import { getWindow } from 'ssr-window';

let browser;

function calcBrowser() {
  const window = getWindow();
  let needPerspectiveFix = false;
  function isSafari() {
    const ua = window.navigator.userAgent.toLowerCase();
    return ua.indexOf('safari') >= 0 && ua.indexOf('chrome') < 0 && ua.indexOf('android') < 0;
  }
  if (isSafari()) {
    const ua = String(window.navigator.userAgent);
    if (ua.includes('Version/')) {
      const [major, minor] = ua
        .split('Version/')[1]
        .split(' ')[0]
        .split('.')
        .map((num) => Number(num));
      needPerspectiveFix = major < 16 || (major === 16 && minor < 2);
    }
  }
  return {
    isSafari: needPerspectiveFix || isSafari(),
    needPerspectiveFix,
    isWebView: /(iPhone|iPod|iPad).*AppleWebKit(?!.*Safari)/i.test(window.navigator.userAgent),
  };
}

function getBrowser() {
  if (!browser) {
    browser = calcBrowser();
  }
  return browser;
}

export { getBrowser };
