/*<![CDATA[*/
// Function to set the theme
function webTheme(theme) {
   // Remove all existing theme-related classes from the body
   document.body.classList.remove('lgt', 'drk', 'sym');
   document.body.classList.add(theme);
   // Save the theme to localStorage
   localStorage.setItem('themeChoice', theme);
}

// Light Mode
function modeL() {
   webTheme('lgt');
   // Save the theme choice
   localStorage.setItem('themeChoice', 'light');
}

// Dark Mode
function modeD() {
   webTheme('drk');
   // Save the theme choice
   localStorage.setItem('themeChoice', 'dark');
}

// System Default Mode
function modeS() {
   // Check for system's color scheme preference when the button is clicked
   const prefersDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;

   if (prefersDarkMode) {
      webTheme('drk'); // Apply dark mode
      document.body.classList.add('sym')
   } else {
      webTheme('lgt'); // Apply light mode
      document.body.classList.add('sym')
   }
   // Save the theme choice
   localStorage.setItem('themeChoice', 'sym');
}

// Function to load user's theme preference
function loadUserThemePreference() {
   const savedTheme = localStorage.getItem('themeChoice');

   if (savedTheme === 'light') {
      modeL();
   } else if (savedTheme === 'dark') {
      modeD();
   } else {
      modeS(); // Automatically set the system default mode
   }
}

// Load user preferences when the page loads
window.onload = loadUserThemePreference;
/*]]>*/