/*<![CDATA[*/
// Check for internet connection
function isOnline() {
   return window.navigator.onLine;
}
// Function to show or hide the "no internet" widget
function toggleNoInternetWidget() {
   const noInternetWidget = document.getElementById("noInternet");

   if (!isOnline()) {
      // If there's no internet connection, show the widget
      noInternetWidget.classList.add("visible");
   } else {
      // If there's an internet connection, hide the widget
      noInternetWidget.classList.remove("visible");
   }
}
// Check the internet connection status when the page loads
window.addEventListener("load", toggleNoInternetWidget);
// Check the internet connection status whenever it changes
window.addEventListener("online", toggleNoInternetWidget);
window.addEventListener("offline", toggleNoInternetWidget);
/*]]>*/