/*<![CDATA[*/
const contextMenu = document.getElementById("contextMenu");

// Show the context menu
window.addEventListener("contextmenu", (e) => {
   e.preventDefault(); // Prevent the default browser context menu
   contextMenu.style.display = "block";
   contextMenu.style.left = `${e.pageX}px`;
   contextMenu.style.top = `${e.pageY}px`;
});

// Hide the context menu when clicking outside of it
document.addEventListener("click", () => {
   contextMenu.style.display = "none";
});

const copyItem = document.getElementById("copy");
const pasteItem = document.getElementById("paste");
const shareItem = document.getElementById("share");
const moreItem = document.getElementById("more");

copyItem.addEventListener("click", () => {
   // Implement the copy action here
   console.log("Copy action clicked");
});

pasteItem.addEventListener("click", () => {
   // Implement the paste action here
   console.log("Paste action clicked");
});

shareItem.addEventListener("click", () => {
   // Implement the share action here
   console.log("Share action clicked");
});

moreItem.addEventListener("click", () => {
   // Implement the more action here
   console.log("More action clicked");
});
/*]]>*/