UE.plugins["dragdrop"] = function() {
  var me = this;
  me.ready(function() {
    domUtils.on(this.body, "dragend", function() {
      var rng = me.selection.getRange();
      var node = rng.getClosedNode() || me.selection.getStart();

      if (node && node.tagName == "IMG") {
        var pre = node.previousSibling,
          next;
        while ((next = node.nextSibling)) {
          if (
            next.nodeType == 1 &&
            next.tagName == "SPAN" &&
            !next.firstChild
          ) {
            domUtils.remove(next);
          } else {
            break;
          }
        }

        if (
          ((pre && pre.nodeType == 1 && !domUtils.isEmptyBlock(pre)) || !pre) &&
          (!next || (next && !domUtils.isEmptyBlock(next)))
        ) {
          if (pre && pre.tagName == "P" && !domUtils.isEmptyBlock(pre)) {
            pre.appendChild(node);
            domUtils.moveChild(next, pre);
            domUtils.remove(next);
          } else if (
            next &&
            next.tagName == "P" &&
            !domUtils.isEmptyBlock(next)
          ) {
            next.insertBefore(node, next.firstChild);
          }

          if (pre && pre.tagName == "P" && domUtils.isEmptyBlock(pre)) {
            domUtils.remove(pre);
          }
          if (next && next.tagName == "P" && domUtils.isEmptyBlock(next)) {
            domUtils.remove(next);
          }
          rng.selectNode(node).select();
          me.fireEvent("saveScene");
        }
      }
    });
  });
  me.addListener("keyup", function(type, evt) {
    var keyCode = evt.keyCode || evt.which;
    if (keyCode == 13) {
      var rng = me.selection.getRange(),
        node;
      if (
        (node = domUtils.findParentByTagName(rng.startContainer, "p", true))
      ) {
        if (domUtils.getComputedStyle(node, "text-align") == "center") {
          domUtils.removeStyle(node, "text-align");
        }
      }
    }
  });
};
