---
title: 'The Intuitive Web Framework'
description: 'Build your next Vue.js application with confidence using Nuxt. An open source framework under MIT license that makes web development simple and powerful.'
showcasesListId: 505
---

::home-hero
---
primaryButtonText: 'Get started'
primaryButtonLink: '/docs/getting-started/introduction'
secondaryButtonText: 'Open on Github'
secondaryButtonLink: 'https://github.com/nuxt/framework'
---

#title
The Intuitive Web Framework

#titleAnimationWord
today.

#description
Build your next Vue.js application with confidence using Nuxt. An open source framework under MIT license that makes web development simple and powerful.
::


::home-section{visible}
#title
Deliver an optimized [User Experience]{.text-transparent .bg-clip-text .bg-gradient-to-r .from-green-400 .to-teal-400}
#description
How a user interacts with and experiences your website will determine your impact. Utility, ease of use, and efficiency are key. **Nuxt is built with a set of features that make this possible.**
#extra
  ::home-card-list
    :::home-card-item
    ---
    image:
      light: 'ux-fast-light.svg'
      dark: 'ux-fast.svg'
    ---
    #title
    Fast and Furious
    #description
    Optimized with code-splitting, tree-shaking, optimized cold-start, link prefetching, payload extraction, just to name a few. Fast by default so you can focus on building.
    :::
    :::home-card-item
    ---
    image:
      light: 'ux-hybrid-light.svg'
      dark: 'ux-hybrid.svg'
    ---
    #title
    On-demand Rendering
    #description
    Decide what rendering strategy at the route level: SSR, SSG, CSR, ISR, ESR, SWR.
    Build any kind of website or web application with optimized performance in mind.
    :::
    :::home-card-item
    ---
    image:
      light: 'ux-seo-light.svg'
      dark: 'ux-seo.svg'
    ---
    #title
    SEO & Web Vitals
    #description
    By leveraging server-side rendering, ESM format and optimized images, Nuxt websites are indexable by search engines while giving the feeling of an app to the end-users. 
    :::
  ::
::

::home-section
---
to: "/showcase"
titleSizeClass: 'text-2xl font-semibold md:text-3xl lg:text-4xl'
---
#title
Trusted by world-class companies
#description
Explore our selection of websites & applications made with Nuxt. F-500 companies, creative agencies and freelancers all trust us.
#link
Discover our showcase
#extra
:::home-companies-carousel
:::
::

::home-section
#title
Discover a new [Developer Experience]{.text-transparent .bg-clip-text .bg-gradient-to-r .from-green-400 .to-teal-400}
#description
Developers deserve solutions as well designed as non-technical people. Our focus is to empower Vue developers to ship great softwares with confidence.
#extra
  ::home-dx-section
  ---
  buttonLink: "/docs/getting-started/installation"
  ---
    ::home-card-list
      :::home-card-item
      ---
      image:
        light: 'dx-plug-and-play-light.svg'
        dark: 'dx-plug-and-play.svg'
      ---
      #title
      Plug & Play
      #description
      Unlock features by creating folders and files with the [most intuitive directory structure]{.font-semibold} made for developers and teams.
      :::
      :::home-card-item
      ---
      image:
        light: 'dx-effortless-light.svg'
        dark: dx-effortless.svg
      ---
      #title
      Automation
      #description
      Repetitive tasks are [automated]{.font-semibold}: auto-imports, code-splitting, typings, minification, bundling for production. and more.
      :::
      :::home-card-item
      ---
      image:
        light: 'dx-batteries-light.svg'
        dark: 'dx-batteries.svg'
      ---
      #title
      Batteries Included
      #description
      Data fetching, state management, meta tags helpers, route guards, cookies, error handling, bundle analyzer and more.
      :::
    ::
  ::
::

::home-section
---
titleSizeClass: 'text-2xl font-semibold md:text-3xl lg:text-4xl'
---
#title
Trusted by the world wide web
#description
Their opinions are valuable and worth sharing to everyone.
#extra
  :::home-testimonials-list
  #items
    ::::home-testimonials-item
    ---
    authorImg: evan
    authorUrl: 'https://twitter.com/youyuxi'
    ---
    #author
    Evan You
    #job
    Creator of VueJS
    #quote
    Nuxt offers a compelling solution and a great ecosystem to help you ship fullstack Vue apps that are performant and SEO friendly. The flexibility to choose between SSR and SSG is icing on the cake.
    ::::

    ::::home-testimonials-item
    ---
    authorImg: sarah
    authorUrl: 'https://twitter.com/sarah_edo'
    ---
    #author
    Sarah Drasner
    #job
    Core Team of Vue.js
    #quote
    Nuxt has outstanding developer productivity, experience, and performance right out of the gate!
    There’s so much attention to detail, ensuring teams have everything at their fingertips to productively build all manners of applications.
    ::::

    ::::home-testimonials-item
    ---
    authorImg: addy
    authorUrl: 'https://twitter.com/addyosmani'
    ---
    #author
    Addy Osmani
    #job
    Chief Engineer of Chrome
    #quote
    Nuxt is a fantastic choice for teams building a production-grade product on the web. It aims to bake in performance best-practices while maintaining excellent Vue.js DX.
    ::::
  :::
::

::home-section
#title
Ship faster with [Nuxt modules]{.text-transparent .bg-clip-text .bg-gradient-to-r .from-green-400 .to-teal-400}
#description
Nuxt is made with a robust plugin system. Integrate with popular CMS or UI librairies with one line of code. With more than 15M monthly downloads and 1K contributors, Nuxt modules are you day to day companions.
#link
Explore Nuxt modules
#extra
  ::home-modules-list
  ::
::

::home-section
#title
A community of [Web builders]{.text-transparent .bg-clip-text .bg-gradient-to-r .from-green-400 .to-teal-300}
#description
Nuxt is composed of web builders all over the world who like to craft beautiful user experiences with Vue.js.
#extra
  ::home-card-list
  ---
  gridClass: 'lg:grid-cols-4'
  ---
    :::home-card-item
    ---
    icon: 'fa-brands:npm'
    to: 'https://www.npmjs.com/package/nuxt'
    ---
    #title
    56M
    #description
    npm downloads
    :::
    :::home-card-item
    ---
    icon: 'fa-brands:discord'
    to: 'https://discord.com/invite/ps2h6QT'
    ---
    #title
    20k
    #description
    Discord members
    :::
    :::home-card-item
    ---
    icon: 'fa-brands:github'
    to: 'https://github.com/nuxt'
    ---
    #title
    55k
    #description
    GitHub stars
    :::
    :::home-card-item
    ---
    icon: 'fa-brands:twitter'
    to: 'https://twitter.com/nuxt_js'
    ---
    #title
    76k
    #description
    Twitter followers
    :::
  ::
::

::home-section
#title
A solution to cover [all your needs]{.text-transparent .bg-clip-text .bg-gradient-to-r .from-green-400 .to-teal-400}
#description
Developers deserve solutions as well designed as non-technical people. Our focus is to empower Vue developers to ship great softwares with confidence.
#extra
::home-needs-section
---
buttonLink: "/support/solutions"
---
#cards
:::home-card-list
  :::home-card-item
  ---
  headerClass: 'justify-start px-4 pt-4 sm:px-6'
  image:
    light: 'needs-official-agency-light.svg'
    dark: 'needs-official-agency.svg'
  imageHeight: '58'
  imageWidth: '52'
  contentClass: 'gap-y-2'
  to: '/support/agencies'
  ---
  #title
  Official agency partners
  #description
  A careful network of trusted agencies from all over the world!
  :::
  :::home-card-item
  ---
  headerClass: 'justify-start px-4 pt-4 sm:px-6'
  image:
    light: 'needs-nuxt-expert-light.svg'
    dark: 'needs-nuxt-expert.svg'
  imageHeight: '58'
  imageWidth: '52'
  contentClass: 'gap-y-2'
  to: '/support/solutions'
  ---
  #title
  Nuxt experts network
  #description
  A network of freelance from all over the world, certified by the NuxtLabs team !
  :::
  :::home-card-item
  ---
  headerClass: 'justify-start px-4 pt-4 sm:px-6'
  contentClass: 'gap-y-2'
  image:
    light: 'needs-community-support-light.svg'
    dark: 'needs-community-support.svg'
  imageHeight: '58'
  imageWidth: '52'
  to: '/support/solutions'
  ---
  #title
  Community support
  #description
  More than 2000 active contributors on multiple platforms are here to help !
  :::
:::
::
::

::home-journey-section
#content
  :::home-section
  ---
  buttons:
  - label: 'Get started'
    size: 'xl'
    variant: 'primary-gradient'
    to: '/docs/getting-started/introduction'
  - label: 'Explore Examples'
    size: 'xl'
    variant: 'secondary'
    to: '/docs/examples/essentials/hello-world'
  ---
  #sectionTitle
  GETTING STARTED
  #title
  Start your Nuxt Journey
  #description
  Learn everything you need to know, from beginner to master.
  :::
::
