---
navigation.icon: uil:info-circle
titleTemplate: '%s'
description: Nuxt's goal is to make web development intuitive and performant with a great DX in mind.
---

# Introduction

Nuxt is an open-source framework under MIT license for building modern and performant web applications that can be deployed on any platform running JavaScript.

## What is Nuxt?

To understand what Nuxt is, we need to understand what we need to create a modern application:

::list{type=success}
- A JavaScript framework to bring reactivity and web components, we chose [Vue.js](https://v3.vuejs.org).
- A bundler to support hot module replacement in development and bundle your code for production, we support both [webpack 5](https://webpack.js.org/) and [Vite](https://vitejs.dev/).
- A transpiler to write the latest JavaScript syntax while supporting legacy browsers, we use [esbuild](https://esbuild.github.io) for that.
- A server for serving your application in development, but also to support [server-side rendering](https://vuejs.org/api/ssr.html#server-side-rendering-api) or API routes, Nuxt uses [h3](https://github.com/unjs/h3) for deployment versatility such as serverless, workers, Node.js and unmatched performance.
- A routing library to handle client-side navigation, we chose [vue-router](https://router.vuejs.org/).
::

This is only the tip of the iceberg, imagine having to set up all of this for your project, make it work, and then, maintain it over time. We have been doing this since October 2016, tuning all the configurations to provide the best optimization and performance for any Vue application.

Nuxt takes care of this and provides both frontend and backend functionality so you can focus on what matters: **creating your web application**.

### View engine

Nuxt uses Vue.js as a view engine. All Vue 3 capabilities are available in Nuxt. You can read about the details of the Vue integration with Nuxt in the [Key Concepts section](/docs/guide/concepts/vuejs-development).

### Automation and conventions

Nuxt uses conventions and an opinionated directory structure to automate repetitive tasks and allow developers to focus on what matters. The configuration file can still customize and override its default behaviors.

::list{type=success}
- Auto-imports
- File-system routing and API layer
- Data-fetching utilities
- Zero-config TypeScript support
- Configured build tools
::

::alert{type="info"}
Discover more in the [Key concepts section](/docs/guide/concepts/auto-imports).
::

### Rendering modes

Nuxt offers different rendering modes to accommodate various use-cases:

::list{type=success}
- Universal rendering (Server-side rendering and hydration)
- Client-side only rendering
- Full Static site generation
- Hybrid rendering (per-routes caching strategy)
::

::alert{type="info"}
Read more about [Nuxt rendering modes](/docs/guide/concepts/rendering).
::

### Server engine

The Nuxt server engine [Nitro](https://nitro.unjs.io) unlocks new full-stack capabilities.

In development, it uses Rollup and Node.js workers for your server code and context isolation. It also generates your server API by reading files in `server/api/` and server middleware from `server/middleware/`.

In production, Nitro builds your app and server into one universal `.output` directory. This output is light: minified and removed from any Node.js modules (except polyfills). You can deploy this output on any system supporting JavaScript, from Node.js, Serverless, Workers, Edge-side rendering or purely static.

::alert{type="info"}
Read more about [Nuxt server engine](/docs/guide/concepts/server-engine).
::

### Production-ready

A Nuxt application can be deployed on a Node or Deno server, pre-rendered to be hosted in static environments, or deployed to serverless and edge providers.

::alert{type="info"}
Discover more in the [deployment section](/docs/getting-started/deployment).
::

### Modular

A module system allows to extend Nuxt with custom features and integrations with third-party services.

::alert{type="info"}
Discover more about [modules](/docs/guide/concepts/modules).
::

### Architecture

Nuxt is composed of different [core packages](https://github.com/nuxt/framework/tree/main/packages):

::list{type=info}
- Core Engine: [nuxt](https://github.com/nuxt/framework/tree/main/packages/nuxt)
- Bundlers: [@nuxt/vite-builder](https://github.com/nuxt/framework/tree/main/packages/vite) and [@nuxt/webpack-builder](https://github.com/nuxt/framework/tree/main/packages/webpack)
- Command line interface: [nuxi](https://github.com/nuxt/framework/tree/main/packages/nuxi)
- Server engine: [nitro](https://github.com/unjs/nitro)
- Development kit: [@nuxt/kit](https://github.com/nuxt/framework/tree/main/packages/kit)
- Nuxt 2 Bridge: [@nuxt/bridge](https://github.com/nuxt/bridge)
::

We recommend reading each concept to have a full vision of Nuxt capabilities and the scope of each package.

## Are you Nuxt?

Nuxt is the backbone of your Vue.js project, giving structure to build your project with confidence while keeping flexibility.

Extendable with a strong module ecosystem and hooks engine, it makes it easy to connect your REST or GraphQL endpoints, favorite CMS, CSS frameworks and more. PWA and AMP support is only a module away from your Nuxt project.

::alert{type=info icon=👍}
Ready to try? Head over to the [Installation section](/docs/getting-started/installation).
::

### Contribute

Do you want to get involved in the evolution of Nuxt? [Follow the contribution guide 👉](/docs/community/contribution)
