---
navigation.icon: uil:rocket
description: Deploy on a Node.js server, pre-render for static hosting and to serverless or edge environments.
---

# Deployment

A Nuxt application can be deployed on a Node.js server, pre-rendered for static hosting, or deployed to serverless or edge (CDN) environments.

::alert{type=info}
If you are looking for a list of cloud providers that support Nuxt 3, see the [list below](#supported-hosting-providers).
::

## Node.js Server

Discover the Node.js server preset with Nitro to deploy on any Node hosting.

::list{type="success"}
- **Default output format** if none is specified or auto-detected <br>
- Loads only the required chunks to render the request for optimal cold start timing <br>
- Useful for deploying Nuxt apps to any Node.js hosting
::

### Entry Point

When running `nuxt build` with the Node server preset, the result will be an entry point that launches a ready-to-run Node server.

```bash
node .output/server/index.mjs
```

### Example

```bash
$ node .output/server/index.mjs
Listening on http://localhost:3000
```

### Configuring Defaults at Runtime

This preset will respect the following runtime environment variables:

- `NITRO_PORT` or `PORT` (defaults to `3000`)
- `NITRO_HOST` or `HOST` (defaults to `'0.0.0.0'`)
- `NITRO_SSL_CERT` and `NITRO_SSL_KEY` - if both are present, this will launch the server in HTTPS mode. In the vast majority of cases, this should not be used other than for testing, and the Nitro server should be run behind a reverse proxy like nginx or Cloudflare which terminates SSL.

#### Using PM2

To use `pm2`, use an `ecosystem.config.js`:

```js [ecosystem.config.js]
module.exports = {
  apps: [
    {
      name: 'NuxtAppName',
      exec_mode: 'cluster',
      instances: 'max',
      script: './.output/server/index.mjs'
    }
  ]
}
```

#### Using Cluster Mode

You can use `NITRO_PRESET=node_cluster` in order to leverage multi-process performance using Node.js [cluster](https://nodejs.org/dist/latest/docs/api/cluster.html) module.

By default, the workload gets distributed to the workers with the round robin strategy.

### Learn More

:ReadMore{link="https://nitro.unjs.io/deploy/node" title="the Nitro documentation for node-server preset"}

## Static Hosting

There are two ways to deploy a Nuxt application to any static hosting services:

- Static site generation (SSG) pre-renders routes of your application at build time.
- Using `ssr: false` to produce a pure client-side output.

### Crawl-based Pre-rendering

Use the [`nuxi generate` command](/docs/api/commands/generate) to build your application. For every page, Nuxt uses a crawler to generate a corresponding HTML and payload files. The built files will be generated in the `.output/public` directory.

```bash
npx nuxi generate
```

### Manual Pre-rendering

You can manually specify routes that [Nitro](/docs/guide/concepts/server-engine) will fetch and pre-render during the build.

```ts [nuxt.config.ts|js]
defineNuxtConfig({
  nitro: {
    prerender: {
      routes: ['/user/1', '/user/2']
    }
  }
})
```

### Client-side Only Rendering

If you don't want to pre-render your routes, another way of using static hosting is to set the `ssr` property to `false` in the `nuxt.config` file. The `nuxi generate` command will then output an `.output/public/index.html` entrypoint and JavaScript bundles like a classic client-side Vue.js application.

```ts [nuxt.config.ts|js]
defineNuxtConfig({
  ssr: false
})
```

## Presets

In addition to Node.js servers and static hosting services, a Nuxt 3 project can be deployed with several well-tested presets and minimal amount of configuration.

You can explicitly set the desired preset in the [`nuxt.config`](/docs/guide/directory-structure/nuxt.config) file:

```js [nuxt.config.js|ts]
export default {
  nitro: {
    preset: 'node-server'
  }
}
```

... or use the `NITRO_PRESET` environment variable when running `nuxt build`:

```bash
NITRO_PRESET=node-server nuxt build
```

🔎 Check [the Nitro deployment](https://nitro.unjs.io/deploy) for all possible deployment presets and providers.

### Supported Hosting Providers

Nuxt 3 can be deployed to several cloud providers with a minimal amount of configuration:

- :icon{name="logos:aws" class="h-5 w-4 inline mb-2"} [AWS](https://nitro.unjs.io/deploy/providers/aws)
- :icon{name="logos:microsoft-azure" class="h-5 w-4 inline mb-2"} [Azure](https://nitro.unjs.io/deploy/providers/azure)
- :icon{name="ph:cloud-duotone" class="h-5 w-4 inline mb-2"} [Cleavr](https://nitro.unjs.io/deploy/providers/cleavr)
- :icon{name="logos:cloudflare" class="h-5 w-4 inline mb-2"} [CloudFlare](https://nitro.unjs.io/deploy/providers/cloudflare)
- :icon{name="logos:digital-ocean" class="h-5 w-4 inline mb-2"} [Digital Ocean](https://nitro.unjs.io/deploy/providers/digitalocean)
- :icon{name="logos:firebase" class="h-5 w-4 inline mb-2"} [Firebase](https://nitro.unjs.io/deploy/providers/firebase)
- :icon{name="logos:heroku-icon" class="h-5 w-4 inline mb-2"} [heroku](https://nitro.unjs.io/deploy/providers/heroku)
- :icon{name="ph:cloud-duotone" class="h-5 w-4 inline mb-2"} [layer0](https://nitro.unjs.io/deploy/providers/layer0)
- :icon{name="logos:netlify" class="h-5 w-4 inline mb-2"} [Netlify](https://nitro.unjs.io/deploy/providers/netlify)
- :icon{name="simple-icons:render" class="h-5 w-4 inline mb-2"} [Render](https://nitro.unjs.io/deploy/providers/render)
- :icon{name="ph:cloud-duotone" class="h-5 w-4 inline mb-2"} [Stormkit](https://nitro.unjs.io/deploy/providers/stormkit)
- :icon{name="logos:vercel-icon" class="h-5 w-4 inline mb-2"} [Vercel](https://nitro.unjs.io/deploy/providers/vercel)
