---
navigation.icon: uil:arrow-up
description: Have a Nuxt 2 project to migrate? Use these guides to upgrade your applications to Nuxt 3.
---
# Upgrade Guide

Have a Nuxt 2 project to migrate? Use these guides to upgrade your Nuxt applications to Nuxt 3 or take the first step in that direction with Nuxt Bridge.

If you are already using Nuxt 3 and want to upgrade to the latest release or test new features before their release, head over to the [Upgrading Nuxt 3](#upgrading-nuxt-3) section.

## Feature Comparison

In the table below, there is a quick comparison between 3 versions of Nuxt:

Feature / Version        | Nuxt 2          | Nuxt Bridge      | Nuxt 3
-------------------------|-----------------|------------------|---------
Vue                      | 2               | 2                | 3
Stability                | 😊 Stable      | 😌 Semi-stable    | Release candidate
Performance              | 🏎 Fast        | ✈️ Faster          | 🚀 Fastest
Nitro Engine             | ❌             | ✅                | ✅
ESM support              | 🌙 Partial     | 👍 Better         | ✅
TypeScript               | ☑️ Opt-in       | 🚧 Partial        | ✅
Composition API          | ❌             | 🚧 Partial        | ✅
Options API              | ✅             | ✅                | ✅
Components Auto Import   | ✅             | ✅                | ✅
`<script setup>` syntax  | ❌             | 🚧 Partial        | ✅
Auto Imports             | ❌             | ✅                | ✅
webpack                  | 4              | 4                 | 5
Vite                     | ⚠️ Partial      | 🚧 Partial        | ✅
Nuxi CLI                 | ❌ Old         | ✅ nuxi           | ✅ nuxi
Static sites             | ✅             | ✅                | ✅

## Nuxt 2 to Nuxt 3

The migration guide provides a step-by-step comparison of Nuxt 2 features to Nuxt 3 features and guidance to adapt your current application.

::alert{type=info icon=👉}
[**Migrate from From Nuxt 2 to Nuxt 3**](/migration/overview)
::

## Nuxt 2 to Nuxt Bridge

If you prefer to progressively migrate your Nuxt 2 application to Nuxt 3, you can use Nuxt Bridge. Nuxt Bridge is a compatibility layer that allows you to use Nuxt 3 features in Nuxt 2 with an opt-in mechanism.

::alert{type=info icon=👉}
[**Migrate from Nuxt 2 to Nuxt Bridge**](/bridge/overview)
::

## Upgrading Nuxt 3

### Latest release

To upgrade Nuxt 3 to the [latest release](/docs/community/changelog), use the `nuxi upgrade` command.

```bash
npx nuxi upgrade
```

### Edge release channel

::alert{type=info icon=👉}
To use the latest Nuxt 3 build and test features before their release, read the [edge release channel](/docs/guide/going-further/edge-channel) guide.
::
