---
navigation.icon: uil:play-circle
---

# Installation

Get started with Nuxt quickly with our online starters or start locally with your terminal.

## Play Online

You can start playing with Nuxt 3 in your browser using our online sandboxes:

:button-link[Play on StackBlitz]{href="https://stackblitz.com/github/nuxt/starter/tree/v3-stackblitz" blank .mr-2}
:button-link[Play on CodeSandbox]{href="https://codesandbox.io/s/github/nuxt/starter/tree/v3-codesandbox" blank}

## Prerequisites

Before getting started, please make sure you have installed the recommended setup.

* **Node.js**<sup>*</sup> (latest LTS version) 👉 [[Download](https://nodejs.org/en/download/)]
* **Visual Studio Code** 👉 [[Download](https://code.visualstudio.com/)]
* **Volar Extension** 👉 [[Download](https://marketplace.visualstudio.com/items?itemName=Vue.volar)]
  * Either enable [**Take Over Mode**](https://vuejs.org/guide/typescript/overview.html#volar-takeover-mode) (recommended)
  * ... or add **TypeScript Vue Plugin (Volar)** 👉 [[Download](https://marketplace.visualstudio.com/items?itemName=Vue.vscode-typescript-vue-plugin)]

<sup>*</sup> If you already have Node.js installed, check with `node --version` above 16.11.

::alert{type=info}

If you have enabled **Take Over Mode** or installed the **TypeScript Vue Plugin (Volar)**, you can disable generating the shim for `*.vue` files in your `nuxt.config` file:

```js
export default defineNuxtConfig({
  typescript: {
    shim: false
  }
})
```

::

## New Project

Open a terminal (if you're using [Visual Studio Code](https://code.visualstudio.com/), you can open an [integrated terminal](https://code.visualstudio.com/docs/editor/integrated-terminal)) and use the following command to create a new starter project:

::code-group

```bash [npx]
npx nuxi init nuxt-app
```

```bash [pnpm]
pnpm dlx nuxi init nuxt-app
```

::

Open `nuxt-app` folder in Visual Studio Code:

```bash
code nuxt-app
```

Install the dependencies:

::code-group

```bash [yarn]
yarn install
```

```bash [npm]
npm install
```

```bash [pnpm]
pnpm install
```

::

::alert
**Note:** If using **pnpm**, make sure to have `.npmrc` with `shamefully-hoist=true` inside it before `pnpm install`.
::

## Development Server

Now you'll be able to start your Nuxt app in development mode:

::code-group

```bash [yarn]
yarn dev -o
```

```bash [npm]
npm run dev -- -o
```

```bash [pnpm]
pnpm run dev -o
```

::

::alert{type=success icon=✨ .font-bold}
Well done! A browser window should automatically open for <http://localhost:3000>.
::

## Next Steps

Now that you've created your Nuxt 3 project, you are ready to start building your application.

* Learn about the framework [concepts](/docs/guide/concepts/auto-imports)
