---
description: "Nuxt provides a module system to extend the framework core and simplify integrations."
---

# Modules

Nuxt provides a module system to extend the framework core and simplify integrations. You don't need to develop everything from scratch or maintain boilerplate if there is already a Nuxt module for it. Adding Nuxt modules is possible using [`nuxt.config`](/docs/api/configuration/nuxt-config#modules).

## Exploring Nuxt Modules

When developing production-grade applications with Nuxt you might find that the framework's core functionality is not enough. Nuxt can be extended with configuration options and plugins, but maintaining these customizations across multiple projects can be tedious, repetitive and time-consuming. On the other hand, supporting every project's needs out of the box would make Nuxt very complex and hard to use.

This is one of the reasons why Nuxt provides a module system that makes it possible to extend the core. Nuxt modules are async functions that sequentially run when starting Nuxt in development mode using `nuxi dev` or building a project for production with `nuxi build`. They can override templates, configure webpack loaders, add CSS libraries, and perform many other useful tasks.

Best of all, Nuxt modules can be distributed in npm packages. This makes it possible for them to be reused across projects and shared with the community, helping create an ecosystem of high-quality add-ons.

::ReadMore{link="/modules" title="Nuxt 3 Compatible Modules"}
::

## The `modules` Property

Once you have installed the modules you can then add them to your `nuxt.config.ts` file under the `modules` property. Modules developers usually provide additional steps and details for usage.

```ts{}[nuxt.config.ts]
export default defineNuxtConfig({
  modules: [
    // Using package name (recommended usage)
    '@nuxtjs/example',

    // Load a local module
    './modules/example',

    // Add module with inline-options
    ['./modules/example', { token: '123' }]

    // Inline module definition
    async (inlineOptions, nuxt) => { }
  ]
})
```

::alert{type="warning" icon=⚠️}
Nuxt modules are now build-time-only, and the `buildModules` property used in Nuxt 2 is deprecated in favor of `modules`.
::

## Module Development

Everyone has the opportunity to develop modules. Read more about developing modules in the [Module Author Guide](/docs/guide/going-further/modules).

::ReadMore{link="/guide/going-further/modules" title="Module Author Guide"}
::
