---
navigation.icon: IconDirectory
title: 'content'
head.title: Content
description: The Content module reads the content/ directory to create a file-based CMS for your application.
---

# Content Directory

The [Nuxt Content module](https://content.nuxtjs.org) reads the `content/` directory in your project and parses `.md`, `.yml`, `.csv` and `.json` files to create a file-based CMS for your application.

::list{type=success}

- Render your content with built-in components.
- Query your content with a MongoDB-like API.
- Use your Vue components in Markdown files with the MDC syntax.
- Automatically generate your navigation.

::

## Get Started

### Installation

Install the `@nuxt/content` module in your project:

::code-group

  ```bash [yarn]
  yarn add --dev @nuxt/content
  ```

  ```bash [npm]
  npm install --save-dev @nuxt/content
  ```

  ```bash [pnpm]
  pnpm add -D @nuxt/content
  ```

::

Then, add `@nuxt/content` to the `modules` section of `nuxt.config.ts`:

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  modules: [
    '@nuxt/content'
  ],
  content: {
    // https://content.nuxtjs.org/api/configuration
  }
})
```

### Create Content

Place your markdown files inside the `content/` directory in the root directory of your project:

```md [content/index.md]
# Hello Content
```

The module automatically loads and parses them.

### Render Pages

To render content pages, add a [catch-all route](/docs/guide/directory-structure/pages/#catch-all-route) using the `ContentDoc` component:

```vue [pages/[...slug].vue]
<template>
  <main>
    <ContentDoc />
  </main>
</template>
```

## Documentation

::alert{type=info}
Head over to <https://content.nuxtjs.org> to learn more about the Content module features, such as how to build queries and use Vue components in your Markdown files with the MDC syntax.
::
