---
navigation.icon: IconFile
title: .nuxtignore
head.title: Nuxt Ignore File
description: The .nuxtignore file lets Nuxt ignore files in your project’s root directory during the build phase.
---

# Nuxt Ignore File

The `.nuxtignore` file lets Nuxt ignore `layout`, `pages`, `components`, `composables` and `middleware` files in your project’s root directory (`rootDir`) during the build phase. The `.nuxtignore` file is subject to the same specification as `.gitignore` and `.eslintignore` files, in which each line is a glob pattern indicating which files should be ignored.

**Note**: You can also configure [`ignoreOptions`](/docs/guide/directory-structure/nuxt.config#ignoreoptions), [`ignorePrefix`](/docs/guide/directory-structure/nuxt.config#ignoreprefix) and [`ignore`](/docs/guide/directory-structure/nuxt.config#ignore) in your `nuxt.config` file.

## Example

```bash [.nuxtignore]
# ignore layout foo.vue
layouts/foo.vue
# ignore layout files whose name ends with -ignore.vue
layouts/*-ignore.vue

# ignore page bar.vue
pages/bar.vue
# ignore page inside ignore folder
pages/ignore/*.vue

# ignore route middleware files under foo folder except foo/bar.js
middleware/foo/*.js
!middleware/foo/bar.js
```

> More details about the spec are in the [gitignore doc](https://git-scm.com/docs/gitignore).
