---
navigation.icon: IconFile
title: app.config.ts
head.title: Nuxt App Config
description: Nuxt 3 provides the app.config file to expose reactive configuration within your application.
---

# App Config File

Nuxt 3 provides an `app.config` config file to expose reactive configuration within your application with the ability to update it at runtime within lifecycle or using a nuxt plugin and editing it with HMR (hot-module-replacement).

You can easily provide runtime app configuration using `app.config.ts` file. It can have either of `.ts`, `.js`, or `.mjs` extensions.

```ts [app.config.ts]
export default defineAppConfig({
  foo: 'bar'
})
```

::alert{type=warning}
Do not put any secret values inside `app.config` file. It is exposed to the user client bundle.
::

## Defining App Config

To expose config and environment variables to the rest of your app, you will need to define configuration in `app.config` file.

**Example:**

```ts [app.config.ts]
export default defineAppConfig({
  theme: {
    primaryColor: '#ababab'
  }
})
```

When adding `theme` to the `app.config`, Nuxt uses Vite or webpack to bundle the code. We can universally access `theme` in both server and browser using [useAppConfig](/docs/api/composables/use-app-config) composable.

```js
const appConfig = useAppConfig()

console.log(appConfig.theme)
```

<!-- TODO: Document module author for extension -->

### Manually Typing App Config

Nuxt tries to automatically generate a typescript interface from provided app config.

It is also possible to type app config manually:

```ts [index.d.ts]
declare module '@nuxt/schema' {
  interface AppConfigInput {
    /** Theme configuration */
    theme?: {
      /** Primary app color */
      primaryColor?: string
    }
  }
}

// It is always important to ensure you import/export something when augmenting a type
export {}
```
