---
navigation.icon: IconFile
title: "app.vue"
description: "The app.vue file is the main component in your Nuxt 3 applications."
head.title: "App File"
---

# App file

The `app.vue` file is the main component in your Nuxt 3 applications.

## Minimal usage

With Nuxt 3, the [`pages/`](/docs/guide/directory-structure/pages) directory is optional. If not present, Nuxt won't include [vue-router](https://router.vuejs.org/) dependency. This is useful when working on a landing page or an application that does not need routing.

```vue [app.vue]
<template>
  <h1>Hello World!</h1>
</template>
```

## Usage With Pages

If you have a [`pages/`](/docs/guide/directory-structure/pages) directory, to display the current page, use the `<NuxtPage>` component:

```vue [app.vue]
<template>
  <div>
    <NuxtLayout>
      <NuxtPage/>
    </NuxtLayout>
  </div>
</template>
```

::alert{type=danger}
Since Nuxt 3 uses [`<Suspense>`](https://vuejs.org/guide/built-ins/suspense.html#suspense) inside `<NuxtPage>`, it cannot be set as a root element.
::

::alert{type=warning}
Remember that `app.vue` acts as the main component of your Nuxt application. Anything you add to it (JS and CSS) will be global and included in every page.
::

If you want to have the possibility to customize the structure around the page between pages, check out the [`layouts/`](/docs/guide/directory-structure/layouts) directory.
