---
navigation.icon: IconFile
title: "nuxt.config.ts"
description: "Nuxt can be easily configured with a single nuxt.config file."
head.title: "Nuxt Configuration File"
---

# Nuxt Config File

Nuxt can be easily configured with a single `nuxt.config` file, which can have either a `.js`, `.ts` or `.mjs` extension.

```ts
export default defineNuxtConfig({
  // My Nuxt config
})
```


::alert
`defineNuxtConfig` helper is globally available without import.
::

You can explicitly import `defineNuxtConfig` from `nuxt/config` if you prefer:

```js
import { defineNuxtConfig } from 'nuxt/config'

export default defineNuxtConfig({
  // My Nuxt config
})
```

To ensure your configuration is up to date, Nuxt will make a full restart when detecting changes in the main configuration file, the `.env`, `.nuxtignore` and `.nuxtrc` dotfiles.

::ReadMore{link="/docs/api/configuration/nuxt-config"}
::
