---
title: "Edge Channel"
description: "Edge channel allows to use latest commits from the repository."
---

# Edge Release Channel

Nuxt 3 is landing commits, improvements, and bug fixes every day. You can opt-in to test them earlier before the next release.

After each commit is merged into the `main` branch of [nuxt/framework](https://github.com/nuxt/framework) and **passing all tests**, we trigger an automated npm release using GitHub Actions publishing Nuxt 3 packages.

You can opt in to use this release channel and avoid waiting for the next release and helping Nuxt by beta testing changes.

The build and publishing method and quality of edge releases are the same as stable ones. The only difference is that you should often check the GitHub repository for updates. There is a slight chance of regressions not being caught during the review process and by the automated tests. Therefore, we internally use this channel to double-check everything before each release.

:::Alert
Features only available on the edge channel are marked with an alert in the documentation.
:::

## Opting Into the Edge Channel

Update `nuxt` dependency inside `package.json`:

```diff [package.json]
{
  "devDependencies": {
--    "nuxt": "^3.0.0-rc.1"
++    "nuxt": "npm:nuxt3@latest"
  }
}
```

Remove lockfile (`package-lock.json`, `yarn.lock`, or `pnpm-lock.yaml`) and reinstall dependencies.

## Opting Out From the Edge Channel

Update `nuxt` dependency inside `package.json`:

```diff [package.json]
{
  "devDependencies": {
--    "nuxt": "npm:nuxt3@latest"
++    "nuxt": "^3.0.0-rc.1"
  }
}
```

Remove lockfile (`package-lock.json`, `yarn.lock`, or `pnpm-lock.yaml`) and reinstall dependencies.

## Using Latest `nuxi` CLI From Edge

:::Alert
All cli dependencies are bundled because of the building method for reducing `nuxi` package size. You can get dependency updates and CLI improvements using the edge channel.
:::

You can use `npx nuxi-edge@latest [command]` to try the latest version of the nuxi CLI.
