---
title: "NuxtApp"
description: "In Nuxt 3, you can access runtime app context within composables, components and plugins."
---

# NuxtApp

In Nuxt 3, you can access runtime app context within composables, components and plugins. In Nuxt 2, this was referred to as [Nuxt context](https://nuxtjs.org/docs/internals-glossary/context#the-context).

## Accessing NuxtApp

Within composables, plugins and components you can access `nuxtApp` with `useNuxtApp`:

```js
function useMyComposable () {
  const nuxtApp = useNuxtApp()
  // access runtime nuxt app instance
}
```

Plugins also receive `nuxtApp` as the first argument for convenience. [Read more about plugins.](/docs/guide/directory-structure/plugins)

::alert{icon=👉}
**`useNuxtApp` (on the server) only works during `setup`, inside Nuxt plugins or `Lifecycle Hooks`**.
::

## Providing Helpers

You can provide helpers to be usable across all composables and application. This usually happens within a Nuxt plugin.

```js
const nuxtApp = useNuxtApp()
nuxtApp.provide('hello', (name) => `Hello ${name}!`)

console.log(nuxtApp.$hello('name')) // Prints "Hello name!"
```

In Nuxt 2 plugins, this was referred to as [inject function](https://nuxtjs.org/docs/directory-structure/plugins#inject-in-root--context).

::alert{icon=👉}
It is possible to inject helpers by returning an object with a `provide` key. See the [plugins documentation](/docs/guide/directory-structure/plugins) for more information.
::
