---
description: The <ClientOnly> component renders its slot only in client-side.
---
# `<ClientOnly>`

The `<ClientOnly>` component renders its slot only in client-side. To import a component only on the client, register the component in a client-side only plugin.

## Props

- **placeholderTag** | **fallbackTag**: specify a tag to be rendered server-side.
- **placeholder** | **fallback**: specify a content to be rendered server-side.

```vue
<template>
  <div>
    <Sidebar />
    <ClientOnly fallback-tag="span" fallback="Loading comments...">
      <Comment />
    </ClientOnly>
  </div>
</template>
```

## Slots

- **#fallback**: specify a content to be displayed server-side.

```vue
<template>
  <div>
    <Sidebar />
    <ClientOnly>
      <!-- ... -->
      <template #fallback>
        <!-- this will be rendered on server side -->
        <p>Loading comments...</p>
      </template>
    </ClientOnly>
  </div>
</template>
```
