---
title: "<NuxtPage>"
description: The NuxtPage component is required to display pages located in the pages/ directory.
---

# `<NuxtPage>`

`<NuxtPage>` is a built-in component that comes with Nuxt. `NuxtPage` is required to display top-level or nested pages located in the `pages/` directory.

`NuxtPage` is a wrapper around [`<RouterView>`](https://router.vuejs.org/api/#router-view-props) component from Vue Router. `NuxtPage` component accepts same `name` and `route` props.

- **name:** type: `string`

`name` helps `RouterView` render the component with the corresponding name in the matched route record's components option.

- **route:** type: `RouteLocationNormalized`

`route` is a route location that has all of its components resolved.

> **Nuxt automatically resolves the `name` and `route` by scanning and rendering all Vue component files found in the `/pages` directory.**

Apart from the `name` and `route`, `NuxtPage` component also accepts `pageKey` props.

- **pageKey:** type: `string` or `function`

`pageKey` helps control when the `NuxtPage` component is re-rendered.

## Example

For example, passing `static` key, `NuxtPage` component is rendered only once when it is mounted.

```html
<!-- static key -->
<NuxtPage page-key="static" />
```

Alternatively, `pageKey` can be passed as a `key` value via `definePageMeta` from the `<script>` section of your Vue component in the `/pages` directory.

```js
<script setup>
definePageMeta({
  key: route => route.fullPath
})
</script>
```

:button-link[Open on StackBlitz]{href="https://stackblitz.com/github/nuxt/framework/tree/main/examples/routing/pages?file=app.vue" blank}

## Custom Props

In addition, `NuxtPage` also accepts custom props that you may need to pass further down the hierarchy. These custom props are accessible via `attrs` in the Nuxt app.

```html
<NuxtPage :foobar="123" />
```

For example, in above example, value of `foobar` will be available using `attrs.foobar`.

::ReadMore{link="/guide/directory-structure/app"}
::
