---
title: "<NuxtLayout>"
---

# `<NuxtLayout>`

You can use `<NuxtLayout />` component to activate `default` layout on `app.vue` or `error.vue`.

```vue [/app.vue]
<template>
  <NuxtLayout>
    some page content
  </NuxtLayout>
</template>
```

`<NuxtLayout />` can be used to override `default` layout on `app.vue`, `error.vue` or even page components found in the `/pages` directory.

## `name` prop

`<NuxtLayout />` component accepts the `name` prop, which you can pass to use a non-default layout, where `name` can be a static string, reactive reference or a computed property. It **must** match the name of the corresponding layout file in the `/layouts` directory.

### Examples

```vue [pages/index.vue]
<template>
  <NuxtLayout :name="layout">
    <NuxtPage />
  </NuxtLayout>
</template>

<script setup>
// layouts/custom.vue
const layout = 'custom'
</script>
```

::alert{icon=👉}
Please note the layout name is normalized to kebab-case, so if your layout file is named `errorLayout.vue`, it will become `error-layout` when passed as a `name` property to `<NuxtLayout />`.
::

```vue [/error.vue]
<template>
  <NuxtLayout name="error-layout">
    <NuxtPage />
  </NuxtLayout>
</template>
```

## Layout and Transition

`<NuxtLayout />` renders incoming content via `<slot />`, which is then wrapped around Vue’s `<Transition />` component to activate layout transition. For this to work as expected, it is recommended that `<NuxtLayout />` is **not** the root element of the page component.

```vue [pages/index.vue]
<template>
  <div>
    <NuxtLayout name="custom">
      <template #header> Some header template content. </template>
    </NuxtLayout>
  </div>
</template>
```

::ReadMore{link="/guide/directory-structure/layouts"}
::
