# `<NuxtLoadingIndicator>`

The `<NuxtLoadingIndicator>` component displays a progress bar on page navigation.

## Examples

### Basic Usage

Add `<NuxtLoadingIndicator/>` in your `app.vue` or layouts.

```vue [app.vue]
<template>
  <NuxtLayout>
    <NuxtLoadingIndicator /> <!-- here -->
    <NuxtPage />
  </NuxtLayout>
</template>
```

:button-link[Open on StackBlitz]{href="https://stackblitz.com/github/nuxt/framework/tree/main/examples/routing/pages?terminal=dev&file=/app.vue" blank}

::alert{type=warning}
If you are changing layouts as well as page, the page transition you set here will not run. Instead, you should set a layout transition.
::

## Slots

You can pass custom HTML or components through the loading indicator's default slot.

## Props

- **color**: The color of the loading bar.
- **height**: Height of the loading bar, in pixels (default `3`).
- **duration**: Duration of the loading bar, in milliseconds (default `2000`).
- **throttle**: Throttle the appearing and hiding, in milliseconds (default `200`).

::alert{type=info icon=🔎}
This component is completely optional. To achieve full customization, you can implement your own one based on [this file](https://github.com/nuxt/framework/blob/main/packages/nuxt/src/app/components/nuxt-loading-indicator.ts).
::
