---
title: "<NuxtErrorBoundary>"
description: The <NuxtErrorBoundary> component handles client-side errors happening in its default slot.
---

# `<NuxtErrorBoundary>`

The `<NuxtErrorBoundary>` component handles client-side errors happening in its default slot, using Vue's [`onErrorCaptured` hook.](https://vuejs.org/api/composition-api-lifecycle.html#onerrorcaptured)

## Events

- **`@error`**: Event emitted when the default slot of the component throws an error.

  ```vue
  <template>
    <NuxtErrorBoundary @error="logSomeError">
      <!-- ... -->
    </NuxtErrorBoundary>
  </template>
  ```

## Slots

- **#error**: Specify a fallback content to display in case of error.

  ```vue
    <template>
      <NuxtErrorBoundary>
        <!-- ... -->
        <template #error="{ error }">
          <p>An error occurred: {{ error }}</p>
        </template>
      </NuxtErrorBoundary>
    </template>
  ```

::ReadMore{link="/docs/getting-started/error-handling"}
::
