---
title: "Lifecycle Hooks"
description: Nuxt provides a powerful hooking system to expand almost every aspect using hooks.
---

# Lifecycle Hooks

:ReadMore{link="/guide/going-further/hooks"}

# App Hooks (runtime)

Check the [app source code](https://github.com/nuxt/framework/blob/main/packages/nuxt/src/app/nuxt.ts#L24) for all available hooks.

Hook                   | Arguments           | Environment     | Description
-----------------------|---------------------|-----------------|-------------
`app:created`          | `vueApp`            | Server & Client | Called when initial `vueApp` instance is created.
`app:error`            | `err`               | Server & Client | Called when a fatal error occurs.
`app:error:cleared`    | `{ redirect? }`     | Server & Client | Called when a fatal error occurs.
`app:data:refresh`     | `keys?`             | Server & Client | (internal)
`vue:setup`            | -                   | Server & Client | (internal)
`vue:error`            | `err, target, info` | Server & Client | Called when a vue error propages to the root component. [Learn More](https://vuejs.org/api/composition-api-lifecycle.html#onerrorcaptured).
`app:rendered`         | `renderContext`     | Server          | Called when SSR rendering is done.
`app:redirected`       | -                   | Server          | Called before SSR redirection.
`app:beforeMount`      | `vueApp`            | Client          | Called before mounting the app, called only on client side.
`app:mounted`          | `vueApp`            | Client          | Called when Vue app is initialized and mounted in browser.
`app:suspense:resolve` | `appComponent`      | Client          | On [Suspense](https://vuejs.org/guide/built-ins/suspense.html#suspense) resolved event.
`link:prefetch`        | `to`                | Client          | Called when a `<NuxtLink>` is observed to be prefetched.
`page:start`           | `pageComponent?`    | Client          | Called on [Suspense](https://vuejs.org/guide/built-ins/suspense.html#suspense) pending event.
`page:finish`          | `pageComponent?`    | Client          | Called on [Suspense](https://vuejs.org/guide/built-ins/suspense.html#suspense) resolved event.
`page:transition:finish`| `pageComponent?`    | Client          | After page transition [onAfterLeave](https://vuejs.org/guide/built-ins/transition.html#javascript-hooks) event.

# Nuxt Hooks (build time)

Check the [schema source code](https://github.com/nuxt/framework/blob/main/packages/schema/src/types/hooks.ts#L53) for all available hooks.

:NeedContribution

# Nitro App Hooks (runtime, server-side)

Hook                   | Arguments             | Description                          | Types
-----------------------|-----------------------|--------------------------------------|------------------
`render:response`      | `response, { event }` | Called before sending the response.  | [response](https://github.com/nuxt/framework/blob/71ef8bd3ff207fd51c2ca18d5a8c7140476780c7/packages/nuxt/src/core/runtime/nitro/renderer.ts#L24), [event](https://github.com/unjs/h3/blob/f6ceb5581043dc4d8b6eab91e9be4531e0c30f8e/src/types.ts#L38)
`render:html`          | `html, { event }`     | Called before constructing the HTML. | [html](https://github.com/nuxt/framework/blob/71ef8bd3ff207fd51c2ca18d5a8c7140476780c7/packages/nuxt/src/core/runtime/nitro/renderer.ts#L15), [event](https://github.com/unjs/h3/blob/f6ceb5581043dc4d8b6eab91e9be4531e0c30f8e/src/types.ts#L38)
