---
title: "Kit Utilities"
description: Nuxt Kit provides composable utilities to help interacting with Nuxt Hooks and Nuxt Builder.
---

# Kit Utilities

::ReadMore{link="/guide/going-further/kit"}
::

## Utilities

### Modules

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/module)

- `installModule(module, inlineOptions)`

### Programmatic Usage

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/loader)

- `loadNuxt(loadOptions)`
- `buildNuxt(nuxt)`
- `loadNuxtConfig(loadOptions)`

### Compatibility

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/compatibility.ts)

- `checkNuxtCompatibility(constraints)`
- `assertNuxtCompatibility(constraints)`
- `hasNuxtCompatibility(constraints)`
- `isNuxt2()`
- `isNuxt3()`
- `getNuxtVersion()`

### Auto-imports

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/imports.ts)

- `addImports(imports)`
- `addImportsDir(importDirs)`
- `addImportsSources(importSources)`

### Components

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/components.ts)

- `addComponentsDir(dir)`
- `addComponent(componentObject)`

### Context

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/context.ts)

- `useNuxt()`

### Pages

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/pages.ts)

- `extendPages (callback: pages => void)`

### Plugins

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/plugin.ts)

- `addPlugin(pluginOptions, { append? })`
- `addPluginTemplate(pluginOptions, { append? })`

### Templates

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/template.ts)

- `addTemplate(templateOptions)`
- `updateTemplates({ filter?: ResolvedNuxtTemplate => boolean })`

### Nitro

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/nitro.ts)

- `addServerHandler (handler)`
- `addDevServerHandler (handler)`
- `useNitro()` (only usable after `ready` hook)
- `addServerPlugin`
- `addPrerenderRoutes`

### Resolving

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/resolve.ts)

- `resolvePath (path, resolveOptions?)`
- `resolveAlias (path, aliases?)`
- `findPath (paths, resolveOptions?)`
- `createResolver (base)`

### Logging

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/logger.ts)

- `useLogger(scope?)`

### Builder

[source code](https://github.com/nuxt/framework/blob/main/packages/kit/src/build.ts)

- `extendWebpackConfig(callback, options?)`
- `extendViteConfig(callback, options?)`
- `addWebpackPlugin(webpackPlugin, options?)`
- `addVitePlugin(vitePlugin, options?)`
