---
navigation.icon: octicon:repo-24
description: Some specific points about contributions to the nuxt/framework repository.
---

# nuxt/framework

Once you've read the [general contribution guide](/docs/community/contribution), here are some specific points to make about contributions to the `nuxt/framework` repository.

## Using the Playground

While working on a PR, you will likely want to check if your changes are working correctly.

You can modify the example app in `playground/`, and run it with `yarn dev`. Please make sure not to commit it to your branch, but it could be helpful to add some example code to your PR description. This can help reviewers and other Nuxt users understand the feature you've built in-depth.

## Testing

Every new feature should have a corresponding unit test (if possible). The `test` folder in this repository is currently a work in progress, but do your best to create a new test following the example of what's already there.

Before creating a PR or marking it as ready-to-review, ensure that all tests pass by running `yarn test` locally.

## Linting

You might have noticed already that we use ESLint to enforce a coding standard. Please run `yarn lint` before committing your changes to verify that the code style is correct. If not, you can use `yarn lint --fix` to fix most of the style changes. If there are still errors left, you must correct them manually.

### Documentation

If you are adding a new feature or refactoring or changing the behavior of Nuxt in any other manner, you'll likely want to document the changes. Please include any changes to the docs in the same PR. You don't have to write documentation up on the first commit (but please do so as soon as your pull request is mature enough). Make sure to make changes according to the [Documentation Guide](/docs/community/contribution#writing-documentation).

### Final Checklist

When submitting your PR, there is a simple template that you have to fill out. Please tick all appropriate "answers" in the checklists.

## Documentation Guide

If you spot an area where we can improve documentation or error messages, please do open a PR - even if it's just to fix a typo!

### Quick Edits

If you spot a typo or want to rephrase a sentence, you can click on the **Edit this page on GitHub** link located after the content of every page.

Make the change directly in the GitHub interface and open a Pull Request.

### Longer Edits

The documentation content is inside the `docs/` directory of the [nuxt/framework repository](https://github.com/nuxt/framework) and written in markdown.

To contribute, fork the repository and follow [these steps](#set-up-documentation-website-in-local-environment) and start docs in development mode.

After making your changes:

- Lint the documentation with the `lint:docs` command.
- Open a Pull Request. Please make sure your PR title adheres to the [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/) guidelines.

### Linting Docs

Documentation is linted using [MarkdownLint](https://github.com/DavidAnson/markdownlint/) and [case police](https://github.com/antfu/case-police) to keep the documentation cohesive.

## Set Up Your Local Development Environment

To contribute to Nuxt, you need to set up a local environment.

1. [Fork](https://help.github.com/articles/fork-a-repo/) the [nuxt/framework repository](https://github.com/nuxt/framework) to your own GitHub account and then [clone](https://help.github.com/articles/cloning-a-repository/) it to your local device.

1. Ensure using the latest Node.js (16.x)

1. Enable [Corepack](https://github.com/nodejs/corepack) using `corepack enable` to have `pnpm` and `yarn`

1. Run `pnpm install` to install the dependencies.

    > If you are adding a dependency, please use `pnpm add`. The `pnpm-lock.yaml` file is the source of truth for all Nuxt dependencies.

1. Run `pnpm build:stub` to activate the passive development system

1. Check out a branch where you can work and commit your changes:

```bash
git checkout -b my-new-branch
```

::js-doc{file=packages/nuxt/src/test.js function=useState}
::

::doc-link{file=packages/nuxt/src/test.js function=useState}
::

### Set Up Documentation Website in Local Environment

We are using [Docus](https://nuxtlabs.com/docus) for documentation.

- Run `pnpm build:stub` once in the root directory
- Go into the docs directory: `cd docs`
- Install docs dependencies using `yarn install`
- Run `yarn dev` to start docs in development mode

We recommend to install the [Docus extension](https://marketplace.visualstudio.com/items?itemName=NuxtLabs.docus) for VS Code.
