---
navigation.icon: uil:directions
---

# Roadmap

Nuxt is constantly evolving, with new features and modules being added all the time.

This page lists the current status and schedule of our planned releases.

## 📢 Announcements

- Oct 12, 2021: [Nuxt 3 Beta](https://nuxtjs.org/announcements/nuxt3-beta/)
- April 20, 2022: [Nuxt 3 Release Candidate](https://nuxtjs.org/announcements/nuxt3-rc/)
- May 25, 2022: [Nuxt Content v2 Release](https://content.nuxtjs.org/blog/announcing-v2)

## 📝 Status Reports

- [Documentation Progress](https://github.com/nuxt/framework/issues/4104)
- [Rendering Optimizations: Today and Tomorrow](https://github.com/nuxt/framework/discussions/5856)
- [Nuxt Image: Performance and Status](https://github.com/nuxt/image/discussions/563)

### Current Releases

[Nuxt 3](https://v3.nuxtjs.org) is *stable** and available as the `nuxt` npm tag with `latest` tag.

The latest updates on Nuxt 2.x are available via the `nuxt-edge` npm package and are expected to be released soon for forward compatibility. A minor version is expected during Autumn,  2022 as `nuxt@2.16` with cumulative updates for future compatibility with Bridge.

Release  | npm | Status      | Last Release | Docs |  Repository
---------|----|---------|--------------|------|-----------------
Nuxt 3.x | [`nuxt`](https://npmjs.com/package/nuxt) | Stable        | <a href="https://npmjs.com/package/nuxt"><img src="https://flat.badgen.net/npm/v/nuxt/rc"></a>       | [3.x docs](https://v3.nuxtjs.org/) | [nuxt/framework](https://github.com/nuxt/framework)
Nuxt 3.x (edge*) | [`nuxt3`](https://npmjs.com/package/nuxt3) | Development        | <a href="https://npmjs.com/package/nuxt3"><img src="https://flat.badgen.net/npm/v/nuxt3"></a>       | [3.x docs](https://v3.nuxtjs.org/) | [nuxt/framework](https://github.com/nuxt/framework)
Nuxt 2.x | [`nuxt`](https://npmjs.com/package/nuxt)  | Maintenance | <a href="https://npmjs.com/package/nuxt"><img src="https://flat.badgen.net/npm/v/nuxt"></a>   | [2.x docs](https://nuxtjs.org/docs) | [nuxt/nuxt.js#2.x](https://github.com/nuxt/nuxt.js/tree/2.x)
Nuxt 2.x (edge*) | [`nuxt-edge`](https://npmjs.com/package/nuxt) | Maintenance | <a href="https://npmjs.com/package/nuxt-edge"><img src="https://flat.badgen.net/npm/v/nuxt-edge"></a>      | [2.x docs](https://nuxtjs.org/docs) | [nuxt/nuxt.js](https://github.com/nuxt/nuxt.js)

(*) Edge releases are automated after each commit passing tests

## 🛣️ Roadmap

In roadmap below are the major expected features that are coming soon with Nuxt 3.

💡 Check [Discussions](https://github.com/nuxt/framework/discussions) and [RFCs](https://github.com/nuxt/framework/discussions/categories/rfcs) for more upcoming features and ideas.

Milestone    | Expected date | Notes  | Description
-------------|------------------|--------|-----------------------
Image        | 2022       | [nuxt/image#548](https://github.com/nuxt/image/discussions/548) | Stable image optimization for Nuxt 3
Test Utils   | 2022       | [nuxt/framework#3198](https://github.com/nuxt/framework/issues/3198) | A rewrite of [nuxt/test-utils](https://github.com/nuxt/test-utils) for testing Nuxt 3 and new modules
SEO & PWA    | 2022       | [nuxt/framework#1823](https://github.com/nuxt/framework/discussions/1823) | Migrating from [nuxt-community/pwa-module](https://github.com/nuxt-community/pwa-module) for built-in SEO utils and service worker support
Scripts      | -          | [nuxt/framework#5856](https://github.com/nuxt/framework/discussions/5856)      | Easy 3rd party script management.
DevTools     | -          | - | Integrated and modular devtools experience for Nuxt
Translations | -          | [nuxt/translations#4](https://github.com/nuxt/translations/discussions/4) ([request access](https://github.com/nuxt/framework/discussions/765)) | A collaborative project for a stable translation process for Nuxt 3 docs. Currently pending for ideas and documentation tooling support (content v2 with remote sources).
Auth         | -           | - | A rewrite of [nuxt-community/auth-module](https://github.com/nuxt-community/auth-module) for Nuxt 3 support

## 📦 Core Modules

In addition to the Nuxt framework, there are modules that are vital for the ecosystem. Their status will be updated below.

Module         | Status              | Nuxt Support | Repository | Description
---------------|---------------------|--------------|------------|-------------------
Content        | Active              | 3.x          | [nuxt/content](https://github.com/nuxt/content) | Released
Auth           | Planned             | 3.x          | `nuxt/auth` to be announced | Nuxt 3 support is planned after session support
Image          | Active              | 2.x and 3.x  | [nuxt/image](https://github.com/nuxt/image) | Nuxt 3 support is in progress: [nuxt/image#548](https://github.com/nuxt/image/discussions/548)
Telemetry      | Active              | 2.x and 3.x  | [nuxt/telemetry](https://github.com/nuxt/telemetry/) | Nuxt 3 is supported. Stats to be public soon!
