# Configuration

## `nuxt.config`

The starting point for your Nuxt app remains your `nuxt.config` file.

::alert{icon=📦}
Nuxt configuration will be loaded using [`unjs/jiti`](https://github.com/unjs/jiti) and [`unjs/c12`](https://github.com/unjs/c12).
::

### Migration

1. You should migrate to the new `defineNuxtConfig` function that provides a typed configuration schema.

   ::code-group

   ```ts [Nuxt 2]
   export default {
     // ...
   }
   ```

   ```ts [Nuxt 3]
   export default defineNuxtConfig({
     // ...
   })
   ```

   ::

1. If you were using `router.extendRoutes` you can migrate to the new `pages:extend` hook:

   ::code-group

   ```ts [Nuxt 2]
   export default {
     router: {
       extendRoutes (routes) {
         //
       }
     }
   }
   ```

   ```ts [Nuxt 3]
   export default defineNuxtConfig({
     hooks: {
       'pages:extend' (routes) {
         //
       }
     }
   })
   ```

   ::

#### ESM Syntax

Nuxt 3 is an [ESM native framework](/docs/guide/going-further/esm). Although [`unjs/jiti`](https://github.com/unjs/jiti) provides semi compatibility when loading `nuxt.config` file, avoid any usage of `require` and `module.exports` in this file.

1. Change `module.exports` to `export default`
1. Change `const lib = require('lib')` to `import lib from 'lib'`

#### Async Configuration

In order to make Nuxt loading behavior more predictable, async config syntax is deprecated. Consider using Nuxt hooks for async operations.

#### Dotenv

Nuxt has built-in support for loading `.env` files. Avoid directly importing it from `nuxt.config`.

## Modules

Nuxt and Nuxt Modules are now build-time-only.

### Migration

1. Move all your `buildModules` into `modules`.
2. Check for Nuxt 3 compatibility of modules.

::alert
If you are a module author, you can check out [more information about module compatibility](/migration/module-authors) and [our module author guide](/docs/guide/going-further/modules).
::

## TypeScript

It will be much easier to migrate your application if you use Nuxt's TypeScript integration. This does not mean you need to write your application in TypeScript, just that Nuxt will provide automatic type hints for your editor.

You can read more about Nuxt's TypeScript support [in the docs](/docs/guide/concepts/typescript).

::alert{icon=📦}
Nuxt can type-check your app using [`vue-tsc`](https://github.com/johnsoncodehk/volar/tree/master/vue-language-tools/vue-tsc) with `nuxi typecheck` command.
::

### Migration

1. Create a `tsconfig.json` with the following content:

   ```json
   {
     "extends": "./.nuxt/tsconfig.json"
   }
   ```

1. Run `npx nuxi prepare` to generate `.nuxt/tsconfig.json`.
1. Install Volar following the instructions in the [docs](/docs/getting-started/introduction#prerequisites).

## Vue Changes

There are a number of changes to what is recommended Vue best practice, as well as a number of breaking changes between Vue 2 and 3.

It is recommended to read the [Vue 3 migration guide](https://v3-migration.vuejs.org/) and in particular the [breaking changes list](https://v3-migration.vuejs.org/breaking-changes/).

It is not currently possible to use the Vue 3 migration build with Nuxt 3 RC.

## Vuex

Nuxt no longer provides a Vuex integration. Instead, the official Vue recommendation is to use `pinia`, which has built-in Nuxt support via a [Nuxt module](https://pinia.vuejs.org/ssr/nuxt.html). [Find out more about pinia here](https://pinia.vuejs.org/).

If you want to keep using Vuex, you can manually migrate to Vuex 4 following [these steps](https://vuex.vuejs.org/guide/migrating-to-4-0-from-3-x.html).
