# Runtime Config

If you wish to reference environment variables within your Nuxt 3 app, you will need to use runtime config.

When referencing these variables within your components, you will have to use the `useRuntimeConfig` composable in your setup method (or Nuxt plugin).

In the `server/` portion of your app, you can use `useRuntimeConfig` without any import.

[Read more about runtime config](/docs/guide/going-further/runtime-config).

## Migration

1. Add any environment variables that you use in your app to the `runtimeConfig` property of the `nuxt.config` file.
1. Migrate `process.env` to `useRuntimeConfig` throughout the Vue part of your app.

## Example

::code-group

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  runtimeConfig: {
    // Private config that is only available on the server
    apiSecret: '123',
    // Config within public will be also exposed to the client
    public: {
      apiBase: '/api'
    }
  },
})
```

```vue [pages/index.vue]
<script setup>
  const config = useRuntimeConfig()

  // instead of process.env you will now access config.public.apiBase
  console.log(config.public.apiBase)
</script>
```

```ts [server/api/hello.ts]
const config = useRuntimeConfig()

export default (req, res) => {
  // In server, you can now access config.apiSecret, in addition to config.public
  console.log(config.apiSecret)
  console.log(config.public.apiBase)
}
```

```ini [.env]
# Runtime config values are automatically replaced by matching environment variables at runtime
NUXT_API_SECRET=api_secret_token
NUXT_PUBLIC_API_BASE=https://nuxtjs.org
```

::
