---
title: Design Kit
description: Welcome to Nuxt design definition page. Identity was redefined by handpicking conscientiously colors, typography and shapes in order to put forward how performant, useful & easy Nuxt products are.
---

::resources-design-kit-hero
#title
Design Kit
#description
Welcome to Nuxt design definition page. Identity was redefined by handpicking conscientiously colors, typography and shapes in order to put forward how performant, useful & easy Nuxt products are.
#buttonText
Download design kit
::

::resources-design-kit-section
---
sectionClass: 'pb-8 pt-16'
highlight: false
---
#category
Logotype
#title
Nuxt Logo
#description
The logo is made from two elements: the triangular mountains and the wordmark. In most cases, they should appear together as the opposite master lockup shows. The triangular mountains can be used on their own as an icon, profile picture or badge, but the wordmark should never be used without this symbol on the side.
#titleExtra
Icon
#designList
  ::resources-design-kit-logo-card
  ---
  imgName: icon-green
  cardClass: 'bg-white'
  infoType: 'primary'
  ---
  #info
  Primary
  #name
  Icon green
  ::

  ::resources-design-kit-logo-card
  ---
  imgName: icon-black
  cardClass: 'bg-white'
  info-type: 'secondary'
  ---
  #info
  Secondary
  #name
  Icon black
  ::

  ::resources-design-kit-logo-card
  ---
  imgName: icon-white
  cardClass: 'bg-gray-900'
  info-type: 'secondary-dark'
  ---
  #info
  Secondary
  #name
  Icon white
  ::

::

::resources-design-kit-section
---
sectionClass: 'pb-16 pt-8'
highlight: false
---
#titleExtra
Logo
#designList
  ::resources-design-kit-logo-card
  ---
  imgName: full-logo-green-dark
  cardClass: 'bg-white'
  infoType: 'primary'
  full: true
  ---
  #info
  Primary
  #name
  Logo green & dark
  ::

  ::resources-design-kit-logo-card
  ---
  imgName: full-logo-green-light
  cardClass: 'bg-gray-900'
  infoType: 'primary-dark'
  full: true
  ---
  #info
  Primary
  #name
  Logo green & light
  ::

  ::resources-design-kit-logo-card
  ---
  imgName: full-logo-black
  cardClass: 'bg-white'
  info-type: 'secondary'
  full: true
  ---
  #info
  Secondary
  #name
  Logo monochrome black
  ::

  ::resources-design-kit-logo-card
  ---
  imgName: full-logo-white
  cardClass: bg-gray-900
  full: true
  info-type: 'secondary-dark'
  ---
  #info
  Secondary
  #name
  Logo monochrome white
  ::
::

::resources-design-kit-section
---
highlight: false
---
#category
Colors
#title
Color Palette
#description
Our color palette is based on our iconic NuxtJS green and colours have been carefully considered to work in harmony and consistency across various media. When creating Nuxt communications, use the colour values shown to make sure your designs stay on-brand.
#designList
  ::resources-design-kit-color-card
  ---
  cardClass: 'bg-green-400'
  hexaColor: '#00DC82'
  ---
  #color
  Green
  #buttonText
  copy
  ::

  ::resources-design-kit-color-card
  ---
  cardClass: 'bg-white border dark:border-none'
  hexaColor: '#FFFFFF'
  ---
  #color
  White
  #buttonText
  copy
  ::

  ::resources-design-kit-color-card
  ---
  cardClass: 'bg-gray-900'
  hexaColor: '#18181B'
  ---
  #color
  Gray
  #buttonText
  copy
  ::
::

::resources-design-kit-section
---
sectionClass: 'pt-16 pb-8'
highlight: false
---
#category
Typography
#title
Roobert font
#description
Our brand typeface is Roobert PRO by the Display Foundry. This typeface was chosen for it’s aesthetic reminding the shape of Nuxt logo by many aspects (joints, apex, vertex of the structure). It provides modernity and sobriety while giving an iconic aspect of our visual content and without decreasing the accessibility of texts.<br /><br />
Font is also variable which allows us to fit with any contexts.
#typography
[Roobert PRO]{ .text-5xl }
<br /><br />
[The quick brown fox jumps over the lazy dog.]{ .text-4xl }
::

::resources-design-kit-section
---
highlight: false
---
#category
Typography
#title
Usage
#description
For Nuxt brand, we will only use Regular / Medium / Semibold / Bold weights 99% of the time. You should avoid Light & Heavy if you want to use it as Nuxt Identity. Only exceptions are for super, subscript characters, also you can use heavy if you go upper than 72px for a font size.
As Roobert font is licensed, you cannot use it for free so you can use the [Inter font](https://fonts.google.com/specimen/Inter){.font-semibold .text-green-400} as an alternative. If you want to have visuals with Roobert official font, contact us we will give you the asset ready.
::
