---
title: Announcing 3.0
description: 'We are thrilled to announce the first stable version of Nuxt 3.0.0'
navigation: false
---

::blog-article
---
authors: 
  - name: Pooya Parsa
    avatarUrl: https://github.com/pi0.png
    link: https://twitter.com/_pi0_
date: "Nov 16, 2022"
---
#title
# Announcing Nuxt 3.0 stable
#description
We are thrilled to announce the first stable version of Nuxt 3.0.0 :sparkles:
#body

Nuxt 3 is a modern rewrite of the Nuxt framework based on [Vite](https://vitejs.dev/), [Vue3](https://vuejs.org/), and [Nitro](https://nitro.unjs.io/) with first-class Typescript support and the result of more than two years of research, community feedback, innovation, and experiment to make a pleasant full-stack Developer Experience for Vue development to everyone.

 [[Read More In the Documentation]](/docs)

## API Stability

Nuxt 3.0.0 comes with a stable, production-ready API and 50+ [supported modules](.com/modules) built using [Nuxt Kit](/docs/guide/going-further/modules) by the community and Nuxt team.

All composables, filesystem conventions, and configurations are guaranteed to be backward compatible with Nuxt 3.0.0. Due to the nature of the meta-frameworks, some changes happen when we upgrade the underlying dependencies (vite, rollup, and nitropack). Thanks to the new Nuxt Kit and Schema tools, such upgrades will be backward compatible as long as you are using documented features. Kit and Schema also guarantee better future compatibility. This makes it faster for us to iterate and plan the next major versions of Nuxt.

## The browser and Node.js support

Nuxt 3 officially supports evergreen browsers only. The "core browser set" is what we (And [web.dev](http://web.dev) team) believe most developers need to support most of the time in the absence of specific constraints. It takes into account [usage numbers](https://caniuse.com/usage-table), developer expectations, and [existing support in](https://make.wordpress.org/core/handbook/best-practices/browser-support/) [the ecosystem](https://angular.io/guide/browser-support). The core browser set targets the **2 most recent major versions** of Chrome, Firefox, and Edge on a monthly basis and Safari on a yearly basis.

On the server side, Nuxt 3 supports Node.js 14, 16, 18, and 19 at the moment. We encourage everyone to use the latest LTS releases of Node.js, we push them once **widely adopted by major deployment platforms**. This means we keep supporting Node.js versions as long as they are supported by the Node.js team on a rolling basis in non-major releases of Nuxt. Since 14.x is being end-of-life soon, we highly encourage you to update to the latest 18.x whenever possible.

## We Love Community

Nuxt wouldn’t be possible today without an amazing community making amazing modules, feedback, and contributions every day. Check our [Community Documentation](https://nuxt.com/docs/community/getting-help) to be involved!

## To the Future

Releasing Nuxt 3 is a big milestone for us and opens a future-proof basis for new ideas and trust for the users to build their enterprise projects with Nuxt 3. 

Server Component Islands, Websocket layer, new Deployment presets, improved CLI and Devtools and Testing infra are a few to mention. Keep an eye on the [roadmap page](https://nuxt.com/docs/community/roadmap) and [GitHub discussions](https://github.com/nuxt/framework/discussions) for updates.

NuxtLabs is working on [new product](https://nuxt.studio) and solutions on top of Nuxt 3 at the time of writing this article.

Stay tuned for more exciting news and Happy Nuxting 💚
::
