/* 
 * OpenCage Data Search Control v1.3.1 - 2020-03-17
 * Copyright (c) 2020, OpenCage GmbH 
 * support@opencagedata.com 
 * https://opencagedata.com 
 * 
 * Licensed under the BSD license. 
 * Demo: https://opencagedata.com 
 * Source: git@github.com:opencagedata/leaflet-opencage-search.git 
 */

!function(e){var t;if("function"==typeof define&&define.amd)define(["leaflet"],e);else if("undefined"!=typeof module)t=require("leaflet"),module.exports=e(t);else{if(void 0===window.L)throw"Leaflet must be loaded first";e(window.L)}}(function(r){"use strict";return r.Control.OpenCageSearch=r.Control.extend({options:{showResultIcons:!1,collapsed:!0,expand:"click",position:"topright",placeholder:"Search...",errorMessage:"Nothing found.",key:"",onResultClick:void 0,addResultToMap:!0,limit:5},_callbackId:0,initialize:function(e){r.Util.setOptions(this,e),this.options.geocoder||(this.options.geocoder=new r.Control.OpenCageSearch.Geocoder(this.options))},onAdd:function(e){var t,o="leaflet-control-ocd-search",s=r.DomUtil.create("div",o),n=r.DomUtil.create("div","leaflet-control-ocd-search-icon",s),i=this._form=r.DomUtil.create("form",o+"-form",s);return this._map=e,this._container=s,(t=this._input=r.DomUtil.create("input")).type="text",t.placeholder=this.options.placeholder,r.DomEvent.addListener(t,"keydown",this._keydown,this),this._errorElement=document.createElement("div"),this._errorElement.className=o+"-form-no-error",this._errorElement.innerHTML=this.options.errorMessage,this._alts=r.DomUtil.create("ul",o+"-alternatives leaflet-control-ocd-search-alternatives-minimized"),i.appendChild(t),i.appendChild(this._errorElement),s.appendChild(this._alts),r.DomEvent.addListener(i,"submit",this._geocode,this),this.options.collapsed?"click"===this.options.expand?r.DomEvent.addListener(n,"click",function(e){0===e.button&&2!==e.detail&&this._toggle()},this):(r.DomEvent.addListener(n,"mouseover",this._expand,this),r.DomEvent.addListener(n,"mouseout",this._collapse,this),this._map.on("movestart",this._collapse,this)):this._expand(),r.DomEvent.disableClickPropagation(s),s},_geocodeResult:function(e){if(r.DomUtil.removeClass(this._container,"leaflet-control-ocd-search-spinner"),1===e.length)this._geocodeResultSelected(e[0]);else if(0<e.length){this._alts.innerHTML="",this._results=e,r.DomUtil.removeClass(this._alts,"leaflet-control-ocd-search-alternatives-minimized");for(var t=0;t<e.length;t++)this._alts.appendChild(this._createAlt(e[t],t))}else r.DomUtil.addClass(this._errorElement,"leaflet-control-ocd-search-error")},markGeocode:function(e){return e.bounds?this._map.fitBounds(e.bounds):this._map.panTo(e.center),this._geocodeMarker&&this._map.removeLayer(this._geocodeMarker),this._geocodeMarker=new r.Marker(e.center).bindPopup(e.name).addTo(this._map).openPopup(),this},_geocode:function(e){return r.DomEvent.preventDefault(e),r.DomUtil.addClass(this._container,"leaflet-control-ocd-search-spinner"),this._clearResults(),this.options.geocoder.geocode(this._input.value,this._geocodeResult,this),!1},_geocodeResultSelected:function(e){this.options.collapsed?this._collapse():this._clearResults(),this.options.onResultClick&&"function"==typeof this.options.onResultClick&&this.options.onResultClick(e),this.options.addResultToMap&&this.markGeocode(e)},_toggle:function(){0<=this._container.className.indexOf("leaflet-control-ocd-search-expanded")?this._collapse():this._expand()},_expand:function(){r.DomUtil.addClass(this._container,"leaflet-control-ocd-search-expanded"),this._input.select()},_collapse:function(){this._container.className=this._container.className.replace(" leaflet-control-ocd-search-expanded",""),r.DomUtil.addClass(this._alts,"leaflet-control-ocd-search-alternatives-minimized"),r.DomUtil.removeClass(this._errorElement,"leaflet-control-ocd-search-error")},_clearResults:function(){r.DomUtil.addClass(this._alts,"leaflet-control-ocd-search-alternatives-minimized"),this._selection=null,r.DomUtil.removeClass(this._errorElement,"leaflet-control-ocd-search-error")},_createAlt:function(e,t){var o=document.createElement("li");return o.innerHTML='<a href="#" data-result-index="'+t+'">'+(this.options.showResultIcons&&e.icon?'<img src="'+e.icon+'"/>':"")+e.name+"</a>",r.DomEvent.addListener(o,"click",function(){this._geocodeResultSelected(e)},this),o},_keydown:function(e){function t(e){o._selection&&(r.DomUtil.removeClass(o._selection.firstChild,"leaflet-control-ocd-search-selected"),o._selection=o._selection[0<e?"nextSibling":"previousSibling"]),o._selection||(o._selection=o._alts[0<e?"firstChild":"lastChild"]),o._selection&&r.DomUtil.addClass(o._selection.firstChild,"leaflet-control-ocd-search-selected")}var o=this;switch(e.keyCode){case 38:t(-1),r.DomEvent.preventDefault(e);break;case 40:t(1),r.DomEvent.preventDefault(e);break;case 13:if(this._selection){var s=parseInt(this._selection.firstChild.getAttribute("data-result-index"),10);this._geocodeResultSelected(this._results[s]),this._clearResults(),r.DomEvent.preventDefault(e)}}return!0}}),r.Control.openCageSearch=function(e,t){return new r.Control.OpenCageSearch(e,t)},r.Control.OpenCageSearch.callbackId=0,r.Control.OpenCageSearch.jsonp=function(e,t,o,s,n){var i="_ocd_geocoder_"+r.Control.OpenCageSearch.callbackId++;t[n||"callback"]=i,window[i]=r.Util.bind(o,s);var l=document.createElement("script");l.type="text/javascript",l.src=e+r.Util.getParamString(t),l.id=i,l.addEventListener("error",function(){o({results:[]})}),l.addEventListener("abort",function(){o({results:[]})}),document.getElementsByTagName("head")[0].appendChild(l)},r.Control.OpenCageSearch.Geocoder=r.Class.extend({options:{serviceUrl:"https://api.opencagedata.com/geocode/v1/",geocodingQueryParams:{},reverseQueryParams:{},key:"",limit:5},initialize:function(e){r.Util.setOptions(this,e)},geocode:function(e,s,n){var t={};if(n&&n._map&&n._map.getCenter()){var o=n._map.getCenter();t.proximity=o.lat+","+o.lng}r.Control.OpenCageSearch.jsonp(this.options.serviceUrl+"json/",r.extend({q:e,limit:this.options.limit,key:this.options.key},t,this.options.geocodingQueryParams),function(e){for(var t=[],o=e.results.length-1;0<=o;o--)t[o]={name:e.results[o].formatted,center:r.latLng(e.results[o].geometry.lat,e.results[o].geometry.lng)},e.results[o].bounds&&(t[o].bounds=r.latLngBounds([e.results[o].bounds.southwest.lat,e.results[o].bounds.southwest.lng],[e.results[o].bounds.northeast.lat,e.results[o].bounds.northeast.lng]));s.call(n,t)},this,"jsonp")},reverse:function(e,t,o,s){this.geocode(e,o,s)}}),r.Control.OpenCageSearch.geocoder=function(e){return new r.Control.OpenCageSearch.Geocoder(e)},r.Control.OpenCageSearch});