# Contributing to Pico

Thanks for your interest in contributing to Pico CSS! Please take a moment to review this document before submitting a [bug report](https://github.com/picocss/pico/issues) or a [pull request](https://github.com/picocss/pico/pulls).

## Bug reports

The [issue tracker]((https://github.com/picocss/pico/issues)) is the preferred channel for bug reports, but please respect the following restrictions:
- Please do not use the issue tracker for personal support requests. [Open a question in our discussion forums](https://github.com/picocss/pico/discussions/discussions/new?category=help) instead.
- Please do not use the issue tracker for feature requests. [Suggest any ideas you have using our discussion forums](https://github.com/picocss/pico/discussions/discussions/new?category=ideas) instead.

## Pull requests

Good pull requests, patches, improvements, and new features are a fantastic help.

**Please ask first before starting work on any significant new features.**
We recommend that you first [suggest your feature idea in our discussion forums](https://github.com/picocss/pico/discussions/discussions/new?category=ideas).

[`dev`](https://github.com/picocss/pico/tree/dev) branch is open to pull requests.

**Do not edit [`/css`](https://github.com/picocss/pico/tree/master/css) files directly.** Edit the source files in [`/scss`](https://github.com/picocss/pico/tree/master/scss), then recompile the [`/css`](https://github.com/picocss/pico/tree/master/css) files with `npm run build`.

Do not edit [`/docs/*.html`](https://github.com/picocss/pico/tree/master/docs) files directly. Edit the source files in [`/docs/src`](https://github.com/picocss/pico/tree/master/docs/src), then recompile the docs files with `npm run build`.