/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   gold-cc-cvc-input.html
 */

/// <reference path="../polymer/types/polymer.d.ts" />
/// <reference path="../paper-input/paper-input-behavior.d.ts" />
/// <reference path="../paper-input/paper-input-container.d.ts" />
/// <reference path="../paper-input/paper-input-error.d.ts" />
/// <reference path="../iron-input/iron-input.d.ts" />
/// <reference path="../iron-icon/iron-icon.d.ts" />
/// <reference path="../iron-form-element-behavior/iron-form-element-behavior.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />

/**
 * `gold-cc-cvc-input` is a single-line text field with Material Design styling
 * for entering a credit card's CVC (Card Verification Code). It supports both
 * 4-digit Amex CVCs and non-Amex 3-digit CVCs
 *
 *     <gold-cc-cvc-input></gold-cc-cvc-input>
 *
 *     <gold-cc-cvc-input card-type="amex"></gold-cc-cvc-input>
 *
 * It may include an optional label, which by default is "CVC".
 *
 *     <gold-cc-cvc-input label="Card Verification Value"></gold-cc-cvc-input>
 *
 * It can be used together with a `gold-cc-input` by binding the `cardType` property:
 *
 *     <gold-cc-input card-type="{{cardType}}"></gold-cc-input>
 *     <gold-cc-cvc-input card-type="[[cardType]]"></gold-cc-cvc-input>
 *
 * ### Validation
 *
 * The input considers a valid amex CVC to be 4 digits long, and 3 digits otherwise.
 * The `amex` attribute can also be bound to a `gold-cc-input`'s `card-type` attribute.
 *
 * The input can be automatically validated as the user is typing by using
 * the `auto-validate` and `required` attributes. For manual validation, the
 * element also has a `validate()` method, which returns the validity of the
 * input as well sets any appropriate error messages and styles.
 *
 * See `Polymer.PaperInputBehavior` for more API docs.
 *
 * ### Styling
 *
 * See `Polymer.PaperInputContainer` for a list of custom properties used to
 * style this element.
 *
 * Custom property | Description | Default
 * ----------------|-------------|----------
 * `--gold-cc-cvc-input-icon` | Mixin applied to the icon | `{}`
 */
interface GoldCcCvcInputElement extends Polymer.Element, Polymer.PaperInputBehavior, Polymer.IronFormElementBehavior {

  /**
   * The label for this input.
   */
  label: string|null|undefined;
  value: string|null|undefined;

  /**
   * Returns a reference to the focusable element. Overridden from PaperInputBehavior
   * to correctly focus the native input.
   *         
   */
  readonly _focusableElement: any;

  /**
   * The type of card that the CVC is for.
   */
  cardType: string|null|undefined;
  readonly _requiredLength: number|null|undefined;
  readonly _amex: boolean|null|undefined;
  ready(): void;

  /**
   * Returns true if the element has a valid value, and sets the visual
   * error state.
   *
   * @returns Whether the input is currently valid or not.
   */
  validate(): boolean;
  beforeRegister(): void;
  _onIronInputReady(): void;

  /**
   * A handler that is called on input
   */
  _onValueChanged(value: any, oldValue: any): void;
  _computeRequiredLength(cardType: any): any;
  _computeIsAmex(cardType: any): any;

  /**
   * Overidden from Polymer.IronControlState.
   */
  _onFocusedChanged(focused: any): void;
}

interface HTMLElementTagNameMap {
  "gold-cc-cvc-input": GoldCcCvcInputElement;
}
