/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   gold-phone-input.html
 */

/// <reference path="../polymer/types/polymer.d.ts" />
/// <reference path="../paper-input/paper-input-behavior.d.ts" />
/// <reference path="../paper-input/paper-input-container.d.ts" />
/// <reference path="../paper-input/paper-input-error.d.ts" />
/// <reference path="../paper-styles/typography.d.ts" />
/// <reference path="../iron-input/iron-input.d.ts" />
/// <reference path="../iron-form-element-behavior/iron-form-element-behavior.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />

/**
 * `<gold-phone-input>` is a single-line text field with Material Design styling
 * for entering a phone number.
 *
 *     <gold-phone-input></gold-phone-input>
 *
 * It may include an optional label, which by default is "Phone number".
 *
 *     <gold-phone-input label="call this"></gold-phone-input>
 *
 * ### Validation
 *
 * By default, the phone number is considered to be a US phone number, and
 * will be validated according to the pattern `XXX-XXX-XXXX`, where `X` is a
 * digit, and `-` is the separating dash. If you want to customize the input
 * for a different area code or number pattern, use the `country-code` and
 * `phone-number-pattern` attributes
 *
 *     <gold-phone-input
 *         country-code="33"
 *         phone-number-pattern="X-XX-XX-XX-XX">
 *     </gold-phone-input>
 *
 * The input can be automatically validated as the user is typing by using
 * the `auto-validate` and `required` attributes. For manual validation, the
 * element also has a `validate()` method, which returns the validity of the
 * input as well sets any appropriate error messages and styles.
 *
 * See `Polymer.PaperInputBehavior` for more API docs.
 *
 * ### Styling
 *
 * See `Polymer.PaperInputContainer` for a list of custom properties used to
 * style this element.
 *
 * `--gold-phone-input-country-code` | Mixin applied to the country code span
 */
interface GoldPhoneInputElement extends Polymer.Element, Polymer.PaperInputBehavior, Polymer.IronFormElementBehavior {

  /**
   * The label for this input.
   */
  label: string|null|undefined;
  value: string|null|undefined;

  /**
   * Returns a reference to the focusable element. Overridden from PaperInputBehavior
   * to correctly focus the native input.
   *     
   */
  readonly _focusableElement: any;

  /**
   * The country code that should be recognized and parsed.
   */
  countryCode: string|null|undefined;

  /**
   * The format of a valid phone number, including formatting but excluding
   * the country code. Use 'X' to denote the digits separated by dashes.
   */
  phoneNumberPattern: string|null|undefined;

  /**
   * International format of the input value.
   */
  readonly internationalValue: String|null;
  ready(): void;

  /**
   * Overidden from Polymer.PaperInputBehavior.
   */
  validate(): any;
  beforeRegister(): void;
  _onIronInputReady(): void;
  _onBindValueChanged(): void;
  _phoneNumberPatternChanged(): void;

  /**
   * A handler that is called on input
   */
  _onValueChanged(value: any, oldValue: any): void;

  /**
   * Overidden from Polymer.IronControlState.
   */
  _onFocusedChanged(focused: any): void;

  /**
   * Returns the phone number value prefixed by the country code or simply
   * the value if the country code is not set. When	`value` equals
   * "3-44-55-66-77" and the `countryCode` is "33", the `internationalValue`
   * equals "+(33)3-44-55-66-77"
   */
  _computeInternationalValue(countryCode: any, value: any): any;
}

interface HTMLElementTagNameMap {
  "gold-phone-input": GoldPhoneInputElement;
}
