/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   iron-request.html
 */

/// <reference path="../polymer/types/polymer.d.ts" />

/**
 * iron-request can be used to perform XMLHttpRequests.
 *
 *     <iron-request id="xhr"></iron-request>
 *     ...
 *     this.$.xhr.send({url: url, body: params});
 */
interface IronRequestElement extends Polymer.Element {
  hostAttributes: object|null;

  /**
   * A reference to the XMLHttpRequest instance used to generate the
   * network request.
   */
  readonly xhr: XMLHttpRequest|null;

  /**
   * A reference to the parsed response body, if the `xhr` has completely
   * resolved.
   */
  readonly response: any;

  /**
   * A reference to the status code, if the `xhr` has completely resolved.
   */
  readonly status: number|null|undefined;

  /**
   * A reference to the status text, if the `xhr` has completely resolved.
   */
  readonly statusText: string|null|undefined;

  /**
   * A promise that resolves when the `xhr` response comes back, or rejects
   * if there is an error before the `xhr` completes.
   * The resolve callback is called with the original request as an argument.
   * By default, the reject callback is called with an `Error` as an argument.
   * If `rejectWithRequest` is true, the reject callback is called with an
   * object with two keys: `request`, the original request, and `error`, the
   * error object.
   */
  readonly completes: Promise<any>|null;

  /**
   * An object that contains progress information emitted by the XHR if
   * available.
   */
  readonly progress: object|null|undefined;

  /**
   * Aborted will be true if an abort of the request is attempted.
   */
  readonly aborted: boolean|null|undefined;

  /**
   * Errored will be true if the browser fired an error event from the
   * XHR object (mainly network errors).
   */
  readonly errored: boolean|null|undefined;

  /**
   * TimedOut will be true if the XHR threw a timeout event.
   */
  readonly timedOut: boolean|null|undefined;

  /**
   * Succeeded is true if the request succeeded. The request succeeded if it
   * loaded without error, wasn't aborted, and the status code is ≥ 200, and
   * < 300, or if the status code is 0.
   *
   * The status code 0 is accepted as a success because some schemes - e.g.
   * file:// - don't provide status codes.
   */
  succeeded: object|null;

  /**
   * Sends an HTTP request to the server and returns a promise (see the `completes`
   * property for details).
   *
   * The handling of the `body` parameter will vary based on the Content-Type
   * header. See the docs for iron-ajax's `body` property for details.
   *
   * @param options   - url The url to which the request is sent.
   *   - method The HTTP method to use, default is GET.
   *   - async By default, all requests are sent asynchronously. To send synchronous requests,
   *         set to false.
   *   -  body The content for the request body for POST method.
   *   -  headers HTTP request headers.
   *   -  handleAs The response type. Default is 'text'.
   *   -  withCredentials Whether or not to send credentials on the request. Default is false.
   *   -  timeout - Timeout for request, in milliseconds.
   *   -  rejectWithRequest Set to true to include the request object with promise rejections.
   */
  send(options: {url: string, method?: string, async?: boolean, body?: ArrayBuffer|ArrayBufferView|Blob|Document|FormData|string|object|null, headers?: object|null, handleAs?: string, jsonPrefix?: string, withCredentials?: boolean, timeout?: Number|null, rejectWithRequest?: boolean}): Promise<any>|null;

  /**
   * Attempts to parse the response body of the XHR. If parsing succeeds,
   * the value returned will be deserialized based on the `responseType`
   * set on the XHR.
   *
   * @returns The parsed response,
   * or undefined if there was an empty response or parsing failed.
   */
  parseResponse(): any;

  /**
   * Aborts the request.
   */
  abort(): any;

  /**
   * @param body The given body of the request to try and encode.
   * @param contentType The given content type, to infer an encoding
   *     from.
   * @returns Either the encoded body as a string, if successful,
   *     or the unaltered body object if no encoding could be inferred.
   */
  _encodeBodyObject(body: any, contentType: string|null): any;

  /**
   * @param object The object to encode as x-www-form-urlencoded.
   * @returns .
   */
  _wwwFormUrlEncode(object: object|null): string;

  /**
   * @param str A key or value to encode as x-www-form-urlencoded.
   * @returns .
   */
  _wwwFormUrlEncodePiece(str: any): string;

  /**
   * Updates the status code and status text.
   */
  _updateStatus(): any;
}

interface HTMLElementTagNameMap {
  "iron-request": IronRequestElement;
}
