/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   iron-ajax.html
 */

/// <reference path="../polymer/types/polymer.d.ts" />
/// <reference path="iron-request.d.ts" />

/**
 * The `iron-ajax` element exposes network request functionality.
 *
 *     <iron-ajax
 *         auto
 *         url="https://www.googleapis.com/youtube/v3/search"
 *         params='{"part":"snippet", "q":"polymer", "key": "YOUTUBE_API_KEY", "type": "video"}'
 *         handle-as="json"
 *         on-response="handleResponse"
 *         debounce-duration="300"></iron-ajax>
 *
 * With `auto` set to `true`, the element performs a request whenever
 * its `url`, `params` or `body` properties are changed. Automatically generated
 * requests will be debounced in the case that multiple attributes are changed
 * sequentially.
 *
 * Note: The `params` attribute must be double quoted JSON.
 *
 * You can trigger a request explicitly by calling `generateRequest` on the
 * element.
 */
interface IronAjaxElement extends Polymer.Element {

  /**
   * The URL target of the request.
   */
  url: string|null|undefined;

  /**
   * An object that contains query parameters to be appended to the
   * specified `url` when generating a request. If you wish to set the body
   * content when making a POST request, you should use the `body` property
   * instead.
   */
  params: object|null|undefined;

  /**
   * The HTTP method to use such as 'GET', 'POST', 'PUT', or 'DELETE'.
   * Default is 'GET'.
   */
  method: string|null|undefined;

  /**
   * HTTP request headers to send.
   *
   * Example:
   *
   *     <iron-ajax
   *         auto
   *         url="http://somesite.com"
   *         headers='{"X-Requested-With": "XMLHttpRequest"}'
   *         handle-as="json"></iron-ajax>
   *
   * Note: setting a `Content-Type` header here will override the value
   * specified by the `contentType` property of this element.
   */
  headers: object|null|undefined;

  /**
   * Content type to use when sending data. If the `contentType` property
   * is set and a `Content-Type` header is specified in the `headers`
   * property, the `headers` property value will take precedence.
   *
   * Varies the handling of the `body` param.
   */
  contentType: string|null|undefined;

  /**
   * Body content to send with the request, typically used with "POST"
   * requests.
   *
   * If body is a string it will be sent unmodified.
   *
   * If Content-Type is set to a value listed below, then
   * the body will be encoded accordingly.
   *
   *    * `content-type="application/json"`
   *      * body is encoded like `{"foo":"bar baz","x":1}`
   *    * `content-type="application/x-www-form-urlencoded"`
   *      * body is encoded like `foo=bar+baz&x=1`
   *
   * Otherwise the body will be passed to the browser unmodified, and it
   * will handle any encoding (e.g. for FormData, Blob, ArrayBuffer).
   */
  body: object|null|undefined;

  /**
   * Toggle whether XHR is synchronous or asynchronous. Don't change this
   * to true unless You Know What You Are Doing™.
   */
  sync: boolean|null|undefined;

  /**
   * Specifies what data to store in the `response` property, and
   * to deliver as `event.detail.response` in `response` events.
   *
   * One of:
   *
   *    `text`: uses `XHR.responseText`.
   *
   *    `xml`: uses `XHR.responseXML`.
   *
   *    `json`: uses `XHR.responseText` parsed as JSON.
   *
   *    `arraybuffer`: uses `XHR.response`.
   *
   *    `blob`: uses `XHR.response`.
   *
   *    `document`: uses `XHR.response`.
   */
  handleAs: string|null|undefined;

  /**
   * Set the withCredentials flag on the request.
   */
  withCredentials: boolean|null|undefined;

  /**
   * Set the timeout flag on the request.
   */
  timeout: number|null|undefined;

  /**
   * If true, automatically performs an Ajax request when either `url` or
   * `params` changes.
   */
  auto: boolean|null|undefined;

  /**
   * If true, error messages will automatically be logged to the console.
   */
  verbose: boolean|null|undefined;

  /**
   * The most recent request made by this iron-ajax element.
   */
  readonly lastRequest: object|null|undefined;

  /**
   * The `progress` property of this element's `lastRequest`.
   */
  readonly lastProgress: object|null|undefined;

  /**
   * True while lastRequest is in flight.
   */
  readonly loading: boolean|null|undefined;

  /**
   * lastRequest's response.
   *
   * Note that lastResponse and lastError are set when lastRequest finishes,
   * so if loading is true, then lastResponse and lastError will correspond
   * to the result of the previous request.
   *
   * The type of the response is determined by the value of `handleAs` at
   * the time that the request was generated.
   */
  readonly lastResponse: object|null;

  /**
   * lastRequest's error, if any.
   */
  readonly lastError: object|null;

  /**
   * An Array of all in-flight requests originating from this iron-ajax
   * element.
   */
  readonly activeRequests: any[]|null|undefined;

  /**
   * Length of time in milliseconds to debounce multiple automatically generated requests.
   */
  debounceDuration: number|null|undefined;

  /**
   * Prefix to be stripped from a JSON response before parsing it.
   *
   * In order to prevent an attack using CSRF with Array responses
   * (http://haacked.com/archive/2008/11/20/anatomy-of-a-subtle-json-vulnerability.aspx/)
   * many backends will mitigate this by prefixing all JSON response bodies
   * with a string that would be nonsensical to a JavaScript parser.
   */
  jsonPrefix: string|null|undefined;

  /**
   * By default, iron-ajax's events do not bubble. Setting this attribute will cause its
   * request and response events as well as its iron-ajax-request, -response,  and -error
   * events to bubble to the window object. The vanilla error event never bubbles when
   * using shadow dom even if this.bubbles is true because a scoped flag is not passed with
   * it (first link) and because the shadow dom spec did not used to allow certain events,
   * including events named error, to leak outside of shadow trees (second link).
   * https://www.w3.org/TR/shadow-dom/#scoped-flag
   * https://www.w3.org/TR/2015/WD-shadow-dom-20151215/#events-that-are-not-leaked-into-ancestor-trees
   */
  bubbles: boolean|null|undefined;

  /**
   * Changes the [`completes`](iron-request#property-completes) promise chain
   * from `generateRequest` to reject with an object
   * containing the original request, as well an error message.
   * If false (default), the promise rejects with an error message only.
   */
  rejectWithRequest: boolean|null|undefined;
  _boundHandleResponse: Function|null|undefined;
  hostAttributes: object|null;

  /**
   * The query string that should be appended to the `url`, serialized from
   * the current value of `params`.
   */
  readonly queryString: string;

  /**
   * The `url` with query string (if `params` are specified), suitable for
   * providing to an `iron-request` instance.
   */
  readonly requestUrl: string;

  /**
   * An object that maps header names to header values, first applying the
   * the value of `Content-Type` and then overlaying the headers specified
   * in the `headers` property.
   */
  readonly requestHeaders: object|null;
  created(): void;
  _onProgressChanged(event: any): void;

  /**
   * Request options suitable for generating an `iron-request` instance based
   * on the current state of the `iron-ajax` instance's properties.
   */
  toRequestOptions(): {url: string, method?: string, async?: boolean, body?: ArrayBuffer|ArrayBufferView|Blob|Document|FormData|string|object|null, headers?: object|null, handleAs?: string, jsonPrefix?: string, withCredentials?: boolean};

  /**
   * Performs an AJAX request to the specified URL.
   */
  generateRequest(): IronRequestElement;
  _handleResponse(request: any): void;
  _handleError(request: any, error: any): void;
  _discardRequest(request: any): void;
  _requestOptionsChanged(): void;
}

interface HTMLElementTagNameMap {
  "iron-ajax": IronAjaxElement;
}
