/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   iron-collapse.html
 */

/// <reference path="../polymer/types/polymer.d.ts" />
/// <reference path="../iron-resizable-behavior/iron-resizable-behavior.d.ts" />

/**
 * `iron-collapse` creates a collapsible block of content.  By default, the content
 * will be collapsed.  Use `opened` or `toggle()` to show/hide the content.
 *
 *     <button on-click="toggle">toggle collapse</button>
 *
 *     <iron-collapse id="collapse">
 *       <div>Content goes here...</div>
 *     </iron-collapse>
 *
 *     ...
 *
 *     toggle: function() {
 *       this.$.collapse.toggle();
 *     }
 *
 * `iron-collapse` adjusts the max-height/max-width of the collapsible element to show/hide
 * the content.  So avoid putting padding/margin/border on the collapsible directly,
 * and instead put a div inside and style that.
 *
 *     <style>
 *       .collapse-content {
 *         padding: 15px;
 *         border: 1px solid #dedede;
 *       }
 *     </style>
 *
 *     <iron-collapse>
 *       <div class="collapse-content">
 *         <div>Content goes here...</div>
 *       </div>
 *     </iron-collapse>
 *
 * ### Styling
 *
 * The following custom properties and mixins are available for styling:
 *
 * Custom property | Description | Default
 * ----------------|-------------|----------
 * `--iron-collapse-transition-duration` | Animation transition duration | `300ms`
 */
interface IronCollapseElement extends Polymer.Element, Polymer.IronResizableBehavior {

  /**
   * If true, the orientation is horizontal; otherwise is vertical.
   */
  horizontal: boolean|null|undefined;

  /**
   * Set opened to true to show the collapse element and to false to hide it.
   */
  opened: boolean|null|undefined;

  /**
   * When true, the element is transitioning its opened state. When false,
   * the element has finished opening/closing.
   */
  readonly transitioning: boolean|null|undefined;

  /**
   * Set noAnimation to true to disable animations.
   */
  noAnimation: boolean|null|undefined;
  hostAttributes: object|null;
  readonly dimension: any;

  /**
   * Toggle the opened state.
   */
  toggle(): void;
  show(): void;
  hide(): void;

  /**
   * Updates the size of the element.
   *
   * @param size The new value for `maxWidth`/`maxHeight` as css property value, usually `auto` or `0px`.
   * @param animated if `true` updates the size with an animation, otherwise without.
   */
  updateSize(size: string, animated?: boolean): void;

  /**
   * enableTransition() is deprecated, but left over so it doesn't break existing code.
   * Please use `noAnimation` property instead.
   */
  enableTransition(enabled: any): void;
  _updateTransition(enabled: any): void;
  _horizontalChanged(): void;
  _openedChanged(): void;
  _transitionEnd(): void;
  _onTransitionEnd(event: any): void;
  _calcSize(): any;
}

interface HTMLElementTagNameMap {
  "iron-collapse": IronCollapseElement;
}
