/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   iron-localstorage.html
 */

/// <reference path="../polymer/types/polymer.d.ts" />

/**
 * Element access to Web Storage API (window.localStorage).
 *
 * Keeps `value` property in sync with localStorage.
 *
 * Value is saved as json by default.
 *
 * ### Usage:
 *
 * `ls-sample` will automatically save changes to its value.
 *
 *     <dom-module id="ls-sample">
 *       <iron-localstorage name="my-app-storage"
 *         value="{{cartoon}}"
 *         on-iron-localstorage-load-empty="initializeDefaultCartoon"
 *       ></iron-localstorage>
 *     </dom-module>
 *
 *     <script>
 *       Polymer({
 *         is: 'ls-sample',
 *         properties: {
 *           cartoon: {
 *             type: Object
 *           }
 *         },
 *         // initializes default if nothing has been stored
 *         initializeDefaultCartoon: function() {
 *           this.cartoon = {
 *             name: "Mickey",
 *             hasEars: true
 *           }
 *         },
 *         // use path set api to propagate changes to localstorage
 *         makeModifications: function() {
 *           this.set('cartoon.name', "Minions");
 *           this.set('cartoon.hasEars', false);
 *         }
 *       });
 *     </script>
 *
 * ### Tech notes:
 *
 * * `value.*` is observed, and saved on modifications. You must use
 *     path change notification methods such as `set()` to modify value
 *     for changes to be observed.
 *
 * * Set `auto-save-disabled` to prevent automatic saving.
 *
 * * Value is saved as JSON by default.
 *
 * * To delete a key, set value to null
 *
 * Element listens to StorageAPI `storage` event, and will reload upon receiving it.
 *
 * **Warning**: do not bind value to sub-properties until Polymer
 * [bug 1550](https://github.com/Polymer/polymer/issues/1550)
 * is resolved. Local storage will be blown away.
 * `<iron-localstorage value="{{foo.bar}}"` will cause **data loss**.
 */
interface IronLocalstorageElement extends Polymer.Element {

  /**
   * localStorage item key
   */
  name: string|null|undefined;

  /**
   * The data associated with this storage.
   * If set to null item will be deleted.
   */
  value: any;

  /**
   * If true: do not convert value to JSON on save/load
   */
  useRaw: boolean|null|undefined;

  /**
   * Value will not be saved automatically if true. You'll have to do it manually with `save()`
   */
  autoSaveDisabled: boolean|null|undefined;

  /**
   * Last error encountered while saving/loading items
   */
  errorMessage: string|null|undefined;

  /**
   * True if value has been loaded
   */
  _loaded: boolean|null|undefined;
  ready(): void;
  attached(): void;
  detached(): void;
  _handleStorage(ev: any): void;
  _trySaveValue(): void;
  _debounceReload(): void;

  /**
   * Loads the value again. Use if you modify
   * localStorage using DOM calls, and want to
   * keep this element in sync.
   */
  reload(): void;

  /**
   * loads value from local storage
   *
   * @param externalChange true if loading changes from a different window
   */
  _load(externalChange?: boolean): void;

  /**
   * Saves the value to localStorage. Call to save if autoSaveDisabled is set.
   * If `value` is null or undefined, deletes localStorage.
   */
  save(): void;
}

interface HTMLElementTagNameMap {
  "iron-localstorage": IronLocalstorageElement;
}
