/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
import './x-resizer-parent.js';
import './x-resizable.js';

import {Polymer} from '@polymer/polymer/lib/legacy/polymer-fn.js';
import {html} from '@polymer/polymer/lib/utils/html-tag.js';

import {IronResizableBehavior} from '../iron-resizable-behavior.js';

Polymer({

  is: 'x-resizer-parent-filtered',

  active: null,

  behaviors: [IronResizableBehavior],

  resizerShouldNotify: function(el) {
    return (el == this.active);
  }

});
Polymer({
  _template: html`
    <div>
      <x-resizable id="resizable"></x-resizable>
    </div>
  `,

  is: 'x-resizable-in-shadow'
});
Polymer({
  _template: html`
    <!-- Normal resizable parent with child resizables -->
    <x-resizer-parent id="parent">
      <x-resizable id="child1a"></x-resizable>
      <div>
        <x-resizable id="child1b"></x-resizable>
      </div>
      <x-resizable-in-shadow id="shadow1c"></x-resizable-in-shadow>
      <div>
        <x-resizable-in-shadow id="shadow1d"></x-resizable-in-shadow>
      </div>
    </x-resizer-parent>

    <!-- Resizable parent using resizerShouldNotify, with child resizables -->
    <x-resizer-parent-filtered id="parentFiltered">
      <x-resizable id="child2a"></x-resizable>
      <div>
        <x-resizable id="child2b"></x-resizable>
      </div>
      <x-resizable-in-shadow id="shadow2c"></x-resizable-in-shadow>
      <div>
        <x-resizable-in-shadow id="shadow2d"></x-resizable-in-shadow>
      </div>
    </x-resizer-parent-filtered>
  `,

  is: 'test-element'
});

/** @polymerBehavior */
export const ObserveIronResizeBehavior = {
  properties: {
    ironResizeCount: {
      type: Number,
      value: 0,
    },
  },

  listeners: {'iron-resize': '_incrementIronResizeCount'},

  _incrementIronResizeCount: function() {
    this.ironResizeCount++;
  }
};

Polymer({
  _template: html`
    <div></div>
  `,

  is: 'x-shadow-resizable',

  behaviors: [IronResizableBehavior, ObserveIronResizeBehavior]
});
Polymer({
  _template: html`
    <x-shadow-resizable id="childResizable1"></x-shadow-resizable>
    <x-shadow-resizable id="childResizable2"></x-shadow-resizable>
  `,

  is: 'x-light-resizable',

  behaviors: [IronResizableBehavior, ObserveIronResizeBehavior]
});
