[![Build status](https://travis-ci.org/PolymerElements/paper-tabs.svg?branch=master)](https://travis-ci.org/PolymerElements/paper-tabs)
[![Published on webcomponents.org](https://img.shields.io/badge/webcomponents.org-published-blue.svg)](https://beta.webcomponents.org/element/PolymerElements/paper-tabs)

## &lt;paper-tabs&gt;

Material design: [Tabs](https://www.google.com/design/spec/components/tabs.html)

`paper-tabs` makes it easy to explore and switch between different views or functional aspects of
an app, or to browse categorized data sets.

<!---
```
<custom-element-demo>
  <template>
    <script src="../webcomponentsjs/webcomponents-lite.js"></script>
    <link rel="import" href="paper-tabs.html">
    <style>
      body {
        margin: 0;
        display: flex;
        align-items: flex-end;
        height: 80px;
        background: #009688;
        color: white;
      }
      paper-tabs {
        font-family: 'Roboto', 'Noto', sans-serif;
        -webkit-font-smoothing: antialiased;
        width: 100%;
        text-transform: uppercase;
        margin-bottom: 1px;
      }
    </style>
    <next-code-block></next-code-block>
  </template>
</custom-element-demo>
```
-->
```html
<paper-tabs selected="0" scrollable>
  <paper-tab>The first tab</paper-tab>
  <paper-tab>Tab two</paper-tab>
  <paper-tab>The third tab</paper-tab>
  <paper-tab>Fourth tab</paper-tab>
</paper-tabs>
```

### Notable breaking changes between 1.x and 2.x (hybrid):

IronSelectableBehavior and IronMultiSelectableBehavior, which are used by
paper-tabs, introduce multiple breaking changes. Please see the README for those
behaviors for more detail.
