/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   paper-tabs.html
 */

/// <reference path="../polymer/types/polymer.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />
/// <reference path="../iron-icon/iron-icon.d.ts" />
/// <reference path="../iron-menu-behavior/iron-menubar-behavior.d.ts" />
/// <reference path="../iron-resizable-behavior/iron-resizable-behavior.d.ts" />
/// <reference path="../paper-icon-button/paper-icon-button.d.ts" />
/// <reference path="../paper-styles/color.d.ts" />
/// <reference path="paper-tabs-icons.d.ts" />
/// <reference path="paper-tab.d.ts" />

/**
 * Material design: [Tabs](https://www.google.com/design/spec/components/tabs.html)
 *
 * `paper-tabs` makes it easy to explore and switch between different views or functional aspects of
 * an app, or to browse categorized data sets.
 *
 * Use `selected` property to get or set the selected tab.
 *
 * Example:
 *
 *     <paper-tabs selected="0">
 *       <paper-tab>TAB 1</paper-tab>
 *       <paper-tab>TAB 2</paper-tab>
 *       <paper-tab>TAB 3</paper-tab>
 *     </paper-tabs>
 *
 * See <a href="?active=paper-tab">paper-tab</a> for more information about
 * `paper-tab`.
 *
 * A common usage for `paper-tabs` is to use it along with `iron-pages` to switch
 * between different views.
 *
 *     <paper-tabs selected="{{selected}}">
 *       <paper-tab>Tab 1</paper-tab>
 *       <paper-tab>Tab 2</paper-tab>
 *       <paper-tab>Tab 3</paper-tab>
 *     </paper-tabs>
 *
 *     <iron-pages selected="{{selected}}">
 *       <div>Page 1</div>
 *       <div>Page 2</div>
 *       <div>Page 3</div>
 *     </iron-pages>
 *
 *
 * To use links in tabs, add `link` attribute to `paper-tab` and put an `<a>`
 * element in `paper-tab` with a `tabindex` of -1.
 *
 * Example:
 *
 * <pre><code>
 * &lt;style is="custom-style">
 *   .link {
 *     &#64;apply --layout-horizontal;
 *     &#64;apply --layout-center-center;
 *   }
 * &lt;/style>
 *
 * &lt;paper-tabs selected="0">
 *   &lt;paper-tab link>
 *     &lt;a href="#link1" class="link" tabindex="-1">TAB ONE&lt;/a>
 *   &lt;/paper-tab>
 *   &lt;paper-tab link>
 *     &lt;a href="#link2" class="link" tabindex="-1">TAB TWO&lt;/a>
 *   &lt;/paper-tab>
 *   &lt;paper-tab link>
 *     &lt;a href="#link3" class="link" tabindex="-1">TAB THREE&lt;/a>
 *   &lt;/paper-tab>
 * &lt;/paper-tabs>
 * </code></pre>
 *
 * ### Styling
 *
 * The following custom properties and mixins are available for styling:
 *
 * Custom property | Description | Default
 * ----------------|-------------|----------
 * `--paper-tabs-selection-bar-color` | Color for the selection bar | `--paper-yellow-a100`
 * `--paper-tabs-selection-bar` | Mixin applied to the selection bar | `{}`
 * `--paper-tabs` | Mixin applied to the tabs | `{}`
 * `--paper-tabs-content` | Mixin applied to the content container of tabs | `{}`
 * `--paper-tabs-container` | Mixin applied to the layout container of tabs | `{}`
 */
interface PaperTabsElement extends Polymer.Element, Polymer.IronResizableBehavior, Polymer.IronMenubarBehavior {
  selectable: string|null|undefined;
  keyBindings: object;

  /**
   * If true, ink ripple effect is disabled. When this property is changed,
   * all descendant `<paper-tab>` elements have their `noink` property
   * changed to the new value as well.
   */
  noink: boolean|null|undefined;

  /**
   * If true, the bottom bar to indicate the selected tab will not be shown.
   */
  noBar: boolean|null|undefined;

  /**
   * If true, the slide effect for the bottom bar is disabled.
   */
  noSlide: boolean|null|undefined;

  /**
   * If true, tabs are scrollable and the tab width is based on the label width.
   */
  scrollable: boolean|null|undefined;

  /**
   * If true, tabs expand to fit their container. This currently only applies when
   * scrollable is true.
   */
  fitContainer: boolean|null|undefined;

  /**
   * If true, dragging on the tabs to scroll is disabled.
   */
  disableDrag: boolean|null|undefined;

  /**
   * If true, scroll buttons (left/right arrow) will be hidden for scrollable tabs.
   */
  hideScrollButtons: boolean|null|undefined;

  /**
   * If true, the tabs are aligned to bottom (the selection bar appears at the top).
   */
  alignBottom: boolean|null|undefined;

  /**
   * If true, tabs are automatically selected when focused using the
   * keyboard.
   */
  autoselect: boolean|null|undefined;

  /**
   * The delay (in milliseconds) between when the user stops interacting
   * with the tabs through the keyboard and when the focused item is
   * automatically selected (if `autoselect` is true).
   */
  autoselectDelay: number|null|undefined;
  _step: number|null|undefined;
  _holdDelay: number|null|undefined;
  _leftHidden: boolean|null|undefined;
  _rightHidden: boolean|null|undefined;
  _previousTab: object|null|undefined;
  readonly _tabContainerScrollSize: any;
  created(): void;
  detached(): void;
  _activateHandler(): void;
  ready(): void;
  _noinkChanged(noink: any): void;
  _setNoinkAttribute(element: any): void;
  _removeNoinkAttribute(element: any): void;
  _computeScrollButtonClass(hideThisButton: any, scrollable: any, hideScrollButtons: any): any;
  _computeTabsContentClass(scrollable: any, fitContainer: any): any;
  _computeSelectionBarClass(noBar: any, alignBottom: any): any;
  _onTabSizingChanged(): void;
  _onIronSelect(event: any): void;
  _onIronDeselect(event: any): void;

  /**
   * Activates an item after a delay (in milliseconds).
   */
  _scheduleActivation(item: any, delay: any): void;

  /**
   * Activates the last item given to `_scheduleActivation`.
   */
  _delayedActivationHandler(): void;

  /**
   * Cancels a previously scheduled item activation made with
   * `_scheduleActivation`.
   */
  _cancelPendingActivation(): void;
  _onArrowKeyup(event: any): void;
  _onBlurCapture(event: any): void;
  _scroll(e: any, detail: any): void;
  _down(e: any): void;
  _affectScroll(dx: any): void;
  _onLeftScrollButtonDown(): void;
  _onRightScrollButtonDown(): void;
  _onScrollButtonUp(): void;
  _scrollToLeft(): void;
  _scrollToRight(): void;
  _tabChanged(tab: any, old: any): void;
  _scrollToSelectedIfNeeded(tabWidth: any, tabOffsetLeft: any): void;
  _calcPercent(w: any, w0: any): any;
  _positionBar(width: any, left: any): void;
  _onBarTransitionEnd(e: any): void;
}

interface HTMLElementTagNameMap {
  "paper-tabs": PaperTabsElement;
}
