var IslandNode = require('../world/IslandNode');
var Pool = require('./Pool');

module.exports = IslandNodePool;

/**
 * @class
 */
function IslandNodePool() {
	Pool.apply(this, arguments);
}
IslandNodePool.prototype = new Pool();
IslandNodePool.prototype.constructor = IslandNodePool;

/**
 * @method create
 * @return {IslandNode}
 */
IslandNodePool.prototype.create = function () {
	return new IslandNode();
};

/**
 * @method destroy
 * @param {IslandNode} node
 * @return {IslandNodePool}
 */
IslandNodePool.prototype.destroy = function (node) {
	node.reset();
	return this;
};
