/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";function t(t){return void 0!==t&&null!==t}return t}),define("Core/DeveloperError",["./defined"],function(t){"use strict";function e(t){this.name="DeveloperError",this.message=t;var e;try{throw new Error}catch(t){e=t.stack}this.stack=e}return t(Object.create)&&(e.prototype=Object.create(Error.prototype),e.prototype.constructor=e),e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e.throwInstantiationError=function(){throw new e("This function defines an interface and should not be called directly.")},e}),define("Core/Check",["./defined","./DeveloperError"],function(t,e){"use strict";function n(t){return t+" is required, actual value was undefined"}function r(t,e,n){return"Expected "+n+" to be typeof "+e+", actual typeof was "+t}var a={};return a.typeOf={},a.defined=function(r,a){if(!t(a))throw new e(n(r))},a.typeOf.func=function(t,n){if("function"!=typeof n)throw new e(r(typeof n,"function",t))},a.typeOf.string=function(t,n){if("string"!=typeof n)throw new e(r(typeof n,"string",t))},a.typeOf.number=function(t,n){if("number"!=typeof n)throw new e(r(typeof n,"number",t))},a.typeOf.number.lessThan=function(t,n,r){if(a.typeOf.number(t,n),n>=r)throw new e("Expected "+t+" to be less than "+r+", actual value was "+n)},a.typeOf.number.lessThanOrEquals=function(t,n,r){if(a.typeOf.number(t,n),n>r)throw new e("Expected "+t+" to be less than or equal to "+r+", actual value was "+n)},a.typeOf.number.greaterThan=function(t,n,r){if(a.typeOf.number(t,n),n<=r)throw new e("Expected "+t+" to be greater than "+r+", actual value was "+n)},a.typeOf.number.greaterThanOrEquals=function(t,n,r){if(a.typeOf.number(t,n),n<r)throw new e("Expected "+t+" to be greater than or equal to"+r+", actual value was "+n)},a.typeOf.object=function(t,n){if("object"!=typeof n)throw new e(r(typeof n,"object",t))},a.typeOf.bool=function(t,n){if("boolean"!=typeof n)throw new e(r(typeof n,"boolean",t))},a.typeOf.number.equals=function(t,n,r,i){if(a.typeOf.number(t,r),a.typeOf.number(n,i),r!==i)throw new e(t+" must be equal to "+n+", the actual values are "+r+" and "+i)},a}),define("Core/freezeObject",["./defined"],function(t){"use strict";var e=Object.freeze;return t(e)||(e=function(t){return t}),e}),define("Core/defaultValue",["./freezeObject"],function(t){"use strict";function e(t,e){return void 0!==t&&null!==t?t:e}return e.EMPTY_OBJECT=t({}),e}),define("ThirdParty/mersenne-twister",[],function(){var t=function(t){void 0==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(t)};return t.prototype.init_genrand=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){var t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},t.prototype.genrand_int32=function(){var t,e=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^t>>>1^e[1&t];for(;n<this.N-1;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^t>>>1^e[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^e[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=t<<7&2636928640,t^=t<<15&4022730752,(t^=t>>>18)>>>0},t.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},t}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(t,e,n,r){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=e(Math.sign,function(t){return t=+t,0===t||t!==t?t:t>0?1:-1}),a.signNotZero=function(t){return t<0?-1:1},a.toSNorm=function(t,n){return n=e(n,255),Math.round((.5*a.clamp(t,-1,1)+.5)*n)},a.fromSNorm=function(t,n){return n=e(n,255),a.clamp(t,0,n)/n*2-1},a.sinh=e(Math.sinh,function(t){return(Math.exp(t)-Math.exp(-t))/2}),a.cosh=e(Math.cosh,function(t){return(Math.exp(t)+Math.exp(-t))/2}),a.lerp=function(t,e,n){return(1-n)*t+n*e},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=Math.PI/2,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI/2,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(t){return t*a.RADIANS_PER_DEGREE},a.toDegrees=function(t){return t*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(t){var e=a.TWO_PI,n=t-Math.floor(t/e)*e;return n<-Math.PI?n+e:n>=Math.PI?n-e:n},a.clampToLatitudeRange=function(t){return a.clamp(t,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(t){return a.zeroToTwoPi(t+a.PI)-a.PI},a.zeroToTwoPi=function(t){var e=a.mod(t,a.TWO_PI);return Math.abs(e)<a.EPSILON14&&Math.abs(t)>a.EPSILON14?a.TWO_PI:e},a.mod=function(t,e){return(t%e+e)%e},a.equalsEpsilon=function(t,n,r,a){a=e(a,r);var i=Math.abs(t-n);return i<=a||i<=r*Math.max(Math.abs(t),Math.abs(n))};var i=[1];a.factorial=function(t){var e=i.length;if(t>=e)for(var n=i[e-1],r=e;r<=t;r++)i.push(n*r);return i[t]},a.incrementWrap=function(t,n,r){return r=e(r,0),++t,t>n&&(t=r),t},a.isPowerOfTwo=function(t){return 0!==t&&0==(t&t-1)},a.nextPowerOfTwo=function(t){return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t},a.clamp=function(t,e,n){return t<e?e:t>n?n:t};var o=new t;return a.setRandomNumberSeed=function(e){o=new t(e)},a.nextRandomNumber=function(){return o.random()},a.randomBetween=function(t,e){return a.nextRandomNumber()*(e-t)+t},a.acosClamped=function(t){return Math.acos(a.clamp(t,-1,1))},a.asinClamped=function(t){return Math.asin(a.clamp(t,-1,1))},a.chordLength=function(t,e){return 2*e*Math.sin(.5*t)},a.logBase=function(t,e){return Math.log(t)/Math.log(e)},a.cbrt=e(Math.cbrt,function(t){var e=Math.pow(Math.abs(t),1/3);return t<0?-e:e}),a.log2=e(Math.log2,function(t){return Math.log(t)*Math.LOG2E}),a.fog=function(t,e){var n=t*e;return 1-Math.exp(-n*n)},a}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,a,i){"use strict";function o(t,n,r){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0)}o.fromSpherical=function(t,r){n(r)||(r=new o);var a=t.clock,i=t.cone,u=e(t.magnitude,1),s=u*Math.sin(i);return r.x=s*Math.cos(a),r.y=s*Math.sin(a),r.z=u*Math.cos(i),r},o.fromElements=function(t,e,r,a){return n(a)?(a.x=t,a.y=e,a.z=r,a):new o(t,e,r)},o.clone=function(t,e){if(n(t))return n(e)?(e.x=t.x,e.y=t.y,e.z=t.z,e):new o(t.x,t.y,t.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(t,n,r){return r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r]=t.z,n},o.unpack=function(t,r,a){return r=e(r,0),n(a)||(a=new o),a.x=t[r++],a.y=t[r++],a.z=t[r],a},o.packArray=function(t,e){var r=t.length;n(e)?e.length=3*r:e=new Array(3*r);for(var a=0;a<r;++a)o.pack(t[a],e,3*a);return e},o.unpackArray=function(t,e){var r=t.length;n(e)?e.length=r/3:e=new Array(r/3);for(var a=0;a<r;a+=3){var i=a/3;e[i]=o.unpack(t,a,e[i])}return e},o.fromArray=o.unpack,o.maximumComponent=function(t){return Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,e,n){return n.x=Math.min(t.x,e.x),n.y=Math.min(t.y,e.y),n.z=Math.min(t.z,e.z),n},o.maximumByComponent=function(t,e,n){return n.x=Math.max(t.x,e.x),n.y=Math.max(t.y,e.y),n.z=Math.max(t.z,e.z),n},o.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(t){return Math.sqrt(o.magnitudeSquared(t))};var u=new o;o.distance=function(t,e){return o.subtract(t,e,u),o.magnitude(u)},o.distanceSquared=function(t,e){return o.subtract(t,e,u),o.magnitudeSquared(u)},o.normalize=function(t,e){var n=o.magnitude(t);return e.x=t.x/n,e.y=t.y/n,e.z=t.z/n,e},o.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z},o.multiplyComponents=function(t,e,n){return n.x=t.x*e.x,n.y=t.y*e.y,n.z=t.z*e.z,n},o.divideComponents=function(t,e,n){return n.x=t.x/e.x,n.y=t.y/e.y,n.z=t.z/e.z,n},o.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n},o.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n},o.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n.z=t.z*e,n},o.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n.z=t.z/e,n},o.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e},o.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e};var s=new o;o.lerp=function(t,e,n,r){return o.multiplyByScalar(e,n,s),r=o.multiplyByScalar(t,1-n,r),o.add(s,r,r)};var c=new o,E=new o;o.angleBetween=function(t,e){o.normalize(t,c),o.normalize(e,E);var n=o.dot(c,E),r=o.magnitude(o.cross(c,E,c));return Math.atan2(r,n)};var _=new o;o.mostOrthogonalAxis=function(t,e){var n=o.normalize(t,_);return o.abs(n,n),e=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,e):o.clone(o.UNIT_Z,e):n.y<=n.z?o.clone(o.UNIT_Y,e):o.clone(o.UNIT_Z,e)},o.projectVector=function(t,e,n){var r=o.dot(t,e)/o.dot(e,e);return o.multiplyByScalar(e,r,n)},o.equals=function(t,e){return t===e||n(t)&&n(e)&&t.x===e.x&&t.y===e.y&&t.z===e.z},o.equalsArray=function(t,e,n){return t.x===e[n]&&t.y===e[n+1]&&t.z===e[n+2]},o.equalsEpsilon=function(t,e,r,a){return t===e||n(t)&&n(e)&&i.equalsEpsilon(t.x,e.x,r,a)&&i.equalsEpsilon(t.y,e.y,r,a)&&i.equalsEpsilon(t.z,e.z,r,a)},o.cross=function(t,e,n){var r=t.x,a=t.y,i=t.z,o=e.x,u=e.y,s=e.z,c=a*s-i*u,E=i*o-r*s,_=r*u-a*o;return n.x=c,n.y=E,n.z=_,n},o.fromDegrees=function(t,e,n,r,a){return t=i.toRadians(t),e=i.toRadians(e),o.fromRadians(t,e,n,r,a)};var l=new o,f=new o,h=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(t,r,a,i,u){a=e(a,0);var s=n(i)?i.radiiSquared:h,c=Math.cos(r);l.x=c*Math.cos(t),l.y=c*Math.sin(t),l.z=Math.sin(r),l=o.normalize(l,l),o.multiplyComponents(s,l,f);var E=Math.sqrt(o.dot(l,f));return f=o.divideByScalar(f,E,f),l=o.multiplyByScalar(l,a,l),n(u)||(u=new o),o.add(f,l,u)},o.fromDegreesArray=function(t,e,r){var a=t.length;n(r)?r.length=a/2:r=new Array(a/2);for(var i=0;i<a;i+=2){var u=t[i],s=t[i+1],c=i/2;r[c]=o.fromDegrees(u,s,0,e,r[c])}return r},o.fromRadiansArray=function(t,e,r){var a=t.length;n(r)?r.length=a/2:r=new Array(a/2);for(var i=0;i<a;i+=2){var u=t[i],s=t[i+1],c=i/2;r[c]=o.fromRadians(u,s,0,e,r[c])}return r},o.fromDegreesArrayHeights=function(t,e,r){var a=t.length;n(r)?r.length=a/3:r=new Array(a/3);for(var i=0;i<a;i+=3){var u=t[i],s=t[i+1],c=t[i+2],E=i/3;r[E]=o.fromDegrees(u,s,c,e,r[E])}return r},o.fromRadiansArrayHeights=function(t,e,r){var a=t.length;n(r)?r.length=a/3:r=new Array(a/3);for(var i=0;i<a;i+=3){var u=t[i],s=t[i+1],c=t[i+2],E=i/3;r[E]=o.fromRadians(u,s,c,e,r[E])}return r},o.ZERO=a(new o(0,0,0)),o.UNIT_X=a(new o(1,0,0)),o.UNIT_Y=a(new o(0,1,0)),o.UNIT_Z=a(new o(0,0,1)),o.prototype.clone=function(t){return o.clone(this,t)},o.prototype.equals=function(t){return o.equals(this,t)},o.prototype.equalsEpsilon=function(t,e,n){return o.equalsEpsilon(this,t,e,n)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(t,e,n,r){"use strict";function a(n,a,u,s,c){var E=n.x,_=n.y,l=n.z,f=a.x,h=a.y,T=a.z,R=E*E*f*f,d=_*_*h*h,A=l*l*T*T,p=R+d+A,m=Math.sqrt(1/p),N=t.multiplyByScalar(n,m,i);if(p<s)return isFinite(m)?t.clone(N,c):void 0;var y=u.x,I=u.y,S=u.z,M=o;M.x=N.x*y*2,M.y=N.y*I*2,M.z=N.z*S*2;var O,C,w,v,g,P,x,F,U,L,D,B=(1-m)*t.magnitude(n)/(.5*t.magnitude(M)),z=0;do{B-=z,w=1/(1+B*y),v=1/(1+B*I),g=1/(1+B*S),P=w*w,x=v*v,F=g*g,U=P*w,L=x*v,D=F*g,O=R*P+d*x+A*F-1,C=R*U*y+d*L*I+A*D*S;z=O/(-2*C)}while(Math.abs(O)>r.EPSILON12);return e(c)?(c.x=E*w,c.y=_*v,c.z=l*g,c):new t(E*w,_*v,l*g)}var i=new t,o=new t;return a}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(t,e,n,r,a,i,o){"use strict";function u(t,e,r){this.longitude=n(t,0),this.latitude=n(e,0),this.height=n(r,0)}u.fromRadians=function(t,e,a,i){return a=n(a,0),r(i)?(i.longitude=t,i.latitude=e,i.height=a,i):new u(t,e,a)},u.fromDegrees=function(t,e,n,r){return t=i.toRadians(t),e=i.toRadians(e),u.fromRadians(t,e,n,r)};var s=new t,c=new t,E=new t,_=new t(1/6378137,1/6378137,1/6356752.314245179),l=new t(1/40680631590769,1/40680631590769,1/40408299984661.445),f=i.EPSILON1;return u.fromCartesian=function(e,n,a){var h=r(n)?n.oneOverRadii:_,T=r(n)?n.oneOverRadiiSquared:l,R=r(n)?n._centerToleranceSquared:f,d=o(e,h,T,R,c);if(r(d)){var A=t.multiplyComponents(d,T,s);A=t.normalize(A,A);var p=t.subtract(e,d,E),m=Math.atan2(A.y,A.x),N=Math.asin(A.z),y=i.sign(t.dot(p,e))*t.magnitude(p);return r(a)?(a.longitude=m,a.latitude=N,a.height=y,a):new u(m,N,y)}},u.toCartesian=function(e,n,r){return t.fromRadians(e.longitude,e.latitude,e.height,n,r)},u.clone=function(t,e){if(r(t))return r(e)?(e.longitude=t.longitude,e.latitude=t.latitude,e.height=t.height,e):new u(t.longitude,t.latitude,t.height)},u.equals=function(t,e){return t===e||r(t)&&r(e)&&t.longitude===e.longitude&&t.latitude===e.latitude&&t.height===e.height},u.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t.longitude-e.longitude)<=n&&Math.abs(t.latitude-e.latitude)<=n&&Math.abs(t.height-e.height)<=n},u.ZERO=a(new u(0,0,0)),u.prototype.clone=function(t){return u.clone(this,t)},u.prototype.equals=function(t){return u.equals(this,t)},u.prototype.equalsEpsilon=function(t,e){return u.equalsEpsilon(this,t,e)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(t){"use strict";var e=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(t){return!1}}(),n=Object.defineProperties;return e&&t(n)||(n=function(t){return t}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(t,e,n,r,a,i,o,u,s,c){"use strict";function E(e,n,a,i){n=r(n,0),a=r(a,0),i=r(i,0),e._radii=new t(n,a,i),e._radiiSquared=new t(n*n,a*a,i*i),e._radiiToTheFourth=new t(n*n*n*n,a*a*a*a,i*i*i*i),e._oneOverRadii=new t(0===n?0:1/n,0===a?0:1/a,0===i?0:1/i),e._oneOverRadiiSquared=new t(0===n?0:1/(n*n),0===a?0:1/(a*a),0===i?0:1/(i*i)),e._minimumRadius=Math.min(n,a,i),e._maximumRadius=Math.max(n,a,i),e._centerToleranceSquared=s.EPSILON1,0!==e._radiiSquared.z&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function _(t,e,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,E(this,t,e,n)}i(_.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),_.clone=function(e,n){if(a(e)){var r=e._radii;return a(n)?(t.clone(r,n._radii),t.clone(e._radiiSquared,n._radiiSquared),t.clone(e._radiiToTheFourth,n._radiiToTheFourth),t.clone(e._oneOverRadii,n._oneOverRadii),t.clone(e._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=e._minimumRadius,n._maximumRadius=e._maximumRadius,n._centerToleranceSquared=e._centerToleranceSquared,n):new _(r.x,r.y,r.z)}},_.fromCartesian3=function(t,e){return a(e)||(e=new _),a(t)?(E(e,t.x,t.y,t.z),e):e},_.WGS84=u(new _(6378137,6378137,6356752.314245179)),_.UNIT_SPHERE=u(new _(1,1,1)),_.MOON=u(new _(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),_.prototype.clone=function(t){return _.clone(this,t)},_.packedLength=t.packedLength,_.pack=function(e,n,a){return a=r(a,0),t.pack(e._radii,n,a),n},_.unpack=function(e,n,a){n=r(n,0);var i=t.unpack(e,n);return _.fromCartesian3(i,a)},_.prototype.geocentricSurfaceNormal=t.normalize,_.prototype.geodeticSurfaceNormalCartographic=function(e,n){var r=e.longitude,i=e.latitude,o=Math.cos(i),u=o*Math.cos(r),s=o*Math.sin(r),c=Math.sin(i);return a(n)||(n=new t),n.x=u,n.y=s,n.z=c,t.normalize(n,n)},_.prototype.geodeticSurfaceNormal=function(e,n){return a(n)||(n=new t),n=t.multiplyComponents(e,this._oneOverRadiiSquared,n),t.normalize(n,n)};var l=new t,f=new t;_.prototype.cartographicToCartesian=function(e,n){var r=l,i=f;this.geodeticSurfaceNormalCartographic(e,r),t.multiplyComponents(this._radiiSquared,r,i);var o=Math.sqrt(t.dot(r,i));return t.divideByScalar(i,o,i),t.multiplyByScalar(r,e.height,r),a(n)||(n=new t),t.add(i,r,n)},_.prototype.cartographicArrayToCartesianArray=function(t,e){var n=t.length;a(e)?e.length=n:e=new Array(n);for(var r=0;r<n;r++)e[r]=this.cartographicToCartesian(t[r],e[r]);return e};var h=new t,T=new t,R=new t;return _.prototype.cartesianToCartographic=function(n,r){var i=this.scaleToGeodeticSurface(n,T);if(a(i)){var o=this.geodeticSurfaceNormal(i,h),u=t.subtract(n,i,R),c=Math.atan2(o.y,o.x),E=Math.asin(o.z),_=s.sign(t.dot(u,n))*t.magnitude(u);return a(r)?(r.longitude=c,r.latitude=E,r.height=_,r):new e(c,E,_)}},_.prototype.cartesianArrayToCartographicArray=function(t,e){var n=t.length;a(e)?e.length=n:e=new Array(n);for(var r=0;r<n;++r)e[r]=this.cartesianToCartographic(t[r],e[r]);return e},_.prototype.scaleToGeodeticSurface=function(t,e){return c(t,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,e)},_.prototype.scaleToGeocentricSurface=function(e,n){a(n)||(n=new t);var r=e.x,i=e.y,o=e.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(r*r*u.x+i*i*u.y+o*o*u.z);return t.multiplyByScalar(e,s,n)},_.prototype.transformPositionToScaledSpace=function(e,n){return a(n)||(n=new t),t.multiplyComponents(e,this._oneOverRadii,n)},_.prototype.transformPositionFromScaledSpace=function(e,n){return a(n)||(n=new t),t.multiplyComponents(e,this._radii,n)},_.prototype.equals=function(e){return this===e||a(e)&&t.equals(this._radii,e._radii)},_.prototype.toString=function(){return this._radii.toString()},_.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,n,i){n=r(n,0);var o=this._squaredXOverSquaredZ;if(a(i)||(i=new t),i.x=0,i.y=0,i.z=e.z*(1-o),!(Math.abs(i.z)>=this._radii.z-n))return i},_}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(t,e,n,r,a,i,o){"use strict";function u(t){this._ellipsoid=n(t,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(e,n){var a=this._semimajorAxis,i=e.longitude*a,o=e.latitude*a,u=e.height;return r(n)?(n.x=i,n.y=o,n.z=u,n):new t(i,o,u)},u.prototype.unproject=function(t,n){var a=this._oneOverSemimajorAxis,i=t.x*a,o=t.y*a,u=t.z;return r(n)?(n.longitude=i,n.latitude=o,n.height=u,n):new e(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(t){"use strict";return t({OUTSIDE:-1,INTERSECTING:0,INSIDE:1})}),define("Core/Interval",["./defaultValue"],function(t){"use strict";function e(e,n){this.start=t(e,0),this.stop=t(n,0)}return e}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,a,i,o,u){"use strict";function s(t,e,r,a,i,o,u,s,c){this[0]=n(t,0),this[1]=n(a,0),this[2]=n(u,0),this[3]=n(e,0),this[4]=n(i,0),this[5]=n(s,0),this[6]=n(r,0),this[7]=n(o,0),this[8]=n(c,0)}function c(t){for(var e=0,n=0;n<9;++n){var r=t[n];e+=r*r}return Math.sqrt(e)}function E(t){for(var e=0,n=0;n<3;++n){var r=t[s.getElementIndex(T[n],h[n])];e+=2*r*r}return Math.sqrt(e)}function _(t,e){for(var n=u.EPSILON15,r=0,a=1,i=0;i<3;++i){var o=Math.abs(t[s.getElementIndex(T[i],h[i])]);o>r&&(a=i,r=o)}var c=1,E=0,_=h[a],l=T[a];if(Math.abs(t[s.getElementIndex(l,_)])>n){var f,R=t[s.getElementIndex(l,l)],d=t[s.getElementIndex(_,_)],A=t[s.getElementIndex(l,_)],p=(R-d)/2/A;f=p<0?-1/(-p+Math.sqrt(1+p*p)):1/(p+Math.sqrt(1+p*p)),c=1/Math.sqrt(1+f*f),E=f*c}return e=s.clone(s.IDENTITY,e),e[s.getElementIndex(_,_)]=e[s.getElementIndex(l,l)]=c,e[s.getElementIndex(l,_)]=E,e[s.getElementIndex(_,l)]=-E,e}s.packedLength=9,s.pack=function(t,e,r){return r=n(r,0),e[r++]=t[0],e[r++]=t[1],e[r++]=t[2],e[r++]=t[3],e[r++]=t[4],e[r++]=t[5],e[r++]=t[6],e[r++]=t[7],e[r++]=t[8],e},s.unpack=function(t,e,a){return e=n(e,0),r(a)||(a=new s),a[0]=t[e++],a[1]=t[e++],a[2]=t[e++],a[3]=t[e++],a[4]=t[e++],a[5]=t[e++],a[6]=t[e++],a[7]=t[e++],a[8]=t[e++],a},s.clone=function(t,e){if(r(t))return r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):new s(t[0],t[3],t[6],t[1],t[4],t[7],t[2],t[5],t[8])},s.fromArray=function(t,e,a){return e=n(e,0),r(a)||(a=new s),a[0]=t[e],a[1]=t[e+1],a[2]=t[e+2],a[3]=t[e+3],a[4]=t[e+4],a[5]=t[e+5],a[6]=t[e+6],a[7]=t[e+7],a[8]=t[e+8],a},s.fromColumnMajorArray=function(t,e){return s.clone(t,e)},s.fromRowMajorArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],e):new s(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},s.fromQuaternion=function(t,e){var n=t.x*t.x,a=t.x*t.y,i=t.x*t.z,o=t.x*t.w,u=t.y*t.y,c=t.y*t.z,E=t.y*t.w,_=t.z*t.z,l=t.z*t.w,f=t.w*t.w,h=n-u-_+f,T=2*(a-l),R=2*(i+E),d=2*(a+l),A=-n+u-_+f,p=2*(c-o),m=2*(i-E),N=2*(c+o),y=-n-u+_+f;return r(e)?(e[0]=h,e[1]=d,e[2]=m,e[3]=T,e[4]=A,e[5]=N,e[6]=R,e[7]=p,e[8]=y,e):new s(h,T,R,d,A,p,m,N,y)},s.fromHeadingPitchRoll=function(t,e){var n=Math.cos(-t.pitch),a=Math.cos(-t.heading),i=Math.cos(t.roll),o=Math.sin(-t.pitch),u=Math.sin(-t.heading),c=Math.sin(t.roll),E=n*a,_=-i*u+c*o*a,l=c*u+i*o*a,f=n*u,h=i*a+c*o*u,T=-c*a+i*o*u,R=-o,d=c*n,A=i*n;return r(e)?(e[0]=E,e[1]=f,e[2]=R,e[3]=_,e[4]=h,e[5]=d,e[6]=l,e[7]=T,e[8]=A,e):new s(E,_,l,f,h,T,R,d,A)},s.fromScale=function(t,e){return r(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=t.y,e[5]=0,e[6]=0,e[7]=0,e[8]=t.z,e):new s(t.x,0,0,0,t.y,0,0,0,t.z)},s.fromUniformScale=function(t,e){return r(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=t,e[5]=0,e[6]=0,e[7]=0,e[8]=t,e):new s(t,0,0,0,t,0,0,0,t)},s.fromCrossProduct=function(t,e){return r(e)?(e[0]=0,e[1]=t.z,e[2]=-t.y,e[3]=-t.z,e[4]=0,e[5]=t.x,e[6]=t.y,e[7]=-t.x,e[8]=0,e):new s(0,-t.z,t.y,t.z,0,-t.x,-t.y,t.x,0)},s.fromRotationX=function(t,e){var n=Math.cos(t),a=Math.sin(t);return r(e)?(e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=n,e[5]=a,e[6]=0,e[7]=-a,e[8]=n,e):new s(1,0,0,0,n,-a,0,a,n)},s.fromRotationY=function(t,e){var n=Math.cos(t),a=Math.sin(t);return r(e)?(e[0]=n,e[1]=0,e[2]=-a,e[3]=0,e[4]=1,e[5]=0,e[6]=a,e[7]=0,e[8]=n,e):new s(n,0,a,0,1,0,-a,0,n)},s.fromRotationZ=function(t,e){var n=Math.cos(t),a=Math.sin(t);return r(e)?(e[0]=n,e[1]=a,e[2]=0,e[3]=-a,e[4]=n,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e):new s(n,-a,0,a,n,0,0,0,1)},s.toArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]]},s.getElementIndex=function(t,e){return 3*t+e},s.getColumn=function(t,e,n){var r=3*e,a=t[r],i=t[r+1],o=t[r+2];return n.x=a,n.y=i,n.z=o,n},s.setColumn=function(t,e,n,r){r=s.clone(t,r);var a=3*e;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r},s.getRow=function(t,e,n){var r=t[e],a=t[e+3],i=t[e+6];return n.x=r,n.y=a,n.z=i,n},s.setRow=function(t,e,n,r){return r=s.clone(t,r),r[e]=n.x,r[e+3]=n.y,r[e+6]=n.z,r};var l=new t;s.getScale=function(e,n){return n.x=t.magnitude(t.fromElements(e[0],e[1],e[2],l)),n.y=t.magnitude(t.fromElements(e[3],e[4],e[5],l)),n.z=t.magnitude(t.fromElements(e[6],e[7],e[8],l)),n};var f=new t;s.getMaximumScale=function(e){return s.getScale(e,f),t.maximumComponent(f)},s.multiply=function(t,e,n){var r=t[0]*e[0]+t[3]*e[1]+t[6]*e[2],a=t[1]*e[0]+t[4]*e[1]+t[7]*e[2],i=t[2]*e[0]+t[5]*e[1]+t[8]*e[2],o=t[0]*e[3]+t[3]*e[4]+t[6]*e[5],u=t[1]*e[3]+t[4]*e[4]+t[7]*e[5],s=t[2]*e[3]+t[5]*e[4]+t[8]*e[5],c=t[0]*e[6]+t[3]*e[7]+t[6]*e[8],E=t[1]*e[6]+t[4]*e[7]+t[7]*e[8],_=t[2]*e[6]+t[5]*e[7]+t[8]*e[8];return n[0]=r,n[1]=a,n[2]=i,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=E,n[8]=_,n},s.add=function(t,e,n){return n[0]=t[0]+e[0],n[1]=t[1]+e[1],n[2]=t[2]+e[2],n[3]=t[3]+e[3],n[4]=t[4]+e[4],n[5]=t[5]+e[5],n[6]=t[6]+e[6],n[7]=t[7]+e[7],n[8]=t[8]+e[8],n},s.subtract=function(t,e,n){return n[0]=t[0]-e[0],n[1]=t[1]-e[1],n[2]=t[2]-e[2],n[3]=t[3]-e[3],n[4]=t[4]-e[4],n[5]=t[5]-e[5],n[6]=t[6]-e[6],n[7]=t[7]-e[7],n[8]=t[8]-e[8],n},s.multiplyByVector=function(t,e,n){var r=e.x,a=e.y,i=e.z,o=t[0]*r+t[3]*a+t[6]*i,u=t[1]*r+t[4]*a+t[7]*i,s=t[2]*r+t[5]*a+t[8]*i;return n.x=o,n.y=u,n.z=s,n},s.multiplyByScalar=function(t,e,n){return n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n[4]=t[4]*e,n[5]=t[5]*e,n[6]=t[6]*e,n[7]=t[7]*e,n[8]=t[8]*e,n},s.multiplyByScale=function(t,e,n){return n[0]=t[0]*e.x,n[1]=t[1]*e.x,n[2]=t[2]*e.x,n[3]=t[3]*e.y,n[4]=t[4]*e.y,n[5]=t[5]*e.y,n[6]=t[6]*e.z,n[7]=t[7]*e.z,n[8]=t[8]*e.z,n},s.negate=function(t,e){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e},s.transpose=function(t,e){var n=t[0],r=t[3],a=t[6],i=t[1],o=t[4],u=t[7],s=t[2],c=t[5],E=t[8];return e[0]=n,e[1]=r,e[2]=a,e[3]=i,e[4]=o,e[5]=u,e[6]=s,e[7]=c,e[8]=E,e};var h=[1,0,0],T=[2,2,1],R=new s,d=new s;return s.computeEigenDecomposition=function(t,e){var n=u.EPSILON20,a=0,i=0;r(e)||(e={});for(var o=e.unitary=s.clone(s.IDENTITY,e.unitary),l=e.diagonal=s.clone(t,e.diagonal),f=n*c(l);i<10&&E(l)>f;)_(l,R),s.transpose(R,d),s.multiply(l,R,l),s.multiply(d,l,l),s.multiply(o,R,o),++a>2&&(++i,a=0);return e},s.abs=function(t,e){return e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e},s.determinant=function(t){var e=t[0],n=t[3],r=t[6],a=t[1],i=t[4],o=t[7],u=t[2],s=t[5],c=t[8];return e*(i*c-s*o)+a*(s*r-n*c)+u*(n*o-i*r)},s.inverse=function(t,e){var n=t[0],r=t[1],a=t[2],i=t[3],o=t[4],u=t[5],c=t[6],E=t[7],_=t[8],l=s.determinant(t);e[0]=o*_-E*u,e[1]=E*a-r*_,e[2]=r*u-o*a,e[3]=c*u-i*_,e[4]=n*_-c*a,e[5]=i*a-n*u,e[6]=i*E-c*o,e[7]=c*r-n*E,e[8]=n*o-i*r;var f=1/l;return s.multiplyByScalar(e,f,e)},s.equals=function(t,e){return t===e||r(t)&&r(e)&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},s.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t[0]-e[0])<=n&&Math.abs(t[1]-e[1])<=n&&Math.abs(t[2]-e[2])<=n&&Math.abs(t[3]-e[3])<=n&&Math.abs(t[4]-e[4])<=n&&Math.abs(t[5]-e[5])<=n&&Math.abs(t[6]-e[6])<=n&&Math.abs(t[7]-e[7])<=n&&Math.abs(t[8]-e[8])<=n},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,a(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.equalsArray=function(t,e,n){return t[0]===e[n]&&t[1]===e[n+1]&&t[2]===e[n+2]&&t[3]===e[n+3]&&t[4]===e[n+4]&&t[5]===e[n+5]&&t[6]===e[n+6]&&t[7]===e[n+7]&&t[8]===e[n+8]},s.prototype.equalsEpsilon=function(t,e){return s.equalsEpsilon(this,t,e)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,a,i){"use strict";function o(t,n,r,a){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0),this.w=e(a,0)}o.fromElements=function(t,e,r,a,i){return n(i)?(i.x=t,i.y=e,i.z=r,i.w=a,i):new o(t,e,r,a)},o.fromColor=function(t,e){return n(e)?(e.x=t.red,e.y=t.green,e.z=t.blue,e.w=t.alpha,e):new o(t.red,t.green,t.blue,t.alpha)},o.clone=function(t,e){if(n(t))return n(e)?(e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e):new o(t.x,t.y,t.z,t.w)},o.packedLength=4,o.pack=function(t,n,r){return r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r++]=t.z,n[r]=t.w,n},o.unpack=function(t,r,a){return r=e(r,0),n(a)||(a=new o),a.x=t[r++],a.y=t[r++],a.z=t[r++],a.w=t[r],a},o.packArray=function(t,e){var r=t.length;n(e)?e.length=4*r:e=new Array(4*r);for(var a=0;a<r;++a)o.pack(t[a],e,4*a);return e},o.unpackArray=function(t,e){var r=t.length;n(e)?e.length=r/4:e=new Array(r/4);for(var a=0;a<r;a+=4){var i=a/4;e[i]=o.unpack(t,a,e[i])}return e},o.fromArray=o.unpack,o.maximumComponent=function(t){return Math.max(t.x,t.y,t.z,t.w)},o.minimumComponent=function(t){return Math.min(t.x,t.y,t.z,t.w)},o.minimumByComponent=function(t,e,n){return n.x=Math.min(t.x,e.x),n.y=Math.min(t.y,e.y),n.z=Math.min(t.z,e.z),n.w=Math.min(t.w,e.w),n},o.maximumByComponent=function(t,e,n){return n.x=Math.max(t.x,e.x),n.y=Math.max(t.y,e.y),n.z=Math.max(t.z,e.z),n.w=Math.max(t.w,e.w),n},o.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(t){return Math.sqrt(o.magnitudeSquared(t))};var u=new o;o.distance=function(t,e){return o.subtract(t,e,u),o.magnitude(u)},o.distanceSquared=function(t,e){return o.subtract(t,e,u),o.magnitudeSquared(u)},o.normalize=function(t,e){var n=o.magnitude(t);return e.x=t.x/n,e.y=t.y/n,e.z=t.z/n,e.w=t.w/n,e},o.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z+t.w*e.w},o.multiplyComponents=function(t,e,n){return n.x=t.x*e.x,n.y=t.y*e.y,n.z=t.z*e.z,n.w=t.w*e.w,n},o.divideComponents=function(t,e,n){return n.x=t.x/e.x,n.y=t.y/e.y,n.z=t.z/e.z,n.w=t.w/e.w,n},o.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n.w=t.w+e.w,n},o.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n.w=t.w-e.w,n},o.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n.z=t.z*e,n.w=t.w*e,n},o.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n.z=t.z/e,n.w=t.w/e,n},o.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e.w=-t.w,e},o.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e.w=Math.abs(t.w),e};var s=new o;o.lerp=function(t,e,n,r){return o.multiplyByScalar(e,n,s),r=o.multiplyByScalar(t,1-n,r),o.add(s,r,r)};var c=new o;o.mostOrthogonalAxis=function(t,e){var n=o.normalize(t,c);return o.abs(n,n),e=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,e):o.clone(o.UNIT_W,e):n.z<=n.w?o.clone(o.UNIT_Z,e):o.clone(o.UNIT_W,e):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,e):o.clone(o.UNIT_W,e):n.z<=n.w?o.clone(o.UNIT_Z,e):o.clone(o.UNIT_W,e)},o.equals=function(t,e){return t===e||n(t)&&n(e)&&t.x===e.x&&t.y===e.y&&t.z===e.z&&t.w===e.w},o.equalsArray=function(t,e,n){return t.x===e[n]&&t.y===e[n+1]&&t.z===e[n+2]&&t.w===e[n+3]},o.equalsEpsilon=function(t,e,r,a){return t===e||n(t)&&n(e)&&i.equalsEpsilon(t.x,e.x,r,a)&&i.equalsEpsilon(t.y,e.y,r,a)&&i.equalsEpsilon(t.z,e.z,r,a)&&i.equalsEpsilon(t.w,e.w,r,a)},o.ZERO=a(new o(0,0,0,0)),o.UNIT_X=a(new o(1,0,0,0)),o.UNIT_Y=a(new o(0,1,0,0)),o.UNIT_Z=a(new o(0,0,1,0)),o.UNIT_W=a(new o(0,0,0,1)),o.prototype.clone=function(t){return o.clone(this,t)},o.prototype.equals=function(t){return o.equals(this,t)},o.prototype.equalsEpsilon=function(t,e,n){return o.equalsEpsilon(this,t,e,n)},o.prototype.toString=function(){
return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var E=new Float32Array(1);return o.packFloat=function(t,e){if(n(e)||(e=new o),E[0]=t,0===(t=E[0]))return o.clone(o.ZERO,e);var r,a=t<0?1:0;isFinite(t)?(t=Math.abs(t),r=Math.floor(i.logBase(t,10))+1,t/=Math.pow(10,r)):(t=.1,r=38);var u=256*t;return e.x=Math.floor(u),u=256*(u-e.x),e.y=Math.floor(u),u=256*(u-e.y),e.z=Math.floor(u),e.w=2*(r+38)+a,e},o.unpackFloat=function(t){var e=t.w/2,n=Math.floor(e),r=2*(e-n);if(n-=38,r=2*r-1,r=-r,n>=38)return r<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var a=r*t.x*(1/256);return a+=r*t.y*(1/65536),(a+=r*t.z*(1/16777216))*Math.pow(10,n)},o}),define("Core/RuntimeError",["./defined"],function(t){"use strict";function e(t){this.name="RuntimeError",this.message=t;var e;try{throw new Error}catch(t){e=t.stack}this.stack=e}return t(Object.create)&&(e.prototype=Object.create(Error.prototype),e.prototype.constructor=e),e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(t,e,n,r,a,i,o,u,s,c){"use strict";function E(t,e,n,a,i,o,u,s,c,E,_,l,f,h,T,R){this[0]=r(t,0),this[1]=r(i,0),this[2]=r(c,0),this[3]=r(f,0),this[4]=r(e,0),this[5]=r(o,0),this[6]=r(E,0),this[7]=r(h,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(_,0),this[11]=r(T,0),this[12]=r(a,0),this[13]=r(s,0),this[14]=r(l,0),this[15]=r(R,0)}E.packedLength=16,E.pack=function(t,e,n){return n=r(n,0),e[n++]=t[0],e[n++]=t[1],e[n++]=t[2],e[n++]=t[3],e[n++]=t[4],e[n++]=t[5],e[n++]=t[6],e[n++]=t[7],e[n++]=t[8],e[n++]=t[9],e[n++]=t[10],e[n++]=t[11],e[n++]=t[12],e[n++]=t[13],e[n++]=t[14],e[n]=t[15],e},E.unpack=function(t,e,n){return e=r(e,0),a(n)||(n=new E),n[0]=t[e++],n[1]=t[e++],n[2]=t[e++],n[3]=t[e++],n[4]=t[e++],n[5]=t[e++],n[6]=t[e++],n[7]=t[e++],n[8]=t[e++],n[9]=t[e++],n[10]=t[e++],n[11]=t[e++],n[12]=t[e++],n[13]=t[e++],n[14]=t[e++],n[15]=t[e],n},E.clone=function(t,e){if(a(t))return a(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):new E(t[0],t[4],t[8],t[12],t[1],t[5],t[9],t[13],t[2],t[6],t[10],t[14],t[3],t[7],t[11],t[15])},E.fromArray=E.unpack,E.fromColumnMajorArray=function(t,e){return E.clone(t,e)},E.fromRowMajorArray=function(t,e){return a(e)?(e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=t[1],e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=t[2],e[9]=t[6],e[10]=t[10],e[11]=t[14],e[12]=t[3],e[13]=t[7],e[14]=t[11],e[15]=t[15],e):new E(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},E.fromRotationTranslation=function(e,n,i){return n=r(n,t.ZERO),a(i)?(i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=0,i[4]=e[3],i[5]=e[4],i[6]=e[5],i[7]=0,i[8]=e[6],i[9]=e[7],i[10]=e[8],i[11]=0,i[12]=n.x,i[13]=n.y,i[14]=n.z,i[15]=1,i):new E(e[0],e[3],e[6],n.x,e[1],e[4],e[7],n.y,e[2],e[5],e[8],n.z,0,0,0,1)},E.fromTranslationQuaternionRotationScale=function(t,e,n,r){a(r)||(r=new E);var i=n.x,o=n.y,u=n.z,s=e.x*e.x,c=e.x*e.y,_=e.x*e.z,l=e.x*e.w,f=e.y*e.y,h=e.y*e.z,T=e.y*e.w,R=e.z*e.z,d=e.z*e.w,A=e.w*e.w,p=s-f-R+A,m=2*(c-d),N=2*(_+T),y=2*(c+d),I=-s+f-R+A,S=2*(h-l),M=2*(_-T),O=2*(h+l),C=-s-f+R+A;return r[0]=p*i,r[1]=y*i,r[2]=M*i,r[3]=0,r[4]=m*o,r[5]=I*o,r[6]=O*o,r[7]=0,r[8]=N*u,r[9]=S*u,r[10]=C*u,r[11]=0,r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=1,r},E.fromTranslationRotationScale=function(t,e){return E.fromTranslationQuaternionRotationScale(t.translation,t.rotation,t.scale,e)},E.fromTranslation=function(t,e){return E.fromRotationTranslation(s.IDENTITY,t,e)},E.fromScale=function(t,e){return a(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t.y,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t.z,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new E(t.x,0,0,0,0,t.y,0,0,0,0,t.z,0,0,0,0,1)},E.fromUniformScale=function(t,e){return a(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new E(t,0,0,0,0,t,0,0,0,0,t,0,0,0,0,1)};var _=new t,l=new t,f=new t;E.fromCamera=function(e,n){var r=e.position,i=e.direction,o=e.up;t.normalize(i,_),t.normalize(t.cross(_,o,l),l),t.normalize(t.cross(l,_,f),f);var u=l.x,s=l.y,c=l.z,h=_.x,T=_.y,R=_.z,d=f.x,A=f.y,p=f.z,m=r.x,N=r.y,y=r.z,I=u*-m+s*-N+c*-y,S=d*-m+A*-N+p*-y,M=h*m+T*N+R*y;return a(n)?(n[0]=u,n[1]=d,n[2]=-h,n[3]=0,n[4]=s,n[5]=A,n[6]=-T,n[7]=0,n[8]=c,n[9]=p,n[10]=-R,n[11]=0,n[12]=I,n[13]=S,n[14]=M,n[15]=1,n):new E(u,s,c,I,d,A,p,S,-h,-T,-R,M,0,0,0,1)},E.computePerspectiveFieldOfView=function(t,e,n,r,a){var i=Math.tan(.5*t),o=1/i,u=o/e,s=(r+n)/(n-r),c=2*r*n/(n-r);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},E.computeOrthographicOffCenter=function(t,e,n,r,a,i,o){var u=1/(e-t),s=1/(r-n),c=1/(i-a),E=-(e+t)*u,_=-(r+n)*s,l=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=E,o[13]=_,o[14]=l,o[15]=1,o},E.computePerspectiveOffCenter=function(t,e,n,r,a,i,o){var u=2*a/(e-t),s=2*a/(r-n),c=(e+t)/(e-t),E=(r+n)/(r-n),_=-(i+a)/(i-a),l=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=E,o[10]=_,o[11]=-1,o[12]=0,o[13]=0,o[14]=l,o[15]=0,o},E.computeInfinitePerspectiveOffCenter=function(t,e,n,r,a,i){var o=2*a/(e-t),u=2*a/(r-n),s=(e+t)/(e-t),c=(r+n)/(r-n),E=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=-1,i[11]=-1,i[12]=0,i[13]=0,i[14]=E,i[15]=0,i},E.computeViewportTransformation=function(t,e,n,a){t=r(t,r.EMPTY_OBJECT);var i=r(t.x,0),o=r(t.y,0),u=r(t.width,0),s=r(t.height,0);e=r(e,0),n=r(n,1);var c=.5*u,E=.5*s,_=.5*(n-e),l=c,f=E,h=_,T=i+c,R=o+E,d=e+_;return a[0]=l,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=f,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=h,a[11]=0,a[12]=T,a[13]=R,a[14]=d,a[15]=1,a},E.computeView=function(e,n,r,a,i){return i[0]=a.x,i[1]=r.x,i[2]=-n.x,i[3]=0,i[4]=a.y,i[5]=r.y,i[6]=-n.y,i[7]=0,i[8]=a.z,i[9]=r.z,i[10]=-n.z,i[11]=0,i[12]=-t.dot(a,e),i[13]=-t.dot(r,e),i[14]=t.dot(n,e),i[15]=1,i},E.toArray=function(t,e){return a(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]]},E.getElementIndex=function(t,e){return 4*t+e},E.getColumn=function(t,e,n){var r=4*e,a=t[r],i=t[r+1],o=t[r+2],u=t[r+3];return n.x=a,n.y=i,n.z=o,n.w=u,n},E.setColumn=function(t,e,n,r){r=E.clone(t,r);var a=4*e;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r[a+3]=n.w,r},E.setTranslation=function(t,e,n){return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n[6]=t[6],n[7]=t[7],n[8]=t[8],n[9]=t[9],n[10]=t[10],n[11]=t[11],n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=t[15],n},E.getRow=function(t,e,n){var r=t[e],a=t[e+4],i=t[e+8],o=t[e+12];return n.x=r,n.y=a,n.z=i,n.w=o,n},E.setRow=function(t,e,n,r){return r=E.clone(t,r),r[e]=n.x,r[e+4]=n.y,r[e+8]=n.z,r[e+12]=n.w,r};var h=new t;E.getScale=function(e,n){return n.x=t.magnitude(t.fromElements(e[0],e[1],e[2],h)),n.y=t.magnitude(t.fromElements(e[4],e[5],e[6],h)),n.z=t.magnitude(t.fromElements(e[8],e[9],e[10],h)),n};var T=new t;E.getMaximumScale=function(e){return E.getScale(e,T),t.maximumComponent(T)},E.multiply=function(t,e,n){var r=t[0],a=t[1],i=t[2],o=t[3],u=t[4],s=t[5],c=t[6],E=t[7],_=t[8],l=t[9],f=t[10],h=t[11],T=t[12],R=t[13],d=t[14],A=t[15],p=e[0],m=e[1],N=e[2],y=e[3],I=e[4],S=e[5],M=e[6],O=e[7],C=e[8],w=e[9],v=e[10],g=e[11],P=e[12],x=e[13],F=e[14],U=e[15],L=r*p+u*m+_*N+T*y,D=a*p+s*m+l*N+R*y,B=i*p+c*m+f*N+d*y,z=o*p+E*m+h*N+A*y,b=r*I+u*S+_*M+T*O,G=a*I+s*S+l*M+R*O,V=i*I+c*S+f*M+d*O,X=o*I+E*S+h*M+A*O,q=r*C+u*w+_*v+T*g,W=a*C+s*w+l*v+R*g,H=i*C+c*w+f*v+d*g,Y=o*C+E*w+h*v+A*g,k=r*P+u*x+_*F+T*U,K=a*P+s*x+l*F+R*U,Z=i*P+c*x+f*F+d*U,j=o*P+E*x+h*F+A*U;return n[0]=L,n[1]=D,n[2]=B,n[3]=z,n[4]=b,n[5]=G,n[6]=V,n[7]=X,n[8]=q,n[9]=W,n[10]=H,n[11]=Y,n[12]=k,n[13]=K,n[14]=Z,n[15]=j,n},E.add=function(t,e,n){return n[0]=t[0]+e[0],n[1]=t[1]+e[1],n[2]=t[2]+e[2],n[3]=t[3]+e[3],n[4]=t[4]+e[4],n[5]=t[5]+e[5],n[6]=t[6]+e[6],n[7]=t[7]+e[7],n[8]=t[8]+e[8],n[9]=t[9]+e[9],n[10]=t[10]+e[10],n[11]=t[11]+e[11],n[12]=t[12]+e[12],n[13]=t[13]+e[13],n[14]=t[14]+e[14],n[15]=t[15]+e[15],n},E.subtract=function(t,e,n){return n[0]=t[0]-e[0],n[1]=t[1]-e[1],n[2]=t[2]-e[2],n[3]=t[3]-e[3],n[4]=t[4]-e[4],n[5]=t[5]-e[5],n[6]=t[6]-e[6],n[7]=t[7]-e[7],n[8]=t[8]-e[8],n[9]=t[9]-e[9],n[10]=t[10]-e[10],n[11]=t[11]-e[11],n[12]=t[12]-e[12],n[13]=t[13]-e[13],n[14]=t[14]-e[14],n[15]=t[15]-e[15],n},E.multiplyTransformation=function(t,e,n){var r=t[0],a=t[1],i=t[2],o=t[4],u=t[5],s=t[6],c=t[8],E=t[9],_=t[10],l=t[12],f=t[13],h=t[14],T=e[0],R=e[1],d=e[2],A=e[4],p=e[5],m=e[6],N=e[8],y=e[9],I=e[10],S=e[12],M=e[13],O=e[14],C=r*T+o*R+c*d,w=a*T+u*R+E*d,v=i*T+s*R+_*d,g=r*A+o*p+c*m,P=a*A+u*p+E*m,x=i*A+s*p+_*m,F=r*N+o*y+c*I,U=a*N+u*y+E*I,L=i*N+s*y+_*I,D=r*S+o*M+c*O+l,B=a*S+u*M+E*O+f,z=i*S+s*M+_*O+h;return n[0]=C,n[1]=w,n[2]=v,n[3]=0,n[4]=g,n[5]=P,n[6]=x,n[7]=0,n[8]=F,n[9]=U,n[10]=L,n[11]=0,n[12]=D,n[13]=B,n[14]=z,n[15]=1,n},E.multiplyByMatrix3=function(t,e,n){var r=t[0],a=t[1],i=t[2],o=t[4],u=t[5],s=t[6],c=t[8],E=t[9],_=t[10],l=e[0],f=e[1],h=e[2],T=e[3],R=e[4],d=e[5],A=e[6],p=e[7],m=e[8],N=r*l+o*f+c*h,y=a*l+u*f+E*h,I=i*l+s*f+_*h,S=r*T+o*R+c*d,M=a*T+u*R+E*d,O=i*T+s*R+_*d,C=r*A+o*p+c*m,w=a*A+u*p+E*m,v=i*A+s*p+_*m;return n[0]=N,n[1]=y,n[2]=I,n[3]=0,n[4]=S,n[5]=M,n[6]=O,n[7]=0,n[8]=C,n[9]=w,n[10]=v,n[11]=0,n[12]=t[12],n[13]=t[13],n[14]=t[14],n[15]=t[15],n},E.multiplyByTranslation=function(t,e,n){var r=e.x,a=e.y,i=e.z,o=r*t[0]+a*t[4]+i*t[8]+t[12],u=r*t[1]+a*t[5]+i*t[9]+t[13],s=r*t[2]+a*t[6]+i*t[10]+t[14];return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n[6]=t[6],n[7]=t[7],n[8]=t[8],n[9]=t[9],n[10]=t[10],n[11]=t[11],n[12]=o,n[13]=u,n[14]=s,n[15]=t[15],n};var R=new t;E.multiplyByUniformScale=function(t,e,n){return R.x=e,R.y=e,R.z=e,E.multiplyByScale(t,R,n)},E.multiplyByScale=function(t,e,n){var r=e.x,a=e.y,i=e.z;return 1===r&&1===a&&1===i?E.clone(t,n):(n[0]=r*t[0],n[1]=r*t[1],n[2]=r*t[2],n[3]=0,n[4]=a*t[4],n[5]=a*t[5],n[6]=a*t[6],n[7]=0,n[8]=i*t[8],n[9]=i*t[9],n[10]=i*t[10],n[11]=0,n[12]=t[12],n[13]=t[13],n[14]=t[14],n[15]=1,n)},E.multiplyByVector=function(t,e,n){var r=e.x,a=e.y,i=e.z,o=e.w,u=t[0]*r+t[4]*a+t[8]*i+t[12]*o,s=t[1]*r+t[5]*a+t[9]*i+t[13]*o,c=t[2]*r+t[6]*a+t[10]*i+t[14]*o,E=t[3]*r+t[7]*a+t[11]*i+t[15]*o;return n.x=u,n.y=s,n.z=c,n.w=E,n},E.multiplyByPointAsVector=function(t,e,n){var r=e.x,a=e.y,i=e.z,o=t[0]*r+t[4]*a+t[8]*i,u=t[1]*r+t[5]*a+t[9]*i,s=t[2]*r+t[6]*a+t[10]*i;return n.x=o,n.y=u,n.z=s,n},E.multiplyByPoint=function(t,e,n){var r=e.x,a=e.y,i=e.z,o=t[0]*r+t[4]*a+t[8]*i+t[12],u=t[1]*r+t[5]*a+t[9]*i+t[13],s=t[2]*r+t[6]*a+t[10]*i+t[14];return n.x=o,n.y=u,n.z=s,n},E.multiplyByScalar=function(t,e,n){return n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n[4]=t[4]*e,n[5]=t[5]*e,n[6]=t[6]*e,n[7]=t[7]*e,n[8]=t[8]*e,n[9]=t[9]*e,n[10]=t[10]*e,n[11]=t[11]*e,n[12]=t[12]*e,n[13]=t[13]*e,n[14]=t[14]*e,n[15]=t[15]*e,n},E.negate=function(t,e){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e[9]=-t[9],e[10]=-t[10],e[11]=-t[11],e[12]=-t[12],e[13]=-t[13],e[14]=-t[14],e[15]=-t[15],e},E.transpose=function(t,e){var n=t[1],r=t[2],a=t[3],i=t[6],o=t[7],u=t[11];return e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=n,e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=r,e[9]=i,e[10]=t[10],e[11]=t[14],e[12]=a,e[13]=o,e[14]=u,e[15]=t[15],e},E.abs=function(t,e){return e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e[9]=Math.abs(t[9]),e[10]=Math.abs(t[10]),e[11]=Math.abs(t[11]),e[12]=Math.abs(t[12]),e[13]=Math.abs(t[13]),e[14]=Math.abs(t[14]),e[15]=Math.abs(t[15]),e},E.equals=function(t,e){return t===e||a(t)&&a(e)&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[3]===e[3]&&t[7]===e[7]&&t[11]===e[11]&&t[15]===e[15]},E.equalsEpsilon=function(t,e,n){return t===e||a(t)&&a(e)&&Math.abs(t[0]-e[0])<=n&&Math.abs(t[1]-e[1])<=n&&Math.abs(t[2]-e[2])<=n&&Math.abs(t[3]-e[3])<=n&&Math.abs(t[4]-e[4])<=n&&Math.abs(t[5]-e[5])<=n&&Math.abs(t[6]-e[6])<=n&&Math.abs(t[7]-e[7])<=n&&Math.abs(t[8]-e[8])<=n&&Math.abs(t[9]-e[9])<=n&&Math.abs(t[10]-e[10])<=n&&Math.abs(t[11]-e[11])<=n&&Math.abs(t[12]-e[12])<=n&&Math.abs(t[13]-e[13])<=n&&Math.abs(t[14]-e[14])<=n&&Math.abs(t[15]-e[15])<=n},E.getTranslation=function(t,e){return e.x=t[12],e.y=t[13],e.z=t[14],e},E.getRotation=function(t,e){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[4],e[4]=t[5],e[5]=t[6],e[6]=t[8],e[7]=t[9],e[8]=t[10],e};var d=new s,A=new s,p=new e,m=new e(0,0,0,1);return E.inverse=function(t,n){if(s.equalsEpsilon(E.getRotation(t,d),A,u.EPSILON7)&&e.equals(E.getRow(t,3,p),m))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-t[12],n[13]=-t[13],n[14]=-t[14],n[15]=1,n;var r=t[0],a=t[4],i=t[8],o=t[12],_=t[1],l=t[5],f=t[9],h=t[13],T=t[2],R=t[6],N=t[10],y=t[14],I=t[3],S=t[7],M=t[11],O=t[15],C=N*O,w=y*M,v=R*O,g=y*S,P=R*M,x=N*S,F=T*O,U=y*I,L=T*M,D=N*I,B=T*S,z=R*I,b=C*l+g*f+P*h-(w*l+v*f+x*h),G=w*_+F*f+D*h-(C*_+U*f+L*h),V=v*_+U*l+B*h-(g*_+F*l+z*h),X=x*_+L*l+z*f-(P*_+D*l+B*f),q=w*a+v*i+x*o-(C*a+g*i+P*o),W=C*r+U*i+L*o-(w*r+F*i+D*o),H=g*r+F*a+z*o-(v*r+U*a+B*o),Y=P*r+D*a+B*i-(x*r+L*a+z*i);C=i*h,w=o*f,v=a*h,g=o*l,P=a*f,x=i*l,F=r*h,U=o*_,L=r*f,D=i*_,B=r*l,z=a*_;var k=C*S+g*M+P*O-(w*S+v*M+x*O),K=w*I+F*M+D*O-(C*I+U*M+L*O),Z=v*I+U*S+B*O-(g*I+F*S+z*O),j=x*I+L*S+z*M-(P*I+D*S+B*M),Q=v*N+x*y+w*R-(P*y+C*R+g*N),J=L*y+C*T+U*N-(F*N+D*y+w*T),$=F*R+z*y+g*T-(B*y+v*T+U*R),tt=B*N+P*T+D*R-(L*R+z*N+x*T),et=r*b+a*G+i*V+o*X;if(Math.abs(et)<u.EPSILON20)throw new c("matrix is not invertible because its determinate is zero.");return et=1/et,n[0]=b*et,n[1]=G*et,n[2]=V*et,n[3]=X*et,n[4]=q*et,n[5]=W*et,n[6]=H*et,n[7]=Y*et,n[8]=k*et,n[9]=K*et,n[10]=Z*et,n[11]=j*et,n[12]=Q*et,n[13]=J*et,n[14]=$*et,n[15]=tt*et,n},E.inverseTransformation=function(t,e){var n=t[0],r=t[1],a=t[2],i=t[4],o=t[5],u=t[6],s=t[8],c=t[9],E=t[10],_=t[12],l=t[13],f=t[14],h=-n*_-r*l-a*f,T=-i*_-o*l-u*f,R=-s*_-c*l-E*f;return e[0]=n,e[1]=i,e[2]=s,e[3]=0,e[4]=r,e[5]=o,e[6]=c,e[7]=0,e[8]=a,e[9]=u,e[10]=E,e[11]=0,e[12]=h,e[13]=T,e[14]=R,e[15]=1,e},E.IDENTITY=o(new E(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),E.ZERO=o(new E(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN0ROW3=3,E.COLUMN1ROW0=4,E.COLUMN1ROW1=5,E.COLUMN1ROW2=6,E.COLUMN1ROW3=7,E.COLUMN2ROW0=8,E.COLUMN2ROW1=9,E.COLUMN2ROW2=10,E.COLUMN2ROW3=11,E.COLUMN3ROW0=12,E.COLUMN3ROW1=13,E.COLUMN3ROW2=14,E.COLUMN3ROW3=15,i(E.prototype,{length:{get:function(){return E.packedLength}}}),E.prototype.clone=function(t){return E.clone(this,t)},E.prototype.equals=function(t){return E.equals(this,t)},E.equalsArray=function(t,e,n){return t[0]===e[n]&&t[1]===e[n+1]&&t[2]===e[n+2]&&t[3]===e[n+3]&&t[4]===e[n+4]&&t[5]===e[n+5]&&t[6]===e[n+6]&&t[7]===e[n+7]&&t[8]===e[n+8]&&t[9]===e[n+9]&&t[10]===e[n+10]&&t[11]===e[n+11]&&t[12]===e[n+12]&&t[13]===e[n+13]&&t[14]===e[n+14]&&t[15]===e[n+15]},E.prototype.equalsEpsilon=function(t,e){return E.equalsEpsilon(this,t,e)},E.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},E}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(t,e,n,r,a,i,o,u){"use strict";function s(t,e,r,a){this.west=n(t,0),this.south=n(e,0),this.east=n(r,0),this.north=n(a,0)}a(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(t,e,r){return r=n(r,0),e[r++]=t.west,e[r++]=t.south,e[r++]=t.east,e[r]=t.north,e},s.unpack=function(t,e,a){return e=n(e,0),r(a)||(a=new s),a.west=t[e++],a.south=t[e++],a.east=t[e++],a.north=t[e],a},s.computeWidth=function(t){var e=t.east,n=t.west;return e<n&&(e+=u.TWO_PI),e-n},s.computeHeight=function(t){return t.north-t.south},s.fromDegrees=function(t,e,a,i,o){return t=u.toRadians(n(t,0)),e=u.toRadians(n(e,0)),a=u.toRadians(n(a,0)),i=u.toRadians(n(i,0)),r(o)?(o.west=t,o.south=e,o.east=a,o.north=i,o):new s(t,e,a,i)},s.fromRadians=function(t,e,a,i,o){return r(o)?(o.west=n(t,0),o.south=n(e,0),o.east=n(a,0),o.north=n(i,0),o):new s(t,e,a,i)},s.fromCartographicArray=function(t,e){for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,E=-Number.MAX_VALUE,_=0,l=t.length;_<l;_++){var f=t[_];n=Math.min(n,f.longitude),a=Math.max(a,f.longitude),c=Math.min(c,f.latitude),E=Math.max(E,f.latitude);var h=f.longitude>=0?f.longitude:f.longitude+u.TWO_PI;i=Math.min(i,h),o=Math.max(o,h)}return a-n>o-i&&(n=i,a=o,a>u.PI&&(a-=u.TWO_PI),n>u.PI&&(n-=u.TWO_PI)),r(e)?(e.west=n,e.south=c,e.east=a,e.north=E,e):new s(n,c,a,E)},s.fromCartesianArray=function(t,e,a){e=n(e,i.WGS84);for(var o=Number.MAX_VALUE,c=-Number.MAX_VALUE,E=Number.MAX_VALUE,_=-Number.MAX_VALUE,l=Number.MAX_VALUE,f=-Number.MAX_VALUE,h=0,T=t.length;h<T;h++){var R=e.cartesianToCartographic(t[h]);o=Math.min(o,R.longitude),c=Math.max(c,R.longitude),l=Math.min(l,R.latitude),f=Math.max(f,R.latitude);var d=R.longitude>=0?R.longitude:R.longitude+u.TWO_PI;E=Math.min(E,d),_=Math.max(_,d)}return c-o>_-E&&(o=E,c=_,c>u.PI&&(c-=u.TWO_PI),o>u.PI&&(o-=u.TWO_PI)),r(a)?(a.west=o,a.south=l,a.east=c,a.north=f,a):new s(o,l,c,f)},s.clone=function(t,e){if(r(t))return r(e)?(e.west=t.west,e.south=t.south,e.east=t.east,e.north=t.north,e):new s(t.west,t.south,t.east,t.north)},s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.equals=function(t,e){return t===e||r(t)&&r(e)&&t.west===e.west&&t.south===e.south&&t.east===e.east&&t.north===e.north},s.prototype.equalsEpsilon=function(t,e){return r(t)&&Math.abs(this.west-t.west)<=e&&Math.abs(this.south-t.south)<=e&&Math.abs(this.east-t.east)<=e&&Math.abs(this.north-t.north)<=e},s.validate=function(t){},s.southwest=function(e,n){return r(n)?(n.longitude=e.west,n.latitude=e.south,n.height=0,n):new t(e.west,e.south)},s.northwest=function(e,n){return r(n)?(n.longitude=e.west,n.latitude=e.north,n.height=0,n):new t(e.west,e.north)},s.northeast=function(e,n){return r(n)?(n.longitude=e.east,n.latitude=e.north,n.height=0,n):new t(e.east,e.north)},s.southeast=function(e,n){return r(n)?(n.longitude=e.east,n.latitude=e.south,n.height=0,n):new t(e.east,e.south)},s.center=function(e,n){var a=e.east,i=e.west;a<i&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(e.south+e.north);return r(n)?(n.longitude=o,n.latitude=s,n.height=0,n):new t(o,s)},s.intersection=function(t,e,n){var a=t.east,i=t.west,o=e.east,c=e.west;a<i&&o>0?a+=u.TWO_PI:o<c&&a>0&&(o+=u.TWO_PI),a<i&&c<0?c+=u.TWO_PI:o<c&&i<0&&(i+=u.TWO_PI);var E=u.negativePiToPi(Math.max(i,c)),_=u.negativePiToPi(Math.min(a,o));if(!((t.west<t.east||e.west<e.east)&&_<=E)){var l=Math.max(t.south,e.south),f=Math.min(t.north,e.north);if(!(l>=f))return r(n)?(n.west=E,n.south=l,n.east=_,n.north=f,n):new s(E,l,_,f)}},s.simpleIntersection=function(t,e,n){var a=Math.max(t.west,e.west),i=Math.max(t.south,e.south),o=Math.min(t.east,e.east),u=Math.min(t.north,e.north);if(!(i>=u||a>=o))return r(n)?(n.west=a,n.south=i,n.east=o,n.north=u,n):new s(a,i,o,u)},s.union=function(t,e,n){r(n)||(n=new s);var a=t.east,i=t.west,o=e.east,c=e.west;a<i&&o>0?a+=u.TWO_PI:o<c&&a>0&&(o+=u.TWO_PI),a<i&&c<0?c+=u.TWO_PI:o<c&&i<0&&(i+=u.TWO_PI);var E=u.convertLongitudeRange(Math.min(i,c)),_=u.convertLongitudeRange(Math.max(a,o));return n.west=E,n.south=Math.min(t.south,e.south),n.east=_,n.north=Math.max(t.north,e.north),n},s.expand=function(t,e,n){return r(n)||(n=new s),n.west=Math.min(t.west,e.longitude),n.south=Math.min(t.south,e.latitude),n.east=Math.max(t.east,e.longitude),n.north=Math.max(t.north,e.latitude),n},s.contains=function(t,e){var n=e.longitude,r=e.latitude,a=t.west,i=t.east;return i<a&&(i+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(n<i||u.equalsEpsilon(n,i,u.EPSILON14))&&r>=t.south&&r<=t.north};var c=new t;return s.subsample=function(t,e,a,o){e=n(e,i.WGS84),a=n(a,0),r(o)||(o=[]);var E=0,_=t.north,l=t.south,f=t.east,h=t.west,T=c;T.height=a,T.longitude=h,T.latitude=_,o[E]=e.cartographicToCartesian(T,o[E]),E++,T.longitude=f,o[E]=e.cartographicToCartesian(T,o[E]),E++,T.latitude=l,o[E]=e.cartographicToCartesian(T,o[E]),E++,T.longitude=h,o[E]=e.cartographicToCartesian(T,o[E]),E++,T.latitude=_<0?_:l>0?l:0;for(var R=1;R<8;++R)T.longitude=-Math.PI+R*u.PI_OVER_TWO,s.contains(t,T)&&(o[E]=e.cartographicToCartesian(T,o[E]),E++);return 0===T.latitude&&(T.longitude=h,o[E]=e.cartographicToCartesian(T,o[E]),E++,T.longitude=f,o[E]=e.cartographicToCartesian(T,o[E]),E++),o.length=E,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],function(t,e,n,r,a,i,o,u,s,c,E,_,l){"use strict";function f(e,n){this.center=t.clone(r(e,t.ZERO)),this.radius=r(n,0)}var h=new t,T=new t,R=new t,d=new t,A=new t,p=new t,m=new t,N=new t,y=new t,I=new t,S=new t,M=new t,O=4/3*c.PI;f.fromPoints=function(e,n){if(a(n)||(n=new f),!a(e)||0===e.length)return n.center=t.clone(t.ZERO,n.center),n.radius=0,n;var r,i=t.clone(e[0],m),o=t.clone(i,h),u=t.clone(i,T),s=t.clone(i,R),c=t.clone(i,d),E=t.clone(i,A),_=t.clone(i,p),l=e.length;for(r=1;r<l;r++){t.clone(e[r],i);var O=i.x,C=i.y,w=i.z;O<o.x&&t.clone(i,o),O>c.x&&t.clone(i,c),C<u.y&&t.clone(i,u),C>E.y&&t.clone(i,E),w<s.z&&t.clone(i,s),w>_.z&&t.clone(i,_)}var v=t.magnitudeSquared(t.subtract(c,o,N)),g=t.magnitudeSquared(t.subtract(E,u,N)),P=t.magnitudeSquared(t.subtract(_,s,N)),x=o,F=c,U=v;g>U&&(U=g,x=u,F=E),P>U&&(U=P,x=s,F=_);var L=y;L.x=.5*(x.x+F.x),L.y=.5*(x.y+F.y),L.z=.5*(x.z+F.z);var D=t.magnitudeSquared(t.subtract(F,L,N)),B=Math.sqrt(D),z=I;z.x=o.x,z.y=u.y,z.z=s.z;var b=S;b.x=c.x,b.y=E.y,b.z=_.z;var G=t.multiplyByScalar(t.add(z,b,N),.5,M),V=0;for(r=0;r<l;r++){t.clone(e[r],i);var X=t.magnitude(t.subtract(i,G,N));X>V&&(V=X);var q=t.magnitudeSquared(t.subtract(i,L,N));if(q>D){var W=Math.sqrt(q);B=.5*(B+W),D=B*B;var H=W-B;L.x=(B*L.x+H*i.x)/W,L.y=(B*L.y+H*i.y)/W,L.z=(B*L.z+H*i.z)/W}}return B<V?(t.clone(L,n.center),n.radius=B):(t.clone(G,n.center),n.radius=V),n};var C=new o,w=new t,v=new t,g=new e,P=new e;f.fromRectangle2D=function(t,e,n){return f.fromRectangleWithHeights2D(t,e,0,0,n)},f.fromRectangleWithHeights2D=function(e,n,i,o,u){if(a(u)||(u=new f),!a(e))return u.center=t.clone(t.ZERO,u.center),u.radius=0,u;n=r(n,C),l.southwest(e,g),g.height=i,l.northeast(e,P),P.height=o;var s=n.project(g,w),c=n.project(P,v),E=c.x-s.x,_=c.y-s.y,h=c.z-s.z;u.radius=.5*Math.sqrt(E*E+_*_+h*h);var T=u.center;return T.x=s.x+.5*E,T.y=s.y+.5*_,T.z=s.z+.5*h,u};var x=[];f.fromRectangle3D=function(e,n,o,u){if(n=r(n,i.WGS84),o=r(o,0),a(u)||(u=new f),!a(e))return u.center=t.clone(t.ZERO,u.center),u.radius=0,u;var s=l.subsample(e,n,o,x);return f.fromPoints(s,u)},f.fromVertices=function(e,n,i,o){if(a(o)||(o=new f),!a(e)||0===e.length)return o.center=t.clone(t.ZERO,o.center),o.radius=0,o;n=r(n,t.ZERO),i=r(i,3);var u=m;u.x=e[0]+n.x,u.y=e[1]+n.y,u.z=e[2]+n.z;var s,c=t.clone(u,h),E=t.clone(u,T),_=t.clone(u,R),l=t.clone(u,d),O=t.clone(u,A),C=t.clone(u,p),w=e.length;for(s=0;s<w;s+=i){var v=e[s]+n.x,g=e[s+1]+n.y,P=e[s+2]+n.z;u.x=v,u.y=g,u.z=P,v<c.x&&t.clone(u,c),v>l.x&&t.clone(u,l),g<E.y&&t.clone(u,E),g>O.y&&t.clone(u,O),P<_.z&&t.clone(u,_),P>C.z&&t.clone(u,C)}var x=t.magnitudeSquared(t.subtract(l,c,N)),F=t.magnitudeSquared(t.subtract(O,E,N)),U=t.magnitudeSquared(t.subtract(C,_,N)),L=c,D=l,B=x;F>B&&(B=F,L=E,D=O),U>B&&(B=U,L=_,D=C);var z=y;z.x=.5*(L.x+D.x),z.y=.5*(L.y+D.y),z.z=.5*(L.z+D.z);var b=t.magnitudeSquared(t.subtract(D,z,N)),G=Math.sqrt(b),V=I;V.x=c.x,V.y=E.y,V.z=_.z;var X=S;X.x=l.x,X.y=O.y,X.z=C.z;var q=t.multiplyByScalar(t.add(V,X,N),.5,M),W=0;for(s=0;s<w;s+=i){u.x=e[s]+n.x,u.y=e[s+1]+n.y,u.z=e[s+2]+n.z;var H=t.magnitude(t.subtract(u,q,N));H>W&&(W=H);var Y=t.magnitudeSquared(t.subtract(u,z,N));if(Y>b){var k=Math.sqrt(Y);G=.5*(G+k),b=G*G;var K=k-G;z.x=(G*z.x+K*u.x)/k,z.y=(G*z.y+K*u.y)/k,z.z=(G*z.z+K*u.z)/k}}return G<W?(t.clone(z,o.center),o.radius=G):(t.clone(q,o.center),o.radius=W),o},f.fromEncodedCartesianVertices=function(e,n,r){if(a(r)||(r=new f),!a(e)||!a(n)||e.length!==n.length||0===e.length)return r.center=t.clone(t.ZERO,r.center),r.radius=0,r;var i=m;i.x=e[0]+n[0],i.y=e[1]+n[1],i.z=e[2]+n[2];var o,u=t.clone(i,h),s=t.clone(i,T),c=t.clone(i,R),E=t.clone(i,d),_=t.clone(i,A),l=t.clone(i,p),O=e.length;for(o=0;o<O;o+=3){var C=e[o]+n[o],w=e[o+1]+n[o+1],v=e[o+2]+n[o+2];i.x=C,i.y=w,i.z=v,C<u.x&&t.clone(i,u),C>E.x&&t.clone(i,E),w<s.y&&t.clone(i,s),w>_.y&&t.clone(i,_),v<c.z&&t.clone(i,c),v>l.z&&t.clone(i,l)}var g=t.magnitudeSquared(t.subtract(E,u,N)),P=t.magnitudeSquared(t.subtract(_,s,N)),x=t.magnitudeSquared(t.subtract(l,c,N)),F=u,U=E,L=g;P>L&&(L=P,F=s,U=_),x>L&&(L=x,F=c,U=l);var D=y;D.x=.5*(F.x+U.x),D.y=.5*(F.y+U.y),D.z=.5*(F.z+U.z);var B=t.magnitudeSquared(t.subtract(U,D,N)),z=Math.sqrt(B),b=I;b.x=u.x,b.y=s.y,b.z=c.z;var G=S;G.x=E.x,G.y=_.y,G.z=l.z;var V=t.multiplyByScalar(t.add(b,G,N),.5,M),X=0;for(o=0;o<O;o+=3){i.x=e[o]+n[o],i.y=e[o+1]+n[o+1],i.z=e[o+2]+n[o+2];var q=t.magnitude(t.subtract(i,V,N));q>X&&(X=q);var W=t.magnitudeSquared(t.subtract(i,D,N));if(W>B){var H=Math.sqrt(W);z=.5*(z+H),B=z*z;var Y=H-z;D.x=(z*D.x+Y*i.x)/H,D.y=(z*D.y+Y*i.y)/H,D.z=(z*D.z+Y*i.z)/H}}return z<X?(t.clone(D,r.center),r.radius=z):(t.clone(V,r.center),r.radius=X),r},f.fromCornerPoints=function(e,n,r){a(r)||(r=new f);var i=r.center;return t.add(e,n,i),t.multiplyByScalar(i,.5,i),r.radius=t.distance(i,n),r},f.fromEllipsoid=function(e,n){return a(n)||(n=new f),t.clone(t.ZERO,n.center),n.radius=e.maximumRadius,n};var F=new t;f.fromBoundingSpheres=function(e,n){if(a(n)||(n=new f),!a(e)||0===e.length)return n.center=t.clone(t.ZERO,n.center),n.radius=0,n;var r=e.length;if(1===r)return f.clone(e[0],n);if(2===r)return f.union(e[0],e[1],n);var i,o=[];for(i=0;i<r;i++)o.push(e[i].center);n=f.fromPoints(o,n);var u=n.center,s=n.radius;for(i=0;i<r;i++){var c=e[i];s=Math.max(s,t.distance(u,c.center,F)+c.radius)}return n.radius=s,n};var U=new t,L=new t,D=new t;f.fromOrientedBoundingBox=function(e,n){a(n)||(n=new f);var r=e.halfAxes,i=E.getColumn(r,0,U),o=E.getColumn(r,1,L),u=E.getColumn(r,2,D);return t.add(i,o,i),t.add(i,u,i),n.center=t.clone(e.center,n.center),n.radius=t.magnitude(i),n},f.clone=function(e,n){if(a(e))return a(n)?(n.center=t.clone(e.center,n.center),n.radius=e.radius,n):new f(e.center,e.radius)},f.packedLength=4,f.pack=function(t,e,n){n=r(n,0);var a=t.center;return e[n++]=a.x,e[n++]=a.y,e[n++]=a.z,e[n]=t.radius,e},f.unpack=function(t,e,n){e=r(e,0),a(n)||(n=new f);var i=n.center;return i.x=t[e++],i.y=t[e++],i.z=t[e++],n.radius=t[e],n};var B=new t,z=new t;f.union=function(e,n,r){a(r)||(r=new f);var i=e.center,o=e.radius,u=n.center,s=n.radius,c=t.subtract(u,i,B),E=t.magnitude(c);if(o>=E+s)return e.clone(r),r;if(s>=E+o)return n.clone(r),r;var _=.5*(o+E+s),l=t.multiplyByScalar(c,(-o+_)/E,z);return t.add(l,i,l),t.clone(l,r.center),r.radius=_,r};var b=new t;f.expand=function(e,n,r){r=f.clone(e,r);var a=t.magnitude(t.subtract(n,r.center,b));return a>r.radius&&(r.radius=a),r},f.intersectPlane=function(e,n){var r=e.center,a=e.radius,i=n.normal,o=t.dot(i,r)+n.distance;return o<-a?u.OUTSIDE:o<a?u.INTERSECTING:u.INSIDE},f.transform=function(t,e,n){return a(n)||(n=new f),n.center=_.multiplyByPoint(e,t.center,n.center),n.radius=_.getMaximumScale(e)*t.radius,n};var G=new t;f.distanceSquaredTo=function(e,n){var r=t.subtract(e.center,n,G);return t.magnitudeSquared(r)-e.radius*e.radius},f.transformWithoutScale=function(t,e,n){return a(n)||(n=new f),n.center=_.multiplyByPoint(e,t.center,n.center),n.radius=t.radius,n};var V=new t;f.computePlaneDistances=function(e,n,r,i){a(i)||(i=new s);var o=t.subtract(e.center,n,V),u=t.dot(r,o);return i.start=u-e.radius,i.stop=u+e.radius,i};for(var X=new t,q=new t,W=new t,H=new t,Y=new t,k=new e,K=new Array(8),Z=0;Z<8;++Z)K[Z]=new t;var j=new o;return f.projectTo2D=function(e,n,a){n=r(n,j);var i=n.ellipsoid,o=e.center,u=e.radius,s=i.geodeticSurfaceNormal(o,X),c=t.cross(t.UNIT_Z,s,q);t.normalize(c,c);var E=t.cross(s,c,W);t.normalize(E,E),t.multiplyByScalar(s,u,s),t.multiplyByScalar(E,u,E),t.multiplyByScalar(c,u,c);var _=t.negate(E,Y),l=t.negate(c,H),h=K,T=h[0];t.add(s,E,T),t.add(T,c,T),T=h[1],t.add(s,E,T),t.add(T,l,T),T=h[2],t.add(s,_,T),t.add(T,l,T),T=h[3],t.add(s,_,T),t.add(T,c,T),t.negate(s,s),T=h[4],t.add(s,E,T),t.add(T,c,T),T=h[5],t.add(s,E,T),t.add(T,l,T),T=h[6],t.add(s,_,T),t.add(T,l,T),T=h[7],t.add(s,_,T),t.add(T,c,T);for(var R=h.length,d=0;d<R;++d){var A=h[d];t.add(o,A,A);var p=i.cartesianToCartographic(A,k);n.project(p,A)}a=f.fromPoints(h,a),o=a.center;var m=o.x,N=o.y,y=o.z;return o.x=y,o.y=m,o.z=N,a},f.isOccluded=function(t,e){return!e.isBoundingSphereVisible(t)},f.equals=function(e,n){return e===n||a(e)&&a(n)&&t.equals(e.center,n.center)&&e.radius===n.radius},f.prototype.intersectPlane=function(t){return f.intersectPlane(this,t)},f.prototype.distanceSquaredTo=function(t){return f.distanceSquaredTo(this,t)},f.prototype.computePlaneDistances=function(t,e,n){return f.computePlaneDistances(this,t,e,n)},f.prototype.isOccluded=function(t){return f.isOccluded(this,t)},f.prototype.equals=function(t){return f.equals(this,t)},f.prototype.clone=function(t){return f.clone(this,t)},f.prototype.volume=function(){var t=this.radius;return O*t*t*t},f}),define("Core/Fullscreen",["./defined","./defineProperties"],function(t,e){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return e(a,{element:{get:function(){if(a.supportsFullscreen())return document[r.fullscreenElement]}},changeEventName:{get:function(){if(a.supportsFullscreen())return r.fullscreenchange}},errorEventName:{get:function(){if(a.supportsFullscreen())return r.fullscreenerror}},enabled:{get:function(){if(a.supportsFullscreen())return document[r.fullscreenEnabled]}},fullscreen:{get:function(){if(a.supportsFullscreen())return null!==a.element}}}),a.supportsFullscreen=function(){if(t(n))return n;n=!1;var e=document.body;if("function"==typeof e.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;o<u;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof e[a]?(r.requestFullscreen=a,n=!0):(a=s+"RequestFullScreen","function"==typeof e[a]&&(r.requestFullscreen=a,n=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?r.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(r.exitFullscreen=a)),a=s+"FullscreenEnabled",void 0!==document[a]?r.fullscreenEnabled=a:(a=s+"FullScreenEnabled",void 0!==document[a]&&(r.fullscreenEnabled=a)),a=s+"FullscreenElement",void 0!==document[a]?r.fullscreenElement=a:(a=s+"FullScreenElement",void 0!==document[a]&&(r.fullscreenElement=a)),a=s+"fullscreenchange",void 0!==document["on"+a]&&("ms"===s&&(a="MSFullscreenChange"),r.fullscreenchange=a),a=s+"fullscreenerror",void 0!==document["on"+a]&&("ms"===s&&(a="MSFullscreenError"),r.fullscreenerror=a)}return n},
a.requestFullscreen=function(t,e){a.supportsFullscreen()&&t[r.requestFullscreen]({vrDisplay:e})},a.exitFullscreen=function(){a.supportsFullscreen()&&document[r.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(t,e,n){"use strict";function r(t){for(var e=t.split("."),n=0,r=e.length;n<r;++n)e[n]=parseInt(e[n],10);return e}function a(){if(!e(y)&&(y=!1,!l())){var t=/ Chrome\/([\.0-9]+)/.exec(N.userAgent);null!==t&&(y=!0,I=r(t[1]))}return y}function i(){return a()&&I}function o(){if(!e(S)&&(S=!1,!a()&&!l()&&/ Safari\/[\.0-9]+/.test(N.userAgent))){var t=/ Version\/([\.0-9]+)/.exec(N.userAgent);null!==t&&(S=!0,M=r(t[1]))}return S}function u(){return o()&&M}function s(){if(!e(O)){O=!1;var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(N.userAgent);null!==t&&(O=!0,C=r(t[1]),C.isNightly=!!t[2])}return O}function c(){return s()&&C}function E(){if(!e(w)){w=!1;var t;"Microsoft Internet Explorer"===N.appName?null!==(t=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(N.userAgent))&&(w=!0,v=r(t[1])):"Netscape"===N.appName&&null!==(t=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(N.userAgent))&&(w=!0,v=r(t[1]))}return w}function _(){return E()&&v}function l(){if(!e(g)){g=!1;var t=/ Edge\/([\.0-9]+)/.exec(N.userAgent);null!==t&&(g=!0,P=r(t[1]))}return g}function f(){return l()&&P}function h(){if(!e(x)){x=!1;var t=/Firefox\/([\.0-9]+)/.exec(N.userAgent);null!==t&&(x=!0,F=r(t[1]))}return x}function T(){return e(U)||(U=/Windows/i.test(N.appVersion)),U}function R(){return h()&&F}function d(){return e(L)||(L="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),L}function A(){return e(D)||(D="undefined"!=typeof PointerEvent&&(!e(N.pointerEnabled)||N.pointerEnabled)),D}function p(){if(!e(z)){var t=document.createElement("canvas");t.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var n=t.style.imageRendering;z=e(n)&&""!==n,z&&(B=n)}return z}function m(){return p()?B:void 0}var N;N="undefined"!=typeof navigator?navigator:{};var y,I,S,M,O,C,w,v,g,P,x,F,U,L,D,B,z,b=[];"undefined"!=typeof ArrayBuffer&&(b.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&b.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&b.push(CanvasPixelArray));var G={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:E,internetExplorerVersion:_,isEdge:l,edgeVersion:f,isFirefox:h,firefoxVersion:R,isWindows:T,isNodeJs:d,hardwareConcurrency:t(N.hardwareConcurrency,3),supportsPointerEvents:A,supportsImageRenderingPixelated:p,imageRenderingValue:m,typedArrayTypes:b};return G.supportsFullscreen=function(){return n.supportsFullscreen()},G.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},G.supportsWebWorkers=function(){return"undefined"!=typeof Worker},G.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!G.isEdge()},G}),define("Core/WebGLConstants",["./freezeObject"],function(t){"use strict";return t({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(t,e,n,r,a,i){"use strict";if(!r.supportsTypedArrays())return{};var o={BYTE:i.BYTE,UNSIGNED_BYTE:i.UNSIGNED_BYTE,SHORT:i.SHORT,UNSIGNED_SHORT:i.UNSIGNED_SHORT,INT:i.INT,UNSIGNED_INT:i.UNSIGNED_INT,FLOAT:i.FLOAT,DOUBLE:i.DOUBLE};return o.getSizeInBytes=function(t){switch(t){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},o.fromTypedArray=function(t){return t instanceof Int8Array?o.BYTE:t instanceof Uint8Array?o.UNSIGNED_BYTE:t instanceof Int16Array?o.SHORT:t instanceof Uint16Array?o.UNSIGNED_SHORT:t instanceof Int32Array?o.INT:t instanceof Uint32Array?o.UNSIGNED_INT:t instanceof Float32Array?o.FLOAT:t instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(t){return e(t)&&(t===o.BYTE||t===o.UNSIGNED_BYTE||t===o.SHORT||t===o.UNSIGNED_SHORT||t===o.INT||t===o.UNSIGNED_INT||t===o.FLOAT||t===o.DOUBLE)},o.createTypedArray=function(t,e){switch(t){case o.BYTE:return new Int8Array(e);case o.UNSIGNED_BYTE:return new Uint8Array(e);case o.SHORT:return new Int16Array(e);case o.UNSIGNED_SHORT:return new Uint16Array(e);case o.INT:return new Int32Array(e);case o.UNSIGNED_INT:return new Uint32Array(e);case o.FLOAT:return new Float32Array(e);case o.DOUBLE:return new Float64Array(e)}},o.createArrayBufferView=function(e,n,r,a){switch(r=t(r,0),a=t(a,(n.byteLength-r)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(n,r,a);case o.UNSIGNED_BYTE:return new Uint8Array(n,r,a);case o.SHORT:return new Int16Array(n,r,a);case o.UNSIGNED_SHORT:return new Uint16Array(n,r,a);case o.INT:return new Int32Array(n,r,a);case o.UNSIGNED_INT:return new Uint32Array(n,r,a);case o.FLOAT:return new Float32Array(n,r,a);case o.DOUBLE:return new Float64Array(n,r,a)}},o.fromName=function(t){switch(t){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE}},a(o)}),define("Core/GeometryType",["./freezeObject"],function(t){"use strict";return t({NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3})}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(t,e){"use strict";var n={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(t){return t===n.POINTS||t===n.LINES||t===n.LINE_LOOP||t===n.LINE_STRIP||t===n.TRIANGLES||t===n.TRIANGLE_STRIP||t===n.TRIANGLE_FAN}};return t(n)}),define("Core/Geometry",["./Check","./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(t,e,n,r,a,i){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,i.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,a.NONE),this.boundingSphereCV=t.boundingSphereCV}return o.computeNumberOfVertices=function(t){var e=-1;for(var r in t.attributes)if(t.attributes.hasOwnProperty(r)&&n(t.attributes[r])&&n(t.attributes[r].values)){var a=t.attributes[r],i=a.values.length/a.componentsPerAttribute;e=i}return e},o}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(t,e,n){"use strict";function r(e){e=t(e,t.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=t(e.normalize,!1),this.values=e.values}return r}),define("Core/GeometryAttributes",["./defaultValue"],function(t){"use strict";function e(e){e=t(e,t.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.bitangent=e.bitangent,this.tangent=e.tangent,this.color=e.color}return e}),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],function(t,e,n,r,a,i,o){"use strict";function u(e,n){this.normal=t.clone(e),this.distance=n}u.fromPointNormal=function(e,r,a){var i=-t.dot(r,e);return n(a)?(t.clone(r,a.normal),a.distance=i,a):new u(r,i)};var s=new t;u.fromCartesian4=function(e,r){var a=t.fromCartesian4(e,s),i=e.w;return n(r)?(t.clone(a,r.normal),r.distance=i,r):new u(a,i)},u.getPointDistance=function(e,n){return t.dot(e.normal,n)+e.distance};var c=new t;u.projectPointOntoPlane=function(e,r,a){n(a)||(a=new t);var i=u.getPointDistance(e,r),o=t.multiplyByScalar(e.normal,i,c);return t.subtract(r,o,a)};var E=new t;return u.transform=function(e,n,r){return o.multiplyByPointAsVector(n,e.normal,s),t.normalize(s,s),t.multiplyByScalar(e.normal,-e.distance,E),o.multiplyByPoint(n,E,E),u.fromPointNormal(E,s,r)},u.clone=function(e,r){return n(r)?(t.clone(e.normal,r.normal),r.distance=e.distance,r):new u(e.normal,e.distance)},u.equals=function(e,n){return e.distance===n.distance&&t.equals(e.normal,n.normal)},u.ORIGIN_XY_PLANE=a(new u(t.UNIT_Z,0)),u.ORIGIN_YZ_PLANE=a(new u(t.UNIT_X,0)),u.ORIGIN_ZX_PLANE=a(new u(t.UNIT_Y,0)),u}),define("Core/CullingVolume",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./Intersect","./Plane"],function(t,e,n,r,a,i,o){"use strict";function u(t){this.planes=n(t,[])}var s=[new t,new t,new t];t.clone(t.UNIT_X,s[0]),t.clone(t.UNIT_Y,s[1]),t.clone(t.UNIT_Z,s[2]);var c=new t,E=new t,_=new o(new t(1,0,0),0);return u.fromBoundingSphere=function(n,a){r(a)||(a=new u);var i=s.length,o=a.planes;o.length=2*i;for(var _=n.center,l=n.radius,f=0,h=0;h<i;++h){var T=s[h],R=o[f],d=o[f+1];r(R)||(R=o[f]=new e),r(d)||(d=o[f+1]=new e),t.multiplyByScalar(T,-l,c),t.add(_,c,c),R.x=T.x,R.y=T.y,R.z=T.z,R.w=-t.dot(T,c),t.multiplyByScalar(T,l,c),t.add(_,c,c),d.x=-T.x,d.y=-T.y,d.z=-T.z,d.w=-t.dot(t.negate(T,E),c),f+=2}return a},u.prototype.computeVisibility=function(t){for(var e=this.planes,n=!1,r=0,a=e.length;r<a;++r){var u=t.intersectPlane(o.fromCartesian4(e[r],_));if(u===i.OUTSIDE)return i.OUTSIDE;u===i.INTERSECTING&&(n=!0)}return n?i.INTERSECTING:i.INSIDE},u.prototype.computeVisibilityWithPlaneMask=function(t,e){if(e===u.MASK_OUTSIDE||e===u.MASK_INSIDE)return e;for(var n=u.MASK_INSIDE,r=this.planes,a=0,s=r.length;a<s;++a){var c=a<31?1<<a:0;if(!(a<31&&0==(e&c))){var E=t.intersectPlane(o.fromCartesian4(r[a],_));if(E===i.OUTSIDE)return u.MASK_OUTSIDE;E===i.INTERSECTING&&(n|=c)}}return n},u.MASK_OUTSIDE=4294967295,u.MASK_INSIDE=0,u.MASK_INDETERMINATE=2147483647,u}),define("Core/OrthographicOffCenterFrustum",["./Cartesian3","./Cartesian4","./CullingVolume","./defaultValue","./defined","./defineProperties","./DeveloperError","./Matrix4"],function(t,e,n,r,a,i,o,u){"use strict";function s(t){t=r(t,r.EMPTY_OBJECT),this.left=t.left,this._left=void 0,this.right=t.right,this._right=void 0,this.top=t.top,this._top=void 0,this.bottom=t.bottom,this._bottom=void 0,this.near=r(t.near,1),this._near=this.near,this.far=r(t.far,5e8),this._far=this.far,this._cullingVolume=new n,this._orthographicMatrix=new u}function c(t){t.top===t._top&&t.bottom===t._bottom&&t.left===t._left&&t.right===t._right&&t.near===t._near&&t.far===t._far||(t._left=t.left,t._right=t.right,t._top=t.top,t._bottom=t.bottom,t._near=t.near,t._far=t.far,t._orthographicMatrix=u.computeOrthographicOffCenter(t.left,t.right,t.bottom,t.top,t.near,t.far,t._orthographicMatrix))}i(s.prototype,{projectionMatrix:{get:function(){return c(this),this._orthographicMatrix}}});var E=new t,_=new t,l=new t,f=new t;return s.prototype.computeCullingVolume=function(n,r,i){var o=this._cullingVolume.planes,u=this.top,s=this.bottom,c=this.right,h=this.left,T=this.near,R=this.far,d=t.cross(r,i,E);t.normalize(d,d);var A=_;t.multiplyByScalar(r,T,A),t.add(n,A,A);var p=l;t.multiplyByScalar(d,h,p),t.add(A,p,p);var m=o[0];return a(m)||(m=o[0]=new e),m.x=d.x,m.y=d.y,m.z=d.z,m.w=-t.dot(d,p),t.multiplyByScalar(d,c,p),t.add(A,p,p),m=o[1],a(m)||(m=o[1]=new e),m.x=-d.x,m.y=-d.y,m.z=-d.z,m.w=-t.dot(t.negate(d,f),p),t.multiplyByScalar(i,s,p),t.add(A,p,p),m=o[2],a(m)||(m=o[2]=new e),m.x=i.x,m.y=i.y,m.z=i.z,m.w=-t.dot(i,p),t.multiplyByScalar(i,u,p),t.add(A,p,p),m=o[3],a(m)||(m=o[3]=new e),m.x=-i.x,m.y=-i.y,m.z=-i.z,m.w=-t.dot(t.negate(i,f),p),m=o[4],a(m)||(m=o[4]=new e),m.x=r.x,m.y=r.y,m.z=r.z,m.w=-t.dot(r,A),t.multiplyByScalar(r,R,p),t.add(n,p,p),m=o[5],a(m)||(m=o[5]=new e),m.x=-r.x,m.y=-r.y,m.z=-r.z,m.w=-t.dot(t.negate(r,f),p),this._cullingVolume},s.prototype.getPixelDimensions=function(t,e,n,r){c(this);var a=this.right-this.left,i=this.top-this.bottom,o=a/t,u=i/e;return r.x=o,r.y=u,r},s.prototype.clone=function(t){return a(t)||(t=new s),t.left=this.left,t.right=this.right,t.top=this.top,t.bottom=this.bottom,t.near=this.near,t.far=this.far,t._left=void 0,t._right=void 0,t._top=void 0,t._bottom=void 0,t._near=void 0,t._far=void 0,t},s.prototype.equals=function(t){return a(t)&&t instanceof s&&this.right===t.right&&this.left===t.left&&this.top===t.top&&this.bottom===t.bottom&&this.near===t.near&&this.far===t.far},s}),define("Core/OrthographicFrustum",["./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./OrthographicOffCenterFrustum"],function(t,e,n,r,a,i){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT),this._offCenterFrustum=new i,this.width=t.width,this._width=void 0,this.aspectRatio=t.aspectRatio,this._aspectRatio=void 0,this.near=e(t.near,1),this._near=this.near,this.far=e(t.far,5e8),this._far=this.far}function u(t){var e=t._offCenterFrustum;if(t.width!==t._width||t.aspectRatio!==t._aspectRatio||t.near!==t._near||t.far!==t._far){t._aspectRatio=t.aspectRatio,t._width=t.width,t._near=t.near,t._far=t.far;var n=1/t.aspectRatio;e.right=.5*t.width,e.left=-e.right,e.top=n*e.right,e.bottom=-e.top,e.near=t.near,e.far=t.far}}return o.packedLength=4,o.pack=function(t,n,r){return r=e(r,0),n[r++]=t.width,n[r++]=t.aspectRatio,n[r++]=t.near,n[r]=t.far,n},o.unpack=function(t,r,a){return r=e(r,0),n(a)||(a=new o),a.width=t[r++],a.aspectRatio=t[r++],a.near=t[r++],a.far=t[r],a},r(o.prototype,{projectionMatrix:{get:function(){return u(this),this._offCenterFrustum.projectionMatrix}}}),o.prototype.computeCullingVolume=function(t,e,n){return u(this),this._offCenterFrustum.computeCullingVolume(t,e,n)},o.prototype.getPixelDimensions=function(t,e,n,r){return u(this),this._offCenterFrustum.getPixelDimensions(t,e,n,r)},o.prototype.clone=function(t){return n(t)||(t=new o),t.aspectRatio=this.aspectRatio,t.width=this.width,t.near=this.near,t.far=this.far,t._aspectRatio=void 0,t._width=void 0,t._near=void 0,t._far=void 0,this._offCenterFrustum.clone(t._offCenterFrustum),t},o.prototype.equals=function(t){return!!(n(t)&&t instanceof o)&&(u(this),u(t),this.width===t.width&&this.aspectRatio===t.aspectRatio&&this.near===t.near&&this.far===t.far&&this._offCenterFrustum.equals(t._offCenterFrustum))},o}),define("Core/PerspectiveOffCenterFrustum",["./Cartesian3","./Cartesian4","./CullingVolume","./defaultValue","./defined","./defineProperties","./DeveloperError","./Matrix4"],function(t,e,n,r,a,i,o,u){"use strict";function s(t){t=r(t,r.EMPTY_OBJECT),this.left=t.left,this._left=void 0,this.right=t.right,this._right=void 0,this.top=t.top,this._top=void 0,this.bottom=t.bottom,this._bottom=void 0,this.near=r(t.near,1),this._near=this.near,this.far=r(t.far,5e8),this._far=this.far,this._cullingVolume=new n,this._perspectiveMatrix=new u,this._infinitePerspective=new u}function c(t){var e=t.top,n=t.bottom,r=t.right,a=t.left,i=t.near,o=t.far;e===t._top&&n===t._bottom&&a===t._left&&r===t._right&&i===t._near&&o===t._far||(t._left=a,t._right=r,t._top=e,t._bottom=n,t._near=i,t._far=o,t._perspectiveMatrix=u.computePerspectiveOffCenter(a,r,n,e,i,o,t._perspectiveMatrix),t._infinitePerspective=u.computeInfinitePerspectiveOffCenter(a,r,n,e,i,t._infinitePerspective))}i(s.prototype,{projectionMatrix:{get:function(){return c(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return c(this),this._infinitePerspective}}});var E=new t,_=new t,l=new t,f=new t;return s.prototype.computeCullingVolume=function(n,r,i){var o=this._cullingVolume.planes,u=this.top,s=this.bottom,c=this.right,h=this.left,T=this.near,R=this.far,d=t.cross(r,i,E),A=_;t.multiplyByScalar(r,T,A),t.add(n,A,A);var p=l;t.multiplyByScalar(r,R,p),t.add(n,p,p);var m=f;t.multiplyByScalar(d,h,m),t.add(A,m,m),t.subtract(m,n,m),t.normalize(m,m),t.cross(m,i,m),t.normalize(m,m);var N=o[0];return a(N)||(N=o[0]=new e),N.x=m.x,N.y=m.y,N.z=m.z,N.w=-t.dot(m,n),t.multiplyByScalar(d,c,m),t.add(A,m,m),t.subtract(m,n,m),t.cross(i,m,m),t.normalize(m,m),N=o[1],a(N)||(N=o[1]=new e),N.x=m.x,N.y=m.y,N.z=m.z,N.w=-t.dot(m,n),t.multiplyByScalar(i,s,m),t.add(A,m,m),t.subtract(m,n,m),t.cross(d,m,m),t.normalize(m,m),N=o[2],a(N)||(N=o[2]=new e),N.x=m.x,N.y=m.y,N.z=m.z,N.w=-t.dot(m,n),t.multiplyByScalar(i,u,m),t.add(A,m,m),t.subtract(m,n,m),t.cross(m,d,m),t.normalize(m,m),N=o[3],a(N)||(N=o[3]=new e),N.x=m.x,N.y=m.y,N.z=m.z,N.w=-t.dot(m,n),N=o[4],a(N)||(N=o[4]=new e),N.x=r.x,N.y=r.y,N.z=r.z,N.w=-t.dot(r,A),t.negate(r,m),N=o[5],a(N)||(N=o[5]=new e),N.x=m.x,N.y=m.y,N.z=m.z,N.w=-t.dot(m,p),this._cullingVolume},s.prototype.getPixelDimensions=function(t,e,n,r){c(this);var a=1/this.near,i=this.top*a,o=2*n*i/e;i=this.right*a;var u=2*n*i/t;return r.x=u,r.y=o,r},s.prototype.clone=function(t){return a(t)||(t=new s),t.right=this.right,t.left=this.left,t.top=this.top,t.bottom=this.bottom,t.near=this.near,t.far=this.far,t._left=void 0,t._right=void 0,t._top=void 0,t._bottom=void 0,t._near=void 0,t._far=void 0,t},s.prototype.equals=function(t){return a(t)&&t instanceof s&&this.right===t.right&&this.left===t.left&&this.top===t.top&&this.bottom===t.bottom&&this.near===t.near&&this.far===t.far},s}),define("Core/PerspectiveFrustum",["./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./PerspectiveOffCenterFrustum"],function(t,e,n,r,a,i){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT),this._offCenterFrustum=new i,this.fov=t.fov,this._fov=void 0,this._fovy=void 0,this._sseDenominator=void 0,this.aspectRatio=t.aspectRatio,this._aspectRatio=void 0,this.near=e(t.near,1),this._near=this.near,this.far=e(t.far,5e8),this._far=this.far,this.xOffset=e(t.xOffset,0),this._xOffset=this.xOffset,this.yOffset=e(t.yOffset,0),this._yOffset=this.yOffset}function u(t){var e=t._offCenterFrustum;t.fov===t._fov&&t.aspectRatio===t._aspectRatio&&t.near===t._near&&t.far===t._far&&t.xOffset===t._xOffset&&t.yOffset===t._yOffset||(t._aspectRatio=t.aspectRatio,t._fov=t.fov,t._fovy=t.aspectRatio<=1?t.fov:2*Math.atan(Math.tan(.5*t.fov)/t.aspectRatio),t._near=t.near,t._far=t.far,t._sseDenominator=2*Math.tan(.5*t._fovy),t._xOffset=t.xOffset,t._yOffset=t.yOffset,e.top=t.near*Math.tan(.5*t._fovy),e.bottom=-e.top,e.right=t.aspectRatio*e.top,e.left=-e.right,e.near=t.near,e.far=t.far,e.right+=t.xOffset,e.left+=t.xOffset,e.top+=t.yOffset,e.bottom+=t.yOffset)}return o.packedLength=6,o.pack=function(t,n,r){return r=e(r,0),n[r++]=t.fov,n[r++]=t.aspectRatio,n[r++]=t.near,n[r++]=t.far,n[r++]=t.xOffset,n[r]=t.yOffset,n},o.unpack=function(t,r,a){return r=e(r,0),n(a)||(a=new o),a.fov=t[r++],a.aspectRatio=t[r++],a.near=t[r++],a.far=t[r++],a.xOffset=t[r++],a.yOffset=t[r],a},r(o.prototype,{projectionMatrix:{get:function(){return u(this),this._offCenterFrustum.projectionMatrix}},
infiniteProjectionMatrix:{get:function(){return u(this),this._offCenterFrustum.infiniteProjectionMatrix}},fovy:{get:function(){return u(this),this._fovy}},sseDenominator:{get:function(){return u(this),this._sseDenominator}}}),o.prototype.computeCullingVolume=function(t,e,n){return u(this),this._offCenterFrustum.computeCullingVolume(t,e,n)},o.prototype.getPixelDimensions=function(t,e,n,r){return u(this),this._offCenterFrustum.getPixelDimensions(t,e,n,r)},o.prototype.clone=function(t){return n(t)||(t=new o),t.aspectRatio=this.aspectRatio,t.fov=this.fov,t.near=this.near,t.far=this.far,t._aspectRatio=void 0,t._fov=void 0,t._near=void 0,t._far=void 0,this._offCenterFrustum.clone(t._offCenterFrustum),t},o.prototype.equals=function(t){return!!(n(t)&&t instanceof o)&&(u(this),u(t),this.fov===t.fov&&this.aspectRatio===t.aspectRatio&&this.near===t.near&&this.far===t.far&&this._offCenterFrustum.equals(t._offCenterFrustum))},o}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(t,e,n,r,a,i,o,u){"use strict";function s(t,e,r,a){this.x=n(t,0),this.y=n(e,0),this.z=n(r,0),this.w=n(a,0)}var c=new t;s.fromAxisAngle=function(e,n,a){var i=n/2,o=Math.sin(i);c=t.normalize(e,c);var u=c.x*o,E=c.y*o,_=c.z*o,l=Math.cos(i);return r(a)?(a.x=u,a.y=E,a.z=_,a.w=l,a):new s(u,E,_,l)};var E=[1,2,0],_=new Array(3);s.fromRotationMatrix=function(t,e){var n,a,i,o,c,l=t[u.COLUMN0ROW0],f=t[u.COLUMN1ROW1],h=t[u.COLUMN2ROW2],T=l+f+h;if(T>0)n=Math.sqrt(T+1),c=.5*n,n=.5/n,a=(t[u.COLUMN1ROW2]-t[u.COLUMN2ROW1])*n,i=(t[u.COLUMN2ROW0]-t[u.COLUMN0ROW2])*n,o=(t[u.COLUMN0ROW1]-t[u.COLUMN1ROW0])*n;else{var R=E,d=0;f>l&&(d=1),h>l&&h>f&&(d=2);var A=R[d],p=R[A];n=Math.sqrt(t[u.getElementIndex(d,d)]-t[u.getElementIndex(A,A)]-t[u.getElementIndex(p,p)]+1);var m=_;m[d]=.5*n,n=.5/n,c=(t[u.getElementIndex(p,A)]-t[u.getElementIndex(A,p)])*n,m[A]=(t[u.getElementIndex(A,d)]+t[u.getElementIndex(d,A)])*n,m[p]=(t[u.getElementIndex(p,d)]+t[u.getElementIndex(d,p)])*n,a=-m[0],i=-m[1],o=-m[2]}return r(e)?(e.x=a,e.y=i,e.z=o,e.w=c,e):new s(a,i,o,c)};var l=new s,f=new s,h=new s,T=new s;s.fromHeadingPitchRoll=function(e,n){return T=s.fromAxisAngle(t.UNIT_X,e.roll,l),h=s.fromAxisAngle(t.UNIT_Y,-e.pitch,n),n=s.multiply(h,T,h),f=s.fromAxisAngle(t.UNIT_Z,-e.heading,l),s.multiply(f,n,n)};var R=new t,d=new t,A=new s,p=new s,m=new s;s.packedLength=4,s.pack=function(t,e,r){return r=n(r,0),e[r++]=t.x,e[r++]=t.y,e[r++]=t.z,e[r]=t.w,e},s.unpack=function(t,e,a){return e=n(e,0),r(a)||(a=new s),a.x=t[e],a.y=t[e+1],a.z=t[e+2],a.w=t[e+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(t,e,n,r){s.unpack(t,4*n,m),s.conjugate(m,m);for(var a=0,i=n-e+1;a<i;a++){var o=3*a;s.unpack(t,4*(e+a),A),s.multiply(A,m,A),A.w<0&&s.negate(A,A),s.computeAxis(A,R);var u=s.computeAngle(A);r[o]=R.x*u,r[o+1]=R.y*u,r[o+2]=R.z*u}},s.unpackInterpolationResult=function(e,n,a,i,o){r(o)||(o=new s),t.fromArray(e,0,d);var u=t.magnitude(d);return s.unpack(n,4*i,p),0===u?s.clone(s.IDENTITY,A):s.fromAxisAngle(d,u,A),s.multiply(A,p,o)},s.clone=function(t,e){if(r(t))return r(e)?(e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e):new s(t.x,t.y,t.z,t.w)},s.conjugate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e.w=t.w,e},s.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},s.magnitude=function(t){return Math.sqrt(s.magnitudeSquared(t))},s.normalize=function(t,e){var n=1/s.magnitude(t),r=t.x*n,a=t.y*n,i=t.z*n,o=t.w*n;return e.x=r,e.y=a,e.z=i,e.w=o,e},s.inverse=function(t,e){var n=s.magnitudeSquared(t);return e=s.conjugate(t,e),s.multiplyByScalar(e,1/n,e)},s.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n.w=t.w+e.w,n},s.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n.w=t.w-e.w,n},s.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e.w=-t.w,e},s.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z+t.w*e.w},s.multiply=function(t,e,n){var r=t.x,a=t.y,i=t.z,o=t.w,u=e.x,s=e.y,c=e.z,E=e.w,_=o*u+r*E+a*c-i*s,l=o*s-r*c+a*E+i*u,f=o*c+r*s-a*u+i*E,h=o*E-r*u-a*s-i*c;return n.x=_,n.y=l,n.z=f,n.w=h,n},s.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n.z=t.z*e,n.w=t.w*e,n},s.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n.z=t.z/e,n.w=t.w/e,n},s.computeAxis=function(t,e){var n=t.w;if(Math.abs(n-1)<o.EPSILON6)return e.x=e.y=e.z=0,e;var r=1/Math.sqrt(1-n*n);return e.x=t.x*r,e.y=t.y*r,e.z=t.z*r,e},s.computeAngle=function(t){return Math.abs(t.w-1)<o.EPSILON6?0:2*Math.acos(t.w)};var N=new s;s.lerp=function(t,e,n,r){return N=s.multiplyByScalar(e,n,N),r=s.multiplyByScalar(t,1-n,r),s.add(N,r,r)};var y=new s,I=new s,S=new s;s.slerp=function(t,e,n,r){var a=s.dot(t,e),i=e;if(a<0&&(a=-a,i=y=s.negate(e,y)),1-a<o.EPSILON6)return s.lerp(t,i,n,r);var u=Math.acos(a);return I=s.multiplyByScalar(t,Math.sin((1-n)*u),I),S=s.multiplyByScalar(i,Math.sin(n*u),S),r=s.add(I,S,r),s.multiplyByScalar(r,1/Math.sin(u),r)},s.log=function(e,n){var r=o.acosClamped(e.w),a=0;return 0!==r&&(a=r/Math.sin(r)),t.multiplyByScalar(e,a,n)},s.exp=function(e,n){var r=t.magnitude(e),a=0;return 0!==r&&(a=Math.sin(r)/r),n.x=e.x*a,n.y=e.y*a,n.z=e.z*a,n.w=Math.cos(r),n};var M=new t,O=new t,C=new s,w=new s;s.computeInnerQuadrangle=function(e,n,r,a){var i=s.conjugate(n,C);s.multiply(i,r,w);var o=s.log(w,M);s.multiply(i,e,w);var u=s.log(w,O);return t.add(o,u,o),t.multiplyByScalar(o,.25,o),t.negate(o,o),s.exp(o,C),s.multiply(n,C,a)},s.squad=function(t,e,n,r,a,i){var o=s.slerp(t,e,a,C),u=s.slerp(n,r,a,w);return s.slerp(o,u,2*a*(1-a),i)};for(var v=new s,g=1.9011074535173003,P=a.supportsTypedArrays()?new Float32Array(8):[],x=a.supportsTypedArrays()?new Float32Array(8):[],F=a.supportsTypedArrays()?new Float32Array(8):[],U=a.supportsTypedArrays()?new Float32Array(8):[],L=0;L<7;++L){var D=L+1,B=2*D+1;P[L]=1/(D*B),x[L]=D/B}return P[7]=g/136,x[7]=8*g/17,s.fastSlerp=function(t,e,n,r){var a,i=s.dot(t,e);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-n,c=n*n,E=u*u,_=7;_>=0;--_)F[_]=(P[_]*c-x[_])*o,U[_]=(P[_]*E-x[_])*o;var l=a*n*(1+F[0]*(1+F[1]*(1+F[2]*(1+F[3]*(1+F[4]*(1+F[5]*(1+F[6]*(1+F[7])))))))),f=u*(1+U[0]*(1+U[1]*(1+U[2]*(1+U[3]*(1+U[4]*(1+U[5]*(1+U[6]*(1+U[7])))))))),h=s.multiplyByScalar(t,f,v);return s.multiplyByScalar(e,l,r),s.add(h,r,r)},s.fastSquad=function(t,e,n,r,a,i){var o=s.fastSlerp(t,e,a,C),u=s.fastSlerp(n,r,a,w);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(t,e){return t===e||r(t)&&r(e)&&t.x===e.x&&t.y===e.y&&t.z===e.z&&t.w===e.w},s.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t.x-e.x)<=n&&Math.abs(t.y-e.y)<=n&&Math.abs(t.z-e.z)<=n&&Math.abs(t.w-e.w)<=n},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.prototype.equalsEpsilon=function(t,e){return s.equalsEpsilon(this,t,e)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,e,n,r){"use strict";function a(e){e=t(e,t.EMPTY_OBJECT),this.position=t(e.position,!1),this.normal=t(e.normal,!1),this.st=t(e.st,!1),this.bitangent=t(e.bitangent,!1),this.tangent=t(e.tangent,!1),this.color=t(e.color,!1)}return a.POSITION_ONLY=r(new a({position:!0})),a.POSITION_AND_NORMAL=r(new a({position:!0,normal:!0})),a.POSITION_NORMAL_AND_ST=r(new a({position:!0,normal:!0,st:!0})),a.POSITION_AND_ST=r(new a({position:!0,st:!0})),a.POSITION_AND_COLOR=r(new a({position:!0,color:!0})),a.ALL=r(new a({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),a.DEFAULT=a.POSITION_NORMAL_AND_ST,a.packedLength=6,a.pack=function(e,n,r){return r=t(r,0),n[r++]=e.position?1:0,n[r++]=e.normal?1:0,n[r++]=e.st?1:0,n[r++]=e.tangent?1:0,n[r++]=e.bitangent?1:0,n[r]=e.color?1:0,n},a.unpack=function(n,r,i){return r=t(r,0),e(i)||(i=new a),i.position=1===n[r++],i.normal=1===n[r++],i.st=1===n[r++],i.tangent=1===n[r++],i.bitangent=1===n[r++],i.color=1===n[r],i},a.clone=function(t,n){if(e(t))return e(n)||(n=new a),n.position=t.position,n.normal=t.normal,n.st=t.st,n.tangent=t.tangent,n.bitangent=t.bitangent,n.color=t.color,n},a}),define("Core/FrustumGeometry",["./BoundingSphere","./Cartesian3","./Cartesian4","./Check","./ComponentDatatype","./defaultValue","./defined","./Geometry","./GeometryAttribute","./GeometryAttributes","./Matrix3","./Matrix4","./OrthographicFrustum","./PerspectiveFrustum","./PrimitiveType","./Quaternion","./VertexFormat"],function(t,e,n,r,a,i,o,u,s,c,E,_,l,f,h,T,R){"use strict";function d(t){var n,r,a=t.frustum,o=t.orientation,u=t.origin,s=i(t.vertexFormat,R.DEFAULT),c=i(t._drawNearPlane,!0);a instanceof f?(n=p,r=f.packedLength):a instanceof l&&(n=m,r=l.packedLength),this._frustumType=n,this._frustum=a.clone(),this._origin=e.clone(u),this._orientation=T.clone(o),this._drawNearPlane=c,this._vertexFormat=s,this._workerName="createFrustumGeometry",this.packedLength=2+r+e.packedLength+T.packedLength+R.packedLength}function A(t,e,n,r,a,i,u,s){for(var c=t/3*2,E=0;E<4;++E)o(e)&&(e[t]=i.x,e[t+1]=i.y,e[t+2]=i.z),o(n)&&(n[t]=u.x,n[t+1]=u.y,n[t+2]=u.z),o(r)&&(r[t]=s.x,r[t+1]=s.y,r[t+2]=s.z),t+=3;a[c]=0,a[c+1]=0,a[c+2]=1,a[c+3]=0,a[c+4]=1,a[c+5]=1,a[c+6]=0,a[c+7]=1}var p=0,m=1;d.pack=function(t,n,r){r=i(r,0);var a=t._frustumType,o=t._frustum;return n[r++]=a,a===p?(f.pack(o,n,r),r+=f.packedLength):(l.pack(o,n,r),r+=l.packedLength),e.pack(t._origin,n,r),r+=e.packedLength,T.pack(t._orientation,n,r),r+=T.packedLength,R.pack(t._vertexFormat,n,r),r+=R.packedLength,n[r]=t._drawNearPlane?1:0,n};var N=new f,y=new l,I=new T,S=new e,M=new R;d.unpack=function(t,n,r){n=i(n,0);var a,u=t[n++];u===p?(a=f.unpack(t,n,N),n+=f.packedLength):(a=l.unpack(t,n,y),n+=l.packedLength);var s=e.unpack(t,n,S);n+=e.packedLength;var c=T.unpack(t,n,I);n+=T.packedLength;var E=R.unpack(t,n,M);n+=R.packedLength;var _=1===t[n];if(!o(r))return new d({frustum:a,origin:s,orientation:c,vertexFormat:E,_drawNearPlane:_});var h=u===r._frustumType?r._frustum:void 0;return r._frustum=a.clone(h),r._frustumType=u,r._origin=e.clone(s,r._origin),r._orientation=T.clone(c,r._orientation),r._vertexFormat=R.clone(E,r._vertexFormat),r._drawNearPlane=_,r};var O=new E,C=new _,w=new _,v=new e,g=new e,P=new e,x=new e,F=new e,U=new e,L=new Array(3),D=new Array(4);D[0]=new n(-1,-1,1,1),D[1]=new n(1,-1,1,1),D[2]=new n(1,1,1,1),D[3]=new n(-1,1,1,1);for(var B=new Array(4),z=0;z<4;++z)B[z]=new n;return d._computeNearFarPlanes=function(t,r,a,u,s,c,l,f){var h=E.fromQuaternion(r,O),T=i(c,v),R=i(l,g),d=i(f,P);T=E.getColumn(h,0,T),R=E.getColumn(h,1,R),d=E.getColumn(h,2,d),e.normalize(T,T),e.normalize(R,R),e.normalize(d,d),e.negate(T,T);var A,m,N=_.computeView(t,d,R,T,C);if(a===p){var y=u.projectionMatrix,I=_.multiply(y,N,w);m=_.inverse(I,w)}else A=_.inverseTransformation(N,w);o(m)?(L[0]=u.near,L[1]=u.far):(L[0]=0,L[1]=u.near,L[2]=u.far);for(var S=0;S<2;++S)for(var M=0;M<4;++M){var x=n.clone(D[M],B[M]);if(o(m)){x=_.multiplyByVector(m,x,x);var F=1/x.w;e.multiplyByScalar(x,F,x),e.subtract(x,t,x),e.normalize(x,x);var U=e.dot(d,x);e.multiplyByScalar(x,L[S]/U,x),e.add(x,t,x)}else{o(u._offCenterFrustum)&&(u=u._offCenterFrustum);var z=L[S],b=L[S+1];x.x=.5*(x.x*(u.right-u.left)+u.left+u.right),x.y=.5*(x.y*(u.top-u.bottom)+u.bottom+u.top),x.z=.5*(x.z*(z-b)-z-b),x.w=1,_.multiplyByVector(A,x,x)}s[12*S+3*M]=x.x,s[12*S+3*M+1]=x.y,s[12*S+3*M+2]=x.z}},d.createGeometry=function(n){var r=n._frustumType,i=n._frustum,E=n._origin,_=n._orientation,l=n._drawNearPlane,f=n._vertexFormat,T=l?6:5,R=new Float64Array(72);d._computeNearFarPlanes(E,_,r,i,R);var p=24;R[p]=R[12],R[p+1]=R[13],R[p+2]=R[14],R[p+3]=R[0],R[p+4]=R[1],R[p+5]=R[2],R[p+6]=R[9],R[p+7]=R[10],R[p+8]=R[11],R[p+9]=R[21],R[p+10]=R[22],R[p+11]=R[23],p+=12,R[p]=R[15],R[p+1]=R[16],R[p+2]=R[17],R[p+3]=R[3],R[p+4]=R[4],R[p+5]=R[5],R[p+6]=R[0],R[p+7]=R[1],R[p+8]=R[2],R[p+9]=R[12],R[p+10]=R[13],R[p+11]=R[14],p+=12,R[p]=R[3],R[p+1]=R[4],R[p+2]=R[5],R[p+3]=R[15],R[p+4]=R[16],R[p+5]=R[17],R[p+6]=R[18],R[p+7]=R[19],R[p+8]=R[20],R[p+9]=R[6],R[p+10]=R[7],R[p+11]=R[8],p+=12,R[p]=R[6],R[p+1]=R[7],R[p+2]=R[8],R[p+3]=R[18],R[p+4]=R[19],R[p+5]=R[20],R[p+6]=R[21],R[p+7]=R[22],R[p+8]=R[23],R[p+9]=R[9],R[p+10]=R[10],R[p+11]=R[11],l||(R=R.subarray(12));var m=new c({position:new s({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:R})});if(o(f.normal)||o(f.tangent)||o(f.bitangent)||o(f.st)){var N=o(f.normal)?new Float32Array(12*T):void 0,y=o(f.tangent)?new Float32Array(12*T):void 0,I=o(f.bitangent)?new Float32Array(12*T):void 0,S=o(f.st)?new Float32Array(8*T):void 0,M=v,O=g,C=P,w=e.negate(M,x),L=e.negate(O,F),D=e.negate(C,U);p=0,l&&(A(p,N,y,I,S,D,M,O),p+=12),A(p,N,y,I,S,C,w,O),p+=12,A(p,N,y,I,S,w,D,O),p+=12,A(p,N,y,I,S,L,D,w),p+=12,A(p,N,y,I,S,M,C,O),p+=12,A(p,N,y,I,S,O,C,w),o(N)&&(m.normal=new s({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:N})),o(y)&&(m.tangent=new s({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:y})),o(I)&&(m.bitangent=new s({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:I})),o(S)&&(m.st=new s({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:S}))}for(var B=new Uint16Array(6*T),z=0;z<T;++z){var b=6*z,G=4*z;B[b]=G,B[b+1]=G+1,B[b+2]=G+2,B[b+3]=G,B[b+4]=G+2,B[b+5]=G+3}return new u({attributes:m,indices:B,primitiveType:h.TRIANGLES,boundingSphere:t.fromVertices(R)})},d}),define("Workers/createFrustumGeometry",["../Core/defined","../Core/FrustumGeometry"],function(t,e){"use strict";function n(n,r){return t(r)&&(n=e.unpack(n,r)),e.createGeometry(n)}return n})}();