/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var o={};return o.typeOf={},o.defined=function(n,o){if(!e(o))throw new t(r(n))},o.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},o.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},o.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},o.typeOf.number.lessThan=function(e,r,n){if(o.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},o.typeOf.number.lessThanOrEquals=function(e,r,n){if(o.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},o.typeOf.number.greaterThan=function(e,r,n){if(o.typeOf.number(e,r),r<=n)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},o.typeOf.number.greaterThanOrEquals=function(e,r,n){if(o.typeOf.number(e,r),r<n)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},o.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},o.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},o.typeOf.number.equals=function(e,r,n,a){if(o.typeOf.number(e,n),o.typeOf.number(r,a),n!==a)throw new t(e+" must be equal to "+r+", the actual values are "+n+" and "+a)},o}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e&&null!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var o={};o.EPSILON1=.1,o.EPSILON2=.01,o.EPSILON3=.001,o.EPSILON4=1e-4,o.EPSILON5=1e-5,o.EPSILON6=1e-6,o.EPSILON7=1e-7,o.EPSILON8=1e-8,o.EPSILON9=1e-9,o.EPSILON10=1e-10,o.EPSILON11=1e-11,o.EPSILON12=1e-12,o.EPSILON13=1e-13,o.EPSILON14=1e-14,o.EPSILON15=1e-15,o.EPSILON16=1e-16,o.EPSILON17=1e-17,o.EPSILON18=1e-18,o.EPSILON19=1e-19,o.EPSILON20=1e-20,o.GRAVITATIONALPARAMETER=3986004418e5,o.SOLAR_RADIUS=6955e5,o.LUNAR_RADIUS=1737400,o.SIXTY_FOUR_KILOBYTES=65536,o.sign=t(Math.sign,function(e){return e=+e,0===e||e!==e?e:e>0?1:-1}),o.signNotZero=function(e){return e<0?-1:1},o.toSNorm=function(e,r){return r=t(r,255),Math.round((.5*o.clamp(e,-1,1)+.5)*r)},o.fromSNorm=function(e,r){return r=t(r,255),o.clamp(e,0,r)/r*2-1},o.sinh=t(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),o.cosh=t(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),o.lerp=function(e,t,r){return(1-r)*e+r*t},o.PI=Math.PI,o.ONE_OVER_PI=1/Math.PI,o.PI_OVER_TWO=Math.PI/2,o.PI_OVER_THREE=Math.PI/3,o.PI_OVER_FOUR=Math.PI/4,o.PI_OVER_SIX=Math.PI/6,o.THREE_PI_OVER_TWO=3*Math.PI/2,o.TWO_PI=2*Math.PI,o.ONE_OVER_TWO_PI=1/(2*Math.PI),o.RADIANS_PER_DEGREE=Math.PI/180,o.DEGREES_PER_RADIAN=180/Math.PI,o.RADIANS_PER_ARCSECOND=o.RADIANS_PER_DEGREE/3600,o.toRadians=function(e){return e*o.RADIANS_PER_DEGREE},o.toDegrees=function(e){return e*o.DEGREES_PER_RADIAN},o.convertLongitudeRange=function(e){var t=o.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},o.clampToLatitudeRange=function(e){return o.clamp(e,-1*o.PI_OVER_TWO,o.PI_OVER_TWO)},o.negativePiToPi=function(e){return o.zeroToTwoPi(e+o.PI)-o.PI},o.zeroToTwoPi=function(e){var t=o.mod(e,o.TWO_PI);return Math.abs(t)<o.EPSILON14&&Math.abs(e)>o.EPSILON14?o.TWO_PI:t},o.mod=function(e,t){return(e%t+t)%t},o.equalsEpsilon=function(e,r,n,o){o=t(o,n);var a=Math.abs(e-r);return a<=o||a<=n*Math.max(Math.abs(e),Math.abs(r))};var a=[1];o.factorial=function(e){var t=a.length;if(e>=t)for(var r=a[t-1],n=t;n<=e;n++)a.push(r*n);return a[e]},o.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},o.isPowerOfTwo=function(e){return 0!==e&&0==(e&e-1)},o.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},o.clamp=function(e,t,r){return e<t?t:e>r?r:e};var i=new e;return o.setRandomNumberSeed=function(t){i=new e(t)},o.nextRandomNumber=function(){return i.random()},o.randomBetween=function(e,t){return o.nextRandomNumber()*(t-e)+e},o.acosClamped=function(e){return Math.acos(o.clamp(e,-1,1))},o.asinClamped=function(e){return Math.asin(o.clamp(e,-1,1))},o.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},o.logBase=function(e,t){return Math.log(e)/Math.log(t)},o.cbrt=t(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t}),o.log2=t(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),o.fog=function(e,t){var r=e*t;return 1-Math.exp(-r*r)},o}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,a){"use strict";function i(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}i.fromSpherical=function(e,n){r(n)||(n=new i);var o=e.clock,a=e.cone,u=t(e.magnitude,1),s=u*Math.sin(a);return n.x=s*Math.cos(o),n.y=s*Math.sin(o),n.z=u*Math.cos(a),n},i.fromElements=function(e,t,n,o){return r(o)?(o.x=e,o.y=t,o.z=n,o):new i(e,t,n)},i.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new i(e.x,e.y,e.z)},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n]=e.z,r},i.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new i),o.x=e[n++],o.y=e[n++],o.z=e[n],o},i.packArray=function(e,t){var n=e.length;r(t)?t.length=3*n:t=new Array(3*n);for(var o=0;o<n;++o)i.pack(e[o],t,3*o);return t},i.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/3:t=new Array(n/3);for(var o=0;o<n;o+=3){var a=o/3;t[a]=i.unpack(e,o,t[a])}return t},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var u=new i;i.distance=function(e,t){return i.subtract(e,t,u),i.magnitude(u)},i.distanceSquared=function(e,t){return i.subtract(e,t,u),i.magnitudeSquared(u)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},i.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r.z=e.z/t.z,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var s=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,s),n=i.multiplyByScalar(e,1-r,n),i.add(s,n,n)};var E=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,E),i.normalize(t,c);var r=i.dot(E,c),n=i.magnitude(i.cross(E,c,E));return Math.atan2(n,r)};var l=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.projectVector=function(e,t,r){var n=i.dot(e,t)/i.dot(t,t);return i.multiplyByScalar(t,n,r)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},i.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,o)&&a.equalsEpsilon(e.y,t.y,n,o)&&a.equalsEpsilon(e.z,t.z,n,o)},i.cross=function(e,t,r){var n=e.x,o=e.y,a=e.z,i=t.x,u=t.y,s=t.z,E=o*s-a*u,c=a*i-n*s,l=n*u-o*i;return r.x=E,r.y=c,r.z=l,r},i.fromDegrees=function(e,t,r,n,o){return e=a.toRadians(e),t=a.toRadians(t),i.fromRadians(e,t,r,n,o)};var f=new i,_=new i,T=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(e,n,o,a,u){o=t(o,0);var s=r(a)?a.radiiSquared:T,E=Math.cos(n);f.x=E*Math.cos(e),f.y=E*Math.sin(e),f.z=Math.sin(n),f=i.normalize(f,f),i.multiplyComponents(s,f,_);var c=Math.sqrt(i.dot(f,_));return _=i.divideByScalar(_,c,_),f=i.multiplyByScalar(f,o,f),r(u)||(u=new i),i.add(_,f,u)},i.fromDegreesArray=function(e,t,n){var o=e.length;r(n)?n.length=o/2:n=new Array(o/2);for(var a=0;a<o;a+=2){var u=e[a],s=e[a+1],E=a/2;n[E]=i.fromDegrees(u,s,0,t,n[E])}return n},i.fromRadiansArray=function(e,t,n){var o=e.length;r(n)?n.length=o/2:n=new Array(o/2);for(var a=0;a<o;a+=2){var u=e[a],s=e[a+1],E=a/2;n[E]=i.fromRadians(u,s,0,t,n[E])}return n},i.fromDegreesArrayHeights=function(e,t,n){var o=e.length;r(n)?n.length=o/3:n=new Array(o/3);for(var a=0;a<o;a+=3){var u=e[a],s=e[a+1],E=e[a+2],c=a/3;n[c]=i.fromDegrees(u,s,E,t,n[c])}return n},i.fromRadiansArrayHeights=function(e,t,n){var o=e.length;r(n)?n.length=o/3:n=new Array(o/3);for(var a=0;a<o;a+=3){var u=e[a],s=e[a+1],E=e[a+2],c=a/3;n[c]=i.fromRadians(u,s,E,t,n[c])}return n},i.ZERO=o(new i(0,0,0)),i.UNIT_X=o(new i(1,0,0)),i.UNIT_Y=o(new i(0,1,0)),i.UNIT_Z=o(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function o(r,o,u,s,E){var c=r.x,l=r.y,f=r.z,_=o.x,T=o.y,R=o.z,A=c*c*_*_,h=l*l*T*T,m=f*f*R*R,d=A+h+m,S=Math.sqrt(1/d),C=e.multiplyByScalar(r,S,a);if(d<s)return isFinite(S)?e.clone(C,E):void 0;var I=u.x,N=u.y,p=u.z,y=i;y.x=C.x*I*2,y.y=C.y*N*2,y.z=C.z*p*2;var O,M,g,F,L,v,U,D,x,B,w,P=(1-S)*e.magnitude(r)/(.5*e.magnitude(y)),b=0;do{P-=b,g=1/(1+P*I),F=1/(1+P*N),L=1/(1+P*p),v=g*g,U=F*F,D=L*L,x=v*g,B=U*F,w=D*L,O=A*v+h*U+m*D-1,M=A*x*I+h*B*N+m*w*p;b=O/(-2*M)}while(Math.abs(O)>n.EPSILON12);return t(E)?(E.x=c*g,E.y=l*F,E.z=f*L,E):new e(c*g,l*F,f*L)}var a=new e,i=new e;return o}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,o,a,i){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,t,o,a){return o=r(o,0),n(a)?(a.longitude=e,a.latitude=t,a.height=o,a):new u(e,t,o)},u.fromDegrees=function(e,t,r,n){return e=a.toRadians(e),t=a.toRadians(t),u.fromRadians(e,t,r,n)};var s=new e,E=new e,c=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),f=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),_=a.EPSILON1;return u.fromCartesian=function(t,r,o){var T=n(r)?r.oneOverRadii:l,R=n(r)?r.oneOverRadiiSquared:f,A=n(r)?r._centerToleranceSquared:_,h=i(t,T,R,A,E);if(n(h)){var m=e.multiplyComponents(h,R,s);m=e.normalize(m,m);var d=e.subtract(t,h,c),S=Math.atan2(m.y,m.x),C=Math.asin(m.z),I=a.sign(e.dot(d,t))*e.magnitude(d);return n(o)?(o.longitude=S,o.latitude=C,o.height=I,o):new u(S,C,I)}},u.toCartesian=function(t,r,n){return e.fromRadians(t.longitude,t.latitude,t.height,r,n)},u.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.longitude-t.longitude)<=r&&Math.abs(e.latitude-t.latitude)<=r&&Math.abs(e.height-t.height)<=r},u.ZERO=o(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,o,a,i,u,s,E){"use strict";function c(t,r,o,a){r=n(r,0),o=n(o,0),a=n(a,0),t._radii=new e(r,o,a),t._radiiSquared=new e(r*r,o*o,a*a),t._radiiToTheFourth=new e(r*r*r*r,o*o*o*o,a*a*a*a),t._oneOverRadii=new e(0===r?0:1/r,0===o?0:1/o,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===o?0:1/(o*o),0===a?0:1/(a*a)),t._minimumRadius=Math.min(r,o,a),t._maximumRadius=Math.max(r,o,a),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,c(this,e,t,r)}a(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(o(t)){var n=t._radii;return o(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)}},l.fromCartesian3=function(e,t){return o(t)||(t=new l),o(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=u(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=u(new l(1,1,1)),l.MOON=u(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,r,o){return o=n(o,0),e.pack(t._radii,r,o),r},l.unpack=function(t,r,o){r=n(r,0);var a=e.unpack(t,r);return l.fromCartesian3(a,o)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,r){var n=t.longitude,a=t.latitude,i=Math.cos(a),u=i*Math.cos(n),s=i*Math.sin(n),E=Math.sin(a);return o(r)||(r=new e),r.x=u,r.y=s,r.z=E,e.normalize(r,r)},l.prototype.geodeticSurfaceNormal=function(t,r){return o(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var f=new e,_=new e;l.prototype.cartographicToCartesian=function(t,r){var n=f,a=_;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,a);var i=Math.sqrt(e.dot(n,a));return e.divideByScalar(a,i,a),e.multiplyByScalar(n,t.height,n),o(r)||(r=new e),e.add(a,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;o(t)?t.length=r:t=new Array(r);for(var n=0;n<r;n++)t[n]=this.cartographicToCartesian(e[n],t[n]);return t};var T=new e,R=new e,A=new e;return l.prototype.cartesianToCartographic=function(r,n){var a=this.scaleToGeodeticSurface(r,R);if(o(a)){var i=this.geodeticSurfaceNormal(a,T),u=e.subtract(r,a,A),E=Math.atan2(i.y,i.x),c=Math.asin(i.z),l=s.sign(e.dot(u,r))*e.magnitude(u);return o(n)?(n.longitude=E,n.latitude=c,n.height=l,n):new t(E,c,l)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;o(t)?t.length=r:t=new Array(r);for(var n=0;n<r;++n)t[n]=this.cartesianToCartographic(e[n],t[n]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return E(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,r){o(r)||(r=new e);var n=t.x,a=t.y,i=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(n*n*u.x+a*a*u.y+i*i*u.z);return e.multiplyByScalar(t,s,r)},l.prototype.transformPositionToScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||o(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,r,a){r=n(r,0);var i=this._squaredXOverSquaredZ;if(o(a)||(a=new e),a.x=0,a.y=0,a.z=t.z*(1-i),!(Math.abs(a.z)>=this._radii.z-r))return a},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,o,a,i){"use strict";function u(e){this._ellipsoid=r(e,i.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return o(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var o=this._semimajorAxis,a=t.longitude*o,i=t.latitude*o,u=t.height;return n(r)?(r.x=a,r.y=i,r.z=u,r):new e(a,i,u)},u.prototype.unproject=function(e,r){var o=this._oneOverSemimajorAxis,a=e.x*o,i=e.y*o,u=e.z;return n(r)?(r.longitude=a,r.latitude=i,r.height=u,r):new t(a,i,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";return e({OUTSIDE:-1,INTERSECTING:0,INSIDE:1})}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,a,i,u){"use strict";function s(e,t,n,o,a,i,u,s,E){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(i,0),this[8]=r(E,0)}function E(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function c(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(R[r],T[r])];t+=2*n*n}return Math.sqrt(t)}function l(e,t){for(var r=u.EPSILON15,n=0,o=1,a=0;a<3;++a){var i=Math.abs(e[s.getElementIndex(R[a],T[a])]);i>n&&(o=a,n=i)}var E=1,c=0,l=T[o],f=R[o];if(Math.abs(e[s.getElementIndex(f,l)])>r){var _,A=e[s.getElementIndex(f,f)],h=e[s.getElementIndex(l,l)],m=e[s.getElementIndex(f,l)],d=(A-h)/2/m;_=d<0?-1/(-d+Math.sqrt(1+d*d)):1/(d+Math.sqrt(1+d*d)),E=1/Math.sqrt(1+_*_),c=_*E}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(l,l)]=t[s.getElementIndex(f,f)]=E,t[s.getElementIndex(f,l)]=c,t[s.getElementIndex(l,f)]=-c,t}s.packedLength=9,s.pack=function(e,t,n){return n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t},s.unpack=function(e,t,o){return t=r(t,0),n(o)||(o=new s),o[0]=e[t++],o[1]=e[t++],o[2]=e[t++],o[3]=e[t++],o[4]=e[t++],o[5]=e[t++],o[6]=e[t++],o[7]=e[t++],o[8]=e[t++],o},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,t,o){return t=r(t,0),n(o)||(o=new s),o[0]=e[t],o[1]=e[t+1],o[2]=e[t+2],o[3]=e[t+3],o[4]=e[t+4],o[5]=e[t+5],o[6]=e[t+6],o[7]=e[t+7],o[8]=e[t+8],o},s.fromColumnMajorArray=function(e,t){return s.clone(e,t)},s.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,t){var r=e.x*e.x,o=e.x*e.y,a=e.x*e.z,i=e.x*e.w,u=e.y*e.y,E=e.y*e.z,c=e.y*e.w,l=e.z*e.z,f=e.z*e.w,_=e.w*e.w,T=r-u-l+_,R=2*(o-f),A=2*(a+c),h=2*(o+f),m=-r+u-l+_,d=2*(E-i),S=2*(a-c),C=2*(E+i),I=-r-u+l+_;return n(t)?(t[0]=T,t[1]=h,t[2]=S,t[3]=R,t[4]=m,t[5]=C,t[6]=A,t[7]=d,t[8]=I,t):new s(T,R,A,h,m,d,S,C,I)},s.fromHeadingPitchRoll=function(e,t){var r=Math.cos(-e.pitch),o=Math.cos(-e.heading),a=Math.cos(e.roll),i=Math.sin(-e.pitch),u=Math.sin(-e.heading),E=Math.sin(e.roll),c=r*o,l=-a*u+E*i*o,f=E*u+a*i*o,_=r*u,T=a*o+E*i*u,R=-E*o+a*i*u,A=-i,h=E*r,m=a*r;return n(t)?(t[0]=c,t[1]=_,t[2]=A,t[3]=l,t[4]=T,t[5]=h,t[6]=f,t[7]=R,t[8]=m,t):new s(c,l,f,_,T,R,A,h,m)},s.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,t){var r=Math.cos(e),o=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=o,t[6]=0,t[7]=-o,t[8]=r,t):new s(1,0,0,0,r,-o,0,o,r)},s.fromRotationY=function(e,t){var r=Math.cos(e),o=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-o,t[3]=0,t[4]=1,t[5]=0,t[6]=o,t[7]=0,t[8]=r,t):new s(r,0,o,0,1,0,-o,0,r)},s.fromRotationZ=function(e,t){var r=Math.cos(e),o=Math.sin(e);return n(t)?(t[0]=r,t[1]=o,t[2]=0,t[3]=-o,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new s(r,-o,0,o,r,0,0,0,1)},s.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,t){return 3*e+t},s.getColumn=function(e,t,r){var n=3*t,o=e[n],a=e[n+1],i=e[n+2];return r.x=o,r.y=a,r.z=i,r},s.setColumn=function(e,t,r,n){n=s.clone(e,n);var o=3*t;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n},s.getRow=function(e,t,r){var n=e[t],o=e[t+3],a=e[t+6];return r.x=n,r.y=o,r.z=a,r},s.setRow=function(e,t,r,n){return n=s.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var f=new e;s.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],f)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],f)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],f)),r};var _=new e;s.getMaximumScale=function(t){return s.getScale(t,_),e.maximumComponent(_)},s.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],i=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],E=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],c=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],l=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=o,r[2]=a,r[3]=i,r[4]=u,r[5]=s,r[6]=E,r[7]=c,r[8]=l,r},s.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},s.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},s.multiplyByVector=function(e,t,r){var n=t.x,o=t.y,a=t.z,i=e[0]*n+e[3]*o+e[6]*a,u=e[1]*n+e[4]*o+e[7]*a,s=e[2]*n+e[5]*o+e[8]*a;return r.x=i,r.y=u,r.z=s,r},s.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},s.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.x,r[3]=e[3]*t.y,r[4]=e[4]*t.y,r[5]=e[5]*t.y,r[6]=e[6]*t.z,r[7]=e[7]*t.z,r[8]=e[8]*t.z,r},s.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},s.transpose=function(e,t){var r=e[0],n=e[3],o=e[6],a=e[1],i=e[4],u=e[7],s=e[2],E=e[5],c=e[8];return t[0]=r,t[1]=n,t[2]=o,t[3]=a,t[4]=i,t[5]=u,t[6]=s,t[7]=E,t[8]=c,t};var T=[1,0,0],R=[2,2,1],A=new s,h=new s;return s.computeEigenDecomposition=function(e,t){var r=u.EPSILON20,o=0,a=0;n(t)||(t={});for(var i=t.unitary=s.clone(s.IDENTITY,t.unitary),f=t.diagonal=s.clone(e,t.diagonal),_=r*E(f);a<10&&c(f)>_;)l(f,A),s.transpose(A,h),s.multiply(f,A,f),s.multiply(h,f,f),s.multiply(i,A,i),++o>2&&(++a,o=0);return t},s.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},s.determinant=function(e){var t=e[0],r=e[3],n=e[6],o=e[1],a=e[4],i=e[7],u=e[2],s=e[5],E=e[8];return t*(a*E-s*i)+o*(s*n-r*E)+u*(r*i-a*n)},s.inverse=function(e,t){var r=e[0],n=e[1],o=e[2],a=e[3],i=e[4],u=e[5],E=e[6],c=e[7],l=e[8],f=s.determinant(e);t[0]=i*l-c*u,t[1]=c*o-n*l,t[2]=n*u-i*o,t[3]=E*u-a*l,t[4]=r*l-E*o,t[5]=a*o-r*u,t[6]=a*c-E*i,t[7]=E*n-r*c,t[8]=r*i-a*n;var _=1/f;return s.multiplyByScalar(t,_,t)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},s.IDENTITY=i(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=i(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,o(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,a){"use strict";function i(e,r,n,o){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(o,0)}i.fromElements=function(e,t,n,o,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=o,a):new i(e,t,n,o)},i.fromColor=function(e,t){return r(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w)},i.packedLength=4,i.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w,r},i.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new i),o.x=e[n++],o.y=e[n++],o.z=e[n++],o.w=e[n],o},i.packArray=function(e,t){var n=e.length;r(t)?t.length=4*n:t=new Array(4*n);for(var o=0;o<n;++o)i.pack(e[o],t,4*o);return t},i.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/4:t=new Array(n/4);for(var o=0;o<n;o+=4){var a=o/4;t[a]=i.unpack(e,o,t[a])}return t},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var u=new i;i.distance=function(e,t){return i.subtract(e,t,u),i.magnitude(u)},i.distanceSquared=function(e,t){return i.subtract(e,t,u),i.magnitudeSquared(u)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},i.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r.z=e.z/t.z,r.w=e.w/t.w,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var s=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,s),n=i.multiplyByScalar(e,1-r,n),i.add(s,n,n)};var E=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,E);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},i.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,o)&&a.equalsEpsilon(e.y,t.y,n,o)&&a.equalsEpsilon(e.z,t.z,n,o)&&a.equalsEpsilon(e.w,t.w,n,o)},i.ZERO=o(new i(0,0,0,0)),i.UNIT_X=o(new i(1,0,0,0)),i.UNIT_Y=o(new i(0,1,0,0)),i.UNIT_Z=o(new i(0,0,1,0)),i.UNIT_W=o(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){
return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var c=new Float32Array(1);return i.packFloat=function(e,t){if(r(t)||(t=new i),c[0]=e,0===(e=c[0]))return i.clone(i.ZERO,t);var n,o=e<0?1:0;isFinite(e)?(e=Math.abs(e),n=Math.floor(a.logBase(e,10))+1,e/=Math.pow(10,n)):(e=.1,n=38);var u=256*e;return t.x=Math.floor(u),u=256*(u-t.x),t.y=Math.floor(u),u=256*(u-t.y),t.z=Math.floor(u),t.w=2*(n+38)+o,t},i.unpackFloat=function(e){var t=e.w/2,r=Math.floor(t),n=2*(t-r);if(r-=38,n=2*n-1,n=-n,r>=38)return n<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var o=n*e.x*(1/256);return o+=n*e.y*(1/65536),(o+=n*e.z*(1/16777216))*Math.pow(10,r)},i}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,o,a,i,u,s,E){"use strict";function c(e,t,r,o,a,i,u,s,E,c,l,f,_,T,R,A){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(E,0),this[3]=n(_,0),this[4]=n(t,0),this[5]=n(i,0),this[6]=n(c,0),this[7]=n(T,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(R,0),this[12]=n(o,0),this[13]=n(s,0),this[14]=n(f,0),this[15]=n(A,0)}c.packedLength=16,c.pack=function(e,t,r){return r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15],t},c.unpack=function(e,t,r){return t=n(t,0),o(r)||(r=new c),r[0]=e[t++],r[1]=e[t++],r[2]=e[t++],r[3]=e[t++],r[4]=e[t++],r[5]=e[t++],r[6]=e[t++],r[7]=e[t++],r[8]=e[t++],r[9]=e[t++],r[10]=e[t++],r[11]=e[t++],r[12]=e[t++],r[13]=e[t++],r[14]=e[t++],r[15]=e[t],r},c.clone=function(e,t){if(o(e))return o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return o(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,r,a){return r=n(r,e.ZERO),o(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=r.x,a[13]=r.y,a[14]=r.z,a[15]=1,a):new c(t[0],t[3],t[6],r.x,t[1],t[4],t[7],r.y,t[2],t[5],t[8],r.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,r,n){o(n)||(n=new c);var a=r.x,i=r.y,u=r.z,s=t.x*t.x,E=t.x*t.y,l=t.x*t.z,f=t.x*t.w,_=t.y*t.y,T=t.y*t.z,R=t.y*t.w,A=t.z*t.z,h=t.z*t.w,m=t.w*t.w,d=s-_-A+m,S=2*(E-h),C=2*(l+R),I=2*(E+h),N=-s+_-A+m,p=2*(T-f),y=2*(l-R),O=2*(T+f),M=-s-_+A+m;return n[0]=d*a,n[1]=I*a,n[2]=y*a,n[3]=0,n[4]=S*i,n[5]=N*i,n[6]=O*i,n[7]=0,n[8]=C*u,n[9]=p*u,n[10]=M*u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n},c.fromTranslationRotationScale=function(e,t){return c.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},c.fromTranslation=function(e,t){return c.fromRotationTranslation(s.IDENTITY,e,t)},c.fromScale=function(e,t){return o(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return o(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,_=new e;c.fromCamera=function(t,r){var n=t.position,a=t.direction,i=t.up;e.normalize(a,l),e.normalize(e.cross(l,i,f),f),e.normalize(e.cross(f,l,_),_);var u=f.x,s=f.y,E=f.z,T=l.x,R=l.y,A=l.z,h=_.x,m=_.y,d=_.z,S=n.x,C=n.y,I=n.z,N=u*-S+s*-C+E*-I,p=h*-S+m*-C+d*-I,y=T*S+R*C+A*I;return o(r)?(r[0]=u,r[1]=h,r[2]=-T,r[3]=0,r[4]=s,r[5]=m,r[6]=-R,r[7]=0,r[8]=E,r[9]=d,r[10]=-A,r[11]=0,r[12]=N,r[13]=p,r[14]=y,r[15]=1,r):new c(u,s,E,N,h,m,d,p,-T,-R,-A,y,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,r,n,o){var a=Math.tan(.5*e),i=1/a,u=i/t,s=(n+r)/(r-n),E=2*n*r/(r-n);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=i,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=s,o[11]=-1,o[12]=0,o[13]=0,o[14]=E,o[15]=0,o},c.computeOrthographicOffCenter=function(e,t,r,n,o,a,i){var u=1/(t-e),s=1/(n-r),E=1/(a-o),c=-(t+e)*u,l=-(n+r)*s,f=-(a+o)*E;return u*=2,s*=2,E*=-2,i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=s,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=E,i[11]=0,i[12]=c,i[13]=l,i[14]=f,i[15]=1,i},c.computePerspectiveOffCenter=function(e,t,r,n,o,a,i){var u=2*o/(t-e),s=2*o/(n-r),E=(t+e)/(t-e),c=(n+r)/(n-r),l=-(a+o)/(a-o),f=-2*a*o/(a-o);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=s,i[6]=0,i[7]=0,i[8]=E,i[9]=c,i[10]=l,i[11]=-1,i[12]=0,i[13]=0,i[14]=f,i[15]=0,i},c.computeInfinitePerspectiveOffCenter=function(e,t,r,n,o,a){var i=2*o/(t-e),u=2*o/(n-r),s=(t+e)/(t-e),E=(n+r)/(n-r),c=-2*o;return a[0]=i,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=s,a[9]=E,a[10]=-1,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeViewportTransformation=function(e,t,r,o){e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),i=n(e.y,0),u=n(e.width,0),s=n(e.height,0);t=n(t,0),r=n(r,1);var E=.5*u,c=.5*s,l=.5*(r-t),f=E,_=c,T=l,R=a+E,A=i+c,h=t+l;return o[0]=f,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=_,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=T,o[11]=0,o[12]=R,o[13]=A,o[14]=h,o[15]=1,o},c.computeView=function(t,r,n,o,a){return a[0]=o.x,a[1]=n.x,a[2]=-r.x,a[3]=0,a[4]=o.y,a[5]=n.y,a[6]=-r.y,a[7]=0,a[8]=o.z,a[9]=n.z,a[10]=-r.z,a[11]=0,a[12]=-e.dot(o,t),a[13]=-e.dot(n,t),a[14]=e.dot(r,t),a[15]=1,a},c.toArray=function(e,t){return o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,r){var n=4*t,o=e[n],a=e[n+1],i=e[n+2],u=e[n+3];return r.x=o,r.y=a,r.z=i,r.w=u,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var o=4*t;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n[o+3]=r.w,n},c.setTranslation=function(e,t,r){return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},c.getRow=function(e,t,r){var n=e[t],o=e[t+4],a=e[t+8],i=e[t+12];return r.x=n,r.y=o,r.z=a,r.w=i,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var T=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],T)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],T)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],T)),r};var R=new e;c.getMaximumScale=function(t){return c.getScale(t,R),e.maximumComponent(R)},c.multiply=function(e,t,r){var n=e[0],o=e[1],a=e[2],i=e[3],u=e[4],s=e[5],E=e[6],c=e[7],l=e[8],f=e[9],_=e[10],T=e[11],R=e[12],A=e[13],h=e[14],m=e[15],d=t[0],S=t[1],C=t[2],I=t[3],N=t[4],p=t[5],y=t[6],O=t[7],M=t[8],g=t[9],F=t[10],L=t[11],v=t[12],U=t[13],D=t[14],x=t[15],B=n*d+u*S+l*C+R*I,w=o*d+s*S+f*C+A*I,P=a*d+E*S+_*C+h*I,b=i*d+c*S+T*C+m*I,G=n*N+u*p+l*y+R*O,z=o*N+s*p+f*y+A*O,V=a*N+E*p+_*y+h*O,H=i*N+c*p+T*y+m*O,X=n*M+u*g+l*F+R*L,W=o*M+s*g+f*F+A*L,Y=a*M+E*g+_*F+h*L,q=i*M+c*g+T*F+m*L,k=n*v+u*U+l*D+R*x,K=o*v+s*U+f*D+A*x,Z=a*v+E*U+_*D+h*x,j=i*v+c*U+T*D+m*x;return r[0]=B,r[1]=w,r[2]=P,r[3]=b,r[4]=G,r[5]=z,r[6]=V,r[7]=H,r[8]=X,r[9]=W,r[10]=Y,r[11]=q,r[12]=k,r[13]=K,r[14]=Z,r[15]=j,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},c.multiplyTransformation=function(e,t,r){var n=e[0],o=e[1],a=e[2],i=e[4],u=e[5],s=e[6],E=e[8],c=e[9],l=e[10],f=e[12],_=e[13],T=e[14],R=t[0],A=t[1],h=t[2],m=t[4],d=t[5],S=t[6],C=t[8],I=t[9],N=t[10],p=t[12],y=t[13],O=t[14],M=n*R+i*A+E*h,g=o*R+u*A+c*h,F=a*R+s*A+l*h,L=n*m+i*d+E*S,v=o*m+u*d+c*S,U=a*m+s*d+l*S,D=n*C+i*I+E*N,x=o*C+u*I+c*N,B=a*C+s*I+l*N,w=n*p+i*y+E*O+f,P=o*p+u*y+c*O+_,b=a*p+s*y+l*O+T;return r[0]=M,r[1]=g,r[2]=F,r[3]=0,r[4]=L,r[5]=v,r[6]=U,r[7]=0,r[8]=D,r[9]=x,r[10]=B,r[11]=0,r[12]=w,r[13]=P,r[14]=b,r[15]=1,r},c.multiplyByMatrix3=function(e,t,r){var n=e[0],o=e[1],a=e[2],i=e[4],u=e[5],s=e[6],E=e[8],c=e[9],l=e[10],f=t[0],_=t[1],T=t[2],R=t[3],A=t[4],h=t[5],m=t[6],d=t[7],S=t[8],C=n*f+i*_+E*T,I=o*f+u*_+c*T,N=a*f+s*_+l*T,p=n*R+i*A+E*h,y=o*R+u*A+c*h,O=a*R+s*A+l*h,M=n*m+i*d+E*S,g=o*m+u*d+c*S,F=a*m+s*d+l*S;return r[0]=C,r[1]=I,r[2]=N,r[3]=0,r[4]=p,r[5]=y,r[6]=O,r[7]=0,r[8]=M,r[9]=g,r[10]=F,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},c.multiplyByTranslation=function(e,t,r){var n=t.x,o=t.y,a=t.z,i=n*e[0]+o*e[4]+a*e[8]+e[12],u=n*e[1]+o*e[5]+a*e[9]+e[13],s=n*e[2]+o*e[6]+a*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=i,r[13]=u,r[14]=s,r[15]=e[15],r};var A=new e;c.multiplyByUniformScale=function(e,t,r){return A.x=t,A.y=t,A.z=t,c.multiplyByScale(e,A,r)},c.multiplyByScale=function(e,t,r){var n=t.x,o=t.y,a=t.z;return 1===n&&1===o&&1===a?c.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=o*e[4],r[5]=o*e[5],r[6]=o*e[6],r[7]=0,r[8]=a*e[8],r[9]=a*e[9],r[10]=a*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},c.multiplyByVector=function(e,t,r){var n=t.x,o=t.y,a=t.z,i=t.w,u=e[0]*n+e[4]*o+e[8]*a+e[12]*i,s=e[1]*n+e[5]*o+e[9]*a+e[13]*i,E=e[2]*n+e[6]*o+e[10]*a+e[14]*i,c=e[3]*n+e[7]*o+e[11]*a+e[15]*i;return r.x=u,r.y=s,r.z=E,r.w=c,r},c.multiplyByPointAsVector=function(e,t,r){var n=t.x,o=t.y,a=t.z,i=e[0]*n+e[4]*o+e[8]*a,u=e[1]*n+e[5]*o+e[9]*a,s=e[2]*n+e[6]*o+e[10]*a;return r.x=i,r.y=u,r.z=s,r},c.multiplyByPoint=function(e,t,r){var n=t.x,o=t.y,a=t.z,i=e[0]*n+e[4]*o+e[8]*a+e[12],u=e[1]*n+e[5]*o+e[9]*a+e[13],s=e[2]*n+e[6]*o+e[10]*a+e[14];return r.x=i,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var r=e[1],n=e[2],o=e[3],a=e[6],i=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=i,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||o(e)&&o(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,r){return e===t||o(e)&&o(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var h=new s,m=new s,d=new t,S=new t(0,0,0,1);return c.inverse=function(e,r){if(s.equalsEpsilon(c.getRotation(e,h),m,u.EPSILON7)&&t.equals(c.getRow(e,3,d),S))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],o=e[4],a=e[8],i=e[12],l=e[1],f=e[5],_=e[9],T=e[13],R=e[2],A=e[6],C=e[10],I=e[14],N=e[3],p=e[7],y=e[11],O=e[15],M=C*O,g=I*y,F=A*O,L=I*p,v=A*y,U=C*p,D=R*O,x=I*N,B=R*y,w=C*N,P=R*p,b=A*N,G=M*f+L*_+v*T-(g*f+F*_+U*T),z=g*l+D*_+w*T-(M*l+x*_+B*T),V=F*l+x*f+P*T-(L*l+D*f+b*T),H=U*l+B*f+b*_-(v*l+w*f+P*_),X=g*o+F*a+U*i-(M*o+L*a+v*i),W=M*n+x*a+B*i-(g*n+D*a+w*i),Y=L*n+D*o+b*i-(F*n+x*o+P*i),q=v*n+w*o+P*a-(U*n+B*o+b*a);M=a*T,g=i*_,F=o*T,L=i*f,v=o*_,U=a*f,D=n*T,x=i*l,B=n*_,w=a*l,P=n*f,b=o*l;var k=M*p+L*y+v*O-(g*p+F*y+U*O),K=g*N+D*y+w*O-(M*N+x*y+B*O),Z=F*N+x*p+P*O-(L*N+D*p+b*O),j=U*N+B*p+b*y-(v*N+w*p+P*y),Q=F*C+U*I+g*A-(v*I+M*A+L*C),J=B*I+M*R+x*C-(D*C+w*I+g*R),$=D*A+b*I+L*R-(P*I+F*R+x*A),ee=P*C+v*R+w*A-(B*A+b*C+U*R),te=n*G+o*z+a*V+i*H;if(Math.abs(te)<u.EPSILON20)throw new E("matrix is not invertible because its determinate is zero.");return te=1/te,r[0]=G*te,r[1]=z*te,r[2]=V*te,r[3]=H*te,r[4]=X*te,r[5]=W*te,r[6]=Y*te,r[7]=q*te,r[8]=k*te,r[9]=K*te,r[10]=Z*te,r[11]=j*te,r[12]=Q*te,r[13]=J*te,r[14]=$*te,r[15]=ee*te,r},c.inverseTransformation=function(e,t){var r=e[0],n=e[1],o=e[2],a=e[4],i=e[5],u=e[6],s=e[8],E=e[9],c=e[10],l=e[12],f=e[13],_=e[14],T=-r*l-n*f-o*_,R=-a*l-i*f-u*_,A=-s*l-E*f-c*_;return t[0]=r,t[1]=a,t[2]=s,t[3]=0,t[4]=n,t[5]=i,t[6]=E,t[7]=0,t[8]=o,t[9]=u,t[10]=c,t[11]=0,t[12]=T,t[13]=R,t[14]=A,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,a(c.prototype,{length:{get:function(){return c.packedLength}}}),c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,o,a,i,u){"use strict";function s(e,t,n,o){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(o,0)}o(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,t,n){return n=r(n,0),t[n++]=e.west,t[n++]=e.south,t[n++]=e.east,t[n]=e.north,t},s.unpack=function(e,t,o){return t=r(t,0),n(o)||(o=new s),o.west=e[t++],o.south=e[t++],o.east=e[t++],o.north=e[t],o},s.computeWidth=function(e){var t=e.east,r=e.west;return t<r&&(t+=u.TWO_PI),t-r},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,t,o,a,i){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),o=u.toRadians(r(o,0)),a=u.toRadians(r(a,0)),n(i)?(i.west=e,i.south=t,i.east=o,i.north=a,i):new s(e,t,o,a)},s.fromRadians=function(e,t,o,a,i){return n(i)?(i.west=r(e,0),i.south=r(t,0),i.east=r(o,0),i.north=r(a,0),i):new s(e,t,o,a)},s.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,i=-Number.MAX_VALUE,E=Number.MAX_VALUE,c=-Number.MAX_VALUE,l=0,f=e.length;l<f;l++){var _=e[l];r=Math.min(r,_.longitude),o=Math.max(o,_.longitude),E=Math.min(E,_.latitude),c=Math.max(c,_.latitude);var T=_.longitude>=0?_.longitude:_.longitude+u.TWO_PI;a=Math.min(a,T),i=Math.max(i,T)}return o-r>i-a&&(r=a,o=i,o>u.PI&&(o-=u.TWO_PI),r>u.PI&&(r-=u.TWO_PI)),n(t)?(t.west=r,t.south=E,t.east=o,t.north=c,t):new s(r,E,o,c)},s.fromCartesianArray=function(e,t,o){t=r(t,a.WGS84);for(var i=Number.MAX_VALUE,E=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=Number.MAX_VALUE,_=-Number.MAX_VALUE,T=0,R=e.length;T<R;T++){var A=t.cartesianToCartographic(e[T]);i=Math.min(i,A.longitude),E=Math.max(E,A.longitude),f=Math.min(f,A.latitude),_=Math.max(_,A.latitude);var h=A.longitude>=0?A.longitude:A.longitude+u.TWO_PI;c=Math.min(c,h),l=Math.max(l,h)}return E-i>l-c&&(i=c,E=l,E>u.PI&&(E-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(o)?(o.west=i,o.south=f,o.east=E,o.north=_,o):new s(i,f,E,_)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},s.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},s.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},s.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},s.center=function(t,r){var o=t.east,a=t.west;o<a&&(o+=u.TWO_PI);var i=u.negativePiToPi(.5*(a+o)),s=.5*(t.south+t.north);return n(r)?(r.longitude=i,r.latitude=s,r.height=0,r):new e(i,s)},s.intersection=function(e,t,r){var o=e.east,a=e.west,i=t.east,E=t.west;o<a&&i>0?o+=u.TWO_PI:i<E&&o>0&&(i+=u.TWO_PI),o<a&&E<0?E+=u.TWO_PI:i<E&&a<0&&(a+=u.TWO_PI);var c=u.negativePiToPi(Math.max(a,E)),l=u.negativePiToPi(Math.min(o,i));if(!((e.west<e.east||t.west<t.east)&&l<=c)){var f=Math.max(e.south,t.south),_=Math.min(e.north,t.north);if(!(f>=_))return n(r)?(r.west=c,r.south=f,r.east=l,r.north=_,r):new s(c,f,l,_)}},s.simpleIntersection=function(e,t,r){var o=Math.max(e.west,t.west),a=Math.max(e.south,t.south),i=Math.min(e.east,t.east),u=Math.min(e.north,t.north);if(!(a>=u||o>=i))return n(r)?(r.west=o,r.south=a,r.east=i,r.north=u,r):new s(o,a,i,u)},s.union=function(e,t,r){n(r)||(r=new s);var o=e.east,a=e.west,i=t.east,E=t.west;o<a&&i>0?o+=u.TWO_PI:i<E&&o>0&&(i+=u.TWO_PI),o<a&&E<0?E+=u.TWO_PI:i<E&&a<0&&(a+=u.TWO_PI);var c=u.convertLongitudeRange(Math.min(a,E)),l=u.convertLongitudeRange(Math.max(o,i));return r.west=c,r.south=Math.min(e.south,t.south),r.east=l,r.north=Math.max(e.north,t.north),r},s.expand=function(e,t,r){return n(r)||(r=new s),r.west=Math.min(e.west,t.longitude),r.south=Math.min(e.south,t.latitude),r.east=Math.max(e.east,t.longitude),r.north=Math.max(e.north,t.latitude),r},s.contains=function(e,t){var r=t.longitude,n=t.latitude,o=e.west,a=e.east;return a<o&&(a+=u.TWO_PI,r<0&&(r+=u.TWO_PI)),(r>o||u.equalsEpsilon(r,o,u.EPSILON14))&&(r<a||u.equalsEpsilon(r,a,u.EPSILON14))&&n>=e.south&&n<=e.north};var E=new e;return s.subsample=function(e,t,o,i){t=r(t,a.WGS84),o=r(o,0),n(i)||(i=[]);var c=0,l=e.north,f=e.south,_=e.east,T=e.west,R=E;R.height=o,R.longitude=T,R.latitude=l,i[c]=t.cartographicToCartesian(R,i[c]),c++,R.longitude=_,i[c]=t.cartographicToCartesian(R,i[c]),c++,R.latitude=f,i[c]=t.cartographicToCartesian(R,i[c]),c++,R.longitude=T,i[c]=t.cartographicToCartesian(R,i[c]),c++,R.latitude=l<0?l:f>0?f:0;for(var A=1;A<8;++A)R.longitude=-Math.PI+A*u.PI_OVER_TWO,s.contains(e,R)&&(i[c]=t.cartographicToCartesian(R,i[c]),c++);return 0===R.latitude&&(R.longitude=T,i[c]=t.cartographicToCartesian(R,i[c]),c++,R.longitude=_,i[c]=t.cartographicToCartesian(R,i[c]),c++),i.length=c,i},s.MAX_VALUE=i(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,o,a,i,u,s,E,c,l,f){"use strict";function _(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var T=new e,R=new e,A=new e,h=new e,m=new e,d=new e,S=new e,C=new e,I=new e,N=new e,p=new e,y=new e,O=4/3*E.PI;_.fromPoints=function(t,r){if(o(r)||(r=new _),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,a=e.clone(t[0],S),i=e.clone(a,T),u=e.clone(a,R),s=e.clone(a,A),E=e.clone(a,h),c=e.clone(a,m),l=e.clone(a,d),f=t.length;for(n=1;n<f;n++){e.clone(t[n],a);var O=a.x,M=a.y,g=a.z;O<i.x&&e.clone(a,i),O>E.x&&e.clone(a,E),M<u.y&&e.clone(a,u),M>c.y&&e.clone(a,c),g<s.z&&e.clone(a,s),g>l.z&&e.clone(a,l)}var F=e.magnitudeSquared(e.subtract(E,i,C)),L=e.magnitudeSquared(e.subtract(c,u,C)),v=e.magnitudeSquared(e.subtract(l,s,C)),U=i,D=E,x=F;L>x&&(x=L,U=u,D=c),v>x&&(x=v,U=s,D=l);var B=I;B.x=.5*(U.x+D.x),B.y=.5*(U.y+D.y),B.z=.5*(U.z+D.z);var w=e.magnitudeSquared(e.subtract(D,B,C)),P=Math.sqrt(w),b=N;b.x=i.x,b.y=u.y,b.z=s.z;var G=p;G.x=E.x,G.y=c.y,G.z=l.z;var z=e.multiplyByScalar(e.add(b,G,C),.5,y),V=0;for(n=0;n<f;n++){e.clone(t[n],a);var H=e.magnitude(e.subtract(a,z,C));H>V&&(V=H);var X=e.magnitudeSquared(e.subtract(a,B,C));if(X>w){var W=Math.sqrt(X);P=.5*(P+W),w=P*P;var Y=W-P;B.x=(P*B.x+Y*a.x)/W,B.y=(P*B.y+Y*a.y)/W,B.z=(P*B.z+Y*a.z)/W}}return P<V?(e.clone(B,r.center),r.radius=P):(e.clone(z,r.center),r.radius=V),r};var M=new i,g=new e,F=new e,L=new t,v=new t;_.fromRectangle2D=function(e,t,r){return _.fromRectangleWithHeights2D(e,t,0,0,r)},_.fromRectangleWithHeights2D=function(t,r,a,i,u){if(o(u)||(u=new _),!o(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,M),f.southwest(t,L),L.height=a,f.northeast(t,v),v.height=i;var s=r.project(L,g),E=r.project(v,F),c=E.x-s.x,l=E.y-s.y,T=E.z-s.z;u.radius=.5*Math.sqrt(c*c+l*l+T*T);var R=u.center;return R.x=s.x+.5*c,R.y=s.y+.5*l,R.z=s.z+.5*T,u};var U=[];_.fromRectangle3D=function(t,r,i,u){if(r=n(r,a.WGS84),i=n(i,0),o(u)||(u=new _),!o(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=f.subsample(t,r,i,U);return _.fromPoints(s,u)},_.fromVertices=function(t,r,a,i){if(o(i)||(i=new _),!o(t)||0===t.length)return i.center=e.clone(e.ZERO,i.center),i.radius=0,i;r=n(r,e.ZERO),a=n(a,3);var u=S;u.x=t[0]+r.x,u.y=t[1]+r.y,u.z=t[2]+r.z;var s,E=e.clone(u,T),c=e.clone(u,R),l=e.clone(u,A),f=e.clone(u,h),O=e.clone(u,m),M=e.clone(u,d),g=t.length;for(s=0;s<g;s+=a){var F=t[s]+r.x,L=t[s+1]+r.y,v=t[s+2]+r.z;u.x=F,u.y=L,u.z=v,F<E.x&&e.clone(u,E),F>f.x&&e.clone(u,f),L<c.y&&e.clone(u,c),L>O.y&&e.clone(u,O),v<l.z&&e.clone(u,l),v>M.z&&e.clone(u,M)}var U=e.magnitudeSquared(e.subtract(f,E,C)),D=e.magnitudeSquared(e.subtract(O,c,C)),x=e.magnitudeSquared(e.subtract(M,l,C)),B=E,w=f,P=U;D>P&&(P=D,B=c,w=O),x>P&&(P=x,B=l,w=M);var b=I;b.x=.5*(B.x+w.x),b.y=.5*(B.y+w.y),b.z=.5*(B.z+w.z);var G=e.magnitudeSquared(e.subtract(w,b,C)),z=Math.sqrt(G),V=N;V.x=E.x,V.y=c.y,V.z=l.z;var H=p;H.x=f.x,H.y=O.y,H.z=M.z;var X=e.multiplyByScalar(e.add(V,H,C),.5,y),W=0;for(s=0;s<g;s+=a){u.x=t[s]+r.x,u.y=t[s+1]+r.y,u.z=t[s+2]+r.z;var Y=e.magnitude(e.subtract(u,X,C));Y>W&&(W=Y);var q=e.magnitudeSquared(e.subtract(u,b,C));if(q>G){var k=Math.sqrt(q);z=.5*(z+k),G=z*z;var K=k-z;b.x=(z*b.x+K*u.x)/k,b.y=(z*b.y+K*u.y)/k,b.z=(z*b.z+K*u.z)/k}}return z<W?(e.clone(b,i.center),i.radius=z):(e.clone(X,i.center),i.radius=W),i},_.fromEncodedCartesianVertices=function(t,r,n){if(o(n)||(n=new _),!o(t)||!o(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=S;a.x=t[0]+r[0],a.y=t[1]+r[1],a.z=t[2]+r[2];var i,u=e.clone(a,T),s=e.clone(a,R),E=e.clone(a,A),c=e.clone(a,h),l=e.clone(a,m),f=e.clone(a,d),O=t.length;for(i=0;i<O;i+=3){var M=t[i]+r[i],g=t[i+1]+r[i+1],F=t[i+2]+r[i+2];a.x=M,a.y=g,a.z=F,M<u.x&&e.clone(a,u),M>c.x&&e.clone(a,c),g<s.y&&e.clone(a,s),g>l.y&&e.clone(a,l),F<E.z&&e.clone(a,E),F>f.z&&e.clone(a,f)}var L=e.magnitudeSquared(e.subtract(c,u,C)),v=e.magnitudeSquared(e.subtract(l,s,C)),U=e.magnitudeSquared(e.subtract(f,E,C)),D=u,x=c,B=L;v>B&&(B=v,D=s,x=l),U>B&&(B=U,D=E,x=f);var w=I;w.x=.5*(D.x+x.x),w.y=.5*(D.y+x.y),w.z=.5*(D.z+x.z);var P=e.magnitudeSquared(e.subtract(x,w,C)),b=Math.sqrt(P),G=N;G.x=u.x,G.y=s.y,G.z=E.z;var z=p;z.x=c.x,z.y=l.y,z.z=f.z;var V=e.multiplyByScalar(e.add(G,z,C),.5,y),H=0;for(i=0;i<O;i+=3){a.x=t[i]+r[i],a.y=t[i+1]+r[i+1],a.z=t[i+2]+r[i+2];var X=e.magnitude(e.subtract(a,V,C));X>H&&(H=X);var W=e.magnitudeSquared(e.subtract(a,w,C));if(W>P){var Y=Math.sqrt(W);b=.5*(b+Y),P=b*b;var q=Y-b;w.x=(b*w.x+q*a.x)/Y,w.y=(b*w.y+q*a.y)/Y,w.z=(b*w.z+q*a.z)/Y}}return b<H?(e.clone(w,n.center),n.radius=b):(e.clone(V,n.center),n.radius=H),n},_.fromCornerPoints=function(t,r,n){o(n)||(n=new _);var a=n.center;return e.add(t,r,a),e.multiplyByScalar(a,.5,a),n.radius=e.distance(a,r),n},_.fromEllipsoid=function(t,r){return o(r)||(r=new _),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var D=new e;_.fromBoundingSpheres=function(t,r){if(o(r)||(r=new _),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return _.clone(t[0],r);if(2===n)return _.union(t[0],t[1],r);var a,i=[];for(a=0;a<n;a++)i.push(t[a].center);r=_.fromPoints(i,r);var u=r.center,s=r.radius;for(a=0;a<n;a++){var E=t[a];s=Math.max(s,e.distance(u,E.center,D)+E.radius)}return r.radius=s,r};var x=new e,B=new e,w=new e;_.fromOrientedBoundingBox=function(t,r){o(r)||(r=new _);var n=t.halfAxes,a=c.getColumn(n,0,x),i=c.getColumn(n,1,B),u=c.getColumn(n,2,w);return e.add(a,i,a),e.add(a,u,a),r.center=e.clone(t.center,r.center),r.radius=e.magnitude(a),r},_.clone=function(t,r){if(o(t))return o(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new _(t.center,t.radius)},_.packedLength=4,_.pack=function(e,t,r){r=n(r,0);var o=e.center;return t[r++]=o.x,t[r++]=o.y,t[r++]=o.z,t[r]=e.radius,t},_.unpack=function(e,t,r){t=n(t,0),o(r)||(r=new _);var a=r.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],r.radius=e[t],r};var P=new e,b=new e;_.union=function(t,r,n){o(n)||(n=new _);var a=t.center,i=t.radius,u=r.center,s=r.radius,E=e.subtract(u,a,P),c=e.magnitude(E);if(i>=c+s)return t.clone(n),n;if(s>=c+i)return r.clone(n),n;var l=.5*(i+c+s),f=e.multiplyByScalar(E,(-i+l)/c,b);return e.add(f,a,f),e.clone(f,n.center),n.radius=l,n};var G=new e;_.expand=function(t,r,n){n=_.clone(t,n);var o=e.magnitude(e.subtract(r,n.center,G));return o>n.radius&&(n.radius=o),n},_.intersectPlane=function(t,r){var n=t.center,o=t.radius,a=r.normal,i=e.dot(a,n)+r.distance;return i<-o?u.OUTSIDE:i<o?u.INTERSECTING:u.INSIDE},_.transform=function(e,t,r){return o(r)||(r=new _),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=l.getMaximumScale(t)*e.radius,r};var z=new e;_.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,z);return e.magnitudeSquared(n)-t.radius*t.radius},_.transformWithoutScale=function(e,t,r){return o(r)||(r=new _),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var V=new e;_.computePlaneDistances=function(t,r,n,a){o(a)||(a=new s);var i=e.subtract(t.center,r,V),u=e.dot(n,i);return a.start=u-t.radius,a.stop=u+t.radius,a};for(var H=new e,X=new e,W=new e,Y=new e,q=new e,k=new t,K=new Array(8),Z=0;Z<8;++Z)K[Z]=new e;var j=new i;return _.projectTo2D=function(t,r,o){r=n(r,j);var a=r.ellipsoid,i=t.center,u=t.radius,s=a.geodeticSurfaceNormal(i,H),E=e.cross(e.UNIT_Z,s,X);e.normalize(E,E);var c=e.cross(s,E,W);e.normalize(c,c),e.multiplyByScalar(s,u,s),e.multiplyByScalar(c,u,c),e.multiplyByScalar(E,u,E);var l=e.negate(c,q),f=e.negate(E,Y),T=K,R=T[0];e.add(s,c,R),e.add(R,E,R),R=T[1],e.add(s,c,R),e.add(R,f,R),R=T[2],e.add(s,l,R),e.add(R,f,R),R=T[3],e.add(s,l,R),e.add(R,E,R),e.negate(s,s),R=T[4],e.add(s,c,R),e.add(R,E,R),R=T[5],e.add(s,c,R),e.add(R,f,R),R=T[6],e.add(s,l,R),e.add(R,f,R),R=T[7],e.add(s,l,R),e.add(R,E,R);for(var A=T.length,h=0;h<A;++h){var m=T[h];e.add(i,m,m);var d=a.cartesianToCartographic(m,k);r.project(d,m)}o=_.fromPoints(T,o),i=o.center;var S=i.x,C=i.y,I=i.z;return i.x=I,i.y=S,i.z=C,o},_.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},_.equals=function(t,r){return t===r||o(t)&&o(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},_.prototype.intersectPlane=function(e){return _.intersectPlane(this,e)},_.prototype.distanceSquaredTo=function(e){return _.distanceSquaredTo(this,e)},_.prototype.computePlaneDistances=function(e,t,r){return _.computePlaneDistances(this,e,t,r)},_.prototype.isOccluded=function(e){return _.isOccluded(this,e)},_.prototype.equals=function(e){return _.equals(this,e)},_.prototype.clone=function(e){return _.clone(this,e)},_.prototype.volume=function(){var e=this.radius;return O*e*e*e},_}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return t(o,{element:{get:function(){if(o.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(o.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(o.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(o.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(o.supportsFullscreen())return null!==o.element}}}),o.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var o,a=["webkit","moz","o","ms","khtml"],i=0,u=a.length;i<u;++i){var s=a[i];o=s+"RequestFullscreen","function"==typeof t[o]?(n.requestFullscreen=o,r=!0):(o=s+"RequestFullScreen","function"==typeof t[o]&&(n.requestFullscreen=o,r=!0)),o=s+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=s+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=s+"FullscreenEnabled",void 0!==document[o]?n.fullscreenEnabled=o:(o=s+"FullScreenEnabled",void 0!==document[o]&&(n.fullscreenEnabled=o)),o=s+"FullscreenElement",void 0!==document[o]?n.fullscreenElement=o:(o=s+"FullScreenElement",void 0!==document[o]&&(n.fullscreenElement=o)),o=s+"fullscreenchange",void 0!==document["on"+o]&&("ms"===s&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=s+"fullscreenerror",void 0!==document["on"+o]&&("ms"===s&&(o="MSFullscreenError"),n.fullscreenerror=o)}return r},
o.requestFullscreen=function(e,t){o.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function o(){if(!t(I)&&(I=!1,!f())){var e=/ Chrome\/([\.0-9]+)/.exec(C.userAgent);null!==e&&(I=!0,N=n(e[1]))}return I}function a(){return o()&&N}function i(){if(!t(p)&&(p=!1,!o()&&!f()&&/ Safari\/[\.0-9]+/.test(C.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(C.userAgent);null!==e&&(p=!0,y=n(e[1]))}return p}function u(){return i()&&y}function s(){if(!t(O)){O=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(C.userAgent);null!==e&&(O=!0,M=n(e[1]),M.isNightly=!!e[2])}return O}function E(){return s()&&M}function c(){if(!t(g)){g=!1;var e;"Microsoft Internet Explorer"===C.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(C.userAgent))&&(g=!0,F=n(e[1])):"Netscape"===C.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(C.userAgent))&&(g=!0,F=n(e[1]))}return g}function l(){return c()&&F}function f(){if(!t(L)){L=!1;var e=/ Edge\/([\.0-9]+)/.exec(C.userAgent);null!==e&&(L=!0,v=n(e[1]))}return L}function _(){return f()&&v}function T(){if(!t(U)){U=!1;var e=/Firefox\/([\.0-9]+)/.exec(C.userAgent);null!==e&&(U=!0,D=n(e[1]))}return U}function R(){return t(x)||(x=/Windows/i.test(C.appVersion)),x}function A(){return T()&&D}function h(){return t(B)||(B="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),B}function m(){return t(w)||(w="undefined"!=typeof PointerEvent&&(!t(C.pointerEnabled)||C.pointerEnabled)),w}function d(){if(!t(b)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;b=t(r)&&""!==r,b&&(P=r)}return b}function S(){return d()?P:void 0}var C;C="undefined"!=typeof navigator?navigator:{};var I,N,p,y,O,M,g,F,L,v,U,D,x,B,w,P,b,G=[];"undefined"!=typeof ArrayBuffer&&(G.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&G.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&G.push(CanvasPixelArray));var z={isChrome:o,chromeVersion:a,isSafari:i,safariVersion:u,isWebkit:s,webkitVersion:E,isInternetExplorer:c,internetExplorerVersion:l,isEdge:f,edgeVersion:_,isFirefox:T,firefoxVersion:A,isWindows:R,isNodeJs:h,hardwareConcurrency:e(C.hardwareConcurrency,3),supportsPointerEvents:m,supportsImageRenderingPixelated:d,imageRenderingValue:S,typedArrayTypes:G};return z.supportsFullscreen=function(){return r.supportsFullscreen()},z.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},z.supportsWebWorkers=function(){return"undefined"!=typeof Worker},z.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!z.isEdge()},z}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,o,a){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE};return i.getSizeInBytes=function(e){switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.INT:return Int32Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Int32Array?i.INT:e instanceof Uint32Array?i.UNSIGNED_INT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return t(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.INT||e===i.UNSIGNED_INT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,t){switch(e){case i.BYTE:return new Int8Array(t);case i.UNSIGNED_BYTE:return new Uint8Array(t);case i.SHORT:return new Int16Array(t);case i.UNSIGNED_SHORT:return new Uint16Array(t);case i.INT:return new Int32Array(t);case i.UNSIGNED_INT:return new Uint32Array(t);case i.FLOAT:return new Float32Array(t);case i.DOUBLE:return new Float64Array(t)}},i.createArrayBufferView=function(t,r,n,o){switch(n=e(n,0),o=e(o,(r.byteLength-n)/i.getSizeInBytes(t)),t){case i.BYTE:return new Int8Array(r,n,o);case i.UNSIGNED_BYTE:return new Uint8Array(r,n,o);case i.SHORT:return new Int16Array(r,n,o);case i.UNSIGNED_SHORT:return new Uint16Array(r,n,o);case i.INT:return new Int32Array(r,n,o);case i.UNSIGNED_INT:return new Uint32Array(r,n,o);case i.FLOAT:return new Float32Array(r,n,o);case i.DOUBLE:return new Float64Array(r,n,o)}},i.fromName=function(e){switch(e){case"BYTE":return i.BYTE;case"UNSIGNED_BYTE":return i.UNSIGNED_BYTE;case"SHORT":return i.SHORT;case"UNSIGNED_SHORT":return i.UNSIGNED_SHORT;case"INT":return i.INT;case"UNSIGNED_INT":return i.UNSIGNED_INT;case"FLOAT":return i.FLOAT;case"DOUBLE":return i.DOUBLE}},o(i)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";return e({NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3})}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Geometry",["./Check","./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,o,a){"use strict";function i(e){e=t(e,t.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=t(e.primitiveType,a.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=t(e.geometryType,o.NONE),this.boundingSphereCV=e.boundingSphereCV}return i.computeNumberOfVertices=function(e){var t=-1;for(var n in e.attributes)if(e.attributes.hasOwnProperty(n)&&r(e.attributes[n])&&r(e.attributes[n].values)){var o=e.attributes[n],a=o.values.length/o.componentsPerAttribute;t=a}return t},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return o.POSITION_ONLY=n(new o({position:!0})),o.POSITION_AND_NORMAL=n(new o({position:!0,normal:!0})),o.POSITION_NORMAL_AND_ST=n(new o({position:!0,normal:!0,st:!0})),o.POSITION_AND_ST=n(new o({position:!0,st:!0})),o.POSITION_AND_COLOR=n(new o({position:!0,color:!0})),o.ALL=n(new o({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),o.DEFAULT=o.POSITION_NORMAL_AND_ST,o.packedLength=6,o.pack=function(t,r,n){return n=e(n,0),r[n++]=t.position?1:0,r[n++]=t.normal?1:0,r[n++]=t.st?1:0,r[n++]=t.tangent?1:0,r[n++]=t.bitangent?1:0,r[n]=t.color?1:0,r},o.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new o),a.position=1===r[n++],a.normal=1===r[n++],a.st=1===r[n++],a.tangent=1===r[n++],a.bitangent=1===r[n++],a.color=1===r[n],a},o.clone=function(e,r){if(t(e))return t(r)||(r=new o),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r},o}),define("Core/BoxGeometry",["./BoundingSphere","./Cartesian3","./Check","./ComponentDatatype","./defaultValue","./defined","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType","./VertexFormat"],function(e,t,r,n,o,a,i,u,s,E,c){"use strict";function l(e){e=o(e,o.EMPTY_OBJECT);var r=e.minimum,n=e.maximum,a=o(e.vertexFormat,c.DEFAULT);this._minimum=t.clone(r),this._maximum=t.clone(n),this._vertexFormat=a,this._workerName="createBoxGeometry"}var f=new t;l.fromDimensions=function(e){e=o(e,o.EMPTY_OBJECT);var r=e.dimensions,n=t.multiplyByScalar(r,.5,new t);return new l({minimum:t.negate(n,new t),maximum:n,vertexFormat:e.vertexFormat})},l.fromAxisAlignedBoundingBox=function(e){return new l({minimum:e.minimum,maximum:e.maximum})},l.packedLength=2*t.packedLength+c.packedLength,l.pack=function(e,r,n){return n=o(n,0),t.pack(e._minimum,r,n),t.pack(e._maximum,r,n+t.packedLength),c.pack(e._vertexFormat,r,n+2*t.packedLength),r};var _=new t,T=new t,R=new c,A={minimum:_,maximum:T,vertexFormat:R};l.unpack=function(e,r,n){r=o(r,0);var i=t.unpack(e,r,_),u=t.unpack(e,r+t.packedLength,T),s=c.unpack(e,r+2*t.packedLength,R);return a(n)?(n._minimum=t.clone(i,n._minimum),n._maximum=t.clone(u,n._maximum),n._vertexFormat=c.clone(s,n._vertexFormat),n):new l(A)},l.createGeometry=function(r){var o=r._minimum,a=r._maximum,c=r._vertexFormat;if(!t.equals(o,a)){var l,_,T=new s;if(c.position&&(c.st||c.normal||c.tangent||c.bitangent)){if(c.position&&(_=new Float64Array(72),_[0]=o.x,_[1]=o.y,_[2]=a.z,_[3]=a.x,_[4]=o.y,_[5]=a.z,_[6]=a.x,_[7]=a.y,_[8]=a.z,_[9]=o.x,_[10]=a.y,_[11]=a.z,_[12]=o.x,_[13]=o.y,_[14]=o.z,_[15]=a.x,_[16]=o.y,_[17]=o.z,_[18]=a.x,_[19]=a.y,_[20]=o.z,_[21]=o.x,_[22]=a.y,_[23]=o.z,_[24]=a.x,_[25]=o.y,_[26]=o.z,_[27]=a.x,_[28]=a.y,_[29]=o.z,_[30]=a.x,_[31]=a.y,_[32]=a.z,_[33]=a.x,_[34]=o.y,_[35]=a.z,_[36]=o.x,_[37]=o.y,_[38]=o.z,_[39]=o.x,_[40]=a.y,_[41]=o.z,_[42]=o.x,_[43]=a.y,_[44]=a.z,_[45]=o.x,_[46]=o.y,_[47]=a.z,_[48]=o.x,_[49]=a.y,_[50]=o.z,_[51]=a.x,_[52]=a.y,_[53]=o.z,_[54]=a.x,_[55]=a.y,_[56]=a.z,_[57]=o.x,_[58]=a.y,_[59]=a.z,_[60]=o.x,_[61]=o.y,_[62]=o.z,_[63]=a.x,_[64]=o.y,_[65]=o.z,_[66]=a.x,_[67]=o.y,_[68]=a.z,_[69]=o.x,_[70]=o.y,_[71]=a.z,T.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:_})),c.normal){var R=new Float32Array(72);R[0]=0,R[1]=0,R[2]=1,R[3]=0,R[4]=0,R[5]=1,R[6]=0,R[7]=0,R[8]=1,R[9]=0,R[10]=0,R[11]=1,R[12]=0,R[13]=0,R[14]=-1,R[15]=0,R[16]=0,R[17]=-1,R[18]=0,R[19]=0,R[20]=-1,R[21]=0,R[22]=0,R[23]=-1,R[24]=1,R[25]=0,R[26]=0,R[27]=1,R[28]=0,R[29]=0,R[30]=1,R[31]=0,R[32]=0,R[33]=1,R[34]=0,R[35]=0,R[36]=-1,R[37]=0,R[38]=0,R[39]=-1,R[40]=0,R[41]=0,R[42]=-1,R[43]=0,R[44]=0,R[45]=-1,R[46]=0,R[47]=0,R[48]=0,R[49]=1,R[50]=0,R[51]=0,R[52]=1,R[53]=0,R[54]=0,R[55]=1,R[56]=0,R[57]=0,R[58]=1,R[59]=0,R[60]=0,R[61]=-1,R[62]=0,R[63]=0,R[64]=-1,R[65]=0,R[66]=0,R[67]=-1,R[68]=0,R[69]=0,R[70]=-1,R[71]=0,T.normal=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:R})}if(c.st){var A=new Float32Array(48);A[0]=0,A[1]=0,A[2]=1,A[3]=0,A[4]=1,A[5]=1,A[6]=0,A[7]=1,A[8]=1,A[9]=0,A[10]=0,A[11]=0,A[12]=0,A[13]=1,A[14]=1,A[15]=1,A[16]=0,A[17]=0,A[18]=1,A[19]=0,A[20]=1,A[21]=1,A[22]=0,A[23]=1,A[24]=1,A[25]=0,A[26]=0,A[27]=0,A[28]=0,A[29]=1,A[30]=1,A[31]=1,A[32]=1,A[33]=0,A[34]=0,A[35]=0,A[36]=0,A[37]=1,A[38]=1,A[39]=1,A[40]=0,A[41]=0,A[42]=1,A[43]=0,A[44]=1,A[45]=1,A[46]=0,A[47]=1,T.st=new u({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:A})}if(c.tangent){var h=new Float32Array(72);h[0]=1,h[1]=0,h[2]=0,h[3]=1,h[4]=0,h[5]=0,h[6]=1,h[7]=0,h[8]=0,h[9]=1,h[10]=0,h[11]=0,h[12]=-1,h[13]=0,h[14]=0,h[15]=-1,h[16]=0,h[17]=0,h[18]=-1,h[19]=0,h[20]=0,h[21]=-1,h[22]=0,h[23]=0,h[24]=0,h[25]=1,h[26]=0,h[27]=0,h[28]=1,h[29]=0,h[30]=0,h[31]=1,h[32]=0,h[33]=0,h[34]=1,h[35]=0,h[36]=0,h[37]=-1,h[38]=0,h[39]=0,h[40]=-1,h[41]=0,h[42]=0,h[43]=-1,h[44]=0,h[45]=0,h[46]=-1,h[47]=0,h[48]=-1,h[49]=0,h[50]=0,h[51]=-1,h[52]=0,h[53]=0,h[54]=-1,h[55]=0,h[56]=0,h[57]=-1,h[58]=0,h[59]=0,h[60]=1,h[61]=0,h[62]=0,h[63]=1,h[64]=0,h[65]=0,h[66]=1,h[67]=0,h[68]=0,h[69]=1,h[70]=0,h[71]=0,T.tangent=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:h})}if(c.bitangent){var m=new Float32Array(72);m[0]=0,m[1]=1,m[2]=0,m[3]=0,m[4]=1,m[5]=0,m[6]=0,m[7]=1,m[8]=0,m[9]=0,m[10]=1,m[11]=0,m[12]=0,m[13]=1,m[14]=0,m[15]=0,m[16]=1,m[17]=0,m[18]=0,m[19]=1,m[20]=0,m[21]=0,m[22]=1,m[23]=0,m[24]=0,m[25]=0,m[26]=1,m[27]=0,m[28]=0,m[29]=1,m[30]=0,m[31]=0,m[32]=1,m[33]=0,m[34]=0,m[35]=1,m[36]=0,m[37]=0,m[38]=1,m[39]=0,m[40]=0,m[41]=1,m[42]=0,m[43]=0,m[44]=1,m[45]=0,m[46]=0,m[47]=1,m[48]=0,m[49]=0,m[50]=1,m[51]=0,m[52]=0,m[53]=1,m[54]=0,m[55]=0,m[56]=1,m[57]=0,m[58]=0,m[59]=1,m[60]=0,m[61]=0,m[62]=1,m[63]=0,m[64]=0,m[65]=1,m[66]=0,m[67]=0,m[68]=1,m[69]=0,m[70]=0,m[71]=1,T.bitangent=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:m})}l=new Uint16Array(36),l[0]=0,l[1]=1,l[2]=2,l[3]=0,l[4]=2,l[5]=3,l[6]=6,l[7]=5,l[8]=4,l[9]=7,l[10]=6,l[11]=4,l[12]=8,l[13]=9,l[14]=10,l[15]=8,l[16]=10,l[17]=11,l[18]=14,l[19]=13,l[20]=12,l[21]=15,l[22]=14,l[23]=12,l[24]=18,l[25]=17,l[26]=16,l[27]=19,l[28]=18,l[29]=16,l[30]=20,l[31]=21,l[32]=22,l[33]=20,l[34]=22,l[35]=23}else _=new Float64Array(24),_[0]=o.x,_[1]=o.y,_[2]=o.z,_[3]=a.x,_[4]=o.y,_[5]=o.z,_[6]=a.x,_[7]=a.y,_[8]=o.z,_[9]=o.x,_[10]=a.y,_[11]=o.z,_[12]=o.x,_[13]=o.y,_[14]=a.z,_[15]=a.x,_[16]=o.y,_[17]=a.z,_[18]=a.x,_[19]=a.y,_[20]=a.z,_[21]=o.x,_[22]=a.y,_[23]=a.z,T.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:_}),l=new Uint16Array(36),l[0]=4,l[1]=5,l[2]=6,l[3]=4,l[4]=6,l[5]=7,l[6]=1,l[7]=0,l[8]=3,l[9]=1,l[10]=3,l[11]=2,l[12]=1,l[13]=6,l[14]=5,l[15]=1,l[16]=2,l[17]=6,l[18]=2,l[19]=3,l[20]=7,l[21]=2,l[22]=7,l[23]=6,l[24]=3,l[25]=0,l[26]=4,l[27]=3,l[28]=4,l[29]=7,l[30]=0,l[31]=1,l[32]=5,l[33]=0,l[34]=5,l[35]=4;var d=t.subtract(a,o,f),S=.5*t.magnitude(d);return new i({attributes:T,indices:l,primitiveType:E.TRIANGLES,boundingSphere:new e(t.ZERO,S)})}};var h;return l.getUnitBox=function(){return a(h)||(h=l.createGeometry(l.fromDimensions({dimensions:new t(1,1,1),vertexFormat:c.POSITION_ONLY}))),h},l}),define("Core/Color",["./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math"],function(e,t,r,n,o,a){"use strict";function i(e,t,r){return r<0&&(r+=1),r>1&&(r-=1),6*r<1?e+6*(t-e)*r:2*r<1?t:3*r<2?e+(t-e)*(2/3-r)*6:e}function u(e,r,n,o){this.red=t(e,1),this.green=t(r,1),this.blue=t(n,1),this.alpha=t(o,1)}u.fromCartesian4=function(e,t){return r(t)?(t.red=e.x,t.green=e.y,t.blue=e.z,t.alpha=e.w,t):new u(e.x,e.y,e.z,e.w)},u.fromBytes=function(e,n,o,a,i){return e=u.byteToFloat(t(e,255)),n=u.byteToFloat(t(n,255)),o=u.byteToFloat(t(o,255)),a=u.byteToFloat(t(a,255)),r(i)?(i.red=e,i.green=n,i.blue=o,i.alpha=a,i):new u(e,n,o,a)},u.fromAlpha=function(e,t,n){return r(n)?(n.red=e.red,n.green=e.green,n.blue=e.blue,n.alpha=t,n):new u(e.red,e.green,e.blue,t)};var s,E,c;n.supportsTypedArrays()&&(s=new ArrayBuffer(4),E=new Uint32Array(s),c=new Uint8Array(s)),u.fromRgba=function(e,t){return E[0]=e,u.fromBytes(c[0],c[1],c[2],c[3],t)},u.fromHsl=function(e,n,o,a,s){e=t(e,0)%1,n=t(n,0),o=t(o,0),a=t(a,1);var E=o,c=o,l=o;if(0!==n){var f;f=o<.5?o*(1+n):o+n-o*n;var _=2*o-f;E=i(_,f,e+1/3),c=i(_,f,e),l=i(_,f,e-1/3)}return r(s)?(s.red=E,s.green=c,s.blue=l,s.alpha=a,s):new u(E,c,l,a)},u.fromRandom=function(e,n){e=t(e,t.EMPTY_OBJECT);var o=e.red;if(!r(o)){var i=t(e.minimumRed,0),s=t(e.maximumRed,1);o=i+a.nextRandomNumber()*(s-i)}var E=e.green;if(!r(E)){var c=t(e.minimumGreen,0),l=t(e.maximumGreen,1);E=c+a.nextRandomNumber()*(l-c)}var f=e.blue;if(!r(f)){var _=t(e.minimumBlue,0),T=t(e.maximumBlue,1);f=_+a.nextRandomNumber()*(T-_)}var R=e.alpha;if(!r(R)){var A=t(e.minimumAlpha,0),h=t(e.maximumAlpha,1);R=A+a.nextRandomNumber()*(h-A)}return r(n)?(n.red=o,n.green=E,n.blue=f,n.alpha=R,n):new u(o,E,f,R)};var l=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,f=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,_=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,T=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return u.fromCssColorString=function(e,n){r(n)||(n=new u);var o=u[e.toUpperCase()];if(r(o))return u.clone(o,n),n;var a=l.exec(e);return null!==a?(n.red=parseInt(a[1],16)/15,n.green=parseInt(a[2],16)/15,n.blue=parseInt(a[3],16)/15,n.alpha=1,n):null!==(a=f.exec(e))?(n.red=parseInt(a[1],16)/255,n.green=parseInt(a[2],16)/255,n.blue=parseInt(a[3],16)/255,n.alpha=1,n):null!==(a=_.exec(e))?(n.red=parseFloat(a[1])/("%"===a[1].substr(-1)?100:255),n.green=parseFloat(a[2])/("%"===a[2].substr(-1)?100:255),n.blue=parseFloat(a[3])/("%"===a[3].substr(-1)?100:255),n.alpha=parseFloat(t(a[4],"1.0")),n):null!==(a=T.exec(e))?u.fromHsl(parseFloat(a[1])/360,parseFloat(a[2])/100,parseFloat(a[3])/100,parseFloat(t(a[4],"1.0")),n):n=void 0},u.packedLength=4,u.pack=function(e,r,n){return n=t(n,0),r[n++]=e.red,r[n++]=e.green,r[n++]=e.blue,r[n]=e.alpha,r},u.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new u),o.red=e[n++],o.green=e[n++],o.blue=e[n++],o.alpha=e[n],o},u.byteToFloat=function(e){return e/255},u.floatToByte=function(e){return 1===e?255:256*e|0},u.clone=function(e,t){if(r(e))return r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new u(e.red,e.green,e.blue,e.alpha)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},u.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},u.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},u.prototype.toCssColorString=function(){var e=u.floatToByte(this.red),t=u.floatToByte(this.green),r=u.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},u.prototype.toBytes=function(e){
var t=u.floatToByte(this.red),n=u.floatToByte(this.green),o=u.floatToByte(this.blue),a=u.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=o,e[3]=a,e):[t,n,o,a]},u.prototype.toRgba=function(){return c[0]=u.floatToByte(this.red),c[1]=u.floatToByte(this.green),c[2]=u.floatToByte(this.blue),c[3]=u.floatToByte(this.alpha),E[0]},u.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},u.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},u.prototype.withAlpha=function(e,t){return u.fromAlpha(this,e,t)},u.add=function(e,t,r){return r.red=e.red+t.red,r.green=e.green+t.green,r.blue=e.blue+t.blue,r.alpha=e.alpha+t.alpha,r},u.subtract=function(e,t,r){return r.red=e.red-t.red,r.green=e.green-t.green,r.blue=e.blue-t.blue,r.alpha=e.alpha-t.alpha,r},u.multiply=function(e,t,r){return r.red=e.red*t.red,r.green=e.green*t.green,r.blue=e.blue*t.blue,r.alpha=e.alpha*t.alpha,r},u.divide=function(e,t,r){return r.red=e.red/t.red,r.green=e.green/t.green,r.blue=e.blue/t.blue,r.alpha=e.alpha/t.alpha,r},u.mod=function(e,t,r){return r.red=e.red%t.red,r.green=e.green%t.green,r.blue=e.blue%t.blue,r.alpha=e.alpha%t.alpha,r},u.multiplyByScalar=function(e,t,r){return r.red=e.red*t,r.green=e.green*t,r.blue=e.blue*t,r.alpha=e.alpha*t,r},u.divideByScalar=function(e,t,r){return r.red=e.red/t,r.green=e.green/t,r.blue=e.blue/t,r.alpha=e.alpha/t,r},u.ALICEBLUE=o(u.fromCssColorString("#F0F8FF")),u.ANTIQUEWHITE=o(u.fromCssColorString("#FAEBD7")),u.AQUA=o(u.fromCssColorString("#00FFFF")),u.AQUAMARINE=o(u.fromCssColorString("#7FFFD4")),u.AZURE=o(u.fromCssColorString("#F0FFFF")),u.BEIGE=o(u.fromCssColorString("#F5F5DC")),u.BISQUE=o(u.fromCssColorString("#FFE4C4")),u.BLACK=o(u.fromCssColorString("#000000")),u.BLANCHEDALMOND=o(u.fromCssColorString("#FFEBCD")),u.BLUE=o(u.fromCssColorString("#0000FF")),u.BLUEVIOLET=o(u.fromCssColorString("#8A2BE2")),u.BROWN=o(u.fromCssColorString("#A52A2A")),u.BURLYWOOD=o(u.fromCssColorString("#DEB887")),u.CADETBLUE=o(u.fromCssColorString("#5F9EA0")),u.CHARTREUSE=o(u.fromCssColorString("#7FFF00")),u.CHOCOLATE=o(u.fromCssColorString("#D2691E")),u.CORAL=o(u.fromCssColorString("#FF7F50")),u.CORNFLOWERBLUE=o(u.fromCssColorString("#6495ED")),u.CORNSILK=o(u.fromCssColorString("#FFF8DC")),u.CRIMSON=o(u.fromCssColorString("#DC143C")),u.CYAN=o(u.fromCssColorString("#00FFFF")),u.DARKBLUE=o(u.fromCssColorString("#00008B")),u.DARKCYAN=o(u.fromCssColorString("#008B8B")),u.DARKGOLDENROD=o(u.fromCssColorString("#B8860B")),u.DARKGRAY=o(u.fromCssColorString("#A9A9A9")),u.DARKGREEN=o(u.fromCssColorString("#006400")),u.DARKGREY=u.DARKGRAY,u.DARKKHAKI=o(u.fromCssColorString("#BDB76B")),u.DARKMAGENTA=o(u.fromCssColorString("#8B008B")),u.DARKOLIVEGREEN=o(u.fromCssColorString("#556B2F")),u.DARKORANGE=o(u.fromCssColorString("#FF8C00")),u.DARKORCHID=o(u.fromCssColorString("#9932CC")),u.DARKRED=o(u.fromCssColorString("#8B0000")),u.DARKSALMON=o(u.fromCssColorString("#E9967A")),u.DARKSEAGREEN=o(u.fromCssColorString("#8FBC8F")),u.DARKSLATEBLUE=o(u.fromCssColorString("#483D8B")),u.DARKSLATEGRAY=o(u.fromCssColorString("#2F4F4F")),u.DARKSLATEGREY=u.DARKSLATEGRAY,u.DARKTURQUOISE=o(u.fromCssColorString("#00CED1")),u.DARKVIOLET=o(u.fromCssColorString("#9400D3")),u.DEEPPINK=o(u.fromCssColorString("#FF1493")),u.DEEPSKYBLUE=o(u.fromCssColorString("#00BFFF")),u.DIMGRAY=o(u.fromCssColorString("#696969")),u.DIMGREY=u.DIMGRAY,u.DODGERBLUE=o(u.fromCssColorString("#1E90FF")),u.FIREBRICK=o(u.fromCssColorString("#B22222")),u.FLORALWHITE=o(u.fromCssColorString("#FFFAF0")),u.FORESTGREEN=o(u.fromCssColorString("#228B22")),u.FUCHSIA=o(u.fromCssColorString("#FF00FF")),u.GAINSBORO=o(u.fromCssColorString("#DCDCDC")),u.GHOSTWHITE=o(u.fromCssColorString("#F8F8FF")),u.GOLD=o(u.fromCssColorString("#FFD700")),u.GOLDENROD=o(u.fromCssColorString("#DAA520")),u.GRAY=o(u.fromCssColorString("#808080")),u.GREEN=o(u.fromCssColorString("#008000")),u.GREENYELLOW=o(u.fromCssColorString("#ADFF2F")),u.GREY=u.GRAY,u.HONEYDEW=o(u.fromCssColorString("#F0FFF0")),u.HOTPINK=o(u.fromCssColorString("#FF69B4")),u.INDIANRED=o(u.fromCssColorString("#CD5C5C")),u.INDIGO=o(u.fromCssColorString("#4B0082")),u.IVORY=o(u.fromCssColorString("#FFFFF0")),u.KHAKI=o(u.fromCssColorString("#F0E68C")),u.LAVENDER=o(u.fromCssColorString("#E6E6FA")),u.LAVENDAR_BLUSH=o(u.fromCssColorString("#FFF0F5")),u.LAWNGREEN=o(u.fromCssColorString("#7CFC00")),u.LEMONCHIFFON=o(u.fromCssColorString("#FFFACD")),u.LIGHTBLUE=o(u.fromCssColorString("#ADD8E6")),u.LIGHTCORAL=o(u.fromCssColorString("#F08080")),u.LIGHTCYAN=o(u.fromCssColorString("#E0FFFF")),u.LIGHTGOLDENRODYELLOW=o(u.fromCssColorString("#FAFAD2")),u.LIGHTGRAY=o(u.fromCssColorString("#D3D3D3")),u.LIGHTGREEN=o(u.fromCssColorString("#90EE90")),u.LIGHTGREY=u.LIGHTGRAY,u.LIGHTPINK=o(u.fromCssColorString("#FFB6C1")),u.LIGHTSEAGREEN=o(u.fromCssColorString("#20B2AA")),u.LIGHTSKYBLUE=o(u.fromCssColorString("#87CEFA")),u.LIGHTSLATEGRAY=o(u.fromCssColorString("#778899")),u.LIGHTSLATEGREY=u.LIGHTSLATEGRAY,u.LIGHTSTEELBLUE=o(u.fromCssColorString("#B0C4DE")),u.LIGHTYELLOW=o(u.fromCssColorString("#FFFFE0")),u.LIME=o(u.fromCssColorString("#00FF00")),u.LIMEGREEN=o(u.fromCssColorString("#32CD32")),u.LINEN=o(u.fromCssColorString("#FAF0E6")),u.MAGENTA=o(u.fromCssColorString("#FF00FF")),u.MAROON=o(u.fromCssColorString("#800000")),u.MEDIUMAQUAMARINE=o(u.fromCssColorString("#66CDAA")),u.MEDIUMBLUE=o(u.fromCssColorString("#0000CD")),u.MEDIUMORCHID=o(u.fromCssColorString("#BA55D3")),u.MEDIUMPURPLE=o(u.fromCssColorString("#9370DB")),u.MEDIUMSEAGREEN=o(u.fromCssColorString("#3CB371")),u.MEDIUMSLATEBLUE=o(u.fromCssColorString("#7B68EE")),u.MEDIUMSPRINGGREEN=o(u.fromCssColorString("#00FA9A")),u.MEDIUMTURQUOISE=o(u.fromCssColorString("#48D1CC")),u.MEDIUMVIOLETRED=o(u.fromCssColorString("#C71585")),u.MIDNIGHTBLUE=o(u.fromCssColorString("#191970")),u.MINTCREAM=o(u.fromCssColorString("#F5FFFA")),u.MISTYROSE=o(u.fromCssColorString("#FFE4E1")),u.MOCCASIN=o(u.fromCssColorString("#FFE4B5")),u.NAVAJOWHITE=o(u.fromCssColorString("#FFDEAD")),u.NAVY=o(u.fromCssColorString("#000080")),u.OLDLACE=o(u.fromCssColorString("#FDF5E6")),u.OLIVE=o(u.fromCssColorString("#808000")),u.OLIVEDRAB=o(u.fromCssColorString("#6B8E23")),u.ORANGE=o(u.fromCssColorString("#FFA500")),u.ORANGERED=o(u.fromCssColorString("#FF4500")),u.ORCHID=o(u.fromCssColorString("#DA70D6")),u.PALEGOLDENROD=o(u.fromCssColorString("#EEE8AA")),u.PALEGREEN=o(u.fromCssColorString("#98FB98")),u.PALETURQUOISE=o(u.fromCssColorString("#AFEEEE")),u.PALEVIOLETRED=o(u.fromCssColorString("#DB7093")),u.PAPAYAWHIP=o(u.fromCssColorString("#FFEFD5")),u.PEACHPUFF=o(u.fromCssColorString("#FFDAB9")),u.PERU=o(u.fromCssColorString("#CD853F")),u.PINK=o(u.fromCssColorString("#FFC0CB")),u.PLUM=o(u.fromCssColorString("#DDA0DD")),u.POWDERBLUE=o(u.fromCssColorString("#B0E0E6")),u.PURPLE=o(u.fromCssColorString("#800080")),u.RED=o(u.fromCssColorString("#FF0000")),u.ROSYBROWN=o(u.fromCssColorString("#BC8F8F")),u.ROYALBLUE=o(u.fromCssColorString("#4169E1")),u.SADDLEBROWN=o(u.fromCssColorString("#8B4513")),u.SALMON=o(u.fromCssColorString("#FA8072")),u.SANDYBROWN=o(u.fromCssColorString("#F4A460")),u.SEAGREEN=o(u.fromCssColorString("#2E8B57")),u.SEASHELL=o(u.fromCssColorString("#FFF5EE")),u.SIENNA=o(u.fromCssColorString("#A0522D")),u.SILVER=o(u.fromCssColorString("#C0C0C0")),u.SKYBLUE=o(u.fromCssColorString("#87CEEB")),u.SLATEBLUE=o(u.fromCssColorString("#6A5ACD")),u.SLATEGRAY=o(u.fromCssColorString("#708090")),u.SLATEGREY=u.SLATEGRAY,u.SNOW=o(u.fromCssColorString("#FFFAFA")),u.SPRINGGREEN=o(u.fromCssColorString("#00FF7F")),u.STEELBLUE=o(u.fromCssColorString("#4682B4")),u.TAN=o(u.fromCssColorString("#D2B48C")),u.TEAL=o(u.fromCssColorString("#008080")),u.THISTLE=o(u.fromCssColorString("#D8BFD8")),u.TOMATO=o(u.fromCssColorString("#FF6347")),u.TURQUOISE=o(u.fromCssColorString("#40E0D0")),u.VIOLET=o(u.fromCssColorString("#EE82EE")),u.WHEAT=o(u.fromCssColorString("#F5DEB3")),u.WHITE=o(u.fromCssColorString("#FFFFFF")),u.WHITESMOKE=o(u.fromCssColorString("#F5F5F5")),u.YELLOW=o(u.fromCssColorString("#FFFF00")),u.YELLOWGREEN=o(u.fromCssColorString("#9ACD32")),u.TRANSPARENT=o(new u(0,0,0,0)),u}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,a){"use strict";function i(e,r){this.x=t(e,0),this.y=t(r,0)}i.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new i(e,t)},i.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new i(e.x,e.y)},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n]=e.y,r},i.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new i),o.x=e[n++],o.y=e[n],o},i.packArray=function(e,t){var n=e.length;r(t)?t.length=2*n:t=new Array(2*n);for(var o=0;o<n;++o)i.pack(e[o],t,2*o);return t},i.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/2:t=new Array(n/2);for(var o=0;o<n;o+=2){var a=o/2;t[a]=i.unpack(e,o,t[a])}return t},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var u=new i;i.distance=function(e,t){return i.subtract(e,t,u),i.magnitude(u)},i.distanceSquared=function(e,t){return i.subtract(e,t,u),i.magnitudeSquared(u)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},i.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var s=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,s),n=i.multiplyByScalar(e,1-r,n),i.add(s,n,n)};var E=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,E),i.normalize(t,c),a.acosClamped(i.dot(E,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},i.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,o)&&a.equalsEpsilon(e.y,t.y,n,o)},i.ZERO=o(new i(0,0)),i.UNIT_X=o(new i(1,0)),i.UNIT_Y=o(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/CylinderGeometryLibrary",["./Math"],function(e){"use strict";var t={};return t.computePositions=function(t,r,n,o,a){var i,u=.5*t,s=-u,E=o+o,c=a?2*E:E,l=new Float64Array(3*c),f=0,_=0,T=a?3*E:0,R=a?3*(E+o):3*o;for(i=0;i<o;i++){var A=i/o*e.TWO_PI,h=Math.cos(A),m=Math.sin(A),d=h*n,S=m*n,C=h*r,I=m*r;l[_+T]=d,l[_+T+1]=S,l[_+T+2]=s,l[_+R]=C,l[_+R+1]=I,l[_+R+2]=u,_+=3,a&&(l[f++]=d,l[f++]=S,l[f++]=s,l[f++]=C,l[f++]=I,l[f++]=u)}return l},t}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,o){"use strict";var a={UNSIGNED_BYTE:o.UNSIGNED_BYTE,UNSIGNED_SHORT:o.UNSIGNED_SHORT,UNSIGNED_INT:o.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(e,t){return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},a.createTypedArrayFromArrayBuffer=function(e,t,r,o){return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,o):new Uint16Array(t,r,o)},r(a)}),define("Core/CylinderGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CylinderGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,n,o,a,i,u,s,E,c,l,f,_,T){"use strict";function R(e){e=a(e,a.EMPTY_OBJECT);var t=e.length,r=e.topRadius,n=e.bottomRadius,o=a(e.vertexFormat,T.DEFAULT),i=a(e.slices,128);this._length=t,this._topRadius=r,this._bottomRadius=n,this._vertexFormat=T.clone(o),this._slices=i,this._workerName="createCylinderGeometry"}var A=new t,h=new r,m=new r,d=new r,S=new r;R.packedLength=T.packedLength+4,R.pack=function(e,t,r){return r=a(r,0),T.pack(e._vertexFormat,t,r),r+=T.packedLength,t[r++]=e._length,t[r++]=e._topRadius,t[r++]=e._bottomRadius,t[r]=e._slices,t};var C=new T,I={vertexFormat:C,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0};R.unpack=function(e,t,r){t=a(t,0);var n=T.unpack(e,t,C);t+=T.packedLength;var o=e[t++],u=e[t++],s=e[t++],E=e[t];return i(r)?(r._vertexFormat=T.clone(n,r._vertexFormat),r._length=o,r._topRadius=u,r._bottomRadius=s,r._slices=E,r):(I.length=o,I.topRadius=u,I.bottomRadius=s,I.slices=E,new R(I))},R.createGeometry=function(a){var i=a._length,u=a._topRadius,T=a._bottomRadius,R=a._vertexFormat,C=a._slices;if(!(i<=0||u<0||T<0||0===u&&0===T)){var I,N=C+C,p=C+N,y=N+N,O=o.computePositions(i,u,T,C,!0),M=R.st?new Float32Array(2*y):void 0,g=R.normal?new Float32Array(3*y):void 0,F=R.tangent?new Float32Array(3*y):void 0,L=R.bitangent?new Float32Array(3*y):void 0,v=R.normal||R.tangent||R.bitangent;if(v){var U=R.tangent||R.bitangent,D=0,x=0,B=0,w=h;w.z=0;var P=d,b=m;for(I=0;I<C;I++){var G=I/C*f.TWO_PI,z=Math.cos(G),V=Math.sin(G);v&&(w.x=z,w.y=V,U&&(P=r.normalize(r.cross(r.UNIT_Z,w,P),P)),R.normal&&(g[D++]=z,g[D++]=V,g[D++]=0,g[D++]=z,g[D++]=V,g[D++]=0),R.tangent&&(F[x++]=P.x,F[x++]=P.y,F[x++]=P.z,F[x++]=P.x,F[x++]=P.y,F[x++]=P.z),R.bitangent&&(b=r.normalize(r.cross(w,P,b),b),L[B++]=b.x,L[B++]=b.y,L[B++]=b.z,L[B++]=b.x,L[B++]=b.y,L[B++]=b.z))}for(I=0;I<C;I++)R.normal&&(g[D++]=0,g[D++]=0,g[D++]=-1),R.tangent&&(F[x++]=1,F[x++]=0,F[x++]=0),R.bitangent&&(L[B++]=0,L[B++]=-1,L[B++]=0);for(I=0;I<C;I++)R.normal&&(g[D++]=0,g[D++]=0,g[D++]=1),R.tangent&&(F[x++]=1,F[x++]=0,F[x++]=0),R.bitangent&&(L[B++]=0,L[B++]=1,L[B++]=0)}var H=12*C-12,X=l.createTypedArray(y,H),W=0,Y=0;for(I=0;I<C-1;I++)X[W++]=Y,X[W++]=Y+2,X[W++]=Y+3,X[W++]=Y,X[W++]=Y+3,X[W++]=Y+1,Y+=2;for(X[W++]=N-2,X[W++]=0,X[W++]=1,X[W++]=N-2,X[W++]=1,X[W++]=N-1,I=1;I<C-1;I++)X[W++]=N+I+1,X[W++]=N+I,X[W++]=N;for(I=1;I<C-1;I++)X[W++]=p,X[W++]=p+I,X[W++]=p+I+1;var q=0;if(R.st){var k=Math.max(u,T);for(I=0;I<y;I++){var K=r.fromArray(O,3*I,S);M[q++]=(K.x+k)/(2*k),M[q++]=(K.y+k)/(2*k)}}var Z=new c;R.position&&(Z.position=new E({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:O})),R.normal&&(Z.normal=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:g})),R.tangent&&(Z.tangent=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:F})),R.bitangent&&(Z.bitangent=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:L})),R.st&&(Z.st=new E({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:M})),A.x=.5*i,A.y=Math.max(T,u);var j=new e(r.ZERO,t.magnitude(A));return new s({attributes:Z,indices:X,primitiveType:_.TRIANGLES,boundingSphere:j})}};var N;return R.getUnitCylinder=function(){return i(N)||(N=R.createGeometry(new R({topRadius:1,bottomRadius:1,length:1,vertexFormat:T.POSITION_ONLY}))),N},R}),define("Core/EllipsoidGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,n,o,a,i,u,s,E,c,l,f,_,T){"use strict";function R(e){e=o(e,o.EMPTY_OBJECT);var t=o(e.radii,C),n=Math.round(o(e.stackPartitions,64)),a=Math.round(o(e.slicePartitions,64)),i=o(e.vertexFormat,T.DEFAULT);this._radii=r.clone(t),this._stackPartitions=n,this._slicePartitions=a,this._vertexFormat=T.clone(i),this._workerName="createEllipsoidGeometry"}var A=new r,h=new r,m=new r,d=new r,S=new r,C=new r(1,1,1),I=Math.cos,N=Math.sin;R.packedLength=r.packedLength+T.packedLength+2,R.pack=function(e,t,n){return n=o(n,0),r.pack(e._radii,t,n),n+=r.packedLength,T.pack(e._vertexFormat,t,n),n+=T.packedLength,t[n++]=e._stackPartitions,t[n]=e._slicePartitions,t};var p=new r,y=new T,O={radii:p,vertexFormat:y,stackPartitions:void 0,slicePartitions:void 0};R.unpack=function(e,t,n){t=o(t,0);var i=r.unpack(e,t,p);t+=r.packedLength;var u=T.unpack(e,t,y);t+=T.packedLength;var s=e[t++],E=e[t];return a(n)?(n._radii=r.clone(i,n._radii),n._vertexFormat=T.clone(u,n._vertexFormat),n._stackPartitions=s,n._slicePartitions=E,n):(O.stackPartitions=s,O.slicePartitions=E,new R(O))},R.createGeometry=function(o){var a=o._radii;if(!(a.x<=0||a.y<=0||a.z<=0)){var i,T,R=u.fromCartesian3(a),C=o._vertexFormat,p=o._slicePartitions+1,y=o._stackPartitions+1,O=y*p,M=new Float64Array(3*O),g=6*(p-1)*(y-2),F=l.createTypedArray(O,g),L=C.normal?new Float32Array(3*O):void 0,v=C.tangent?new Float32Array(3*O):void 0,U=C.bitangent?new Float32Array(3*O):void 0,D=C.st?new Float32Array(2*O):void 0,x=new Array(p),B=new Array(p),w=0;for(i=0;i<p;i++){var P=f.TWO_PI*i/(p-1);x[i]=I(P),B[i]=N(P),M[w++]=0,M[w++]=0,M[w++]=a.z}for(i=1;i<y-1;i++){var b=Math.PI*i/(y-1),G=N(b),z=a.x*G,V=a.y*G,H=a.z*I(b);for(T=0;T<p;T++)M[w++]=x[T]*z,M[w++]=B[T]*V,M[w++]=H}for(i=0;i<p;i++)M[w++]=0,M[w++]=0,M[w++]=-a.z;var X=new c;C.position&&(X.position=new E({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:M}));var W=0,Y=0,q=0,k=0;if(C.st||C.normal||C.tangent||C.bitangent){for(i=0;i<O;i++){var K=r.fromArray(M,3*i,A),Z=R.geodeticSurfaceNormal(K,h);if(C.st){var j=t.negate(Z,S);t.magnitude(j)<f.EPSILON6&&(w=3*(i+p*Math.floor(.5*y)),w>M.length&&(w=3*(i-p*Math.floor(.5*y))),r.fromArray(M,w,j),R.geodeticSurfaceNormal(j,j),t.negate(j,j)),D[W++]=Math.atan2(j.y,j.x)/f.TWO_PI+.5,D[W++]=Math.asin(Z.z)/Math.PI+.5}if(C.normal&&(L[Y++]=Z.x,L[Y++]=Z.y,L[Y++]=Z.z),C.tangent||C.bitangent){var Q=m;if(i<p||i>O-p-1?(r.cross(r.UNIT_X,Z,Q),r.normalize(Q,Q)):(r.cross(r.UNIT_Z,Z,Q),r.normalize(Q,Q)),C.tangent&&(v[q++]=Q.x,v[q++]=Q.y,v[q++]=Q.z),C.bitangent){var J=r.cross(Z,Q,d);r.normalize(J,J),U[k++]=J.x,U[k++]=J.y,U[k++]=J.z}}}C.st&&(X.st=new E({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:D})),C.normal&&(X.normal=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:L})),C.tangent&&(X.tangent=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:v})),C.bitangent&&(X.bitangent=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:U}))}for(w=0,T=0;T<p-1;T++)F[w++]=p+T,F[w++]=p+T+1,F[w++]=T+1;var $,ee;for(i=1;i<y-2;i++)for($=i*p,ee=(i+1)*p,T=0;T<p-1;T++)F[w++]=ee+T,F[w++]=ee+T+1,F[w++]=$+T+1,F[w++]=ee+T,F[w++]=$+T+1,F[w++]=$+T;for(i=y-2,$=i*p,ee=(i+1)*p,T=0;T<p-1;T++)F[w++]=ee+T,F[w++]=$+T+1,F[w++]=$+T;return new s({attributes:X,indices:F,primitiveType:_.TRIANGLES,boundingSphere:e.fromEllipsoid(R)})}};var M;return R.getUnitEllipsoid=function(){return a(M)||(M=R.createGeometry(new R({radii:new r(1,1,1),vertexFormat:T.POSITION_ONLY}))),M},R}),define("Scene/Vector3DTileBatch",[],function(){"use strict";function e(e){this.offset=e.offset,this.count=e.count,this.color=e.color,this.batchIds=e.batchIds}return e}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var r,n=t.name,o=t.message;r=e(n)&&e(o)?n+": "+o:t.toString();var a=t.stack;return e(a)&&(r+="\n"+a),r}return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,r){"use strict";function n(n){var o,a=[],i={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;a.length=0,i.id=s.id,i.error=void 0,i.result=void 0;try{i.result=n(s.parameters,a)}catch(e){e instanceof Error?i.error={name:e.name,message:e.message,stack:e.stack}:i.error=e}t(o)||(o=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(a.length=0);try{o(i,a)}catch(e){i.result=void 0,i.error="postMessage failed with error: "+r(e)+"\n  with responseMessage: "+JSON.stringify(i),o(i)}}}return n}),define("Workers/createVectorTileGeometries",["../Core/BoundingSphere","../Core/BoxGeometry","../Core/Cartesian3","../Core/Color","../Core/CylinderGeometry","../Core/defined","../Core/EllipsoidGeometry","../Core/IndexDatatype","../Core/Matrix4","../Scene/Vector3DTileBatch","./createTaskProcessorWorker"],function(e,t,r,n,o,a,i,u,s,E,c){"use strict";function l(e,t){var n=t*C,o=r.unpack(e,n,S);n+=r.packedLength;var a=s.unpack(e,n,y.modelMatrix);s.multiplyByScale(a,o,a);var i=y.boundingVolume;return r.clone(r.ZERO,i.center),i.radius=Math.sqrt(3),y}function f(e,t){var n=t*I,o=e[n++],a=e[n++],i=r.fromElements(o,o,a,S),u=s.unpack(e,n,y.modelMatrix);s.multiplyByScale(u,i,u);var E=y.boundingVolume;return r.clone(r.ZERO,E.center),E.radius=Math.sqrt(2),y}function _(e,t){var n=t*N,o=r.unpack(e,n,S);n+=r.packedLength;var a=s.unpack(e,n,y.modelMatrix);s.multiplyByScale(a,o,a);var i=y.boundingVolume;return r.clone(r.ZERO,i.center),i.radius=1,y}function T(e,t){var n=t*p,o=e[n++],a=r.unpack(e,n,S),i=s.fromTranslation(a,y.modelMatrix);s.multiplyByUniformScale(i,o,i);var u=y.boundingVolume;return r.clone(r.ZERO,u.center),u.radius=1,y}function R(t,o,i,u,c){if(a(o)){for(var l=i.length,f=u.attributes.position.values,_=u.indices,T=t.positions,R=t.vertexBatchIds,A=t.indices,h=t.batchIds,m=t.batchTableColors,d=t.batchedIndices,S=t.indexOffsets,C=t.indexCounts,I=t.boundingVolumes,N=t.modelMatrix,p=t.center,y=t.positionOffset,M=t.batchIdIndex,g=t.indexOffset,F=t.batchedIndicesOffset,L=0;L<l;++L){var v=c(o,L),U=v.modelMatrix;s.multiply(N,U,U);for(var D=i[L],x=f.length,B=0;B<x;B+=3){var w=r.unpack(f,B,O);s.multiplyByPoint(U,w,w),r.subtract(w,p,w),r.pack(w,T,3*y+B),R[M++]=D}for(var P=_.length,b=0;b<P;++b)A[g+b]=_[b]+y;var G=L+F;d[G]=new E({offset:g,count:P,color:n.fromRgba(m[D]),batchIds:[D]}),h[G]=D,S[G]=g,C[G]=P,I[G]=e.transform(v.boundingVolume,U),y+=x/3,g+=P}t.positionOffset=y,t.batchIdIndex=M,t.indexOffset=g,t.batchedIndicesOffset+=l}}function A(e){var t=new Float64Array(e),n=0;r.unpack(t,n,M),n+=r.packedLength,s.unpack(t,n,g)}function h(e){for(var t=e.length,r=0,o=0;o<t;++o)r+=n.packedLength+3+e[o].batchIds.length;return r}function m(t,r,o){var a=o.length,i=2+a*e.packedLength+1+h(r),u=new Float64Array(i),s=0;u[s++]=t,u[s++]=a;for(var E=0;E<a;++E)e.pack(o[E],u,s),s+=e.packedLength;var c=r.length;u[s++]=c;for(var l=0;l<c;++l){var f=r[l];n.pack(f.color,u,s),s+=n.packedLength,u[s++]=f.offset,u[s++]=f.count;var _=f.batchIds,T=_.length;u[s++]=T;for(var R=0;R<T;++R)u[s++]=_[R]}return u}function d(e,r){var n=a(e.boxes)?new Float32Array(e.boxes):void 0,s=a(e.boxBatchIds)?new Uint16Array(e.boxBatchIds):void 0,E=a(e.cylinders)?new Float32Array(e.cylinders):void 0,c=a(e.cylinderBatchIds)?new Uint16Array(e.cylinderBatchIds):void 0,h=a(e.ellipsoids)?new Float32Array(e.ellipsoids):void 0,d=a(e.ellipsoidBatchIds)?new Uint16Array(e.ellipsoidBatchIds):void 0,S=a(e.spheres)?new Float32Array(e.spheres):void 0,C=a(e.sphereBatchIds)?new Uint16Array(e.sphereBatchIds):void 0,I=a(n)?s.length:0,N=a(E)?c.length:0,p=a(h)?d.length:0,y=a(S)?C.length:0,O=t.getUnitBox(),F=o.getUnitCylinder(),L=i.getUnitEllipsoid(),v=O.attributes.position.values,U=F.attributes.position.values,D=L.attributes.position.values,x=v.length*I;x+=U.length*N,x+=D.length*(p+y);var B=O.indices,w=F.indices,P=L.indices,b=B.length*I;b+=w.length*N,b+=P.length*(p+y);var G=new Float32Array(x),z=new Uint16Array(x/3),V=u.createTypedArray(x/3,b),H=I+N+p+y,X=new Uint16Array(H),W=new Array(H),Y=new Uint32Array(H),q=new Uint32Array(H),k=new Array(H);A(e.packedBuffer);var K={batchTableColors:new Uint32Array(e.batchTableColors),positions:G,vertexBatchIds:z,indices:V,batchIds:X,batchedIndices:W,indexOffsets:Y,indexCounts:q,boundingVolumes:k,positionOffset:0,batchIdIndex:0,indexOffset:0,batchedIndicesOffset:0,modelMatrix:g,center:M};R(K,n,s,O,l),R(K,E,c,F,f),R(K,h,d,L,_),R(K,S,C,L,T);var Z=m(V.BYTES_PER_ELEMENT,W,k);return r.push(G.buffer,z.buffer,V.buffer),r.push(X.buffer,Y.buffer,q.buffer),r.push(Z.buffer),{positions:G.buffer,vertexBatchIds:z.buffer,indices:V.buffer,indexOffsets:Y.buffer,indexCounts:q.buffer,batchIds:X.buffer,packedBuffer:Z.buffer}}var S=new r,C=s.packedLength+r.packedLength,I=s.packedLength+2,N=s.packedLength+r.packedLength,p=r.packedLength+1,y={modelMatrix:new s,boundingVolume:new e},O=new r,M=new r,g=new s;return c(d)})}();