/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";function E(E){return void 0!==E&&null!==E}return E}),define("Core/freezeObject",["./defined"],function(E){"use strict";var e=Object.freeze;return E(e)||(e=function(E){return E}),e}),define("Core/defaultValue",["./freezeObject"],function(E){"use strict";function e(E,e){return void 0!==E&&null!==E?E:e}return e.EMPTY_OBJECT=E({}),e}),define("Core/DeveloperError",["./defined"],function(E){"use strict";function e(E){this.name="DeveloperError",this.message=E;var e;try{throw new Error}catch(E){e=E.stack}this.stack=e}return E(Object.create)&&(e.prototype=Object.create(Error.prototype),e.prototype.constructor=e),e.prototype.toString=function(){var e=this.name+": "+this.message;return E(this.stack)&&(e+="\n"+this.stack.toString()),e},e.throwInstantiationError=function(){throw new e("This function defines an interface and should not be called directly.")},e}),define("Core/defineProperties",["./defined"],function(E){"use strict";var e=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(E){return!1}}(),r=Object.defineProperties;return e&&E(r)||(r=function(E){return E}),r}),define("Core/Fullscreen",["./defined","./defineProperties"],function(E,e){"use strict";var r,_={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},t={};return e(t,{element:{get:function(){if(t.supportsFullscreen())return document[_.fullscreenElement]}},changeEventName:{get:function(){if(t.supportsFullscreen())return _.fullscreenchange}},errorEventName:{get:function(){if(t.supportsFullscreen())return _.fullscreenerror}},enabled:{get:function(){if(t.supportsFullscreen())return document[_.fullscreenEnabled]}},fullscreen:{get:function(){if(t.supportsFullscreen())return null!==t.element}}}),t.supportsFullscreen=function(){if(E(r))return r;r=!1;var e=document.body;if("function"==typeof e.requestFullscreen)return _.requestFullscreen="requestFullscreen",_.exitFullscreen="exitFullscreen",_.fullscreenEnabled="fullscreenEnabled",_.fullscreenElement="fullscreenElement",_.fullscreenchange="fullscreenchange",_.fullscreenerror="fullscreenerror",r=!0;for(var t,n=["webkit","moz","o","ms","khtml"],T=0,R=n.length;T<R;++T){var A=n[T];t=A+"RequestFullscreen","function"==typeof e[t]?(_.requestFullscreen=t,r=!0):(t=A+"RequestFullScreen","function"==typeof e[t]&&(_.requestFullscreen=t,r=!0)),t=A+"ExitFullscreen","function"==typeof document[t]?_.exitFullscreen=t:(t=A+"CancelFullScreen","function"==typeof document[t]&&(_.exitFullscreen=t)),t=A+"FullscreenEnabled",void 0!==document[t]?_.fullscreenEnabled=t:(t=A+"FullScreenEnabled",void 0!==document[t]&&(_.fullscreenEnabled=t)),t=A+"FullscreenElement",void 0!==document[t]?_.fullscreenElement=t:(t=A+"FullScreenElement",void 0!==document[t]&&(_.fullscreenElement=t)),t=A+"fullscreenchange",void 0!==document["on"+t]&&("ms"===A&&(t="MSFullscreenChange"),_.fullscreenchange=t),t=A+"fullscreenerror",void 0!==document["on"+t]&&("ms"===A&&(t="MSFullscreenError"),_.fullscreenerror=t)}return r},t.requestFullscreen=function(E,e){t.supportsFullscreen()&&E[_.requestFullscreen]({vrDisplay:e})},t.exitFullscreen=function(){t.supportsFullscreen()&&document[_.exitFullscreen]()},t}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(E,e,r){"use strict";function _(E){for(var e=E.split("."),r=0,_=e.length;r<_;++r)e[r]=parseInt(e[r],10);return e}function t(){if(!e(C)&&(C=!1,!S())){var E=/ Chrome\/([\.0-9]+)/.exec(c.userAgent);null!==E&&(C=!0,D=_(E[1]))}return C}function n(){return t()&&D}function T(){if(!e(L)&&(L=!1,!t()&&!S()&&/ Safari\/[\.0-9]+/.test(c.userAgent))){var E=/ Version\/([\.0-9]+)/.exec(c.userAgent);null!==E&&(L=!0,P=_(E[1]))}return L}function R(){return T()&&P}function A(){if(!e(B)){B=!1;var E=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(c.userAgent);null!==E&&(B=!0,f=_(E[1]),f.isNightly=!!E[2])}return B}function N(){return A()&&f}function I(){if(!e(l)){l=!1;var E;"Microsoft Internet Explorer"===c.appName?null!==(E=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(c.userAgent))&&(l=!0,G=_(E[1])):"Netscape"===c.appName&&null!==(E=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(c.userAgent))&&(l=!0,G=_(E[1]))}return l}function i(){return I()&&G}function S(){if(!e(d)){d=!1;var E=/ Edge\/([\.0-9]+)/.exec(c.userAgent);null!==E&&(d=!0,h=_(E[1]))}return d}function o(){return S()&&h}function a(){if(!e(y)){y=!1;var E=/Firefox\/([\.0-9]+)/.exec(c.userAgent);null!==E&&(y=!0,X=_(E[1]))}return y}function s(){return e(m)||(m=/Windows/i.test(c.appVersion)),m}function u(){return a()&&X}function O(){return e(p)||(p="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),p}function F(){return e(H)||(H="undefined"!=typeof PointerEvent&&(!e(c.pointerEnabled)||c.pointerEnabled)),H}function M(){if(!e(Y)){var E=document.createElement("canvas");E.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=E.style.imageRendering;Y=e(r)&&""!==r,Y&&(V=r)}return Y}function U(){return M()?V:void 0}var c;c="undefined"!=typeof navigator?navigator:{};var C,D,L,P,B,f,l,G,d,h,y,X,m,p,H,V,Y,v=[];"undefined"!=typeof ArrayBuffer&&(v.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&v.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&v.push(CanvasPixelArray));var g={isChrome:t,chromeVersion:n,isSafari:T,safariVersion:R,isWebkit:A,webkitVersion:N,isInternetExplorer:I,internetExplorerVersion:i,isEdge:S,edgeVersion:o,isFirefox:a,firefoxVersion:u,isWindows:s,isNodeJs:O,hardwareConcurrency:E(c.hardwareConcurrency,3),supportsPointerEvents:F,supportsImageRenderingPixelated:M,imageRenderingValue:U,typedArrayTypes:v};return g.supportsFullscreen=function(){return r.supportsFullscreen()},g.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},g.supportsWebWorkers=function(){return"undefined"!=typeof Worker},g.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!g.isEdge()},g}),define("Core/WebGLConstants",["./freezeObject"],function(E){"use strict";return E({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(E,e,r,_,t,n){"use strict";if(!_.supportsTypedArrays())return{};var T={BYTE:n.BYTE,UNSIGNED_BYTE:n.UNSIGNED_BYTE,SHORT:n.SHORT,UNSIGNED_SHORT:n.UNSIGNED_SHORT,INT:n.INT,UNSIGNED_INT:n.UNSIGNED_INT,FLOAT:n.FLOAT,DOUBLE:n.DOUBLE};return T.getSizeInBytes=function(E){switch(E){case T.BYTE:return Int8Array.BYTES_PER_ELEMENT;case T.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case T.SHORT:return Int16Array.BYTES_PER_ELEMENT;case T.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case T.INT:return Int32Array.BYTES_PER_ELEMENT;case T.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case T.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case T.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},T.fromTypedArray=function(E){return E instanceof Int8Array?T.BYTE:E instanceof Uint8Array?T.UNSIGNED_BYTE:E instanceof Int16Array?T.SHORT:E instanceof Uint16Array?T.UNSIGNED_SHORT:E instanceof Int32Array?T.INT:E instanceof Uint32Array?T.UNSIGNED_INT:E instanceof Float32Array?T.FLOAT:E instanceof Float64Array?T.DOUBLE:void 0},T.validate=function(E){return e(E)&&(E===T.BYTE||E===T.UNSIGNED_BYTE||E===T.SHORT||E===T.UNSIGNED_SHORT||E===T.INT||E===T.UNSIGNED_INT||E===T.FLOAT||E===T.DOUBLE)},T.createTypedArray=function(E,e){switch(E){case T.BYTE:return new Int8Array(e);case T.UNSIGNED_BYTE:return new Uint8Array(e);case T.SHORT:return new Int16Array(e);case T.UNSIGNED_SHORT:return new Uint16Array(e);case T.INT:return new Int32Array(e);case T.UNSIGNED_INT:return new Uint32Array(e);case T.FLOAT:return new Float32Array(e);case T.DOUBLE:return new Float64Array(e)}},T.createArrayBufferView=function(e,r,_,t){switch(_=E(_,0),t=E(t,(r.byteLength-_)/T.getSizeInBytes(e)),e){case T.BYTE:return new Int8Array(r,_,t);case T.UNSIGNED_BYTE:return new Uint8Array(r,_,t);case T.SHORT:return new Int16Array(r,_,t);case T.UNSIGNED_SHORT:return new Uint16Array(r,_,t);case T.INT:return new Int32Array(r,_,t);case T.UNSIGNED_INT:return new Uint32Array(r,_,t);case T.FLOAT:return new Float32Array(r,_,t);case T.DOUBLE:return new Float64Array(r,_,t)}},T.fromName=function(E){switch(E){case"BYTE":return T.BYTE;case"UNSIGNED_BYTE":return T.UNSIGNED_BYTE;case"SHORT":return T.SHORT;case"UNSIGNED_SHORT":return T.UNSIGNED_SHORT;case"INT":return T.INT;case"UNSIGNED_INT":return T.UNSIGNED_INT;case"FLOAT":return T.FLOAT;case"DOUBLE":return T.DOUBLE}},t(T)}),define("ThirdParty/mersenne-twister",[],function(){var E=function(E){void 0==E&&(E=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(E)};return E.prototype.init_genrand=function(E){for(this.mt[0]=E>>>0,this.mti=1;this.mti<this.N;this.mti++){var E=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&E)>>>16)<<16)+1812433253*(65535&E)+this.mti,this.mt[this.mti]>>>=0}},E.prototype.genrand_int32=function(){var E,e=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)E=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^E>>>1^e[1&E];for(;r<this.N-1;r++)E=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^E>>>1^e[1&E];E=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^E>>>1^e[1&E],this.mti=0}return E=this.mt[this.mti++],E^=E>>>11,E^=E<<7&2636928640,E^=E<<15&4022730752,(E^=E>>>18)>>>0},E.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},E}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(E,e,r,_){"use strict";var t={};t.EPSILON1=.1,t.EPSILON2=.01,t.EPSILON3=.001,t.EPSILON4=1e-4,t.EPSILON5=1e-5,t.EPSILON6=1e-6,t.EPSILON7=1e-7,t.EPSILON8=1e-8,t.EPSILON9=1e-9,t.EPSILON10=1e-10,t.EPSILON11=1e-11,t.EPSILON12=1e-12,t.EPSILON13=1e-13,t.EPSILON14=1e-14,t.EPSILON15=1e-15,t.EPSILON16=1e-16,t.EPSILON17=1e-17,t.EPSILON18=1e-18,t.EPSILON19=1e-19,t.EPSILON20=1e-20,t.GRAVITATIONALPARAMETER=3986004418e5,t.SOLAR_RADIUS=6955e5,t.LUNAR_RADIUS=1737400,t.SIXTY_FOUR_KILOBYTES=65536,t.sign=e(Math.sign,function(E){return E=+E,0===E||E!==E?E:E>0?1:-1}),t.signNotZero=function(E){return E<0?-1:1},t.toSNorm=function(E,r){return r=e(r,255),Math.round((.5*t.clamp(E,-1,1)+.5)*r)},t.fromSNorm=function(E,r){return r=e(r,255),t.clamp(E,0,r)/r*2-1},t.sinh=e(Math.sinh,function(E){return(Math.exp(E)-Math.exp(-E))/2}),t.cosh=e(Math.cosh,function(E){return(Math.exp(E)+Math.exp(-E))/2}),t.lerp=function(E,e,r){return(1-r)*E+r*e},t.PI=Math.PI,t.ONE_OVER_PI=1/Math.PI,t.PI_OVER_TWO=Math.PI/2,t.PI_OVER_THREE=Math.PI/3,t.PI_OVER_FOUR=Math.PI/4,t.PI_OVER_SIX=Math.PI/6,t.THREE_PI_OVER_TWO=3*Math.PI/2,t.TWO_PI=2*Math.PI,t.ONE_OVER_TWO_PI=1/(2*Math.PI),t.RADIANS_PER_DEGREE=Math.PI/180,t.DEGREES_PER_RADIAN=180/Math.PI,t.RADIANS_PER_ARCSECOND=t.RADIANS_PER_DEGREE/3600,t.toRadians=function(E){return E*t.RADIANS_PER_DEGREE},t.toDegrees=function(E){return E*t.DEGREES_PER_RADIAN},t.convertLongitudeRange=function(E){var e=t.TWO_PI,r=E-Math.floor(E/e)*e;return r<-Math.PI?r+e:r>=Math.PI?r-e:r},t.clampToLatitudeRange=function(E){return t.clamp(E,-1*t.PI_OVER_TWO,t.PI_OVER_TWO)},t.negativePiToPi=function(E){return t.zeroToTwoPi(E+t.PI)-t.PI},t.zeroToTwoPi=function(E){var e=t.mod(E,t.TWO_PI);return Math.abs(e)<t.EPSILON14&&Math.abs(E)>t.EPSILON14?t.TWO_PI:e},t.mod=function(E,e){return(E%e+e)%e},t.equalsEpsilon=function(E,r,_,t){t=e(t,_);var n=Math.abs(E-r);return n<=t||n<=_*Math.max(Math.abs(E),Math.abs(r))};var n=[1];t.factorial=function(E){var e=n.length;if(E>=e)for(var r=n[e-1],_=e;_<=E;_++)n.push(r*_);return n[E]},t.incrementWrap=function(E,r,_){return _=e(_,0),++E,E>r&&(E=_),E},t.isPowerOfTwo=function(E){return 0!==E&&0==(E&E-1)},t.nextPowerOfTwo=function(E){return--E,E|=E>>1,E|=E>>2,E|=E>>4,E|=E>>8,E|=E>>16,++E},t.clamp=function(E,e,r){return E<e?e:E>r?r:E};var T=new E;return t.setRandomNumberSeed=function(e){T=new E(e)},t.nextRandomNumber=function(){return T.random()},t.randomBetween=function(E,e){return t.nextRandomNumber()*(e-E)+E},t.acosClamped=function(E){return Math.acos(t.clamp(E,-1,1))},t.asinClamped=function(E){return Math.asin(t.clamp(E,-1,1))},t.chordLength=function(E,e){return 2*e*Math.sin(.5*E)},t.logBase=function(E,e){return Math.log(E)/Math.log(e)},t.cbrt=e(Math.cbrt,function(E){var e=Math.pow(Math.abs(E),1/3);return E<0?-e:e}),t.log2=e(Math.log2,function(E){return Math.log(E)*Math.LOG2E}),t.fog=function(E,e){var r=E*e;return 1-Math.exp(-r*r)},t}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(E,e,r,_,t){"use strict";var n={UNSIGNED_BYTE:t.UNSIGNED_BYTE,UNSIGNED_SHORT:t.UNSIGNED_SHORT,UNSIGNED_INT:t.UNSIGNED_INT};return n.getSizeInBytes=function(E){switch(E){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},n.validate=function(e){return E(e)&&(e===n.UNSIGNED_BYTE||e===n.UNSIGNED_SHORT||e===n.UNSIGNED_INT)},n.createTypedArray=function(E,e){return E>=_.SIXTY_FOUR_KILOBYTES?new Uint32Array(e):new Uint16Array(e)},n.createTypedArrayFromArrayBuffer=function(E,e,r,t){return E>=_.SIXTY_FOUR_KILOBYTES?new Uint32Array(e,r,t):new Uint16Array(e,r,t)},r(n)}),define("Core/RuntimeError",["./defined"],function(E){"use strict";function e(E){this.name="RuntimeError",this.message=E;var e;try{throw new Error}catch(E){e=E.stack}this.stack=e}return E(Object.create)&&(e.prototype=Object.create(Error.prototype),e.prototype.constructor=e),e.prototype.toString=function(){var e=this.name+": "+this.message;return E(this.stack)&&(e+="\n"+this.stack.toString()),e},e}),define("Core/formatError",["./defined"],function(E){"use strict";function e(e){var r,_=e.name,t=e.message;r=E(_)&&E(t)?_+": "+t:e.toString();var n=e.stack;return E(n)&&(r+="\n"+n),r}return e}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(E,e,r){"use strict";function _(_){var t,n=[],T={id:void 0,result:void 0,error:void 0};return function(R){var A=R.data;n.length=0,T.id=A.id,T.error=void 0,T.result=void 0;try{T.result=_(A.parameters,n)}catch(E){E instanceof Error?T.error={name:E.name,message:E.message,stack:E.stack}:T.error=E}e(t)||(t=E(self.webkitPostMessage,self.postMessage)),A.canTransferArrayBuffer||(n.length=0);try{t(T,n)}catch(E){T.result=void 0,T.error="postMessage failed with error: "+r(E)+"\n  with responseMessage: "+JSON.stringify(T),t(T)}}}return _}),define("Workers/decodeDraco",["../Core/ComponentDatatype","../Core/defined","../Core/IndexDatatype","../Core/RuntimeError","./createTaskProcessorWorker"],function(E,e,r,_,t){"use strict";function n(E){for(var e=E.num_points(),_=E.num_faces(),t=new S.DracoInt32Array,n=3*_,T=r.createTypedArray(e,n),R=0,A=0;A<_;++A)o.GetFaceFromMesh(E,A,t),T[R+0]=t.GetValue(0),T[R+1]=t.GetValue(1),T[R+2]=t.GetValue(2),R+=3;return S.destroy(t),{typedArray:T,numberOfIndices:n}}function T(E,e,r,_){var t,n=new S.DracoInt32Array;t=r.octEncoded?new Int16Array(_):new Uint16Array(_),o.GetAttributeInt32ForAllPoints(E,e,n);for(var T=0;T<_;++T)t[T]=n.GetValue(T);return S.destroy(n),t}function R(E,e,r){var _,t;switch(e.data_type()){case 1:case 11:t=new S.DracoInt8Array,_=new Int8Array(r),o.GetAttributeInt8ForAllPoints(E,e,t);break;case 2:t=new S.DracoUInt8Array,_=new Uint8Array(r),o.GetAttributeUInt8ForAllPoints(E,e,t);break;case 3:t=new S.DracoInt16Array,_=new Int16Array(r),o.GetAttributeInt16ForAllPoints(E,e,t);break;case 4:t=new S.DracoUInt16Array,_=new Uint16Array(r),o.GetAttributeUInt16ForAllPoints(E,e,t);break;case 5:case 7:t=new S.DracoInt32Array,_=new Int32Array(r),o.GetAttributeInt32ForAllPoints(E,e,t);break;case 6:case 8:t=new S.DracoUint32Array,_=new Uint32Array(r),o.GetAttributeUInt32ForAllPoints(E,e,t);break;case 9:case 10:t=new S.DracoFloat32Array,_=new Float32Array(r),o.GetAttributeFloatForAllPoints(E,e,t)}for(var n=0;n<r;++n)_[n]=t.GetValue(n);return S.destroy(t),_}function A(r,_){var t,n,A=r.num_points(),N={};for(var I in _)if(_.hasOwnProperty(I)){var i,a=_[I],s=o.GetAttributeByUniqueId(r,a),u=s.num_components(),O=new S.AttributeQuantizationTransform;if(O.InitFromAttribute(s)){var F=new Array(u);for(i=0;i<u;++i)F[i]=O.min_value(i);n={quantizationBits:O.quantization_bits(),minValues:F,range:O.range(),octEncoded:!1}}S.destroy(O),O=new S.AttributeOctahedronTransform,O.InitFromAttribute(s)&&(n={quantizationBits:O.quantization_bits(),octEncoded:!0}),S.destroy(O);var M=A*u;t=e(n)?T(r,s,n,M):R(r,s,M);var U=E.fromTypedArray(t);N[I]={array:t,data:{componentsPerAttribute:u,componentDatatype:U,byteOffset:s.byte_offset(),byteStride:E.getSizeInBytes(U)*u,normalized:s.normalized(),quantization:n}},n=void 0}return N}function N(E){var e=["POSITION","NORMAL","COLOR","TEX_COORD"];if(E.dequantizeInShader)for(var r=0;r<e.length;++r)o.SkipAttributeTransform(S[e[r]]);var t=E.bufferView,T=new S.DecoderBuffer;if(T.Init(E.array,t.byteLength),o.GetEncodedGeometryType(T)!==S.TRIANGULAR_MESH)throw new _("Unsupported draco mesh geometry type.");var R=new S.Mesh,N=o.DecodeBufferToMesh(T,R);if(!N.ok()||0===R.ptr)throw new _("Error decoding draco mesh geometry: "+N.error_msg());S.destroy(T);var I={indexArray:n(R),attributeData:A(R,E.compressedAttributes)};return S.destroy(R),I}function I(E){S=E,o=new S.Decoder,self.onmessage=t(N),self.postMessage(!0)}function i(E){var r=E.data,_=r.webAssemblyConfig;if(e(_))return require([_.modulePath],function(E){e(_.wasmBinaryFile)?(e(E)||(E=self.DracoDecoderModule),E(_).then(function(E){I(E)})):I(E())})}var S,o;return i})}();