/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
 * @licence
 * crunch/crnlib uses the ZLIB license:
 * http://opensource.org/licenses/Zlib
 *
 * Copyright (c) 2010-2016 Richard Geldreich, Jr. and Binomial LLC
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 * claim that you wrote the original software. If you use this software
 * in a product, an acknowledgment in the product documentation would be
 * appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution.
 */

/**
     * @license
     *
     * Copyright (c) 2014, Brandon Jones. All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without modification,
     * are permitted provided that the following conditions are met:
     *
     *  * Redistributions of source code must retain the above copyright notice, this
     *  list of conditions and the following disclaimer.
     *  * Redistributions in binary form must reproduce the above copyright notice,
     *  this list of conditions and the following disclaimer in the documentation
     *  and/or other materials provided with the distribution.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
     * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
     * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
     * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
     * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
     * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
     * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
     * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
     * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
     * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),i=Object.defineProperties;return r&&e(i)||(i=function(e){return e}),i}),define("Core/CompressedTextureBuffer",["./defined","./defineProperties"],function(e,r){"use strict";function i(e,r,i,t){this._format=e,this._width=r,this._height=i,this._buffer=t}return r(i.prototype,{internalFormat:{get:function(){return this._format}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},bufferView:{get:function(){return this._buffer}}}),i.clone=function(r){if(e(r))return new i(r._format,r._width,r._height,r._buffer)},i.prototype.clone=function(){return i.clone(this)},i}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})}),define("Renderer/PixelDatatype",["../Core/freezeObject","../Core/WebGLConstants"],function(e,r){"use strict";var i={UNSIGNED_BYTE:r.UNSIGNED_BYTE,UNSIGNED_SHORT:r.UNSIGNED_SHORT,UNSIGNED_INT:r.UNSIGNED_INT,FLOAT:r.FLOAT,UNSIGNED_INT_24_8:r.UNSIGNED_INT_24_8,UNSIGNED_SHORT_4_4_4_4:r.UNSIGNED_SHORT_4_4_4_4,UNSIGNED_SHORT_5_5_5_1:r.UNSIGNED_SHORT_5_5_5_1,UNSIGNED_SHORT_5_6_5:r.UNSIGNED_SHORT_5_6_5,isPacked:function(e){return e===i.UNSIGNED_INT_24_8||e===i.UNSIGNED_SHORT_4_4_4_4||e===i.UNSIGNED_SHORT_5_5_5_1||e===i.UNSIGNED_SHORT_5_6_5},sizeInBytes:function(e){switch(e){case i.UNSIGNED_BYTE:return 1;case i.UNSIGNED_SHORT:case i.UNSIGNED_SHORT_4_4_4_4:case i.UNSIGNED_SHORT_5_5_5_1:case i.UNSIGNED_SHORT_5_6_5:return 2;case i.UNSIGNED_INT:case i.FLOAT:case i.UNSIGNED_INT_24_8:return 4}},validate:function(e){return e===i.UNSIGNED_BYTE||e===i.UNSIGNED_SHORT||e===i.UNSIGNED_INT||e===i.FLOAT||e===i.UNSIGNED_INT_24_8||e===i.UNSIGNED_SHORT_4_4_4_4||e===i.UNSIGNED_SHORT_5_5_5_1||e===i.UNSIGNED_SHORT_5_6_5}};return e(i)}),define("Core/PixelFormat",["../Renderer/PixelDatatype","./freezeObject","./WebGLConstants"],function(e,r,i){"use strict";var t={DEPTH_COMPONENT:i.DEPTH_COMPONENT,DEPTH_STENCIL:i.DEPTH_STENCIL,ALPHA:i.ALPHA,RGB:i.RGB,RGBA:i.RGBA,LUMINANCE:i.LUMINANCE,LUMINANCE_ALPHA:i.LUMINANCE_ALPHA,RGB_DXT1:i.COMPRESSED_RGB_S3TC_DXT1_EXT,RGBA_DXT1:i.COMPRESSED_RGBA_S3TC_DXT1_EXT,RGBA_DXT3:i.COMPRESSED_RGBA_S3TC_DXT3_EXT,RGBA_DXT5:i.COMPRESSED_RGBA_S3TC_DXT5_EXT,RGB_PVRTC_4BPPV1:i.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,RGB_PVRTC_2BPPV1:i.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,RGBA_PVRTC_4BPPV1:i.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,RGBA_PVRTC_2BPPV1:i.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,RGB_ETC1:i.COMPRESSED_RGB_ETC1_WEBGL,componentsLength:function(e){switch(e){case t.RGB:return 3;case t.RGBA:return 4;case t.LUMINANCE_ALPHA:return 2;case t.ALPHA:case t.LUMINANCE:default:return 1}},validate:function(e){return e===t.DEPTH_COMPONENT||e===t.DEPTH_STENCIL||e===t.ALPHA||e===t.RGB||e===t.RGBA||e===t.LUMINANCE||e===t.LUMINANCE_ALPHA||e===t.RGB_DXT1||e===t.RGBA_DXT1||e===t.RGBA_DXT3||e===t.RGBA_DXT5||e===t.RGB_PVRTC_4BPPV1||e===t.RGB_PVRTC_2BPPV1||e===t.RGBA_PVRTC_4BPPV1||e===t.RGBA_PVRTC_2BPPV1||e===t.RGB_ETC1},isColorFormat:function(e){return e===t.ALPHA||e===t.RGB||e===t.RGBA||e===t.LUMINANCE||e===t.LUMINANCE_ALPHA},isDepthFormat:function(e){return e===t.DEPTH_COMPONENT||e===t.DEPTH_STENCIL},isCompressedFormat:function(e){return e===t.RGB_DXT1||e===t.RGBA_DXT1||e===t.RGBA_DXT3||e===t.RGBA_DXT5||e===t.RGB_PVRTC_4BPPV1||e===t.RGB_PVRTC_2BPPV1||e===t.RGBA_PVRTC_4BPPV1||e===t.RGBA_PVRTC_2BPPV1||e===t.RGB_ETC1},isDXTFormat:function(e){return e===t.RGB_DXT1||e===t.RGBA_DXT1||e===t.RGBA_DXT3||e===t.RGBA_DXT5},isPVRTCFormat:function(e){return e===t.RGB_PVRTC_4BPPV1||e===t.RGB_PVRTC_2BPPV1||e===t.RGBA_PVRTC_4BPPV1||e===t.RGBA_PVRTC_2BPPV1},isETC1Format:function(e){return e===t.RGB_ETC1},compressedTextureSizeInBytes:function(e,r,i){switch(e){case t.RGB_DXT1:case t.RGBA_DXT1:case t.RGB_ETC1:return Math.floor((r+3)/4)*Math.floor((i+3)/4)*8;case t.RGBA_DXT3:case t.RGBA_DXT5:return Math.floor((r+3)/4)*Math.floor((i+3)/4)*16;case t.RGB_PVRTC_4BPPV1:case t.RGBA_PVRTC_4BPPV1:return Math.floor((Math.max(r,8)*Math.max(i,8)*4+7)/8);case t.RGB_PVRTC_2BPPV1:case t.RGBA_PVRTC_2BPPV1:return Math.floor((Math.max(r,16)*Math.max(i,8)*2+7)/8);default:return 0}},textureSizeInBytes:function(r,i,n,_){var a=t.componentsLength(r);return e.isPacked(i)&&(a=1),a*e.sizeInBytes(i)*n*_},createTypedArray:function(r,i,n,_){var a=e.sizeInBytes(i);return new(a===Uint8Array.BYTES_PER_ELEMENT?Uint8Array:a===Uint16Array.BYTES_PER_ELEMENT?Uint16Array:a===Float32Array.BYTES_PER_ELEMENT&&i===e.FLOAT?Float32Array:Uint32Array)(t.componentsLength(r)*n*_)},flipY:function(e,r,i,n,_){if(1===_)return e;for(var a=t.createTypedArray(r,i,n,_),o=t.componentsLength(r),E=n*o,u=0;u<_;++u)for(var f=u*_*o,T=(_-u-1)*_*o,l=0;l<E;++l)a[T+l]=e[f+l];return a}};return r(t)}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function r(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(e){r=e.stack}this.stack=r}return e(Object.create)&&(r.prototype=Object.create(Error.prototype),r.prototype.constructor=r),r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("ThirdParty/crunch",[],function(){function globalEval(e){eval.call(null,e)}function assert(e,r){e||abort("Assertion failed: "+r)}function getCFunc(ident){var func=Module["_"+ident];if(!func)try{func=eval("_"+ident)}catch(e){}return assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)"),func}function setValue(e,r,i,t){switch(i=i||"i8","*"===i.charAt(i.length-1)&&(i="i32"),i){case"i1":case"i8":HEAP8[e>>0]=r;break;case"i16":HEAP16[e>>1]=r;break;case"i32":HEAP32[e>>2]=r;break;case"i64":tempI64=[r>>>0,(tempDouble=r,+Math_abs(tempDouble)>=1?tempDouble>0?(0|Math_min(+Math_floor(tempDouble/4294967296),4294967295))>>>0:~~+Math_ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[e>>2]=tempI64[0],HEAP32[e+4>>2]=tempI64[1];break;case"float":HEAPF32[e>>2]=r;break;case"double":HEAPF64[e>>3]=r;break;default:abort("invalid type for setValue: "+i)}}function getValue(e,r,i){switch(r=r||"i8","*"===r.charAt(r.length-1)&&(r="i32"),r){case"i1":case"i8":return HEAP8[e>>0];case"i16":return HEAP16[e>>1];case"i32":case"i64":return HEAP32[e>>2];case"float":return HEAPF32[e>>2];case"double":return HEAPF64[e>>3];default:abort("invalid type for setValue: "+r)}return null}function allocate(e,r,i,t){var n,_;"number"==typeof e?(n=!0,_=e):(n=!1,_=e.length);var a,o="string"==typeof r?r:null;if(a=i==ALLOC_NONE?t:["function"==typeof _malloc?_malloc:Runtime.staticAlloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][void 0===i?ALLOC_STATIC:i](Math.max(_,o?1:r.length)),n){var E,t=a;for(assert(0==(3&a)),E=a+(-4&_);t<E;t+=4)HEAP32[t>>2]=0;for(E=a+_;t<E;)HEAP8[t++>>0]=0;return a}if("i8"===o)return e.subarray||e.slice?HEAPU8.set(e,a):HEAPU8.set(new Uint8Array(e),a),a;for(var u,f,T,l=0;l<_;){var c=e[l];"function"==typeof c&&(c=Runtime.getFunctionIndex(c)),u=o||r[l],0!==u?("i64"==u&&(u="i32"),setValue(a+l,c,u),T!==u&&(f=Runtime.getNativeTypeSize(u),T=u),l+=f):l++}return a}function getMemory(e){return staticSealed?runtimeInitialized?_malloc(e):Runtime.dynamicAlloc(e):Runtime.staticAlloc(e)}function Pointer_stringify(e,r){if(0===r||!e)return"";for(var i,t=0,n=0;;){if(i=HEAPU8[e+n>>0],t|=i,0==i&&!r)break;if(n++,r&&n==r)break}r||(r=n);var _="";if(t<128){for(var a;r>0;)a=String.fromCharCode.apply(String,HEAPU8.subarray(e,e+Math.min(r,1024))),_=_?_+a:a,e+=1024,r-=1024;return _}return Module.UTF8ToString(e)}function AsciiToString(e){for(var r="";;){var i=HEAP8[e++>>0];if(!i)return r;r+=String.fromCharCode(i)}}function stringToAscii(e,r){return writeAsciiToMemory(e,r,!1)}function UTF8ArrayToString(e,r){for(var i=r;e[i];)++i;if(i-r>16&&e.subarray&&UTF8Decoder)return UTF8Decoder.decode(e.subarray(r,i));for(var t,n,_,a,o,E,u="";;){if(!(t=e[r++]))return u;if(128&t)if(n=63&e[r++],192!=(224&t))if(_=63&e[r++],224==(240&t)?t=(15&t)<<12|n<<6|_:(a=63&e[r++],240==(248&t)?t=(7&t)<<18|n<<12|_<<6|a:(o=63&e[r++],248==(252&t)?t=(3&t)<<24|n<<18|_<<12|a<<6|o:(E=63&e[r++],t=(1&t)<<30|n<<24|_<<18|a<<12|o<<6|E))),t<65536)u+=String.fromCharCode(t);else{var f=t-65536;u+=String.fromCharCode(55296|f>>10,56320|1023&f)}else u+=String.fromCharCode((31&t)<<6|n);else u+=String.fromCharCode(t)}}function UTF8ToString(e){return UTF8ArrayToString(HEAPU8,e)}function stringToUTF8Array(e,r,i,t){if(!(t>0))return 0;for(var n=i,_=i+t-1,a=0;a<e.length;++a){var o=e.charCodeAt(a);if(o>=55296&&o<=57343&&(o=65536+((1023&o)<<10)|1023&e.charCodeAt(++a)),o<=127){if(i>=_)break;r[i++]=o}else if(o<=2047){if(i+1>=_)break;r[i++]=192|o>>6,r[i++]=128|63&o}else if(o<=65535){if(i+2>=_)break;r[i++]=224|o>>12,r[i++]=128|o>>6&63,r[i++]=128|63&o}else if(o<=2097151){if(i+3>=_)break;r[i++]=240|o>>18,r[i++]=128|o>>12&63,r[i++]=128|o>>6&63,r[i++]=128|63&o}else if(o<=67108863){if(i+4>=_)break;r[i++]=248|o>>24,r[i++]=128|o>>18&63,r[i++]=128|o>>12&63,r[i++]=128|o>>6&63,r[i++]=128|63&o}else{if(i+5>=_)break;r[i++]=252|o>>30,r[i++]=128|o>>24&63,r[i++]=128|o>>18&63,r[i++]=128|o>>12&63,r[i++]=128|o>>6&63,r[i++]=128|63&o}}return r[i]=0,i-n}function stringToUTF8(e,r,i){return stringToUTF8Array(e,HEAPU8,r,i)}function lengthBytesUTF8(e){for(var r=0,i=0;i<e.length;++i){var t=e.charCodeAt(i);t>=55296&&t<=57343&&(t=65536+((1023&t)<<10)|1023&e.charCodeAt(++i)),t<=127?++r:r+=t<=2047?2:t<=65535?3:t<=2097151?4:t<=67108863?5:6}return r}function demangle(e){var r=Module.___cxa_demangle||Module.__cxa_demangle;if(r){try{var i=e.substr(1),t=lengthBytesUTF8(i)+1,n=_malloc(t);stringToUTF8(i,n,t);var _=_malloc(4),a=r(n,0,0,_);if(0===getValue(_,"i32")&&a)return Pointer_stringify(a)}catch(e){}finally{n&&_free(n),_&&_free(_),a&&_free(a)}return e}return Runtime.warnOnce("warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling"),e}function demangleAll(e){var r=/__Z[\w\d_]+/g;return e.replace(r,function(e){var r=demangle(e);return e===r?e:e+" ["+r+"]"})}function jsStackTrace(){var e=new Error;if(!e.stack){try{throw new Error(0)}catch(r){e=r}if(!e.stack)return"(no stack trace available)"}return e.stack.toString()}function stackTrace(){var e=jsStackTrace();return Module.extraStackTrace&&(e+="\n"+Module.extraStackTrace()),demangleAll(e)}function alignUp(e,r){return e%r>0&&(e+=r-e%r),e}function updateGlobalBuffer(e){Module.buffer=buffer=e}function updateGlobalBufferViews(){Module.HEAP8=HEAP8=new Int8Array(buffer),Module.HEAP16=HEAP16=new Int16Array(buffer),Module.HEAP32=HEAP32=new Int32Array(buffer),Module.HEAPU8=HEAPU8=new Uint8Array(buffer),Module.HEAPU16=HEAPU16=new Uint16Array(buffer),Module.HEAPU32=HEAPU32=new Uint32Array(buffer),Module.HEAPF32=HEAPF32=new Float32Array(buffer),Module.HEAPF64=HEAPF64=new Float64Array(buffer)}function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){var e=Module.usingWasm?WASM_PAGE_SIZE:ASMJS_PAGE_SIZE,r=2147483648-e;if(HEAP32[DYNAMICTOP_PTR>>2]>r)return!1;var i=TOTAL_MEMORY;for(TOTAL_MEMORY=Math.max(TOTAL_MEMORY,MIN_TOTAL_MEMORY);TOTAL_MEMORY<HEAP32[DYNAMICTOP_PTR>>2];)TOTAL_MEMORY=TOTAL_MEMORY<=536870912?alignUp(2*TOTAL_MEMORY,e):Math.min(alignUp((3*TOTAL_MEMORY+2147483648)/4,e),r);var t=Module.reallocBuffer(TOTAL_MEMORY);return t&&t.byteLength==TOTAL_MEMORY?(updateGlobalBuffer(t),updateGlobalBufferViews(),!0):(TOTAL_MEMORY=i,!1)}function getTotalMemory(){return TOTAL_MEMORY}function callRuntimeCallbacks(e){for(;e.length>0;){var r=e.shift();if("function"!=typeof r){var i=r.func;"number"==typeof i?void 0===r.arg?Module.dynCall_v(i):Module.dynCall_vi(i,r.arg):i(void 0===r.arg?null:r.arg)}else r()}}function preRun(){if(Module.preRun)for("function"==typeof Module.preRun&&(Module.preRun=[Module.preRun]);Module.preRun.length;)addOnPreRun(Module.preRun.shift());callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){runtimeInitialized||(runtimeInitialized=!0,callRuntimeCallbacks(__ATINIT__))}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__),runtimeExited=!0}function postRun(){if(Module.postRun)for("function"==typeof Module.postRun&&(Module.postRun=[Module.postRun]);Module.postRun.length;)addOnPostRun(Module.postRun.shift());callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(e){__ATPRERUN__.unshift(e)}function addOnInit(e){__ATINIT__.unshift(e)}function addOnPreMain(e){__ATMAIN__.unshift(e)}function addOnExit(e){__ATEXIT__.unshift(e)}function addOnPostRun(e){__ATPOSTRUN__.unshift(e)}function intArrayFromString(e,r,i){var t=i>0?i:lengthBytesUTF8(e)+1,n=new Array(t),_=stringToUTF8Array(e,n,0,n.length);return r&&(n.length=_),n}function intArrayToString(e){for(var r=[],i=0;i<e.length;i++){var t=e[i];t>255&&(t&=255),r.push(String.fromCharCode(t))}return r.join("")}function writeStringToMemory(e,r,i){Runtime.warnOnce("writeStringToMemory is deprecated and should not be called! Use stringToUTF8() instead!");var t,n;i&&(n=r+lengthBytesUTF8(e),t=HEAP8[n]),stringToUTF8(e,r,1/0),i&&(HEAP8[n]=t)}function writeArrayToMemory(e,r){HEAP8.set(e,r)}function writeAsciiToMemory(e,r,i){for(var t=0;t<e.length;++t)HEAP8[r++>>0]=e.charCodeAt(t);i||(HEAP8[r>>0]=0)}function addRunDependency(e){runDependencies++,Module.monitorRunDependencies&&Module.monitorRunDependencies(runDependencies)}function removeRunDependency(e){if(runDependencies--,Module.monitorRunDependencies&&Module.monitorRunDependencies(runDependencies),0==runDependencies&&(null!==runDependencyWatcher&&(clearInterval(runDependencyWatcher),runDependencyWatcher=null),dependenciesFulfilled)){var r=dependenciesFulfilled;dependenciesFulfilled=null,r()}}function _abort(){Module.abort()}function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}function ___cxa_begin_catch(e){var r=EXCEPTIONS.infos[e];return r&&!r.caught&&(r.caught=!0,__ZSt18uncaught_exceptionv.uncaught_exception--),r&&(r.rethrown=!1),EXCEPTIONS.caught.push(e),EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(e)),e}function _pthread_once(e,r){_pthread_once.seen||(_pthread_once.seen={}),e in _pthread_once.seen||(Module.dynCall_v(r),_pthread_once.seen[e]=1)}function _emscripten_memcpy_big(e,r,i){return HEAPU8.set(HEAPU8.subarray(r,r+i),e),e}function ___syscall6(e,r){SYSCALLS.varargs=r;try{var i=SYSCALLS.getStreamFromFD();return FS.close(i),0}catch(e){return"undefined"!=typeof FS&&e instanceof FS.ErrnoError||abort(e),-e.errno}}function _pthread_getspecific(e){return PTHREAD_SPECIFIC[e]||0}function ___setErrNo(e){return Module.___errno_location&&(HEAP32[Module.___errno_location()>>2]=e),e}function _pthread_key_create(e,r){return 0==e?ERRNO_CODES.EINVAL:(HEAP32[e>>2]=PTHREAD_SPECIFIC_NEXT_KEY,PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0,PTHREAD_SPECIFIC_NEXT_KEY++,0)}function ___resumeException(e){throw EXCEPTIONS.last||(EXCEPTIONS.last=e),e+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var e=EXCEPTIONS.last;if(!e)return 0|(Runtime.setTempRet0(0),0);var r=EXCEPTIONS.infos[e],i=r.type;if(!i)return 0|(Runtime.setTempRet0(0),e);var t=Array.prototype.slice.call(arguments);Module.___cxa_is_pointer_type(i);___cxa_find_matching_catch.buffer||(___cxa_find_matching_catch.buffer=_malloc(4)),HEAP32[___cxa_find_matching_catch.buffer>>2]=e,e=___cxa_find_matching_catch.buffer;for(var n=0;n<t.length;n++)if(t[n]&&Module.___cxa_can_catch(t[n],i,e))return e=HEAP32[e>>2],r.adjusted=e,0|(Runtime.setTempRet0(t[n]),e);return e=HEAP32[e>>2],0|(Runtime.setTempRet0(i),e)}function ___gxx_personality_v0(){}function _pthread_setspecific(e,r){return e in PTHREAD_SPECIFIC?(PTHREAD_SPECIFIC[e]=r,0):ERRNO_CODES.EINVAL}function ___syscall140(e,r){SYSCALLS.varargs=r;try{var i=SYSCALLS.getStreamFromFD(),t=(SYSCALLS.get(),SYSCALLS.get()),n=SYSCALLS.get(),_=SYSCALLS.get(),a=t;return FS.llseek(i,a,_),HEAP32[n>>2]=i.position,i.getdents&&0===a&&0===_&&(i.getdents=null),0}catch(e){return"undefined"!=typeof FS&&e instanceof FS.ErrnoError||abort(e),-e.errno}}function ___syscall146(e,r){SYSCALLS.varargs=r;try{var i=SYSCALLS.get(),t=SYSCALLS.get(),n=SYSCALLS.get(),_=0;___syscall146.buffer||(___syscall146.buffers=[null,[],[]],___syscall146.printChar=function(e,r){var i=___syscall146.buffers[e];assert(i),0===r||10===r?((1===e?Module.print:Module.printErr)(UTF8ArrayToString(i,0)),i.length=0):i.push(r)});for(var a=0;a<n;a++){for(var o=HEAP32[t+8*a>>2],E=HEAP32[t+(8*a+4)>>2],u=0;u<E;u++)___syscall146.printChar(i,HEAPU8[o+u]);_+=E}return _}catch(e){return"undefined"!=typeof FS&&e instanceof FS.ErrnoError||abort(e),-e.errno}}function ___syscall54(e,r){SYSCALLS.varargs=r;try{return 0}catch(e){return"undefined"!=typeof FS&&e instanceof FS.ErrnoError||abort(e),-e.errno}}function invoke_iiii(e,r,i,t){try{return Module.dynCall_iiii(e,r,i,t)}catch(e){if("number"!=typeof e&&"longjmp"!==e)throw e;Module.setThrew(1,0)}}function invoke_viiiii(e,r,i,t,n,_){try{Module.dynCall_viiiii(e,r,i,t,n,_)}catch(e){if("number"!=typeof e&&"longjmp"!==e)throw e;Module.setThrew(1,0)}}function invoke_vi(e,r){try{Module.dynCall_vi(e,r)}catch(e){if("number"!=typeof e&&"longjmp"!==e)throw e;Module.setThrew(1,0)}}function invoke_ii(e,r){try{return Module.dynCall_ii(e,r)}catch(e){if("number"!=typeof e&&"longjmp"!==e)throw e;Module.setThrew(1,0)}}function invoke_viii(e,r,i,t){try{Module.dynCall_viii(e,r,i,t)}catch(e){if("number"!=typeof e&&"longjmp"!==e)throw e;Module.setThrew(1,0)}}function invoke_v(e){try{Module.dynCall_v(e)}catch(e){if("number"!=typeof e&&"longjmp"!==e)throw e;Module.setThrew(1,0)}}function invoke_viiiiii(e,r,i,t,n,_,a){try{Module.dynCall_viiiiii(e,r,i,t,n,_,a)}catch(e){if("number"!=typeof e&&"longjmp"!==e)throw e;Module.setThrew(1,0)}}function invoke_viiii(e,r,i,t,n){try{Module.dynCall_viiii(e,r,i,t,n)}catch(e){if("number"!=typeof e&&"longjmp"!==e)throw e;Module.setThrew(1,0)}}function ExitStatus(e){this.name="ExitStatus",this.message="Program terminated with exit("+e+")",this.status=e}function run(e){function r(){Module.calledRun||(Module.calledRun=!0,
ABORT||(ensureInitRuntime(),preMain(),Module.onRuntimeInitialized&&Module.onRuntimeInitialized(),Module._main&&shouldRunNow&&Module.callMain(e),postRun()))}e=e||Module.arguments,null===preloadStartTime&&(preloadStartTime=Date.now()),runDependencies>0||(preRun(),runDependencies>0||Module.calledRun||(Module.setStatus?(Module.setStatus("Running..."),setTimeout(function(){setTimeout(function(){Module.setStatus("")},1),r()},1)):r()))}function exit(e,r){r&&Module.noExitRuntime||(Module.noExitRuntime||(ABORT=!0,EXITSTATUS=e,STACKTOP=initialStackTop,exitRuntime(),Module.onExit&&Module.onExit(e)),ENVIRONMENT_IS_NODE&&process.exit(e),Module.quit(e,new ExitStatus(e)))}function abort(e){Module.onAbort&&Module.onAbort(e),void 0!==e?(Module.print(e),Module.printErr(e),e=JSON.stringify(e)):e="",ABORT=!0,EXITSTATUS=1;var r="abort("+e+") at "+stackTrace()+"\nIf this abort() is unexpected, build with -s ASSERTIONS=1 which can give more information.";throw abortDecorators&&abortDecorators.forEach(function(i){r=i(r,e)}),r}var Module;Module||(Module=(void 0!==Module?Module:null)||{});var moduleOverrides={};for(var key in Module)Module.hasOwnProperty(key)&&(moduleOverrides[key]=Module[key]);var ENVIRONMENT_IS_WEB=!1,ENVIRONMENT_IS_WORKER=!1,ENVIRONMENT_IS_NODE=!1,ENVIRONMENT_IS_SHELL=!1;if(Module.ENVIRONMENT)if("WEB"===Module.ENVIRONMENT)ENVIRONMENT_IS_WEB=!0;else if("WORKER"===Module.ENVIRONMENT)ENVIRONMENT_IS_WORKER=!0;else if("NODE"===Module.ENVIRONMENT)ENVIRONMENT_IS_NODE=!0;else{if("SHELL"!==Module.ENVIRONMENT)throw new Error("The provided Module['ENVIRONMENT'] value is not valid. It must be one of: WEB|WORKER|NODE|SHELL.");ENVIRONMENT_IS_SHELL=!0}else ENVIRONMENT_IS_WEB="object"==typeof window,ENVIRONMENT_IS_WORKER="function"==typeof importScripts,ENVIRONMENT_IS_NODE="object"==typeof process&&"function"==typeof require&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER,ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){Module.print||(Module.print=console.log),Module.printErr||(Module.printErr=console.warn);var nodeFS,nodePath;Module.read=function(e,r){nodeFS||(nodeFS=require("fs")),nodePath||(nodePath=require("path")),e=nodePath.normalize(e);var i=nodeFS.readFileSync(e);return r?i:i.toString()},Module.readBinary=function(e){var r=Module.read(e,!0);return r.buffer||(r=new Uint8Array(r)),assert(r.buffer),r},Module.load=function(e){globalEval(read(e))},Module.thisProgram||(process.argv.length>1?Module.thisProgram=process.argv[1].replace(/\\/g,"/"):Module.thisProgram="unknown-program"),Module.arguments=process.argv.slice(2),"undefined"!=typeof module&&(module.exports=Module),process.on("uncaughtException",function(e){if(!(e instanceof ExitStatus))throw e}),Module.inspect=function(){return"[Emscripten Module object]"}}else if(ENVIRONMENT_IS_SHELL)Module.print||(Module.print=print),"undefined"!=typeof printErr&&(Module.printErr=printErr),"undefined"!=typeof read?Module.read=read:Module.read=function(){throw"no read() available"},Module.readBinary=function(e){if("function"==typeof readbuffer)return new Uint8Array(readbuffer(e));var r=read(e,"binary");return assert("object"==typeof r),r},"undefined"!=typeof scriptArgs?Module.arguments=scriptArgs:void 0!==arguments&&(Module.arguments=arguments),"function"==typeof quit&&(Module.quit=function(e,r){quit(e)});else{if(!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER)throw"Unknown runtime environment. Where are we?";if(Module.read=function(e){var r=new XMLHttpRequest;return r.open("GET",e,!1),r.send(null),r.responseText},ENVIRONMENT_IS_WORKER&&(Module.readBinary=function(e){var r=new XMLHttpRequest;return r.open("GET",e,!1),r.responseType="arraybuffer",r.send(null),new Uint8Array(r.response)}),Module.readAsync=function(e,r,i){var t=new XMLHttpRequest;t.open("GET",e,!0),t.responseType="arraybuffer",t.onload=function(){200==t.status||0==t.status&&t.response?r(t.response):i()},t.onerror=i,t.send(null)},void 0!==arguments&&(Module.arguments=arguments),"undefined"!=typeof console)Module.print||(Module.print=function(e){console.log(e)}),Module.printErr||(Module.printErr=function(e){console.warn(e)});else{var TRY_USE_DUMP=!1;Module.print||(Module.print=TRY_USE_DUMP&&"undefined"!=typeof dump?function(e){dump(e)}:function(e){})}ENVIRONMENT_IS_WORKER&&(Module.load=importScripts),void 0===Module.setWindowTitle&&(Module.setWindowTitle=function(e){document.title=e})}!Module.load&&Module.read&&(Module.load=function(e){globalEval(Module.read(e))}),Module.print||(Module.print=function(){}),Module.printErr||(Module.printErr=Module.print),Module.arguments||(Module.arguments=[]),Module.thisProgram||(Module.thisProgram="./this.program"),Module.quit||(Module.quit=function(e,r){throw r}),Module.print=Module.print,Module.printErr=Module.printErr,Module.preRun=[],Module.postRun=[];for(var key in moduleOverrides)moduleOverrides.hasOwnProperty(key)&&(Module[key]=moduleOverrides[key]);moduleOverrides=void 0;var Runtime={setTempRet0:function(e){return tempRet0=e,e},getTempRet0:function(){return tempRet0},stackSave:function(){return STACKTOP},stackRestore:function(e){STACKTOP=e},getNativeTypeSize:function(e){switch(e){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:if("*"===e[e.length-1])return Runtime.QUANTUM_SIZE;if("i"===e[0]){var r=parseInt(e.substr(1));return assert(r%8==0),r/8}return 0}},getNativeFieldSize:function(e){return Math.max(Runtime.getNativeTypeSize(e),Runtime.QUANTUM_SIZE)},STACK_ALIGN:16,prepVararg:function(e,r){return"double"===r||"i64"===r?7&e&&(assert(4==(7&e)),e+=4):assert(0==(3&e)),e},getAlignSize:function(e,r,i){return i||"i64"!=e&&"double"!=e?e?Math.min(r||(e?Runtime.getNativeFieldSize(e):0),Runtime.QUANTUM_SIZE):Math.min(r,8):8},dynCall:function(e,r,i){return i&&i.length?Module["dynCall_"+e].apply(null,[r].concat(i)):Module["dynCall_"+e].call(null,r)},functionPointers:[],addFunction:function(e){for(var r=0;r<Runtime.functionPointers.length;r++)if(!Runtime.functionPointers[r])return Runtime.functionPointers[r]=e,2*(1+r);throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."},removeFunction:function(e){Runtime.functionPointers[(e-2)/2]=null},warnOnce:function(e){Runtime.warnOnce.shown||(Runtime.warnOnce.shown={}),Runtime.warnOnce.shown[e]||(Runtime.warnOnce.shown[e]=1,Module.printErr(e))},funcWrappers:{},getFuncWrapper:function(e,r){assert(r),Runtime.funcWrappers[r]||(Runtime.funcWrappers[r]={});var i=Runtime.funcWrappers[r];return i[e]||(1===r.length?i[e]=function(){return Runtime.dynCall(r,e)}:2===r.length?i[e]=function(i){return Runtime.dynCall(r,e,[i])}:i[e]=function(){return Runtime.dynCall(r,e,Array.prototype.slice.call(arguments))}),i[e]},getCompilerSetting:function(e){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"},stackAlloc:function(e){var r=STACKTOP;return STACKTOP=STACKTOP+e|0,STACKTOP=STACKTOP+15&-16,r},staticAlloc:function(e){var r=STATICTOP;return STATICTOP=STATICTOP+e|0,STATICTOP=STATICTOP+15&-16,r},dynamicAlloc:function(e){var r=HEAP32[DYNAMICTOP_PTR>>2],i=-16&(r+e+15|0);if(HEAP32[DYNAMICTOP_PTR>>2]=i,i>=TOTAL_MEMORY){if(!enlargeMemory())return HEAP32[DYNAMICTOP_PTR>>2]=r,0}return r},alignMemory:function(e,r){return e=Math.ceil(e/(r||16))*(r||16)},makeBigInt:function(e,r,i){return i?+(e>>>0)+4294967296*+(r>>>0):+(e>>>0)+4294967296*+(0|r)},GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module.Runtime=Runtime;var ABORT=0,EXITSTATUS=0,cwrap,ccall;!function(){function parseJSFunc(e){var r=e.toString().match(sourceRegex).slice(1);return{arguments:r[0],body:r[1],returnValue:r[2]}}function ensureJSsource(){if(!JSsource){JSsource={};for(var e in JSfuncs)JSfuncs.hasOwnProperty(e)&&(JSsource[e]=parseJSFunc(JSfuncs[e]))}}var JSfuncs={stackSave:function(){Runtime.stackSave()},stackRestore:function(){Runtime.stackRestore()},arrayToC:function(e){var r=Runtime.stackAlloc(e.length);return writeArrayToMemory(e,r),r},stringToC:function(e){var r=0;if(null!==e&&void 0!==e&&0!==e){var i=1+(e.length<<2);r=Runtime.stackAlloc(i),stringToUTF8(e,r,i)}return r}},toC={string:JSfuncs.stringToC,array:JSfuncs.arrayToC};ccall=function(e,r,i,t,n){var _=getCFunc(e),a=[],o=0;if(t)for(var E=0;E<t.length;E++){var u=toC[i[E]];u?(0===o&&(o=Runtime.stackSave()),a[E]=u(t[E])):a[E]=t[E]}var f=_.apply(null,a);if("string"===r&&(f=Pointer_stringify(f)),0!==o){if(n&&n.async)return void EmterpreterAsync.asyncFinalizers.push(function(){Runtime.stackRestore(o)});Runtime.stackRestore(o)}return f};var sourceRegex=/^function\s*[a-zA-Z$_0-9]*\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/,JSsource=null;cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident),numericArgs=argTypes.every(function(e){return"number"===e}),numericRet="string"!==returnType;if(numericRet&&numericArgs)return cfunc;var argNames=argTypes.map(function(e,r){return"$"+r}),funcstr="(function("+argNames.join(",")+") {",nargs=argTypes.length;if(!numericArgs){ensureJSsource(),funcstr+="var stack = "+JSsource.stackSave.body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if("number"!==type){var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";",funcstr+=convertCode.body+";",funcstr+=arg+"=("+convertCode.returnValue+");"}}}var cfuncname=parseJSFunc(function(){return cfunc}).returnValue;if(funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");",!numericRet){var strgfy=parseJSFunc(function(){return Pointer_stringify}).returnValue;funcstr+="ret = "+strgfy+"(ret);"}return numericArgs||(ensureJSsource(),funcstr+=JSsource.stackRestore.body.replace("()","(stack)")+";"),funcstr+="return ret})",eval(funcstr)}}(),Module.ccall=ccall,Module.cwrap=cwrap,Module.setValue=setValue,Module.getValue=getValue;var ALLOC_NORMAL=0,ALLOC_STACK=1,ALLOC_STATIC=2,ALLOC_DYNAMIC=3,ALLOC_NONE=4;Module.ALLOC_NORMAL=ALLOC_NORMAL,Module.ALLOC_STACK=ALLOC_STACK,Module.ALLOC_STATIC=ALLOC_STATIC,Module.ALLOC_DYNAMIC=ALLOC_DYNAMIC,Module.ALLOC_NONE=ALLOC_NONE,Module.allocate=allocate,Module.getMemory=getMemory,Module.Pointer_stringify=Pointer_stringify,Module.AsciiToString=AsciiToString,Module.stringToAscii=stringToAscii;var UTF8Decoder="undefined"!=typeof TextDecoder?new TextDecoder("utf8"):void 0;Module.UTF8ArrayToString=UTF8ArrayToString,Module.UTF8ToString=UTF8ToString,Module.stringToUTF8Array=stringToUTF8Array,Module.stringToUTF8=stringToUTF8,Module.lengthBytesUTF8=lengthBytesUTF8;var UTF16Decoder="undefined"!=typeof TextDecoder?new TextDecoder("utf-16le"):void 0;Module.stackTrace=stackTrace;var WASM_PAGE_SIZE=65536,ASMJS_PAGE_SIZE=16777216,MIN_TOTAL_MEMORY=16777216,HEAP,buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64,STATIC_BASE,STATICTOP,staticSealed,STACK_BASE,STACKTOP,STACK_MAX,DYNAMIC_BASE,DYNAMICTOP_PTR;STATIC_BASE=STATICTOP=STACK_BASE=STACKTOP=STACK_MAX=DYNAMIC_BASE=DYNAMICTOP_PTR=0,staticSealed=!1,Module.reallocBuffer||(Module.reallocBuffer=function(e){var r;try{if(ArrayBuffer.transfer)r=ArrayBuffer.transfer(buffer,e);else{var i=HEAP8;r=new ArrayBuffer(e);new Int8Array(r).set(i)}}catch(e){return!1}return!!_emscripten_replace_memory(r)&&r});var byteLength;try{byteLength=Function.prototype.call.bind(Object.getOwnPropertyDescriptor(ArrayBuffer.prototype,"byteLength").get),byteLength(new ArrayBuffer(4))}catch(e){byteLength=function(e){return e.byteLength}}var TOTAL_STACK=Module.TOTAL_STACK||5242880,TOTAL_MEMORY=Module.TOTAL_MEMORY||16777216;if(TOTAL_MEMORY<TOTAL_STACK&&Module.printErr("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+TOTAL_MEMORY+"! (TOTAL_STACK="+TOTAL_STACK+")"),buffer=Module.buffer?Module.buffer:new ArrayBuffer(TOTAL_MEMORY),updateGlobalBufferViews(),HEAP32[0]=1668509029,HEAP16[1]=25459,115!==HEAPU8[2]||99!==HEAPU8[3])throw"Runtime error: expected the system to be little-endian!";Module.HEAP=HEAP,Module.buffer=buffer,Module.HEAP8=HEAP8,Module.HEAP16=HEAP16,Module.HEAP32=HEAP32,Module.HEAPU8=HEAPU8,Module.HEAPU16=HEAPU16,Module.HEAPU32=HEAPU32,Module.HEAPF32=HEAPF32,Module.HEAPF64=HEAPF64;var __ATPRERUN__=[],__ATINIT__=[],__ATMAIN__=[],__ATEXIT__=[],__ATPOSTRUN__=[],runtimeInitialized=!1,runtimeExited=!1;Module.addOnPreRun=addOnPreRun,Module.addOnInit=addOnInit,Module.addOnPreMain=addOnPreMain,Module.addOnExit=addOnExit,Module.addOnPostRun=addOnPostRun,Module.intArrayFromString=intArrayFromString,Module.intArrayToString=intArrayToString,Module.writeStringToMemory=writeStringToMemory,Module.writeArrayToMemory=writeArrayToMemory,Module.writeAsciiToMemory=writeAsciiToMemory,Math.imul&&-5===Math.imul(4294967295,5)||(Math.imul=function(e,r){var i=e>>>16,t=65535&e,n=r>>>16,_=65535&r;return t*_+(i*_+t*n<<16)|0}),Math.imul=Math.imul,Math.clz32||(Math.clz32=function(e){e>>>=0;for(var r=0;r<32;r++)if(e&1<<31-r)return r;return 32}),Math.clz32=Math.clz32,Math.trunc||(Math.trunc=function(e){return e<0?Math.ceil(e):Math.floor(e)}),Math.trunc=Math.trunc;var Math_abs=Math.abs,Math_cos=Math.cos,Math_sin=Math.sin,Math_tan=Math.tan,Math_acos=Math.acos,Math_asin=Math.asin,Math_atan=Math.atan,Math_atan2=Math.atan2,Math_exp=Math.exp,Math_log=Math.log,Math_sqrt=Math.sqrt,Math_ceil=Math.ceil,Math_floor=Math.floor,Math_pow=Math.pow,Math_imul=Math.imul,Math_fround=Math.fround,Math_round=Math.round,Math_min=Math.min,Math_clz32=Math.clz32,Math_trunc=Math.trunc,runDependencies=0,runDependencyWatcher=null,dependenciesFulfilled=null;Module.addRunDependency=addRunDependency,Module.removeRunDependency=removeRunDependency,Module.preloadedImages={},Module.preloadedAudios={};var ASM_CONSTS=[];STATIC_BASE=Runtime.GLOBAL_BASE,STATICTOP=STATIC_BASE+6192,__ATINIT__.push(),allocate([228,2,0,0,81,16,0,0,12,3,0,0,177,16,0,0,32,0,0,0,0,0,0,0,12,3,0,0,94,16,0,0,48,0,0,0,0,0,0,0,228,2,0,0,127,16,0,0,12,3,0,0,140,16,0,0,16,0,0,0,0,0,0,0,12,3,0,0,183,17,0,0,32,0,0,0,0,0,0,0,12,3,0,0,147,17,0,0,72,0,0,0,0,0,0,0,108,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,32,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,0,0,5,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,2,0,0,0,40,20,0,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,16,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,56,0,0,0,1,0,0,0,5,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,37,115,40,37,117,41,58,32,65,115,115,101,114,116,105,111,110,32,102,97,105,108,117,114,101,58,32,34,37,115,34,10,0,109,95,115,105,122,101,32,60,61,32,109,95,99,97,112,97,99,105,116,121,0,46,47,105,110,99,92,99,114,110,95,100,101,99,111,109,112,46,104,0,109,105,110,95,110,101,119,95,99,97,112,97,99,105,116,121,32,60,32,40,48,120,55,70,70,70,48,48,48,48,85,32,47,32,101,108,101,109,101,110,116,95,115,105,122,101,41,0,110,101,119,95,99,97,112,97,99,105,116,121,32,38,38,32,40,110,101,119,95,99,97,112,97,99,105,116,121,32,62,32,109,95,99,97,112,97,99,105,116,121,41,0,110,117,109,95,99,111,100,101,115,91,99,93,0,115,111,114,116,101,100,95,112,111,115,32,60,32,116,111,116,97,108,95,117,115,101,100,95,115,121,109,115,0,112,67,111,100,101,115,105,122,101,115,91,115,121,109,95,105,110,100,101,120,93,32,61,61,32,99,111,100,101,115,105,122,101,0,116,32,60,32,40,49,85,32,60,60,32,116,97,98,108,101,95,98,105,116,115,41,0,109,95,108,111,111,107,117,112,91,116,93,32,61,61,32,99,85,73,78,84,51,50,95,77,65,88,0,99,114,110,100,95,109,97,108,108,111,99,58,32,115,105,122,101,32,116,111,111,32,98,105,103,0,99,114,110,100,95,109,97,108,108,111,99,58,32,111,117,116,32,111,102,32,109,101,109,111,114,121,0,40,40,117,105,110,116,51,50,41,112,95,110,101,119,32,38,32,40,67,82,78,68,95,77,73,78,95,65,76,76,79,67,95,65,76,73,71,78,77,69,78,84,32,45,32,49,41,41,32,61,61,32,48,0,99,114,110,100,95,114,101,97,108,108,111,99,58,32,98,97,100,32,112,116,114,0,99,114,110,100,95,102,114,101,101,58,32,98,97,100,32,112,116,114,0,102,97,108,115,101,0,40,116,111,116,97,108,95,115,121,109,115,32,62,61,32,49,41,32,38,38,32,40,116,111,116,97,108,95,115,121,109,115,32,60,61,32,112,114,101,102,105,120,95,99,111,100,105,110,103,58,58,99,77,97,120,83,117,112,112,111,114,116,101,100,83,121,109,115,41,0,17,18,19,20,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15,16,48,0,110,117,109,95,98,105,116,115,32,60,61,32,51,50,85,0,109,95,98,105,116,95,99,111,117,110,116,32,60,61,32,99,66,105,116,66,117,102,83,105,122,101,0,116,32,33,61,32,99,85,73,78,84,51,50,95,77,65,88,0,109,111,100,101,108,46,109,95,99,111,100,101,95,115,105,122,101,115,91,115,121,109,93,32,61,61,32,108,101,110,0,0,2,3,1,0,2,3,4,5,6,7,1,40,108,101,110,32,62,61,32,49,41,32,38,38,32,40,108,101,110,32,60,61,32,99,77,97,120,69,120,112,101,99,116,101,100,67,111,100,101,83,105,122,101,41,0,105,32,60,32,109,95,115,105,122,101,0,110,101,120,116,95,108,101,118,101,108,95,111,102,115,32,62,32,99,117,114,95,108,101,118,101,108,95,111,102,115,0,1,2,2,3,3,3,3,4,0,0,0,0,0,0,1,1,0,1,0,1,0,0,1,2,1,2,0,0,0,1,0,2,1,0,2,0,0,1,2,3,110,117,109,32,38,38,32,40,110,117,109,32,61,61,32,126,110,117,109,95,99,104,101,99,107,41,0,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,46,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,116,101,114,109,105,110,97,116,105,110,103,0,117,110,99,97,117,103,104,116,0,83,116,57,101,120,99,101,112,116,105,111,110,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,83,116,57,116,121,112,101,95,105,110,102,111,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);var tempDoublePtr=STATICTOP;STATICTOP+=16;var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:function(e){if(!e||EXCEPTIONS.infos[e])return e;for(var r in EXCEPTIONS.infos){if(EXCEPTIONS.infos[r].adjusted===e)return r}return e},addRef:function(e){if(e){EXCEPTIONS.infos[e].refcount++}},decRef:function(e){if(e){var r=EXCEPTIONS.infos[e];assert(r.refcount>0),r.refcount--,0!==r.refcount||r.rethrown||(r.destructor&&Module.dynCall_vi(r.destructor,e),delete EXCEPTIONS.infos[e],___cxa_free_exception(e))}},clearRef:function(e){if(e){EXCEPTIONS.infos[e].refcount=0}}},SYSCALLS={varargs:0,get:function(e){return SYSCALLS.varargs+=4,HEAP32[SYSCALLS.varargs-4>>2]},getStr:function(){return Pointer_stringify(SYSCALLS.get())},get64:function(){var e=SYSCALLS.get(),r=SYSCALLS.get();return assert(e>=0?0===r:-1===r),e},getZero:function(){assert(0===SYSCALLS.get())}},cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_STATIC),PTHREAD_SPECIFIC={},PTHREAD_SPECIFIC_NEXT_KEY=1,ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};__ATEXIT__.push(function(){var e=Module._fflush;e&&e(0);var r=___syscall146.printChar;if(r){var i=___syscall146.buffers;i[1].length&&r(1,10),i[2].length&&r(2,10)}}),DYNAMICTOP_PTR=allocate(1,"i32",ALLOC_STATIC),STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP),STACK_MAX=STACK_BASE+TOTAL_STACK,DYNAMIC_BASE=Runtime.alignMemory(STACK_MAX),HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE,staticSealed=!0,Module.asmGlobalArg={Math:Math,Int8Array:Int8Array,Int16Array:Int16Array,Int32Array:Int32Array,Uint8Array:Uint8Array,Uint16Array:Uint16Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array,NaN:NaN,Infinity:1/0,byteLength:byteLength},Module.asmLibraryArg={abort:abort,assert:assert,enlargeMemory:enlargeMemory,getTotalMemory:getTotalMemory,abortOnCannotGrowMemory:abortOnCannotGrowMemory,invoke_iiii:invoke_iiii,invoke_viiiii:invoke_viiiii,invoke_vi:invoke_vi,invoke_ii:invoke_ii,invoke_viii:invoke_viii,invoke_v:invoke_v,invoke_viiiiii:invoke_viiiiii,invoke_viiii:invoke_viiii,_pthread_getspecific:_pthread_getspecific,
___syscall54:___syscall54,_pthread_setspecific:_pthread_setspecific,___gxx_personality_v0:___gxx_personality_v0,___syscall6:___syscall6,___setErrNo:___setErrNo,_abort:_abort,___cxa_begin_catch:___cxa_begin_catch,_pthread_once:_pthread_once,_emscripten_memcpy_big:_emscripten_memcpy_big,_pthread_key_create:_pthread_key_create,___syscall140:___syscall140,___resumeException:___resumeException,___cxa_find_matching_catch:___cxa_find_matching_catch,___syscall146:___syscall146,__ZSt18uncaught_exceptionv:__ZSt18uncaught_exceptionv,DYNAMICTOP_PTR:DYNAMICTOP_PTR,tempDoublePtr:tempDoublePtr,ABORT:ABORT,STACKTOP:STACKTOP,STACK_MAX:STACK_MAX,cttz_i8:cttz_i8};var asm=function(e,r,i){"almost asm";function t(e){return!(16777215&ii(e)||ii(e)<=16777215||ii(e)>2147483648)&&(Xr=new Hr(e),Yr=new Vr(e),Kr=new xr(e),Zr=new Wr(e),jr=new zr(e),Qr=new Jr(e),$r=new qr(e),ri=new ei(e),i=e,!0)}function n(e){e|=0;var r=0,i=0,t=0,n=0,_=0,a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,I=0;I=_i,_i=_i+16|0,l=I;do{if(e>>>0<245){if(u=e>>>0<11?16:e+11&-8,e=u>>>3,T=0|Kr[1144],3&(i=T>>>e)|0)return r=(1&i^1)+e|0,e=4616+(r<<1<<2)|0,i=e+8|0,t=0|Kr[i>>2],n=t+8|0,_=0|Kr[n>>2],(0|e)==(0|_)?Kr[1144]=T&~(1<<r):(Kr[_+12>>2]=e,Kr[i>>2]=_),N=r<<3,Kr[t+4>>2]=3|N,N=t+N+4|0,Kr[N>>2]=1|Kr[N>>2],N=n,_i=I,0|N;if(f=0|Kr[1146],u>>>0>f>>>0){if(0|i)return r=2<<e,r=i<<e&(r|0-r),r=(r&0-r)-1|0,a=r>>>12&16,r>>>=a,i=r>>>5&8,r>>>=i,n=r>>>2&4,r>>>=n,e=r>>>1&2,r>>>=e,t=r>>>1&1,t=(i|a|n|e|t)+(r>>>t)|0,r=4616+(t<<1<<2)|0,e=r+8|0,n=0|Kr[e>>2],a=n+8|0,i=0|Kr[a>>2],(0|r)==(0|i)?(e=T&~(1<<t),Kr[1144]=e):(Kr[i+12>>2]=r,Kr[e>>2]=i,e=T),_=(t<<3)-u|0,Kr[n+4>>2]=3|u,t=n+u|0,Kr[t+4>>2]=1|_,Kr[t+_>>2]=_,0|f&&(n=0|Kr[1149],r=f>>>3,i=4616+(r<<1<<2)|0,r=1<<r,e&r?(e=i+8|0,r=0|Kr[e>>2]):(Kr[1144]=e|r,r=i,e=i+8|0),Kr[e>>2]=n,Kr[r+12>>2]=n,Kr[n+8>>2]=r,Kr[n+12>>2]=i),Kr[1146]=_,Kr[1149]=t,N=a,_i=I,0|N;if(o=0|Kr[1145]){if(i=(o&0-o)-1|0,a=i>>>12&16,i>>>=a,_=i>>>5&8,i>>>=_,E=i>>>2&4,i>>>=E,t=i>>>1&2,i>>>=t,e=i>>>1&1,e=0|Kr[4880+((_|a|E|t|e)+(i>>>e)<<2)>>2],i=(-8&Kr[e+4>>2])-u|0,t=0|Kr[e+16+((0==(0|Kr[e+16>>2])&1)<<2)>>2]){do{a=(-8&Kr[t+4>>2])-u|0,E=a>>>0<i>>>0,i=E?a:i,e=E?t:e,t=0|Kr[t+16+((0==(0|Kr[t+16>>2])&1)<<2)>>2]}while(0!=(0|t));E=e,_=i}else E=e,_=i;if(a=E+u|0,E>>>0<a>>>0){n=0|Kr[E+24>>2],r=0|Kr[E+12>>2];do{if((0|r)==(0|E)){if(e=E+20|0,!((r=0|Kr[e>>2])||(e=E+16|0,r=0|Kr[e>>2]))){i=0;break}for(;;)if(i=r+20|0,0|(t=0|Kr[i>>2]))r=t,e=i;else{if(i=r+16|0,!(t=0|Kr[i>>2]))break;r=t,e=i}Kr[e>>2]=0,i=r}else i=0|Kr[E+8>>2],Kr[i+12>>2]=r,Kr[r+8>>2]=i,i=r}while(0);do{if(0|n){if(r=0|Kr[E+28>>2],e=4880+(r<<2)|0,(0|E)==(0|Kr[e>>2])){if(Kr[e>>2]=i,!i){Kr[1145]=o&~(1<<r);break}}else if(Kr[n+16+(((0|Kr[n+16>>2])!=(0|E)&1)<<2)>>2]=i,!i)break;Kr[i+24>>2]=n,r=0|Kr[E+16>>2],0|r&&(Kr[i+16>>2]=r,Kr[r+24>>2]=i),r=0|Kr[E+20>>2],0|r&&(Kr[i+20>>2]=r,Kr[r+24>>2]=i)}}while(0);return _>>>0<16?(N=_+u|0,Kr[E+4>>2]=3|N,N=E+N+4|0,Kr[N>>2]=1|Kr[N>>2]):(Kr[E+4>>2]=3|u,Kr[a+4>>2]=1|_,Kr[a+_>>2]=_,0|f&&(t=0|Kr[1149],r=f>>>3,i=4616+(r<<1<<2)|0,r=1<<r,T&r?(e=i+8|0,r=0|Kr[e>>2]):(Kr[1144]=T|r,r=i,e=i+8|0),Kr[e>>2]=t,Kr[r+12>>2]=t,Kr[t+8>>2]=r,Kr[t+12>>2]=i),Kr[1146]=_,Kr[1149]=a),N=E+8|0,_i=I,0|N}T=u}else T=u}else T=u}else if(e>>>0<=4294967231)if(e=e+11|0,u=-8&e,E=0|Kr[1145]){t=0-u|0,e>>>=8,e?u>>>0>16777215?o=31:(T=(e+1048320|0)>>>16&8,S=e<<T,f=(S+520192|0)>>>16&4,S<<=f,o=(S+245760|0)>>>16&2,o=14-(f|T|o)+(S<<o>>>15)|0,o=u>>>(o+7|0)&1|o<<1):o=0,i=0|Kr[4880+(o<<2)>>2];e:do{if(i)for(e=0,a=u<<(31==(0|o)?0:25-(o>>>1)|0),_=0;;){if((n=(-8&Kr[i+4>>2])-u|0)>>>0<t>>>0){if(!n){e=i,t=0,n=i,S=61;break e}e=i,t=n}if(n=0|Kr[i+20>>2],i=0|Kr[i+16+(a>>>31<<2)>>2],_=0==(0|n)|(0|n)==(0|i)?_:n,n=0==(0|i)){i=_,S=57;break}a<<=1&(1^n)}else i=0,e=0,S=57}while(0);if(57==(0|S)){if(0==(0|i)&0==(0|e)){if(e=2<<o,!(e=E&(e|0-e))){T=u;break}T=(e&0-e)-1|0,a=T>>>12&16,T>>>=a,_=T>>>5&8,T>>>=_,o=T>>>2&4,T>>>=o,f=T>>>1&2,T>>>=f,i=T>>>1&1,e=0,i=0|Kr[4880+((_|a|o|f|i)+(T>>>i)<<2)>>2]}i?(n=i,S=61):(o=e,a=t)}if(61==(0|S))for(;;){if(S=0,i=(-8&Kr[n+4>>2])-u|0,T=i>>>0<t>>>0,i=T?i:t,e=T?n:e,!(n=0|Kr[n+16+((0==(0|Kr[n+16>>2])&1)<<2)>>2])){o=e,a=i;break}t=i,S=61}if(0!=(0|o)?a>>>0<((0|Kr[1146])-u|0)>>>0:0){if(_=o+u|0,o>>>0>=_>>>0)return N=0,_i=I,0|N;n=0|Kr[o+24>>2],r=0|Kr[o+12>>2];do{if((0|r)==(0|o)){if(e=o+20|0,!((r=0|Kr[e>>2])||(e=o+16|0,r=0|Kr[e>>2]))){r=0;break}for(;;)if(i=r+20|0,0|(t=0|Kr[i>>2]))r=t,e=i;else{if(i=r+16|0,!(t=0|Kr[i>>2]))break;r=t,e=i}Kr[e>>2]=0}else N=0|Kr[o+8>>2],Kr[N+12>>2]=r,Kr[r+8>>2]=N}while(0);do{if(n){if(e=0|Kr[o+28>>2],i=4880+(e<<2)|0,(0|o)==(0|Kr[i>>2])){if(Kr[i>>2]=r,!r){t=E&~(1<<e),Kr[1145]=t;break}}else if(Kr[n+16+(((0|Kr[n+16>>2])!=(0|o)&1)<<2)>>2]=r,!r){t=E;break}Kr[r+24>>2]=n,e=0|Kr[o+16>>2],0|e&&(Kr[r+16>>2]=e,Kr[e+24>>2]=r),e=0|Kr[o+20>>2],e?(Kr[r+20>>2]=e,Kr[e+24>>2]=r,t=E):t=E}else t=E}while(0);do{if(a>>>0>=16){if(Kr[o+4>>2]=3|u,Kr[_+4>>2]=1|a,Kr[_+a>>2]=a,r=a>>>3,a>>>0<256){i=4616+(r<<1<<2)|0,e=0|Kr[1144],r=1<<r,e&r?(e=i+8|0,r=0|Kr[e>>2]):(Kr[1144]=e|r,r=i,e=i+8|0),Kr[e>>2]=_,Kr[r+12>>2]=_,Kr[_+8>>2]=r,Kr[_+12>>2]=i;break}if(r=a>>>8,r?a>>>0>16777215?r=31:(S=(r+1048320|0)>>>16&8,N=r<<S,M=(N+520192|0)>>>16&4,N<<=M,r=(N+245760|0)>>>16&2,r=14-(M|S|r)+(N<<r>>>15)|0,r=a>>>(r+7|0)&1|r<<1):r=0,i=4880+(r<<2)|0,Kr[_+28>>2]=r,e=_+16|0,Kr[e+4>>2]=0,Kr[e>>2]=0,e=1<<r,!(t&e)){Kr[1145]=t|e,Kr[i>>2]=_,Kr[_+24>>2]=i,Kr[_+12>>2]=_,Kr[_+8>>2]=_;break}for(e=a<<(31==(0|r)?0:25-(r>>>1)|0),i=0|Kr[i>>2];;){if((-8&Kr[i+4>>2]|0)==(0|a)){S=97;break}if(t=i+16+(e>>>31<<2)|0,!(r=0|Kr[t>>2])){S=96;break}e<<=1,i=r}if(96==(0|S)){Kr[t>>2]=_,Kr[_+24>>2]=i,Kr[_+12>>2]=_,Kr[_+8>>2]=_;break}if(97==(0|S)){S=i+8|0,N=0|Kr[S>>2],Kr[N+12>>2]=_,Kr[S>>2]=_,Kr[_+8>>2]=N,Kr[_+12>>2]=i,Kr[_+24>>2]=0;break}}else N=a+u|0,Kr[o+4>>2]=3|N,N=o+N+4|0,Kr[N>>2]=1|Kr[N>>2]}while(0);return N=o+8|0,_i=I,0|N}T=u}else T=u;else T=-1}while(0);if((i=0|Kr[1146])>>>0>=T>>>0)return r=i-T|0,e=0|Kr[1149],r>>>0>15?(N=e+T|0,Kr[1149]=N,Kr[1146]=r,Kr[N+4>>2]=1|r,Kr[N+r>>2]=r,Kr[e+4>>2]=3|T):(Kr[1146]=0,Kr[1149]=0,Kr[e+4>>2]=3|i,N=e+i+4|0,Kr[N>>2]=1|Kr[N>>2]),N=e+8|0,_i=I,0|N;if((a=0|Kr[1147])>>>0>T>>>0)return M=a-T|0,Kr[1147]=M,N=0|Kr[1150],S=N+T|0,Kr[1150]=S,Kr[S+4>>2]=1|M,Kr[N+4>>2]=3|T,N=N+8|0,_i=I,0|N;if(0|Kr[1262]?e=0|Kr[1264]:(Kr[1264]=4096,Kr[1263]=4096,Kr[1265]=-1,Kr[1266]=-1,Kr[1267]=0,Kr[1255]=0,e=-16&l^1431655768,Kr[l>>2]=e,Kr[1262]=e,e=4096),o=T+48|0,E=T+47|0,_=e+E|0,n=0-e|0,(u=_&n)>>>0<=T>>>0)return N=0,_i=I,0|N;if(e=0|Kr[1254],0|e?(f=0|Kr[1252],(l=f+u|0)>>>0<=f>>>0|l>>>0>e>>>0):0)return N=0,_i=I,0|N;e:do{if(4&Kr[1255])r=0,S=133;else{i=0|Kr[1150];r:do{if(i){for(t=5024;;){if(e=0|Kr[t>>2],e>>>0<=i>>>0?(R=t+4|0,(e+(0|Kr[R>>2])|0)>>>0>i>>>0):0)break;if(!(e=0|Kr[t+8>>2])){S=118;break r}t=e}if((r=_-a&n)>>>0<2147483647)if((0|(e=0|Ne(0|r)))==((0|Kr[t>>2])+(0|Kr[R>>2])|0)){if(-1!=(0|e)){a=r,_=e,S=135;break e}}else t=e,S=126;else r=0}else S=118}while(0);do{if(118==(0|S))if(i=0|Ne(0),-1!=(0|i)?(r=i,c=0|Kr[1263],A=c+-1|0,r=(0==(A&r|0)?0:(A+r&0-c)-r|0)+u|0,c=0|Kr[1252],A=r+c|0,r>>>0>T>>>0&r>>>0<2147483647):0){if(R=0|Kr[1254],0|R?A>>>0<=c>>>0|A>>>0>R>>>0:0){r=0;break}if((0|(e=0|Ne(0|r)))==(0|i)){a=r,_=i,S=135;break e}t=e,S=126}else r=0}while(0);do{if(126==(0|S)){if(i=0-r|0,!(o>>>0>r>>>0&r>>>0<2147483647&-1!=(0|t))){if(-1==(0|t)){r=0;break}a=r,_=t,S=135;break e}if(e=0|Kr[1264],(e=E-r+e&0-e)>>>0>=2147483647){a=r,_=t,S=135;break e}if(-1==(0|Ne(0|e))){Ne(0|i),r=0;break}a=e+r|0,_=t,S=135;break e}}while(0);Kr[1255]=4|Kr[1255],S=133}}while(0);if(!(133==(0|S)?u>>>0<2147483647:0)||(M=0|Ne(0|u),R=0|Ne(0),s=R-M|0,d=s>>>0>(T+40|0)>>>0,-1==(0|M)|1^d|M>>>0<R>>>0&-1!=(0|M)&-1!=(0|R)^1)||(a=d?s:r,_=M,S=135),135==(0|S)){r=(0|Kr[1252])+a|0,Kr[1252]=r,r>>>0>(0|Kr[1253])>>>0&&(Kr[1253]=r),E=0|Kr[1150];do{if(E){for(r=5024;;){if(e=0|Kr[r>>2],i=r+4|0,t=0|Kr[i>>2],(0|_)==(e+t|0)){S=145;break}if(!(n=0|Kr[r+8>>2]))break;r=n}if((145==(0|S)?0==(8&Kr[r+12>>2]|0):0)?E>>>0<_>>>0&E>>>0>=e>>>0:0){Kr[i>>2]=t+a,N=E+8|0,N=0==(7&N|0)?0:0-N&7,S=E+N|0,N=(0|Kr[1147])+(a-N)|0,Kr[1150]=S,Kr[1147]=N,Kr[S+4>>2]=1|N,Kr[S+N+4>>2]=40,Kr[1151]=Kr[1266];break}for(_>>>0<(0|Kr[1148])>>>0&&(Kr[1148]=_),i=_+a|0,r=5024;;){if((0|Kr[r>>2])==(0|i)){S=153;break}if(!(e=0|Kr[r+8>>2]))break;r=e}if(153==(0|S)?0==(8&Kr[r+12>>2]|0):0){Kr[r>>2]=_,f=r+4|0,Kr[f>>2]=(0|Kr[f>>2])+a,f=_+8|0,f=_+(0==(7&f|0)?0:0-f&7)|0,r=i+8|0,r=i+(0==(7&r|0)?0:0-r&7)|0,u=f+T|0,o=r-f-T|0,Kr[f+4>>2]=3|T;do{if((0|r)!=(0|E)){if((0|r)==(0|Kr[1149])){N=(0|Kr[1146])+o|0,Kr[1146]=N,Kr[1149]=u,Kr[u+4>>2]=1|N,Kr[u+N>>2]=N;break}if(1==(3&(e=0|Kr[r+4>>2])|0)){a=-8&e,t=e>>>3;e:do{if(e>>>0<256){if(e=0|Kr[r+8>>2],(0|(i=0|Kr[r+12>>2]))==(0|e)){Kr[1144]=Kr[1144]&~(1<<t);break}Kr[e+12>>2]=i,Kr[i+8>>2]=e;break}_=0|Kr[r+24>>2],e=0|Kr[r+12>>2];do{if((0|e)==(0|r)){if(t=r+16|0,i=t+4|0,!(e=0|Kr[i>>2])){if(!(e=0|Kr[t>>2])){e=0;break}i=t}for(;;)if(t=e+20|0,0|(n=0|Kr[t>>2]))e=n,i=t;else{if(t=e+16|0,!(n=0|Kr[t>>2]))break;e=n,i=t}Kr[i>>2]=0}else N=0|Kr[r+8>>2],Kr[N+12>>2]=e,Kr[e+8>>2]=N}while(0);if(!_)break;i=0|Kr[r+28>>2],t=4880+(i<<2)|0;do{if((0|r)==(0|Kr[t>>2])){if(Kr[t>>2]=e,0|e)break;Kr[1145]=Kr[1145]&~(1<<i);break e}if(Kr[_+16+(((0|Kr[_+16>>2])!=(0|r)&1)<<2)>>2]=e,!e)break e}while(0);if(Kr[e+24>>2]=_,i=r+16|0,t=0|Kr[i>>2],0|t&&(Kr[e+16>>2]=t,Kr[t+24>>2]=e),!(i=0|Kr[i+4>>2]))break;Kr[e+20>>2]=i,Kr[i+24>>2]=e}while(0);r=r+a|0,n=a+o|0}else n=o;if(r=r+4|0,Kr[r>>2]=-2&Kr[r>>2],Kr[u+4>>2]=1|n,Kr[u+n>>2]=n,r=n>>>3,n>>>0<256){i=4616+(r<<1<<2)|0,e=0|Kr[1144],r=1<<r,e&r?(e=i+8|0,r=0|Kr[e>>2]):(Kr[1144]=e|r,r=i,e=i+8|0),Kr[e>>2]=u,Kr[r+12>>2]=u,Kr[u+8>>2]=r,Kr[u+12>>2]=i;break}r=n>>>8;do{if(r){if(n>>>0>16777215){r=31;break}S=(r+1048320|0)>>>16&8,N=r<<S,M=(N+520192|0)>>>16&4,N<<=M,r=(N+245760|0)>>>16&2,r=14-(M|S|r)+(N<<r>>>15)|0,r=n>>>(r+7|0)&1|r<<1}else r=0}while(0);if(t=4880+(r<<2)|0,Kr[u+28>>2]=r,e=u+16|0,Kr[e+4>>2]=0,Kr[e>>2]=0,e=0|Kr[1145],i=1<<r,!(e&i)){Kr[1145]=e|i,Kr[t>>2]=u,Kr[u+24>>2]=t,Kr[u+12>>2]=u,Kr[u+8>>2]=u;break}for(e=n<<(31==(0|r)?0:25-(r>>>1)|0),i=0|Kr[t>>2];;){if((-8&Kr[i+4>>2]|0)==(0|n)){S=194;break}if(t=i+16+(e>>>31<<2)|0,!(r=0|Kr[t>>2])){S=193;break}e<<=1,i=r}if(193==(0|S)){Kr[t>>2]=u,Kr[u+24>>2]=i,Kr[u+12>>2]=u,Kr[u+8>>2]=u;break}if(194==(0|S)){S=i+8|0,N=0|Kr[S>>2],Kr[N+12>>2]=u,Kr[S>>2]=u,Kr[u+8>>2]=N,Kr[u+12>>2]=i,Kr[u+24>>2]=0;break}}else N=(0|Kr[1147])+o|0,Kr[1147]=N,Kr[1150]=u,Kr[u+4>>2]=1|N}while(0);return N=f+8|0,_i=I,0|N}for(r=5024;;){if(e=0|Kr[r>>2],e>>>0<=E>>>0?(N=e+(0|Kr[r+4>>2])|0)>>>0>E>>>0:0)break;r=0|Kr[r+8>>2]}n=N+-47|0,e=n+8|0,e=n+(0==(7&e|0)?0:0-e&7)|0,n=E+16|0,e=e>>>0<n>>>0?E:e,r=e+8|0,i=_+8|0,i=0==(7&i|0)?0:0-i&7,S=_+i|0,i=a+-40-i|0,Kr[1150]=S,Kr[1147]=i,Kr[S+4>>2]=1|i,Kr[S+i+4>>2]=40,Kr[1151]=Kr[1266],i=e+4|0,Kr[i>>2]=27,Kr[r>>2]=Kr[1256],Kr[r+4>>2]=Kr[1257],Kr[r+8>>2]=Kr[1258],Kr[r+12>>2]=Kr[1259],Kr[1256]=_,Kr[1257]=a,Kr[1259]=0,Kr[1258]=r,r=e+24|0;do{S=r,r=r+4|0,Kr[r>>2]=7}while((S+8|0)>>>0<N>>>0);if((0|e)!=(0|E)){if(_=e-E|0,Kr[i>>2]=-2&Kr[i>>2],Kr[E+4>>2]=1|_,Kr[e>>2]=_,r=_>>>3,_>>>0<256){i=4616+(r<<1<<2)|0,e=0|Kr[1144],r=1<<r,e&r?(e=i+8|0,r=0|Kr[e>>2]):(Kr[1144]=e|r,r=i,e=i+8|0),Kr[e>>2]=E,Kr[r+12>>2]=E,Kr[E+8>>2]=r,Kr[E+12>>2]=i;break}if(r=_>>>8,r?_>>>0>16777215?i=31:(S=(r+1048320|0)>>>16&8,N=r<<S,M=(N+520192|0)>>>16&4,N<<=M,i=(N+245760|0)>>>16&2,i=14-(M|S|i)+(N<<i>>>15)|0,i=_>>>(i+7|0)&1|i<<1):i=0,t=4880+(i<<2)|0,Kr[E+28>>2]=i,Kr[E+20>>2]=0,Kr[n>>2]=0,r=0|Kr[1145],e=1<<i,!(r&e)){Kr[1145]=r|e,Kr[t>>2]=E,Kr[E+24>>2]=t,Kr[E+12>>2]=E,Kr[E+8>>2]=E;break}for(e=_<<(31==(0|i)?0:25-(i>>>1)|0),i=0|Kr[t>>2];;){if((-8&Kr[i+4>>2]|0)==(0|_)){S=216;break}if(t=i+16+(e>>>31<<2)|0,!(r=0|Kr[t>>2])){S=215;break}e<<=1,i=r}if(215==(0|S)){Kr[t>>2]=E,Kr[E+24>>2]=i,Kr[E+12>>2]=E,Kr[E+8>>2]=E;break}if(216==(0|S)){S=i+8|0,N=0|Kr[S>>2],Kr[N+12>>2]=E,Kr[S>>2]=E,Kr[E+8>>2]=N,Kr[E+12>>2]=i,Kr[E+24>>2]=0;break}}}else{N=0|Kr[1148],0==(0|N)|_>>>0<N>>>0&&(Kr[1148]=_),Kr[1256]=_,Kr[1257]=a,Kr[1259]=0,Kr[1153]=Kr[1262],Kr[1152]=-1,r=0;do{N=4616+(r<<1<<2)|0,Kr[N+12>>2]=N,Kr[N+8>>2]=N,r=r+1|0}while(32!=(0|r));N=_+8|0,N=0==(7&N|0)?0:0-N&7,S=_+N|0,N=a+-40-N|0,Kr[1150]=S,Kr[1147]=N,Kr[S+4>>2]=1|N,Kr[S+N+4>>2]=40,Kr[1151]=Kr[1266]}}while(0);if((r=0|Kr[1147])>>>0>T>>>0)return M=r-T|0,Kr[1147]=M,N=0|Kr[1150],S=N+T|0,Kr[1150]=S,Kr[S+4>>2]=1|M,Kr[N+4>>2]=3|T,N=N+8|0,_i=I,0|N}return N=0|hr(),Kr[N>>2]=12,N=0,_i=I,0|N}function _(e,r,i,t,n,_){e|=0,r=+r,i|=0,t|=0,n|=0,_|=0;var a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,I=0,O=0,C=0,P=0,h=0,L=0,b=0,U=0;U=_i,_i=_i+560|0,E=U+8|0,s=U,b=U+524|0,L=b,u=U+512|0,Kr[s>>2]=0,h=u+12|0,Je(r),(0|fi)<0?(r=-r,C=1,O=2087):(C=0!=(2049&n|0)&1,O=0==(2048&n|0)?0==(1&n|0)?2088:2093:2090),Je(r),P=2146435072&fi;do{if(P>>>0<2146435072|2146435072==(0|P)&!1){if(c=2*+Cr(r,s),a=0!=c,a&&(Kr[s>>2]=(0|Kr[s>>2])-1),97==(0|(M=32|_))){A=32&_,l=0==(0|A)?O:O+9|0,T=2|C,a=12-t|0;do{if(!(t>>>0>11|0==(0|a))){r=8;do{a=a+-1|0,r*=16}while(0!=(0|a));if(45==(0|Xr[l>>0])){r=-(r+(-c-r));break}r=c+r-r;break}r=c}while(0);o=0|Kr[s>>2],a=(0|o)<0?0-o|0:o,a=0|ue(a,((0|a)<0)<<31>>31,h),(0|a)==(0|h)&&(a=u+11|0,Xr[a>>0]=48),Xr[a+-1>>0]=43+(o>>31&2),f=a+-2|0,Xr[f>>0]=_+15,u=(0|t)<1,E=0==(8&n|0),a=b;do{P=~~r,o=a+1|0,Xr[a>>0]=Zr[2122+P>>0]|A,r=16*(r-+(0|P)),1!=(o-L|0)||E&u&0==r?a=o:(Xr[o>>0]=46,a=a+2|0)}while(0!=r);P=a-L|0,L=h-f|0,h=0!=(0|t)&(P+-2|0)<(0|t)?t+2|0:P,a=L+T+h|0,Ae(e,32,i,a,n),tr(e,l,T),Ae(e,48,i,a,65536^n),tr(e,b,P),Ae(e,48,h-P|0,0,0),tr(e,f,L),Ae(e,32,i,a,8192^n);break}o=(0|t)<0?6:t,a?(a=(0|Kr[s>>2])-28|0,Kr[s>>2]=a,r=268435456*c):(r=c,a=0|Kr[s>>2]),P=(0|a)<0?E:E+288|0,E=P;do{N=~~r>>>0,Kr[E>>2]=N,E=E+4|0,r=1e9*(r-+(N>>>0))}while(0!=r);if((0|a)>0)for(u=P,T=E;;){if(f=(0|a)<29?a:29,(a=T+-4|0)>>>0>=u>>>0){E=0;do{S=0|Ye(0|Kr[a>>2],0,0|f),S=0|Qe(0|S,0|fi,0|E,0),N=fi,d=0|me(0|S,0|N,1e9,0),Kr[a>>2]=d,E=0|fr(0|S,0|N,1e9,0),a=a+-4|0}while(a>>>0>=u>>>0);E&&(u=u+-4|0,Kr[u>>2]=E)}for(E=T;;){if(E>>>0<=u>>>0)break;if(a=E+-4|0,0|Kr[a>>2])break;E=a}if(a=(0|Kr[s>>2])-f|0,Kr[s>>2]=a,!((0|a)>0))break;T=E}else u=P;if((0|a)<0){t=1+((o+25|0)/9|0)|0,R=102==(0|M);do{if(A=0-a|0,A=(0|A)<9?A:9,u>>>0<E>>>0){f=(1<<A)-1|0,T=1e9>>>A,l=0,a=u;do{N=0|Kr[a>>2],Kr[a>>2]=(N>>>A)+l,l=0|Ti(N&f,T),a=a+4|0}while(a>>>0<E>>>0);a=0==(0|Kr[u>>2])?u+4|0:u,l?(Kr[E>>2]=l,u=a,a=E+4|0):(u=a,a=E)}else u=0==(0|Kr[u>>2])?u+4|0:u,a=E;E=R?P:u,E=(a-E>>2|0)>(0|t)?E+(t<<2)|0:a,a=(0|Kr[s>>2])+A|0,Kr[s>>2]=a}while((0|a)<0);a=u,t=E}else a=u,t=E;if(N=P,a>>>0<t>>>0){if(E=9*(N-a>>2)|0,(f=0|Kr[a>>2])>>>0>=10){u=10;do{u=10*u|0,E=E+1|0}while(f>>>0>=u>>>0)}}else E=0;if(R=103==(0|M),d=0!=(0|o),(0|(u=o-(102!=(0|M)?E:0)+((d&R)<<31>>31)|0))<((9*(t-N>>2)|0)-9|0)){if(u=u+9216|0,A=P+4+(((0|u)/9|0)-1024<<2)|0,(0|(u=1+((0|u)%9|0)|0))<9){f=10;do{f=10*f|0,u=u+1|0}while(9!=(0|u))}else f=10;if(T=0|Kr[A>>2],l=(T>>>0)%(f>>>0)|0,(u=(A+4|0)==(0|t))&0==(0|l))u=A;else if(c=0==(1&((T>>>0)/(f>>>0)|0)|0)?9007199254740992:9007199254740994,S=(0|f)/2|0,r=l>>>0<S>>>0?.5:u&(0|l)==(0|S)?1:1.5,C&&(S=45==(0|Xr[O>>0]),r=S?-r:r,c=S?-c:c),u=T-l|0,Kr[A>>2]=u,c+r!=c){if(S=u+f|0,Kr[A>>2]=S,S>>>0>999999999)for(E=A;;){if(u=E+-4|0,Kr[E>>2]=0,u>>>0<a>>>0&&(a=a+-4|0,Kr[a>>2]=0),S=1+(0|Kr[u>>2])|0,Kr[u>>2]=S,!(S>>>0>999999999))break;E=u}else u=A;if(E=9*(N-a>>2)|0,(T=0|Kr[a>>2])>>>0>=10){f=10;do{f=10*f|0,E=E+1|0}while(T>>>0>=f>>>0)}}else u=A;u=u+4|0,u=t>>>0>u>>>0?u:t,S=a}else u=t,S=a;for(M=u;;){if(M>>>0<=S>>>0){s=0;break}if(a=M+-4|0,0|Kr[a>>2]){s=1;break}M=a}t=0-E|0;do{if(R){if(a=(1&(1^d))+o|0,(0|a)>(0|E)&(0|E)>-5?(f=_+-1|0,o=a+-1-E|0):(f=_+-2|0,o=a+-1|0),!(a=8&n)){if(s?0!=(0|(I=0|Kr[M+-4>>2])):0)if((I>>>0)%10|0)u=0;else{u=0,a=10;do{a=10*a|0,u=u+1|0}while(!(0|(I>>>0)%(a>>>0)))}else u=9;if(a=(9*(M-N>>2)|0)-9|0,102==(32|f)){A=a-u|0,A=(0|A)>0?A:0,o=(0|o)<(0|A)?o:A,A=0;break}A=a+E-u|0,A=(0|A)>0?A:0,o=(0|o)<(0|A)?o:A,A=0;break}A=a}else f=_,A=8&n}while(0);if(R=o|A,T=0!=(0|R)&1,l=102==(32|f))d=0,a=(0|E)>0?E:0;else{if(a=(0|E)<0?t:E,a=0|ue(a,((0|a)<0)<<31>>31,h),((u=h)-a|0)<2)do{a=a+-1|0,Xr[a>>0]=48}while((u-a|0)<2);Xr[a+-1>>0]=43+(E>>31&2),a=a+-2|0,Xr[a>>0]=f,d=a,a=u-a|0}if(a=C+1+o+T+a|0,Ae(e,32,i,a,n),tr(e,O,C),Ae(e,48,i,a,65536^n),l){f=S>>>0>P>>>0?P:S,A=b+9|0,T=A,l=b+8|0,u=f;do{if(E=0|ue(0|Kr[u>>2],0,A),(0|u)==(0|f))(0|E)==(0|A)&&(Xr[l>>0]=48,E=l);else if(E>>>0>b>>>0){ee(0|b,48,E-L|0);do{E=E+-1|0}while(E>>>0>b>>>0)}tr(e,E,T-E|0),u=u+4|0}while(u>>>0<=P>>>0);if(0|R&&tr(e,2138,1),u>>>0<M>>>0&(0|o)>0)for(;;){if((E=0|ue(0|Kr[u>>2],0,A))>>>0>b>>>0){ee(0|b,48,E-L|0);do{E=E+-1|0}while(E>>>0>b>>>0)}if(tr(e,E,(0|o)<9?o:9),u=u+4|0,E=o+-9|0,!(u>>>0<M>>>0&(0|o)>9)){o=E;break}o=E}Ae(e,48,o+9|0,9,0)}else{if(R=s?M:S+4|0,(0|o)>-1){s=b+9|0,A=0==(0|A),t=s,T=0-L|0,l=b+8|0,f=S;do{E=0|ue(0|Kr[f>>2],0,s),(0|E)==(0|s)&&(Xr[l>>0]=48,E=l);do{if((0|f)==(0|S)){if(u=E+1|0,tr(e,E,1),A&(0|o)<1){E=u;break}tr(e,2138,1),E=u}else{if(E>>>0<=b>>>0)break;ee(0|b,48,E+T|0);do{E=E+-1|0}while(E>>>0>b>>>0)}}while(0);L=t-E|0,tr(e,E,(0|o)>(0|L)?L:o),o=o-L|0,f=f+4|0}while(f>>>0<R>>>0&(0|o)>-1)}Ae(e,48,o+18|0,18,0),tr(e,d,h-d|0)}Ae(e,32,i,a,8192^n)}else b=0!=(32&_|0),a=C+3|0,Ae(e,32,i,a,-65537&n),tr(e,O,C),tr(e,r!=r|!1?b?2114:2118:b?2106:2110,3),Ae(e,32,i,a,8192^n)}while(0);return _i=U,0|((0|a)<(0|i)?i:a)}function a(e,r,i,t,n){e|=0,r|=0,i|=0,t|=0,n|=0;var a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,I=0,O=0,P=0,h=0,L=0,b=0,U=0,F=0;F=_i,_i=_i+64|0,h=F+16|0,L=F,O=F+24|0,b=F+8|0,U=F+20|0,Kr[h>>2]=r,S=0!=(0|e),N=O+40|0,I=N,O=O+39|0,P=b+4|0,o=0,a=0,T=0;e:for(;;){do{if((0|a)>-1){if((0|o)>(2147483647-a|0)){a=0|hr(),Kr[a>>2]=75,a=-1;break}a=o+a|0;break}}while(0);if(!((o=0|Xr[r>>0])<<24>>24)){M=87;break}E=r;r:for(;;){switch(o<<24>>24){case 37:o=E,M=9;break r;case 0:o=E;break r}d=E+1|0,Kr[h>>2]=d,o=0|Xr[d>>0],E=d}r:do{if(9==(0|M))for(;;){if(M=0,37!=(0|Xr[E+1>>0]))break r;if(o=o+1|0,E=E+2|0,Kr[h>>2]=E,37!=(0|Xr[E>>0]))break;M=9}}while(0);if(o=o-r|0,S&&tr(e,r,o),0|o)r=E;else{u=E+1|0,o=(0|Xr[u>>0])-48|0,o>>>0<10?(d=36==(0|Xr[E+2>>0]),s=d?o:-1,T=d?1:T,u=d?E+3|0:u):s=-1,Kr[h>>2]=u,o=0|Xr[u>>0],E=(o<<24>>24)-32|0;r:do{if(E>>>0<32)for(f=0,l=o;;){if(!(75913&(o=1<<E))){o=l;break r}if(f|=o,u=u+1|0,Kr[h>>2]=u,o=0|Xr[u>>0],(E=(o<<24>>24)-32|0)>>>0>=32)break;l=o}else f=0}while(0);if(o<<24>>24==42){if(E=u+1|0,o=(0|Xr[E>>0])-48|0,o>>>0<10?36==(0|Xr[u+2>>0]):0)Kr[n+(o<<2)>>2]=10,o=0|Kr[t+((0|Xr[E>>0])-48<<3)>>2],T=1,u=u+3|0;else{if(0|T){a=-1;break}S?(T=3+(0|Kr[i>>2])&-4,o=0|Kr[T>>2],Kr[i>>2]=T+4,T=0,u=E):(o=0,T=0,u=E)}Kr[h>>2]=u,d=(0|o)<0,o=d?0-o|0:o,f=d?8192|f:f}else{if((0|(o=0|Pe(h)))<0){a=-1;break}u=0|Kr[h>>2]}do{if(46==(0|Xr[u>>0])){if(42!=(0|Xr[u+1>>0])){Kr[h>>2]=u+1,E=0|Pe(h),u=0|Kr[h>>2];break}if(l=u+2|0,E=(0|Xr[l>>0])-48|0,E>>>0<10?36==(0|Xr[u+3>>0]):0){Kr[n+(E<<2)>>2]=10,E=0|Kr[t+((0|Xr[l>>0])-48<<3)>>2],u=u+4|0,Kr[h>>2]=u;break}if(0|T){a=-1;break e}S?(d=3+(0|Kr[i>>2])&-4,E=0|Kr[d>>2],Kr[i>>2]=d+4):E=0,Kr[h>>2]=l,u=l}else E=-1}while(0);for(R=0;;){if(((0|Xr[u>>0])-65|0)>>>0>57){a=-1;break e}if(d=u+1|0,Kr[h>>2]=d,l=0|Xr[(0|Xr[u>>0])-65+(1606+(58*R|0))>>0],!(((c=255&l)+-1|0)>>>0<8))break;R=c,u=d}if(!(l<<24>>24)){a=-1;break}A=(0|s)>-1;do{if(l<<24>>24==19){if(A){a=-1;break e}M=49}else{if(A){Kr[n+(s<<2)>>2]=c,A=t+(s<<3)|0,s=0|Kr[A+4>>2],M=L,Kr[M>>2]=Kr[A>>2],Kr[M+4>>2]=s,M=49;break}if(!S){a=0;break e}C(L,c,i)}}while(0);if(49!=(0|M)||(M=0,S)){u=0|Xr[u>>0],u=0!=(0|R)&3==(15&u|0)?-33&u:u,A=-65537&f,s=0==(8192&f|0)?f:A;r:do{switch(0|u){case 110:switch((255&R)<<24>>24){case 0:case 1:Kr[Kr[L>>2]>>2]=a,o=0,r=d;continue e;case 2:o=0|Kr[L>>2],Kr[o>>2]=a,Kr[o+4>>2]=((0|a)<0)<<31>>31,o=0,r=d;continue e;case 3:Yr[Kr[L>>2]>>1]=a,o=0,r=d;continue e;case 4:Xr[Kr[L>>2]>>0]=a,o=0,r=d;continue e;case 6:Kr[Kr[L>>2]>>2]=a,o=0,r=d;continue e;case 7:o=0|Kr[L>>2],Kr[o>>2]=a,Kr[o+4>>2]=((0|a)<0)<<31>>31,o=0,r=d;continue e;default:o=0,r=d;continue e}case 112:u=120,E=E>>>0>8?E:8,r=8|s,M=61;break;case 88:case 120:r=s,M=61;break;case 111:u=L,r=0|Kr[u>>2],u=0|Kr[u+4>>2],c=0|Fe(r,u,N),A=I-c|0,f=0,l=2070,E=0==(8&s|0)|(0|E)>(0|A)?E:A+1|0,A=s,M=67;break;case 105:case 100:if(u=L,r=0|Kr[u>>2],(0|(u=0|Kr[u+4>>2]))<0){r=0|Ze(0,0,0|r,0|u),u=fi,f=L,Kr[f>>2]=r,Kr[f+4>>2]=u,f=1,l=2070,M=66;break r}f=0!=(2049&s|0)&1,l=0==(2048&s|0)?0==(1&s|0)?2070:2072:2071,M=66;break r;case 117:u=L,f=0,l=2070,r=0|Kr[u>>2],u=0|Kr[u+4>>2],M=66;break;case 99:Xr[O>>0]=Kr[L>>2],r=O,f=0,l=2070,c=N,u=1,E=A;break;case 109:u=0|hr(),u=0|ar(0|Kr[u>>2]),M=71;break;case 115:u=0|Kr[L>>2],u=0|u?u:2080,M=71;break;case 67:Kr[b>>2]=Kr[L>>2],Kr[P>>2]=0,Kr[L>>2]=b,c=-1,u=b,M=75;break;case 83:r=0|Kr[L>>2],E?(c=E,u=r,M=75):(Ae(e,32,o,0,s),r=0,M=84);break;case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:o=0|_(e,+ri[L>>3],o,E,s,u),r=d;continue e;default:f=0,l=2070,c=N,u=E,E=s}}while(0);r:do{if(61==(0|M))s=L,R=0|Kr[s>>2],s=0|Kr[s+4>>2],c=0|he(R,s,N,32&u),l=0==(8&r|0)|0==(0|R)&0==(0|s),f=l?0:2,l=l?2070:2070+(u>>4)|0,A=r,r=R,u=s,M=67;else if(66==(0|M))c=0|ue(r,u,N),A=s,M=67;else if(71==(0|M))M=0,s=0|X(u,0,E),R=0==(0|s),r=u,f=0,l=2070,c=R?u+E|0:s,u=R?E:s-u|0,E=A;else if(75==(0|M)){for(M=0,l=u,r=0,E=0;;){if(!(f=0|Kr[l>>2]))break;if((0|(E=0|or(U,f)))<0|E>>>0>(c-r|0)>>>0)break;if(r=E+r|0,!(c>>>0>r>>>0))break;l=l+4|0}if((0|E)<0){a=-1;break e}if(Ae(e,32,o,r,s),r)for(f=0;;){if(!(E=0|Kr[u>>2])){M=84;break r}if(E=0|or(U,E),(0|(f=E+f|0))>(0|r)){M=84;break r}if(tr(e,U,E),f>>>0>=r>>>0){M=84;break}u=u+4|0}else r=0,M=84}}while(0);if(67==(0|M))M=0,u=0!=(0|r)|0!=(0|u),s=0!=(0|E)|u,u=I-c+(1&(1^u))|0,r=s?c:N,c=N,u=s?(0|E)>(0|u)?E:u:E,E=(0|E)>-1?-65537&A:A;else if(84==(0|M)){M=0,Ae(e,32,o,r,8192^s),o=(0|o)>(0|r)?o:r,r=d;continue}R=c-r|0,A=(0|u)<(0|R)?R:u,s=A+f|0,o=(0|o)<(0|s)?s:o,Ae(e,32,o,s,E),tr(e,l,f),Ae(e,48,o,s,65536^E),Ae(e,48,A,R,0),tr(e,r,R),Ae(e,32,o,s,8192^E),r=d}else o=0,r=d}}e:do{if(87==(0|M)&&!e)if(T){for(a=1;;){if(!(r=0|Kr[n+(a<<2)>>2]))break;if(C(t+(a<<3)|0,r,i),(0|(a=a+1|0))>=10){a=1;break e}}for(;;){if(0|Kr[n+(a<<2)>>2]){a=-1;break e}if((0|(a=a+1|0))>=10){a=1;break}}}else a=0}while(0);return _i=F,0|a}function o(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0,a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,O=0,C=0,P=0,L=0,b=0,U=0;if(U=_i,_i=_i+704|0,C=U+144|0,O=U+128|0,N=U+112|0,S=U+96|0,M=U+80|0,d=U+64|0,s=U+48|0,P=U+32|0,f=U+16|0,o=U,l=U+184|0,b=U+160|0,!(c=0|x(e,14)))return J(r),b=1,_i=U,0|b;if(A=r+4|0,R=r+8|0,(0|(i=0|Kr[R>>2]))!=(0|c)){if(i>>>0<=c>>>0){do{if((0|Kr[r+12>>2])>>>0<c>>>0){if(0|h(A,c,(i+1|0)==(0|c),1,0)){i=0|Kr[R>>2];break}return Xr[r+16>>0]=1,b=0,_i=U,0|b}}while(0);ee((0|Kr[A>>2])+i|0,0,c-i|0)}Kr[R>>2]=c}if(ee(0|Kr[A>>2],0,0|c),T=e+20|0,(0|(i=0|Kr[T>>2]))<5){_=e+4|0,a=e+8|0,n=e+16|0;do{t=0|Kr[_>>2],(0|t)==(0|Kr[a>>2])?t=0:(Kr[_>>2]=t+1,t=0|Zr[t>>0]),i=i+8|0,Kr[T>>2]=i,(0|i)>=33&&(Kr[o>>2]=866,Kr[o+4>>2]=3208,Kr[o+8>>2]=1366,He(l,812,o),le(l),i=0|Kr[T>>2]),t=t<<32-i|Kr[n>>2],Kr[n>>2]=t}while((0|i)<5)}else t=e+16|0,n=t,t=0|Kr[t>>2];if(u=t>>>27,Kr[n>>2]=t<<5,Kr[T>>2]=i+-5,(u+-1|0)>>>0>20)return b=0,_i=U,0|b;Kr[b+20>>2]=0,Kr[b>>2]=0,Kr[b+4>>2]=0,Kr[b+8>>2]=0,Kr[b+12>>2]=0,Xr[b+16>>0]=0,i=b+4|0,t=b+8|0;e:do{if(0|h(i,21,0,1,0)){_=0|Kr[t>>2],E=0|Kr[i>>2],ee(E+_|0,0,21-_|0),Kr[t>>2]=21,_=e+4|0,a=e+8|0,o=e+16|0,n=0;do{if((0|(i=0|Kr[T>>2]))<3)do{t=0|Kr[_>>2],(0|t)==(0|Kr[a>>2])?t=0:(Kr[_>>2]=t+1,t=0|Zr[t>>0]),i=i+8|0,Kr[T>>2]=i,(0|i)>=33&&(Kr[f>>2]=866,Kr[f+4>>2]=3208,Kr[f+8>>2]=1366,He(l,812,f),le(l),i=0|Kr[T>>2]),t=t<<32-i|Kr[o>>2],Kr[o>>2]=t}while((0|i)<3);else t=0|Kr[o>>2];Kr[o>>2]=t<<3,Kr[T>>2]=i+-3,Xr[E+(0|Zr[1327+n>>0])>>0]=t>>>29,n=n+1|0}while((0|n)!=(0|u));if(0|y(b)){o=e+4|0,E=e+8|0,u=e+16|0,i=0;r:do{a=c-i|0,n=0|I(e,b);i:do{if(n>>>0<17)(0|Kr[R>>2])>>>0<=i>>>0&&(Kr[P>>2]=866,Kr[P+4>>2]=910,Kr[P+8>>2]=1497,He(l,812,P),le(l)),Xr[(0|Kr[A>>2])+i>>0]=n,i=i+1|0;else switch(0|n){case 17:if((0|(t=0|Kr[T>>2]))<3)do{n=0|Kr[o>>2],(0|n)==(0|Kr[E>>2])?n=0:(Kr[o>>2]=n+1,n=0|Zr[n>>0]),t=t+8|0,Kr[T>>2]=t,(0|t)>=33&&(Kr[s>>2]=866,Kr[s+4>>2]=3208,Kr[s+8>>2]=1366,He(l,812,s),le(l),t=0|Kr[T>>2]),n=n<<32-t|Kr[u>>2],Kr[u>>2]=n}while((0|t)<3);else n=0|Kr[u>>2];if(Kr[u>>2]=n<<3,Kr[T>>2]=t+-3,n=3+(n>>>29)|0,t=n>>>0>a>>>0){i=0;break e}i=(t?0:n)+i|0;break i;case 18:if((0|(t=0|Kr[T>>2]))<7)do{n=0|Kr[o>>2],(0|n)==(0|Kr[E>>2])?n=0:(Kr[o>>2]=n+1,n=0|Zr[n>>0]),t=t+8|0,Kr[T>>2]=t,(0|t)>=33&&(Kr[d>>2]=866,Kr[d+4>>2]=3208,Kr[d+8>>2]=1366,He(l,812,d),le(l),t=0|Kr[T>>2]),n=n<<32-t|Kr[u>>2],Kr[u>>2]=n}while((0|t)<7);else n=0|Kr[u>>2];if(Kr[u>>2]=n<<7,Kr[T>>2]=t+-7,n=11+(n>>>25)|0,t=n>>>0>a>>>0){i=0;break e}i=(t?0:n)+i|0;break i;default:if((n+-19|0)>>>0>=2){L=81;break r}if(t=0|Kr[T>>2],19==(0|n)){if((0|t)<2)for(n=t;;){if(t=0|Kr[o>>2],(0|t)==(0|Kr[E>>2])?_=0:(Kr[o>>2]=t+1,_=0|Zr[t>>0]),t=n+8|0,Kr[T>>2]=t,(0|t)>=33&&(Kr[M>>2]=866,Kr[M+4>>2]=3208,Kr[M+8>>2]=1366,He(l,812,M),le(l),t=0|Kr[T>>2]),n=_<<32-t|Kr[u>>2],Kr[u>>2]=n,!((0|t)<2))break;n=t}else n=0|Kr[u>>2];Kr[u>>2]=n<<2,n>>>=30,_=3,t=t+-2|0}else{if((0|t)<6)do{n=0|Kr[o>>2],(0|n)==(0|Kr[E>>2])?n=0:(Kr[o>>2]=n+1,n=0|Zr[n>>0]),t=t+8|0,Kr[T>>2]=t,(0|t)>=33&&(Kr[S>>2]=866,Kr[S+4>>2]=3208,Kr[S+8>>2]=1366,He(l,812,S),le(l),t=0|Kr[T>>2]),n=n<<32-t|Kr[u>>2],Kr[u>>2]=n}while((0|t)<6);else n=0|Kr[u>>2];Kr[u>>2]=n<<6,n>>>=26,_=7,t=t+-6|0}if(Kr[T>>2]=t,n=n+_|0,0==(0|i)|n>>>0>a>>>0){i=0;break e}if(t=i+-1|0,(0|Kr[R>>2])>>>0<=t>>>0&&(Kr[N>>2]=866,Kr[N+4>>2]=910,Kr[N+8>>2]=1497,He(l,812,N),le(l)),!((_=0|Xr[(0|Kr[A>>2])+t>>0])<<24>>24)){i=0;break e}if(t=n+i|0,i>>>0>=t>>>0)break i;do{(0|Kr[R>>2])>>>0<=i>>>0&&(Kr[O>>2]=866,Kr[O+4>>2]=910,Kr[O+8>>2]=1497,He(l,812,O),le(l)),Xr[(0|Kr[A>>2])+i>>0]=_,i=i+1|0}while((0|i)!=(0|t));i=t}}while(0)}while(c>>>0>i>>>0);if(81==(0|L)){Kr[C>>2]=866,Kr[C+4>>2]=3149,Kr[C+8>>2]=1348,He(l,812,C),le(l),i=0;break}i=(0|c)==(0|i)?0|y(r):0}else i=0}else Xr[b+16>>0]=1,i=0}while(0);return z(b),b=i,_i=U,0|b}function E(e,r,i,t){e|=0,r|=0,i|=0,t|=0;var n=0,_=0,a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,I=0,O=0,C=0,P=0,h=0,L=0,b=0,U=0,F=0,D=0,m=0;if(m=_i,_i=_i+880|0,F=m+144|0,U=m+128|0,b=m+112|0,L=m+96|0,O=m+80|0,d=m+64|0,R=m+48|0,s=m+32|0,T=m+16|0,f=m,P=m+360|0,h=m+296|0,D=m+224|0,A=m+156|0,0==(0|r)|t>>>0>11)return D=0,_i=m,0|D;Kr[e>>2]=r,n=D,_=n+68|0;do{Kr[n>>2]=0,n=n+4|0}while((0|n)<(0|_));n=0;do{C=0|Xr[i+n>>0],_=D+((255&C)<<2)|0,C<<24>>24&&(Kr[_>>2]=1+(0|Kr[_>>2])),n=n+1|0}while((0|n)!=(0|r));for(_=0,a=0,o=0,E=-1,u=1;;){if(n=0|Kr[D+(u<<2)>>2],n?(l=u+-1|0,Kr[h+(l<<2)>>2]=_,_=n+_|0,C=16-u|0,Kr[e+28+(l<<2)>>2]=1+(_+-1<<C|(1<<C)-1),Kr[e+96+(l<<2)>>2]=a,Kr[A+(u<<2)>>2]=a,l=n+a|0,o=o>>>0>u>>>0?o:u,E=E>>>0<u>>>0?E:u):(Kr[e+28+(u+-1<<2)>>2]=0,l=a),17==(0|(u=u+1|0)))break;_<<=1,a=l}Kr[e+4>>2]=l,_=e+172|0;do{if(l>>>0>(0|Kr[_>>2])>>>0){n=l+-1|0,n&l?(n|=n>>>16,n|=n>>>8,n|=n>>>4,n|=n>>>2,n=1+(n>>>1|n)|0,n=n>>>0>r>>>0?r:n):n=l,Kr[_>>2]=n,a=e+176|0,n=0|Kr[a>>2];do{if(0|n){if(C=0|Kr[n+-4>>2],n=n+-8|0,(0!=(0|C)?(0|C)==(0|~Kr[n>>2]):0)||(Kr[f>>2]=866,Kr[f+4>>2]=651,Kr[f+8>>2]=1579,He(P,812,f),le(P)),7&n){Kr[T>>2]=866,Kr[T+4>>2]=2506,Kr[T+8>>2]=1232,He(P,812,T),le(P);break}_e(n,0,0,1,0);break}}while(0);if(n=0|Kr[_>>2],n=0|n?n:1,_=0|j(8+(n<<1)|0,0)){Kr[_+4>>2]=n,Kr[_>>2]=~n,Kr[a>>2]=_+8,c=24;break}Kr[a>>2]=0,t=0;break}c=24}while(0);e:do{if(24==(0|c)){C=e+24|0,Xr[C>>0]=E,Xr[e+25>>0]=o,a=e+176|0,_=0;do{I=0|Xr[i+_>>0],n=255&I,I<<24>>24&&(0|Kr[D+(n<<2)>>2]||(Kr[s>>2]=866,Kr[s+4>>2]=2276,Kr[s+8>>2]=977,He(P,812,s),le(P)),I=A+(n<<2)|0,n=0|Kr[I>>2],Kr[I>>2]=n+1,n>>>0>=l>>>0&&(Kr[R>>2]=866,Kr[R+4>>2]=2280,Kr[R+8>>2]=990,He(P,812,R),le(P)),Yr[(0|Kr[a>>2])+(n<<1)>>1]=_),_=_+1|0}while((0|_)!=(0|r));if(N=(0|Zr[C>>0])>>>0<t>>>0?t:0,I=e+8|0,Kr[I>>2]=N,S=0!=(0|N)){M=1<<N,n=e+164|0;do{if(M>>>0>(0|Kr[n>>2])>>>0){Kr[n>>2]=M,a=e+168|0,n=0|Kr[a>>2];do{if(0|n){if(s=0|Kr[n+-4>>2],n=n+-8|0,(0!=(0|s)?(0|s)==(0|~Kr[n>>2]):0)||(Kr[d>>2]=866,Kr[d+4>>2]=651,Kr[d+8>>2]=1579,He(P,812,d),le(P)),7&n){Kr[O>>2]=866,Kr[O+4>>2]=2506,Kr[O+8>>2]=1232,He(P,812,O),le(P);break}_e(n,0,0,1,0);break}}while(0);if(n=M<<2,_=0|j(n+8|0,0)){O=_+8|0,Kr[_+4>>2]=M,Kr[_>>2]=~M,Kr[a>>2]=O,_=O;break}Kr[a>>2]=0,t=0;break e}_=e+168|0,n=M<<2,a=_,_=0|Kr[_>>2]}while(0);ee(0|_,-1,0|n),R=e+176|0,A=1;do{if(0|Kr[D+(A<<2)>>2]&&(s=N-A|0,d=1<<s,n=A+-1|0,_=0|Kr[h+(n<<2)>>2],n>>>0>=16&&(Kr[L>>2]=866,Kr[L+4>>2]=1960,Kr[L+8>>2]=1453,He(P,812,L),le(P)),r=0|Kr[e+28+(n<<2)>>2],r=0==(0|r)?-1:(r+-1|0)>>>(16-A|0),_>>>0<=r>>>0)){l=(0|Kr[e+96+(n<<2)>>2])-_|0,c=A<<16;do{n=0|jr[(0|Kr[R>>2])+(l+_<<1)>>1],(0|Zr[i+n>>0])!=(0|A)&&(Kr[b>>2]=866,Kr[b+4>>2]=2322,Kr[b+8>>2]=1019,He(P,812,b),le(P)),T=_<<s,u=n|c,E=0;do{f=E+T|0,f>>>0>=M>>>0&&(Kr[U>>2]=866,Kr[U+4>>2]=2328,Kr[U+8>>2]=1053,He(P,812,U),le(P)),n=0|Kr[a>>2],-1!=(0|Kr[n+(f<<2)>>2])&&(Kr[F>>2]=866,Kr[F+4>>2]=2330,Kr[F+8>>2]=1076,He(P,812,F),le(P),n=0|Kr[a>>2]),Kr[n+(f<<2)>>2]=u,E=E+1|0}while(E>>>0<d>>>0);_=_+1|0}while(_>>>0<=r>>>0)}A=A+1|0}while(N>>>0>=A>>>0)}n=e+96|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h>>2]),n=e+100|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+4>>2]),n=e+104|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+8>>2]),n=e+108|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+12>>2]),n=e+112|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+16>>2]),n=e+116|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+20>>2]),n=e+120|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+24>>2]),n=e+124|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+28>>2]),n=e+128|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+32>>2]),n=e+132|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+36>>2]),n=e+136|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+40>>2]),n=e+140|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+44>>2]),n=e+144|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+48>>2]),n=e+148|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+52>>2]),n=e+152|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+56>>2]),n=e+156|0,Kr[n>>2]=(0|Kr[n>>2])-(0|Kr[h+60>>2]),n=e+16|0,Kr[n>>2]=0,_=e+20|0,Kr[_>>2]=Zr[C>>0];r:do{if(S){do{if(!t)break r;F=t,t=t+-1|0}while(!(0|Kr[D+(F<<2)>>2]));if(Kr[n>>2]=Kr[e+28+(t<<2)>>2],t=N+1|0,Kr[_>>2]=t,t>>>0<=o>>>0){for(;;){if(0|Kr[D+(t<<2)>>2])break;if((t=t+1|0)>>>0>o>>>0)break r}Kr[_>>2]=t}}}while(0);Kr[e+92>>2]=-1,Kr[e+160>>2]=1048575,Kr[e+12>>2]=32-(0|Kr[I>>2]),t=1}}while(0);return D=t,_i=m,0|D}function u(e,r,i,t,n,_,a,o){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0,a|=0,o|=0;var E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,O=0,C=0,P=0,h=0,L=0,b=0,U=0,F=0,D=0,m=0,B=0,p=0,v=0,k=0,y=0,g=0,w=0,G=0,H=0,X=0,V=0,Y=0,x=0,K=0,W=0,Z=0,z=0,j=0,J=0,Q=0,q=0,$=0,ee=0,re=0,ie=0,te=0,ne=0;if(ie=_i,_i=_i+656|0,ee=ie+112|0,q=ie+96|0,Q=ie+80|0,J=ie+64|0,j=ie+48|0,re=ie+32|0,$=ie+16|0,z=ie,W=ie+144|0,Z=ie+128|0,y=e+240|0,g=0|Kr[y>>2],w=e+256|0,G=0|Kr[w>>2],K=0|Xr[17+(0|Kr[e+88>>2])>>0],H=255&K,X=t>>>2,!(K<<24>>24))return _i=ie,1;V=0==(0|o),Y=a+-1|0,x=Y<<4,K=o+-1|0,D=0!=(1&_|0),m=t<<1,B=e+92|0,p=e+116|0,v=e+140|0,k=e+236|0,F=0!=(1&n|0),U=e+188|0,P=e+252|0,h=X+1|0,L=X+2|0,b=X+3|0,C=0,_=0,i=0,n=1;do{if(!V)for(N=0|Kr[r+(C<<2)>>2],O=0;;){if(M=1&O,u=0==(0|M),d=(M<<5^32)-16|0,M=(M<<1^2)-1|0,s=u?a:-1,E=u?0:Y,e=(0|O)==(0|K),S=D&e,(0|E)!=(0|s))for(R=D&e^1,A=u?N:N+x|0;;){1==(0|n)&&(n=512|I(B,p)),c=7&n,n>>>=3,u=0|Zr[1539+c>>0],e=0;do{f=(0|I(B,v))+i|0,T=f-g|0,l=T>>31,i=l&f|T&~l,(0|Kr[y>>2])>>>0<=i>>>0&&(Kr[z>>2]=866,Kr[z+4>>2]=910,Kr[z+8>>2]=1497,He(W,812,z),le(W)),Kr[Z+(e<<2)>>2]=Kr[(0|Kr[k>>2])+(i<<2)>>2],e=e+1|0}while(e>>>0<u>>>0);if(l=F&(0|E)==(0|Y),S|l){T=0;do{e=A+(0|Ti(T,t))|0,f=0==(0|T)|R,u=T<<1,ne=(0|I(B,U))+_|0,te=ne-G|0,_=te>>31,_=_&ne|te&~_;do{if(l){if(!f){te=(0|I(B,U))+_|0,ne=te-G|0,_=ne>>31,_=_&te|ne&~_;break}Kr[e>>2]=Kr[Z+((0|Zr[1547+(c<<2)+u>>0])<<2)>>2],(0|Kr[w>>2])>>>0<=_>>>0&&(Kr[q>>2]=866,Kr[q+4>>2]=910,Kr[q+8>>2]=1497,He(W,812,q),le(W)),Kr[e+4>>2]=Kr[(0|Kr[P>>2])+(_<<2)>>2],te=(0|I(B,U))+_|0,ne=te-G|0,_=ne>>31,_=_&te|ne&~_}else f&&(Kr[e>>2]=Kr[Z+((0|Zr[1547+(c<<2)+u>>0])<<2)>>2],(0|Kr[w>>2])>>>0<=_>>>0&&(Kr[Q>>2]=866,Kr[Q+4>>2]=910,Kr[Q+8>>2]=1497,He(W,812,Q),le(W)),Kr[e+4>>2]=Kr[(0|Kr[P>>2])+(_<<2)>>2]),e=e+8|0,te=(0|I(B,U))+_|0,ne=te-G|0,_=ne>>31,_=_&te|ne&~_,f&&(Kr[e>>2]=Kr[Z+((0|Zr[1547+(c<<2)+(1|u)>>0])<<2)>>2],(0|Kr[w>>2])>>>0<=_>>>0&&(Kr[ee>>2]=866,Kr[ee+4>>2]=910,Kr[ee+8>>2]=1497,He(W,812,ee),le(W)),Kr[e+4>>2]=Kr[(0|Kr[P>>2])+(_<<2)>>2])}while(0);T=T+1|0}while(2!=(0|T))}else Kr[A>>2]=Kr[Z+((0|Zr[1547+(c<<2)>>0])<<2)>>2],te=(0|I(B,U))+_|0,ne=te-G|0,_=ne>>31,_=_&te|ne&~_,(0|Kr[w>>2])>>>0<=_>>>0&&(Kr[$>>2]=866,Kr[$+4>>2]=910,Kr[$+8>>2]=1497,He(W,812,$),le(W)),Kr[A+4>>2]=Kr[(0|Kr[P>>2])+(_<<2)>>2],Kr[A+8>>2]=Kr[Z+((0|Zr[1547+(c<<2)+1>>0])<<2)>>2],te=(0|I(B,U))+_|0,ne=te-G|0,_=ne>>31,_=_&te|ne&~_,(0|Kr[w>>2])>>>0<=_>>>0&&(Kr[re>>2]=866,Kr[re+4>>2]=910,Kr[re+8>>2]=1497,He(W,812,re),le(W)),Kr[A+12>>2]=Kr[(0|Kr[P>>2])+(_<<2)>>2],Kr[A+(X<<2)>>2]=Kr[Z+((0|Zr[1547+(c<<2)+2>>0])<<2)>>2],te=(0|I(B,U))+_|0,ne=te-G|0,_=ne>>31,_=_&te|ne&~_,
(0|Kr[w>>2])>>>0<=_>>>0&&(Kr[j>>2]=866,Kr[j+4>>2]=910,Kr[j+8>>2]=1497,He(W,812,j),le(W)),Kr[A+(h<<2)>>2]=Kr[(0|Kr[P>>2])+(_<<2)>>2],Kr[A+(L<<2)>>2]=Kr[Z+((0|Zr[1547+(c<<2)+3>>0])<<2)>>2],te=(0|I(B,U))+_|0,ne=te-G|0,_=ne>>31,_=_&te|ne&~_,(0|Kr[w>>2])>>>0<=_>>>0&&(Kr[J>>2]=866,Kr[J+4>>2]=910,Kr[J+8>>2]=1497,He(W,812,J),le(W)),Kr[A+(b<<2)>>2]=Kr[(0|Kr[P>>2])+(_<<2)>>2];if((0|(E=M+E|0))==(0|s))break;A=A+d|0}if((0|(O=O+1|0))==(0|o))break;N=N+m|0}C=C+1|0}while((0|C)!=(0|H));return _i=ie,1}function f(e,r,i,t,n,_,a,o){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0,a|=0,o|=0;var E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,O=0,C=0,P=0,h=0,L=0,b=0,U=0,F=0,D=0,m=0,B=0,p=0,v=0,k=0,y=0,g=0,w=0,G=0,H=0,X=0,V=0,Y=0,x=0,K=0,W=0,Z=0,z=0,j=0,J=0,Q=0,q=0,$=0,ee=0,re=0,ie=0,te=0,ne=0,_e=0,ae=0;if(ae=_i,_i=_i+640|0,te=ae+80|0,ie=ae+64|0,re=ae+48|0,_e=ae+32|0,ne=ae+16|0,ee=ae,q=ae+128|0,$=ae+112|0,g=ae+96|0,w=e+272|0,G=0|Kr[w>>2],Q=0|Kr[e+88>>2],H=(0|Zr[Q+63>>0])<<8|0|Zr[Q+64>>0],Q=0|Xr[Q+17>>0],X=255&Q,!(Q<<24>>24))return _i=ae,1;V=0==(0|o),Y=a+-1|0,x=Y<<5,K=o+-1|0,W=t<<1,Z=e+92|0,z=e+116|0,j=e+164|0,J=e+268|0,Q=e+212|0,y=0==(1&n|0),k=0==(1&_|0),v=e+288|0,p=e+284|0,B=0,e=0,_=0,n=0,i=0,E=1;do{if(!V)for(D=0|Kr[r+(B<<2)>>2],m=0;;){if(F=1&m,f=0==(0|F),U=(F<<6^64)-32|0,F=(F<<1^2)-1|0,L=f?a:-1,(0|(u=f?0:Y))!=(0|L))for(b=k|(0|m)!=(0|K),h=f?D:D+x|0;;){1==(0|E)&&(E=512|I(Z,z)),P=7&E,E>>>=3,T=0|Zr[1539+P>>0],f=0;do{N=(0|I(Z,j))+i|0,O=N-G|0,C=O>>31,i=C&N|O&~C,(0|Kr[w>>2])>>>0<=i>>>0&&(Kr[ee>>2]=866,Kr[ee+4>>2]=910,Kr[ee+8>>2]=1497,He(q,812,ee),le(q)),Kr[$+(f<<2)>>2]=jr[(0|Kr[J>>2])+(i<<1)>>1],f=f+1|0}while(f>>>0<T>>>0);f=0;do{N=(0|I(Z,j))+_|0,O=N-G|0,C=O>>31,_=C&N|O&~C,(0|Kr[w>>2])>>>0<=_>>>0&&(Kr[ne>>2]=866,Kr[ne+4>>2]=910,Kr[ne+8>>2]=1497,He(q,812,ne),le(q)),Kr[g+(f<<2)>>2]=jr[(0|Kr[J>>2])+(_<<1)>>1],f=f+1|0}while(f>>>0<T>>>0);for(C=y|(0|u)!=(0|Y),N=0,O=h;;){if(d=b|0==(0|N),M=N<<1,C)for(R=0,s=O;;){if(S=(0|I(Z,Q))+n|0,A=S-H|0,n=A>>31,n=n&S|A&~n,A=(0|I(Z,Q))+e|0,S=A-H|0,e=S>>31,e=e&A|S&~e,d&&(A=0|Zr[R+M+(1547+(P<<2))>>0],T=3*n|0,f=0|Kr[v>>2],f>>>0<=T>>>0&&(Kr[_e>>2]=866,Kr[_e+4>>2]=910,Kr[_e+8>>2]=1497,He(q,812,_e),le(q),f=0|Kr[v>>2]),l=0|Kr[p>>2],T=l+(T<<1)|0,c=3*e|0,f>>>0>c>>>0?f=l:(Kr[re>>2]=866,Kr[re+4>>2]=910,Kr[re+8>>2]=1497,He(q,812,re),le(q),f=0|Kr[p>>2]),S=f+(c<<1)|0,Kr[s>>2]=(0|jr[T>>1])<<16|Kr[$+(A<<2)>>2],Kr[s+4>>2]=(0|jr[T+4>>1])<<16|0|jr[T+2>>1],Kr[s+8>>2]=(0|jr[S>>1])<<16|Kr[g+(A<<2)>>2],Kr[s+12>>2]=(0|jr[S+4>>1])<<16|0|jr[S+2>>1]),2==(0|(R=R+1|0)))break;s=s+16|0}else for(S=1^d,d=1547+(P<<2)+M|0,R=0,s=O;;){if(M=(0|I(Z,Q))+n|0,A=M-H|0,n=A>>31,n=n&M|A&~n,A=(0|I(Z,Q))+e|0,M=A-H|0,e=M>>31,e=e&A|M&~e,0!=(0|R)|S||(A=0|Zr[d>>0],T=3*n|0,f=0|Kr[v>>2],f>>>0<=T>>>0&&(Kr[ie>>2]=866,Kr[ie+4>>2]=910,Kr[ie+8>>2]=1497,He(q,812,ie),le(q),f=0|Kr[v>>2]),l=0|Kr[p>>2],T=l+(T<<1)|0,c=3*e|0,f>>>0>c>>>0?f=l:(Kr[te>>2]=866,Kr[te+4>>2]=910,Kr[te+8>>2]=1497,He(q,812,te),le(q),f=0|Kr[p>>2]),M=f+(c<<1)|0,Kr[s>>2]=(0|jr[T>>1])<<16|Kr[$+(A<<2)>>2],Kr[s+4>>2]=(0|jr[T+4>>1])<<16|0|jr[T+2>>1],Kr[s+8>>2]=(0|jr[M>>1])<<16|Kr[g+(A<<2)>>2],Kr[s+12>>2]=(0|jr[M+4>>1])<<16|0|jr[M+2>>1]),2==(0|(R=R+1|0)))break;s=s+16|0}if(2==(0|(N=N+1|0)))break;O=O+t|0}if((0|(u=F+u|0))==(0|L))break;h=h+U|0}if((0|(m=m+1|0))==(0|o))break;D=D+W|0}B=B+1|0}while((0|B)!=(0|X));return _i=ae,1}function T(e){e|=0;var r=0,i=0,t=0,n=0,_=0,a=0,o=0,E=0;if(e){i=e+-8|0,n=0|Kr[1148],e=0|Kr[e+-4>>2],r=-8&e,E=i+r|0;do{if(1&e)o=i,a=i;else{if(t=0|Kr[i>>2],!(3&e))return;if(a=i+(0-t)|0,_=t+r|0,a>>>0<n>>>0)return;if((0|a)==(0|Kr[1149])){if(e=E+4|0,3!=(3&(r=0|Kr[e>>2])|0)){o=a,r=_;break}return Kr[1146]=_,Kr[e>>2]=-2&r,Kr[a+4>>2]=1|_,void(Kr[a+_>>2]=_)}if(i=t>>>3,t>>>0<256){if(e=0|Kr[a+8>>2],(0|(r=0|Kr[a+12>>2]))==(0|e)){Kr[1144]=Kr[1144]&~(1<<i),o=a,r=_;break}Kr[e+12>>2]=r,Kr[r+8>>2]=e,o=a,r=_;break}n=0|Kr[a+24>>2],e=0|Kr[a+12>>2];do{if((0|e)==(0|a)){if(i=a+16|0,r=i+4|0,!(e=0|Kr[r>>2])){if(!(e=0|Kr[i>>2])){e=0;break}r=i}for(;;)if(i=e+20|0,0|(t=0|Kr[i>>2]))e=t,r=i;else{if(i=e+16|0,!(t=0|Kr[i>>2]))break;e=t,r=i}Kr[r>>2]=0}else o=0|Kr[a+8>>2],Kr[o+12>>2]=e,Kr[e+8>>2]=o}while(0);if(n){if(r=0|Kr[a+28>>2],i=4880+(r<<2)|0,(0|a)==(0|Kr[i>>2])){if(Kr[i>>2]=e,!e){Kr[1145]=Kr[1145]&~(1<<r),o=a,r=_;break}}else if(Kr[n+16+(((0|Kr[n+16>>2])!=(0|a)&1)<<2)>>2]=e,!e){o=a,r=_;break}Kr[e+24>>2]=n,r=a+16|0,i=0|Kr[r>>2],0|i&&(Kr[e+16>>2]=i,Kr[i+24>>2]=e),r=0|Kr[r+4>>2],r?(Kr[e+20>>2]=r,Kr[r+24>>2]=e,o=a,r=_):(o=a,r=_)}else o=a,r=_}}while(0);if(!(a>>>0>=E>>>0)&&(e=E+4|0,1&(t=0|Kr[e>>2]))){if(2&t)Kr[e>>2]=-2&t,Kr[o+4>>2]=1|r,Kr[a+r>>2]=r,n=r;else{if(e=0|Kr[1149],(0|E)==(0|Kr[1150])){if(E=(0|Kr[1147])+r|0,Kr[1147]=E,Kr[1150]=o,Kr[o+4>>2]=1|E,(0|o)!=(0|e))return;return Kr[1149]=0,void(Kr[1146]=0)}if((0|E)==(0|e))return E=(0|Kr[1146])+r|0,Kr[1146]=E,Kr[1149]=a,Kr[o+4>>2]=1|E,void(Kr[a+E>>2]=E);n=(-8&t)+r|0,i=t>>>3;do{if(t>>>0<256){if(r=0|Kr[E+8>>2],(0|(e=0|Kr[E+12>>2]))==(0|r)){Kr[1144]=Kr[1144]&~(1<<i);break}Kr[r+12>>2]=e,Kr[e+8>>2]=r;break}_=0|Kr[E+24>>2],e=0|Kr[E+12>>2];do{if((0|e)==(0|E)){if(i=E+16|0,r=i+4|0,!(e=0|Kr[r>>2])){if(!(e=0|Kr[i>>2])){i=0;break}r=i}for(;;)if(i=e+20|0,0|(t=0|Kr[i>>2]))e=t,r=i;else{if(i=e+16|0,!(t=0|Kr[i>>2]))break;e=t,r=i}Kr[r>>2]=0,i=e}else i=0|Kr[E+8>>2],Kr[i+12>>2]=e,Kr[e+8>>2]=i,i=e}while(0);if(0|_){if(e=0|Kr[E+28>>2],r=4880+(e<<2)|0,(0|E)==(0|Kr[r>>2])){if(Kr[r>>2]=i,!i){Kr[1145]=Kr[1145]&~(1<<e);break}}else if(Kr[_+16+(((0|Kr[_+16>>2])!=(0|E)&1)<<2)>>2]=i,!i)break;Kr[i+24>>2]=_,e=E+16|0,r=0|Kr[e>>2],0|r&&(Kr[i+16>>2]=r,Kr[r+24>>2]=i),e=0|Kr[e+4>>2],0|e&&(Kr[i+20>>2]=e,Kr[e+24>>2]=i)}}while(0);if(Kr[o+4>>2]=1|n,Kr[a+n>>2]=n,(0|o)==(0|Kr[1149]))return void(Kr[1146]=n)}if(e=n>>>3,n>>>0<256)return i=4616+(e<<1<<2)|0,r=0|Kr[1144],e=1<<e,r&e?(r=i+8|0,e=0|Kr[r>>2]):(Kr[1144]=r|e,e=i,r=i+8|0),Kr[r>>2]=o,Kr[e+12>>2]=o,Kr[o+8>>2]=e,void(Kr[o+12>>2]=i);e=n>>>8,e?n>>>0>16777215?e=31:(a=(e+1048320|0)>>>16&8,E=e<<a,_=(E+520192|0)>>>16&4,E<<=_,e=(E+245760|0)>>>16&2,e=14-(_|a|e)+(E<<e>>>15)|0,e=n>>>(e+7|0)&1|e<<1):e=0,t=4880+(e<<2)|0,Kr[o+28>>2]=e,Kr[o+20>>2]=0,Kr[o+16>>2]=0,r=0|Kr[1145],i=1<<e;do{if(r&i){for(r=n<<(31==(0|e)?0:25-(e>>>1)|0),i=0|Kr[t>>2];;){if((-8&Kr[i+4>>2]|0)==(0|n)){e=73;break}if(t=i+16+(r>>>31<<2)|0,!(e=0|Kr[t>>2])){e=72;break}r<<=1,i=e}if(72==(0|e)){Kr[t>>2]=o,Kr[o+24>>2]=i,Kr[o+12>>2]=o,Kr[o+8>>2]=o;break}if(73==(0|e)){a=i+8|0,E=0|Kr[a>>2],Kr[E+12>>2]=o,Kr[a>>2]=o,Kr[o+8>>2]=E,Kr[o+12>>2]=i,Kr[o+24>>2]=0;break}}else Kr[1145]=r|i,Kr[t>>2]=o,Kr[o+24>>2]=t,Kr[o+12>>2]=o,Kr[o+8>>2]=o}while(0);if(E=(0|Kr[1152])-1|0,Kr[1152]=E,!E){for(e=5032;;){if(!(e=0|Kr[e>>2]))break;e=e+8|0}Kr[1152]=-1}}}}function l(e,r,i,t,n,_,a,o){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0,a|=0,o|=0;var E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,O=0,C=0,P=0,h=0,L=0,b=0,U=0,F=0,D=0,m=0,B=0,p=0,v=0,k=0,y=0,g=0,w=0,G=0,H=0,X=0,V=0,Y=0,x=0,K=0,W=0,Z=0,z=0,j=0,J=0,Q=0,q=0,$=0,ee=0,re=0,ie=0,te=0,ne=0,_e=0,ae=0,oe=0,Ee=0,ue=0,fe=0,Te=0;if(Te=_i,_i=_i+640|0,Ee=Te+80|0,oe=Te+64|0,ae=Te+48|0,fe=Te+32|0,ue=Te+16|0,_e=Te,te=Te+128|0,ne=Te+112|0,k=Te+96|0,y=e+240|0,g=0|Kr[y>>2],w=e+256|0,G=0|Kr[w>>2],H=e+272|0,X=0|Kr[H>>2],ie=0|Kr[e+88>>2],V=(0|Zr[ie+63>>0])<<8|0|Zr[ie+64>>0],ie=0|Xr[ie+17>>0],Y=255&ie,!(ie<<24>>24))return _i=Te,1;x=0==(0|o),K=a+-1|0,W=K<<5,Z=o+-1|0,z=t<<1,j=e+92|0,J=e+116|0,Q=e+164|0,q=e+268|0,$=e+140|0,ee=e+236|0,re=e+212|0,ie=e+188|0,v=0==(1&n|0),p=0==(1&_|0),m=e+288|0,B=e+284|0,D=e+252|0,F=0,e=0,_=0,n=0,i=0,E=1;do{if(!x)for(b=0|Kr[r+(F<<2)>>2],U=0;;){if(L=1&U,f=0==(0|L),h=(L<<6^64)-32|0,L=(L<<1^2)-1|0,C=f?a:-1,(0|(u=f?0:K))!=(0|C))for(P=p|(0|U)!=(0|Z),O=f?b:b+W|0;;){1==(0|E)&&(E=512|I(j,J)),N=7&E,E>>>=3,T=0|Zr[1539+N>>0],f=0;do{d=(0|I(j,Q))+_|0,M=d-X|0,S=M>>31,_=S&d|M&~S,(0|Kr[H>>2])>>>0<=_>>>0&&(Kr[_e>>2]=866,Kr[_e+4>>2]=910,Kr[_e+8>>2]=1497,He(te,812,_e),le(te)),Kr[k+(f<<2)>>2]=jr[(0|Kr[q>>2])+(_<<1)>>1],f=f+1|0}while(f>>>0<T>>>0);f=0;do{d=(0|I(j,$))+i|0,M=d-g|0,S=M>>31,i=S&d|M&~S,(0|Kr[y>>2])>>>0<=i>>>0&&(Kr[ue>>2]=866,Kr[ue+4>>2]=910,Kr[ue+8>>2]=1497,He(te,812,ue),le(te)),Kr[ne+(f<<2)>>2]=Kr[(0|Kr[ee>>2])+(i<<2)>>2],f=f+1|0}while(f>>>0<T>>>0);for(S=v|(0|u)!=(0|K),d=0,M=O;;){if(A=P|0==(0|d),R=d<<1,S)for(l=0,c=M;;){if(s=(0|I(j,re))+e|0,T=s-V|0,e=T>>31,e=e&s|T&~e,T=(0|I(j,ie))+n|0,s=T-G|0,n=s>>31,n=n&T|s&~n,A&&(f=0|Zr[l+R+(1547+(N<<2))>>0],T=3*e|0,(0|Kr[m>>2])>>>0<=T>>>0&&(Kr[fe>>2]=866,Kr[fe+4>>2]=910,Kr[fe+8>>2]=1497,He(te,812,fe),le(te)),s=(0|Kr[B>>2])+(T<<1)|0,Kr[c>>2]=(0|jr[s>>1])<<16|Kr[k+(f<<2)>>2],Kr[c+4>>2]=(0|jr[s+4>>1])<<16|0|jr[s+2>>1],Kr[c+8>>2]=Kr[ne+(f<<2)>>2],(0|Kr[w>>2])>>>0<=n>>>0&&(Kr[ae>>2]=866,Kr[ae+4>>2]=910,Kr[ae+8>>2]=1497,He(te,812,ae),le(te)),Kr[c+12>>2]=Kr[(0|Kr[D>>2])+(n<<2)>>2]),2==(0|(l=l+1|0)))break;c=c+16|0}else for(s=1^A,A=1547+(N<<2)+R|0,l=0,c=M;;){if(R=(0|I(j,re))+e|0,T=R-V|0,e=T>>31,e=e&R|T&~e,T=(0|I(j,ie))+n|0,R=T-G|0,n=R>>31,n=n&T|R&~n,0!=(0|l)|s||(f=0|Zr[A>>0],T=3*e|0,(0|Kr[m>>2])>>>0<=T>>>0&&(Kr[oe>>2]=866,Kr[oe+4>>2]=910,Kr[oe+8>>2]=1497,He(te,812,oe),le(te)),R=(0|Kr[B>>2])+(T<<1)|0,Kr[c>>2]=(0|jr[R>>1])<<16|Kr[k+(f<<2)>>2],Kr[c+4>>2]=(0|jr[R+4>>1])<<16|0|jr[R+2>>1],Kr[c+8>>2]=Kr[ne+(f<<2)>>2],(0|Kr[w>>2])>>>0<=n>>>0&&(Kr[Ee>>2]=866,Kr[Ee+4>>2]=910,Kr[Ee+8>>2]=1497,He(te,812,Ee),le(te)),Kr[c+12>>2]=Kr[(0|Kr[D>>2])+(n<<2)>>2]),2==(0|(l=l+1|0)))break;c=c+16|0}if(2==(0|(d=d+1|0)))break;M=M+t|0}if((0|(u=L+u|0))==(0|C))break;O=O+h|0}if((0|(U=U+1|0))==(0|o))break;b=b+z|0}F=F+1|0}while((0|F)!=(0|Y));return _i=Te,1}function c(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0,a=0,o=0,E=0;E=e+r|0,i=0|Kr[e+4>>2];do{if(1&i)o=e,i=r;else{if(t=0|Kr[e>>2],!(3&i))return;if(_=e+(0-t)|0,a=t+r|0,(0|_)==(0|Kr[1149])){if(e=E+4|0,3!=(3&(i=0|Kr[e>>2])|0)){o=_,i=a;break}return Kr[1146]=a,Kr[e>>2]=-2&i,Kr[_+4>>2]=1|a,void(Kr[_+a>>2]=a)}if(r=t>>>3,t>>>0<256){if(e=0|Kr[_+8>>2],(0|(i=0|Kr[_+12>>2]))==(0|e)){Kr[1144]=Kr[1144]&~(1<<r),o=_,i=a;break}Kr[e+12>>2]=i,Kr[i+8>>2]=e,o=_,i=a;break}n=0|Kr[_+24>>2],e=0|Kr[_+12>>2];do{if((0|e)==(0|_)){if(r=_+16|0,i=r+4|0,!(e=0|Kr[i>>2])){if(!(e=0|Kr[r>>2])){e=0;break}i=r}for(;;)if(r=e+20|0,0|(t=0|Kr[r>>2]))e=t,i=r;else{if(r=e+16|0,!(t=0|Kr[r>>2]))break;e=t,i=r}Kr[i>>2]=0}else o=0|Kr[_+8>>2],Kr[o+12>>2]=e,Kr[e+8>>2]=o}while(0);if(n){if(i=0|Kr[_+28>>2],r=4880+(i<<2)|0,(0|_)==(0|Kr[r>>2])){if(Kr[r>>2]=e,!e){Kr[1145]=Kr[1145]&~(1<<i),o=_,i=a;break}}else if(Kr[n+16+(((0|Kr[n+16>>2])!=(0|_)&1)<<2)>>2]=e,!e){o=_,i=a;break}Kr[e+24>>2]=n,i=_+16|0,r=0|Kr[i>>2],0|r&&(Kr[e+16>>2]=r,Kr[r+24>>2]=e),i=0|Kr[i+4>>2],i?(Kr[e+20>>2]=i,Kr[i+24>>2]=e,o=_,i=a):(o=_,i=a)}else o=_,i=a}}while(0);if(e=E+4|0,2&(t=0|Kr[e>>2]))Kr[e>>2]=-2&t,Kr[o+4>>2]=1|i,Kr[o+i>>2]=i;else{if(e=0|Kr[1149],(0|E)==(0|Kr[1150])){if(E=(0|Kr[1147])+i|0,Kr[1147]=E,Kr[1150]=o,Kr[o+4>>2]=1|E,(0|o)!=(0|e))return;return Kr[1149]=0,void(Kr[1146]=0)}if((0|E)==(0|e))return E=(0|Kr[1146])+i|0,Kr[1146]=E,Kr[1149]=o,Kr[o+4>>2]=1|E,void(Kr[o+E>>2]=E);_=(-8&t)+i|0,r=t>>>3;do{if(t>>>0<256){if(i=0|Kr[E+8>>2],(0|(e=0|Kr[E+12>>2]))==(0|i)){Kr[1144]=Kr[1144]&~(1<<r);break}Kr[i+12>>2]=e,Kr[e+8>>2]=i;break}n=0|Kr[E+24>>2],e=0|Kr[E+12>>2];do{if((0|e)==(0|E)){if(r=E+16|0,i=r+4|0,!(e=0|Kr[i>>2])){if(!(e=0|Kr[r>>2])){r=0;break}i=r}for(;;)if(r=e+20|0,0|(t=0|Kr[r>>2]))e=t,i=r;else{if(r=e+16|0,!(t=0|Kr[r>>2]))break;e=t,i=r}Kr[i>>2]=0,r=e}else r=0|Kr[E+8>>2],Kr[r+12>>2]=e,Kr[e+8>>2]=r,r=e}while(0);if(0|n){if(e=0|Kr[E+28>>2],i=4880+(e<<2)|0,(0|E)==(0|Kr[i>>2])){if(Kr[i>>2]=r,!r){Kr[1145]=Kr[1145]&~(1<<e);break}}else if(Kr[n+16+(((0|Kr[n+16>>2])!=(0|E)&1)<<2)>>2]=r,!r)break;Kr[r+24>>2]=n,e=E+16|0,i=0|Kr[e>>2],0|i&&(Kr[r+16>>2]=i,Kr[i+24>>2]=r),e=0|Kr[e+4>>2],0|e&&(Kr[r+20>>2]=e,Kr[e+24>>2]=r)}}while(0);if(Kr[o+4>>2]=1|_,Kr[o+_>>2]=_,(0|o)==(0|Kr[1149]))return void(Kr[1146]=_);i=_}if(e=i>>>3,i>>>0<256)return r=4616+(e<<1<<2)|0,i=0|Kr[1144],e=1<<e,i&e?(i=r+8|0,e=0|Kr[i>>2]):(Kr[1144]=i|e,e=r,i=r+8|0),Kr[i>>2]=o,Kr[e+12>>2]=o,Kr[o+8>>2]=e,void(Kr[o+12>>2]=r);if(e=i>>>8,e?i>>>0>16777215?e=31:(a=(e+1048320|0)>>>16&8,E=e<<a,_=(E+520192|0)>>>16&4,E<<=_,e=(E+245760|0)>>>16&2,e=14-(_|a|e)+(E<<e>>>15)|0,e=i>>>(e+7|0)&1|e<<1):e=0,n=4880+(e<<2)|0,Kr[o+28>>2]=e,Kr[o+20>>2]=0,Kr[o+16>>2]=0,r=0|Kr[1145],t=1<<e,!(r&t))return Kr[1145]=r|t,Kr[n>>2]=o,Kr[o+24>>2]=n,Kr[o+12>>2]=o,void(Kr[o+8>>2]=o);for(r=i<<(31==(0|e)?0:25-(e>>>1)|0),t=0|Kr[n>>2];;){if((-8&Kr[t+4>>2]|0)==(0|i)){e=69;break}if(n=t+16+(r>>>31<<2)|0,!(e=0|Kr[n>>2])){e=68;break}r<<=1,t=e}return 68==(0|e)?(Kr[n>>2]=o,Kr[o+24>>2]=t,Kr[o+12>>2]=o,void(Kr[o+8>>2]=o)):69==(0|e)?(a=t+8|0,E=0|Kr[a>>2],Kr[E+12>>2]=o,Kr[a>>2]=o,Kr[o+8>>2]=E,Kr[o+12>>2]=t,void(Kr[o+24>>2]=0)):void 0}function A(e){e|=0;var r=0,i=0,t=0,n=0,_=0,a=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,O=0,C=0,P=0,L=0,b=0,U=0,F=0,D=0,m=0,B=0,p=0,v=0,k=0,y=0,g=0,w=0,G=0,H=0,X=0,V=0,Y=0,x=0;if(V=_i,_i=_i+2416|0,a=V,_=V+1904|0,X=V+1880|0,w=V+980|0,G=V+80|0,H=V+16|0,i=0|Kr[e+88>>2],y=(0|Zr[i+63>>0])<<8|0|Zr[i+64>>0],g=e+92|0,r=(0|Kr[e+4>>2])+((0|Zr[i+58>>0])<<8|(0|Zr[i+57>>0])<<16|0|Zr[i+59>>0])|0,!(i=(0|Zr[i+61>>0])<<8|(0|Zr[i+60>>0])<<16|0|Zr[i+62>>0]))return X=0,_i=V,0|X;if(Kr[g>>2]=r,Kr[e+96>>2]=r,Kr[e+104>>2]=i,Kr[e+100>>2]=r+i,Kr[e+108>>2]=0,Kr[e+112>>2]=0,Kr[X+20>>2]=0,Kr[X>>2]=0,Kr[X+4>>2]=0,Kr[X+8>>2]=0,Kr[X+12>>2]=0,Xr[X+16>>0]=0,0|o(g,X)){for(r=0,i=-7,t=-7;;){if(Kr[w+(r<<2)>>2]=t,Kr[G+(r<<2)>>2]=i,n=(0|t)>6,225==(0|(r=r+1|0)))break;i=(1&n)+i|0,t=n?-7:t+1|0}r=H,i=r+64|0;do{Kr[r>>2]=0,r=r+4|0}while((0|r)<(0|i));n=e+284|0,i=3*y|0,t=e+288|0,r=0|Kr[t>>2];e:do{if((0|r)==(0|i))E=13;else{if(r>>>0<=i>>>0){do{if((0|Kr[e+292>>2])>>>0<i>>>0){if(0|h(n,i,(r+1|0)==(0|i),2,0)){r=0|Kr[t>>2];break}Xr[e+296>>0]=1,r=0;break e}}while(0);ee((0|Kr[n>>2])+(r<<1)|0,0,i-r<<1|0)}Kr[t>>2]=i,E=13}}while(0);do{if(13==(0|E)){if(!y){Kr[a>>2]=866,Kr[a+4>>2]=910,Kr[a+8>>2]=1497,He(_,812,a),le(_),r=1;break}for(S=H+4|0,N=H+8|0,O=H+12|0,C=H+16|0,P=H+20|0,L=H+24|0,b=H+28|0,U=H+32|0,F=H+36|0,D=H+40|0,m=H+44|0,B=H+48|0,p=H+52|0,v=H+56|0,k=H+60|0,M=0,r=0|Kr[n>>2],i=0|Kr[H>>2],t=0|Kr[S>>2],n=0|Kr[N>>2],e=0|Kr[O>>2],_=0|Kr[C>>2],a=0|Kr[P>>2],E=0|Kr[L>>2],u=0|Kr[b>>2],f=0|Kr[U>>2],T=0|Kr[F>>2],l=0|Kr[D>>2],c=0|Kr[m>>2],A=0,R=0,s=0,d=0;;){if(x=0|I(g,X),i=i+(0|Kr[w+(x<<2)>>2])&7,t=t+(0|Kr[G+(x<<2)>>2])&7,x=0|I(g,X),n=n+(0|Kr[w+(x<<2)>>2])&7,e=e+(0|Kr[G+(x<<2)>>2])&7,x=0|I(g,X),_=_+(0|Kr[w+(x<<2)>>2])&7,a=a+(0|Kr[G+(x<<2)>>2])&7,x=0|I(g,X),E=E+(0|Kr[w+(x<<2)>>2])&7,u=u+(0|Kr[G+(x<<2)>>2])&7,x=0|I(g,X),f=f+(0|Kr[w+(x<<2)>>2])&7,T=T+(0|Kr[G+(x<<2)>>2])&7,x=0|I(g,X),l=l+(0|Kr[w+(x<<2)>>2])&7,c=c+(0|Kr[G+(x<<2)>>2])&7,x=0|I(g,X),A=A+(0|Kr[w+(x<<2)>>2])&7,R=R+(0|Kr[G+(x<<2)>>2])&7,x=0|I(g,X),s=s+(0|Kr[w+(x<<2)>>2])&7,d=d+(0|Kr[G+(x<<2)>>2])&7,x=0|Zr[1445+a>>0],Yr[r>>1]=(0|Zr[1445+t>>0])<<3|0|Zr[1445+i>>0]|(0|Zr[1445+n>>0])<<6|(0|Zr[1445+e>>0])<<9|(0|Zr[1445+_>>0])<<12|x<<15,Y=0|Zr[1445+l>>0],Yr[r+2>>1]=(0|Zr[1445+E>>0])<<2|x>>>1|(0|Zr[1445+u>>0])<<5|(0|Zr[1445+f>>0])<<8|(0|Zr[1445+T>>0])<<11|Y<<14,Yr[r+4>>1]=(0|Zr[1445+c>>0])<<1|Y>>>2|(0|Zr[1445+A>>0])<<4|(0|Zr[1445+R>>0])<<7|(0|Zr[1445+s>>0])<<10|(0|Zr[1445+d>>0])<<13,(M=M+1|0)>>>0>=y>>>0)break;r=r+6|0}Kr[H>>2]=i,Kr[S>>2]=t,Kr[N>>2]=n,Kr[O>>2]=e,Kr[C>>2]=_,Kr[P>>2]=a,Kr[L>>2]=E,Kr[b>>2]=u,Kr[U>>2]=f,Kr[F>>2]=T,Kr[D>>2]=l,Kr[m>>2]=c,Kr[B>>2]=A,Kr[p>>2]=R,Kr[v>>2]=s,Kr[k>>2]=d,r=1}}while(0)}else r=0;return z(X),x=r,_i=V,0|x}function R(e){e|=0;var r=0,i=0,t=0,n=0,_=0,a=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,O=0,C=0,P=0,L=0,b=0,U=0,F=0,D=0,m=0,B=0,p=0,v=0,k=0,y=0,g=0,w=0,G=0,H=0,X=0,V=0;if(U=_i,_i=_i+1008|0,a=U,_=U+496|0,b=U+472|0,C=U+276|0,P=U+80|0,L=U+16|0,i=0|Kr[e+88>>2],N=(0|Zr[i+47>>0])<<8|0|Zr[i+48>>0],O=e+92|0,r=(0|Kr[e+4>>2])+((0|Zr[i+42>>0])<<8|(0|Zr[i+41>>0])<<16|0|Zr[i+43>>0])|0,!(i=(0|Zr[i+45>>0])<<8|(0|Zr[i+44>>0])<<16|0|Zr[i+46>>0]))return b=0,_i=U,0|b;if(Kr[O>>2]=r,Kr[e+96>>2]=r,Kr[e+104>>2]=i,Kr[e+100>>2]=r+i,Kr[e+108>>2]=0,Kr[e+112>>2]=0,Kr[b+20>>2]=0,Kr[b>>2]=0,Kr[b+4>>2]=0,Kr[b+8>>2]=0,Kr[b+12>>2]=0,Xr[b+16>>0]=0,0|o(O,b)){for(r=0,i=-3,t=-3;;){if(Kr[C+(r<<2)>>2]=t,Kr[P+(r<<2)>>2]=i,n=(0|t)>2,49==(0|(r=r+1|0)))break;i=(1&n)+i|0,t=n?-3:t+1|0}r=L,i=r+64|0;do{Kr[r>>2]=0,r=r+4|0}while((0|r)<(0|i));t=e+252|0,i=e+256|0,r=0|Kr[i>>2];e:do{if((0|r)==(0|N))E=13;else{if(r>>>0<=N>>>0){do{if((0|Kr[e+260>>2])>>>0<N>>>0){if(0|h(t,N,(r+1|0)==(0|N),4,0)){r=0|Kr[i>>2];break}Xr[e+264>>0]=1,r=0;break e}}while(0);ee((0|Kr[t>>2])+(r<<2)|0,0,N-r<<2|0)}Kr[i>>2]=N,E=13}}while(0);do{if(13==(0|E)){if(!N){Kr[a>>2]=866,Kr[a+4>>2]=910,Kr[a+8>>2]=1497,He(_,812,a),le(_),r=1;break}for(e=L+4|0,_=L+8|0,a=L+12|0,E=L+16|0,u=L+20|0,f=L+24|0,T=L+28|0,l=L+32|0,c=L+36|0,A=L+40|0,R=L+44|0,s=L+48|0,d=L+52|0,M=L+56|0,S=L+60|0,n=0,r=0|Kr[t>>2],i=0|Kr[e>>2],t=0|Kr[L>>2];;){if(X=0|I(O,b),t=t+(0|Kr[C+(X<<2)>>2])&3,i=i+(0|Kr[P+(X<<2)>>2])&3,X=0|I(O,b),V=(0|Kr[_>>2])+(0|Kr[C+(X<<2)>>2])&3,Kr[_>>2]=V,X=(0|Kr[a>>2])+(0|Kr[P+(X<<2)>>2])&3,Kr[a>>2]=X,G=0|I(O,b),H=(0|Kr[E>>2])+(0|Kr[C+(G<<2)>>2])&3,Kr[E>>2]=H,G=(0|Kr[u>>2])+(0|Kr[P+(G<<2)>>2])&3,Kr[u>>2]=G,g=0|I(O,b),w=(0|Kr[f>>2])+(0|Kr[C+(g<<2)>>2])&3,Kr[f>>2]=w,g=(0|Kr[T>>2])+(0|Kr[P+(g<<2)>>2])&3,Kr[T>>2]=g,k=0|I(O,b),y=(0|Kr[l>>2])+(0|Kr[C+(k<<2)>>2])&3,Kr[l>>2]=y,k=(0|Kr[c>>2])+(0|Kr[P+(k<<2)>>2])&3,Kr[c>>2]=k,p=0|I(O,b),v=(0|Kr[A>>2])+(0|Kr[C+(p<<2)>>2])&3,Kr[A>>2]=v,p=(0|Kr[R>>2])+(0|Kr[P+(p<<2)>>2])&3,Kr[R>>2]=p,m=0|I(O,b),B=(0|Kr[s>>2])+(0|Kr[C+(m<<2)>>2])&3,Kr[s>>2]=B,m=(0|Kr[d>>2])+(0|Kr[P+(m<<2)>>2])&3,Kr[d>>2]=m,F=0|I(O,b),D=(0|Kr[M>>2])+(0|Kr[C+(F<<2)>>2])&3,Kr[M>>2]=D,F=(0|Kr[S>>2])+(0|Kr[P+(F<<2)>>2])&3,Kr[S>>2]=F,Kr[r>>2]=(0|Zr[1441+i>>0])<<2|0|Zr[1441+t>>0]|(0|Zr[1441+V>>0])<<4|(0|Zr[1441+X>>0])<<6|(0|Zr[1441+H>>0])<<8|(0|Zr[1441+G>>0])<<10|(0|Zr[1441+w>>0])<<12|(0|Zr[1441+g>>0])<<14|(0|Zr[1441+y>>0])<<16|(0|Zr[1441+k>>0])<<18|(0|Zr[1441+v>>0])<<20|(0|Zr[1441+p>>0])<<22|(0|Zr[1441+B>>0])<<24|(0|Zr[1441+m>>0])<<26|(0|Zr[1441+D>>0])<<28|(0|Zr[1441+F>>0])<<30,(n=n+1|0)>>>0>=N>>>0)break;r=r+4|0}Kr[L>>2]=t,Kr[e>>2]=i,r=1}}while(0)}else r=0;return z(b),V=r,_i=U,0|V}function s(e,r,i,t,n,_,a,o){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0,a|=0,o|=0;var E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0,d=0,M=0,S=0,N=0,O=0,C=0,P=0,h=0,L=0,b=0,U=0,F=0,D=0,m=0,B=0,p=0,v=0,k=0,y=0,g=0,w=0,G=0,H=0,X=0,V=0,Y=0,x=0,K=0,W=0,Z=0,z=0,j=0,J=0;if(J=_i,_i=_i+592|0,Z=J+48|0,j=J+32|0,z=J+16|0,W=J,x=J+80|0,K=J+64|0,D=e+272|0,m=0|Kr[D>>2],Y=0|Kr[e+88>>2],B=(0|Zr[Y+63>>0])<<8|0|Zr[Y+64>>0],Y=0|Xr[Y+17>>0],p=255&Y,!(Y<<24>>24))return _i=J,1;v=0==(0|o),k=a+-1|0,y=k<<4,g=o+-1|0,w=t<<1,G=e+92|0,H=e+116|0,X=e+164|0,V=e+268|0,Y=e+212|0,F=0==(1&n|0),U=0==(1&_|0),b=e+288|0,L=e+284|0,h=0,n=0,i=0,_=1;do{if(!v)for(C=0|Kr[r+(h<<2)>>2],P=0;;){if(O=1&P,E=0==(0|O),N=(O<<5^32)-16|0,O=(O<<1^2)-1|0,M=E?a:-1,(0|(e=E?0:k))!=(0|M))for(S=U|(0|P)!=(0|g),d=E?C:C+y|0;;){1==(0|_)&&(_=512|I(G,H)),s=7&_,_>>>=3,u=0|Zr[1539+s>>0],E=0;do{c=(0|I(G,X))+i|0,A=c-m|0,R=A>>31,i=R&c|A&~R,(0|Kr[D>>2])>>>0<=i>>>0&&(Kr[W>>2]=866,Kr[W+4>>2]=910,Kr[W+8>>2]=1497,He(x,812,W),le(x)),Kr[K+(E<<2)>>2]=jr[(0|Kr[V>>2])+(i<<1)>>1],E=E+1|0}while(E>>>0<u>>>0);for(R=F|(0|e)!=(0|k),c=0,A=d;;){if(l=S|0==(0|c),u=c<<1,E=(0|I(G,Y))+n|0,f=E-B|0,T=f>>31,T=T&E|f&~T,R?(l&&(n=0|Zr[1547+(s<<2)+u>>0],E=3*T|0,(0|Kr[b>>2])>>>0<=E>>>0&&(Kr[z>>2]=866,Kr[z+4>>2]=910,Kr[z+8>>2]=1497,He(x,812,z),le(x)),f=(0|Kr[L>>2])+(E<<1)|0,Kr[A>>2]=(0|jr[f>>1])<<16|Kr[K+(n<<2)>>2],Kr[A+4>>2]=(0|jr[f+4>>1])<<16|0|jr[f+2>>1]),f=A+8|0,E=(0|I(G,Y))+T|0,T=E-B|0,n=T>>31,n=n&E|T&~n,l&&(E=0|Zr[1547+(s<<2)+(1|u)>>0],u=3*n|0,(0|Kr[b>>2])>>>0<=u>>>0&&(Kr[Z>>2]=866,Kr[Z+4>>2]=910,Kr[Z+8>>2]=1497,He(x,812,Z),le(x)),l=(0|Kr[L>>2])+(u<<1)|0,Kr[f>>2]=(0|jr[l>>1])<<16|Kr[K+(E<<2)>>2],Kr[A+12>>2]=(0|jr[l+4>>1])<<16|0|jr[l+2>>1])):(l&&(n=0|Zr[1547+(s<<2)+u>>0],E=3*T|0,(0|Kr[b>>2])>>>0<=E>>>0&&(Kr[j>>2]=866,Kr[j+4>>2]=910,Kr[j+8>>2]=1497,He(x,812,j),le(x)),l=(0|Kr[L>>2])+(E<<1)|0,Kr[A>>2]=(0|jr[l>>1])<<16|Kr[K+(n<<2)>>2],Kr[A+4>>2]=(0|jr[l+4>>1])<<16|0|jr[l+2>>1]),T=(0|I(G,Y))+T|0,l=T-B|0,n=l>>31,n=n&T|l&~n),2==(0|(c=c+1|0)))break;A=A+t|0}if((0|(e=O+e|0))==(0|M))break;d=d+N|0}if((0|(P=P+1|0))==(0|o))break;C=C+w|0}h=h+1|0}while((0|h)!=(0|p));return _i=J,1}function d(e,r,i,t,n){e|=0,r|=0,i|=0,t|=0,n|=0;var _=0,a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0;if(f=e,E=r,u=E,a=i,l=t,o=l,!u)return _=0!=(0|n),o?_?(Kr[n>>2]=0|e,Kr[n+4>>2]=0&r,l=0,n=0,0|(fi=l,n)):(l=0,n=0,0|(fi=l,n)):(_&&(Kr[n>>2]=(f>>>0)%(a>>>0),Kr[n+4>>2]=0),l=0,n=(f>>>0)/(a>>>0)>>>0,0|(fi=l,n));_=0==(0|o);do{if(a){if(!_){if((_=(0|li(0|o))-(0|li(0|u))|0)>>>0<=31){T=_+1|0,o=31-_|0,r=_-31>>31,a=T,e=f>>>(T>>>0)&r|u<<o,r&=u>>>(T>>>0),_=0,o=f<<o;break}return n?(Kr[n>>2]=0|e,Kr[n+4>>2]=E|0&r,l=0,n=0,0|(fi=l,n)):(l=0,n=0,0|(fi=l,n))}if((_=a-1|0)&a|0){o=33+(0|li(0|a))-(0|li(0|u))|0,A=64-o|0,T=32-o|0,E=T>>31,c=o-32|0,r=c>>31,a=o,e=T-1>>31&u>>>(c>>>0)|(u<<T|f>>>(o>>>0))&r,r&=u>>>(o>>>0),_=f<<A&E,o=(u<<A|f>>>(c>>>0))&E|f<<T&o-33>>31;break}return 0|n&&(Kr[n>>2]=_&f,Kr[n+4>>2]=0),1==(0|a)?(c=E|0&r,A=0|e,0|(fi=c,A)):(A=0|be(0|a),c=u>>>(A>>>0)|0,A=u<<32-A|f>>>(A>>>0)|0,0|(fi=c,A))}if(_)return 0|n&&(Kr[n>>2]=(u>>>0)%(a>>>0),Kr[n+4>>2]=0),c=0,A=(u>>>0)/(a>>>0)>>>0,0|(fi=c,A);if(!f)return 0|n&&(Kr[n>>2]=0,Kr[n+4>>2]=(u>>>0)%(o>>>0)),c=0,A=(u>>>0)/(o>>>0)>>>0,0|(fi=c,A);if(!((_=o-1|0)&o))return 0|n&&(Kr[n>>2]=0|e,Kr[n+4>>2]=_&u|0&r),c=0,A=u>>>((0|be(0|o))>>>0),0|(fi=c,A);if((_=(0|li(0|o))-(0|li(0|u))|0)>>>0<=30){r=_+1|0,o=31-_|0,a=r,e=u<<o|f>>>(r>>>0),r=u>>>(r>>>0),_=0,o=f<<o;break}return n?(Kr[n>>2]=0|e,Kr[n+4>>2]=E|0&r,c=0,A=0,0|(fi=c,A)):(c=0,A=0,0|(fi=c,A))}while(0);if(a){T=0|i,f=l|0&t,u=0|Qe(0|T,0|f,-1,-1),i=fi,E=o,o=0;do{t=E,E=_>>>31|E<<1,_=o|_<<1,t=e<<1|t>>>31|0,l=e>>>31|r<<1|0,Ze(0|u,0|i,0|t,0|l),A=fi,c=A>>31|((0|A)<0?-1:0)<<1,o=1&c,e=0|Ze(0|t,0|l,c&T|0,(((0|A)<0?-1:0)>>31|((0|A)<0?-1:0)<<1)&f|0),r=fi,a=a-1|0}while(0!=(0|a));u=E,E=0}else u=o,E=0,o=0;return a=0,0|n&&(Kr[n>>2]=e,Kr[n+4>>2]=r),c=(0|_)>>>31|(u|a)<<1|0&(a<<1|_>>>31)|E,A=-2&(_<<1|0)|o,0|(fi=c,A)}function M(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0,a=0,o=0,E=0,u=0,f=0,T=0;if(T=e+4|0,f=0|Kr[T>>2],i=-8&f,o=e+i|0,!(3&f))return r>>>0<256?0|(e=0):(i>>>0>=(r+4|0)>>>0?(i-r|0)>>>0<=Kr[1264]<<1>>>0:0)?0|e:0|(e=0);if(i>>>0>=r>>>0)return(i=i-r|0)>>>0<=15?0|e:(u=e+r|0,Kr[T>>2]=1&f|r|2,Kr[u+4>>2]=3|i,T=u+i+4|0,Kr[T>>2]=1|Kr[T>>2],c(u,i),0|e);if((0|o)==(0|Kr[1150]))return u=(0|Kr[1147])+i|0,i=u-r|0,t=e+r|0,u>>>0<=r>>>0?0|(e=0):(Kr[T>>2]=1&f|r|2,Kr[t+4>>2]=1|i,Kr[1150]=t,Kr[1147]=i,0|e);if((0|o)==(0|Kr[1149]))return(n=(0|Kr[1146])+i|0)>>>0<r>>>0?0|(e=0):(i=n-r|0,t=1&f,i>>>0>15?(f=e+r|0,u=f+i|0,Kr[T>>2]=t|r|2,Kr[f+4>>2]=1|i,Kr[u>>2]=i,t=u+4|0,Kr[t>>2]=-2&Kr[t>>2],t=f):(Kr[T>>2]=t|n|2,t=e+n+4|0,Kr[t>>2]=1|Kr[t>>2],t=0,i=0),Kr[1146]=i,Kr[1149]=t,0|e);if(2&(t=0|Kr[o+4>>2])|0)return 0|(e=0);if((E=(-8&t)+i|0)>>>0<r>>>0)return 0|(e=0);u=E-r|0,n=t>>>3;do{if(t>>>0<256){if(t=0|Kr[o+8>>2],(0|(i=0|Kr[o+12>>2]))==(0|t)){Kr[1144]=Kr[1144]&~(1<<n);break}Kr[t+12>>2]=i,Kr[i+8>>2]=t;break}a=0|Kr[o+24>>2],i=0|Kr[o+12>>2];do{if((0|i)==(0|o)){if(n=o+16|0,t=n+4|0,i=0|Kr[t>>2])_=t;else{if(!(i=0|Kr[n>>2])){n=0;break}_=n}for(;;)if(n=i+20|0,0|(t=0|Kr[n>>2]))i=t,_=n;else{if(t=i+16|0,!(n=0|Kr[t>>2]))break;i=n,_=t}Kr[_>>2]=0,n=i}else n=0|Kr[o+8>>2],Kr[n+12>>2]=i,Kr[i+8>>2]=n,n=i}while(0);if(0|a){if(i=0|Kr[o+28>>2],t=4880+(i<<2)|0,(0|o)==(0|Kr[t>>2])){if(Kr[t>>2]=n,!n){Kr[1145]=Kr[1145]&~(1<<i);break}}else if(Kr[a+16+(((0|Kr[a+16>>2])!=(0|o)&1)<<2)>>2]=n,!n)break;Kr[n+24>>2]=a,i=o+16|0,t=0|Kr[i>>2],0|t&&(Kr[n+16>>2]=t,Kr[t+24>>2]=n),i=0|Kr[i+4>>2],0|i&&(Kr[n+20>>2]=i,Kr[i+24>>2]=n)}}while(0);return i=1&f,u>>>0<16?(Kr[T>>2]=E|i|2,T=e+E+4|0,Kr[T>>2]=1|Kr[T>>2],0|e):(f=e+r|0,Kr[T>>2]=i|r|2,Kr[f+4>>2]=3|u,T=f+u+4|0,Kr[T>>2]=1|Kr[T>>2],c(f,u),0|e)}function S(e,r,i,t,n,_){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0;var a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0;switch(A=_i,_i=_i+592|0,c=A+56|0,E=A+40|0,T=A+72|0,f=A,l=A+68|0,Kr[f>>2]=40,G(e,r,f),a=(0|Kr[f+4>>2])>>>n,o=(0|Kr[f+8>>2])>>>n,f=f+32|0,t=0|Kr[f+4>>2],0|Kr[f>>2]){case 0:t?u=14:f=8;break;case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:u=t?14:13;break;case 9:case 10:t?u=14:f=8;break;default:u=14}13==(0|u)?f=16:14==(0|u)&&(Kr[E>>2]=866,Kr[E+4>>2]=2672,Kr[E+8>>2]=1251,He(T,812,E),le(T),f=0),Kr[l>>2]=i,u=0|L(e,r),r=_+n|0;do{if(r>>>0>n>>>0){if(!u){for(t=i;;){if(t=t+(0|Ti(0|Ti((a+3|0)>>>2,f),(o+3|0)>>>2))|0,(0|(n=n+1|0))==(0|r))break;o>>>=1,a>>>=1}Kr[l>>2]=t;break}for(e=o,t=i;;){if(o=0|Ti((a+3|0)>>>2,f),E=0|Ti(o,(e+3|0)>>>2),(n>>>0>15|E>>>0<8?0:519686845==(0|Kr[u>>2]))&&(V(u,l,E,o,n),t=0|Kr[l>>2]),t=t+E|0,Kr[l>>2]=t,(0|(n=n+1|0))==(0|r))break;e>>>=1,a>>>=1}}}while(0);return u?519686845!=(0|Kr[u>>2])?void(_i=A):(O(u),7&u?(Kr[c>>2]=866,Kr[c+4>>2]=2506,Kr[c+8>>2]=1232,He(T,812,c),le(T),void(_i=A)):(_e(u,0,0,1,0),void(_i=A))):void(_i=A)}function N(e){e|=0;var r=0,i=0,t=0,n=0,_=0,a=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0;if(A=_i,_i=_i+576|0,a=A,n=A+64|0,c=A+16|0,t=e+88|0,r=0|Kr[t>>2],l=(0|Zr[r+39>>0])<<8|0|Zr[r+40>>0],f=e+236|0,_=e+240|0,(0|(i=0|Kr[_>>2]))!=(0|l)){if(i>>>0<=l>>>0){do{if((0|Kr[e+244>>2])>>>0<l>>>0){if(0|h(f,l,(i+1|0)==(0|l),4,0)){r=0|Kr[_>>2];break}return Xr[e+248>>0]=1,c=0,_i=A,0|c}r=i}while(0);ee((0|Kr[f>>2])+(r<<2)|0,0,l-r<<2|0),r=0|Kr[t>>2]}Kr[_>>2]=l}if(T=e+92|0,i=(0|Kr[e+4>>2])+((0|Zr[r+34>>0])<<8|(0|Zr[r+33>>0])<<16|0|Zr[r+35>>0])|0,!(r=(0|Zr[r+37>>0])<<8|(0|Zr[r+36>>0])<<16|0|Zr[r+38>>0]))return c=0,_i=A,0|c;if(Kr[T>>2]=i,Kr[e+96>>2]=i,Kr[e+104>>2]=r,Kr[e+100>>2]=i+r,Kr[e+108>>2]=0,Kr[e+112>>2]=0,E=c+20|0,Kr[c>>2]=0,Kr[c+4>>2]=0,Kr[c+8>>2]=0,Kr[c+12>>2]=0,Xr[c+16>>0]=0,u=c+24|0,Kr[c+44>>2]=0,Kr[E>>2]=0,Kr[E+4>>2]=0,Kr[E+8>>2]=0,Kr[E+12>>2]=0,Kr[E+16>>2]=0,Xr[E+20>>0]=0,0|o(T,c)?0|o(T,u):0)if(0|Kr[_>>2]||(Kr[a>>2]=866,Kr[a+4>>2]=910,Kr[a+8>>2]=1497,He(n,812,a),le(n)),l)for(a=0,E=0,i=0|Kr[f>>2],t=0,e=0,r=0,n=0,_=0;;){if(a=(0|I(T,c))+a&31,_=(0|I(T,u))+_&63,n=(0|I(T,c))+n&31,r=(0|I(T,c))+r|0,e=(0|I(T,u))+e&63,t=(0|I(T,c))+t&31,Kr[i>>2]=_<<5|a<<11|n|r<<27|e<<21|t<<16,(E=E+1|0)>>>0>=l>>>0){r=1;break}i=i+4|0,r&=31}else r=1;else r=0;return z(c+24|0),z(c),c=r,_i=A,0|c}function I(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0,a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0;R=_i,_i=_i+576|0,u=R+48|0,T=R+32|0,f=R+16|0,E=R,c=R+64|0,l=0|Kr[r+20>>2],A=e+20|0,o=0|Kr[A>>2],(0|o)<24?(a=e+4|0,i=0|Kr[a>>2],n=0|Kr[e+8>>2],t=i>>>0<n>>>0,(0|o)<16?(t?(_=(0|Zr[i>>0])<<8,i=i+1|0):_=0,i>>>0<n>>>0?(n=0|Zr[i>>0],i=i+1|0):n=0,Kr[a>>2]=i,Kr[A>>2]=o+16,t=16,i=n|_):(t?(Kr[a>>2]=i+1,i=0|Zr[i>>0]):i=0,Kr[A>>2]=o+8,t=24),a=e+16|0,n=Kr[a>>2]|i<<t-o,Kr[a>>2]=n):(n=e+16|0,a=n,n=0|Kr[n>>2]),_=1+(n>>>16)|0;do{if(!(_>>>0<=(0|Kr[l+16>>2])>>>0)){for(t=0|Kr[l+20>>2];;){if(i=t+-1|0,!(_>>>0>(0|Kr[l+28+(i<<2)>>2])>>>0))break;t=t+1|0}if((i=(n>>>(32-t|0))+(0|Kr[l+96+(i<<2)>>2])|0)>>>0<(0|Kr[r>>2])>>>0){i=0|jr[(0|Kr[l+176>>2])+(i<<1)>>1];break}return Kr[u>>2]=866,Kr[u+4>>2]=3275,Kr[u+8>>2]=1348,He(c,812,u),le(c),A=0,_i=R,0|A}t=0|Kr[(0|Kr[l+168>>2])+(n>>>(32-(0|Kr[l+8>>2])|0)<<2)>>2],-1==(0|t)&&(Kr[E>>2]=866,Kr[E+4>>2]=3253,Kr[E+8>>2]=1393,He(c,812,E),le(c)),i=65535&t,t>>>=16,(0|Kr[r+8>>2])>>>0<=i>>>0&&(Kr[f>>2]=866,Kr[f+4>>2]=909,Kr[f+8>>2]=1497,He(c,812,f),le(c)),(0|Zr[(0|Kr[r+4>>2])+i>>0])!=(0|t)&&(Kr[T>>2]=866,Kr[T+4>>2]=3257,Kr[T+8>>2]=1410,He(c,812,T),le(c))}while(0);return Kr[a>>2]=Kr[a>>2]<<t,Kr[A>>2]=(0|Kr[A>>2])-t,A=i,_i=R,0|A}function O(e){e|=0;var r=0,i=0,t=0,n=0,_=0,a=0,o=0,E=0;if(E=_i,_i=_i+576|0,o=E+48|0,_=E+32|0,n=E+16|0,t=E,a=E+64|0,Kr[e>>2]=0,r=e+284|0,i=0|Kr[r>>2],0|i&&(7&i?(Kr[t>>2]=866,Kr[t+4>>2]=2506,Kr[t+8>>2]=1232,He(a,812,t),le(a)):_e(i,0,0,1,0),Kr[r>>2]=0,Kr[e+288>>2]=0,Kr[e+292>>2]=0),Xr[e+296>>0]=0,r=e+268|0,i=0|Kr[r>>2],0|i&&(7&i?(Kr[n>>2]=866,Kr[n+4>>2]=2506,Kr[n+8>>2]=1232,He(a,812,n),le(a)):_e(i,0,0,1,0),Kr[r>>2]=0,Kr[e+272>>2]=0,Kr[e+276>>2]=0),Xr[e+280>>0]=0,r=e+252|0,i=0|Kr[r>>2],0|i&&(7&i?(Kr[_>>2]=866,Kr[_+4>>2]=2506,Kr[_+8>>2]=1232,He(a,812,_),le(a)):_e(i,0,0,1,0),Kr[r>>2]=0,Kr[e+256>>2]=0,Kr[e+260>>2]=0),Xr[e+264>>0]=0,r=e+236|0,!(i=0|Kr[r>>2]))return o=e+248|0,Xr[o>>0]=0,o=e+212|0,z(o),o=e+188|0,z(o),o=e+164|0,z(o),o=e+140|0,z(o),o=e+116|0,z(o),void(_i=E);7&i?(Kr[o>>2]=866,Kr[o+4>>2]=2506,Kr[o+8>>2]=1232,He(a,812,o),le(a)):_e(i,0,0,1,0),Kr[r>>2]=0,Kr[e+240>>2]=0,Kr[e+244>>2]=0,o=e+248|0,Xr[o>>0]=0,o=e+212|0,z(o),o=e+188|0,z(o),o=e+164|0,z(o),o=e+140|0,z(o),o=e+116|0,z(o),_i=E}function C(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0;e:do{if(r>>>0<=20)switch(0|r){case 9:t=3+(0|Kr[i>>2])&-4,r=0|Kr[t>>2],Kr[i>>2]=t+4,Kr[e>>2]=r;break e;case 10:t=3+(0|Kr[i>>2])&-4,r=0|Kr[t>>2],Kr[i>>2]=t+4,t=e,Kr[t>>2]=r,Kr[t+4>>2]=((0|r)<0)<<31>>31;break e;case 11:t=3+(0|Kr[i>>2])&-4,r=0|Kr[t>>2],Kr[i>>2]=t+4,t=e,Kr[t>>2]=r,Kr[t+4>>2]=0;break e;case 12:t=7+(0|Kr[i>>2])&-8,r=t,n=0|Kr[r>>2],r=0|Kr[r+4>>2],Kr[i>>2]=t+8,t=e,Kr[t>>2]=n,Kr[t+4>>2]=r;break e;case 13:n=3+(0|Kr[i>>2])&-4,t=0|Kr[n>>2],Kr[i>>2]=n+4,t=(65535&t)<<16>>16,n=e,Kr[n>>2]=t,Kr[n+4>>2]=((0|t)<0)<<31>>31;break e;case 14:n=3+(0|Kr[i>>2])&-4,t=0|Kr[n>>2],Kr[i>>2]=n+4,n=e,Kr[n>>2]=65535&t,Kr[n+4>>2]=0;break e;case 15:n=3+(0|Kr[i>>2])&-4,t=0|Kr[n>>2],Kr[i>>2]=n+4,t=(255&t)<<24>>24,n=e,Kr[n>>2]=t,Kr[n+4>>2]=((0|t)<0)<<31>>31;break e;case 16:n=3+(0|Kr[i>>2])&-4,t=0|Kr[n>>2],Kr[i>>2]=n+4,n=e,Kr[n>>2]=255&t,Kr[n+4>>2]=0;break e;case 17:case 18:n=7+(0|Kr[i>>2])&-8,_=+ri[n>>3],Kr[i>>2]=n+8,ri[e>>3]=_;break e;default:break e}}while(0)}function P(e){e|=0;var r=0,i=0,t=0,n=0,_=0,a=0,E=0,u=0,f=0;if(f=_i,_i=_i+560|0,n=f,t=f+40|0,u=f+16|0,i=0|Kr[e+88>>2],a=(0|Zr[i+55>>0])<<8|0|Zr[i+56>>0],E=e+92|0,r=(0|Kr[e+4>>2])+((0|Zr[i+50>>0])<<8|(0|Zr[i+49>>0])<<16|0|Zr[i+51>>0])|0,!(i=(0|Zr[i+53>>0])<<8|(0|Zr[i+52>>0])<<16|0|Zr[i+54>>0]))return u=0,_i=f,0|u;Kr[E>>2]=r,Kr[e+96>>2]=r,Kr[e+104>>2]=i,Kr[e+100>>2]=r+i,Kr[e+108>>2]=0,Kr[e+112>>2]=0,Kr[u+20>>2]=0,Kr[u>>2]=0,Kr[u+4>>2]=0,Kr[u+8>>2]=0,Kr[u+12>>2]=0,Xr[u+16>>0]=0;e:do{if(0|o(E,u)){if(_=e+268|0,i=e+272|0,(0|(r=0|Kr[i>>2]))!=(0|a)){if(r>>>0<=a>>>0){do{if((0|Kr[e+276>>2])>>>0<a>>>0){if(0|h(_,a,(r+1|0)==(0|a),2,0)){r=0|Kr[i>>2];break}Xr[e+280>>0]=1,r=0;break e}}while(0);ee((0|Kr[_>>2])+(r<<1)|0,0,a-r<<1|0)}Kr[i>>2]=a}if(!a){Kr[n>>2]=866,Kr[n+4>>2]=910,Kr[n+8>>2]=1497,He(t,812,n),le(t),r=1;break}for(i=0,e=0,t=0,r=0|Kr[_>>2];;){if(_=0|I(E,u),t=_+t&255,e=(0|I(E,u))+e&255,Yr[r>>1]=e<<8|t,(i=i+1|0)>>>0>=a>>>0){r=1;break}r=r+2|0}}else r=0}while(0);return z(u),u=r,_i=f,0|u}function h(e,r,i,t,n){e|=0,r|=0,i|=0,t|=0,n|=0;var _=0,a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0;if(A=_i,_i=_i+576|0,T=A+48|0,E=A+32|0,a=A+16|0,_=A,f=A+64|0,l=A+60|0,u=e+4|0,c=e+8|0,(0|Kr[u>>2])>>>0>(0|Kr[c>>2])>>>0&&(Kr[_>>2]=866,Kr[_+4>>2]=2123,Kr[_+8>>2]=845,He(f,812,_),le(f)),(2147418112/(t>>>0)|0)>>>0<=r>>>0&&(Kr[a>>2]=866,Kr[a+4>>2]=2124,Kr[a+8>>2]=885,He(f,812,a),le(f)),(_=0|Kr[c>>2])>>>0>=r>>>0)return c=1,_i=A,0|c;if((i?0!=((o=r+-1|0)&r|0):0)?(r=o>>>16|o,r|=r>>>8,r|=r>>>4,r|=r>>>2,r=1+(r>>>1|r)|0,r?i=9:(r=0,i=10)):i=9,9==(0|i)&&r>>>0<=_>>>0&&(i=10),10==(0|i)&&(Kr[E>>2]=866,Kr[E+4>>2]=2133,Kr[E+8>>2]=933,He(f,812,E),le(f)),o=0|Ti(r,t),n)if(a=0|j(o,l)){Bi[0&n](a,0|Kr[e>>2],0|Kr[u>>2]),_=0|Kr[e>>2];do{if(0|_){if(7&_){Kr[T>>2]=866,Kr[T+4>>2]=2506,Kr[T+8>>2]=1232,He(f,812,T),le(f);break}_e(_,0,0,1,0);break}}while(0);Kr[e>>2]=a,i=20}else r=0;else _=0|q(0|Kr[e>>2],o,l,1),_?(Kr[e>>2]=_,i=20):r=0;return 20==(0|i)&&(_=0|Kr[l>>2],_>>>0>o>>>0&&(r=(_>>>0)/(t>>>0)|0),Kr[c>>2]=r,r=1),c=r,_i=A,0|c}function L(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0,a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0;if(l=_i,_i=_i+528|0,f=l,o=l+16|0,0==(0|e)|r>>>0<62)return c=0,_i=l,0|c;if(!(E=0|j(300,0)))return c=0,_i=l,0|c;Kr[E>>2]=519686845,Kr[E+4>>2]=0,Kr[E+8>>2]=0,u=E+88|0,i=E+136|0,t=E+160|0,n=E+184|0,_=E+208|0,a=E+232|0,T=E+252|0,Kr[T>>2]=0,Kr[T+4>>2]=0,Kr[T+8>>2]=0,Xr[T+12>>0]=0,T=E+268|0,Kr[T>>2]=0,Kr[T+4>>2]=0,Kr[T+8>>2]=0,Xr[T+12>>0]=0,T=E+284|0,Kr[T>>2]=0,Kr[T+4>>2]=0,Kr[T+8>>2]=0,Xr[T+12>>0]=0,T=u,c=T+44|0;do{Kr[T>>2]=0,T=T+4|0}while((0|T)<(0|c));return Xr[u+44>>0]=0,Kr[i>>2]=0,Kr[i+4>>2]=0,Kr[i+8>>2]=0,Kr[i+12>>2]=0,Kr[i+16>>2]=0,Xr[i+20>>0]=0,Kr[t>>2]=0,Kr[t+4>>2]=0,Kr[t+8>>2]=0,Kr[t+12>>2]=0,Kr[t+16>>2]=0,Xr[t+20>>0]=0,Kr[n>>2]=0,Kr[n+4>>2]=0,Kr[n+8>>2]=0,Kr[n+12>>2]=0,Kr[n+16>>2]=0,Xr[n+20>>0]=0,Kr[_>>2]=0,Kr[_+4>>2]=0,Kr[_+8>>2]=0,Kr[_+12>>2]=0,Kr[_+16>>2]=0,Xr[_+20>>0]=0,Kr[a>>2]=0,Kr[a+4>>2]=0,Kr[a+8>>2]=0,Kr[a+12>>2]=0,Xr[a+16>>0]=0,0|Y(E,e,r)?(c=E,_i=l,0|c):(O(E),7&E?(Kr[f>>2]=866,Kr[f+4>>2]=2506,Kr[f+8>>2]=1232,He(o,812,f),le(o),c=0,_i=l,0|c):(_e(E,0,0,1,0),c=0,_i=l,0|c))}function b(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0,a=0,o=0,E=0;switch(o=_i,_i=_i+576|0,_=o+40|0,n=o+56|0,E=o,Kr[E>>2]=40,G(e,r,E),
t=(3+((0|Kr[E+4>>2])>>>i)|0)>>>2,r=(3+((0|Kr[E+8>>2])>>>i)|0)>>>2,i=E+32|0,e=0|Kr[i+4>>2],0|Kr[i>>2]){case 0:e?a=14:e=8;break;case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:a=e?14:13;break;case 9:case 10:e?a=14:e=8;break;default:a=14}return 13==(0|a)?e=16:14==(0|a)&&(Kr[_>>2]=866,Kr[_+4>>2]=2672,Kr[_+8>>2]=1251,He(n,812,_),le(n),e=0),E=0|Ti(0|Ti(r,t),e),_i=o,0|E}function U(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0;switch(n=_i,_i=_i+576|0,t=n+40|0,i=n+56|0,_=n,Kr[_>>2]=40,G(e,r,_),r=_+32|0,e=0|Kr[r+4>>2],0|Kr[r>>2]){case 0:if(!e)return _=8,_i=n,0|_;e=14;break;case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:e=e?14:13;break;case 9:case 10:if(!e)return _=8,_i=n,0|_;e=14;break;default:e=14}return 13==(0|e)?(_=16,_i=n,0|_):14==(0|e)?(Kr[t>>2]=866,Kr[t+4>>2]=2672,Kr[t+8>>2]=1251,He(i,812,t),le(i),_=0,_i=n,0|_):0}function F(e,r,i,t,n,_,a){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0,a|=0;var o=0,E=0,T=0,c=0;if(c=0|Kr[e+88>>2],E=(Zr[c+12>>0]<<8|Zr[c+13>>0])>>>a,T=(Zr[c+14>>0]<<8|Zr[c+15>>0])>>>a,E=((E>>>0>1?E:1)+3|0)>>>2,T=((T>>>0>1?T:1)+3|0)>>>2,c=c+18|0,a=0|Xr[c>>0],a=0|Ti(E,a<<24>>24==0|a<<24>>24==9?8:16),_){if(!(0==(3&_|0)&a>>>0<=_>>>0))return 0|(n=0);a=_}if((0|Ti(a,T))>>>0>n>>>0)return 0|(n=0);if(_=(E+1|0)>>>1,o=(T+1|0)>>>1,!i)return 0|(n=0);switch(Kr[e+92>>2]=r,Kr[e+96>>2]=r,Kr[e+104>>2]=i,Kr[e+100>>2]=r+i,Kr[e+108>>2]=0,Kr[e+112>>2]=0,0|Xr[c>>0]){case 0:if(!(0|u(e,t,n,a,E,T,_,o)))return 0|(n=0);break;case 4:case 6:case 5:case 3:case 2:if(!(0|l(e,t,n,a,E,T,_,o)))return 0|(n=0);break;case 9:if(!(0|s(e,t,n,a,E,T,_,o)))return 0|(n=0);break;case 8:case 7:if(!(0|f(e,t,n,a,E,T,_,o)))return 0|(n=0);break;default:return 0|(n=0)}return 0|(n=1)}function D(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0;if((0|i)>=8192)return 0|Pi(0|e,0|r,0|i);if(_=0|e,n=e+i|0,(3&e)==(3&r)){for(;3&e;){if(!i)return 0|_;Xr[e>>0]=0|Xr[r>>0],e=e+1|0,r=r+1|0,i=i-1|0}for(i=-4&n|0,t=i-64|0;(0|e)<=(0|t);)Kr[e>>2]=Kr[r>>2],Kr[e+4>>2]=Kr[r+4>>2],Kr[e+8>>2]=Kr[r+8>>2],Kr[e+12>>2]=Kr[r+12>>2],Kr[e+16>>2]=Kr[r+16>>2],Kr[e+20>>2]=Kr[r+20>>2],Kr[e+24>>2]=Kr[r+24>>2],Kr[e+28>>2]=Kr[r+28>>2],Kr[e+32>>2]=Kr[r+32>>2],Kr[e+36>>2]=Kr[r+36>>2],Kr[e+40>>2]=Kr[r+40>>2],Kr[e+44>>2]=Kr[r+44>>2],Kr[e+48>>2]=Kr[r+48>>2],Kr[e+52>>2]=Kr[r+52>>2],Kr[e+56>>2]=Kr[r+56>>2],Kr[e+60>>2]=Kr[r+60>>2],e=e+64|0,r=r+64|0;for(;(0|e)<(0|i);)Kr[e>>2]=Kr[r>>2],e=e+4|0,r=r+4|0}else for(i=n-4|0;(0|e)<(0|i);)Xr[e>>0]=0|Xr[r>>0],Xr[e+1>>0]=0|Xr[r+1>>0],Xr[e+2>>0]=0|Xr[r+2>>0],Xr[e+3>>0]=0|Xr[r+3>>0],e=e+4|0,r=r+4|0;for(;(0|e)<(0|n);)Xr[e>>0]=0|Xr[r>>0],e=e+1|0,r=r+1|0;return 0|_}function m(e){e|=0;var r=0,i=0,t=0,n=0;if(n=e+92|0,t=e+88|0,i=0|Kr[t>>2],r=(0|Kr[e+4>>2])+((0|Zr[i+68>>0])<<8|(0|Zr[i+67>>0])<<16|0|Zr[i+69>>0])|0,!(i=(0|Zr[i+65>>0])<<8|0|Zr[i+66>>0]))return 0|(n=0);if(Kr[n>>2]=r,Kr[e+96>>2]=r,Kr[e+104>>2]=i,Kr[e+100>>2]=r+i,Kr[e+108>>2]=0,Kr[e+112>>2]=0,!(0|o(n,e+116|0)))return 0|(n=0);r=0|Kr[t>>2];do{if((0|Zr[r+39>>0])<<8|0|Zr[r+40>>0]){if(!(0|o(n,e+140|0)))return 0|(n=0);if(0|o(n,e+188|0)){r=0|Kr[t>>2];break}return 0|(n=0)}if(!((0|Zr[r+55>>0])<<8|0|Zr[r+56>>0]))return 0|(n=0)}while(0);if((0|Zr[r+55>>0])<<8|0|Zr[r+56>>0]|0){if(!(0|o(n,e+164|0)))return 0|(n=0);if(!(0|o(n,e+212|0)))return 0|(n=0)}return 0|(n=1)}function B(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0,a=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0;T=_i,_i=_i+48|0,u=T+16|0,_=T,n=T+32|0,o=e+28|0,t=0|Kr[o>>2],Kr[n>>2]=t,E=e+20|0,t=(0|Kr[E>>2])-t|0,Kr[n+4>>2]=t,Kr[n+8>>2]=r,Kr[n+12>>2]=i,t=t+i|0,a=e+60|0,Kr[_>>2]=Kr[a>>2],Kr[_+4>>2]=n,Kr[_+8>>2]=2,_=0|$e(0|bi(146,0|_));e:do{if((0|t)!=(0|_)){for(r=2;;){if((0|_)<0)break;if(t=t-_|0,c=0|Kr[n+4>>2],l=_>>>0>c>>>0,n=l?n+8|0:n,r=(l<<31>>31)+r|0,c=_-(l?c:0)|0,Kr[n>>2]=(0|Kr[n>>2])+c,l=n+4|0,Kr[l>>2]=(0|Kr[l>>2])-c,Kr[u>>2]=Kr[a>>2],Kr[u+4>>2]=n,Kr[u+8>>2]=r,_=0|$e(0|bi(146,0|u)),(0|t)==(0|_)){f=3;break e}}Kr[e+16>>2]=0,Kr[o>>2]=0,Kr[E>>2]=0,Kr[e>>2]=32|Kr[e>>2],i=2==(0|r)?0:i-(0|Kr[n+4>>2])|0}else f=3}while(0);return 3==(0|f)&&(c=0|Kr[e+44>>2],Kr[e+16>>2]=c+(0|Kr[e+48>>2]),Kr[o>>2]=c,Kr[E>>2]=c),_i=T,0|i}function p(e,r,i,t,n){e|=0,r|=0,i|=0,t|=0,n|=0;var _=0,a=0,o=0,E=0;do{if(0|Er(e,0|Kr[r+8>>2],n))Ue(0,r,i,t);else{if(_=e+8|0,!(0|Er(e,0|Kr[r>>2],n))){o=0|Kr[_>>2],Fi[3&Kr[24+(0|Kr[o>>2])>>2]](o,r,i,t,n);break}if(e=r+32|0,(0|Kr[r+16>>2])!=(0|i)?(a=r+20|0,(0|Kr[a>>2])!=(0|i)):0){if(Kr[e>>2]=t,t=r+44|0,4==(0|Kr[t>>2]))break;e=r+52|0,Xr[e>>0]=0,E=r+53|0,Xr[E>>0]=0,_=0|Kr[_>>2],vi[3&Kr[20+(0|Kr[_>>2])>>2]](_,r,i,i,1,n),0|Xr[E>>0]?0|Xr[e>>0]?e=3:(e=3,o=11):(e=4,o=11),11==(0|o)&&(Kr[a>>2]=i,E=r+40|0,Kr[E>>2]=1+(0|Kr[E>>2]),(1==(0|Kr[r+36>>2])?2==(0|Kr[r+24>>2]):0)&&(Xr[r+54>>0]=1)),Kr[t>>2]=e;break}1==(0|t)&&(Kr[e>>2]=1)}}while(0)}function v(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0,o=0,E=0,u=0,f=0,T=0,l=0,c=0,A=0,R=0,s=0;s=_i,_i=_i+224|0,T=s+120|0,l=s+80|0,A=s,R=s+136|0,t=l,n=t+40|0;do{Kr[t>>2]=0,t=t+4|0}while((0|t)<(0|n));return Kr[T>>2]=Kr[i>>2],(0|a(0,r,T,A,l))<0?i=-1:(c=(0|Kr[e+76>>2])>-1?0|kr(e):0,i=0|Kr[e>>2],f=32&i,(0|Xr[e+74>>0])<1&&(Kr[e>>2]=-33&i),t=e+48|0,0|Kr[t>>2]?i=0|a(e,r,T,A,l):(n=e+44|0,_=0|Kr[n>>2],Kr[n>>2]=R,o=e+28|0,Kr[o>>2]=R,E=e+20|0,Kr[E>>2]=R,Kr[t>>2]=80,u=e+16|0,Kr[u>>2]=R+80,i=0|a(e,r,T,A,l),_&&(Ui[7&Kr[e+36>>2]](e,0,0),i=0==(0|Kr[E>>2])?-1:i,Kr[n>>2]=_,Kr[t>>2]=0,Kr[u>>2]=0,Kr[o>>2]=0,Kr[E>>2]=0)),t=0|Kr[e>>2],Kr[e>>2]=t|f,0|c&&vr(e),i=0==(32&t|0)?i:-1),_i=s,0|i}function k(e,r,i,t){e|=0,r|=0,i|=0,t|=0;var n=0,_=0,a=0,o=0,E=0,u=0,f=0,T=0,l=0;l=_i,_i=_i+64|0,f=l,u=0|Kr[e>>2],T=e+(0|Kr[u+-8>>2])|0,u=0|Kr[u+-4>>2],Kr[f>>2]=i,Kr[f+4>>2]=e,Kr[f+8>>2]=r,Kr[f+12>>2]=t,e=f+16|0,r=f+20|0,t=f+24|0,n=f+28|0,_=f+32|0,a=f+40|0,o=e,E=o+36|0;do{Kr[o>>2]=0,o=o+4|0}while((0|o)<(0|E));Yr[e+36>>1]=0,Xr[e+38>>0]=0;e:do{if(0|Er(u,i,0))Kr[f+48>>2]=1,vi[3&Kr[20+(0|Kr[u>>2])>>2]](u,f,T,T,1,0),e=1==(0|Kr[t>>2])?T:0;else{switch(Fi[3&Kr[24+(0|Kr[u>>2])>>2]](u,f,T,1,0),0|Kr[f+36>>2]){case 0:e=1==(0|Kr[a>>2])&1==(0|Kr[n>>2])&1==(0|Kr[_>>2])?0|Kr[r>>2]:0;break e;case 1:break;default:e=0;break e}if(1!=(0|Kr[t>>2])?!(0==(0|Kr[a>>2])&1==(0|Kr[n>>2])&1==(0|Kr[_>>2])):0){e=0;break}e=0|Kr[e>>2]}}while(0);return _i=l,0|e}function y(e){e|=0;var r=0,i=0,t=0,n=0,_=0,a=0,o=0,u=0;if(u=_i,_i=_i+544|0,a=u+16|0,r=u,n=u+32|0,_=e+8|0,i=0|Kr[_>>2],(i+-1|0)>>>0>=8192&&(Kr[r>>2]=866,Kr[r+4>>2]=3006,Kr[r+8>>2]=1257,He(n,812,r),le(n)),Kr[e>>2]=i,t=e+20|0,r=0|Kr[t>>2],r?o=i:(r=0|j(180,0),r?(o=r+164|0,Kr[o>>2]=0,Kr[o+4>>2]=0,Kr[o+8>>2]=0,Kr[o+12>>2]=0):r=0,Kr[t>>2]=r,o=0|Kr[e>>2]),0|Kr[_>>2]?a=o:(Kr[a>>2]=866,Kr[a+4>>2]=910,Kr[a+8>>2]=1497,He(n,812,a),le(n),a=0|Kr[e>>2]),n=0|Kr[e+4>>2],!(a>>>0>16))return e=0,e=0|E(r,o,n,e),_i=u,0|e;for(i=a,t=0;;){if(_=t+1|0,!(i>>>0>3))break;i>>>=1,t=_}return e=t+2+(32!=(0|_)&1<<_>>>0<a>>>0&1)|0,e=255&(e>>>0<11?e:11),e=0|E(r,o,n,e),_i=u,0|e}function g(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0,a=0,o=0,E=0,u=0,f=0,T=0,l=0;l=1794895138+(0|Kr[e>>2])|0,_=0|ur(0|Kr[e+8>>2],l),t=0|ur(0|Kr[e+12>>2],l),n=0|ur(0|Kr[e+16>>2],l);e:do{if((_>>>0<r>>>2>>>0?(T=r-(_<<2)|0,t>>>0<T>>>0&n>>>0<T>>>0):0)?0==(3&(n|t)|0):0){for(T=t>>>2,f=n>>>2,u=0;;){if(o=_>>>1,E=u+o|0,a=E<<1,n=a+T|0,t=0|ur(0|Kr[e+(n<<2)>>2],l),!((n=0|ur(0|Kr[e+(n+1<<2)>>2],l))>>>0<r>>>0&t>>>0<(r-n|0)>>>0)){t=0;break e}if(0|Xr[e+(n+t)>>0]){t=0;break e}if(!(t=0|Me(i,e+n|0)))break;if(t=(0|t)<0,1==(0|_)){t=0;break e}u=t?u:E,_=t?o:_-o|0}t=a+f|0,n=0|ur(0|Kr[e+(t<<2)>>2],l),t=0|ur(0|Kr[e+(t+1<<2)>>2],l),t=t>>>0<r>>>0&n>>>0<(r-t|0)>>>0&&0==(0|Xr[e+(t+n)>>0])?e+t|0:0}else t=0}while(0);return 0|t}function w(e){e|=0;var r=0,i=0,t=0,n=0,_=0,a=0,o=0,E=0;o=_i,_i=_i+576|0,_=o+48|0,a=o+32|0,t=o+16|0,i=o,n=o+64|0,r=0|Kr[e+168>>2];do{if(0|r){if(E=0|Kr[r+-4>>2],r=r+-8|0,(0!=(0|E)?(0|E)==(0|~Kr[r>>2]):0)||(Kr[i>>2]=866,Kr[i+4>>2]=651,Kr[i+8>>2]=1579,He(n,812,i),le(n)),7&r){Kr[t>>2]=866,Kr[t+4>>2]=2506,Kr[t+8>>2]=1232,He(n,812,t),le(n);break}_e(r,0,0,1,0);break}}while(0);return(r=0|Kr[e+176>>2])?(E=0|Kr[r+-4>>2],r=r+-8|0,(0!=(0|E)?(0|E)==(0|~Kr[r>>2]):0)||(Kr[a>>2]=866,Kr[a+4>>2]=651,Kr[a+8>>2]=1579,He(n,812,a),le(n)),7&r?(Kr[_>>2]=866,Kr[_+4>>2]=2506,Kr[_+8>>2]=1232,He(n,812,_),le(n),void(_i=o)):(_e(r,0,0,1,0),void(_i=o))):void(_i=o)}function G(e,r,i){e|=0,r|=0,i|=0;var t=0;return 0!=(0|e)&r>>>0>73&0!=(0|i)?40!=(0|Kr[i>>2])?0|(i=0):18552!=((0|Zr[e>>0])<<8|0|Zr[e+1>>0]|0)?0|(i=0):((0|Zr[e+2>>0])<<8|0|Zr[e+3>>0])>>>0<74?0|(i=0):((0|Zr[e+7>>0])<<16|(0|Zr[e+6>>0])<<24|(0|Zr[e+8>>0])<<8|0|Zr[e+9>>0])>>>0>r>>>0?0|(i=0):(Kr[i+4>>2]=(0|Zr[e+12>>0])<<8|0|Zr[e+13>>0],Kr[i+8>>2]=(0|Zr[e+14>>0])<<8|0|Zr[e+15>>0],Kr[i+12>>2]=Zr[e+16>>0],Kr[i+16>>2]=Zr[e+17>>0],r=e+18|0,t=i+32|0,Kr[t>>2]=Zr[r>>0],Kr[t+4>>2]=0,r=0|Xr[r>>0],Kr[i+20>>2]=r<<24>>24==0|r<<24>>24==9?8:16,Kr[i+24>>2]=(0|Zr[e+26>>0])<<16|(0|Zr[e+25>>0])<<24|(0|Zr[e+27>>0])<<8|0|Zr[e+28>>0],Kr[i+28>>2]=(0|Zr[e+30>>0])<<16|(0|Zr[e+29>>0])<<24|(0|Zr[e+31>>0])<<8|0|Zr[e+32>>0],0|(i=1)):0|(i=0)}function H(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0,a=0,o=0,E=0,u=0;if(u=_i,_i=_i+544|0,o=u+16|0,i=u,a=u+32|0,r>>>0>=33&&(Kr[i>>2]=866,Kr[i+4>>2]=3199,Kr[i+8>>2]=1350,He(a,812,i),le(a)),E=e+20|0,(0|(i=0|Kr[E>>2]))>=(0|r))return n=e+16|0,_=n,n=0|Kr[n>>2],a=i,o=32-r|0,o=n>>>o,n<<=r,Kr[_>>2]=n,r=a-r|0,Kr[E>>2]=r,_i=u,0|o;n=e+4|0,_=e+8|0,t=e+16|0;do{e=0|Kr[n>>2],(0|e)==(0|Kr[_>>2])?e=0:(Kr[n>>2]=e+1,e=0|Zr[e>>0]),i=i+8|0,Kr[E>>2]=i,(0|i)>=33&&(Kr[o>>2]=866,Kr[o+4>>2]=3208,Kr[o+8>>2]=1366,He(a,812,o),le(a),i=0|Kr[E>>2]),e=e<<32-i|Kr[t>>2],Kr[t>>2]=e}while((0|i)<(0|r));return o=32-r|0,o=e>>>o,a=e<<r,Kr[t>>2]=a,r=i-r|0,Kr[E>>2]=r,_i=u,0|o}function X(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0,a=0;_=255&r,t=0!=(0|i);e:do{if(t&0!=(3&e|0))for(n=255&r;;){if((0|Xr[e>>0])==n<<24>>24){a=6;break e}if(e=e+1|0,i=i+-1|0,!((t=0!=(0|i))&0!=(3&e|0))){a=5;break}}else a=5}while(0);5==(0|a)&&(t?a=6:i=0);e:do{if(6==(0|a)&&(n=255&r,(0|Xr[e>>0])!=n<<24>>24)){t=0|Ti(_,16843009);r:do{if(i>>>0>3)for(;;){if((-2139062144&(_=Kr[e>>2]^t)^-2139062144)&_+-16843009|0)break;if(e=e+4|0,(i=i+-4|0)>>>0<=3){a=11;break r}}else a=11}while(0);if(11==(0|a)&&!i){i=0;break}for(;;){if((0|Xr[e>>0])==n<<24>>24)break e;if(e=e+1|0,!(i=i+-1|0)){i=0;break}}}}while(0);return 0|(0|i?e:0)}function V(e,r,i,t,n){e|=0,r|=0,i|=0,t|=0,n|=0;var _=0,a=0,o=0,E=0,u=0,f=0;return f=_i,_i=_i+528|0,u=f,E=f+16|0,a=0|Kr[e+88>>2],o=(0|Zr[a+70+(n<<2)+1>>0])<<16|(0|Zr[a+70+(n<<2)>>0])<<24|(0|Zr[a+70+(n<<2)+2>>0])<<8|0|Zr[a+70+(n<<2)+3>>0],_=n+1|0,(_=_>>>0<(0|Zr[a+16>>0])>>>0?(0|Zr[a+70+(_<<2)+1>>0])<<16|(0|Zr[a+70+(_<<2)>>0])<<24|(0|Zr[a+70+(_<<2)+2>>0])<<8|0|Zr[a+70+(_<<2)+3>>0]:0|Kr[e+8>>2])>>>0>o>>>0?(E=e+4|0,E=0|Kr[E>>2],E=E+o|0,u=_-o|0,u=0|F(e,E,u,r,i,t,n),_i=f,0|u):(Kr[u>>2]=866,Kr[u+4>>2]=3694,Kr[u+8>>2]=1508,He(E,812,u),le(E),E=e+4|0,E=0|Kr[E>>2],E=E+o|0,u=_-o|0,u=0|F(e,E,u,r,i,t,n),_i=f,0|u)}function Y(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0;if(((0==(0|r)|i>>>0<74?0:18552==((0|Zr[r>>0])<<8|0|Zr[r+1>>0]|0))?((0|Zr[r+2>>0])<<8|0|Zr[r+3>>0])>>>0>=74:0)?((0|Zr[r+7>>0])<<16|(0|Zr[r+6>>0])<<24|(0|Zr[r+8>>0])<<8|0|Zr[r+9>>0])>>>0<=i>>>0:0){if(t=e+88|0,Kr[t>>2]=r,Kr[e+4>>2]=r,Kr[e+8>>2]=i,!(0|m(e)))return 0|(n=0);if(r=0|Kr[t>>2],(0|Zr[r+39>>0])<<8|0|Zr[r+40>>0]?(0|N(e)?0|R(e):0)&&(r=0|Kr[t>>2],n=11):n=11,11==(0|n)){if(!((0|Zr[r+55>>0])<<8|0|Zr[r+56>>0]))return 0|(n=1);if(0|P(e)?0|A(e):0)return 0|(n=1)}return 0|(n=0)}return Kr[e+88>>2]=0,0|(n=0)}function x(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0,a=0,o=0,E=0,u=0;if(u=_i,_i=_i+528|0,a=u,_=u+16|0,!r)return E=0,_i=u,0|E;if(r>>>0<=16)return E=0|H(e,r),_i=u,0|E;if(o=0|H(e,r+-16|0),E=e+20|0,(0|(r=0|Kr[E>>2]))<16){t=e+4|0,n=e+8|0,i=e+16|0;do{e=0|Kr[t>>2],(0|e)==(0|Kr[n>>2])?e=0:(Kr[t>>2]=e+1,e=0|Zr[e>>0]),r=r+8|0,Kr[E>>2]=r,(0|r)>=33&&(Kr[a>>2]=866,Kr[a+4>>2]=3208,Kr[a+8>>2]=1366,He(_,812,a),le(_),r=0|Kr[E>>2]),e=e<<32-r|Kr[i>>2],Kr[i>>2]=e}while((0|r)<16)}else e=e+16|0,i=e,e=0|Kr[e>>2];return Kr[i>>2]=e<<16,Kr[E>>2]=r+-16,E=e>>>16|o<<16,_i=u,0|E}function K(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0,a=0,o=0;t=i+16|0,n=0|Kr[t>>2],n?_=5:0|de(i)?t=0:(n=0|Kr[t>>2],_=5);e:do{if(5==(0|_)){if(o=i+20|0,a=0|Kr[o>>2],t=a,(n-a|0)>>>0<r>>>0){t=0|Ui[7&Kr[i+36>>2]](i,e,r);break}r:do{if((0|Xr[i+75>>0])>-1){for(a=r;;){if(!a){_=0,n=e;break r}if(n=a+-1|0,10==(0|Xr[e+n>>0]))break;a=n}if((t=0|Ui[7&Kr[i+36>>2]](i,e,a))>>>0<a>>>0)break e;_=a,n=e+a|0,r=r-a|0,t=0|Kr[o>>2]}else _=0,n=e}while(0);D(0|t,0|n,0|r),Kr[o>>2]=(0|Kr[o>>2])+r,t=_+r|0}}while(0);return 0|t}function W(e,r,i){e|=0,r|=0,i|=0;do{if(e){if(r>>>0<128){Xr[e>>0]=r,e=1;break}if(i=188+(0|br())|0,!(0|Kr[Kr[i>>2]>>2])){if(57216==(-128&r|0)){Xr[e>>0]=r,e=1;break}e=0|hr(),Kr[e>>2]=84,e=-1;break}if(r>>>0<2048){Xr[e>>0]=r>>>6|192,Xr[e+1>>0]=63&r|128,e=2;break}if(r>>>0<55296|57344==(-8192&r|0)){Xr[e>>0]=r>>>12|224,Xr[e+1>>0]=r>>>6&63|128,Xr[e+2>>0]=63&r|128,e=3;break}if((r+-65536|0)>>>0<1048576){Xr[e>>0]=r>>>18|240,Xr[e+1>>0]=r>>>12&63|128,Xr[e+2>>0]=r>>>6&63|128,Xr[e+3>>0]=63&r|128,e=4;break}e=0|hr(),Kr[e>>2]=84,e=-1;break}e=1}while(0);return 0|e}function Z(){var e=0,r=0,i=0,t=0,n=0,_=0,a=0,o=0;n=_i,_i=_i+48|0,a=n+32|0,i=n+24|0,o=n+16|0,_=n,n=n+36|0,e=0|ye(),(0|e?0|(t=0|Kr[e>>2]):0)&&(e=t+48|0,r=0|Kr[e>>2],e=0|Kr[e+4>>2],1126902528==(-256&r|0)&1129074247==(0|e)||(Kr[i>>2]=4168,Ke(4118,i)),e=1126902529==(0|r)&1129074247==(0|e)?0|Kr[t+44>>2]:t+80|0,Kr[n>>2]=e,t=0|Kr[t>>2],e=0|Kr[t+4>>2],0|Ui[7&Kr[16+(0|Kr[2])>>2]](8,t,n)?(o=0|Kr[n>>2],o=0|mi[1&Kr[8+(0|Kr[o>>2])>>2]](o),Kr[_>>2]=4168,Kr[_+4>>2]=e,Kr[_+8>>2]=o,Ke(4032,_)):(Kr[o>>2]=4168,Kr[o+4>>2]=e,Ke(4077,o))),Ke(4156,a)}function z(e){e|=0;var r=0,i=0,t=0,n=0,_=0;_=_i,_i=_i+544|0,n=_+16|0,i=_,t=_+32|0,r=0|Kr[e+20>>2];do{if(0|r){if(w(r),7&r){Kr[i>>2]=866,Kr[i+4>>2]=2506,Kr[i+8>>2]=1232,He(t,812,i),le(t);break}_e(r,0,0,1,0);break}}while(0);if(r=e+4|0,!(i=0|Kr[r>>2]))return n=e+16|0,Xr[n>>0]=0,void(_i=_);7&i?(Kr[n>>2]=866,Kr[n+4>>2]=2506,Kr[n+8>>2]=1232,He(t,812,n),le(t)):_e(i,0,0,1,0),Kr[r>>2]=0,Kr[e+8>>2]=0,Kr[e+12>>2]=0,n=e+16|0,Xr[n>>0]=0,_i=_}function j(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0,a=0,o=0,E=0;return E=_i,_i=_i+560|0,o=E+32|0,a=E+16|0,i=E,_=E+48|0,n=E+44|0,t=e+3&-4,(t=0|t?t:4)>>>0>2147418112?(Kr[i>>2]=866,Kr[i+4>>2]=2506,Kr[i+8>>2]=1103,He(_,812,i),le(_),o=0,_i=E,0|o):(Kr[n>>2]=t,e=0|_e(0,t,n,1,0),i=0|Kr[n>>2],0|r&&(Kr[r>>2]=i),0==(0|e)|i>>>0<t>>>0?(Kr[a>>2]=866,Kr[a+4>>2]=2506,Kr[a+8>>2]=1129,He(_,812,a),le(_),e=0):7&e&&(Kr[o>>2]=866,Kr[o+4>>2]=2533,Kr[o+8>>2]=1156,He(_,812,o),le(_)),o=e,_i=E,0|o)}function J(e){e|=0;var r=0,i=0,t=0,n=0,_=0,a=0;if(a=_i,_i=_i+544|0,_=a+16|0,t=a,n=a+32|0,Kr[e>>2]=0,r=e+4|0,i=0|Kr[r>>2],0|i&&(7&i?(Kr[t>>2]=866,Kr[t+4>>2]=2506,Kr[t+8>>2]=1232,He(n,812,t),le(n)):_e(i,0,0,1,0),Kr[r>>2]=0,Kr[e+8>>2]=0,Kr[e+12>>2]=0),Xr[e+16>>0]=0,e=e+20|0,!(r=0|Kr[e>>2]))return void(_i=a);w(r),7&r?(Kr[_>>2]=866,Kr[_+4>>2]=2506,Kr[_+8>>2]=1232,He(n,812,_),le(n)):_e(r,0,0,1,0),Kr[e>>2]=0,_i=a}function Q(e,r,i,t){e|=0,r|=0,i|=0,t|=0;var n=0,_=0,a=0,o=0,E=0,u=0,f=0;f=_i,_i=_i+128|0,n=f+124|0,u=f,_=u,a=604,o=_+124|0;do{Kr[_>>2]=Kr[a>>2],_=_+4|0,a=a+4|0}while((0|_)<(0|o));return(r+-1|0)>>>0>2147483646?r?(r=0|hr(),Kr[r>>2]=75,r=-1):(e=n,r=1,E=4):E=4,4==(0|E)&&(E=-2-e|0,E=r>>>0>E>>>0?E:r,Kr[u+48>>2]=E,n=u+20|0,Kr[n>>2]=e,Kr[u+44>>2]=e,r=e+E|0,e=u+16|0,Kr[e>>2]=r,Kr[u+28>>2]=r,r=0|v(u,i,t),E&&(u=0|Kr[n>>2],Xr[u+(((0|u)==(0|Kr[e>>2]))<<31>>31)>>0]=0)),_i=f,0|r}function q(e,r,i,t){e|=0,r|=0,i|=0,t|=0;var n=0,_=0,a=0,o=0,E=0,u=0;return u=_i,_i=_i+560|0,E=u+32|0,_=u+16|0,n=u,a=u+48|0,o=u+44|0,7&e|0?(Kr[n>>2]=866,Kr[n+4>>2]=2506,Kr[n+8>>2]=1210,He(a,812,n),le(a),E=0,_i=u,0|E):r>>>0>2147418112?(Kr[_>>2]=866,Kr[_+4>>2]=2506,Kr[_+8>>2]=1103,He(a,812,_),le(a),E=0,_i=u,0|E):(Kr[o>>2]=r,e=0|_e(e,r,o,t,0),0|i&&(Kr[i>>2]=Kr[o>>2]),7&e|0&&(Kr[E>>2]=866,Kr[E+4>>2]=2558,Kr[E+8>>2]=1156,He(a,812,E),le(a)),E=e,_i=u,0|E)}function $(e,r,i,t,n){e|=0,r|=0,i|=0,t|=0,n|=0;var _=0;do{if(0|Er(e,0|Kr[r+8>>2],n))Ue(0,r,i,t);else if(0|Er(e,0|Kr[r>>2],n)){if(e=r+32|0,(0|Kr[r+16>>2])!=(0|i)?(_=r+20|0,(0|Kr[_>>2])!=(0|i)):0){Kr[e>>2]=t,Kr[_>>2]=i,t=r+40|0,Kr[t>>2]=1+(0|Kr[t>>2]),(1==(0|Kr[r+36>>2])?2==(0|Kr[r+24>>2]):0)&&(Xr[r+54>>0]=1),Kr[r+44>>2]=4;break}1==(0|t)&&(Kr[e>>2]=1)}}while(0)}function ee(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0,a=0;if(_=e+i|0,r&=255,(0|i)>=67){for(;3&e;)Xr[e>>0]=r,e=e+1|0;for(t=-4&_|0,n=t-64|0,a=r|r<<8|r<<16|r<<24;(0|e)<=(0|n);)Kr[e>>2]=a,Kr[e+4>>2]=a,Kr[e+8>>2]=a,Kr[e+12>>2]=a,Kr[e+16>>2]=a,Kr[e+20>>2]=a,Kr[e+24>>2]=a,Kr[e+28>>2]=a,Kr[e+32>>2]=a,Kr[e+36>>2]=a,Kr[e+40>>2]=a,Kr[e+44>>2]=a,Kr[e+48>>2]=a,Kr[e+52>>2]=a,Kr[e+56>>2]=a,Kr[e+60>>2]=a,e=e+64|0;for(;(0|e)<(0|t);)Kr[e>>2]=a,e=e+4|0}for(;(0|e)<(0|_);)Xr[e>>0]=r,e=e+1|0;return _-i|0}function re(e,r,i,t,n){e|=0,r|=0,i|=0,t|=0,n|=0;var _=0,a=0,o=0,E=0;Xr[r+53>>0]=1;do{if((0|Kr[r+4>>2])==(0|t)){if(Xr[r+52>>0]=1,t=r+16|0,_=0|Kr[t>>2],o=r+54|0,E=r+48|0,a=r+24|0,e=r+36|0,!_){if(Kr[t>>2]=i,Kr[a>>2]=n,Kr[e>>2]=1,!(1==(0|Kr[E>>2])&1==(0|n)))break;Xr[o>>0]=1;break}if((0|_)!=(0|i)){Kr[e>>2]=1+(0|Kr[e>>2]),Xr[o>>0]=1;break}e=0|Kr[a>>2],2==(0|e)&&(Kr[a>>2]=n,e=n),1==(0|Kr[E>>2])&1==(0|e)&&(Xr[o>>0]=1)}}while(0)}function ie(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0,a=0;if(a=_i,_i=_i+64|0,n=a,0|Er(e,r,0))r=1;else if(0!=(0|r)?0!=(0|(_=0|k(r,32,16,0))):0){r=n+4|0,t=r+52|0;do{Kr[r>>2]=0,r=r+4|0}while((0|r)<(0|t));Kr[n>>2]=_,Kr[n+8>>2]=e,Kr[n+12>>2]=-1,Kr[n+48>>2]=1,ki[3&Kr[28+(0|Kr[_>>2])>>2]](_,n,0|Kr[i>>2],1),1==(0|Kr[n+24>>2])?(Kr[i>>2]=Kr[n+16>>2],r=1):r=0}else r=0;return _i=a,0|r}function te(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0,a=0,o=0,E=0;E=_i,_i=_i+16|0,a=E,o=255&r,Xr[a>>0]=o,t=e+16|0,n=0|Kr[t>>2],n?_=4:0|de(e)?i=-1:(n=0|Kr[t>>2],_=4);do{if(4==(0|_)){if(_=e+20|0,t=0|Kr[_>>2],t>>>0<n>>>0?(0|(i=255&r))!=(0|Xr[e+75>>0]):0){Kr[_>>2]=t+1,Xr[t>>0]=o;break}i=1==(0|Ui[7&Kr[e+36>>2]](e,a,1))?0|Zr[a>>0]:-1}}while(0);return _i=E,0|i}function ne(e,r){e|=0,r|=0;var i=0,t=0,n=0,_=0,a=0,o=0,E=0;o=255&e,i=255&e,((0|Kr[r+76>>2])>=0?0!=(0|kr(r)):0)?(((0|i)!=(0|Xr[r+75>>0])?(_=r+20|0,(a=0|Kr[_>>2])>>>0<(0|Kr[r+16>>2])>>>0):0)?(Kr[_>>2]=a+1,Xr[a>>0]=o):i=0|te(r,e),vr(r)):E=3;do{if(3==(0|E)){if((0|i)!=(0|Xr[r+75>>0])?(t=r+20|0,(n=0|Kr[t>>2])>>>0<(0|Kr[r+16>>2])>>>0):0){Kr[t>>2]=n+1,Xr[n>>0]=o;break}i=0|te(r,e)}}while(0);return 0|i}function _e(e,r,i,t,_){e|=0,r|=0,i|=0,t|=0,_|=0;do{if(e){if(!r){if(T(e),!i){r=0;break}Kr[i>>2]=0,r=0;break}t?(r=0|fe(e,r),e=0==(0|r)?e:r):r=0,i&&(_=0|Ge(e),Kr[i>>2]=_)}else r=0|n(r),i&&(e=r?0|Ge(r):0,Kr[i>>2]=e)}while(0);return 0|r}function ae(e){e|=0;var r=0,i=0,t=0;t=e;e:do{if(3&t)for(r=t;;){if(!(0|Xr[e>>0])){e=r;break e}if(e=e+1|0,!(3&(r=e))){i=4;break}}else i=4}while(0);if(4==(0|i)){for(;;){if((-2139062144&(r=0|Kr[e>>2])^-2139062144)&r+-16843009)break;e=e+4|0}if((255&r)<<24>>24)do{e=e+1|0}while(0!=(0|Xr[e>>0]))}return e-t|0}function oe(e,r){e=+e,r|=0;var i=0,t=0,n=0;switch(ri[ni>>3]=e,i=0|Kr[ni>>2],t=0|Kr[ni+4>>2],2047&(n=0|xe(0|i,0|t,52))){case 0:0!=e?(e=+oe(0x10000000000000000*e,r),i=(0|Kr[r>>2])-64|0):i=0,Kr[r>>2]=i;break;case 2047:break;default:Kr[r>>2]=(2047&n)-1022,Kr[ni>>2]=i,Kr[ni+4>>2]=-2146435073&t|1071644672,e=+ri[ni>>3]}return+e}function Ee(e,r){e|=0,r|=0;var i=0,t=0;for(t=0;;){if((0|Zr[2140+t>>0])==(0|e)){e=2;break}if(87==(0|(i=t+1|0))){i=2228,t=87,e=5;break}t=i}if(2==(0|e)&&(t?(i=2228,e=5):i=2228),5==(0|e))for(;;){do{e=i,i=i+1|0}while(0!=(0|Xr[e>>0]));if(!(t=t+-1|0))break;e=5}return 0|Nr(i,0|Kr[r+20>>2])}function ue(e,r,i){e|=0,r|=0,i|=0;var t=0;if(r>>>0>0|0==(0|r)&e>>>0>4294967295){for(;;){if(t=0|me(0|e,0|r,10,0),i=i+-1|0,Xr[i>>0]=255&t|48,t=e,e=0|fr(0|e,0|r,10,0),!(r>>>0>9|9==(0|r)&t>>>0>4294967295))break;r=fi}r=e}else r=e;if(r)for(;;){if(i=i+-1|0,Xr[i>>0]=48|(r>>>0)%10,r>>>0<10)break;r=(r>>>0)/10|0}return 0|i}function fe(e,r){e|=0,r|=0;var i=0,t=0;return e?r>>>0>4294967231?(r=0|hr(),Kr[r>>2]=12,0|(r=0)):0|(i=0|M(e+-8|0,r>>>0<11?16:r+11&-8))?0|(r=i+8|0):(i=0|n(r))?(t=0|Kr[e+-4>>2],t=(-8&t)-(0==(3&t|0)?8:4)|0,D(0|i,0|e,0|(t>>>0<r>>>0?t:r)),T(e),0|(r=i)):0|(r=0):0|(r=0|n(r))}function Te(e,r,i,t){e|=0,r|=0,i|=0,t|=0;var n=0,_=0,a=0;e=r+16|0,n=0|Kr[e>>2],_=r+36|0,a=r+24|0;do{if(n){if((0|n)!=(0|i)){Kr[_>>2]=1+(0|Kr[_>>2]),Kr[a>>2]=2,Xr[r+54>>0]=1;break}2==(0|Kr[a>>2])&&(Kr[a>>2]=t)}else Kr[e>>2]=i,Kr[a>>2]=t,Kr[_>>2]=1}while(0)}function le(e){e|=0;var r=0,i=0,t=0,n=0;t=0|Kr[119],n=(0|Kr[t+76>>2])>-1?0|kr(t):0;do{if((0|ir(e,t))<0)e=1;else{if(10!=(0|Xr[t+75>>0])?(r=t+20|0,(i=0|Kr[r>>2])>>>0<(0|Kr[t+16>>2])>>>0):0){Kr[r>>2]=i+1,Xr[i>>0]=10,e=0;break}e=(0|te(t,10))<0}}while(0);return 0|n&&vr(t),e<<31>>31|0}function ce(e,r,i,t,n,_){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0,0|Er(e,0|Kr[r+8>>2],_)?re(0,r,i,t,n):(e=0|Kr[e+8>>2],vi[3&Kr[20+(0|Kr[e>>2])>>2]](e,r,i,t,n,_))}function Ae(e,r,i,t,n){e|=0,r|=0,i|=0,t|=0,n|=0;var _=0,a=0;if(a=_i,_i=_i+256|0,_=a,(0|i)>(0|t)&0==(73728&n|0)){if(n=i-t|0,ee(0|_,0|r,0|(n>>>0<256?n:256)),n>>>0>255){r=i-t|0;do{tr(e,_,256),n=n+-256|0}while(n>>>0>255);n=255&r}tr(e,_,n)}_i=a}function Re(e,r,i,t){e|=0,r|=0,i|=0,t|=0,0|Er(e,0|Kr[r+8>>2],0)?Te(0,r,i,t):(e=0|Kr[e+8>>2],ki[3&Kr[28+(0|Kr[e>>2])>>2]](e,r,i,t))}function se(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0,_=0;return n=_i,_i=_i+32|0,_=n,t=n+20|0,Kr[_>>2]=Kr[e+60>>2],Kr[_+4>>2]=0,Kr[_+8>>2]=r,Kr[_+12>>2]=t,Kr[_+16>>2]=i,(0|$e(0|Li(140,0|_)))<0?(Kr[t>>2]=-1,e=-1):e=0|Kr[t>>2],_i=n,0|e}function de(e){e|=0;var r=0,i=0;return r=e+74|0,i=0|Xr[r>>0],Xr[r>>0]=i+255|i,r=0|Kr[e>>2],8&r?(Kr[e>>2]=32|r,e=-1):(Kr[e+8>>2]=0,Kr[e+4>>2]=0,i=0|Kr[e+44>>2],Kr[e+28>>2]=i,Kr[e+20>>2]=i,Kr[e+16>>2]=i+(0|Kr[e+48>>2]),e=0),0|e}function Me(e,r){e|=0,r|=0;var i=0,t=0;if(i=0|Xr[e>>0],t=0|Xr[r>>0],i<<24>>24==0?1:i<<24>>24!=t<<24>>24)e=t;else{do{e=e+1|0,r=r+1|0,i=0|Xr[e>>0],t=0|Xr[r>>0]}while(!(i<<24>>24==0?1:i<<24>>24!=t<<24>>24));e=t}return(255&i)-(255&e)|0}function Se(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0;return n=_i,_i=_i+32|0,t=n,Kr[e+36>>2]=1,(0==(64&Kr[e>>2]|0)?(Kr[t>>2]=Kr[e+60>>2],Kr[t+4>>2]=21523,Kr[t+8>>2]=n+16,0|Mi(54,0|t)):0)&&(Xr[e+75>>0]=-1),t=0|B(e,r,i),_i=n,0|t}function Ne(e){e|=0;var r=0,i=0;return i=e+15&-16|0,r=0|Kr[ti>>2],e=r+i|0,(0|i)>0&(0|e)<(0|r)|(0|e)<0?(si(),Ii(12),-1):(Kr[ti>>2]=e,((0|e)>(0|Ri())?0==(0|Ai()):0)?(Kr[ti>>2]=r,Ii(12),-1):0|r)}function Ie(e,r,i,t){e|=0,r|=0,i|=0,t|=0;var n=0,_=0;return n=0|Ti(i,r),i=0==(0|r)?0:i,(0|Kr[t+76>>2])>-1?(_=0==(0|kr(t)),e=0|K(e,n,t),_||vr(t)):e=0|K(e,n,t),(0|e)!=(0|n)&&(i=(e>>>0)/(r>>>0)|0),0|i}function Oe(e,r,i,t,n,_){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0,0|Er(e,0|Kr[r+8>>2],_)&&re(0,r,i,t,n)}function Ce(e,r,i,t){e|=0,r|=0,i|=0,t|=0,0|Er(e,0|Kr[r+8>>2],0)&&Te(0,r,i,t)}function Pe(e){e|=0;var r=0,i=0,t=0;if(i=0|Kr[e>>2],(t=(0|Xr[i>>0])-48|0)>>>0<10){r=0;do{r=t+(10*r|0)|0,i=i+1|0,Kr[e>>2]=i,t=(0|Xr[i>>0])-48|0}while(t>>>0<10)}else r=0;return 0|r}function he(e,r,i,t){if(e|=0,r|=0,i|=0,t|=0,!(0==(0|e)&0==(0|r)))do{i=i+-1|0,Xr[i>>0]=0|Zr[2122+(15&e)>>0]|t,e=0|xe(0|e,0|r,4),r=fi}while(!(0==(0|e)&0==(0|r)));return 0|i}function Le(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0;return n=_i,_i=_i+16|0,t=n,Kr[t>>2]=Kr[i>>2],e=0|Ui[7&Kr[16+(0|Kr[e>>2])>>2]](e,r,t),e&&(Kr[i>>2]=Kr[t>>2]),_i=n,1&e|0}function be(e){e|=0;var r=0;return(0|(r=0|Xr[oi+(255&e)>>0]))<8?0|r:(0|(r=0|Xr[oi+(e>>8&255)>>0]))<8?r+8|0:(r=0|Xr[oi+(e>>16&255)>>0],(0|r)<8?r+16|0:24+(0|Xr[oi+(e>>>24)>>0])|0)}function Ue(e,r,i,t){e|=0,r|=0,i|=0,t|=0;var n=0;((0|Kr[r+4>>2])==(0|i)?(n=r+28|0,1!=(0|Kr[n>>2])):0)&&(Kr[n>>2]=t)}function Fe(e,r,i){if(e|=0,r|=0,i|=0,!(0==(0|e)&0==(0|r)))do{i=i+-1|0,Xr[i>>0]=7&e|48,e=0|xe(0|e,0|r,3),r=fi}while(!(0==(0|e)&0==(0|r)));return 0|i}function De(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0;return t=e+20|0,n=0|Kr[t>>2],e=(0|Kr[e+16>>2])-n|0,e=e>>>0>i>>>0?i:e,D(0|n,0|r,0|e),Kr[t>>2]=(0|Kr[t>>2])+e,0|i}function me(e,r,i,t){e|=0,r|=0,i|=0,t|=0;var n=0,_=0;return _=_i,_i=_i+16|0,n=0|_,d(e,r,i,t,n),_i=_,0|(fi=0|Kr[n+4>>2],0|Kr[n>>2])}function Be(e,r){e|=0,r|=0;var i=0,t=0;return t=_i,_i=_i+48|0,i=t,Kr[i>>2]=40,G(e,r,i),_i=t,0|Kr[i+32>>2]}function pe(e,r){e|=0,r|=0;var i=0,t=0;return t=_i,_i=_i+48|0,i=t,Kr[i>>2]=40,G(e,r,i),_i=t,0|Kr[i+12>>2]}function ve(e,r){e|=0,r|=0;var i=0,t=0;return t=_i,_i=_i+48|0,i=t,Kr[i>>2]=40,G(e,r,i),_i=t,0|Kr[i+8>>2]}function ke(e,r){e|=0,r|=0;var i=0,t=0;return t=_i,_i=_i+48|0,i=t,Kr[i>>2]=40,G(e,r,i),_i=t,0|Kr[i+4>>2]}function ye(){var e=0,r=0;return e=_i,_i=_i+16|0,0|Ci(5136,2)?(Ke(4307,e),0):(r=0|di(0|Kr[1285]),_i=e,0|r)}function ge(e){e|=0;var r=0,i=0;return r=_i,_i=_i+16|0,i=r,e=0|mr(0|Kr[e+60>>2]),Kr[i>>2]=e,e=0|$e(0|Ni(6,0|i)),_i=r,0|e}function we(e){e|=0;var r=0;if(r=_i,_i=_i+16|0,T(e),!(0|Si(0|Kr[1285],0)))return void(_i=r);Ke(4406,r)}function Ge(e){e|=0;var r=0;return e?(r=0|Kr[e+-4>>2],e=3&r,0|(1==(0|e)?0:(-8&r)-(0==(0|e)?8:4)|0)):0}function He(e,r,i){e|=0,r|=0,i|=0;var t=0,n=0;return t=_i,_i=_i+16|0,n=t,Kr[n>>2]=i,i=0|Ar(e,r,n),_i=t,0|i}function Xe(e,r,i,t,n,_,a){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0,a|=0,vi[3&e](0|r,0|i,0|t,0|n,0|_,0|a)}function Ve(){var e=0;if(e=_i,_i=_i+16|0,!(0|hi(5140,6)))return void(_i=e);Ke(4356,e)}function Ye(e,r,i){return e|=0,r|=0,(0|(i|=0))<32?(fi=r<<i|(e&(1<<i)-1<<32-i)>>>32-i,e<<i):(fi=e<<i-32,0)}function xe(e,r,i){return e|=0,r|=0,(0|(i|=0))<32?(fi=r>>>i,e>>>i|(r&(1<<i)-1)<<32-i):(fi=0,r>>>i-32|0)}function Ke(e,r){e|=0,r|=0;var i=0;i=_i,_i=_i+16|0,Kr[i>>2]=r,r=0|Kr[26],v(r,e,i),ne(10,r),Oi()}function We(){}function Ze(e,r,i,t){return e|=0,r|=0,i|=0,t|=0,t=r-t-(i>>>0>e>>>0|0)>>>0,0|(fi=t,e-i>>>0|0)}function ze(e,r){return e|=0,r|=0,r=r?0|g(0|Kr[r>>2],0|Kr[r+4>>2],e):0,0|(0|r?r:e)}function je(e,r,i,t,n,_){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0,Fi[3&e](0|r,0|i,0|t,0|n,0|_)}function Je(e){e=+e;var r=0;return ri[ni>>3]=e,r=0|Kr[ni>>2],fi=0|Kr[ni+4>>2],0|r}function Qe(e,r,i,t){return e|=0,r|=0,i|=0,t|=0,i=e+i>>>0,0|(fi=r+t+(i>>>0<e>>>0|0)>>>0,0|i)}function qe(e,r,i,t,n){e|=0,r|=0,i|=0,t|=0,n|=0,ki[3&e](0|r,0|i,0|t,0|n)}function $e(e){e|=0;var r=0;return e>>>0>4294963200&&(r=0|hr(),Kr[r>>2]=0-e,e=-1),0|e}function er(e){return e|=0,1&(e=e?0!=(0|k(e,32,88,0)):0)|0}function rr(e,r,i,t){return e|=0,r|=0,i|=0,t|=0,0|Ui[7&e](0|r,0|i,0|t)}function ir(e,r){e|=0,r|=0;var i=0;return i=0|ae(e),((0|Ie(e,1,i,r))!=(0|i))<<31>>31|0}function tr(e,r,i){e|=0,r|=0,i|=0,32&Kr[e>>2]||K(r,i,e)}function nr(e,r,i,t){e|=0,r|=0,i|=0,t|=0,Bi[0&e](0|r,0|i,0|t)}function _r(e){e|=0;var r=0;return r=_i,_i=_i+e|0,_i=_i+15&-16,0|r}function ar(e){e|=0;var r=0;return r=188+(0|br())|0,0|Ee(e,0|Kr[r>>2])}function or(e,r){return e|=0,r|=0,0|(e=e?0|W(e,r,0):0)}function Er(e,r,i){return e|=0,r|=0,i|=0,(0|e)==(0|r)|0}function ur(e,r){e|=0,r|=0;var i=0;return i=0|Tr(0|e),0|(0==(0|r)?e:i)}function fr(e,r,i,t){return e|=0,r|=0,i|=0,t|=0,0|d(e,r,i,t,0)}function Tr(e){return(255&(e|=0))<<24|(e>>8&255)<<16|(e>>16&255)<<8|e>>>24|0}function lr(e,r,i,t,n,_){e|=0,r|=0,i|=0,t|=0,n|=0,_|=0,ci(6)}function cr(e,r){e|=0,r|=0,Ei||(Ei=e,ui=r)}function Ar(e,r,i){return e|=0,r|=0,i|=0,0|Q(e,2147483647,r,i)}function Rr(e,r,i,t,n){e|=0,r|=0,i|=0,t|=0,n|=0,ci(1)}function sr(e){e|=0,vr(e),Fr(e)}function dr(e,r){return e|=0,r|=0,0|mi[1&e](0|r)}function Mr(e,r){e|=0,r|=0,_i=e,ai=r}function Sr(e,r,i,t){e|=0,r|=0,i|=0,t|=0,ci(7)}function Nr(e,r){return e|=0,r|=0,0|ze(e,r)}function Ir(e,r){e|=0,r|=0,Di[7&e](0|r)}function Or(e,r,i){return e|=0,r|=0,i|=0,ci(0),0}function Cr(e,r){return e=+e,r|=0,+ +oe(e,r)}function Pr(e,r,i){e|=0,r|=0,i|=0,ci(4)}function hr(){return 64+(0|br())|0}function Lr(e){e|=0,pi[3&e]()}function br(){return 232}function Ur(e){e|=0,_i=e}function Fr(e){e|=0,T(e)}function Dr(e){e|=0,fi=e}function mr(e){return 0|(e|=0)}function Br(){return 5072}function pr(e){return e|=0,ci(3),0}function vr(e){e|=0}function kr(e){return e|=0,0}function yr(){return 0|fi}function gr(){return 0|_i}function wr(e){e|=0,ci(2)}function Gr(){ci(5)}var Hr=e.Int8Array,Xr=new Hr(i),Vr=e.Int16Array,Yr=new Vr(i),xr=e.Int32Array,Kr=new xr(i),Wr=e.Uint8Array,Zr=new Wr(i),zr=e.Uint16Array,jr=new zr(i),Jr=e.Uint32Array,Qr=new Jr(i),qr=e.Float32Array,$r=new qr(i),ei=e.Float64Array,ri=new ei(i),ii=e.byteLength,ti=0|r.DYNAMICTOP_PTR,ni=0|r.tempDoublePtr,_i=(r.ABORT,0|r.STACKTOP),ai=0|r.STACK_MAX,oi=0|r.cttz_i8,Ei=0,ui=0,fi=(e.NaN,e.Infinity,0),Ti=(e.Math.floor,e.Math.abs,e.Math.sqrt,e.Math.pow,e.Math.cos,e.Math.sin,e.Math.tan,e.Math.acos,e.Math.asin,e.Math.atan,e.Math.atan2,e.Math.exp,e.Math.log,e.Math.ceil,e.Math.imul),li=(e.Math.min,e.Math.max,e.Math.clz32),ci=r.abort,Ai=(r.assert,r.enlargeMemory),Ri=r.getTotalMemory,si=r.abortOnCannotGrowMemory,di=(r.invoke_iiii,r.invoke_viiiii,r.invoke_vi,r.invoke_ii,r.invoke_viii,r.invoke_v,r.invoke_viiiiii,r.invoke_viiii,r._pthread_getspecific),Mi=r.___syscall54,Si=r._pthread_setspecific,Ni=(r.___gxx_personality_v0,r.___syscall6),Ii=r.___setErrNo,Oi=r._abort,Ci=(r.___cxa_begin_catch,r._pthread_once),Pi=r._emscripten_memcpy_big,hi=r._pthread_key_create,Li=r.___syscall140,bi=(r.___resumeException,r.___cxa_find_matching_catch,r.___syscall146),Ui=(r.__ZSt18uncaught_exceptionv,[Or,B,se,Se,De,ie,Or,Or]),Fi=[Rr,$,p,Rr],Di=[wr,vr,sr,vr,vr,sr,we,wr],mi=[pr,ge],Bi=[Pr],pi=[Gr,Z,Ve,Gr],vi=[lr,Oe,ce,lr],ki=[Sr,Ce,Re,Sr];return{stackSave:gr,_i64Subtract:Ze,_crn_get_bytes_per_block:U,setThrew:cr,dynCall_viii:nr,_bitshift64Lshr:xe,_bitshift64Shl:Ye,dynCall_viiii:qe,setTempRet0:Dr,_crn_decompress:S,_memset:ee,_sbrk:Ne,_memcpy:D,stackAlloc:_r,_crn_get_height:ve,dynCall_vi:Ir,getTempRet0:yr,_crn_get_levels:pe,_crn_get_uncompressed_size:b,_i64Add:Qe,dynCall_iiii:rr,_emscripten_get_global_libc:Br,dynCall_ii:dr,___udivdi3:fr,_llvm_bswap_i32:Tr,dynCall_viiiii:je,___cxa_can_catch:Le,_free:T,runPostSets:We,dynCall_viiiiii:Xe,establishStackSpace:Mr,___uremdi3:me,___cxa_is_pointer_type:er,stackRestore:Ur,_malloc:n,_emscripten_replace_memory:t,dynCall_v:Lr,_crn_get_width:ke,_crn_get_dxt_format:Be}}(Module.asmGlobalArg,Module.asmLibraryArg,buffer),stackSave=Module.stackSave=asm.stackSave,getTempRet0=Module.getTempRet0=asm.getTempRet0,_memset=Module._memset=asm._memset,setThrew=Module.setThrew=asm.setThrew,_bitshift64Lshr=Module._bitshift64Lshr=asm._bitshift64Lshr,_bitshift64Shl=Module._bitshift64Shl=asm._bitshift64Shl,setTempRet0=Module.setTempRet0=asm.setTempRet0,_crn_decompress=Module._crn_decompress=asm._crn_decompress,_crn_get_bytes_per_block=Module._crn_get_bytes_per_block=asm._crn_get_bytes_per_block,_sbrk=Module._sbrk=asm._sbrk,_memcpy=Module._memcpy=asm._memcpy,stackAlloc=Module.stackAlloc=asm.stackAlloc,_crn_get_height=Module._crn_get_height=asm._crn_get_height,_i64Subtract=Module._i64Subtract=asm._i64Subtract,_crn_get_levels=Module._crn_get_levels=asm._crn_get_levels,_crn_get_uncompressed_size=Module._crn_get_uncompressed_size=asm._crn_get_uncompressed_size,_i64Add=Module._i64Add=asm._i64Add,_emscripten_get_global_libc=Module._emscripten_get_global_libc=asm._emscripten_get_global_libc,___udivdi3=Module.___udivdi3=asm.___udivdi3,_llvm_bswap_i32=Module._llvm_bswap_i32=asm._llvm_bswap_i32,___cxa_can_catch=Module.___cxa_can_catch=asm.___cxa_can_catch,_free=Module._free=asm._free,runPostSets=Module.runPostSets=asm.runPostSets,establishStackSpace=Module.establishStackSpace=asm.establishStackSpace,___uremdi3=Module.___uremdi3=asm.___uremdi3,___cxa_is_pointer_type=Module.___cxa_is_pointer_type=asm.___cxa_is_pointer_type,stackRestore=Module.stackRestore=asm.stackRestore,_malloc=Module._malloc=asm._malloc,_emscripten_replace_memory=Module._emscripten_replace_memory=asm._emscripten_replace_memory,_crn_get_width=Module._crn_get_width=asm._crn_get_width,_crn_get_dxt_format=Module._crn_get_dxt_format=asm._crn_get_dxt_format,dynCall_iiii=Module.dynCall_iiii=asm.dynCall_iiii,dynCall_viiiii=Module.dynCall_viiiii=asm.dynCall_viiiii,dynCall_vi=Module.dynCall_vi=asm.dynCall_vi,dynCall_ii=Module.dynCall_ii=asm.dynCall_ii,dynCall_viii=Module.dynCall_viii=asm.dynCall_viii,dynCall_v=Module.dynCall_v=asm.dynCall_v,dynCall_viiiiii=Module.dynCall_viiiiii=asm.dynCall_viiiiii,dynCall_viiii=Module.dynCall_viiii=asm.dynCall_viiii;Runtime.stackAlloc=Module.stackAlloc,Runtime.stackSave=Module.stackSave,Runtime.stackRestore=Module.stackRestore,Runtime.establishStackSpace=Module.establishStackSpace,Runtime.setTempRet0=Module.setTempRet0,Runtime.getTempRet0=Module.getTempRet0,Module.asm=asm,ExitStatus.prototype=new Error,ExitStatus.prototype.constructor=ExitStatus;var initialStackTop,preloadStartTime=null,calledMain=!1;dependenciesFulfilled=function e(){Module.calledRun||run(),Module.calledRun||(dependenciesFulfilled=e)},Module.callMain=Module.callMain=function(e){function r(){for(var e=0;e<3;e++)t.push(0)}e=e||[],ensureInitRuntime()
;var i=e.length+1,t=[allocate(intArrayFromString(Module.thisProgram),"i8",ALLOC_NORMAL)];r();for(var n=0;n<i-1;n+=1)t.push(allocate(intArrayFromString(e[n]),"i8",ALLOC_NORMAL)),r();t.push(0),t=allocate(t,"i32",ALLOC_NORMAL);try{exit(Module._main(i,t,0),!0)}catch(e){if(e instanceof ExitStatus)return;if("SimulateInfiniteLoop"==e)return void(Module.noExitRuntime=!0);var _=e;e&&"object"==typeof e&&e.stack&&(_=[e,e.stack]),Module.printErr("exception thrown: "+_),Module.quit(1,e)}finally{calledMain=!0}},Module.run=Module.run=run,Module.exit=Module.exit=exit;var abortDecorators=[];if(Module.abort=Module.abort=abort,Module.preInit)for("function"==typeof Module.preInit&&(Module.preInit=[Module.preInit]);Module.preInit.length>0;)Module.preInit.pop()();var shouldRunNow=!0;return Module.noInitialRun&&(shouldRunNow=!1),Module.noExitRuntime=!0,run(),Module}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function r(e,r){return void 0!==e&&null!==e?e:r}return r.EMPTY_OBJECT=e({}),r}),define("Core/formatError",["./defined"],function(e){"use strict";function r(r){var i,t=r.name,n=r.message;i=e(t)&&e(n)?t+": "+n:r.toString();var _=r.stack;return e(_)&&(i+="\n"+_),i}return r}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,r,i){"use strict";function t(t){var n,_=[],a={id:void 0,result:void 0,error:void 0};return function(o){var E=o.data;_.length=0,a.id=E.id,a.error=void 0,a.result=void 0;try{a.result=t(E.parameters,_)}catch(e){e instanceof Error?a.error={name:e.name,message:e.message,stack:e.stack}:a.error=e}r(n)||(n=e(self.webkitPostMessage,self.postMessage)),E.canTransferArrayBuffer||(_.length=0);try{n(a,_)}catch(e){a.result=void 0,a.error="postMessage failed with error: "+i(e)+"\n  with responseMessage: "+JSON.stringify(a),n(a)}}}return t}),define("Workers/transcodeCRNToDXT",["../Core/CompressedTextureBuffer","../Core/defined","../Core/PixelFormat","../Core/RuntimeError","../ThirdParty/crunch","./createTaskProcessorWorker"],function(e,r,i,t,n,_){"use strict";function a(e,r,i,t){var n,_=i/4,a=t%4,o=new Uint32Array(e.buffer,0,(t-a)/4),E=new Uint32Array(r.buffer);for(n=0;n<o.length;n++)E[_+n]=o[n];for(n=t-a;n<t;n++)r[i+n]=e[n]}function o(_,o){var E=_.byteLength,c=new Uint8Array(_),A=n._malloc(E);a(c,n.HEAPU8,A,E);var R=n._crn_get_dxt_format(A,E),s=u[R];if(!r(s))throw new t("Unsupported compressed format.");var d,M=n._crn_get_levels(A,E),S=n._crn_get_width(A,E),N=n._crn_get_height(A,E),I=0;for(d=0;d<M;++d)I+=i.compressedTextureSizeInBytes(s,S>>d,N>>d);l<I&&(r(f)&&n._free(f),f=n._malloc(I),T=new Uint8Array(n.HEAPU8.buffer,f,I),l=I),n._crn_decompress(A,E,f,I,0,M),n._free(A);var O=i.compressedTextureSizeInBytes(s,S,N),C=T.subarray(0,O),P=new Uint8Array(O);return P.set(C,0),o.push(P.buffer),new e(s,S,N,P)}var E={cCRNFmtInvalid:-1,cCRNFmtDXT1:0,cCRNFmtDXT3:1,cCRNFmtDXT5:2},u={};u[E.cCRNFmtDXT1]=i.RGB_DXT1,u[E.cCRNFmtDXT3]=i.RGBA_DXT3,u[E.cCRNFmtDXT5]=i.RGBA_DXT5;var f,T,l=0;return _(o)})}();