/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var a={};return a.typeOf={},a.defined=function(n,a){if(!e(a))throw new t(r(n))},a.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},a.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},a.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},a.typeOf.number.lessThan=function(e,r,n){if(a.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},a.typeOf.number.lessThanOrEquals=function(e,r,n){if(a.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},a.typeOf.number.greaterThan=function(e,r,n){if(a.typeOf.number(e,r),r<=n)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},a.typeOf.number.greaterThanOrEquals=function(e,r,n){if(a.typeOf.number(e,r),r<n)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},a.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},a.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},a.typeOf.number.equals=function(e,r,n,i){if(a.typeOf.number(e,n),a.typeOf.number(r,i),n!==i)throw new t(e+" must be equal to "+r+", the actual values are "+n+" and "+i)},a}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e&&null!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n,a){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=r(Math.sign,function(e){return e=+e,0===e||e!==e?e:e>0?1:-1}),i.signNotZero=function(e){return e<0?-1:1},i.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*i.clamp(e,-1,1)+.5)*t)},i.fromSNorm=function(e,t){return t=r(t,255),i.clamp(e,0,t)/t*2-1},i.sinh=r(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),i.cosh=r(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=Math.PI/2,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI/2,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},i.clampToLatitudeRange=function(e){return i.clamp(e,-1*i.PI_OVER_TWO,i.PI_OVER_TWO)},i.negativePiToPi=function(e){return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){return(e%t+t)%t},i.equalsEpsilon=function(e,t,n,a){a=r(a,n);var i=Math.abs(e-t);return i<=a||i<=n*Math.max(Math.abs(e),Math.abs(t))};var o=[1];i.factorial=function(e){var t=o.length;if(e>=t)for(var r=o[t-1],n=t;n<=e;n++)o.push(r*n);return o[e]},i.incrementWrap=function(e,t,n){return n=r(n,0),++e,e>t&&(e=n),e},i.isPowerOfTwo=function(e){return 0!==e&&0==(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},i.clamp=function(e,t,r){return e<t?t:e>r?r:e};var u=new e;return i.setRandomNumberSeed=function(t){u=new e(t)},i.nextRandomNumber=function(){return u.random()},i.randomBetween=function(e,t){return i.nextRandomNumber()*(t-e)+e},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},i.logBase=function(e,t){return Math.log(e)/Math.log(t)},i.cbrt=r(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t}),i.log2=r(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),i.fog=function(e,t){var r=e*t;return 1-Math.exp(-r*r)},i.fastApproximateAtan=function(e){return e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},i.fastApproximateAtan2=function(e,t){var r,n,a=Math.abs(e);r=Math.abs(t),n=Math.max(a,r),r=Math.min(a,r);var o=r/n;return a=i.fastApproximateAtan(o),a=Math.abs(t)>Math.abs(e)?i.PI_OVER_TWO-a:a,a=e<0?i.PI-a:a,a=t<0?-a:a},i}),define("Core/arrayRemoveDuplicates",["./Check","./defaultValue","./defined","./Math"],function(e,t,r,n){"use strict";function a(e,n,a){if(r(e)){a=t(a,!1);var o=e.length;if(o<2)return e;var u,s,c;for(u=1;u<o&&(s=e[u-1],c=e[u],!n(s,c,i));++u);if(u===o)return a&&n(e[0],e[e.length-1],i)?e.slice(1):e;for(var l=e.slice(0,u);u<o;++u)c=e[u],n(s,c,i)||(l.push(c),s=c);return a&&l.length>1&&n(l[0],l[l.length-1],i)&&l.shift(),l}}var i=n.EPSILON10;return a}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(e,n){r(n)||(n=new o);var a=e.clock,i=e.cone,u=t(e.magnitude,1),s=u*Math.sin(i);return n.x=s*Math.cos(a),n.y=s*Math.sin(a),n.z=u*Math.cos(i),n},o.fromElements=function(e,t,n,a){return r(a)?(a.x=e,a.y=t,a.z=n,a):new o(e,t,n)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n]=e.z,r},o.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new o),a.x=e[n++],a.y=e[n++],a.z=e[n],a},o.packArray=function(e,t){var n=e.length;r(t)?t.length=3*n:t=new Array(3*n);for(var a=0;a<n;++a)o.pack(e[a],t,3*a);return t},o.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/3:t=new Array(n/3);for(var a=0;a<n;a+=3){var i=a/3;t[i]=o.unpack(e,a,t[i])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},o.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var r=o.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},o.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},o.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r.z=e.z/t.z,r},o.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},o.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},o.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},o.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var s=new o;o.lerp=function(e,t,r,n){return o.multiplyByScalar(t,r,s),n=o.multiplyByScalar(e,1-r,n),o.add(s,n,n)};var c=new o,l=new o;o.angleBetween=function(e,t){o.normalize(e,c),o.normalize(t,l);var r=o.dot(c,l),n=o.magnitude(o.cross(c,l,c));return Math.atan2(n,r)};var f=new o;o.mostOrthogonalAxis=function(e,t){var r=o.normalize(e,f);return o.abs(r,r),t=r.x<=r.y?r.x<=r.z?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Z,t):r.y<=r.z?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_Z,t)},o.projectVector=function(e,t,r){var n=o.dot(e,t)/o.dot(t,t);return o.multiplyByScalar(t,n,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)},o.cross=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-n*s,f=n*u-a*o;return r.x=c,r.y=l,r.z=f,r},o.fromDegrees=function(e,t,r,n,a){return e=i.toRadians(e),t=i.toRadians(t),o.fromRadians(e,t,r,n,a)};var d=new o,h=new o,p=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(e,n,a,i,u){a=t(a,0);var s=r(i)?i.radiiSquared:p,c=Math.cos(n);d.x=c*Math.cos(e),d.y=c*Math.sin(e),d.z=Math.sin(n),d=o.normalize(d,d),o.multiplyComponents(s,d,h);var l=Math.sqrt(o.dot(d,h));return h=o.divideByScalar(h,l,h),d=o.multiplyByScalar(d,a,d),r(u)||(u=new o),o.add(h,d,u)},o.fromDegreesArray=function(e,t,n){var a=e.length;r(n)?n.length=a/2:n=new Array(a/2);for(var i=0;i<a;i+=2){var u=e[i],s=e[i+1],c=i/2;n[c]=o.fromDegrees(u,s,0,t,n[c])}return n},o.fromRadiansArray=function(e,t,n){var a=e.length;r(n)?n.length=a/2:n=new Array(a/2);for(var i=0;i<a;i+=2){var u=e[i],s=e[i+1],c=i/2;n[c]=o.fromRadians(u,s,0,t,n[c])}return n},o.fromDegreesArrayHeights=function(e,t,n){var a=e.length;r(n)?n.length=a/3:n=new Array(a/3);for(var i=0;i<a;i+=3){var u=e[i],s=e[i+1],c=e[i+2],l=i/3;n[l]=o.fromDegrees(u,s,c,t,n[l])}return n},o.fromRadiansArrayHeights=function(e,t,n){var a=e.length;r(n)?n.length=a/3:n=new Array(a/3);for(var i=0;i<a;i+=3){var u=e[i],s=e[i+1],c=e[i+2],l=i/3;n[l]=o.fromRadians(u,s,c,t,n[l])}return n},o.ZERO=a(new o(0,0,0)),o.UNIT_X=a(new o(1,0,0)),o.UNIT_Y=a(new o(0,1,0)),o.UNIT_Z=a(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function a(r,a,u,s,c){var l=r.x,f=r.y,d=r.z,h=a.x,p=a.y,m=a.z,E=l*l*h*h,y=f*f*p*p,_=d*d*m*m,T=E+y+_,R=Math.sqrt(1/T),v=e.multiplyByScalar(r,R,i);if(T<s)return isFinite(R)?e.clone(v,c):void 0;var A=u.x,g=u.y,S=u.z,N=o;N.x=v.x*A*2,N.y=v.y*g*2,N.z=v.z*S*2;var w,O,I,M,x,C,P,U,D,L,b,F=(1-R)*e.magnitude(r)/(.5*e.magnitude(N)),B=0;do{F-=B,I=1/(1+F*A),M=1/(1+F*g),x=1/(1+F*S),C=I*I,P=M*M,U=x*x,D=C*I,L=P*M,b=U*x,w=E*C+y*P+_*U-1,O=E*D*A+y*L*g+_*b*S;B=w/(-2*O)}while(Math.abs(w)>n.EPSILON12);return t(c)?(c.x=l*I,c.y=f*M,c.z=d*x,c):new e(l*I,f*M,d*x)}var i=new e,o=new e;return a}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,a,i,o){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,t,a,i){return a=r(a,0),n(i)?(i.longitude=e,i.latitude=t,i.height=a,i):new u(e,t,a)},u.fromDegrees=function(e,t,r,n){return e=i.toRadians(e),t=i.toRadians(t),u.fromRadians(e,t,r,n)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),d=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),h=i.EPSILON1;return u.fromCartesian=function(t,r,a){var p=n(r)?r.oneOverRadii:f,m=n(r)?r.oneOverRadiiSquared:d,E=n(r)?r._centerToleranceSquared:h,y=o(t,p,m,E,c);if(n(y)){var _=e.multiplyComponents(y,m,s);_=e.normalize(_,_);var T=e.subtract(t,y,l),R=Math.atan2(_.y,_.x),v=Math.asin(_.z),A=i.sign(e.dot(T,t))*e.magnitude(T);return n(a)?(a.longitude=R,a.latitude=v,a.height=A,a):new u(R,v,A)}},u.toCartesian=function(t,r,n){return e.fromRadians(t.longitude,t.latitude,t.height,r,n)},u.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.longitude-t.longitude)<=r&&Math.abs(e.latitude-t.latitude)<=r&&Math.abs(e.height-t.height)<=r},u.ZERO=a(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(t,r,a,i){r=n(r,0),a=n(a,0),i=n(i,0),t._radii=new e(r,a,i),t._radiiSquared=new e(r*r,a*a,i*i),t._radiiToTheFourth=new e(r*r*r*r,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===r?0:1/r,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(r,a,i),t._maximumRadius=Math.max(r,a,i),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function f(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,l(this,e,t,r)}i(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(t,r){if(a(t)){var n=t._radii;return a(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new f(n.x,n.y,n.z)}},f.fromCartesian3=function(e,t){return a(t)||(t=new f),a(e)?(l(t,e.x,e.y,e.z),t):t},f.WGS84=u(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=u(new f(1,1,1)),f.MOON=u(new f(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(t,r,a){return a=n(a,0),e.pack(t._radii,r,a),r},f.unpack=function(t,r,a){r=n(r,0);var i=e.unpack(t,r);return f.fromCartesian3(i,a)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(t,r){var n=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(n),s=o*Math.sin(n),c=Math.sin(i);return a(r)||(r=new e),r.x=u,r.y=s,r.z=c,e.normalize(r,r)},f.prototype.geodeticSurfaceNormal=function(t,r){return a(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var d=new e,h=new e;f.prototype.cartographicToCartesian=function(t,r){var n=d,i=h;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,i);var o=Math.sqrt(e.dot(n,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(n,t.height,n),a(r)||(r=new e),e.add(i,n,r)},f.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;a(t)?t.length=r:t=new Array(r);for(var n=0;n<r;n++)t[n]=this.cartographicToCartesian(e[n],t[n]);return t};var p=new e,m=new e,E=new e;return f.prototype.cartesianToCartographic=function(r,n){var i=this.scaleToGeodeticSurface(r,m);if(a(i)){var o=this.geodeticSurfaceNormal(i,p),u=e.subtract(r,i,E),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=s.sign(e.dot(u,r))*e.magnitude(u);return a(n)?(n.longitude=c,n.latitude=l,n.height=f,n):new t(c,l,f)}},f.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;a(t)?t.length=r:t=new Array(r);for(var n=0;n<r;++n)t[n]=this.cartesianToCartographic(e[n],t[n]);return t},f.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},f.prototype.scaleToGeocentricSurface=function(t,r){a(r)||(r=new e);var n=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(n*n*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,r)},f.prototype.transformPositionToScaledSpace=function(t,r){return a(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},f.prototype.transformPositionFromScaledSpace=function(t,r){return a(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},f.prototype.equals=function(t){return this===t||a(t)&&e.equals(this._radii,t._radii)},f.prototype.toString=function(){return this._radii.toString()},f.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,r,i){r=n(r,0);var o=this._squaredXOverSquaredZ;if(a(i)||(i=new e),i.x=0,i.y=0,i.z=t.z*(1-o),!(Math.abs(i.z)>=this._radii.z-r))return i},f}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,a,i,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return n(r)?(r.x=i,r.y=o,r.z=u,r):new e(i,o,u)},u.prototype.unproject=function(e,r){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return n(r)?(r.longitude=i,r.latitude=o,r.height=u,r):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";return e({OUTSIDE:-1,INTERSECTING:0,INSIDE:1})}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,t,n,a,i,o,u,s,c){this[0]=r(e,0),this[1]=r(a,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(i,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function l(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(m[r],p[r])];t+=2*n*n}return Math.sqrt(t)}function f(e,t){for(var r=u.EPSILON15,n=0,a=1,i=0;i<3;++i){var o=Math.abs(e[s.getElementIndex(m[i],p[i])]);o>n&&(a=i,n=o)}var c=1,l=0,f=p[a],d=m[a];if(Math.abs(e[s.getElementIndex(d,f)])>r){var h,E=e[s.getElementIndex(d,d)],y=e[s.getElementIndex(f,f)],_=e[s.getElementIndex(d,f)],T=(E-y)/2/_;h=T<0?-1/(-T+Math.sqrt(1+T*T)):1/(T+Math.sqrt(1+T*T)),c=1/Math.sqrt(1+h*h),l=h*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(f,f)]=t[s.getElementIndex(d,d)]=c,t[s.getElementIndex(d,f)]=l,t[s.getElementIndex(f,d)]=-l,t}s.packedLength=9,s.pack=function(e,t,n){return n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t},s.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new s),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,t,a){return t=r(t,0),n(a)||(a=new s),a[0]=e[t],a[1]=e[t+1],a[2]=e[t+2],a[3]=e[t+3],a[4]=e[t+4],a[5]=e[t+5],a[6]=e[t+6],a[7]=e[t+7],a[8]=e[t+8],a},s.fromColumnMajorArray=function(e,t){return s.clone(e,t)},s.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,t){var r=e.x*e.x,a=e.x*e.y,i=e.x*e.z,o=e.x*e.w,u=e.y*e.y,c=e.y*e.z,l=e.y*e.w,f=e.z*e.z,d=e.z*e.w,h=e.w*e.w,p=r-u-f+h,m=2*(a-d),E=2*(i+l),y=2*(a+d),_=-r+u-f+h,T=2*(c-o),R=2*(i-l),v=2*(c+o),A=-r-u+f+h;return n(t)?(t[0]=p,t[1]=y,t[2]=R,t[3]=m,t[4]=_,t[5]=v,t[6]=E,t[7]=T,t[8]=A,t):new s(p,m,E,y,_,T,R,v,A)},s.fromHeadingPitchRoll=function(e,t){var r=Math.cos(-e.pitch),a=Math.cos(-e.heading),i=Math.cos(e.roll),o=Math.sin(-e.pitch),u=Math.sin(-e.heading),c=Math.sin(e.roll),l=r*a,f=-i*u+c*o*a,d=c*u+i*o*a,h=r*u,p=i*a+c*o*u,m=-c*a+i*o*u,E=-o,y=c*r,_=i*r;return n(t)?(t[0]=l,t[1]=h,t[2]=E,t[3]=f,t[4]=p,t[5]=y,t[6]=d,t[7]=m,t[8]=_,t):new s(l,f,d,h,p,m,E,y,_)},s.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=a,t[6]=0,t[7]=-a,t[8]=r,t):new s(1,0,0,0,r,-a,0,a,r)},s.fromRotationY=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=r,t):new s(r,0,a,0,1,0,-a,0,r)},s.fromRotationZ=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=a,t[2]=0,t[3]=-a,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new s(r,-a,0,a,r,0,0,0,1)},s.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,t){return 3*e+t},s.getColumn=function(e,t,r){var n=3*t,a=e[n],i=e[n+1],o=e[n+2];return r.x=a,r.y=i,r.z=o,r},s.setColumn=function(e,t,r,n){n=s.clone(e,n);var a=3*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n},s.getRow=function(e,t,r){var n=e[t],a=e[t+3],i=e[t+6];return r.x=n,r.y=a,r.z=i,r},s.setRow=function(e,t,r,n){return n=s.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var d=new e;s.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],d)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],d)),r};var h=new e;s.getMaximumScale=function(t){return s.getScale(t,h),e.maximumComponent(h)},s.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=a,r[2]=i,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r},s.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},s.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},s.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[3]*a+e[6]*i,u=e[1]*n+e[4]*a+e[7]*i,s=e[2]*n+e[5]*a+e[8]*i;return r.x=o,r.y=u,r.z=s,r},s.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},s.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.x,r[3]=e[3]*t.y,r[4]=e[4]*t.y,r[5]=e[5]*t.y,r[6]=e[6]*t.z,r[7]=e[7]*t.z,r[8]=e[8]*t.z,r},s.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},s.transpose=function(e,t){var r=e[0],n=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var p=[1,0,0],m=[2,2,1],E=new s,y=new s;return s.computeEigenDecomposition=function(e,t){var r=u.EPSILON20,a=0,i=0;n(t)||(t={});for(var o=t.unitary=s.clone(s.IDENTITY,t.unitary),d=t.diagonal=s.clone(e,t.diagonal),h=r*c(d);i<10&&l(d)>h;)f(d,E),s.transpose(E,y),s.multiply(d,E,d),s.multiply(y,d,d),s.multiply(o,E,o),++a>2&&(++i,a=0);return t},s.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},s.determinant=function(e){var t=e[0],r=e[3],n=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*n-r*c)+u*(r*o-i*n)},s.inverse=function(e,t){var r=e[0],n=e[1],a=e[2],i=e[3],o=e[4],u=e[5],c=e[6],l=e[7],f=e[8],d=s.determinant(e);t[0]=o*f-l*u,t[1]=l*a-n*f,t[2]=n*u-o*a,t[3]=c*u-i*f,t[4]=r*f-c*a,t[5]=i*a-r*u,t[6]=i*l-c*o,t[7]=c*n-r*l,t[8]=r*o-i*n;var h=1/d;return s.multiplyByScalar(t,h,t)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,a(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r,n,a){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(a,0)}o.fromElements=function(e,t,n,a,i){return r(i)?(i.x=e,i.y=t,i.z=n,i.w=a,i):new o(e,t,n,a)},o.fromColor=function(e,t){return r(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w)},o.packedLength=4,o.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w,r},o.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new o),a.x=e[n++],a.y=e[n++],a.z=e[n++],a.w=e[n],a},o.packArray=function(e,t){var n=e.length;r(t)?t.length=4*n:t=new Array(4*n);for(var a=0;a<n;++a)o.pack(e[a],t,4*a);return t},o.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/4:t=new Array(n/4);for(var a=0;a<n;a+=4){var i=a/4;t[i]=o.unpack(e,a,t[i])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},o.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var r=o.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},o.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},o.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r.z=e.z/t.z,r.w=e.w/t.w,r},o.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},o.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},o.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},o.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var s=new o;o.lerp=function(e,t,r,n){return o.multiplyByScalar(t,r,s),n=o.multiplyByScalar(e,1-r,n),o.add(s,n,n)};var c=new o;o.mostOrthogonalAxis=function(e,t){var r=o.normalize(e,c);return o.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?o.clone(o.UNIT_X,t):o.clone(o.UNIT_W,t):r.z<=r.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t):r.y<=r.z?r.y<=r.w?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_W,t):r.z<=r.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t)},
o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)&&i.equalsEpsilon(e.w,t.w,n,a)},o.ZERO=a(new o(0,0,0,0)),o.UNIT_X=a(new o(1,0,0,0)),o.UNIT_Y=a(new o(0,1,0,0)),o.UNIT_Z=a(new o(0,0,1,0)),o.UNIT_W=a(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var l=new Float32Array(1);return o.packFloat=function(e,t){if(r(t)||(t=new o),l[0]=e,0===(e=l[0]))return o.clone(o.ZERO,t);var n,a=e<0?1:0;isFinite(e)?(e=Math.abs(e),n=Math.floor(i.logBase(e,10))+1,e/=Math.pow(10,n)):(e=.1,n=38);var u=256*e;return t.x=Math.floor(u),u=256*(u-t.x),t.y=Math.floor(u),u=256*(u-t.y),t.z=Math.floor(u),t.w=2*(n+38)+a,t},o.unpackFloat=function(e){var t=e.w/2,r=Math.floor(t),n=2*(t-r);if(r-=38,n=2*n-1,n=-n,r>=38)return n<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var a=n*e.x*(1/256);return a+=n*e.y*(1/65536),(a+=n*e.z*(1/16777216))*Math.pow(10,r)},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(e,t,r,a,i,o,u,s,c,l,f,d,h,p,m,E){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(p,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(m,0),this[12]=n(a,0),this[13]=n(s,0),this[14]=n(d,0),this[15]=n(E,0)}l.packedLength=16,l.pack=function(e,t,r){return r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15],t},l.unpack=function(e,t,r){return t=n(t,0),a(r)||(r=new l),r[0]=e[t++],r[1]=e[t++],r[2]=e[t++],r[3]=e[t++],r[4]=e[t++],r[5]=e[t++],r[6]=e[t++],r[7]=e[t++],r[8]=e[t++],r[9]=e[t++],r[10]=e[t++],r[11]=e[t++],r[12]=e[t++],r[13]=e[t++],r[14]=e[t++],r[15]=e[t],r},l.clone=function(e,t){if(a(e))return a(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return a(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(t,r,i){return r=n(r,e.ZERO),a(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=r.x,i[13]=r.y,i[14]=r.z,i[15]=1,i):new l(t[0],t[3],t[6],r.x,t[1],t[4],t[7],r.y,t[2],t[5],t[8],r.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,t,r,n){a(n)||(n=new l);var i=r.x,o=r.y,u=r.z,s=t.x*t.x,c=t.x*t.y,f=t.x*t.z,d=t.x*t.w,h=t.y*t.y,p=t.y*t.z,m=t.y*t.w,E=t.z*t.z,y=t.z*t.w,_=t.w*t.w,T=s-h-E+_,R=2*(c-y),v=2*(f+m),A=2*(c+y),g=-s+h-E+_,S=2*(p-d),N=2*(f-m),w=2*(p+d),O=-s-h+E+_;return n[0]=T*i,n[1]=A*i,n[2]=N*i,n[3]=0,n[4]=R*o,n[5]=g*o,n[6]=w*o,n[7]=0,n[8]=v*u,n[9]=S*u,n[10]=O*u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n},l.fromTranslationRotationScale=function(e,t){return l.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},l.fromTranslation=function(e,t){return l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return a(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return a(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,d=new e,h=new e;l.fromCamera=function(t,r){var n=t.position,i=t.direction,o=t.up;e.normalize(i,f),e.normalize(e.cross(f,o,d),d),e.normalize(e.cross(d,f,h),h);var u=d.x,s=d.y,c=d.z,p=f.x,m=f.y,E=f.z,y=h.x,_=h.y,T=h.z,R=n.x,v=n.y,A=n.z,g=u*-R+s*-v+c*-A,S=y*-R+_*-v+T*-A,N=p*R+m*v+E*A;return a(r)?(r[0]=u,r[1]=y,r[2]=-p,r[3]=0,r[4]=s,r[5]=_,r[6]=-m,r[7]=0,r[8]=c,r[9]=T,r[10]=-E,r[11]=0,r[12]=g,r[13]=S,r[14]=N,r[15]=1,r):new l(u,s,c,g,y,_,T,S,-p,-m,-E,N,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,r,n,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(n+r)/(r-n),c=2*n*r/(r-n);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},l.computeOrthographicOffCenter=function(e,t,r,n,a,i,o){var u=1/(t-e),s=1/(n-r),c=1/(i-a),l=-(t+e)*u,f=-(n+r)*s,d=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=d,o[15]=1,o},l.computePerspectiveOffCenter=function(e,t,r,n,a,i,o){var u=2*a/(t-e),s=2*a/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),f=-(i+a)/(i-a),d=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=-1,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},l.computeInfinitePerspectiveOffCenter=function(e,t,r,n,a,i){var o=2*a/(t-e),u=2*a/(n-r),s=(t+e)/(t-e),c=(n+r)/(n-r),l=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=-1,i[11]=-1,i[12]=0,i[13]=0,i[14]=l,i[15]=0,i},l.computeViewportTransformation=function(e,t,r,a){e=n(e,n.EMPTY_OBJECT);var i=n(e.x,0),o=n(e.y,0),u=n(e.width,0),s=n(e.height,0);t=n(t,0),r=n(r,1);var c=.5*u,l=.5*s,f=.5*(r-t),d=c,h=l,p=f,m=i+c,E=o+l,y=t+f;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=h,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=p,a[11]=0,a[12]=m,a[13]=E,a[14]=y,a[15]=1,a},l.computeView=function(t,r,n,a,i){return i[0]=a.x,i[1]=n.x,i[2]=-r.x,i[3]=0,i[4]=a.y,i[5]=n.y,i[6]=-r.y,i[7]=0,i[8]=a.z,i[9]=n.z,i[10]=-r.z,i[11]=0,i[12]=-e.dot(a,t),i[13]=-e.dot(n,t),i[14]=e.dot(r,t),i[15]=1,i},l.toArray=function(e,t){return a(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return 4*e+t},l.getColumn=function(e,t,r){var n=4*t,a=e[n],i=e[n+1],o=e[n+2],u=e[n+3];return r.x=a,r.y=i,r.z=o,r.w=u,r},l.setColumn=function(e,t,r,n){n=l.clone(e,n);var a=4*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n[a+3]=r.w,n},l.setTranslation=function(e,t,r){return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},l.getRow=function(e,t,r){var n=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return r.x=n,r.y=a,r.z=i,r.w=o,r},l.setRow=function(e,t,r,n){return n=l.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var p=new e;l.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],p)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],p)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],p)),r};var m=new e;l.getMaximumScale=function(t){return l.getScale(t,m),e.maximumComponent(m)},l.multiply=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],d=e[9],h=e[10],p=e[11],m=e[12],E=e[13],y=e[14],_=e[15],T=t[0],R=t[1],v=t[2],A=t[3],g=t[4],S=t[5],N=t[6],w=t[7],O=t[8],I=t[9],M=t[10],x=t[11],C=t[12],P=t[13],U=t[14],D=t[15],L=n*T+u*R+f*v+m*A,b=a*T+s*R+d*v+E*A,F=i*T+c*R+h*v+y*A,B=o*T+l*R+p*v+_*A,z=n*g+u*S+f*N+m*w,q=a*g+s*S+d*N+E*w,G=i*g+c*S+h*N+y*w,V=o*g+l*S+p*N+_*w,W=n*O+u*I+f*M+m*x,X=a*O+s*I+d*M+E*x,H=i*O+c*I+h*M+y*x,Y=o*O+l*I+p*M+_*x,k=n*C+u*P+f*U+m*D,j=a*C+s*P+d*U+E*D,Z=i*C+c*P+h*U+y*D,K=o*C+l*P+p*U+_*D;return r[0]=L,r[1]=b,r[2]=F,r[3]=B,r[4]=z,r[5]=q,r[6]=G,r[7]=V,r[8]=W,r[9]=X,r[10]=H,r[11]=Y,r[12]=k,r[13]=j,r[14]=Z,r[15]=K,r},l.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},l.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},l.multiplyTransformation=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],d=e[12],h=e[13],p=e[14],m=t[0],E=t[1],y=t[2],_=t[4],T=t[5],R=t[6],v=t[8],A=t[9],g=t[10],S=t[12],N=t[13],w=t[14],O=n*m+o*E+c*y,I=a*m+u*E+l*y,M=i*m+s*E+f*y,x=n*_+o*T+c*R,C=a*_+u*T+l*R,P=i*_+s*T+f*R,U=n*v+o*A+c*g,D=a*v+u*A+l*g,L=i*v+s*A+f*g,b=n*S+o*N+c*w+d,F=a*S+u*N+l*w+h,B=i*S+s*N+f*w+p;return r[0]=O,r[1]=I,r[2]=M,r[3]=0,r[4]=x,r[5]=C,r[6]=P,r[7]=0,r[8]=U,r[9]=D,r[10]=L,r[11]=0,r[12]=b,r[13]=F,r[14]=B,r[15]=1,r},l.multiplyByMatrix3=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],d=t[0],h=t[1],p=t[2],m=t[3],E=t[4],y=t[5],_=t[6],T=t[7],R=t[8],v=n*d+o*h+c*p,A=a*d+u*h+l*p,g=i*d+s*h+f*p,S=n*m+o*E+c*y,N=a*m+u*E+l*y,w=i*m+s*E+f*y,O=n*_+o*T+c*R,I=a*_+u*T+l*R,M=i*_+s*T+f*R;return r[0]=v,r[1]=A,r[2]=g,r[3]=0,r[4]=S,r[5]=N,r[6]=w,r[7]=0,r[8]=O,r[9]=I,r[10]=M,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},l.multiplyByTranslation=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=n*e[0]+a*e[4]+i*e[8]+e[12],u=n*e[1]+a*e[5]+i*e[9]+e[13],s=n*e[2]+a*e[6]+i*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=o,r[13]=u,r[14]=s,r[15]=e[15],r};var E=new e;l.multiplyByUniformScale=function(e,t,r){return E.x=t,E.y=t,E.z=t,l.multiplyByScale(e,E,r)},l.multiplyByScale=function(e,t,r){var n=t.x,a=t.y,i=t.z;return 1===n&&1===a&&1===i?l.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=a*e[4],r[5]=a*e[5],r[6]=a*e[6],r[7]=0,r[8]=i*e[8],r[9]=i*e[9],r[10]=i*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},l.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*n+e[4]*a+e[8]*i+e[12]*o,s=e[1]*n+e[5]*a+e[9]*i+e[13]*o,c=e[2]*n+e[6]*a+e[10]*i+e[14]*o,l=e[3]*n+e[7]*a+e[11]*i+e[15]*o;return r.x=u,r.y=s,r.z=c,r.w=l,r},l.multiplyByPointAsVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i,u=e[1]*n+e[5]*a+e[9]*i,s=e[2]*n+e[6]*a+e[10]*i;return r.x=o,r.y=u,r.z=s,r},l.multiplyByPoint=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i+e[12],u=e[1]*n+e[5]*a+e[9]*i+e[13],s=e[2]*n+e[6]*a+e[10]*i+e[14];return r.x=o,r.y=u,r.z=s,r},l.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},l.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},l.transpose=function(e,t){var r=e[1],n=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},l.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},l.equals=function(e,t){return e===t||a(e)&&a(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,r){return e===t||a(e)&&a(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},l.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},l.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var y=new s,_=new s,T=new t,R=new t(0,0,0,1);return l.inverse=function(e,r){if(s.equalsEpsilon(l.getRotation(e,y),_,u.EPSILON7)&&t.equals(l.getRow(e,3,T),R))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],a=e[4],i=e[8],o=e[12],f=e[1],d=e[5],h=e[9],p=e[13],m=e[2],E=e[6],v=e[10],A=e[14],g=e[3],S=e[7],N=e[11],w=e[15],O=v*w,I=A*N,M=E*w,x=A*S,C=E*N,P=v*S,U=m*w,D=A*g,L=m*N,b=v*g,F=m*S,B=E*g,z=O*d+x*h+C*p-(I*d+M*h+P*p),q=I*f+U*h+b*p-(O*f+D*h+L*p),G=M*f+D*d+F*p-(x*f+U*d+B*p),V=P*f+L*d+B*h-(C*f+b*d+F*h),W=I*a+M*i+P*o-(O*a+x*i+C*o),X=O*n+D*i+L*o-(I*n+U*i+b*o),H=x*n+U*a+B*o-(M*n+D*a+F*o),Y=C*n+b*a+F*i-(P*n+L*a+B*i);O=i*p,I=o*h,M=a*p,x=o*d,C=a*h,P=i*d,U=n*p,D=o*f,L=n*h,b=i*f,F=n*d,B=a*f;var k=O*S+x*N+C*w-(I*S+M*N+P*w),j=I*g+U*N+b*w-(O*g+D*N+L*w),Z=M*g+D*S+F*w-(x*g+U*S+B*w),K=P*g+L*S+B*N-(C*g+b*S+F*N),J=M*v+P*A+I*E-(C*A+O*E+x*v),Q=L*A+O*m+D*v-(U*v+b*A+I*m),$=U*E+B*A+x*m-(F*A+M*m+D*E),ee=F*v+C*m+b*E-(L*E+B*v+P*m),te=n*z+a*q+i*G+o*V;if(Math.abs(te)<u.EPSILON20)throw new c("matrix is not invertible because its determinate is zero.");return te=1/te,r[0]=z*te,r[1]=q*te,r[2]=G*te,r[3]=V*te,r[4]=W*te,r[5]=X*te,r[6]=H*te,r[7]=Y*te,r[8]=k*te,r[9]=j*te,r[10]=Z*te,r[11]=K*te,r[12]=J*te,r[13]=Q*te,r[14]=$*te,r[15]=ee*te,r},l.inverseTransformation=function(e,t){var r=e[0],n=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],d=e[13],h=e[14],p=-r*f-n*d-a*h,m=-i*f-o*d-u*h,E=-s*f-c*d-l*h;return t[0]=r,t[1]=i,t[2]=s,t[3]=0,t[4]=n,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=p,t[13]=m,t[14]=E,t[15]=1,t},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=o(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,i(l.prototype,{length:{get:function(){return l.packedLength}}}),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,t,n,a){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(a,0)}a(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,t,n){return n=r(n,0),t[n++]=e.west,t[n++]=e.south,t[n++]=e.east,t[n]=e.north,t},s.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new s),a.west=e[t++],a.south=e[t++],a.east=e[t++],a.north=e[t],a},s.computeWidth=function(e){var t=e.east,r=e.west;return t<r&&(t+=u.TWO_PI),t-r},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,t,a,i,o){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),a=u.toRadians(r(a,0)),i=u.toRadians(r(i,0)),n(o)?(o.west=e,o.south=t,o.east=a,o.north=i,o):new s(e,t,a,i)},s.fromRadians=function(e,t,a,i,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(a,0),o.north=r(i,0),o):new s(e,t,a,i)},s.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=0,d=e.length;f<d;f++){var h=e[f];r=Math.min(r,h.longitude),a=Math.max(a,h.longitude),c=Math.min(c,h.latitude),l=Math.max(l,h.latitude);var p=h.longitude>=0?h.longitude:h.longitude+u.TWO_PI;i=Math.min(i,p),o=Math.max(o,p)}return a-r>o-i&&(r=i,a=o,a>u.PI&&(a-=u.TWO_PI),r>u.PI&&(r-=u.TWO_PI)),n(t)?(t.west=r,t.south=c,t.east=a,t.north=l,t):new s(r,c,a,l)},s.fromCartesianArray=function(e,t,a){t=r(t,i.WGS84);for(var o=Number.MAX_VALUE,c=-Number.MAX_VALUE,l=Number.MAX_VALUE,f=-Number.MAX_VALUE,d=Number.MAX_VALUE,h=-Number.MAX_VALUE,p=0,m=e.length;p<m;p++){var E=t.cartesianToCartographic(e[p]);o=Math.min(o,E.longitude),c=Math.max(c,E.longitude),d=Math.min(d,E.latitude),h=Math.max(h,E.latitude);var y=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;l=Math.min(l,y),f=Math.max(f,y)}return c-o>f-l&&(o=l,c=f,c>u.PI&&(c-=u.TWO_PI),o>u.PI&&(o-=u.TWO_PI)),n(a)?(a.west=o,a.south=d,a.east=c,a.north=h,a):new s(o,d,c,h)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.west-t.west)<=r&&Math.abs(e.south-t.south)<=r&&Math.abs(e.east-t.east)<=r&&Math.abs(e.north-t.north)<=r},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.validate=function(e){},s.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},s.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},s.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},s.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},s.center=function(t,r){var a=t.east,i=t.west;a<i&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=s,r.height=0,r):new e(o,s)},s.intersection=function(e,t,r){var a=e.east,i=e.west,o=t.east,c=t.west;a<i&&o>0?a+=u.TWO_PI:o<c&&a>0&&(o+=u.TWO_PI),a<i&&c<0?c+=u.TWO_PI:o<c&&i<0&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),f=u.negativePiToPi(Math.min(a,o));if(!((e.west<e.east||t.west<t.east)&&f<=l)){var d=Math.max(e.south,t.south),h=Math.min(e.north,t.north);if(!(d>=h))return n(r)?(r.west=l,r.south=d,r.east=f,r.north=h,r):new s(l,d,f,h)}},s.simpleIntersection=function(e,t,r){var a=Math.max(e.west,t.west),i=Math.max(e.south,t.south),o=Math.min(e.east,t.east),u=Math.min(e.north,t.north);if(!(i>=u||a>=o))return n(r)?(r.west=a,r.south=i,r.east=o,r.north=u,r):new s(a,i,o,u)},s.union=function(e,t,r){n(r)||(r=new s);var a=e.east,i=e.west,o=t.east,c=t.west;a<i&&o>0?a+=u.TWO_PI:o<c&&a>0&&(o+=u.TWO_PI),a<i&&c<0?c+=u.TWO_PI:o<c&&i<0&&(i+=u.TWO_PI);var l=u.convertLongitudeRange(Math.min(i,c)),f=u.convertLongitudeRange(Math.max(a,o));return r.west=l,r.south=Math.min(e.south,t.south),r.east=f,r.north=Math.max(e.north,t.north),r},s.expand=function(e,t,r){return n(r)||(r=new s),r.west=Math.min(e.west,t.longitude),r.south=Math.min(e.south,t.latitude),r.east=Math.max(e.east,t.longitude),r.north=Math.max(e.north,t.latitude),r},s.contains=function(e,t){var r=t.longitude,n=t.latitude,a=e.west,i=e.east;return i<a&&(i+=u.TWO_PI,r<0&&(r+=u.TWO_PI)),(r>a||u.equalsEpsilon(r,a,u.EPSILON14))&&(r<i||u.equalsEpsilon(r,i,u.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return s.subsample=function(e,t,a,o){t=r(t,i.WGS84),a=r(a,0),n(o)||(o=[]);var l=0,f=e.north,d=e.south,h=e.east,p=e.west,m=c;m.height=a,m.longitude=p,m.latitude=f,o[l]=t.cartographicToCartesian(m,o[l]),l++,m.longitude=h,o[l]=t.cartographicToCartesian(m,o[l]),l++,m.latitude=d,o[l]=t.cartographicToCartesian(m,o[l]),l++,m.longitude=p,o[l]=t.cartographicToCartesian(m,o[l]),l++,m.latitude=f<0?f:d>0?d:0;for(var E=1;E<8;++E)m.longitude=-Math.PI+E*u.PI_OVER_TWO,s.contains(e,m)&&(o[l]=t.cartographicToCartesian(m,o[l]),l++);return 0===m.latitude&&(m.longitude=p,o[l]=t.cartographicToCartesian(m,o[l]),l++,m.longitude=h,o[l]=t.cartographicToCartesian(m,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,a,i,o,u,s,c,l,f,d){"use strict";function h(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var p=new e,m=new e,E=new e,y=new e,_=new e,T=new e,R=new e,v=new e,A=new e,g=new e,S=new e,N=new e,w=4/3*c.PI;h.fromPoints=function(t,r){if(a(r)||(r=new h),!a(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,i=e.clone(t[0],R),o=e.clone(i,p),u=e.clone(i,m),s=e.clone(i,E),c=e.clone(i,y),l=e.clone(i,_),f=e.clone(i,T),d=t.length;for(n=1;n<d;n++){e.clone(t[n],i);var w=i.x,O=i.y,I=i.z;w<o.x&&e.clone(i,o),w>c.x&&e.clone(i,c),O<u.y&&e.clone(i,u),O>l.y&&e.clone(i,l),I<s.z&&e.clone(i,s),I>f.z&&e.clone(i,f)}var M=e.magnitudeSquared(e.subtract(c,o,v)),x=e.magnitudeSquared(e.subtract(l,u,v)),C=e.magnitudeSquared(e.subtract(f,s,v)),P=o,U=c,D=M;x>D&&(D=x,P=u,U=l),C>D&&(D=C,P=s,U=f);var L=A;L.x=.5*(P.x+U.x),L.y=.5*(P.y+U.y),L.z=.5*(P.z+U.z);var b=e.magnitudeSquared(e.subtract(U,L,v)),F=Math.sqrt(b),B=g;B.x=o.x,B.y=u.y,B.z=s.z;var z=S;z.x=c.x,z.y=l.y,z.z=f.z;var q=e.multiplyByScalar(e.add(B,z,v),.5,N),G=0;for(n=0;n<d;n++){e.clone(t[n],i);var V=e.magnitude(e.subtract(i,q,v));V>G&&(G=V);var W=e.magnitudeSquared(e.subtract(i,L,v));if(W>b){var X=Math.sqrt(W);F=.5*(F+X),b=F*F;var H=X-F;L.x=(F*L.x+H*i.x)/X,L.y=(F*L.y+H*i.y)/X,L.z=(F*L.z+H*i.z)/X}}return F<G?(e.clone(L,r.center),r.radius=F):(e.clone(q,r.center),r.radius=G),r};var O=new o,I=new e,M=new e,x=new t,C=new t;h.fromRectangle2D=function(e,t,r){return h.fromRectangleWithHeights2D(e,t,0,0,r)},h.fromRectangleWithHeights2D=function(t,r,i,o,u){if(a(u)||(u=new h),!a(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,O),d.southwest(t,x),x.height=i,d.northeast(t,C),C.height=o;var s=r.project(x,I),c=r.project(C,M),l=c.x-s.x,f=c.y-s.y,p=c.z-s.z;u.radius=.5*Math.sqrt(l*l+f*f+p*p);var m=u.center;return m.x=s.x+.5*l,m.y=s.y+.5*f,m.z=s.z+.5*p,u};var P=[];h.fromRectangle3D=function(t,r,o,u){if(r=n(r,i.WGS84),o=n(o,0),a(u)||(u=new h),!a(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=d.subsample(t,r,o,P);return h.fromPoints(s,u)},h.fromVertices=function(t,r,i,o){if(a(o)||(o=new h),!a(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;r=n(r,e.ZERO),i=n(i,3);var u=R;u.x=t[0]+r.x,u.y=t[1]+r.y,u.z=t[2]+r.z;var s,c=e.clone(u,p),l=e.clone(u,m),f=e.clone(u,E),d=e.clone(u,y),w=e.clone(u,_),O=e.clone(u,T),I=t.length;for(s=0;s<I;s+=i){var M=t[s]+r.x,x=t[s+1]+r.y,C=t[s+2]+r.z;u.x=M,u.y=x,u.z=C,M<c.x&&e.clone(u,c),M>d.x&&e.clone(u,d),x<l.y&&e.clone(u,l),x>w.y&&e.clone(u,w),C<f.z&&e.clone(u,f),C>O.z&&e.clone(u,O)}var P=e.magnitudeSquared(e.subtract(d,c,v)),U=e.magnitudeSquared(e.subtract(w,l,v)),D=e.magnitudeSquared(e.subtract(O,f,v)),L=c,b=d,F=P;U>F&&(F=U,L=l,b=w),D>F&&(F=D,L=f,b=O);var B=A;B.x=.5*(L.x+b.x),B.y=.5*(L.y+b.y),B.z=.5*(L.z+b.z);var z=e.magnitudeSquared(e.subtract(b,B,v)),q=Math.sqrt(z),G=g;G.x=c.x,G.y=l.y,G.z=f.z;var V=S;V.x=d.x,V.y=w.y,V.z=O.z;var W=e.multiplyByScalar(e.add(G,V,v),.5,N),X=0;for(s=0;s<I;s+=i){u.x=t[s]+r.x,u.y=t[s+1]+r.y,u.z=t[s+2]+r.z;var H=e.magnitude(e.subtract(u,W,v));H>X&&(X=H);var Y=e.magnitudeSquared(e.subtract(u,B,v));if(Y>z){var k=Math.sqrt(Y);q=.5*(q+k),z=q*q;var j=k-q;B.x=(q*B.x+j*u.x)/k,B.y=(q*B.y+j*u.y)/k,B.z=(q*B.z+j*u.z)/k}}return q<X?(e.clone(B,o.center),o.radius=q):(e.clone(W,o.center),o.radius=X),o},h.fromEncodedCartesianVertices=function(t,r,n){if(a(n)||(n=new h),!a(t)||!a(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=R;i.x=t[0]+r[0],i.y=t[1]+r[1],i.z=t[2]+r[2];var o,u=e.clone(i,p),s=e.clone(i,m),c=e.clone(i,E),l=e.clone(i,y),f=e.clone(i,_),d=e.clone(i,T),w=t.length;for(o=0;o<w;o+=3){var O=t[o]+r[o],I=t[o+1]+r[o+1],M=t[o+2]+r[o+2];i.x=O,i.y=I,i.z=M,O<u.x&&e.clone(i,u),O>l.x&&e.clone(i,l),I<s.y&&e.clone(i,s),I>f.y&&e.clone(i,f),M<c.z&&e.clone(i,c),M>d.z&&e.clone(i,d)}var x=e.magnitudeSquared(e.subtract(l,u,v)),C=e.magnitudeSquared(e.subtract(f,s,v)),P=e.magnitudeSquared(e.subtract(d,c,v)),U=u,D=l,L=x;C>L&&(L=C,U=s,D=f),P>L&&(L=P,U=c,D=d);var b=A;b.x=.5*(U.x+D.x),b.y=.5*(U.y+D.y),b.z=.5*(U.z+D.z);var F=e.magnitudeSquared(e.subtract(D,b,v)),B=Math.sqrt(F),z=g;z.x=u.x,z.y=s.y,z.z=c.z;var q=S;q.x=l.x,q.y=f.y,q.z=d.z;var G=e.multiplyByScalar(e.add(z,q,v),.5,N),V=0;for(o=0;o<w;o+=3){i.x=t[o]+r[o],i.y=t[o+1]+r[o+1],i.z=t[o+2]+r[o+2];var W=e.magnitude(e.subtract(i,G,v));W>V&&(V=W);var X=e.magnitudeSquared(e.subtract(i,b,v));if(X>F){var H=Math.sqrt(X);B=.5*(B+H),F=B*B;var Y=H-B;b.x=(B*b.x+Y*i.x)/H,b.y=(B*b.y+Y*i.y)/H,b.z=(B*b.z+Y*i.z)/H}}return B<V?(e.clone(b,n.center),n.radius=B):(e.clone(G,n.center),n.radius=V),n},h.fromCornerPoints=function(t,r,n){a(n)||(n=new h);var i=n.center;return e.add(t,r,i),e.multiplyByScalar(i,.5,i),n.radius=e.distance(i,r),n},h.fromEllipsoid=function(t,r){return a(r)||(r=new h),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var U=new e;h.fromBoundingSpheres=function(t,r){if(a(r)||(r=new h),!a(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return h.clone(t[0],r);if(2===n)return h.union(t[0],t[1],r);var i,o=[];for(i=0;i<n;i++)o.push(t[i].center);r=h.fromPoints(o,r);var u=r.center,s=r.radius;for(i=0;i<n;i++){var c=t[i];s=Math.max(s,e.distance(u,c.center,U)+c.radius)}return r.radius=s,r};var D=new e,L=new e,b=new e;h.fromOrientedBoundingBox=function(t,r){a(r)||(r=new h);var n=t.halfAxes,i=l.getColumn(n,0,D),o=l.getColumn(n,1,L),u=l.getColumn(n,2,b);return e.add(i,o,i),e.add(i,u,i),r.center=e.clone(t.center,r.center),r.radius=e.magnitude(i),r},h.clone=function(t,r){if(a(t))return a(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new h(t.center,t.radius)},h.packedLength=4,h.pack=function(e,t,r){r=n(r,0);var a=e.center;return t[r++]=a.x,t[r++]=a.y,t[r++]=a.z,t[r]=e.radius,t},h.unpack=function(e,t,r){t=n(t,0),a(r)||(r=new h);var i=r.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],r.radius=e[t],r};var F=new e,B=new e;h.union=function(t,r,n){a(n)||(n=new h);var i=t.center,o=t.radius,u=r.center,s=r.radius,c=e.subtract(u,i,F),l=e.magnitude(c);if(o>=l+s)return t.clone(n),n;if(s>=l+o)return r.clone(n),n;var f=.5*(o+l+s),d=e.multiplyByScalar(c,(-o+f)/l,B);return e.add(d,i,d),e.clone(d,n.center),n.radius=f,n};var z=new e;h.expand=function(t,r,n){n=h.clone(t,n);var a=e.magnitude(e.subtract(r,n.center,z));return a>n.radius&&(n.radius=a),n},h.intersectPlane=function(t,r){var n=t.center,a=t.radius,i=r.normal,o=e.dot(i,n)+r.distance;return o<-a?u.OUTSIDE:o<a?u.INTERSECTING:u.INSIDE},h.transform=function(e,t,r){return a(r)||(r=new h),r.center=f.multiplyByPoint(t,e.center,r.center),r.radius=f.getMaximumScale(t)*e.radius,r};var q=new e;h.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,q);return e.magnitudeSquared(n)-t.radius*t.radius},h.transformWithoutScale=function(e,t,r){return a(r)||(r=new h),r.center=f.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var G=new e;h.computePlaneDistances=function(t,r,n,i){a(i)||(i=new s);var o=e.subtract(t.center,r,G),u=e.dot(n,o);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var V=new e,W=new e,X=new e,H=new e,Y=new e,k=new t,j=new Array(8),Z=0;Z<8;++Z)j[Z]=new e;var K=new o;return h.projectTo2D=function(t,r,a){r=n(r,K);var i=r.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,V),c=e.cross(e.UNIT_Z,s,W);e.normalize(c,c);var l=e.cross(s,c,X);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var f=e.negate(l,Y),d=e.negate(c,H),p=j,m=p[0];e.add(s,l,m),e.add(m,c,m),m=p[1],e.add(s,l,m),e.add(m,d,m),m=p[2],e.add(s,f,m),e.add(m,d,m),m=p[3],e.add(s,f,m),e.add(m,c,m),e.negate(s,s),m=p[4],e.add(s,l,m),e.add(m,c,m),m=p[5],e.add(s,l,m),e.add(m,d,m),m=p[6],e.add(s,f,m),e.add(m,d,m),m=p[7],e.add(s,f,m),e.add(m,c,m);for(var E=p.length,y=0;y<E;++y){var _=p[y];e.add(o,_,_);var T=i.cartesianToCartographic(_,k);r.project(T,_)}a=h.fromPoints(p,a),o=a.center;var R=o.x,v=o.y,A=o.z;return o.x=A,o.y=R,o.z=v,a},h.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},h.equals=function(t,r){return t===r||a(t)&&a(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,r){return h.computePlaneDistances(this,e,t,r)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.volume=function(){var e=this.radius;return w*e*e*e},h}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){if(a.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(a.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(a.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(a.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(a.supportsFullscreen())return null!==a.element}}}),a.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;o<u;++o){var s=i[o];a=s+"RequestFullscreen",
"function"==typeof t[a]?(n.requestFullscreen=a,r=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(n.requestFullscreen=a,r=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?n.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(n.exitFullscreen=a)),a=s+"FullscreenEnabled",void 0!==document[a]?n.fullscreenEnabled=a:(a=s+"FullScreenEnabled",void 0!==document[a]&&(n.fullscreenEnabled=a)),a=s+"FullscreenElement",void 0!==document[a]?n.fullscreenElement=a:(a=s+"FullScreenElement",void 0!==document[a]&&(n.fullscreenElement=a)),a=s+"fullscreenchange",void 0!==document["on"+a]&&("ms"===s&&(a="MSFullscreenChange"),n.fullscreenchange=a),a=s+"fullscreenerror",void 0!==document["on"+a]&&("ms"===s&&(a="MSFullscreenError"),n.fullscreenerror=a)}return r},a.requestFullscreen=function(e,t){a.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},a.exitFullscreen=function(){a.supportsFullscreen()&&document[n.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(A)&&(A=!1,!d())){var e=/ Chrome\/([\.0-9]+)/.exec(v.userAgent);null!==e&&(A=!0,g=n(e[1]))}return A}function i(){return a()&&g}function o(){if(!t(S)&&(S=!1,!a()&&!d()&&/ Safari\/[\.0-9]+/.test(v.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(v.userAgent);null!==e&&(S=!0,N=n(e[1]))}return S}function u(){return o()&&N}function s(){if(!t(w)){w=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(v.userAgent);null!==e&&(w=!0,O=n(e[1]),O.isNightly=!!e[2])}return w}function c(){return s()&&O}function l(){if(!t(I)){I=!1;var e;"Microsoft Internet Explorer"===v.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(v.userAgent))&&(I=!0,M=n(e[1])):"Netscape"===v.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(v.userAgent))&&(I=!0,M=n(e[1]))}return I}function f(){return l()&&M}function d(){if(!t(x)){x=!1;var e=/ Edge\/([\.0-9]+)/.exec(v.userAgent);null!==e&&(x=!0,C=n(e[1]))}return x}function h(){return d()&&C}function p(){if(!t(P)){P=!1;var e=/Firefox\/([\.0-9]+)/.exec(v.userAgent);null!==e&&(P=!0,U=n(e[1]))}return P}function m(){return t(D)||(D=/Windows/i.test(v.appVersion)),D}function E(){return p()&&U}function y(){return t(L)||(L="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),L}function _(){return t(b)||(b="undefined"!=typeof PointerEvent&&(!t(v.pointerEnabled)||v.pointerEnabled)),b}function T(){if(!t(B)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;B=t(r)&&""!==r,B&&(F=r)}return B}function R(){return T()?F:void 0}var v;v="undefined"!=typeof navigator?navigator:{};var A,g,S,N,w,O,I,M,x,C,P,U,D,L,b,F,B,z=[];"undefined"!=typeof ArrayBuffer&&(z.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&z.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&z.push(CanvasPixelArray));var q={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isEdge:d,edgeVersion:h,isFirefox:p,firefoxVersion:E,isWindows:m,isNodeJs:y,hardwareConcurrency:e(v.hardwareConcurrency,3),supportsPointerEvents:_,supportsImageRenderingPixelated:T,imageRenderingValue:R,typedArrayTypes:z};return q.supportsFullscreen=function(){return r.supportsFullscreen()},q.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},q.supportsWebWorkers=function(){return"undefined"!=typeof Worker},q.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!q.isEdge()},q}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,a,i){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:i.BYTE,UNSIGNED_BYTE:i.UNSIGNED_BYTE,SHORT:i.SHORT,UNSIGNED_SHORT:i.UNSIGNED_SHORT,INT:i.INT,UNSIGNED_INT:i.UNSIGNED_INT,FLOAT:i.FLOAT,DOUBLE:i.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.INT:return new Int32Array(t);case o.UNSIGNED_INT:return new Uint32Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t)}},o.createArrayBufferView=function(t,r,n,a){switch(n=e(n,0),a=e(a,(r.byteLength-n)/o.getSizeInBytes(t)),t){case o.BYTE:return new Int8Array(r,n,a);case o.UNSIGNED_BYTE:return new Uint8Array(r,n,a);case o.SHORT:return new Int16Array(r,n,a);case o.UNSIGNED_SHORT:return new Uint16Array(r,n,a);case o.INT:return new Int32Array(r,n,a);case o.UNSIGNED_INT:return new Uint32Array(r,n,a);case o.FLOAT:return new Float32Array(r,n,a);case o.DOUBLE:return new Float64Array(r,n,a)}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE}},a(o)}),define("Core/CornerType",["./freezeObject"],function(e){"use strict";return e({ROUNDED:0,MITERED:1,BEVELED:2})}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e){var t=e._uSquared,r=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,a=(r-n)/r,i=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-a)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),c=s*u,l=Math.atan2(u,i),f=s*o,d=f*f,h=1-d,p=Math.sqrt(h),m=t/4,E=m*m,y=E*m,_=E*E,T=1+m-3*E/4+5*y/4-175*_/64,R=1-m+15*E/8-35*y/8,v=1-3*m+35*E/4,A=1-5*m,g=T*l-R*Math.sin(2*l)*m/2-v*Math.sin(4*l)*E/16-A*Math.sin(6*l)*y/48-5*Math.sin(8*l)*_/512,S=e._constants;S.a=r,S.b=n,S.f=a,S.cosineHeading=i,S.sineHeading=o,S.tanU=u,S.cosineU=s,S.sineU=c,S.sigma=l,S.sineAlpha=f,S.sineSquaredAlpha=d,S.cosineSquaredAlpha=h,S.cosineAlpha=p,S.u2Over4=m,S.u4Over16=E,S.u6Over64=y,S.u8Over256=_,S.a0=T,S.a1=R,S.a2=v,S.a3=A,S.distanceRatio=g}function c(e,t){return e*t*(4+e*(4-3*t))/16}function l(e,t,r,n,a,i,o){var u=c(e,r);return(1-u)*e*t*(n+u*a*(o+u*i*(2*o*o-1)))}function f(e,t,r,n,a,i,o){var s,c,f,d,h,p=(t-r)/t,m=i-n,E=Math.atan((1-p)*Math.tan(a)),y=Math.atan((1-p)*Math.tan(o)),_=Math.cos(E),T=Math.sin(E),R=Math.cos(y),v=Math.sin(y),A=_*R,g=_*v,S=T*v,N=T*R,w=m,O=u.TWO_PI,I=Math.cos(w),M=Math.sin(w);do{I=Math.cos(w),M=Math.sin(w);var x=g-N*I;f=Math.sqrt(R*R*M*M+x*x),c=S+A*I,s=Math.atan2(f,c);var C;0===f?(C=0,d=1):(C=A*M/f,d=1-C*C),O=w,h=c-2*S/d,isNaN(h)&&(h=0),w=m+l(p,C,d,s,f,c,h)}while(Math.abs(w-O)>u.EPSILON12);var P=d*(t*t-r*r)/(r*r),U=1+P*(4096+P*(P*(320-175*P)-768))/16384,D=P*(256+P*(P*(74-47*P)-128))/1024,L=h*h,b=D*f*(h+D*(c*(2*L-1)-D*h*(4*f*f-3)*(4*L-3)/6)/4),F=r*U*(s-b),B=Math.atan2(R*M,g-N*I),z=Math.atan2(_*M,g*I-N);e._distance=F,e._startHeading=B,e._endHeading=z,e._uSquared=P}function d(r,n,a,i){e.normalize(i.cartographicToCartesian(n,m),p),e.normalize(i.cartographicToCartesian(a,m),m);f(r,i.maximumRadius,i.minimumRadius,n.longitude,n.latitude,a.longitude,a.latitude),r._start=t.clone(n,r._start),r._end=t.clone(a,r._end),r._start.height=0,r._end.height=0,s(r)}function h(e,r,i){var u=n(i,o.WGS84);this._ellipsoid=u,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,a(e)&&a(r)&&d(this,e,r,u)}var p=new e,m=new e;return i(h.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),h.prototype.setEndPoints=function(e,t){d(this,e,t,this._ellipsoid)},h.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},h.prototype.interpolateUsingSurfaceDistance=function(e,r){var n=this._constants,i=n.distanceRatio+e/n.b,o=Math.cos(2*i),u=Math.cos(4*i),s=Math.cos(6*i),c=Math.sin(2*i),f=Math.sin(4*i),d=Math.sin(6*i),h=Math.sin(8*i),p=i*i,m=i*p,E=n.u8Over256,y=n.u2Over4,_=n.u6Over64,T=n.u4Over16,R=2*m*E*o/3+i*(1-y+7*T/4-15*_/4+579*E/64-(T-15*_/4+187*E/16)*o-(5*_/4-115*E/16)*u-29*E*s/16)+(y/2-T+71*_/32-85*E/16)*c+(5*T/16-5*_/4+383*E/96)*f-p*((_-11*E/2)*c+5*E*f/2)+(29*_/96-29*E/16)*d+539*E*h/1536,v=Math.asin(Math.sin(R)*n.cosineAlpha),A=Math.atan(n.a/n.b*Math.tan(v));R-=n.sigma;var g=Math.cos(2*n.sigma+R),S=Math.sin(R),N=Math.cos(R),w=n.cosineU*N,O=n.sineU*S,I=Math.atan2(S*n.sineHeading,w-O*n.cosineHeading),M=I-l(n.f,n.sineAlpha,n.cosineSquaredAlpha,R,S,N,g);return a(r)?(r.longitude=this._start.longitude+M,r.latitude=A,r.height=0,r):new t(this._start.longitude+M,A,0)},h}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var a=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(r)))<n?0:a}var n={};return n.computeDiscriminant=function(e,t,r){return t*t-4*e*r},n.computeRealRoots=function(e,n,a){var i;if(0===e)return 0===n?[]:[-a/n];if(0===n){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(o<u&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if((i=-a/e)<0)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-n/e,i<0?[i,0]:[0,i];var c=n*n,l=4*e*a,f=r(c,-l,t.EPSILON14);if(f<0)return[];var d=-.5*r(n,t.sign(n)*Math.sqrt(f),t.EPSILON14);return n>0?[d/e,a/d]:[a/d,d/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var a,i,o=e,u=t/3,s=r/3,c=n,l=o*s,f=u*c,d=u*u,h=s*s,p=o*s-d,m=o*c-u*s,E=u*c-h,y=4*p*E-m*m;if(y<0){var _,T,R;d*f>=l*h?(_=o,T=p,R=-2*u*p+o*m):(_=c,T=E,R=-c*m+2*s*E);var v=R<0?-1:1,A=-v*Math.abs(_)*Math.sqrt(-y);i=-R+A;var g=i/2,S=g<0?-Math.pow(-g,1/3):Math.pow(g,1/3),N=i===A?-S:-T/S;return a=T<=0?S+N:-R/(S*S+N*N+T),d*f>=l*h?[(a-u)/o]:[-c/(a+s)]}var w=p,O=-2*u*p+o*m,I=E,M=-c*m+2*s*E,x=Math.sqrt(y),C=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*x,-O)/3);a=2*Math.sqrt(-w);var U=Math.cos(P);i=a*U;var D=a*(-U/2-C*Math.sin(P)),L=i+D>2*u?i-u:D-u,b=o,F=L/b;P=Math.abs(Math.atan2(c*x,-M)/3),a=2*Math.sqrt(-I),U=Math.cos(P),i=a*U,D=a*(-U/2-C*Math.sin(P));var B=-c,z=i+D<2*s?i+s:D+s,q=B/z,G=b*z,V=-L*z-b*B,W=L*B,X=(s*V-u*W)/(-u*V+s*G);return F<=X?F<=q?X<=q?[F,X,q]:[F,q,X]:[q,F,X]:F<=q?[X,F,q]:X<=q?[X,q,F]:[q,X,F]}var n={};return n.computeDiscriminant=function(e,t,r,n){var a=e*e,i=t*t,o=r*r;return 18*e*t*r*n+i*o-27*a*(n*n)-4*(e*o*r+i*t*n)},n.computeRealRoots=function(e,n,a,i){var o,u;if(0===e)return t.computeRealRoots(n,a,i);if(0===n){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=u<0?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):r(e,0,a,i)}return 0===a?0===i?(u=-n/e,u<0?[u,0,0]:[0,0,u]):r(e,n,0,i):0===i?(o=t.computeRealRoots(e,n,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):r(e,n,a,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var d=-t/4,h=f[f.length-1];if(Math.abs(h)<r.EPSILON14){var p=n.computeRealRoots(1,s,l);if(2===p.length){var m,E=p[0],y=p[1];if(E>=0&&y>=0){var _=Math.sqrt(E),T=Math.sqrt(y);return[d-T,d-_,d+_,d+T]}if(E>=0&&y<0)return m=Math.sqrt(E),[d-m,d+m];if(E<0&&y>=0)return m=Math.sqrt(y),[d-m,d+m]}return[]}if(h>0){var R=Math.sqrt(h),v=(s+h-c/R)/2,A=(s+h+c/R)/2,g=n.computeRealRoots(1,R,v),S=n.computeRealRoots(1,-R,A);return 0!==g.length?(g[0]+=d,g[1]+=d,0!==S.length?(S[0]+=d,S[1]+=d,g[1]<=S[0]?[g[0],g[1],S[0],S[1]]:S[1]<=g[0]?[S[0],S[1],g[0],g[1]]:g[0]>=S[0]&&g[1]<=S[1]?[S[0],g[0],g[1],S[1]]:S[0]>=g[0]&&S[1]<=g[1]?[g[0],S[0],S[1],g[1]]:g[0]>S[0]&&g[0]<S[1]?[S[0],g[0],S[1],g[1]]:[g[0],S[0],g[1],S[1]]):g):0!==S.length?(S[0]+=d,S[1]+=d,S):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,f=i*t+s-4*o,d=c*o-i*a*t+u,h=e.computeRealRoots(1,l,f,d);if(h.length>0){var p,m,E=h[0],y=a-E,_=y*y,T=t/2,R=y/2,v=_-4*o,A=_+4*Math.abs(o),g=c-4*E,S=c+4*Math.abs(E);if(E<0||v*S<g*A){var N=Math.sqrt(g);p=N/2,m=0===N?0:(t*R-i)/N}else{var w=Math.sqrt(v);p=0===w?0:(t*R-i)/w,m=w/2}var O,I;0===T&&0===p?(O=0,I=0):r.sign(T)===r.sign(p)?(O=T+p,I=E/O):(I=T-p,O=E/I);var M,x;0===R&&0===m?(M=0,x=0):r.sign(R)===r.sign(m)?(M=R+m,x=o/M):(x=R-m,M=o/x);var C=n.computeRealRoots(1,O,M),P=n.computeRealRoots(1,I,x);if(0!==C.length)return 0!==P.length?C[1]<=P[0]?[C[0],C[1],P[0],P[1]]:P[1]<=C[0]?[P[0],P[1],C[0],C[1]]:C[0]>=P[0]&&C[1]<=P[1]?[P[0],C[0],C[1],P[1]]:P[0]>=C[0]&&P[1]<=C[1]?[C[0],P[0],P[1],C[1]]:C[0]>P[0]&&C[0]<P[1]?[P[0],C[0],P[1],C[1]]:[C[0],P[0],C[1],P[1]]:C;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,r,n,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=r*r,l=c*r,f=n*n,d=f*n,h=a*a;return u*c*f-4*s*d-4*e*l*f+18*e*t*r*d-27*i*f*f+256*o*(h*a)+a*(18*s*r*n-4*u*l+16*e*c*c-80*e*t*c*n-6*e*u*f+144*i*r*f)+h*(144*e*u*r-27*u*u-128*i*c-192*i*t*n)},o.computeRealRoots=function(t,n,o,u,s){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,o,u,s);var c=n/t,l=o/t,f=u/t,d=s/t,h=c<0?1:0;switch(h+=l<0?h+1:h,h+=f<0?h+1:h,h+=d<0?h+1:h){case 0:return a(c,l,f,d);case 1:case 2:return i(c,l,f,d);case 3:case 4:return a(c,l,f,d);case 5:return i(c,l,f,d);case 6:case 7:return a(c,l,f,d);case 8:return i(c,l,f,d);case 9:case 10:return a(c,l,f,d);case 11:return i(c,l,f,d);case 12:case 13:case 14:case 15:return a(c,l,f,d);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function a(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n}return a.getPoint=function(t,n,a){return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,n,a),e.add(t.origin,a,a)},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,a,i,o,u,s,c,l){"use strict";function f(e,t,r,n){var a=t*t-4*e*r;if(!(a<0)){if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return u<s?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}function d(t,r,a){n(a)||(a=new i);var o=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,l=e.subtract(o,s,_),d=e.dot(u,u),h=2*e.dot(u,l),p=e.magnitudeSquared(l)-c,m=f(d,h,p,A);if(n(m))return a.start=m.root0,a.stop=m.root1,a}function h(e,t,r){var n=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function p(t,r,n,a,i){var l,f=a*a,d=i*i,p=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*d,m=i*(a*h(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+r.y),E=t[u.COLUMN0ROW0]*f+t[u.COLUMN2ROW2]*d+a*r.x+n,y=d*h(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),_=i*(a*h(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),T=[];if(0===_&&0===y){if(l=s.computeRealRoots(p,m,E),0===l.length)return T;var R=l[0],v=Math.sqrt(Math.max(1-R*R,0));if(T.push(new e(a,i*R,i*-v)),T.push(new e(a,i*R,i*v)),2===l.length){var A=l[1],g=Math.sqrt(Math.max(1-A*A,0));T.push(new e(a,i*A,i*-g)),T.push(new e(a,i*A,i*g))}return T}var S=_*_,N=y*y,w=p*p,O=_*y,I=w+N,M=2*(m*p+O),x=2*E*p+m*m-N+S,C=2*(E*m-O),P=E*E-S;if(0===I&&0===M&&0===x&&0===C)return T;l=c.computeRealRoots(I,M,x,C,P);var U=l.length;if(0===U)return T;for(var D=0;D<U;++D){var L,b=l[D],F=b*b,B=Math.max(1-F,0),z=Math.sqrt(B);L=o.sign(p)===o.sign(E)?h(p*F+E,m*b,o.EPSILON12):o.sign(E)===o.sign(m*b)?h(p*F,m*b+E,o.EPSILON12):h(p*F+m*b,E,o.EPSILON12);var q=h(y*b,_,o.EPSILON15),G=L*q;G<0?T.push(new e(a,i*b,i*z)):G>0?T.push(new e(a,i*b,i*-z)):0!==z?(T.push(new e(a,i*b,i*-z)),T.push(new e(a,i*b,i*z)),++D):T.push(new e(a,i*b,i*z))}return T}var m={};m.rayPlane=function(t,r,a){n(a)||(a=new e);var i=t.origin,u=t.direction,s=r.normal,c=e.dot(s,u);if(!(Math.abs(c)<o.EPSILON15)){var l=(-r.distance-e.dot(s,i))/c;if(!(l<0))return a=e.multiplyByScalar(u,l,a),e.add(i,a,a)}};var E=new e,y=new e,_=new e,T=new e,R=new e;m.rayTriangleParametric=function(t,n,a,i,u){u=r(u,!1);var s,c,l,f,d,h=t.origin,p=t.direction,m=e.subtract(a,n,E),v=e.subtract(i,n,y),A=e.cross(p,v,_),g=e.dot(m,A);if(u){if(g<o.EPSILON6)return;if(s=e.subtract(h,n,T),(l=e.dot(s,A))<0||l>g)return;if(c=e.cross(s,m,R),(f=e.dot(p,c))<0||l+f>g)return;d=e.dot(v,c)/g}else{if(Math.abs(g)<o.EPSILON6)return;var S=1/g;if(s=e.subtract(h,n,T),(l=e.dot(s,A)*S)<0||l>1)return;if(c=e.cross(s,m,R),(f=e.dot(p,c)*S)<0||l+f>1)return;d=e.dot(v,c)*S}return d},m.rayTriangle=function(t,r,a,i,o,u){var s=m.rayTriangleParametric(t,r,a,i,o);if(n(s)&&!(s<0))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var v=new l;m.lineSegmentTriangle=function(t,r,a,i,o,u,s){var c=v;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var l=m.rayTriangleParametric(c,a,i,o,u);if(!(!n(l)||l<0||l>e.distance(t,r)))return n(s)||(s=new e),e.multiplyByScalar(c.direction,l,s),e.add(c.origin,s,s)};var A={root0:0,root1:0};m.raySphere=function(e,t,r){if(r=d(e,t,r),
n(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var g=new l;m.lineSegmentSphere=function(t,r,a,i){var o=g;e.clone(t,o.origin);var u=e.subtract(r,t,o.direction),s=e.magnitude(u);if(e.normalize(u,u),i=d(o,a,i),!(!n(i)||i.stop<0||i.start>s))return i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i};var S=new e,N=new e;m.rayEllipsoid=function(t,r){var n,a,o,u,s,c=r.oneOverRadii,l=e.multiplyComponents(c,t.origin,S),f=e.multiplyComponents(c,t.direction,N),d=e.magnitudeSquared(l),h=e.dot(l,f);if(d>1){if(h>=0)return;var p=h*h;if(n=d-1,a=e.magnitudeSquared(f),o=a*n,p<o)return;if(p>o){u=h*h-o,s=-h+Math.sqrt(u);var m=s/a,E=n/s;return m<E?new i(m,E):{start:E,stop:m}}var y=Math.sqrt(n/a);return new i(y,y)}return d<1?(n=d-1,a=e.magnitudeSquared(f),o=a*n,u=h*h-o,s=-h+Math.sqrt(u),new i(0,s/a)):h<0?(a=e.magnitudeSquared(f),new i(0,-h/a)):void 0};var w=new e,O=new e,I=new e,M=new e,x=new e,C=new u,P=new u,U=new u,D=new u,L=new u,b=new u,F=new u,B=new e,z=new e,q=new t;m.grazingAltitudeLocation=function(t,r){var a=t.origin,i=t.direction;if(!e.equals(a,e.ZERO)){var s=r.geodeticSurfaceNormal(a,w);if(e.dot(i,s)>=0)return a}var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(i,w),f=e.normalize(l,l),d=e.mostOrthogonalAxis(l,M),h=e.normalize(e.cross(d,f,O),O),m=e.normalize(e.cross(f,h,I),I),E=C;E[0]=f.x,E[1]=f.y,E[2]=f.z,E[3]=h.x,E[4]=h.y,E[5]=h.z,E[6]=m.x,E[7]=m.y,E[8]=m.z;var y=u.transpose(E,P),_=u.fromScale(r.radii,U),T=u.fromScale(r.oneOverRadii,D),R=L;R[0]=0,R[1]=-i.z,R[2]=i.y,R[3]=i.z,R[4]=0,R[5]=-i.x,R[6]=-i.y,R[7]=i.x,R[8]=0;var v,A,g=u.multiply(u.multiply(y,T,b),R,b),S=u.multiply(u.multiply(g,_,F),E,F),N=u.multiplyByVector(g,a,x),G=p(S,e.negate(N,w),0,0,1),V=G.length;if(V>0){for(var W=e.clone(e.ZERO,z),X=Number.NEGATIVE_INFINITY,H=0;H<V;++H){v=u.multiplyByVector(_,u.multiplyByVector(E,G[H],B),B);var Y=e.normalize(e.subtract(v,a,M),M),k=e.dot(Y,i);k>X&&(X=k,W=e.clone(v,W))}var j=r.cartesianToCartographic(W,q);return X=o.clamp(X,0,1),A=e.magnitude(e.subtract(W,a,M))*Math.sqrt(1-X*X),A=c?-A:A,j.height=A,r.cartographicToCartesian(j,new e)}};var G=new e;return m.lineSegmentPlane=function(t,r,a,i){n(i)||(i=new e);var u=e.subtract(r,t,G),s=a.normal,c=e.dot(s,u);if(!(Math.abs(c)<o.EPSILON6)){var l=e.dot(s,t),f=-(a.distance+l)/c;if(!(f<0||f>1))return e.multiplyByScalar(u,f,i),e.add(t,i,i),i}},m.trianglePlaneIntersection=function(t,r,n,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,r)+o<0,c=e.dot(i,n)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,d;if(1!==l&&2!==l||(f=new e,d=new e),1===l){if(u)return m.lineSegmentPlane(t,r,a,f),m.lineSegmentPlane(t,n,a,d),{positions:[t,r,n,f,d],indices:[0,3,4,1,2,4,1,4,3]};if(s)return m.lineSegmentPlane(r,n,a,f),m.lineSegmentPlane(r,t,a,d),{positions:[t,r,n,f,d],indices:[1,3,4,2,0,4,2,4,3]};if(c)return m.lineSegmentPlane(n,t,a,f),m.lineSegmentPlane(n,r,a,d),{positions:[t,r,n,f,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return m.lineSegmentPlane(r,t,a,f),m.lineSegmentPlane(n,t,a,d),{positions:[t,r,n,f,d],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return m.lineSegmentPlane(n,r,a,f),m.lineSegmentPlane(t,r,a,d),{positions:[t,r,n,f,d],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return m.lineSegmentPlane(t,n,a,f),m.lineSegmentPlane(r,n,a,d),{positions:[t,r,n,f,d],indices:[0,1,4,0,4,3,2,3,4]}}},m}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],function(e,t,r,n,a,i,o){"use strict";function u(t,r){this.normal=e.clone(t),this.distance=r}u.fromPointNormal=function(t,n,a){var i=-e.dot(n,t);return r(a)?(e.clone(n,a.normal),a.distance=i,a):new u(n,i)};var s=new e;u.fromCartesian4=function(t,n){var a=e.fromCartesian4(t,s),i=t.w;return r(n)?(e.clone(a,n.normal),n.distance=i,n):new u(a,i)},u.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance};var c=new e;u.projectPointOntoPlane=function(t,n,a){r(a)||(a=new e);var i=u.getPointDistance(t,n),o=e.multiplyByScalar(t.normal,i,c);return e.subtract(n,o,a)};var l=new e;return u.transform=function(t,r,n){return o.multiplyByPointAsVector(r,t.normal,s),e.normalize(s,s),e.multiplyByScalar(t.normal,-t.distance,l),o.multiplyByPoint(r,l,l),u.fromPointNormal(l,s,n)},u.clone=function(t,n){return r(n)?(e.clone(t.normal,n.normal),n.distance=t.distance,n):new u(t.normal,t.distance)},u.equals=function(t,r){return t.distance===r.distance&&e.equals(t.normal,r.normal)},u.ORIGIN_XY_PLANE=a(new u(e.UNIT_Z,0)),u.ORIGIN_YZ_PLANE=a(new u(e.UNIT_X,0)),u.ORIGIN_ZX_PLANE=a(new u(e.UNIT_Y,0)),u}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,r,n,a,i,o,u,s,c,l,f){"use strict";function d(e,t,r){var n=S;n.length=e;var a;if(t===r){for(a=0;a<e;a++)n[a]=t;return n}var i=r-t,o=i/e;for(a=0;a<e;a++){var u=t+a*o;n[a]=u}return n}function h(t,r,n,a,i,o,u,s){var c=a.scaleToGeodeticSurface(t,I),l=a.scaleToGeodeticSurface(r,M),f=p.numberOfPoints(t,r,n),h=a.cartesianToCartographic(c,N),m=a.cartesianToCartographic(l,w),E=d(f,i,o);x.setEndPoints(h,m);var y=x.surfaceDistance/f,_=s;h.height=i;var T=a.cartographicToCartesian(h,O);e.pack(T,u,_),_+=3;for(var R=1;R<f;R++){var v=x.interpolateUsingSurfaceDistance(R*y,w);v.height=E[R],T=a.cartographicToCartesian(v,O),e.pack(T,u,_),_+=3}return _}var p={};p.numberOfPoints=function(t,r,n){var a=e.distance(t,r);return Math.ceil(a/n)};var m=new t;p.extractHeights=function(e,t){for(var r=e.length,n=new Array(r),a=0;a<r;a++){var i=e[a];n[a]=t.cartesianToCartographic(i,m).height}return n};var E=new l,y=new e,_=new e,T=new f(e.UNIT_X,0),R=new e,v=new f(e.UNIT_X,0),A=new e,g=new e,S=[],N=new t,w=new t,O=new e,I=new e,M=new e,x=new o;return p.wrapLongitude=function(t,a){var i=[],o=[];if(n(t)&&t.length>0){a=r(a,l.IDENTITY);var s=l.inverseTransformation(a,E),c=l.multiplyByPoint(s,e.ZERO,y),d=e.normalize(l.multiplyByPointAsVector(s,e.UNIT_Y,_),_),h=f.fromPointNormal(c,d,T),p=e.normalize(l.multiplyByPointAsVector(s,e.UNIT_X,R),R),m=f.fromPointNormal(c,p,v),S=1;i.push(e.clone(t[0]));for(var N=i[0],w=t.length,O=1;O<w;++O){var I=t[O];if(f.getPointDistance(m,N)<0||f.getPointDistance(m,I)<0){var M=u.lineSegmentPlane(N,I,h,A);if(n(M)){var x=e.multiplyByScalar(d,5e-9,g);f.getPointDistance(h,N)<0&&e.negate(x,x),i.push(e.add(M,x,new e)),o.push(S+1),e.negate(x,x),i.push(e.add(M,x,new e)),S=1}}i.push(e.clone(t[O])),S++,N=I}o.push(S)}return{positions:i,lengths:o}},p.generateArc=function(t){n(t)||(t={});var a=t.positions,o=a.length,u=r(t.ellipsoid,i.WGS84),l=r(t.height,0),f=s(l);if(o<1)return[];if(1===o){var d=u.scaleToGeodeticSurface(a[0],I);if(0!==(l=f?l[0]:l)){var m=u.geodeticSurfaceNormal(d,O);e.multiplyByScalar(m,l,m),e.add(d,m,d)}return[d.x,d.y,d.z]}var E=t.minDistance;if(!n(E)){var y=r(t.granularity,c.RADIANS_PER_DEGREE);E=c.chordLength(y,u.maximumRadius)}var _,T=0;for(_=0;_<o-1;_++)T+=p.numberOfPoints(a[_],a[_+1],E);var R=3*(T+1),v=new Array(R),A=0;for(_=0;_<o-1;_++){A=h(a[_],a[_+1],E,u,f?l[_]:l,f?l[_+1]:l,v,A)}S.length=0;var g=a[o-1],w=u.cartesianToCartographic(g,N);w.height=f?l[o-1]:l;var M=u.cartographicToCartesian(w,O);return e.pack(M,v,R-3),v},p.generateCartesianArc=function(t){for(var r=p.generateArc(t),n=r.length/3,a=new Array(n),i=0;i<n;i++)a[i]=e.unpack(r,3*i);return a},p}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n]=e.y,r},o.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new o),a.x=e[n++],a.y=e[n],a},o.packArray=function(e,t){var n=e.length;r(t)?t.length=2*n:t=new Array(2*n);for(var a=0;a<n;++a)o.pack(e[a],t,2*a);return t},o.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/2:t=new Array(n/2);for(var a=0;a<n;a+=2){var i=a/2;t[i]=o.unpack(e,a,t[i])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y)},o.minimumComponent=function(e){return Math.min(e.x,e.y)},o.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},o.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var r=o.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y},o.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},o.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r},o.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},o.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},o.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},o.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var s=new o;o.lerp=function(e,t,r,n){return o.multiplyByScalar(t,r,s),n=o.multiplyByScalar(e,1-r,n),o.add(s,n,n)};var c=new o,l=new o;o.angleBetween=function(e,t){return o.normalize(e,c),o.normalize(t,l),i.acosClamped(o.dot(c,l))};var f=new o;return o.mostOrthogonalAxis=function(e,t){var r=o.normalize(e,f);return o.abs(r,r),t=r.x<=r.y?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Y,t)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)},o.ZERO=a(new o(0,0)),o.UNIT_X=a(new o(1,0)),o.UNIT_Y=a(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./Check","./defaultValue","./defined","./Intersect"],function(e,t,r,n,a){"use strict";function i(t,a,i){this.minimum=e.clone(r(t,e.ZERO)),this.maximum=e.clone(r(a,e.ZERO)),n(i)?i=e.clone(i):(i=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(i,.5,i)),this.center=i}i.fromPoints=function(t,r){if(n(r)||(r=new i),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var a=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,d=1;d<f;d++){var h=t[d],p=h.x,m=h.y,E=h.z;a=Math.min(p,a),s=Math.max(p,s),o=Math.min(m,o),c=Math.max(m,c),u=Math.min(E,u),l=Math.max(E,l)}var y=r.minimum;y.x=a,y.y=o,y.z=u;var _=r.maximum;_.x=s,_.y=c,_.z=l;var T=e.add(y,_,r.center);return e.multiplyByScalar(T,.5,T),r},i.clone=function(t,r){if(n(t))return n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new i(t.minimum,t.maximum,t.center)},i.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var o=new e;return i.intersectPlane=function(t,r){o=e.subtract(t.maximum,t.minimum,o);var n=e.multiplyByScalar(o,.5,o),i=r.normal,u=n.x*Math.abs(i.x)+n.y*Math.abs(i.y)+n.z*Math.abs(i.z),s=e.dot(t.center,i)+r.distance;return s-u>0?a.INSIDE:s+u<0?a.OUTSIDE:a.INTERSECTING},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.intersectPlane=function(e){return i.intersectPlane(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,a){return t(e).then(r,n,a)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=o(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=a(e),t}function r(t){return e(t,i)}function n(e){this.then=e}function a(e){return new n(function(r){try{return t(r?r(e):e)}catch(e){return i(e)}})}function i(e){return new n(function(r,n){try{return n?t(n(e)):i(e)}catch(e){return i(e)}})}function o(){function e(e,t,r){return d(e,t,r)}function r(e){return p(e)}function a(e){return p(i(e))}function u(e){return h(e)}var s,c,l,f,d,h,p;return c=new n(e),s={then:e,resolve:r,reject:a,progress:u,promise:c,resolver:{resolve:r,reject:a,progress:u}},l=[],f=[],d=function(e,t,r){var n,a;return n=o(),a="function"==typeof r?function(e){try{n.progress(r(e))}catch(e){n.progress(e)}}:function(e){n.progress(e)},l.push(function(r){r.then(e,t).then(n.resolve,n.reject,a)}),f.push(a),n.promise},h=function(e){return m(f,e),e},p=function(e){return e=t(e),d=e.then,p=t,h=y,m(l,e),f=l=v,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,a,i){return E(2,arguments),e(t,function(t){function u(e){m(e)}function s(e){p(e)}var c,l,f,d,h,p,m,E,_,T;if(_=t.length>>>0,c=Math.max(0,Math.min(r,_)),f=[],l=_-c+1,d=[],h=o(),c)for(E=h.progress,m=function(e){d.push(e),--l||(p=m=y,h.reject(d))},p=function(e){f.push(e),--c||(p=m=y,h.resolve(f))},T=0;T<_;++T)T in t&&e(t[T],s,u,E);else h.resolve(f);return h.then(n,a,i)})}function c(e,t,r,n){function a(e){return t?t(e[0]):e[0]}return s(e,1,a,r,n)}function l(e,t,r,n){return E(1,arguments),d(e,_).then(t,r,n)}function f(){return d(arguments,_)}function d(t,r){return e(t,function(t){var n,a,i,u,s,c;if(i=a=t.length>>>0,n=[],c=o(),i)for(u=function(t,a){e(t,r).then(function(e){n[a]=e,--i||c.resolve(n)},c.reject)},s=0;s<a;s++)s in t?u(t[s],s):--i;else c.resolve(n);return c.promise})}function h(t,r){var n=R.call(arguments,1);return e(t,function(t){var a;return a=t.length,n[0]=function(t,n,i){return e(t,function(t){return e(n,function(e){return r(t,e,i,a)})})},T.apply(t,n)})}function p(t,r,n){var a=arguments.length>2;return e(t,function(e){return e=a?n:e,r.resolve(e),e},function(e){return r.reject(e),i(e)},r.progress)}function m(e,t){for(var r,n=0;r=e[n++];)r(t)}function E(e,t){for(var r,n=t.length;n>e;)if(null!=(r=t[--n])&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function y(){}function _(e){return e}var T,R,v;return e.defer=o,e.resolve=t,e.reject=r,e.join=f,e.all=l,e.map=d,e.reduce=h,e.any=c,e.some=s,e.chain=p,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(v,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(v,t)})})}},R=[].slice,T=[].reduce||function(e){var t,r,n,a,i;if(i=0,t=Object(this),a=t.length>>>0,r=arguments,r.length<=1)for(;;){if(i in t){n=t[i++];break}if(++i>=a)throw new TypeError}else n=r[1];for(;i<a;++i)i in t&&(n=e(n,t[i],i,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./Check"],function(e){"use strict";function t(e,t,r){for(var n,a,i=0,o=e.length-1;i<=o;)if(n=~~((i+o)/2),(a=r(e[n],t))<0)i=n+1;else{if(!(a>0))return n;o=n-1}return~(o+1)}return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,n,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=a}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],a=function(e,t,r,n){r||(r=" ");var a=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+a:a+e},i=function(e,t,r,n,i,o){var u=n-e.length;return u>0&&(e=r||!i?a(e,n,o,r):e.slice(0,t.length)+a("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,u,s){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+a(c.toString(t),u||0,"0",!1),i(e,r,n,o,s)},u=function(e,t,r,n,a,o){return null!=n&&(e=e.slice(0,n)),i(e,"",t,r,a,o)},s=function(e,n,s,c,l,f,d){var h,p,m,E,y;if("%%"==e)return"%";for(var _=!1,T="",R=!1,v=!1,A=" ",g=s.length,S=0;s&&S<g;S++)switch(s.charAt(S)){case" ":T=" ";break;case"+":T="+";break;case"-":_=!0;break;case"'":A=s.charAt(S+1);break;case"0":R=!0;break;case"#":v=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,c<0&&(c=-c,_=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[r++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,y=n?t[n.slice(0,-1)]:t[r++],d){case"s":return u(String(y),_,c,f,R,A);case"c":return u(String.fromCharCode(+y),_,c,f,R);case"b":return o(y,2,v,_,c,f,R);case"o":return o(y,8,v,_,c,f,R);case"x":return o(y,16,v,_,c,f,R);case"X":return o(y,16,v,_,c,f,R).toUpperCase();case"u":return o(y,10,v,_,c,f,R);case"i":case"d":return h=+y||0,h=Math.round(h-h%1),p=h<0?"-":T,y=p+a(String(Math.abs(h)),f,"0",!1),i(y,p,_,c,R);case"e":case"E":case"f":case"F":case"g":case"G":return h=+y,p=h<0?"-":T,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],E=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],y=p+Math.abs(h)[m](f),i(y,p,_,c,R)[E]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,n,a,i,o,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=a,this.second=i,this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4==0&&e%100!=0||e%400==0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";return e({SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5})}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";return e({UTC:0,TAI:1})}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(e,t){return m.compare(e.julianDate,t.julianDate)}function f(e){_.julianDate=e;var r=m.leapSeconds,n=t(r,_,l);n<0&&(n=~n),n>=r.length&&(n=r.length-1);var a=r[n].offset;if(n>0){m.secondsDifference(r[n].julianDate,e)>a&&(n--,a=r[n].offset)}m.addSeconds(e,a,e)}function d(e,r){_.julianDate=e;var n=m.leapSeconds,a=t(n,_,l);if(a<0&&(a=~a),0===a)return m.addSeconds(e,-n[0].offset,r);if(a>=n.length)return m.addSeconds(e,-n[a-1].offset,r);var i=m.secondsDifference(n[a].julianDate,e);return 0===i?m.addSeconds(e,-n[a].offset,r):i<=1?void 0:m.addSeconds(e,-n[--a].offset,r)}function h(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,t-=s.SECONDS_PER_DAY*n,t<0&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function p(e,t,r,n,a,i,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;(n-=12)<0&&(n+=24);var f=i+(n*s.SECONDS_PER_HOUR+a*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}function m(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var a=0|e;t+=(e-a)*s.SECONDS_PER_DAY,h(a,t,this),n===c.UTC&&f(this)}var E=new i,y=[31,28,31,30,31,30,31,31,30,31,30,31],_=new u,T=/^(\d{4})$/,R=/^(\d{4})-(\d{2})$/,v=/^(\d{4})-?(\d{3})$/,A=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,g=/^(\d{4})-?(\d{2})-?(\d{2})$/,S=/([Z+\-])?(\d{2})?:?(\d{2})?$/,N=/^(\d{2})(\.\d+)?/.source+S.source,w=/^(\d{2}):?(\d{2})(\.\d+)?/.source+S.source,O=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+S.source;m.fromGregorianDate=function(e,t){var r=p(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(h(r[0],r[1],t),f(t),t):new m(r[0],r[1],c.UTC)},m.fromDate=function(e,t){var r=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(h(r[0],r[1],t),f(t),t):new m(r[0],r[1],c.UTC)},m.fromIso8601=function(e,t){e=e.replace(",",".");var r,a,i,u=e.split("T"),s=1,l=1,d=0,E=0,_=0,S=0,I=u[0],M=u[1];if(null!==(u=I.match(g)))r=+u[1],s=+u[2],l=+u[3];else if(null!==(u=I.match(R)))r=+u[1],s=+u[2];else if(null!==(u=I.match(T)))r=+u[1];else{var x;if(null!==(u=I.match(v)))r=+u[1],x=+u[2],i=o(r);else if(null!==(u=I.match(A))){r=+u[1];var C=+u[2],P=+u[3]||0,U=new Date(Date.UTC(r,0,4));x=7*C+P-U.getUTCDay()-3}a=new Date(Date.UTC(r,0,1)),a.setUTCDate(x),s=a.getUTCMonth()+1,l=a.getUTCDate()}i=o(r);var D;if(n(M)){u=M.match(O),null!==u?(d=+u[1],E=+u[2],_=+u[3],S=1e3*+(u[4]||0),D=5):(u=M.match(w),null!==u?(d=+u[1],E=+u[2],_=60*+(u[3]||0),D=4):null!==(u=M.match(N))&&(d=+u[1],E=60*+(u[2]||0),D=3));var L=u[D],b=+u[D+1],F=+(u[D+2]||0);switch(L){case"+":d-=b,E-=F;break;case"-":d+=b,E+=F;break;case"Z":break;default:E+=new Date(Date.UTC(r,s-1,l,d,E)).getTimezoneOffset()}}var B=60===_;for(B&&_--;E>=60;)E-=60,d++;for(;d>=24;)d-=24,l++;for(a=i&&2===s?29:y[s-1];l>a;)l-=a,s++,s>12&&(s-=12,r++),a=i&&2===s?29:y[s-1];for(;E<0;)E+=60,d--;for(;d<0;)d+=24,l--;for(;l<1;)s--,s<1&&(s+=12,r--),a=i&&2===s?29:y[s-1],l+=a;var z=p(r,s,l,d,E,_,S);return n(t)?(h(z[0],z[1],t),f(t)):t=new m(z[0],z[1],c.UTC),B&&m.addSeconds(t,1,t),t},m.now=function(e){return m.fromDate(new Date,e)};var I=new m(0,0,c.TAI);return m.toGregorianDate=function(e,t){var r=!1,a=d(e,I);n(a)||(m.addSeconds(e,-1,I),a=d(I,I),r=!0);var o=a.dayNumber,u=a.secondsOfDay;u>=43200&&(o+=1);var c=o+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var f=4e3*(c+1)/1461001|0;c=c-(1461*f/4|0)+31|0;var h=80*c/2447|0,p=c-(2447*h/80|0)|0;c=h/11|0;var E=h+2-12*c|0,y=100*(l-49)+f+c|0,_=u/s.SECONDS_PER_HOUR|0,T=u-_*s.SECONDS_PER_HOUR,R=T/s.SECONDS_PER_MINUTE|0;T-=R*s.SECONDS_PER_MINUTE;var v=0|T,A=(T-v)/s.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),r&&(v+=1),n(t)?(t.year=y,t.month=E,t.day=p,t.hour=_,t.minute=R,t.second=v,t.millisecond=A,t.isLeapSecond=r,t):new i(y,E,p,_,R,v,A,r)},m.toDate=function(e){var t=m.toGregorianDate(e,E),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},m.toIso8601=function(t,r){var a,i=m.toGregorianDate(t,E);return n(r)||0===i.millisecond?n(r)&&0!==r?(a=(.01*i.millisecond).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(a=(.01*i.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a))},m.clone=function(e,t){if(n(e))return n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new m(e.dayNumber,e.secondsOfDay,c.TAI)},m.compare=function(e,t){var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},m.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},m.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(m.secondsDifference(e,t))<=r},m.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},m.secondsDifference=function(e,t){return(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},m.daysDifference=function(e,t){return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY},m.computeTaiMinusUtc=function(e){_.julianDate=e;var r=m.leapSeconds,n=t(r,_,l);return n<0&&(n=~n,--n<0&&(n=0)),r[n].offset},m.addSeconds=function(e,t,r){return h(e.dayNumber,e.secondsOfDay+t,r)},m.addMinutes=function(e,t,r){var n=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return h(e.dayNumber,n,r)},m.addHours=function(e,t,r){var n=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return h(e.dayNumber,n,r)},m.addDays=function(e,t,r){return h(e.dayNumber+t,e.secondsOfDay,r)},m.lessThan=function(e,t){return m.compare(e,t)<0},m.lessThanOrEquals=function(e,t){return m.compare(e,t)<=0},m.greaterThan=function(e,t){return m.compare(e,t)>0},m.greaterThanOrEquals=function(e,t){return m.compare(e,t)>=0},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m.prototype.equalsEpsilon=function(e,t){return m.equalsEpsilon(this,e,t)},m.prototype.toString=function(){return m.toIso8601(this)},m.leapSeconds=[new u(new m(2441317,43210,c.TAI),10),new u(new m(2441499,43211,c.TAI),11),new u(new m(2441683,43212,c.TAI),12),new u(new m(2442048,43213,c.TAI),13),new u(new m(2442413,43214,c.TAI),14),new u(new m(2442778,43215,c.TAI),15),new u(new m(2443144,43216,c.TAI),16),new u(new m(2443509,43217,c.TAI),17),new u(new m(2443874,43218,c.TAI),18),new u(new m(2444239,43219,c.TAI),19),new u(new m(2444786,43220,c.TAI),20),new u(new m(2445151,43221,c.TAI),21),new u(new m(2445516,43222,c.TAI),22),new u(new m(2446247,43223,c.TAI),23),new u(new m(2447161,43224,c.TAI),24),new u(new m(2447892,43225,c.TAI),25),new u(new m(2448257,43226,c.TAI),26),new u(new m(2448804,43227,c.TAI),27),new u(new m(2449169,43228,c.TAI),28),new u(new m(2449534,43229,c.TAI),29),new u(new m(2450083,43230,c.TAI),30),new u(new m(2450630,43231,c.TAI),31),new u(new m(2451179,43232,c.TAI),32),new u(new m(2453736,43233,c.TAI),33),new u(new m(2454832,43234,c.TAI),34),new u(new m(2456109,43235,c.TAI),35),new u(new m(2457204,43236,c.TAI),36),new u(new m(2457754,43237,c.TAI),37)],m}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,r).replace(a,t)),this.path&&(this.path=this.path.replace(a,t)),this.query&&(this.query=this.query.replace(a,t)),this.fragment&&(this.fragment=this.fragment.replace(a,t))};var a=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]&&t.shift();t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);"."!=e&&".."!=e||r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/appendForwardSlash",[],function(){"use strict";function e(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}return e}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var a=new r.constructor;for(var i in r)if(r.hasOwnProperty(i)){var o=r[i];n&&(o=t(o,n)),a[i]=o}return a}return t}),define("Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";function r(n,a,i){i=e(i,!1);var o,u,s,c={},l=t(n),f=t(a);if(l)for(o in n)n.hasOwnProperty(o)&&(u=n[o],f&&i&&"object"==typeof u&&a.hasOwnProperty(o)?(s=a[o],c[o]="object"==typeof s?r(u,s,i):u):c[o]=u);if(f)for(o in a)a.hasOwnProperty(o)&&!c.hasOwnProperty(o)&&(s=a[o],c[o]=s);return c}return r}),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r,n){t(a[r])||(a[r]=!0,console.warn(e(n,r)))}var a={};return n.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",n.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",n}),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],function(e,t,r){"use strict";function n(e,t){r(e,t)}return n}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function a(e,t){var r;return"undefined"!=typeof document&&(r=document),a._implementation(e,t,r)}return a._implementation=function(n,a,i){if(!r(a)){if(void 0===i)return n;a=t(i.baseURI,i.location.href)}var o=new e(a);return new e(n).resolve(o).toString()},a}),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r,n){var a="",i=r.lastIndexOf("/");return-1!==i&&(a=r.substring(0,i+1)),n?(r=new e(r),t(r.query)&&(a+="?"+r.query),t(r.fragment)&&(a+="#"+r.fragment),a):a}return n}),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(t){var r=new e(t);r.normalize();var n=r.path,a=n.lastIndexOf("/");return-1!==a&&(n=n.substr(a+1)),a=n.lastIndexOf("."),n=-1===a?"":n.substr(a+1)}return n}),define("Core/isBlobUri",["./Check"],function(e){"use strict";function t(e){return r.test(e)}var r=/^blob:/i;return t}),define("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";function t(t){e(r)||(r=document.createElement("a")),r.href=window.location.href;var n=r.host,a=r.protocol;return r.href=t,r.href=r.href,a!==r.protocol||n!==r.host}var r;return t}),define("Core/isDataUri",["./Check"],function(e){"use strict";function t(e){return r.test(e)}var r=/^data:/i;return t}),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(e){var t="";for(var n in e)if(e.hasOwnProperty(n)){var a=e[n],i=encodeURIComponent(n)+"=";if(r(a))for(var o=0,u=a.length;o<u;++o)t+=i+encodeURIComponent(a[o])+"&";else t+=i+encodeURIComponent(a)+"&"}return t=t.slice(0,-1)}return n}),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(t){var n={};if(""===t)return n;for(var a=t.replace(/\+/g,"%20").split(/[&;]/),i=0,o=a.length;i<o;++i){
var u=a[i].split("="),s=decodeURIComponent(u[0]),c=u[1];c=e(c)?decodeURIComponent(c):"";var l=n[s];"string"==typeof l?n[s]=[l,c]:r(l)?l.push(c):n[s]=c}return n}return n}),define("Core/RequestState",["../Core/freezeObject"],function(e){"use strict";return e({UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5})}),define("Core/RequestType",["../Core/freezeObject"],function(e){"use strict";return e({TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3})}),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],function(e,t,r,n){"use strict";function a(t){t=e(t,e.EMPTY_OBJECT);var a=e(t.throttleByServer,!1),i=a||e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=i,this.throttleByServer=a,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return a.prototype.cancel=function(){this.cancelled=!0},a.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new a(this)},a}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var a=r[n],i=a.indexOf(": ");if(i>0){var o=a.substring(0,i),u=a.substring(i+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/Event",["./Check","./defined","./defineProperties"],function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function a(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);var r=this;return function(){r.removeEventListener(e,t)}},n.prototype.removeEventListener=function(e,t){for(var r=this._listeners,n=this._scopes,a=-1,i=0;i<r.length;i++)if(r[i]===e&&n[i]===t){a=i;break}return-1!==a&&(this._insideRaiseEvent?(this._toRemove.push(a),r[a]=void 0,n[a]=void 0):(r.splice(a,1),n.splice(a,1)),!0)},n.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var e,r=this._listeners,n=this._scopes,i=r.length;for(e=0;e<i;e++){var o=r[e];t(o)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if((i=u.length)>0){for(u.sort(a),e=0;e<i;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n}),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],function(e,t,r,n){"use strict";function a(e){this._comparator=e.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function i(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(a.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),a.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},a.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,a=this._array,o=-1,u=!0;u;){var s=2*(e+1),c=s-1;o=c<r&&n(a[c],a[e])<0?c:e,s<r&&n(a[s],a[o])<0&&(o=s),o!==e?(i(a,o,e),e=o):u=!1}},a.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},a.prototype.insert=function(e){var t=this._array,n=this._comparator,a=this._maximumLength,o=this._length++;for(o<t.length?t[o]=e:t.push(e);0!==o;){var u=Math.floor((o-1)/2);if(!(n(t[o],t[u])<0))break;i(t,o,u),o=u}var s;return r(a)&&this._length>a&&(s=t[a],this._length=a),s},a.prototype.pop=function(e){if(e=t(e,0),0!==this._length){var r=this._array,n=r[e];return i(r,e,--this._length),this.heapify(e),n}},a}),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState"],function(e,t,r,n,a,i,o,u,s,c,l){"use strict";function f(e,t){return e.priority-t.priority}function d(){}function h(e){a(e.priorityFunction)&&(e.priority=e.priorityFunction())}function p(e){var t=n(d.requestsByServer[e],d.maximumRequestsPerServer);return w[e]<t}function m(e){return e.state===l.UNISSUED&&(e.state=l.ISSUED,e.deferred=t.defer()),e.deferred.promise}function E(e){return function(t){e.state!==l.CANCELLED&&(--A.numberOfActiveRequests,--w[e.serverKey],I.raiseEvent(),e.state=l.RECEIVED,e.deferred.resolve(t))}}function y(e){return function(t){e.state!==l.CANCELLED&&(++A.numberOfFailedRequests,--A.numberOfActiveRequests,--w[e.serverKey],I.raiseEvent(t),e.state=l.FAILED,e.deferred.reject(t))}}function _(e){var t=m(e);return e.state=l.ACTIVE,N.push(e),++A.numberOfActiveRequests,++A.numberOfActiveRequestsEver,++w[e.serverKey],e.requestFunction().then(E(e)).otherwise(y(e)),t}function T(e){var t=e.state===l.ACTIVE;e.state=l.CANCELLED,++A.numberOfCancelledRequests,e.deferred.reject(),t&&(--A.numberOfActiveRequests,--w[e.serverKey],++A.numberOfCancelledActiveRequests),a(e.cancelFunction)&&e.cancelFunction()}function R(){A.numberOfAttemptedRequests=0,A.numberOfCancelledRequests=0,A.numberOfCancelledActiveRequests=0}function v(){d.debugShowStatistics&&(A.numberOfAttemptedRequests>0&&console.log("Number of attempted requests: "+A.numberOfAttemptedRequests),A.numberOfActiveRequests>0&&console.log("Number of active requests: "+A.numberOfActiveRequests),A.numberOfCancelledRequests>0&&console.log("Number of cancelled requests: "+A.numberOfCancelledRequests),A.numberOfCancelledActiveRequests>0&&console.log("Number of cancelled active requests: "+A.numberOfCancelledActiveRequests),A.numberOfFailedRequests>0&&console.log("Number of failed requests: "+A.numberOfFailedRequests),R())}var A={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0},g=20,S=new u({comparator:f});S.maximumLength=g,S.reserve(g);var N=[],w={},O="undefined"!=typeof document?new e(document.location.href):new e,I=new o;return d.maximumRequests=50,d.maximumRequestsPerServer=6,d.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},d.throttleRequests=!0,d.debugShowStatistics=!1,d.requestCompletedEvent=I,i(d,{statistics:{get:function(){return A}},priorityHeapLength:{get:function(){return g},set:function(e){if(e<g)for(;S.length>e;){var t=S.pop();T(t)}g=e,S.maximumLength=e,S.reserve(e)}}}),d.update=function(){var e,t,r=0,n=N.length;for(e=0;e<n;++e)t=N[e],t.cancelled&&T(t),t.state===l.ACTIVE?r>0&&(N[e-r]=t):++r;N.length-=r;var a=S.internalArray,i=S.length;for(e=0;e<i;++e)h(a[e]);S.resort();for(var o=Math.max(d.maximumRequests-N.length,0),u=0;u<o&&S.length>0;)t=S.pop(),t.cancelled?T(t):!t.throttleByServer||p(t.serverKey)?(_(t),++u):T(t);v()},d.getServerKey=function(t){var r=new e(t).resolve(O);r.normalize();var n=r.authority;/:/.test(n)||(n=n+":"+("https"===r.scheme?"443":"80"));var i=w[n];return a(i)||(w[n]=0),n},d.request=function(e){if(c(e.url)||s(e.url))return I.raiseEvent(),e.state=l.RECEIVED,e.requestFunction();if(++A.numberOfAttemptedRequests,a(e.serverKey)||(e.serverKey=d.getServerKey(e.url)),!d.throttleRequests||!e.throttle)return _(e);if(!(N.length>=d.maximumRequests)&&(!e.throttleByServer||p(e.serverKey))){h(e);var t=S.insert(e);if(a(t)){if(t===e)return;T(t)}return m(e)}},d.clearForSpecs=function(){for(;S.length>0;){T(S.pop())}for(var e=N.length,t=0;t<e;++t)T(N[t]);N.length=0,w={},A.numberOfAttemptedRequests=0,A.numberOfActiveRequests=0,A.numberOfCancelledRequests=0,A.numberOfCancelledActiveRequests=0,A.numberOfFailedRequests=0,A.numberOfActiveRequestsEver=0},d.numberOfActiveRequestsByServer=function(e){return w[e]},d.requestHeap=S,d}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r){var n=new e(r);n.normalize();var a=n.getAuthority();if(t(a)){if(-1!==a.indexOf("@")){a=a.split("@")[1]}if(-1===a.indexOf(":")){var i=n.getScheme();if(t(i)||(i=window.location.protocol,i=i.substring(0,i.length-1)),"http"===i)a+=":80";else{if("https"!==i)return;a+=":443"}}return a}}var a={},i={};return a.add=function(e,r){var n=e.toLowerCase()+":"+r;t(i[n])||(i[n]=!0)},a.remove=function(e,r){var n=e.toLowerCase()+":"+r;t(i[n])&&delete i[n]},a.contains=function(e){var r=n(e);return!(!t(r)||!t(i[r]))},a.clear=function(){i={}},a}),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./deprecationWarning","./DeveloperError","./FeatureDetection","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,p,m,E,y,_,T,R,v,A,g,S,N,w){"use strict";function O(e,t,r,n){var a=e.query;if(!u(a)||0===a.length)return{};var i;if(-1===a.indexOf("=")){var o={};o[a]=void 0,i=o}else i=R(a);t._queryParameters=r?C(i,t._queryParameters,n):i,e.query=void 0}function I(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=T(r):e.query=n[0]}function M(e,t){return u(e)?u(e.clone)?e.clone():a(e):t}function x(e){if(e.state===S.ISSUED||e.state===S.ACTIVE)throw new N("The Resource is already being fetched.");e.state=S.UNISSUED,e.deferred=void 0}function C(e,t,r){if(!r)return i(e,t);var n=a(e,!0);for(var o in t)if(t.hasOwnProperty(o)){var s=n[o],c=t[o];u(s)?(Array.isArray(s)||(s=n[o]=[s]),n[o]=s.concat(c)):n[o]=Array.isArray(c)?c.slice():c}return n}function P(t){t=o(t,o.EMPTY_OBJECT),"string"==typeof t&&(t={url:t}),this._url=void 0,this._templateValues=M(t.templateValues,{}),this._queryParameters=M(t.queryParameters,{}),this.headers=M(t.headers,{}),this.request=o(t.request,new v),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=o(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);O(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function U(e){var r=e.request;r.url=e.url,r.requestFunction=function(){var r=e.url,n=!1;e.isDataUri||e.isBlobUri||(n=e.isCrossOriginUrl);var a=t.defer();return P._Implementations.createImage(r,n,a),a.promise};var n=g.request(r);if(u(n))return n.otherwise(function(n){return r.state!==S.FAILED?t.reject(n):e.retryOnError(n).then(function(a){return a?(r.state=S.UNISSUED,r.deferred=void 0,U(e)):t.reject(n)})})}function D(e,r,n){var a={};a[r]=n,e.setQueryParameters(a);var i=e.request;i.url=e.url,i.requestFunction=function(){var r=t.defer();return window[n]=function(e){r.resolve(e);try{delete window[n]}catch(e){window[n]=void 0}},P._Implementations.loadAndExecuteScript(e.url,n,r),r.promise};var o=g.request(i);if(u(o))return o.otherwise(function(a){return i.state!==S.FAILED?t.reject(a):e.retryOnError(a).then(function(o){return o?(i.state=S.UNISSUED,i.deferred=void 0,D(e,r,n)):t.reject(a)})})}function L(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function b(e,t){for(var r=L(e,t),n=new ArrayBuffer(r.length),a=new Uint8Array(n),i=0;i<r.length;i++)a[i]=r.charCodeAt(i);return n}function F(e,t){t=o(t,"");var r=e[1],n=!!e[2],a=e[3];switch(t){case"":case"text":return L(n,a);case"arraybuffer":return b(n,a);case"blob":var i=b(n,a);return new Blob([i],{type:r});case"document":return(new DOMParser).parseFromString(L(n,a),r);case"json":return JSON.parse(L(n,a))}}function B(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function z(e,t,r,n,a,i,o){var u=require("url").parse(e),s="https:"===u.protocol?require("https"):require("http"),c=require("zlib"),l={protocol:u.protocol,hostname:u.hostname,port:u.port,path:u.path,query:u.query,method:r,headers:a};s.request(l).on("response",function(e){if(e.statusCode<200||e.statusCode>=300)return void i.reject(new A(e.statusCode,e,e.headers));var r=[];e.on("data",function(e){r.push(e)}),e.on("end",function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?c.gunzip(n,function(e,r){e?i.reject(new N("Error decompressing response.")):i.resolve(B(r,t))}):i.resolve(B(n,t))})}).on("error",function(e){i.reject(new A)}).end()}var q=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(e){return!1}}();P.createIfNeeded=function(e){return e instanceof P?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new P({url:e})},s(P,{isBlobSupported:{get:function(){return q}}}),s(P.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);O(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return m(this._url)}},isDataUri:{get:function(){return _(this._url)}},isBlobUri:{get:function(){return E(this._url)}},isCrossOriginUrl:{get:function(){return y(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),P.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&I(n,this);var a=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),i=this._templateValues,o=Object.keys(i);if(o.length>0)for(var s=0;s<o.length;s++){var c=o[s],l=i[c];a=a.replace(new RegExp("{"+c+"}","g"),encodeURIComponent(l))}return r&&u(this.proxy)&&(a=this.proxy.getURL(a)),a},P.prototype.setQueryParameters=function(e,t){this._queryParameters=t?C(this._queryParameters,e,!1):C(e,this._queryParameters,!1)},P.prototype.addQueryParameters=function(e,t){return c("Resource.addQueryParameters","addQueryParameters has been deprecated and will be removed 1.45. Use setQueryParameters or appendQueryParameters instead."),this.setQueryParameters(e,t)},P.prototype.appendQueryParameters=function(e){this._queryParameters=C(e,this._queryParameters,!0)},P.prototype.setTemplateValues=function(e,t){this._templateValues=t?i(this._templateValues,e):i(e,this._templateValues)},P.prototype.addTemplateValues=function(e,t){return c("Resource.addTemplateValues","addTemplateValues has been deprecated and will be removed 1.45. Use setTemplateValues."),this.setTemplateValues(e,t)},P.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url);O(n,r,!0,o(t.preserveQueryParameters,!1)),n.fragment=void 0,r._url=n.resolve(new e(h(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=i(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=i(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=i(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},P.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then(function(e){return++n._retryCount,e})},P.prototype.clone=function(e){return u(e)||(e=new P({url:this._url})),e._url=this._url,e._queryParameters=a(this._queryParameters),e._templateValues=a(this._templateValues),e.headers=a(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},P.prototype.getBaseUri=function(e){return p(this.getUrlComponent(e),e)},P.prototype.appendForwardSlash=function(){this._url=r(this._url)},P.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},P.fetchArrayBuffer=function(e){return new P(e).fetchArrayBuffer()},P.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},P.fetchBlob=function(e){return new P(e).fetchBlob()},P.prototype.fetchImage=function(e){if(e=o(e,!1),x(this.request),!q||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!e)return U(this,!0);var r=this.fetchBlob();if(u(r)){var n,a;return r.then(function(e){if(u(e)){a=e;var t=window.URL.createObjectURL(e);return n=new P({url:t}),U(n)}}).then(function(e){if(u(e))return window.URL.revokeObjectURL(n.url),e.blob=a,e}).otherwise(function(e){return u(n)&&window.URL.revokeObjectURL(n.url),t.reject(e)})}},P.fetchImage=function(e){return new P(e).fetchImage(e.preferBlob)},P.prototype.fetchText=function(){return this.fetch({responseType:"text"})},P.fetchText=function(e){return new P(e).fetchText()},P.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then(function(e){if(u(e))return JSON.parse(e)})},P.fetchJson=function(e){return new P(e).fetchJson()},P.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},P.fetchXML=function(e){return new P(e).fetchXML()},P.prototype.fetchJsonp=function(e){e=o(e,"callback"),x(this.request);var t;do{t="loadJsonp"+Math.random().toString().substring(2,8)}while(u(window[t]));return D(this,e,t)},P.fetchJsonp=function(e){return new P(e).fetchJsonp(e.callbackParameterName)},P.prototype._makeRequest=function(e){var r=this;x(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(){var a=e.responseType,o=i(e.headers,r.headers),s=e.overrideMimeType,c=e.method,l=e.data,f=t.defer(),d=P._Implementations.loadWithXhr(r.url,a,c,l,o,f,s);return u(d)&&u(d.abort)&&(n.cancelFunction=function(){d.abort()}),f.promise};var a=g.request(n);if(u(a))return a.then(function(e){return e}).otherwise(function(a){return n.state!==S.FAILED?t.reject(a):r.retryOnError(a).then(function(i){return i?(n.state=S.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(a)})})};var G=/^data:(.*?)(;base64)?,(.*)$/;return P.prototype.fetch=function(e){return e=M(e,{}),e.method="GET",this._makeRequest(e)},P.fetch=function(e){return new P(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},P.prototype.delete=function(e){return e=M(e,{}),e.method="DELETE",this._makeRequest(e)},P.delete=function(e){return new P(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},P.prototype.head=function(e){return e=M(e,{}),e.method="HEAD",this._makeRequest(e)},P.head=function(e){return new P(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},P.prototype.options=function(e){return e=M(e,{}),e.method="OPTIONS",this._makeRequest(e)},P.options=function(e){return new P(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},P.prototype.post=function(e,t){return n.defined("data",e),t=M(t,{}),t.method="POST",t.data=e,this._makeRequest(t)},P.post=function(e){return new P(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},P.prototype.put=function(e,t){return n.defined("data",e),t=M(t,{}),t.method="PUT",t.data=e,this._makeRequest(t)},P.put=function(e){return new P(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},P.prototype.patch=function(e,t){return n.defined("data",e),t=M(t,{}),t.method="PATCH",t.data=e,this._makeRequest(t)},P.patch=function(e){return new P(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},P._Implementations={},P._Implementations.createImage=function(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(w.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e},P._Implementations.loadWithXhr=function(e,t,r,n,a,i,o){var s=G.exec(e);if(null!==s)return void i.resolve(F(s,t));if(f.isNodeJs())return void z(e,t,r,n,a,i,o);var c=new XMLHttpRequest;if(w.contains(e)&&(c.withCredentials=!0),u(o)&&u(c.overrideMimeType)&&c.overrideMimeType(o),c.open(r,e,!0),u(a))for(var l in a)a.hasOwnProperty(l)&&c.setRequestHeader(l,a[l]);u(t)&&(c.responseType=t);var d=!1;return"string"==typeof e&&(d=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),c.onload=function(){if((c.status<200||c.status>=300)&&(!d||0!==c.status))return void i.reject(new A(c.status,c.response,c.getAllResponseHeaders()));var e=c.response,n=c.responseType;if("HEAD"===r||"OPTIONS"===r){var a=c.getAllResponseHeaders(),o=a.trim().split(/[\r\n]+/),s={};return o.forEach(function(e){var t=e.split(": "),r=t.shift();s[r]=t.join(": ")}),void i.resolve(s)}if(204===c.status)i.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{i.resolve(JSON.parse(e))}catch(e){i.reject(e)}else(""===n||"document"===n)&&u(c.responseXML)&&c.responseXML.hasChildNodes()?i.resolve(c.responseXML):""!==n&&"text"!==n||!u(c.responseText)?i.reject(new N("Invalid XMLHttpRequest response type.")):i.resolve(c.responseText);else i.resolve(e)},c.onerror=function(e){i.reject(new A)},c.send(n),c},P._Implementations.loadAndExecuteScript=function(e,t,r){var n=document.createElement("script");n.async=!0,n.src=e;var a=document.getElementsByTagName("head")[0];n.onload=function(){n.onload=void 0,a.removeChild(n)},n.onerror=function(e){r.reject(e)},a.appendChild(n)},P._DefaultImplementations={},P._DefaultImplementations.createImage=P._Implementations.createImage,P._DefaultImplementations.loadWithXhr=P._Implementations.loadWithXhr,P._DefaultImplementations.loadAndExecuteScript=P._Implementations.loadAndExecuteScript,P.DEFAULT=d(new P({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),P}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,a,i,o,u,s,c,l,f){"use strict";function d(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))p(this,t.data);else if(n(t.url)){var a=s.createIfNeeded(t.url),i=this;this._downloadPromise=e(a.fetchJson(),function(e){p(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+a.url+"."})}else p(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function h(e,t){return o.compare(e.julianDate,t)}function p(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var a=r.columnNames.indexOf("modifiedJulianDateUtc"),i=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),d=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=r.columnNames.indexOf("taiMinusUtcSeconds");if(a<0||i<0||s<0||c<0||d<0||p<0||m<0)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var E=e._samples=r.samples,y=e._dates=[];e._dateColumn=a,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=p,e._taiMinusUtcSecondsColumn=m,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _,T=e._addNewLeapSeconds,R=0,v=E.length;R<v;R+=e._columnCount){var A=E[R+a],g=E[R+m],S=A+l.MODIFIED_JULIAN_DATE_DIFFERENCE,N=new o(S,g,f.TAI);if(y.push(N),T){if(g!==_&&n(_)){var w=o.leapSeconds,O=t(w,N,h);if(O<0){var I=new u(N,g);w.splice(~O,0,I)}}_=g}}}function m(e,t,r,n,a){var i=r*n;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function E(e,t,r){return t+e*(r-t)}function y(e,t,r,n,a,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[a],l=t[i];if(c.equals(l)||n.equals(c))return m(e,r,a,s,u),u;if(n.equals(l))return m(e,r,i,s,u),u;var f=o.secondsDifference(n,c)/o.secondsDifference(l,c),d=a*s,h=i*s,p=r[d+e._ut1MinusUtcSecondsColumn],y=r[h+e._ut1MinusUtcSecondsColumn],_=y-p;if(_>.5||_<-.5){var T=r[d+e._taiMinusUtcSecondsColumn],R=r[h+e._taiMinusUtcSecondsColumn];T!==R&&(l.equals(n)?p=y:y-=R-T)}return u.xPoleWander=E(f,r[d+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=E(f,r[d+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=E(f,r[d+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=E(f,r[d+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=E(f,p,y),u}return d.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),d.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},d.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new a(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var i=this._dates,u=this._lastIndex,s=0,l=0;if(n(u)){var f=i[u],d=i[u+1],h=o.lessThanOrEquals(f,e),p=!n(d),m=p||o.greaterThanOrEquals(d,e);if(h&&m)return s=u,!p&&d.equals(e)&&++s,l=s+1,y(this,i,this._samples,e,s,l,r),r}var E=t(i,e,o.compare,this._dateColumn);return E>=0?(E<i.length-1&&i[E+1].equals(e)&&++E,s=E,l=E):(l=~E,(s=l-1)<0&&(s=0)),this._lastIndex=s,y(this,i,this._samples,e,s,l,r),r}if(n(this._dataError))throw new c(this._dataError)},d}),define("Core/buildModuleUrl",["./defined","./DeveloperError","./Resource","require"],function(e,t,r,n){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;t<r;++t){var n=e[t].getAttribute("src"),a=d.exec(n);if(null!==a)return a[1]}}function i(){if(e(c))return c;var t;return t="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:a(),c=new r({url:t}),c.appendForwardSlash(),c}function o(e){return n.toUrl("../"+e)}function u(e){return i().getDerivedResource({url:e}).url}function s(t){if("undefined"==typeof document)return t;e(l)||(l=e(define.amd)&&!define.amd.toUrlUndefined&&e(n.toUrl)?o:u),e(f)||(f=document.createElement("a"));var r=l(t);return f.href=r,f.href=f.href,f.href}var c,l,f,d=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return s._cesiumScriptRegex=d,s._buildModuleUrlFromBaseUrl=u,s._clearBaseResource=function(){c=void 0},s.setBaseUrl=function(e){c=r.DEFAULT.getDerivedResource({url:e})},s}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],function(e,t,r,n,a,i,o,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=o.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),a=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;c<=t;++c){n[c]=s,a[c]=c*this._stepSizeDays;for(var l=0;l<=t;++l)l!==c&&(n[c]*=c-l);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,r){var n=f;return n.dayNumber=t,n.secondsOfDay=r,i.daysDifference(n,e._sampleZeroDateTT)}function l(r,a){if(r._chunkDownloadsInProgress[a])return r._chunkDownloadsInProgress[a];var i=e.defer();r._chunkDownloadsInProgress[a]=i;var u,s=r._xysFileUrlTemplate;return u=n(s)?s.getDerivedResource({templateValues:{0:a}}):new o({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+a+".json")}),e(u.fetchJson(),function(e){r._chunkDownloadsInProgress[a]=!1;for(var t=r._samples,n=e.samples,o=a*r._samplesPerXysFile*3,u=0,s=n.length;u<s;++u)t[o+u]=n[u];i.resolve()}),i.promise}var f=new i(0,0,u.TAI);return s.prototype.preload=function(t,r,n,a){var i=c(this,t,r),o=c(this,n,a),u=i/this._stepSizeDays-this._interpolationOrder/2|0;u<0&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,d=s/this._samplesPerXysFile|0,h=[],p=f;p<=d;++p)h.push(l(this,p));return e.all(h)},s.prototype.computeXysRadians=function(e,t,r){var i=c(this,e,t);if(!(i<0)){var o=i/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);s<0&&(s=0);var f=s+u;f>=this._totalSamples&&(f=this._totalSamples-1,(s=f-u)<0&&(s=0));var d=!1,h=this._samples;if(n(h[3*s])||(l(this,s/this._samplesPerXysFile|0),d=!0),n(h[3*f])||(l(this,f/this._samplesPerXysFile|0),d=!0),!d){n(r)?(r.x=0,r.y=0,r.s=0):r=new a(0,0,0);var p,m,E=i-s*this._stepSizeDays,y=this._work,_=this._denominators,T=this._coef,R=this._xTable;for(p=0;p<=u;++p)y[p]=E-R[p];for(p=0;p<=u;++p){for(T[p]=1,m=0;m<=u;++m)m!==p&&(T[p]*=y[m]);T[p]*=_[p];var v=3*(s+p);r.x+=T[p]*h[v++],r.y+=T[p]*h[v++],r.s+=T[p]*h[v]}return r}}}},s}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,t,n,a){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(a,0)}var c=new e;s.fromAxisAngle=function(t,r,a){var i=r/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,f=c.z*o,d=Math.cos(i);return n(a)?(a.x=u,a.y=l,a.z=f,a.w=d,a):new s(u,l,f,d)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,t){var r,a,i,o,c,d=e[u.COLUMN0ROW0],h=e[u.COLUMN1ROW1],p=e[u.COLUMN2ROW2],m=d+h+p;if(m>0)r=Math.sqrt(m+1),c=.5*r,r=.5/r,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*r,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*r,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*r;else{var E=l,y=0;h>d&&(y=1),p>d&&p>h&&(y=2);var _=E[y],T=E[_];r=Math.sqrt(e[u.getElementIndex(y,y)]-e[u.getElementIndex(_,_)]-e[u.getElementIndex(T,T)]+1);var R=f;R[y]=.5*r,r=.5/r,c=(e[u.getElementIndex(T,_)]-e[u.getElementIndex(_,T)])*r,
R[_]=(e[u.getElementIndex(_,y)]+e[u.getElementIndex(y,_)])*r,R[T]=(e[u.getElementIndex(T,y)]+e[u.getElementIndex(y,T)])*r,a=-R[0],i=-R[1],o=-R[2]}return n(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var d=new s,h=new s,p=new s,m=new s;s.fromHeadingPitchRoll=function(t,r){return m=s.fromAxisAngle(e.UNIT_X,t.roll,d),p=s.fromAxisAngle(e.UNIT_Y,-t.pitch,r),r=s.multiply(p,m,p),h=s.fromAxisAngle(e.UNIT_Z,-t.heading,d),s.multiply(h,r,r)};var E=new e,y=new e,_=new s,T=new s,R=new s;s.packedLength=4,s.pack=function(e,t,n){return n=r(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.z,t[n]=e.w,t},s.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new s),a.x=e[t],a.y=e[t+1],a.z=e[t+2],a.w=e[t+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,R),s.conjugate(R,R);for(var a=0,i=r-t+1;a<i;a++){var o=3*a;s.unpack(e,4*(t+a),_),s.multiply(_,R,_),_.w<0&&s.negate(_,_),s.computeAxis(_,E);var u=s.computeAngle(_);n[o]=E.x*u,n[o+1]=E.y*u,n[o+2]=E.z*u}},s.unpackInterpolationResult=function(t,r,a,i,o){n(o)||(o=new s),e.fromArray(t,0,y);var u=e.magnitude(y);return s.unpack(r,4*i,T),0===u?s.clone(s.IDENTITY,_):s.fromAxisAngle(y,u,_),s.multiply(_,T,o)},s.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w)},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var r=1/s.magnitude(e),n=e.x*r,a=e.y*r,i=e.z*r,o=e.w*r;return t.x=n,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var r=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/r,t)},s.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},s.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,f=o*u+n*l+a*c-i*s,d=o*s-n*c+a*l+i*u,h=o*c+n*s-a*u+i*l,p=o*l-n*u-a*s-i*c;return r.x=f,r.y=d,r.z=h,r.w=p,r},s.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},s.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},s.computeAxis=function(e,t){var r=e.w;if(Math.abs(r-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var n=1/Math.sqrt(1-r*r);return t.x=e.x*n,t.y=e.y*n,t.z=e.z*n,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var v=new s;s.lerp=function(e,t,r,n){return v=s.multiplyByScalar(t,r,v),n=s.multiplyByScalar(e,1-r,n),s.add(v,n,n)};var A=new s,g=new s,S=new s;s.slerp=function(e,t,r,n){var a=s.dot(e,t),i=t;if(a<0&&(a=-a,i=A=s.negate(t,A)),1-a<o.EPSILON6)return s.lerp(e,i,r,n);var u=Math.acos(a);return g=s.multiplyByScalar(e,Math.sin((1-r)*u),g),S=s.multiplyByScalar(i,Math.sin(r*u),S),n=s.add(g,S,n),s.multiplyByScalar(n,1/Math.sin(u),n)},s.log=function(t,r){var n=o.acosClamped(t.w),a=0;return 0!==n&&(a=n/Math.sin(n)),e.multiplyByScalar(t,a,r)},s.exp=function(t,r){var n=e.magnitude(t),a=0;return 0!==n&&(a=Math.sin(n)/n),r.x=t.x*a,r.y=t.y*a,r.z=t.z*a,r.w=Math.cos(n),r};var N=new e,w=new e,O=new s,I=new s;s.computeInnerQuadrangle=function(t,r,n,a){var i=s.conjugate(r,O);s.multiply(i,n,I);var o=s.log(I,N);s.multiply(i,t,I);var u=s.log(I,w);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,O),s.multiply(r,O,a)},s.squad=function(e,t,r,n,a,i){var o=s.slerp(e,t,a,O),u=s.slerp(r,n,a,I);return s.slerp(o,u,2*a*(1-a),i)};for(var M=new s,x=1.9011074535173003,C=a.supportsTypedArrays()?new Float32Array(8):[],P=a.supportsTypedArrays()?new Float32Array(8):[],U=a.supportsTypedArrays()?new Float32Array(8):[],D=a.supportsTypedArrays()?new Float32Array(8):[],L=0;L<7;++L){var b=L+1,F=2*b+1;C[L]=1/(b*F),P[L]=b/F}return C[7]=x/136,P[7]=8*x/17,s.fastSlerp=function(e,t,r,n){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-r,c=r*r,l=u*u,f=7;f>=0;--f)U[f]=(C[f]*c-P[f])*o,D[f]=(C[f]*l-P[f])*o;var d=a*r*(1+U[0]*(1+U[1]*(1+U[2]*(1+U[3]*(1+U[4]*(1+U[5]*(1+U[6]*(1+U[7])))))))),h=u*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),p=s.multiplyByScalar(e,h,M);return s.multiplyByScalar(t,d,n),s.add(p,n,n)},s.fastSquad=function(e,t,r,n,a,i){var o=s.fastSlerp(e,t,a,O),u=s.fastSlerp(r,n,a,I);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.x-t.x)<=r&&Math.abs(e.y-t.y)<=r&&Math.abs(e.z-t.z)<=r&&Math.abs(e.w-t.w)<=r},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,p,m,E,y,_,T){"use strict";var R={},v={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},A={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},g={},S={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},N=new r,w=new r,O=new r;R.localFrameToFixedFrameGenerator=function(e,t){if(!v.hasOwnProperty(e)||!v[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,a=v[e][t],i=e+t;return u(g[i])?n=g[i]:(n=function(n,i,s){if(u(s)||(s=new y),m.equalsEpsilon(n.x,0,m.EPSILON14)&&m.equalsEpsilon(n.y,0,m.EPSILON14)){var c=m.sign(n.z);r.unpack(A[e],0,N),"east"!==e&&"west"!==e&&r.multiplyByScalar(N,c,N),r.unpack(A[t],0,w),"east"!==t&&"west"!==t&&r.multiplyByScalar(w,c,w),r.unpack(A[a],0,O),"east"!==a&&"west"!==a&&r.multiplyByScalar(O,c,O)}else{i=o(i,f.WGS84),i.geodeticSurfaceNormal(n,S.up);var l=S.up,d=S.east;d.x=-n.y,d.y=n.x,d.z=0,r.normalize(d,S.east),r.cross(l,d,S.north),r.multiplyByScalar(S.up,-1,S.down),r.multiplyByScalar(S.east,-1,S.west),r.multiplyByScalar(S.north,-1,S.south),N=S[e],w=S[t],O=S[a]}return s[0]=N.x,s[1]=N.y,s[2]=N.z,s[3]=0,s[4]=w.x,s[5]=w.y,s[6]=w.z,s[7]=0,s[8]=O.x,s[9]=O.y,s[10]=O.z,s[11]=0,s[12]=n.x,s[13]=n.y,s[14]=n.z,s[15]=1,s},g[i]=n),n},R.eastNorthUpToFixedFrame=R.localFrameToFixedFrameGenerator("east","north"),R.northEastDownToFixedFrame=R.localFrameToFixedFrameGenerator("north","east"),R.northUpEastToFixedFrame=R.localFrameToFixedFrameGenerator("north","up"),R.northWestUpToFixedFrame=R.localFrameToFixedFrameGenerator("north","west");var I=new _,M=new r(1,1,1),x=new y;R.headingPitchRollToFixedFrame=function(e,t,n,a,i){a=o(a,R.eastNorthUpToFixedFrame);var u=_.fromHeadingPitchRoll(t,I),s=y.fromTranslationQuaternionRotationScale(r.ZERO,u,M,x);return i=a(e,n,i),y.multiply(i,s,i)};var C=new y,P=new E;R.headingPitchRollQuaternion=function(e,t,r,n,a){var i=R.headingPitchRollToFixedFrame(e,t,r,n,C),o=y.getRotation(i,P);return _.fromRotationMatrix(o,a)};var U=m.TWO_PI/86400,D=new p;R.computeTemeToPseudoFixedMatrix=function(e,t){D=p.addSeconds(e,-p.computeTaiMinusUtc(e),D);var r,n=D.dayNumber,a=D.secondsOfDay,i=n-2451545;r=a>=43200?(i+.5)/T.DAYS_PER_JULIAN_CENTURY:(i-.5)/T.DAYS_PER_JULIAN_CENTURY;var o=24110.54841+r*(8640184.812866+r*(.093104+-62e-7*r)),s=o*U%m.TWO_PI,c=72921158553e-15+1.1772758384668e-19*(n-2451545.5),l=(a+.5*T.SECONDS_PER_DAY)%T.SECONDS_PER_DAY,f=s+c*l,d=Math.cos(f),h=Math.sin(f);return u(t)?(t[0]=d,t[1]=-h,t[2]=0,t[3]=h,t[4]=d,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(d,h,0,-h,d,0,0,0,1)},R.iau2006XysData=new d,R.earthOrientationParameters=c.NONE;R.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+32.184,a=t.stop.dayNumber,i=t.stop.secondsOfDay+32.184,o=R.iau2006XysData.preload(r,n,a,i),u=R.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},R.computeIcrfToFixedMatrix=function(e,t){u(t)||(t=new E);var r=R.computeFixedToIcrfMatrix(e,t);if(u(r))return E.transpose(r,t)};var L=new h(0,0,0),b=new l(0,0,0,0,0,0),F=new E,B=new E;R.computeFixedToIcrfMatrix=function(e,t){u(t)||(t=new E);var r=R.earthOrientationParameters.compute(e,b);if(u(r)){var n=e.dayNumber,a=e.secondsOfDay+32.184,i=R.iau2006XysData.computeXysRadians(n,a,L);if(u(i)){var o=i.x+r.xPoleOffset,s=i.y+r.yPoleOffset,c=1/(1+Math.sqrt(1-o*o-s*s)),l=F;l[0]=1-c*o*o,l[3]=-c*o*s,l[6]=o,l[1]=-c*o*s,l[4]=1-c*s*s,l[7]=s,l[2]=-o,l[5]=-s,l[8]=1-c*(o*o+s*s);var f=E.fromRotationZ(-i.s,B),d=E.multiply(l,f,F),h=e.dayNumber,y=e.secondsOfDay-p.computeTaiMinusUtc(e)+r.ut1MinusUtc,_=h-2451545,v=y/T.SECONDS_PER_DAY,A=.779057273264+v+.00273781191135448*(_+v);A=A%1*m.TWO_PI;var g=E.fromRotationZ(A,B),S=E.multiply(d,g,F),N=Math.cos(r.xPoleWander),w=Math.cos(r.yPoleWander),O=Math.sin(r.xPoleWander),I=Math.sin(r.yPoleWander),M=n-2451545+a/T.SECONDS_PER_DAY;M/=36525;var x=-47e-6*M*m.RADIANS_PER_DEGREE/3600,C=Math.cos(x),P=Math.sin(x),U=B;return U[0]=N*C,U[1]=N*P,U[2]=O,U[3]=-w*P+I*O*C,U[4]=w*C+I*O*P,U[5]=-I*N,U[6]=-I*P-w*O*C,U[7]=I*C-w*O*P,U[8]=w*N,E.multiply(S,U,t)}}};var z=new n;R.pointToWindowCoordinates=function(e,t,r,n){return n=R.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},R.pointToGLWindowCoordinates=function(e,r,a,i){u(i)||(i=new t);var o=z;return y.multiplyByVector(e,n.fromElements(a.x,a.y,a.z,1,o),o),n.multiplyByScalar(o,1/o.w,o),y.multiplyByVector(r,o,o),t.fromCartesian4(o,i)};var q=new r,G=new r,V=new r;R.rotationMatrixFromPositionVelocity=function(e,t,n,a){var i=o(n,f.WGS84).geodeticSurfaceNormal(e,q),s=r.cross(t,i,G);r.equalsEpsilon(s,r.ZERO,m.EPSILON6)&&(s=r.clone(r.UNIT_X,s));var c=r.cross(s,t,V);return r.cross(t,c,s),r.negate(s,s),u(a)||(a=new E),a[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=s.x,a[4]=s.y,a[5]=s.z,a[6]=c.x,a[7]=c.y,a[8]=c.z,a};var W=new y(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),X=new a,H=new r,Y=new r,k=new E,j=new y,Z=new y;return R.basisTo2D=function(e,t,n){var a=y.getTranslation(t,Y),i=e.ellipsoid,o=i.cartesianToCartographic(a,X),u=e.project(o,H);r.fromElements(u.z,u.x,u.y,u);var s=R.eastNorthUpToFixedFrame(a,i,j),c=y.inverseTransformation(s,Z),l=y.getRotation(t,k),f=y.multiplyByMatrix3(c,l,n);return y.multiply(W,f,n),y.setTranslation(n,u,n),n},R.wgs84To2DModelMatrix=function(e,t,n){var a=e.ellipsoid,i=R.eastNorthUpToFixedFrame(t,a,j),o=y.inverseTransformation(i,Z),u=a.cartesianToCartographic(t,X),s=e.project(u,H);r.fromElements(s.z,s.x,s.y,s);var c=y.fromTranslation(s,j);return y.multiply(W,o,n),y.multiply(c,n,n),n},R}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h){"use strict";function p(e,t){t=a(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var n=h.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(l.getColumn(n,0,m)),this._yAxis=r.fromCartesian4(l.getColumn(n,1,m));var i=r.fromCartesian4(l.getColumn(n,2,m));this._plane=f.fromPointNormal(e,i)}var m=new n;o(p.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var E=new e;p.fromPoints=function(t,r){return new p(e.fromPoints(t,E).center,r)};var y=new d,_=new r;p.prototype.projectPointOntoPlane=function(e,n){var a=y;a.origin=e,r.normalize(e,a.direction);var o=c.rayPlane(a,this._plane,_);if(i(o)||(r.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,_)),i(o)){var u=r.subtract(o,this._origin,o),s=r.dot(this._xAxis,u),l=r.dot(this._yAxis,u);return i(n)?(n.x=s,n.y=l,n):new t(s,l)}},p.prototype.projectPointsOntoPlane=function(e,t){i(t)||(t=[]);for(var r=0,n=e.length,a=0;a<n;a++){var o=this.projectPointOntoPlane(e[a],t[r]);i(o)&&(t[r]=o,r++)}return t.length=r,t},p.prototype.projectPointToNearestOnPlane=function(e,n){i(n)||(n=new t);var a=y;a.origin=e,r.clone(this._plane.normal,a.direction);var o=c.rayPlane(a,this._plane,_);i(o)||(r.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,_));var u=r.subtract(o,this._origin,o),s=r.dot(this._xAxis,u),l=r.dot(this._yAxis,u);return n.x=s,n.y=l,n},p.prototype.projectPointsToNearestOnPlane=function(e,t){i(t)||(t=[]);var r=e.length;t.length=r;for(var n=0;n<r;n++)t[n]=this.projectPointToNearestOnPlane(e[n],t[n]);return t};var T=new r;return p.prototype.projectPointsOntoEllipsoid=function(e,t){var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=T,l=0;l<n;++l){var f=e[l];r.multiplyByScalar(u,f.x,c),i(t[l])||(t[l]=new r);var d=r.add(o,c,t[l]);r.multiplyByScalar(s,f.y,c),r.add(d,c,d),a.scaleToGeocentricSurface(d,d)}return t},p}),define("Core/PolylineVolumeGeometryLibrary",["./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./EllipsoidTangentPlane","./Math","./Matrix3","./Matrix4","./PolylinePipeline","./Quaternion","./Transforms"],function(e,t,r,n,a,i,o,u,s,c,l,f){"use strict";function d(e,t){for(var r=new Array(e.length),n=0;n<e.length;n++){var a=e[n];U=t.cartesianToCartographic(a,U),r[n]=U.height,e[n]=t.scaleToGeodeticSurface(a,a)}return r}function h(e,r,n,a){var i,o=e[0],u=e[1],s=t.angleBetween(o,u),c=Math.ceil(s/a),l=new Array(c);if(r===n){for(i=0;i<c;i++)l[i]=r;return l.push(n),l}var f=n-r,d=f/c;for(i=1;i<c;i++){var h=r+i*d;l[i]=h}return l[0]=r,l.push(n),l}function p(r,n,a,o){var u=new i(a,o),s=u.projectPointOntoPlane(t.add(a,r,D),D),c=u.projectPointOntoPlane(t.add(a,n,L),L),l=e.angleBetween(s,c);return c.x*s.y-c.y*s.x>=0?-l:l}function m(e,r,n,a,i,o,c,l){var d=G,h=V;F=f.eastNorthUpToFixedFrame(e,i,F),d=s.multiplyByPointAsVector(F,b,d),d=t.normalize(d,d);var m=p(d,r,e,i);z=u.fromRotationZ(m,z),W.z=o,F=s.multiplyTransformation(F,s.fromRotationTranslation(z,W,B),F);var E=q;E[0]=c;for(var y=0;y<l;y++)for(var _=0;_<n.length;_+=3)h=t.fromArray(n,_,h),h=u.multiplyByVector(E,h,h),h=s.multiplyByPoint(F,h,h),a.push(h.x,h.y,h.z);return a}function E(e,r,n,a,i,o,u){for(var s=0;s<e.length;s+=3){a=m(t.fromArray(e,s,X),r,n,a,i,o[s/3],u,1)}return a}function y(e,t){var r=e.length,n=new Array(6*r),a=0,i=t.x+t.width/2,o=t.y+t.height/2,u=e[0];n[a++]=u.x-i,n[a++]=0,n[a++]=u.y-o;for(var s=1;s<r;s++){u=e[s];var c=u.x-i,l=u.y-o;n[a++]=c,n[a++]=0,n[a++]=l,n[a++]=c,n[a++]=0,n[a++]=l}return u=e[0],n[a++]=u.x-i,n[a++]=0,n[a++]=u.y-o,n}function _(e,t){for(var r=e.length,n=new Array(3*r),a=0,i=t.x+t.width/2,o=t.y+t.height/2,u=0;u<r;u++)n[a++]=e[u].x-i,n[a++]=0,n[a++]=e[u].y-o;return n}function T(e,r,n,i,s,c,f,d,h,p){var E,y=t.angleBetween(t.subtract(r,e,x),t.subtract(n,e,C)),_=i===a.BEVELED?0:Math.ceil(y/o.toRadians(5));E=s?u.fromQuaternion(l.fromAxisAngle(t.negate(e,x),y/(_+1),H),k):u.fromQuaternion(l.fromAxisAngle(e,y/(_+1),H),k);var T,R;if(r=t.clone(r,Y),_>0)for(var v=p?2:1,A=0;A<_;A++)r=u.multiplyByVector(E,r,r),T=t.subtract(r,e,x),T=t.normalize(T,T),s||(T=t.negate(T,T)),R=c.scaleToGeodeticSurface(r,C),f=m(R,T,d,f,c,h,1,v);else T=t.subtract(r,e,x),T=t.normalize(T,T),s||(T=t.negate(T,T)),R=c.scaleToGeodeticSurface(r,C),f=m(R,T,d,f,c,h,1,1),n=t.clone(n,Y),T=t.subtract(n,e,x),T=t.normalize(T,T),s||(T=t.negate(T,T)),R=c.scaleToGeodeticSurface(n,C),f=m(R,T,d,f,c,h,1,1);return f}var R=[new t,new t],v=new t,A=new t,g=new t,S=new t,N=new t,w=new t,O=new t,I=new t,M=new t,x=new t,C=new t,P={},U=new n,D=new t,L=new t,b=new t(-1,0,0),F=new s,B=new s,z=new u,q=u.IDENTITY.clone(),G=new t,V=new r,W=new t,X=new t,H=new l,Y=new t,k=new u;P.removeDuplicatesFromShape=function(t){for(var r=t.length,n=[],a=r-1,i=0;i<r;a=i++){var o=t[a],u=t[i];e.equals(o,u)||n.push(u)}return n},P.angleIsGreaterThanPi=function(e,r,n,a){var o=new i(n,a),u=o.projectPointOntoPlane(t.add(n,e,D),D),s=o.projectPointOntoPlane(t.add(n,r,L),L);return s.x*u.y-s.y*u.x>=0};var j=new t,Z=new t;return P.computePositions=function(e,r,n,i,u){var s=i._ellipsoid,l=d(e,s),f=i._granularity,p=i._cornerType,C=u?y(r,n):_(r,n),U=u?_(r,n):void 0,D=n.height/2,L=n.width/2,b=e.length,F=[],B=u?[]:void 0,z=v,q=A,G=g,V=S,W=N,X=w,H=O,Y=I,k=M,K=e[0],J=e[1];V=s.geodeticSurfaceNormal(K,V),z=t.subtract(J,K,z),z=t.normalize(z,z),Y=t.cross(V,z,Y),Y=t.normalize(Y,Y);var Q=l[0],$=l[1];u&&(B=m(K,Y,U,B,s,Q+D,1,1)),k=t.clone(K,k),K=J,q=t.negate(z,q);for(var ee,te,re=1;re<b-1;re++){var ne=u?2:1;J=e[re+1],z=t.subtract(J,K,z),z=t.normalize(z,z),G=t.add(z,q,G),G=t.normalize(G,G),V=s.geodeticSurfaceNormal(K,V);var ae=t.multiplyByScalar(V,t.dot(z,V),j);t.subtract(z,ae,ae),t.normalize(ae,ae);var ie=t.multiplyByScalar(V,t.dot(q,V),Z);t.subtract(q,ie,ie),t.normalize(ie,ie);if(!o.equalsEpsilon(Math.abs(t.dot(ae,ie)),1,o.EPSILON7)){G=t.cross(G,V,G),G=t.cross(V,G,G),G=t.normalize(G,G);var oe=1/Math.max(.25,t.magnitude(t.cross(G,q,x))),ue=P.angleIsGreaterThanPi(z,q,K,s);ue?(W=t.add(K,t.multiplyByScalar(G,oe*L,G),W),X=t.add(W,t.multiplyByScalar(Y,L,X),X),R[0]=t.clone(k,R[0]),R[1]=t.clone(X,R[1]),ee=h(R,Q+D,$+D,f),te=c.generateArc({positions:R,granularity:f,ellipsoid:s}),F=E(te,Y,C,F,s,ee,1),Y=t.cross(V,z,Y),Y=t.normalize(Y,Y),H=t.add(W,t.multiplyByScalar(Y,L,H),H),p===a.ROUNDED||p===a.BEVELED?T(W,X,H,p,ue,s,F,C,$+D,u):(G=t.negate(G,G),F=m(K,G,C,F,s,$+D,oe,ne)),k=t.clone(H,k)):(W=t.add(K,t.multiplyByScalar(G,oe*L,G),W),X=t.add(W,t.multiplyByScalar(Y,-L,X),X),R[0]=t.clone(k,R[0]),R[1]=t.clone(X,R[1]),ee=h(R,Q+D,$+D,f),te=c.generateArc({positions:R,granularity:f,ellipsoid:s}),F=E(te,Y,C,F,s,ee,1),Y=t.cross(V,z,Y),Y=t.normalize(Y,Y),H=t.add(W,t.multiplyByScalar(Y,-L,H),H),p===a.ROUNDED||p===a.BEVELED?T(W,X,H,p,ue,s,F,C,$+D,u):F=m(K,G,C,F,s,$+D,oe,ne),k=t.clone(H,k)),q=t.negate(z,q)}else F=m(k,Y,C,F,s,Q+D,1,1),k=K;Q=$,$=l[re+1],K=J}R[0]=t.clone(k,R[0]),R[1]=t.clone(K,R[1]),ee=h(R,Q+D,$+D,f),te=c.generateArc({positions:R,granularity:f,ellipsoid:s}),F=E(te,Y,C,F,s,ee,1),u&&(B=m(K,Y,U,B,s,$+D,1,1)),b=F.length;var se=u?b+B.length:b,ce=new Float64Array(se);return ce.set(F),u&&ce.set(B,b),ce},P}),define("Core/CorridorGeometryLibrary",["./Cartesian3","./CornerType","./defined","./Math","./Matrix3","./PolylinePipeline","./PolylineVolumeGeometryLibrary","./Quaternion"],function(e,t,r,n,a,i,o,u){"use strict";function s(r,i,o,s,c){var l=e.angleBetween(e.subtract(i,r,h),e.subtract(o,r,p)),f=s===t.BEVELED?1:Math.ceil(l/n.toRadians(5))+1,d=3*f,m=new Array(d);m[d-3]=o.x,m[d-2]=o.y,m[d-1]=o.z;var E;E=c?a.fromQuaternion(u.fromAxisAngle(e.negate(r,h),l/f,I),M):a.fromQuaternion(u.fromAxisAngle(r,l/f,I),M);var y=0;i=e.clone(i,h);for(var _=0;_<f;_++)i=a.multiplyByVector(E,i,i),m[y++]=i.x,m[y++]=i.y,m[y++]=i.z;return m}function c(r){var n=_,a=T,i=R,o=r[1];a=e.fromArray(r[1],o.length-3,a),i=e.fromArray(r[0],0,i),n=e.multiplyByScalar(e.add(a,i,n),.5,n);var u=s(n,a,i,t.ROUNDED,!1),c=r.length-1,l=r[c-1];return o=r[c],a=e.fromArray(l,l.length-3,a),i=e.fromArray(o,0,i),n=e.multiplyByScalar(e.add(a,i,n),.5,n),[u,s(n,a,i,t.ROUNDED,!1)]}function l(t,r,n,a){var i=h;return a?i=e.add(t,r,i):(r=e.negate(r,r),i=e.add(t,r,i)),[i.x,i.y,i.z,n.x,n.y,n.z]}function f(t,r,n,a){for(var i=new Array(t.length),o=new Array(t.length),u=e.multiplyByScalar(r,n,h),s=e.negate(u,p),c=0,l=t.length-1,f=0;f<t.length;f+=3){var d=e.fromArray(t,f,m),y=e.add(d,s,E);i[c++]=y.x,i[c++]=y.y,i[c++]=y.z;var _=e.add(d,u,E);o[l--]=_.z,o[l--]=_.y,o[l--]=_.x}return a.push(i,o),a}var d={},h=new e,p=new e,m=new e,E=new e,y=[new e,new e],_=new e,T=new e,R=new e,v=new e,A=new e,g=new e,S=new e,N=new e,w=new e,O=new e,I=new u,M=new a;d.addAttribute=function(e,t,n,a){var i=t.x,o=t.y,u=t.z;r(n)&&(e[n]=i,e[n+1]=o,e[n+2]=u),r(a)&&(e[a]=u,e[a-1]=o,e[a-2]=i)};var x=new e,C=new e;return d.computePositions=function(r){var a=r.granularity,u=r.positions,d=r.ellipsoid,p=r.width/2,m=r.cornerType,E=r.saveAttributes,I=_,M=T,P=R,U=v,D=A,L=g,b=S,F=N,B=w,z=O,q=[],G=E?[]:void 0,V=E?[]:void 0,W=u[0],X=u[1];M=e.normalize(e.subtract(X,W,M),M),I=d.geodeticSurfaceNormal(W,I),U=e.normalize(e.cross(I,M,U),U),E&&(G.push(U.x,U.y,U.z),V.push(I.x,I.y,I.z)),b=e.clone(W,b),W=X,P=e.negate(M,P);var H,Y,k=[],j=u.length;for(Y=1;Y<j-1;Y++){I=d.geodeticSurfaceNormal(W,I),X=u[Y+1],M=e.normalize(e.subtract(X,W,M),M),D=e.normalize(e.add(M,P,D),D);var Z=e.multiplyByScalar(I,e.dot(M,I),x);e.subtract(M,Z,Z),e.normalize(Z,Z);var K=e.multiplyByScalar(I,e.dot(P,I),C);e.subtract(P,K,K),e.normalize(K,K);if(!n.equalsEpsilon(Math.abs(e.dot(Z,K)),1,n.EPSILON7)){D=e.cross(D,I,D),D=e.cross(I,D,D),D=e.normalize(D,D);var J=p/Math.max(.25,e.magnitude(e.cross(D,P,h))),Q=o.angleIsGreaterThanPi(M,P,W,d);D=e.multiplyByScalar(D,J,D),Q?(F=e.add(W,D,F),z=e.add(F,e.multiplyByScalar(U,p,z),z),B=e.add(F,e.multiplyByScalar(U,2*p,B),B),y[0]=e.clone(b,y[0]),y[1]=e.clone(z,y[1]),H=i.generateArc({positions:y,granularity:a,ellipsoid:d}),q=f(H,U,p,q),E&&(G.push(U.x,U.y,U.z),V.push(I.x,I.y,I.z)),L=e.clone(B,L),U=e.normalize(e.cross(I,M,U),U),B=e.add(F,e.multiplyByScalar(U,2*p,B),B),b=e.add(F,e.multiplyByScalar(U,p,b),b),m===t.ROUNDED||m===t.BEVELED?k.push({leftPositions:s(F,L,B,m,Q)}):k.push({leftPositions:l(W,e.negate(D,D),B,Q)})):(B=e.add(W,D,B),z=e.add(B,e.negate(e.multiplyByScalar(U,p,z),z),z),F=e.add(B,e.negate(e.multiplyByScalar(U,2*p,F),F),F),y[0]=e.clone(b,y[0]),y[1]=e.clone(z,y[1]),H=i.generateArc({positions:y,granularity:a,ellipsoid:d}),q=f(H,U,p,q),E&&(G.push(U.x,U.y,U.z),V.push(I.x,I.y,I.z)),L=e.clone(F,L),U=e.normalize(e.cross(I,M,U),U),F=e.add(B,e.negate(e.multiplyByScalar(U,2*p,F),F),F),b=e.add(B,e.negate(e.multiplyByScalar(U,p,b),b),b),m===t.ROUNDED||m===t.BEVELED?k.push({rightPositions:s(B,L,F,m,Q)}):k.push({rightPositions:l(W,D,F,Q)})),P=e.negate(M,P)}W=X}I=d.geodeticSurfaceNormal(W,I),y[0]=e.clone(b,y[0]),y[1]=e.clone(W,y[1]),H=i.generateArc({positions:y,granularity:a,ellipsoid:d}),q=f(H,U,p,q),E&&(G.push(U.x,U.y,U.z),V.push(I.x,I.y,I.z));var $;return m===t.ROUNDED&&($=c(q)),{positions:q,corners:k,lefts:G,normals:V,endPositions:$}},d}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";return e({NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3})}),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],function(e,t,r,n,a,i){"use strict";function o(e,t,n,a){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(a,0)}o.packedLength=4,o.pack=function(e,t,n){return n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t},o.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new o),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a},o.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3])},o.fromArray=function(e,t,a){return t=r(t,0),n(a)||(a=new o),a[0]=e[t],a[1]=e[t+1],a[2]=e[t+2],a[3]=e[t+3],a},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new o(e,0,0,e)},o.fromRotation=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=a,t[2]=-a,t[3]=r,t):new o(r,-a,a,r)},o.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,t){return 2*e+t},o.getColumn=function(e,t,r){var n=2*t,a=e[n],i=e[n+1];return r.x=a,r.y=i,r},o.setColumn=function(e,t,r,n){n=o.clone(e,n);var a=2*t;return n[a]=r.x,n[a+1]=r.y,n},o.getRow=function(e,t,r){var n=e[t],a=e[t+2];return r.x=n,r.y=a,r},o.setRow=function(e,t,r,n){return n=o.clone(e,n),n[t]=r.x,n[t+2]=r.y,n};var u=new e;o.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],u)),r.y=e.magnitude(e.fromElements(t[2],t[3],u)),r};var s=new e;return o.getMaximumScale=function(t){return o.getScale(t,s),e.maximumComponent(s)},o.multiply=function(e,t,r){var n=e[0]*t[0]+e[2]*t[1],a=e[0]*t[2]+e[2]*t[3],i=e[1]*t[0]+e[3]*t[1],o=e[1]*t[2]+e[3]*t[3];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r},o.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r},o.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r},o.multiplyByVector=function(e,t,r){var n=e[0]*t.x+e[2]*t.y,a=e[1]*t.x+e[3]*t.y;return r.x=n,r.y=a,r},o.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r},o.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.y,r[3]=e[3]*t.y,r},o.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},o.transpose=function(e,t){var r=e[0],n=e[2],a=e[1],i=e[3];return t[0]=r,t[1]=n,t[2]=a,t[3]=i,t},o.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},o.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r},o.IDENTITY=i(new o(1,0,0,1)),o.ZERO=i(new o(0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,a(o.prototype,{length:{get:function(){return o.packedLength}}}),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},o}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,p){"use strict";function m(e){e=a(e,a.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=a(e.primitiveType,f.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=a(e.geometryType,u.NONE),this.boundingSphereCV=e.boundingSphereCV}m.computeNumberOfVertices=function(e){var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&i(e.attributes[r])&&i(e.attributes[r].values)){var n=e.attributes[r],a=n.values.length/n.componentsPerAttribute;t=a}return t};var E=new r,y=new t,_=new l,T=[new r,new r,new r],R=[new e,new e,new e],v=[new e,new e,new e],A=new t,g=new d,S=new l,N=new s;return m._textureCoordinateRotationPoints=function(n,a,i,o){var u,f=h.center(o,E),m=r.toCartesian(f,i,y),w=p.eastNorthUpToFixedFrame(m,i,_),O=l.inverse(w,_),I=R,M=T;M[0].longitude=o.west,M[0].latitude=o.south,M[1].longitude=o.west,M[1].latitude=o.north,M[2].longitude=o.east,M[2].latitude=o.south;var x=A;for(u=0;u<3;u++)r.toCartesian(M[u],i,x),x=l.multiplyByPointAsVector(O,x,x),I[u].x=x.x,I[u].y=x.y;var C=d.fromAxisAngle(t.UNIT_Z,-a,g),P=c.fromQuaternion(C,S),U=n.length,D=Number.POSITIVE_INFINITY,L=Number.POSITIVE_INFINITY,b=Number.NEGATIVE_INFINITY,F=Number.NEGATIVE_INFINITY;for(u=0;u<U;u++)x=l.multiplyByPointAsVector(O,n[u],x),x=c.multiplyByVector(P,x,x),D=Math.min(D,x.x),L=Math.min(L,x.y),b=Math.max(b,x.x),F=Math.max(F,x.y);var B=s.fromRotation(a,N),z=v;z[0].x=D,z[0].y=L,z[1].x=D,z[1].y=F,z[2].x=b,z[2].y=L;var q=I[0],G=I[2].x-q.x,V=I[1].y-q.y;for(u=0;u<3;u++){var W=z[u];s.multiplyByVector(B,W,W),W.x=(W.x-q.x)/G,W.y=(W.y-q.y)/V}var X=z[0],H=z[1],Y=z[2],k=new Array(6);return e.pack(X,k),e.pack(H,k,2),e.pack(Y,k,4),k},m}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,a){"use strict";var i={UNSIGNED_BYTE:a.UNSIGNED_BYTE,UNSIGNED_SHORT:a.UNSIGNED_SHORT,UNSIGNED_INT:a.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},i.createTypedArray=function(e,t){return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},i.createTypedArrayFromArrayBuffer=function(e,t,r,a){return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,a):new Uint16Array(t,r,a)},r(i)}),define("ThirdParty/earcut-2.1.1",[],function(){"use strict";function e(e,r,a){a=a||2;var i=r&&r.length,o=i?r[0]*a:e.length,u=t(e,0,o,a,!0),c=[];if(!u)return c;var l,f,d,h,p,m,E;if(i&&(u=s(e,r,u,a)),e.length>80*a){l=d=e[0],f=h=e[1];for(var y=a;y<o;y+=a)p=e[y],m=e[y+1],p<l&&(l=p),m<f&&(f=m),p>d&&(d=p),m>h&&(h=m);E=Math.max(d-l,h-f)}return n(u,c,a,l,f,E),c}function t(e,t,r,n,a){var i,o;if(a===I(e,t,r,n)>0)for(i=t;i<r;i+=n)o=N(i,e[i],e[i+1],o);else for(i=r-n;i>=t;i-=n)o=N(i,e[i],e[i+1],o);return o&&T(o,o.next)&&(w(o),o=o.next),o}function r(e,t){if(!e)return e;t||(t=e);var r,n=e;do{if(r=!1,n.steiner||!T(n,n.next)&&0!==_(n.prev,n,n.next))n=n.next;else{if(w(n),(n=t=n.prev)===n.next)return null;r=!0}}while(r||n!==t);return t}function n(e,t,s,c,l,f,h){if(e){!h&&f&&d(e,c,l,f);for(var p,m,E=e;e.prev!==e.next;)if(p=e.prev,m=e.next,f?i(e,c,l,f):a(e))t.push(p.i/s),t.push(e.i/s),t.push(m.i/s),w(e),e=m.next,E=m.next;else if((e=m)===E){h?1===h?(e=o(e,t,s),n(e,t,s,c,l,f,2)):2===h&&u(e,t,s,c,l,f):n(r(e),t,s,c,l,f,1);break}}}function a(e){var t=e.prev,r=e,n=e.next;if(_(t,r,n)>=0)return!1;for(var a=e.next.next;a!==e.prev;){if(E(t.x,t.y,r.x,r.y,n.x,n.y,a.x,a.y)&&_(a.prev,a,a.next)>=0)return!1;a=a.next}return!0}function i(e,t,r,n){var a=e.prev,i=e,o=e.next;if(_(a,i,o)>=0)return!1;for(var u=a.x<i.x?a.x<o.x?a.x:o.x:i.x<o.x?i.x:o.x,s=a.y<i.y?a.y<o.y?a.y:o.y:i.y<o.y?i.y:o.y,c=a.x>i.x?a.x>o.x?a.x:o.x:i.x>o.x?i.x:o.x,l=a.y>i.y?a.y>o.y?a.y:o.y:i.y>o.y?i.y:o.y,f=p(u,s,t,r,n),d=p(c,l,t,r,n),h=e.nextZ;h&&h.z<=d;){if(h!==e.prev&&h!==e.next&&E(a.x,a.y,i.x,i.y,o.x,o.y,h.x,h.y)&&_(h.prev,h,h.next)>=0)return!1;h=h.nextZ}for(h=e.prevZ;h&&h.z>=f;){if(h!==e.prev&&h!==e.next&&E(a.x,a.y,i.x,i.y,o.x,o.y,h.x,h.y)&&_(h.prev,h,h.next)>=0)return!1;h=h.prevZ}return!0}function o(e,t,r){var n=e;do{var a=n.prev,i=n.next.next;!T(a,i)&&R(a,n,n.next,i)&&A(a,i)&&A(i,a)&&(t.push(a.i/r),t.push(n.i/r),t.push(i.i/r),w(n),w(n.next),n=e=i),n=n.next
}while(n!==e);return n}function u(e,t,a,i,o,u){var s=e;do{for(var c=s.next.next;c!==s.prev;){if(s.i!==c.i&&y(s,c)){var l=S(s,c);return s=r(s,s.next),l=r(l,l.next),n(s,t,a,i,o,u),void n(l,t,a,i,o,u)}c=c.next}s=s.next}while(s!==e)}function s(e,n,a,i){var o,u,s,f,d,h=[];for(o=0,u=n.length;o<u;o++)s=n[o]*i,f=o<u-1?n[o+1]*i:e.length,d=t(e,s,f,i,!1),d===d.next&&(d.steiner=!0),h.push(m(d));for(h.sort(c),o=0;o<h.length;o++)l(h[o],a),a=r(a,a.next);return a}function c(e,t){return e.x-t.x}function l(e,t){if(t=f(e,t)){var n=S(t,e);r(n,n.next)}}function f(e,t){var r,n=t,a=e.x,i=e.y,o=-1/0;do{if(i<=n.y&&i>=n.next.y){var u=n.x+(i-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(u<=a&&u>o){if(o=u,u===a){if(i===n.y)return n;if(i===n.next.y)return n.next}r=n.x<n.next.x?n:n.next}}n=n.next}while(n!==t);if(!r)return null;if(a===o)return r.prev;var s,c=r,l=r.x,f=r.y,d=1/0;for(n=r.next;n!==c;)a>=n.x&&n.x>=l&&E(i<f?a:o,i,l,f,i<f?o:a,i,n.x,n.y)&&((s=Math.abs(i-n.y)/(a-n.x))<d||s===d&&n.x>r.x)&&A(n,e)&&(r=n,d=s),n=n.next;return r}function d(e,t,r,n){var a=e;do{null===a.z&&(a.z=p(a.x,a.y,t,r,n)),a.prevZ=a.prev,a.nextZ=a.next,a=a.next}while(a!==e);a.prevZ.nextZ=null,a.prevZ=null,h(a)}function h(e){var t,r,n,a,i,o,u,s,c=1;do{for(r=e,e=null,i=null,o=0;r;){for(o++,n=r,u=0,t=0;t<c&&(u++,n=n.nextZ);t++);for(s=c;u>0||s>0&&n;)0===u?(a=n,n=n.nextZ,s--):0!==s&&n?r.z<=n.z?(a=r,r=r.nextZ,u--):(a=n,n=n.nextZ,s--):(a=r,r=r.nextZ,u--),i?i.nextZ=a:e=a,a.prevZ=i,i=a;r=n}i.nextZ=null,c*=2}while(o>1);return e}function p(e,t,r,n,a){return e=32767*(e-r)/a,t=32767*(t-n)/a,e=16711935&(e|e<<8),e=252645135&(e|e<<4),e=858993459&(e|e<<2),e=1431655765&(e|e<<1),t=16711935&(t|t<<8),t=252645135&(t|t<<4),t=858993459&(t|t<<2),t=1431655765&(t|t<<1),e|t<<1}function m(e){var t=e,r=e;do{t.x<r.x&&(r=t),t=t.next}while(t!==e);return r}function E(e,t,r,n,a,i,o,u){return(a-o)*(t-u)-(e-o)*(i-u)>=0&&(e-o)*(n-u)-(r-o)*(t-u)>=0&&(r-o)*(i-u)-(a-o)*(n-u)>=0}function y(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!v(e,t)&&A(e,t)&&A(t,e)&&g(e,t)}function _(e,t,r){return(t.y-e.y)*(r.x-t.x)-(t.x-e.x)*(r.y-t.y)}function T(e,t){return e.x===t.x&&e.y===t.y}function R(e,t,r,n){return!!(T(e,t)&&T(r,n)||T(e,n)&&T(r,t))||_(e,t,r)>0!=_(e,t,n)>0&&_(r,n,e)>0!=_(r,n,t)>0}function v(e,t){var r=e;do{if(r.i!==e.i&&r.next.i!==e.i&&r.i!==t.i&&r.next.i!==t.i&&R(r,r.next,e,t))return!0;r=r.next}while(r!==e);return!1}function A(e,t){return _(e.prev,e,e.next)<0?_(e,t,e.next)>=0&&_(e,e.prev,t)>=0:_(e,t,e.prev)<0||_(e,e.next,t)<0}function g(e,t){var r=e,n=!1,a=(e.x+t.x)/2,i=(e.y+t.y)/2;do{r.y>i!=r.next.y>i&&a<(r.next.x-r.x)*(i-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next}while(r!==e);return n}function S(e,t){var r=new O(e.i,e.x,e.y),n=new O(t.i,t.x,t.y),a=e.next,i=t.prev;return e.next=t,t.prev=e,r.next=a,a.prev=r,n.next=r,r.prev=n,i.next=n,n.prev=i,n}function N(e,t,r,n){var a=new O(e,t,r);return n?(a.next=n.next,a.prev=n,n.next.prev=a,n.next=a):(a.prev=a,a.next=a),a}function w(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function O(e,t,r){this.i=e,this.x=t,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function I(e,t,r,n){for(var a=0,i=t,o=r-n;i<r;i+=n)a+=(e[o]-e[i])*(e[i+1]+e[o+1]),o=i;return a}return e.deviation=function(e,t,r,n){var a=t&&t.length,i=a?t[0]*r:e.length,o=Math.abs(I(e,0,i,r));if(a)for(var u=0,s=t.length;u<s;u++){var c=t[u]*r,l=u<s-1?t[u+1]*r:e.length;o-=Math.abs(I(e,c,l,r))}var f=0;for(u=0;u<n.length;u+=3){var d=n[u]*r,h=n[u+1]*r,p=n[u+2]*r;f+=Math.abs((e[d]-e[p])*(e[h+1]-e[d+1])-(e[d]-e[h])*(e[p+1]-e[d+1]))}return 0===o&&0===f?0:Math.abs((f-o)/o)},e.flatten=function(e){for(var t=e[0][0].length,r={vertices:[],holes:[],dimensions:t},n=0,a=0;a<e.length;a++){for(var i=0;i<e[a].length;i++)for(var o=0;o<t;o++)r.vertices.push(e[a][i][o]);a>0&&(n+=e[a-1].length,r.holes.push(n))}return r},e}),define("Core/WindingOrder",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={CLOCKWISE:t.CW,COUNTER_CLOCKWISE:t.CCW,validate:function(e){return e===r.CLOCKWISE||e===r.COUNTER_CLOCKWISE}};return e(r)}),define("Core/PolygonPipeline",["../ThirdParty/earcut-2.1.1","./Cartesian2","./Cartesian3","./Check","./ComponentDatatype","./defaultValue","./defined","./Ellipsoid","./Geometry","./GeometryAttribute","./Math","./PrimitiveType","./WindingOrder"],function(e,t,r,n,a,i,o,u,s,c,l,f,d){"use strict";var h=new r,p=new r,m={};m.computeArea2D=function(e){for(var t=e.length,r=0,n=t-1,a=0;a<t;n=a++){var i=e[n],o=e[a];r+=i.x*o.y-o.x*i.y}return.5*r},m.computeWindingOrder2D=function(e){return m.computeArea2D(e)>0?d.COUNTER_CLOCKWISE:d.CLOCKWISE},m.triangulate=function(r,n){var a=t.packArray(r);return e(a,n,2)};var E=new r,y=new r,_=new r,T=new r,R=new r,v=new r,A=new r;return m.computeSubdivision=function(e,t,n,u){u=i(u,l.RADIANS_PER_DEGREE);var d,h=n.slice(0),p=t.length,m=new Array(3*p),g=0;for(d=0;d<p;d++){var S=t[d];m[g++]=S.x,m[g++]=S.y,m[g++]=S.z}for(var N=[],w={},O=e.maximumRadius,I=l.chordLength(u,O),M=I*I;h.length>0;){var x,C,P=h.pop(),U=h.pop(),D=h.pop(),L=r.fromArray(m,3*D,E),b=r.fromArray(m,3*U,y),F=r.fromArray(m,3*P,_),B=r.multiplyByScalar(r.normalize(L,T),O,T),z=r.multiplyByScalar(r.normalize(b,R),O,R),q=r.multiplyByScalar(r.normalize(F,v),O,v),G=r.magnitudeSquared(r.subtract(B,z,A)),V=r.magnitudeSquared(r.subtract(z,q,A)),W=r.magnitudeSquared(r.subtract(q,B,A)),X=Math.max(G,V,W);X>M?G===X?(x=Math.min(D,U)+" "+Math.max(D,U),d=w[x],o(d)||(C=r.add(L,b,A),r.multiplyByScalar(C,.5,C),m.push(C.x,C.y,C.z),d=m.length/3-1,w[x]=d),h.push(D,d,P),h.push(d,U,P)):V===X?(x=Math.min(U,P)+" "+Math.max(U,P),d=w[x],o(d)||(C=r.add(b,F,A),r.multiplyByScalar(C,.5,C),m.push(C.x,C.y,C.z),d=m.length/3-1,w[x]=d),h.push(U,d,D),h.push(d,P,D)):W===X&&(x=Math.min(P,D)+" "+Math.max(P,D),d=w[x],o(d)||(C=r.add(F,L,A),r.multiplyByScalar(C,.5,C),m.push(C.x,C.y,C.z),d=m.length/3-1,w[x]=d),h.push(P,d,U),h.push(d,D,U)):(N.push(D),N.push(U),N.push(P))}return new s({attributes:{position:new c({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:m})},indices:N,primitiveType:f.TRIANGLES})},m.scaleToGeodeticHeight=function(e,t,n,a){n=i(n,u.WGS84);var s=h,c=p;if(t=i(t,0),a=i(a,!0),o(e))for(var l=e.length,f=0;f<l;f+=3)r.fromArray(e,f,c),a&&(c=n.scaleToGeodeticSurface(c,c)),0!==t&&(s=n.geodeticSurfaceNormal(c,s),r.multiplyByScalar(s,t,s),r.add(c,s,c)),e[f]=c.x,e[f+1]=c.y,e[f+2]=c.z;return e},m}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function a(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return a.POSITION_ONLY=n(new a({position:!0})),a.POSITION_AND_NORMAL=n(new a({position:!0,normal:!0})),a.POSITION_NORMAL_AND_ST=n(new a({position:!0,normal:!0,st:!0})),a.POSITION_AND_ST=n(new a({position:!0,st:!0})),a.POSITION_AND_COLOR=n(new a({position:!0,color:!0})),a.ALL=n(new a({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),a.DEFAULT=a.POSITION_NORMAL_AND_ST,a.packedLength=6,a.pack=function(t,r,n){return n=e(n,0),r[n++]=t.position?1:0,r[n++]=t.normal?1:0,r[n++]=t.st?1:0,r[n++]=t.tangent?1:0,r[n++]=t.bitangent?1:0,r[n]=t.color?1:0,r},a.unpack=function(r,n,i){return n=e(n,0),t(i)||(i=new a),i.position=1===r[n++],i.normal=1===r[n++],i.st=1===r[n++],i.tangent=1===r[n++],i.bitangent=1===r[n++],i.color=1===r[n],i},a.clone=function(e,r){if(t(e))return t(r)||(r=new a),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r},a}),define("Core/CorridorGeometry",["./arrayRemoveDuplicates","./BoundingSphere","./Cartesian3","./Cartographic","./ComponentDatatype","./CornerType","./CorridorGeometryLibrary","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PrimitiveType","./Rectangle","./VertexFormat"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,p,m,E,y,_,T,R){"use strict";function v(e,t){for(var r=0;r<e.length;r++)e[r]=t.scaleToGeodeticSurface(e[r],e[r]);return e}function A(e,t,n,a,i,u){var s=e.normals,c=e.tangents,l=e.bitangents,f=r.normalize(r.cross(n,t,b),b);u.normal&&o.addAttribute(s,t,a,i),u.tangent&&o.addAttribute(c,f,a,i),u.bitangent&&o.addAttribute(l,n,a,i)}function g(e,t,n){var i,u,c,l=e.positions,f=e.corners,d=e.endPositions,y=e.lefts,_=e.normals,T=new p,R=0,v=0,g=0;for(u=0;u<l.length;u+=2)c=l[u].length-3,R+=c,g+=2*c,v+=l[u+1].length-3;for(R+=3,v+=3,u=0;u<f.length;u++){i=f[u];var S=f[u].leftPositions;s(S)?(c=S.length,R+=c,g+=c):(c=f[u].rightPositions.length,v+=c,g+=c)}var N,w=s(d);w&&(N=d[0].length-3,R+=N,v+=N,N/=3,g+=6*N);var O,I,M,D,B,z,q=R+v,G=new Float64Array(q),V=t.normal?new Float32Array(q):void 0,W=t.tangent?new Float32Array(q):void 0,X=t.bitangent?new Float32Array(q):void 0,H={normals:V,tangents:W,bitangents:X},Y=0,k=q-1,j=x,Z=C,K=N/2,J=m.createTypedArray(q/3,g),Q=0;if(w){z=P,B=U;var $=d[0];for(j=r.fromArray(_,0,j),Z=r.fromArray(y,0,Z),u=0;u<K;u++)z=r.fromArray($,3*(K-1-u),z),B=r.fromArray($,3*(K+u),B),o.addAttribute(G,B,Y),o.addAttribute(G,z,void 0,k),A(H,j,Z,Y,k,t),I=Y/3,D=I+1,O=(k-2)/3,M=O-1,J[Q++]=O,J[Q++]=I,J[Q++]=M,J[Q++]=M,J[Q++]=I,J[Q++]=D,Y+=3,k-=3}var ee=0,te=0,re=l[ee++],ne=l[ee++];G.set(re,Y),G.set(ne,k-ne.length+1),Z=r.fromArray(y,te,Z);var ae,ie;for(c=ne.length-3,u=0;u<c;u+=3)ae=n.geodeticSurfaceNormal(r.fromArray(re,u,b),b),ie=n.geodeticSurfaceNormal(r.fromArray(ne,c-u,F),F),j=r.normalize(r.add(ae,ie,j),j),A(H,j,Z,Y,k,t),I=Y/3,D=I+1,O=(k-2)/3,M=O-1,J[Q++]=O,J[Q++]=I,J[Q++]=M,J[Q++]=M,J[Q++]=I,J[Q++]=D,Y+=3,k-=3;for(ae=n.geodeticSurfaceNormal(r.fromArray(re,c,b),b),ie=n.geodeticSurfaceNormal(r.fromArray(ne,c,F),F),j=r.normalize(r.add(ae,ie,j),j),te+=3,u=0;u<f.length;u++){var oe;i=f[u];var ue,se,ce=i.leftPositions,le=i.rightPositions,fe=L,de=P,he=U;if(j=r.fromArray(_,te,j),s(ce)){for(A(H,j,Z,void 0,k,t),k-=3,ue=D,se=M,oe=0;oe<ce.length/3;oe++)fe=r.fromArray(ce,3*oe,fe),J[Q++]=ue,J[Q++]=se-oe-1,J[Q++]=se-oe,o.addAttribute(G,fe,void 0,k),de=r.fromArray(G,3*(se-oe-1),de),he=r.fromArray(G,3*ue,he),Z=r.normalize(r.subtract(de,he,Z),Z),A(H,j,Z,void 0,k,t),k-=3;fe=r.fromArray(G,3*ue,fe),de=r.subtract(r.fromArray(G,3*se,de),fe,de),he=r.subtract(r.fromArray(G,3*(se-oe),he),fe,he),Z=r.normalize(r.add(de,he,Z),Z),A(H,j,Z,Y,void 0,t),Y+=3}else{for(A(H,j,Z,Y,void 0,t),Y+=3,ue=M,se=D,oe=0;oe<le.length/3;oe++)fe=r.fromArray(le,3*oe,fe),J[Q++]=ue,J[Q++]=se+oe,J[Q++]=se+oe+1,o.addAttribute(G,fe,Y),de=r.fromArray(G,3*ue,de),he=r.fromArray(G,3*(se+oe),he),Z=r.normalize(r.subtract(de,he,Z),Z),A(H,j,Z,Y,void 0,t),Y+=3;fe=r.fromArray(G,3*ue,fe),de=r.subtract(r.fromArray(G,3*(se+oe),de),fe,de),he=r.subtract(r.fromArray(G,3*se,he),fe,he),Z=r.normalize(r.negate(r.add(he,de,Z),Z),Z),A(H,j,Z,void 0,k,t),k-=3}for(re=l[ee++],ne=l[ee++],re.splice(0,3),ne.splice(ne.length-3,3),G.set(re,Y),G.set(ne,k-ne.length+1),c=ne.length-3,te+=3,Z=r.fromArray(y,te,Z),oe=0;oe<ne.length;oe+=3)ae=n.geodeticSurfaceNormal(r.fromArray(re,oe,b),b),ie=n.geodeticSurfaceNormal(r.fromArray(ne,c-oe,F),F),j=r.normalize(r.add(ae,ie,j),j),A(H,j,Z,Y,k,t),D=Y/3,I=D-1,M=(k-2)/3,O=M+1,J[Q++]=O,J[Q++]=I,J[Q++]=M,J[Q++]=M,J[Q++]=I,J[Q++]=D,Y+=3,k-=3;Y-=3,k+=3}if(j=r.fromArray(_,_.length-3,j),A(H,j,Z,Y,k,t),w){Y+=3,k-=3,z=P,B=U;var pe=d[1];for(u=0;u<K;u++)z=r.fromArray(pe,3*(N-u-1),z),B=r.fromArray(pe,3*u,B),o.addAttribute(G,z,void 0,k),o.addAttribute(G,B,Y),A(H,j,Z,Y,k,t),D=Y/3,I=D-1,M=(k-2)/3,O=M+1,J[Q++]=O,J[Q++]=I,J[Q++]=M,J[Q++]=M,J[Q++]=I,J[Q++]=D,Y+=3,k-=3}if(T.position=new h({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:G}),t.st){var me,Ee,ye=new Float32Array(q/3*2),_e=0;if(w){R/=3,v/=3;var Te=Math.PI/(N+1);Ee=1/(R-N+1),me=1/(v-N+1);var Re,ve=N/2;for(u=ve+1;u<N+1;u++)Re=E.PI_OVER_TWO+Te*u,ye[_e++]=me*(1+Math.cos(Re)),ye[_e++]=.5*(1+Math.sin(Re));for(u=1;u<v-N+1;u++)ye[_e++]=u*me,ye[_e++]=0;for(u=N;u>ve;u--)Re=E.PI_OVER_TWO-u*Te,ye[_e++]=1-me*(1+Math.cos(Re)),ye[_e++]=.5*(1+Math.sin(Re));for(u=ve;u>0;u--)Re=E.PI_OVER_TWO-Te*u,ye[_e++]=1-Ee*(1+Math.cos(Re)),ye[_e++]=.5*(1+Math.sin(Re));for(u=R-N;u>0;u--)ye[_e++]=u*Ee,ye[_e++]=1;for(u=1;u<ve+1;u++)Re=E.PI_OVER_TWO+Te*u,ye[_e++]=Ee*(1+Math.cos(Re)),ye[_e++]=.5*(1+Math.sin(Re))}else{for(R/=3,v/=3,Ee=1/(R-1),me=1/(v-1),u=0;u<v;u++)ye[_e++]=u*me,ye[_e++]=0;for(u=R;u>0;u--)ye[_e++]=(u-1)*Ee,ye[_e++]=1}T.st=new h({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:ye})}return t.normal&&(T.normal=new h({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:H.normals})),t.tangent&&(T.tangent=new h({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:H.tangents})),t.bitangent&&(T.bitangent=new h({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:H.bitangents})),{attributes:T,indices:J}}function S(e,t){if(!(t.normal||t.tangent||t.bitangent||t.st))return e;var n,a,i=e.position.values;(t.normal||t.bitangent)&&(n=e.normal.values,a=e.bitangent.values);var u,s=e.position.values.length/18,c=3*s,l=2*s,f=2*c;if(t.normal||t.bitangent||t.tangent){var d=t.normal?new Float32Array(6*c):void 0,h=t.tangent?new Float32Array(6*c):void 0,p=t.bitangent?new Float32Array(6*c):void 0,m=x,E=C,y=P,_=U,T=D,R=L,v=f;for(u=0;u<c;u+=3){var A=v+f;m=r.fromArray(i,u,m),E=r.fromArray(i,u+c,E),y=r.fromArray(i,(u+3)%c,y),E=r.subtract(E,m,E),y=r.subtract(y,m,y),_=r.normalize(r.cross(E,y,_),_),t.normal&&(o.addAttribute(d,_,A),o.addAttribute(d,_,A+3),o.addAttribute(d,_,v),o.addAttribute(d,_,v+3)),(t.tangent||t.bitangent)&&(R=r.fromArray(n,u,R),t.bitangent&&(o.addAttribute(p,R,A),o.addAttribute(p,R,A+3),o.addAttribute(p,R,v),o.addAttribute(p,R,v+3)),t.tangent&&(T=r.normalize(r.cross(R,_,T),T),o.addAttribute(h,T,A),o.addAttribute(h,T,A+3),o.addAttribute(h,T,v),o.addAttribute(h,T,v+3))),v+=6}if(t.normal){for(d.set(n),u=0;u<c;u+=3)d[u+c]=-n[u],d[u+c+1]=-n[u+1],d[u+c+2]=-n[u+2];e.normal.values=d}else e.normal=void 0;if(t.bitangent?(p.set(a),p.set(a,c),e.bitangent.values=p):e.bitangent=void 0,t.tangent){var g=e.tangent.values;h.set(g),h.set(g,c),e.tangent.values=h}}if(t.st){var S=e.st.values,N=new Float32Array(6*l);N.set(S),N.set(S,l);for(var w=2*l,O=0;O<2;O++){for(N[w++]=S[0],N[w++]=S[1],u=2;u<l;u+=2){var I=S[u],M=S[u+1];N[w++]=I,N[w++]=M,N[w++]=I,N[w++]=M}N[w++]=S[0],N[w++]=S[1]}e.st.values=N}return e}function N(e,t,r){r[t++]=e[0],r[t++]=e[1],r[t++]=e[2];for(var n=3;n<e.length;n+=3){var a=e[n],i=e[n+1],o=e[n+2];r[t++]=a,r[t++]=i,r[t++]=o,r[t++]=a,r[t++]=i,r[t++]=o}return r[t++]=e[0],r[t++]=e[1],r[t++]=e[2],r}function w(e,t){var r=new R({position:t.position,normal:t.normal||t.bitangent||e.shadowVolume,tangent:t.tangent,bitangent:t.normal||t.bitangent,st:t.st}),n=e.ellipsoid,i=o.computePositions(e),u=g(i,r,n),s=e.height,c=e.extrudedHeight,l=u.attributes,f=u.indices,d=l.position.values,p=d.length,E=new Float64Array(6*p),_=new Float64Array(p);_.set(d);var T=new Float64Array(4*p);d=y.scaleToGeodeticHeight(d,s,n),T=N(d,0,T),_=y.scaleToGeodeticHeight(_,c,n),T=N(_,2*p,T),E.set(d),E.set(_,p),E.set(T,2*p),l.position.values=E,l=S(l,t);var v,A=p/3;if(e.shadowVolume){var w=l.normal.values;p=w.length;var O=new Float32Array(6*p);for(v=0;v<p;v++)w[v]=-w[v];O.set(w,p),O=N(w,4*p,O),l.extrudeDirection=new h({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:O}),t.normal||(l.normal=void 0)}var I=f.length,M=A+A,x=m.createTypedArray(E.length/3,2*I+3*M);x.set(f);var C=I;for(v=0;v<I;v+=3){var P=f[v],U=f[v+1],D=f[v+2];x[C++]=D+A,x[C++]=U+A,x[C++]=P+A}var L,b,F,B;for(v=0;v<M;v+=2)L=v+M,b=L+M,F=L+1,B=b+1,x[C++]=L,x[C++]=b,x[C++]=F,x[C++]=F,x[C++]=b,x[C++]=B;return{attributes:l,indices:x}}function O(e,t,n,a,i,o){var u=r.subtract(t,e,B);r.normalize(u,u);var s=n.geodeticSurfaceNormal(e,z),c=r.cross(u,s,B);r.multiplyByScalar(c,a,c);var l=i.latitude,f=i.longitude,d=o.latitude,h=o.longitude;r.add(e,c,z),n.cartesianToCartographic(z,q);var p=q.latitude,m=q.longitude;l=Math.min(l,p),f=Math.min(f,m),d=Math.max(d,p),h=Math.max(h,m),r.subtract(e,c,z),n.cartesianToCartographic(z,q),p=q.latitude,m=q.longitude,l=Math.min(l,p),f=Math.min(f,m),d=Math.max(d,p),h=Math.max(h,m),i.latitude=l,i.longitude=f,o.latitude=d,o.longitude=h}function I(t,n,a,o){t=v(t,n);var u=e(t,r.equalsEpsilon),s=u.length;if(s<2||a<=0)return new T;var c=.5*a;W.latitude=Number.POSITIVE_INFINITY,W.longitude=Number.POSITIVE_INFINITY,X.latitude=Number.NEGATIVE_INFINITY,X.longitude=Number.NEGATIVE_INFINITY;var l,f;if(o===i.ROUNDED){var d=u[0];r.subtract(d,u[1],G),r.normalize(G,G),r.multiplyByScalar(G,c,G),r.add(d,G,V),n.cartesianToCartographic(V,q),l=q.latitude,f=q.longitude,W.latitude=Math.min(W.latitude,l),W.longitude=Math.min(W.longitude,f),X.latitude=Math.max(X.latitude,l),X.longitude=Math.max(X.longitude,f)}for(var h=0;h<s-1;++h)O(u[h],u[h+1],n,c,W,X);var p=u[s-1];r.subtract(p,u[s-2],G),r.normalize(G,G),r.multiplyByScalar(G,c,G),r.add(p,G,V),O(p,V,n,c,W,X),o===i.ROUNDED&&(n.cartesianToCartographic(V,q),l=q.latitude,f=q.longitude,W.latitude=Math.min(W.latitude,l),W.longitude=Math.min(W.longitude,f),X.latitude=Math.max(X.latitude,l),X.longitude=Math.max(X.longitude,f));var m=new T;return m.north=X.latitude,m.south=W.latitude,m.east=X.longitude,m.west=W.longitude,m}function M(e){e=u(e,u.EMPTY_OBJECT);var t=e.positions,n=e.width,a=u(e.height,0),o=u(e.extrudedHeight,a);this._positions=t,this._ellipsoid=f.clone(u(e.ellipsoid,f.WGS84)),this._vertexFormat=R.clone(u(e.vertexFormat,R.DEFAULT)),this._width=n,this._height=Math.max(a,o),this._extrudedHeight=Math.min(a,o),this._cornerType=u(e.cornerType,i.ROUNDED),this._granularity=u(e.granularity,E.RADIANS_PER_DEGREE),this._shadowVolume=u(e.shadowVolume,!1),this._workerName="createCorridorGeometry",this._rectangle=void 0,this.packedLength=1+t.length*r.packedLength+f.packedLength+R.packedLength+6}var x=new r,C=new r,P=new r,U=new r,D=new r,L=new r,b=new r,F=new r,B=new r,z=new r,q=new n,G=new r,V=new r,W=new n,X=new n;M.pack=function(e,t,n){n=u(n,0);var a=e._positions,i=a.length;t[n++]=i;for(var o=0;o<i;++o,n+=r.packedLength)r.pack(a[o],t,n);return f.pack(e._ellipsoid,t,n),n+=f.packedLength,R.pack(e._vertexFormat,t,n),n+=R.packedLength,t[n++]=e._width,t[n++]=e._height,t[n++]=e._extrudedHeight,t[n++]=e._cornerType,t[n++]=e._granularity,t[n]=e._shadowVolume?1:0,t};var H=f.clone(f.UNIT_SPHERE),Y=new R,k={positions:void 0,ellipsoid:H,vertexFormat:Y,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,shadowVolume:void 0};return M.unpack=function(e,t,n){t=u(t,0);for(var a=e[t++],i=new Array(a),o=0;o<a;++o,t+=r.packedLength)i[o]=r.unpack(e,t);var c=f.unpack(e,t,H);t+=f.packedLength;var l=R.unpack(e,t,Y);t+=R.packedLength;var d=e[t++],h=e[t++],p=e[t++],m=e[t++],E=e[t++],y=1===e[t];return s(n)?(n._positions=i,n._ellipsoid=f.clone(c,n._ellipsoid),n._vertexFormat=R.clone(l,n._vertexFormat),n._width=d,n._height=h,n._extrudedHeight=p,n._cornerType=m,n._granularity=E,n._shadowVolume=y,n):(k.positions=i,k.width=d,k.height=h,k.extrudedHeight=p,k.cornerType=m,k.granularity=E,k.shadowVolume=y,new M(k))},M.createGeometry=function(n){var a=n._positions,i=n._width,u=n._ellipsoid;a=v(a,u);var s=e(a,r.equalsEpsilon);if(!(s.length<2||i<=0)){var c,l=n._height,f=n._extrudedHeight,h=!E.equalsEpsilon(l,f,0,E.EPSILON2),p=n._vertexFormat,m={ellipsoid:u,positions:s,width:i,cornerType:n._cornerType,granularity:n._granularity,saveAttributes:!0};if(h)m.height=l,m.extrudedHeight=f,m.shadowVolume=n._shadowVolume,c=w(m,p);else{c=g(o.computePositions(m),p,u),c.attributes.position.values=y.scaleToGeodeticHeight(c.attributes.position.values,l,u)}var T=c.attributes,R=t.fromVertices(T.position.values,void 0,3);return p.position||(c.attributes.position.values=void 0),new d({attributes:T,indices:c.indices,primitiveType:_.TRIANGLES,boundingSphere:R})}},M.createShadowVolume=function(e,t,r){var n=e._granularity,a=e._ellipsoid,i=t(n,a),o=r(n,a);return new M({positions:e._positions,width:e._width,cornerType:e._cornerType,ellipsoid:a,granularity:n,extrudedHeight:i,height:o,vertexFormat:R.POSITION_ONLY,shadowVolume:!0})},c(M.prototype,{rectangle:{get:function(){return s(this._rectangle)||(this._rectangle=I(this._positions,this._ellipsoid,this._width,this._cornerType)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return[0,0,0,1,1,0]}}}),M}),define("Workers/createCorridorGeometry",["../Core/CorridorGeometry","../Core/defined","../Core/Ellipsoid"],function(e,t,r){"use strict";function n(n,a){return t(a)&&(n=e.unpack(n,a)),n._ellipsoid=r.clone(n._ellipsoid),e.createGeometry(n)}return n})}();