/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var o={};return o.typeOf={},o.defined=function(n,o){if(!e(o))throw new t(r(n))},o.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},o.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},o.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},o.typeOf.number.lessThan=function(e,r,n){if(o.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},o.typeOf.number.lessThanOrEquals=function(e,r,n){if(o.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},o.typeOf.number.greaterThan=function(e,r,n){if(o.typeOf.number(e,r),r<=n)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},o.typeOf.number.greaterThanOrEquals=function(e,r,n){if(o.typeOf.number(e,r),r<n)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},o.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},o.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},o.typeOf.number.equals=function(e,r,n,a){if(o.typeOf.number(e,n),o.typeOf.number(r,a),n!==a)throw new t(e+" must be equal to "+r+", the actual values are "+n+" and "+a)},o}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e&&null!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n,o){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=r(Math.sign,function(e){return e=+e,0===e||e!==e?e:e>0?1:-1}),a.signNotZero=function(e){return e<0?-1:1},a.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*a.clamp(e,-1,1)+.5)*t)},a.fromSNorm=function(e,t){return t=r(t,255),a.clamp(e,0,t)/t*2-1},a.sinh=r(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),a.cosh=r(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=Math.PI/2,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI/2,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){var t=a.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},a.clampToLatitudeRange=function(e){return a.clamp(e,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(e){return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){return(e%t+t)%t},a.equalsEpsilon=function(e,t,n,o){o=r(o,n);var a=Math.abs(e-t);return a<=o||a<=n*Math.max(Math.abs(e),Math.abs(t))};var i=[1];a.factorial=function(e){var t=i.length;if(e>=t)for(var r=i[t-1],n=t;n<=e;n++)i.push(r*n);return i[e]},a.incrementWrap=function(e,t,n){return n=r(n,0),++e,e>t&&(e=n),e},a.isPowerOfTwo=function(e){return 0!==e&&0==(e&e-1)},a.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},a.clamp=function(e,t,r){return e<t?t:e>r?r:e};var s=new e;return a.setRandomNumberSeed=function(t){s=new e(t)},a.nextRandomNumber=function(){return s.random()},a.randomBetween=function(e,t){return a.nextRandomNumber()*(t-e)+e},a.acosClamped=function(e){return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},a.logBase=function(e,t){return Math.log(e)/Math.log(t)},a.cbrt=r(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t}),a.log2=r(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),a.fog=function(e,t){var r=e*t;return 1-Math.exp(-r*r)},a.fastApproximateAtan=function(e){return e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},a.fastApproximateAtan2=function(e,t){var r,n,o=Math.abs(e);r=Math.abs(t),n=Math.max(o,r),r=Math.min(o,r);var i=r/n;return o=a.fastApproximateAtan(i),o=Math.abs(t)>Math.abs(e)?a.PI_OVER_TWO-o:o,o=e<0?a.PI-o:o,o=t<0?-o:o},a}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,a){"use strict";function i(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}i.fromSpherical=function(e,n){r(n)||(n=new i);var o=e.clock,a=e.cone,s=t(e.magnitude,1),u=s*Math.sin(a);return n.x=u*Math.cos(o),n.y=u*Math.sin(o),n.z=s*Math.cos(a),n},i.fromElements=function(e,t,n,o){return r(o)?(o.x=e,o.y=t,o.z=n,o):new i(e,t,n)},i.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new i(e.x,e.y,e.z)},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n]=e.z,r},i.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new i),o.x=e[n++],o.y=e[n++],o.z=e[n],o},i.packArray=function(e,t){var n=e.length;r(t)?t.length=3*n:t=new Array(3*n);for(var o=0;o<n;++o)i.pack(e[o],t,3*o);return t},i.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/3:t=new Array(n/3);for(var o=0;o<n;o+=3){var a=o/3;t[a]=i.unpack(e,o,t[a])}return t},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var s=new i;i.distance=function(e,t){return i.subtract(e,t,s),i.magnitude(s)},i.distanceSquared=function(e,t){return i.subtract(e,t,s),i.magnitudeSquared(s)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},i.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r.z=e.z/t.z,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var c=new i,l=new i;i.angleBetween=function(e,t){i.normalize(e,c),i.normalize(t,l);var r=i.dot(c,l),n=i.magnitude(i.cross(c,l,c));return Math.atan2(n,r)};var f=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,f);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.projectVector=function(e,t,r){var n=i.dot(e,t)/i.dot(t,t);return i.multiplyByScalar(t,n,r)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},i.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,o)&&a.equalsEpsilon(e.y,t.y,n,o)&&a.equalsEpsilon(e.z,t.z,n,o)},i.cross=function(e,t,r){var n=e.x,o=e.y,a=e.z,i=t.x,s=t.y,u=t.z,c=o*u-a*s,l=a*i-n*u,f=n*s-o*i;return r.x=c,r.y=l,r.z=f,r},i.fromDegrees=function(e,t,r,n,o){return e=a.toRadians(e),t=a.toRadians(t),i.fromRadians(e,t,r,n,o)};var d=new i,h=new i,E=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(e,n,o,a,s){o=t(o,0);var u=r(a)?a.radiiSquared:E,c=Math.cos(n);d.x=c*Math.cos(e),d.y=c*Math.sin(e),d.z=Math.sin(n),d=i.normalize(d,d),i.multiplyComponents(u,d,h);var l=Math.sqrt(i.dot(d,h));return h=i.divideByScalar(h,l,h),d=i.multiplyByScalar(d,o,d),r(s)||(s=new i),i.add(h,d,s)},i.fromDegreesArray=function(e,t,n){var o=e.length;r(n)?n.length=o/2:n=new Array(o/2);for(var a=0;a<o;a+=2){var s=e[a],u=e[a+1],c=a/2;n[c]=i.fromDegrees(s,u,0,t,n[c])}return n},i.fromRadiansArray=function(e,t,n){var o=e.length;r(n)?n.length=o/2:n=new Array(o/2);for(var a=0;a<o;a+=2){var s=e[a],u=e[a+1],c=a/2;n[c]=i.fromRadians(s,u,0,t,n[c])}return n},i.fromDegreesArrayHeights=function(e,t,n){var o=e.length;r(n)?n.length=o/3:n=new Array(o/3);for(var a=0;a<o;a+=3){var s=e[a],u=e[a+1],c=e[a+2],l=a/3;n[l]=i.fromDegrees(s,u,c,t,n[l])}return n},i.fromRadiansArrayHeights=function(e,t,n){var o=e.length;r(n)?n.length=o/3:n=new Array(o/3);for(var a=0;a<o;a+=3){var s=e[a],u=e[a+1],c=e[a+2],l=a/3;n[l]=i.fromRadians(s,u,c,t,n[l])}return n},i.ZERO=o(new i(0,0,0)),i.UNIT_X=o(new i(1,0,0)),i.UNIT_Y=o(new i(0,1,0)),i.UNIT_Z=o(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function o(r,o,s,u,c){var l=r.x,f=r.y,d=r.z,h=o.x,E=o.y,m=o.z,p=l*l*h*h,y=f*f*E*E,_=d*d*m*m,T=p+y+_,R=Math.sqrt(1/T),A=e.multiplyByScalar(r,R,a);if(T<u)return isFinite(R)?e.clone(A,c):void 0;var S=s.x,C=s.y,I=s.z,g=i;g.x=A.x*S*2,g.y=A.y*C*2,g.z=A.z*I*2;var O,N,v,w,M,F,x,D,U,P,L,b=(1-R)*e.magnitude(r)/(.5*e.magnitude(g)),B=0;do{b-=B,v=1/(1+b*S),w=1/(1+b*C),M=1/(1+b*I),F=v*v,x=w*w,D=M*M,U=F*v,P=x*w,L=D*M,O=p*F+y*x+_*D-1,N=p*U*S+y*P*C+_*L*I;B=O/(-2*N)}while(Math.abs(O)>n.EPSILON12);return t(c)?(c.x=l*v,c.y=f*w,c.z=d*M,c):new e(l*v,f*w,d*M)}var a=new e,i=new e;return o}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,o,a,i){"use strict";function s(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}s.fromRadians=function(e,t,o,a){return o=r(o,0),n(a)?(a.longitude=e,a.latitude=t,a.height=o,a):new s(e,t,o)},s.fromDegrees=function(e,t,r,n){return e=a.toRadians(e),t=a.toRadians(t),s.fromRadians(e,t,r,n)};var u=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),d=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),h=a.EPSILON1;return s.fromCartesian=function(t,r,o){var E=n(r)?r.oneOverRadii:f,m=n(r)?r.oneOverRadiiSquared:d,p=n(r)?r._centerToleranceSquared:h,y=i(t,E,m,p,c);if(n(y)){var _=e.multiplyComponents(y,m,u);_=e.normalize(_,_);var T=e.subtract(t,y,l),R=Math.atan2(_.y,_.x),A=Math.asin(_.z),S=a.sign(e.dot(T,t))*e.magnitude(T);return n(o)?(o.longitude=R,o.latitude=A,o.height=S,o):new s(R,A,S)}},s.toCartesian=function(t,r,n){return e.fromRadians(t.longitude,t.latitude,t.height,r,n)},s.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new s(e.longitude,e.latitude,e.height)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.longitude-t.longitude)<=r&&Math.abs(e.latitude-t.latitude)<=r&&Math.abs(e.height-t.height)<=r},s.ZERO=o(new s(0,0,0)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},s}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,o,a,i,s,u,c){"use strict";function l(t,r,o,a){r=n(r,0),o=n(o,0),a=n(a,0),t._radii=new e(r,o,a),t._radiiSquared=new e(r*r,o*o,a*a),t._radiiToTheFourth=new e(r*r*r*r,o*o*o*o,a*a*a*a),t._oneOverRadii=new e(0===r?0:1/r,0===o?0:1/o,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===o?0:1/(o*o),0===a?0:1/(a*a)),t._minimumRadius=Math.min(r,o,a),t._maximumRadius=Math.max(r,o,a),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function f(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,l(this,e,t,r)}a(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(t,r){if(o(t)){var n=t._radii;return o(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new f(n.x,n.y,n.z)}},f.fromCartesian3=function(e,t){return o(t)||(t=new f),o(e)?(l(t,e.x,e.y,e.z),t):t},f.WGS84=s(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=s(new f(1,1,1)),f.MOON=s(new f(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(t,r,o){return o=n(o,0),e.pack(t._radii,r,o),r},f.unpack=function(t,r,o){r=n(r,0);var a=e.unpack(t,r);return f.fromCartesian3(a,o)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(t,r){var n=t.longitude,a=t.latitude,i=Math.cos(a),s=i*Math.cos(n),u=i*Math.sin(n),c=Math.sin(a);return o(r)||(r=new e),r.x=s,r.y=u,r.z=c,e.normalize(r,r)},f.prototype.geodeticSurfaceNormal=function(t,r){return o(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var d=new e,h=new e;f.prototype.cartographicToCartesian=function(t,r){var n=d,a=h;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,a);var i=Math.sqrt(e.dot(n,a));return e.divideByScalar(a,i,a),e.multiplyByScalar(n,t.height,n),o(r)||(r=new e),e.add(a,n,r)},f.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;o(t)?t.length=r:t=new Array(r);for(var n=0;n<r;n++)t[n]=this.cartographicToCartesian(e[n],t[n]);return t};var E=new e,m=new e,p=new e;return f.prototype.cartesianToCartographic=function(r,n){var a=this.scaleToGeodeticSurface(r,m);if(o(a)){var i=this.geodeticSurfaceNormal(a,E),s=e.subtract(r,a,p),c=Math.atan2(i.y,i.x),l=Math.asin(i.z),f=u.sign(e.dot(s,r))*e.magnitude(s);return o(n)?(n.longitude=c,n.latitude=l,n.height=f,n):new t(c,l,f)}},f.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;o(t)?t.length=r:t=new Array(r);for(var n=0;n<r;++n)t[n]=this.cartesianToCartographic(e[n],t[n]);return t},f.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},f.prototype.scaleToGeocentricSurface=function(t,r){o(r)||(r=new e);var n=t.x,a=t.y,i=t.z,s=this._oneOverRadiiSquared,u=1/Math.sqrt(n*n*s.x+a*a*s.y+i*i*s.z);return e.multiplyByScalar(t,u,r)},f.prototype.transformPositionToScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},f.prototype.transformPositionFromScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},f.prototype.equals=function(t){return this===t||o(t)&&e.equals(this._radii,t._radii)},f.prototype.toString=function(){return this._radii.toString()},f.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,r,a){r=n(r,0);var i=this._squaredXOverSquaredZ;if(o(a)||(a=new e),a.x=0,a.y=0,a.z=t.z*(1-i),!(Math.abs(a.z)>=this._radii.z-r))return a},f}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,o,a,i){"use strict";function s(e){this._ellipsoid=r(e,i.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return o(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(t,r){var o=this._semimajorAxis,a=t.longitude*o,i=t.latitude*o,s=t.height;return n(r)?(r.x=a,r.y=i,r.z=s,r):new e(a,i,s)},s.prototype.unproject=function(e,r){var o=this._oneOverSemimajorAxis,a=e.x*o,i=e.y*o,s=e.z;return n(r)?(r.longitude=a,r.latitude=i,r.height=s,r):new t(a,i,s)},s}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";return e({OUTSIDE:-1,INTERSECTING:0,INSIDE:1})}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,a,i,s){"use strict";function u(e,t,n,o,a,i,s,u,c){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(s,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(i,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function l(e){for(var t=0,r=0;r<3;++r){var n=e[u.getElementIndex(m[r],E[r])];t+=2*n*n}return Math.sqrt(t)}function f(e,t){for(var r=s.EPSILON15,n=0,o=1,a=0;a<3;++a){var i=Math.abs(e[u.getElementIndex(m[a],E[a])]);i>n&&(o=a,n=i)}var c=1,l=0,f=E[o],d=m[o];if(Math.abs(e[u.getElementIndex(d,f)])>r){var h,p=e[u.getElementIndex(d,d)],y=e[u.getElementIndex(f,f)],_=e[u.getElementIndex(d,f)],T=(p-y)/2/_;h=T<0?-1/(-T+Math.sqrt(1+T*T)):1/(T+Math.sqrt(1+T*T)),c=1/Math.sqrt(1+h*h),l=h*c}return t=u.clone(u.IDENTITY,t),t[u.getElementIndex(f,f)]=t[u.getElementIndex(d,d)]=c,t[u.getElementIndex(d,f)]=l,t[u.getElementIndex(f,d)]=-l,t}u.packedLength=9,u.pack=function(e,t,n){return n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t},u.unpack=function(e,t,o){return t=r(t,0),n(o)||(o=new u),o[0]=e[t++],o[1]=e[t++],o[2]=e[t++],o[3]=e[t++],o[4]=e[t++],o[5]=e[t++],o[6]=e[t++],o[7]=e[t++],o[8]=e[t++],o},u.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new u(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},u.fromArray=function(e,t,o){return t=r(t,0),n(o)||(o=new u),o[0]=e[t],o[1]=e[t+1],o[2]=e[t+2],o[3]=e[t+3],o[4]=e[t+4],o[5]=e[t+5],o[6]=e[t+6],o[7]=e[t+7],o[8]=e[t+8],o},u.fromColumnMajorArray=function(e,t){return u.clone(e,t)},u.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new u(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},u.fromQuaternion=function(e,t){var r=e.x*e.x,o=e.x*e.y,a=e.x*e.z,i=e.x*e.w,s=e.y*e.y,c=e.y*e.z,l=e.y*e.w,f=e.z*e.z,d=e.z*e.w,h=e.w*e.w,E=r-s-f+h,m=2*(o-d),p=2*(a+l),y=2*(o+d),_=-r+s-f+h,T=2*(c-i),R=2*(a-l),A=2*(c+i),S=-r-s+f+h;return n(t)?(t[0]=E,t[1]=y,t[2]=R,t[3]=m,t[4]=_,t[5]=A,t[6]=p,t[7]=T,t[8]=S,t):new u(E,m,p,y,_,T,R,A,S)},u.fromHeadingPitchRoll=function(e,t){var r=Math.cos(-e.pitch),o=Math.cos(-e.heading),a=Math.cos(e.roll),i=Math.sin(-e.pitch),s=Math.sin(-e.heading),c=Math.sin(e.roll),l=r*o,f=-a*s+c*i*o,d=c*s+a*i*o,h=r*s,E=a*o+c*i*s,m=-c*o+a*i*s,p=-i,y=c*r,_=a*r;return n(t)?(t[0]=l,t[1]=h,t[2]=p,t[3]=f,t[4]=E,t[5]=y,t[6]=d,t[7]=m,t[8]=_,t):new u(l,f,d,h,E,m,p,y,_)},u.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new u(e.x,0,0,0,e.y,0,0,0,e.z)},u.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new u(e,0,0,0,e,0,0,0,e)},u.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new u(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},u.fromRotationX=function(e,t){var r=Math.cos(e),o=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=o,t[6]=0,t[7]=-o,t[8]=r,t):new u(1,0,0,0,r,-o,0,o,r)},u.fromRotationY=function(e,t){var r=Math.cos(e),o=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-o,t[3]=0,t[4]=1,t[5]=0,t[6]=o,t[7]=0,t[8]=r,t):new u(r,0,o,0,1,0,-o,0,r)},u.fromRotationZ=function(e,t){var r=Math.cos(e),o=Math.sin(e);return n(t)?(t[0]=r,t[1]=o,t[2]=0,t[3]=-o,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new u(r,-o,0,o,r,0,0,0,1)},u.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},u.getElementIndex=function(e,t){return 3*e+t},u.getColumn=function(e,t,r){var n=3*t,o=e[n],a=e[n+1],i=e[n+2];return r.x=o,r.y=a,r.z=i,r},u.setColumn=function(e,t,r,n){n=u.clone(e,n);var o=3*t;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n},u.getRow=function(e,t,r){var n=e[t],o=e[t+3],a=e[t+6];return r.x=n,r.y=o,r.z=a,r},u.setRow=function(e,t,r,n){return n=u.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var d=new e;u.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],d)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],d)),r};var h=new e;u.getMaximumScale=function(t){return u.getScale(t,h),e.maximumComponent(h)},u.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],i=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],s=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],u=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=o,r[2]=a,r[3]=i,r[4]=s,r[5]=u,r[6]=c,r[7]=l,r[8]=f,r},u.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},u.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},u.multiplyByVector=function(e,t,r){var n=t.x,o=t.y,a=t.z,i=e[0]*n+e[3]*o+e[6]*a,s=e[1]*n+e[4]*o+e[7]*a,u=e[2]*n+e[5]*o+e[8]*a;return r.x=i,r.y=s,r.z=u,r},u.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},u.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.x,r[3]=e[3]*t.y,r[4]=e[4]*t.y,r[5]=e[5]*t.y,r[6]=e[6]*t.z,r[7]=e[7]*t.z,r[8]=e[8]*t.z,r},u.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},u.transpose=function(e,t){var r=e[0],n=e[3],o=e[6],a=e[1],i=e[4],s=e[7],u=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=o,t[3]=a,t[4]=i,t[5]=s,t[6]=u,t[7]=c,t[8]=l,t};var E=[1,0,0],m=[2,2,1],p=new u,y=new u;return u.computeEigenDecomposition=function(e,t){var r=s.EPSILON20,o=0,a=0;n(t)||(t={});for(var i=t.unitary=u.clone(u.IDENTITY,t.unitary),d=t.diagonal=u.clone(e,t.diagonal),h=r*c(d);a<10&&l(d)>h;)f(d,p),u.transpose(p,y),u.multiply(d,p,d),u.multiply(y,d,d),u.multiply(i,p,i),++o>2&&(++a,o=0);return t},u.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},u.determinant=function(e){var t=e[0],r=e[3],n=e[6],o=e[1],a=e[4],i=e[7],s=e[2],u=e[5],c=e[8];return t*(a*c-u*i)+o*(u*n-r*c)+s*(r*i-a*n)},u.inverse=function(e,t){var r=e[0],n=e[1],o=e[2],a=e[3],i=e[4],s=e[5],c=e[6],l=e[7],f=e[8],d=u.determinant(e);t[0]=i*f-l*s,t[1]=l*o-n*f,t[2]=n*s-i*o,t[3]=c*s-a*f,t[4]=r*f-c*o,t[5]=a*o-r*s,t[6]=a*l-c*i,t[7]=c*n-r*l,t[8]=r*i-a*n;var h=1/d;return u.multiplyByScalar(t,h,t)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},u.IDENTITY=i(new u(1,0,0,0,1,0,0,0,1)),u.ZERO=i(new u(0,0,0,0,0,0,0,0,0)),u.COLUMN0ROW0=0,u.COLUMN0ROW1=1,u.COLUMN0ROW2=2,u.COLUMN1ROW0=3,u.COLUMN1ROW1=4,u.COLUMN1ROW2=5,u.COLUMN2ROW0=6,u.COLUMN2ROW1=7,u.COLUMN2ROW2=8,o(u.prototype,{length:{get:function(){return u.packedLength}}}),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},u}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,a){"use strict";function i(e,r,n,o){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(o,0)}i.fromElements=function(e,t,n,o,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=o,a):new i(e,t,n,o)},i.fromColor=function(e,t){return r(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w)},i.packedLength=4,i.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w,r},i.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new i),o.x=e[n++],o.y=e[n++],o.z=e[n++],o.w=e[n],o},i.packArray=function(e,t){var n=e.length;r(t)?t.length=4*n:t=new Array(4*n);for(var o=0;o<n;++o)i.pack(e[o],t,4*o);return t},i.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/4:t=new Array(n/4);for(var o=0;o<n;o+=4){var a=o/4;t[a]=i.unpack(e,o,t[a])}return t},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var s=new i;i.distance=function(e,t){return i.subtract(e,t,s),i.magnitude(s)},i.distanceSquared=function(e,t){return i.subtract(e,t,s),i.magnitudeSquared(s)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},i.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r.z=e.z/t.z,r.w=e.w/t.w,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var c=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,c);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},i.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,o)&&a.equalsEpsilon(e.y,t.y,n,o)&&a.equalsEpsilon(e.z,t.z,n,o)&&a.equalsEpsilon(e.w,t.w,n,o)},i.ZERO=o(new i(0,0,0,0)),i.UNIT_X=o(new i(1,0,0,0)),i.UNIT_Y=o(new i(0,1,0,0)),
i.UNIT_Z=o(new i(0,0,1,0)),i.UNIT_W=o(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var l=new Float32Array(1);return i.packFloat=function(e,t){if(r(t)||(t=new i),l[0]=e,0===(e=l[0]))return i.clone(i.ZERO,t);var n,o=e<0?1:0;isFinite(e)?(e=Math.abs(e),n=Math.floor(a.logBase(e,10))+1,e/=Math.pow(10,n)):(e=.1,n=38);var s=256*e;return t.x=Math.floor(s),s=256*(s-t.x),t.y=Math.floor(s),s=256*(s-t.y),t.z=Math.floor(s),t.w=2*(n+38)+o,t},i.unpackFloat=function(e){var t=e.w/2,r=Math.floor(t),n=2*(t-r);if(r-=38,n=2*n-1,n=-n,r>=38)return n<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var o=n*e.x*(1/256);return o+=n*e.y*(1/65536),(o+=n*e.z*(1/16777216))*Math.pow(10,r)},i}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,o,a,i,s,u,c){"use strict";function l(e,t,r,o,a,i,s,u,c,l,f,d,h,E,m,p){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(i,0),this[6]=n(l,0),this[7]=n(E,0),this[8]=n(r,0),this[9]=n(s,0),this[10]=n(f,0),this[11]=n(m,0),this[12]=n(o,0),this[13]=n(u,0),this[14]=n(d,0),this[15]=n(p,0)}l.packedLength=16,l.pack=function(e,t,r){return r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15],t},l.unpack=function(e,t,r){return t=n(t,0),o(r)||(r=new l),r[0]=e[t++],r[1]=e[t++],r[2]=e[t++],r[3]=e[t++],r[4]=e[t++],r[5]=e[t++],r[6]=e[t++],r[7]=e[t++],r[8]=e[t++],r[9]=e[t++],r[10]=e[t++],r[11]=e[t++],r[12]=e[t++],r[13]=e[t++],r[14]=e[t++],r[15]=e[t],r},l.clone=function(e,t){if(o(e))return o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return o(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(t,r,a){return r=n(r,e.ZERO),o(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=r.x,a[13]=r.y,a[14]=r.z,a[15]=1,a):new l(t[0],t[3],t[6],r.x,t[1],t[4],t[7],r.y,t[2],t[5],t[8],r.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,t,r,n){o(n)||(n=new l);var a=r.x,i=r.y,s=r.z,u=t.x*t.x,c=t.x*t.y,f=t.x*t.z,d=t.x*t.w,h=t.y*t.y,E=t.y*t.z,m=t.y*t.w,p=t.z*t.z,y=t.z*t.w,_=t.w*t.w,T=u-h-p+_,R=2*(c-y),A=2*(f+m),S=2*(c+y),C=-u+h-p+_,I=2*(E-d),g=2*(f-m),O=2*(E+d),N=-u-h+p+_;return n[0]=T*a,n[1]=S*a,n[2]=g*a,n[3]=0,n[4]=R*i,n[5]=C*i,n[6]=O*i,n[7]=0,n[8]=A*s,n[9]=I*s,n[10]=N*s,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n},l.fromTranslationRotationScale=function(e,t){return l.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},l.fromTranslation=function(e,t){return l.fromRotationTranslation(u.IDENTITY,e,t)},l.fromScale=function(e,t){return o(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return o(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,d=new e,h=new e;l.fromCamera=function(t,r){var n=t.position,a=t.direction,i=t.up;e.normalize(a,f),e.normalize(e.cross(f,i,d),d),e.normalize(e.cross(d,f,h),h);var s=d.x,u=d.y,c=d.z,E=f.x,m=f.y,p=f.z,y=h.x,_=h.y,T=h.z,R=n.x,A=n.y,S=n.z,C=s*-R+u*-A+c*-S,I=y*-R+_*-A+T*-S,g=E*R+m*A+p*S;return o(r)?(r[0]=s,r[1]=y,r[2]=-E,r[3]=0,r[4]=u,r[5]=_,r[6]=-m,r[7]=0,r[8]=c,r[9]=T,r[10]=-p,r[11]=0,r[12]=C,r[13]=I,r[14]=g,r[15]=1,r):new l(s,u,c,C,y,_,T,I,-E,-m,-p,g,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,r,n,o){var a=Math.tan(.5*e),i=1/a,s=i/t,u=(n+r)/(r-n),c=2*n*r/(r-n);return o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=i,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=u,o[11]=-1,o[12]=0,o[13]=0,o[14]=c,o[15]=0,o},l.computeOrthographicOffCenter=function(e,t,r,n,o,a,i){var s=1/(t-e),u=1/(n-r),c=1/(a-o),l=-(t+e)*s,f=-(n+r)*u,d=-(a+o)*c;return s*=2,u*=2,c*=-2,i[0]=s,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=c,i[11]=0,i[12]=l,i[13]=f,i[14]=d,i[15]=1,i},l.computePerspectiveOffCenter=function(e,t,r,n,o,a,i){var s=2*o/(t-e),u=2*o/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),f=-(a+o)/(a-o),d=-2*a*o/(a-o);return i[0]=s,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=c,i[9]=l,i[10]=f,i[11]=-1,i[12]=0,i[13]=0,i[14]=d,i[15]=0,i},l.computeInfinitePerspectiveOffCenter=function(e,t,r,n,o,a){var i=2*o/(t-e),s=2*o/(n-r),u=(t+e)/(t-e),c=(n+r)/(n-r),l=-2*o;return a[0]=i,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=u,a[9]=c,a[10]=-1,a[11]=-1,a[12]=0,a[13]=0,a[14]=l,a[15]=0,a},l.computeViewportTransformation=function(e,t,r,o){e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),i=n(e.y,0),s=n(e.width,0),u=n(e.height,0);t=n(t,0),r=n(r,1);var c=.5*s,l=.5*u,f=.5*(r-t),d=c,h=l,E=f,m=a+c,p=i+l,y=t+f;return o[0]=d,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=h,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=E,o[11]=0,o[12]=m,o[13]=p,o[14]=y,o[15]=1,o},l.computeView=function(t,r,n,o,a){return a[0]=o.x,a[1]=n.x,a[2]=-r.x,a[3]=0,a[4]=o.y,a[5]=n.y,a[6]=-r.y,a[7]=0,a[8]=o.z,a[9]=n.z,a[10]=-r.z,a[11]=0,a[12]=-e.dot(o,t),a[13]=-e.dot(n,t),a[14]=e.dot(r,t),a[15]=1,a},l.toArray=function(e,t){return o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return 4*e+t},l.getColumn=function(e,t,r){var n=4*t,o=e[n],a=e[n+1],i=e[n+2],s=e[n+3];return r.x=o,r.y=a,r.z=i,r.w=s,r},l.setColumn=function(e,t,r,n){n=l.clone(e,n);var o=4*t;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n[o+3]=r.w,n},l.setTranslation=function(e,t,r){return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},l.getRow=function(e,t,r){var n=e[t],o=e[t+4],a=e[t+8],i=e[t+12];return r.x=n,r.y=o,r.z=a,r.w=i,r},l.setRow=function(e,t,r,n){return n=l.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var E=new e;l.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],E)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],E)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],E)),r};var m=new e;l.getMaximumScale=function(t){return l.getScale(t,m),e.maximumComponent(m)},l.multiply=function(e,t,r){var n=e[0],o=e[1],a=e[2],i=e[3],s=e[4],u=e[5],c=e[6],l=e[7],f=e[8],d=e[9],h=e[10],E=e[11],m=e[12],p=e[13],y=e[14],_=e[15],T=t[0],R=t[1],A=t[2],S=t[3],C=t[4],I=t[5],g=t[6],O=t[7],N=t[8],v=t[9],w=t[10],M=t[11],F=t[12],x=t[13],D=t[14],U=t[15],P=n*T+s*R+f*A+m*S,L=o*T+u*R+d*A+p*S,b=a*T+c*R+h*A+y*S,B=i*T+l*R+E*A+_*S,z=n*C+s*I+f*g+m*O,G=o*C+u*I+d*g+p*O,q=a*C+c*I+h*g+y*O,V=i*C+l*I+E*g+_*O,W=n*N+s*v+f*w+m*M,k=o*N+u*v+d*w+p*M,H=a*N+c*v+h*w+y*M,X=i*N+l*v+E*w+_*M,Y=n*F+s*x+f*D+m*U,j=o*F+u*x+d*D+p*U,K=a*F+c*x+h*D+y*U,Z=i*F+l*x+E*D+_*U;return r[0]=P,r[1]=L,r[2]=b,r[3]=B,r[4]=z,r[5]=G,r[6]=q,r[7]=V,r[8]=W,r[9]=k,r[10]=H,r[11]=X,r[12]=Y,r[13]=j,r[14]=K,r[15]=Z,r},l.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},l.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},l.multiplyTransformation=function(e,t,r){var n=e[0],o=e[1],a=e[2],i=e[4],s=e[5],u=e[6],c=e[8],l=e[9],f=e[10],d=e[12],h=e[13],E=e[14],m=t[0],p=t[1],y=t[2],_=t[4],T=t[5],R=t[6],A=t[8],S=t[9],C=t[10],I=t[12],g=t[13],O=t[14],N=n*m+i*p+c*y,v=o*m+s*p+l*y,w=a*m+u*p+f*y,M=n*_+i*T+c*R,F=o*_+s*T+l*R,x=a*_+u*T+f*R,D=n*A+i*S+c*C,U=o*A+s*S+l*C,P=a*A+u*S+f*C,L=n*I+i*g+c*O+d,b=o*I+s*g+l*O+h,B=a*I+u*g+f*O+E;return r[0]=N,r[1]=v,r[2]=w,r[3]=0,r[4]=M,r[5]=F,r[6]=x,r[7]=0,r[8]=D,r[9]=U,r[10]=P,r[11]=0,r[12]=L,r[13]=b,r[14]=B,r[15]=1,r},l.multiplyByMatrix3=function(e,t,r){var n=e[0],o=e[1],a=e[2],i=e[4],s=e[5],u=e[6],c=e[8],l=e[9],f=e[10],d=t[0],h=t[1],E=t[2],m=t[3],p=t[4],y=t[5],_=t[6],T=t[7],R=t[8],A=n*d+i*h+c*E,S=o*d+s*h+l*E,C=a*d+u*h+f*E,I=n*m+i*p+c*y,g=o*m+s*p+l*y,O=a*m+u*p+f*y,N=n*_+i*T+c*R,v=o*_+s*T+l*R,w=a*_+u*T+f*R;return r[0]=A,r[1]=S,r[2]=C,r[3]=0,r[4]=I,r[5]=g,r[6]=O,r[7]=0,r[8]=N,r[9]=v,r[10]=w,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},l.multiplyByTranslation=function(e,t,r){var n=t.x,o=t.y,a=t.z,i=n*e[0]+o*e[4]+a*e[8]+e[12],s=n*e[1]+o*e[5]+a*e[9]+e[13],u=n*e[2]+o*e[6]+a*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=i,r[13]=s,r[14]=u,r[15]=e[15],r};var p=new e;l.multiplyByUniformScale=function(e,t,r){return p.x=t,p.y=t,p.z=t,l.multiplyByScale(e,p,r)},l.multiplyByScale=function(e,t,r){var n=t.x,o=t.y,a=t.z;return 1===n&&1===o&&1===a?l.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=o*e[4],r[5]=o*e[5],r[6]=o*e[6],r[7]=0,r[8]=a*e[8],r[9]=a*e[9],r[10]=a*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},l.multiplyByVector=function(e,t,r){var n=t.x,o=t.y,a=t.z,i=t.w,s=e[0]*n+e[4]*o+e[8]*a+e[12]*i,u=e[1]*n+e[5]*o+e[9]*a+e[13]*i,c=e[2]*n+e[6]*o+e[10]*a+e[14]*i,l=e[3]*n+e[7]*o+e[11]*a+e[15]*i;return r.x=s,r.y=u,r.z=c,r.w=l,r},l.multiplyByPointAsVector=function(e,t,r){var n=t.x,o=t.y,a=t.z,i=e[0]*n+e[4]*o+e[8]*a,s=e[1]*n+e[5]*o+e[9]*a,u=e[2]*n+e[6]*o+e[10]*a;return r.x=i,r.y=s,r.z=u,r},l.multiplyByPoint=function(e,t,r){var n=t.x,o=t.y,a=t.z,i=e[0]*n+e[4]*o+e[8]*a+e[12],s=e[1]*n+e[5]*o+e[9]*a+e[13],u=e[2]*n+e[6]*o+e[10]*a+e[14];return r.x=i,r.y=s,r.z=u,r},l.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},l.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},l.transpose=function(e,t){var r=e[1],n=e[2],o=e[3],a=e[6],i=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=i,t[14]=s,t[15]=e[15],t},l.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},l.equals=function(e,t){return e===t||o(e)&&o(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,r){return e===t||o(e)&&o(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},l.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},l.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var y=new u,_=new u,T=new t,R=new t(0,0,0,1);return l.inverse=function(e,r){if(u.equalsEpsilon(l.getRotation(e,y),_,s.EPSILON7)&&t.equals(l.getRow(e,3,T),R))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],o=e[4],a=e[8],i=e[12],f=e[1],d=e[5],h=e[9],E=e[13],m=e[2],p=e[6],A=e[10],S=e[14],C=e[3],I=e[7],g=e[11],O=e[15],N=A*O,v=S*g,w=p*O,M=S*I,F=p*g,x=A*I,D=m*O,U=S*C,P=m*g,L=A*C,b=m*I,B=p*C,z=N*d+M*h+F*E-(v*d+w*h+x*E),G=v*f+D*h+L*E-(N*f+U*h+P*E),q=w*f+U*d+b*E-(M*f+D*d+B*E),V=x*f+P*d+B*h-(F*f+L*d+b*h),W=v*o+w*a+x*i-(N*o+M*a+F*i),k=N*n+U*a+P*i-(v*n+D*a+L*i),H=M*n+D*o+B*i-(w*n+U*o+b*i),X=F*n+L*o+b*a-(x*n+P*o+B*a);N=a*E,v=i*h,w=o*E,M=i*d,F=o*h,x=a*d,D=n*E,U=i*f,P=n*h,L=a*f,b=n*d,B=o*f;var Y=N*I+M*g+F*O-(v*I+w*g+x*O),j=v*C+D*g+L*O-(N*C+U*g+P*O),K=w*C+U*I+b*O-(M*C+D*I+B*O),Z=x*C+P*I+B*g-(F*C+L*I+b*g),J=w*A+x*S+v*p-(F*S+N*p+M*A),Q=P*S+N*m+U*A-(D*A+L*S+v*m),$=D*p+B*S+M*m-(b*S+w*m+U*p),ee=b*A+F*m+L*p-(P*p+B*A+x*m),te=n*z+o*G+a*q+i*V;if(Math.abs(te)<s.EPSILON20)throw new c("matrix is not invertible because its determinate is zero.");return te=1/te,r[0]=z*te,r[1]=G*te,r[2]=q*te,r[3]=V*te,r[4]=W*te,r[5]=k*te,r[6]=H*te,r[7]=X*te,r[8]=Y*te,r[9]=j*te,r[10]=K*te,r[11]=Z*te,r[12]=J*te,r[13]=Q*te,r[14]=$*te,r[15]=ee*te,r},l.inverseTransformation=function(e,t){var r=e[0],n=e[1],o=e[2],a=e[4],i=e[5],s=e[6],u=e[8],c=e[9],l=e[10],f=e[12],d=e[13],h=e[14],E=-r*f-n*d-o*h,m=-a*f-i*d-s*h,p=-u*f-c*d-l*h;return t[0]=r,t[1]=a,t[2]=u,t[3]=0,t[4]=n,t[5]=i,t[6]=c,t[7]=0,t[8]=o,t[9]=s,t[10]=l,t[11]=0,t[12]=E,t[13]=m,t[14]=p,t[15]=1,t},l.IDENTITY=i(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=i(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,a(l.prototype,{length:{get:function(){return l.packedLength}}}),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,o,a,i,s){"use strict";function u(e,t,n,o){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(o,0)}o(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(e,t,n){return n=r(n,0),t[n++]=e.west,t[n++]=e.south,t[n++]=e.east,t[n]=e.north,t},u.unpack=function(e,t,o){return t=r(t,0),n(o)||(o=new u),o.west=e[t++],o.south=e[t++],o.east=e[t++],o.north=e[t],o},u.computeWidth=function(e){var t=e.east,r=e.west;return t<r&&(t+=s.TWO_PI),t-r},u.computeHeight=function(e){return e.north-e.south},u.fromDegrees=function(e,t,o,a,i){return e=s.toRadians(r(e,0)),t=s.toRadians(r(t,0)),o=s.toRadians(r(o,0)),a=s.toRadians(r(a,0)),n(i)?(i.west=e,i.south=t,i.east=o,i.north=a,i):new u(e,t,o,a)},u.fromRadians=function(e,t,o,a,i){return n(i)?(i.west=r(e,0),i.south=r(t,0),i.east=r(o,0),i.north=r(a,0),i):new u(e,t,o,a)},u.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,i=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=0,d=e.length;f<d;f++){var h=e[f];r=Math.min(r,h.longitude),o=Math.max(o,h.longitude),c=Math.min(c,h.latitude),l=Math.max(l,h.latitude);var E=h.longitude>=0?h.longitude:h.longitude+s.TWO_PI;a=Math.min(a,E),i=Math.max(i,E)}return o-r>i-a&&(r=a,o=i,o>s.PI&&(o-=s.TWO_PI),r>s.PI&&(r-=s.TWO_PI)),n(t)?(t.west=r,t.south=c,t.east=o,t.north=l,t):new u(r,c,o,l)},u.fromCartesianArray=function(e,t,o){t=r(t,a.WGS84);for(var i=Number.MAX_VALUE,c=-Number.MAX_VALUE,l=Number.MAX_VALUE,f=-Number.MAX_VALUE,d=Number.MAX_VALUE,h=-Number.MAX_VALUE,E=0,m=e.length;E<m;E++){var p=t.cartesianToCartographic(e[E]);i=Math.min(i,p.longitude),c=Math.max(c,p.longitude),d=Math.min(d,p.latitude),h=Math.max(h,p.latitude);var y=p.longitude>=0?p.longitude:p.longitude+s.TWO_PI;l=Math.min(l,y),f=Math.max(f,y)}return c-i>f-l&&(i=l,c=f,c>s.PI&&(c-=s.TWO_PI),i>s.PI&&(i-=s.TWO_PI)),n(o)?(o.west=i,o.south=d,o.east=c,o.north=h,o):new u(i,d,c,h)},u.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new u(e.west,e.south,e.east,e.north)},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.west-t.west)<=r&&Math.abs(e.south-t.south)<=r&&Math.abs(e.east-t.east)<=r&&Math.abs(e.north-t.north)<=r},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.validate=function(e){},u.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},u.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},u.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},u.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},u.center=function(t,r){var o=t.east,a=t.west;o<a&&(o+=s.TWO_PI);var i=s.negativePiToPi(.5*(a+o)),u=.5*(t.south+t.north);return n(r)?(r.longitude=i,r.latitude=u,r.height=0,r):new e(i,u)},u.intersection=function(e,t,r){var o=e.east,a=e.west,i=t.east,c=t.west;o<a&&i>0?o+=s.TWO_PI:i<c&&o>0&&(i+=s.TWO_PI),o<a&&c<0?c+=s.TWO_PI:i<c&&a<0&&(a+=s.TWO_PI);var l=s.negativePiToPi(Math.max(a,c)),f=s.negativePiToPi(Math.min(o,i));if(!((e.west<e.east||t.west<t.east)&&f<=l)){var d=Math.max(e.south,t.south),h=Math.min(e.north,t.north);if(!(d>=h))return n(r)?(r.west=l,r.south=d,r.east=f,r.north=h,r):new u(l,d,f,h)}},u.simpleIntersection=function(e,t,r){var o=Math.max(e.west,t.west),a=Math.max(e.south,t.south),i=Math.min(e.east,t.east),s=Math.min(e.north,t.north);if(!(a>=s||o>=i))return n(r)?(r.west=o,r.south=a,r.east=i,r.north=s,r):new u(o,a,i,s)},u.union=function(e,t,r){n(r)||(r=new u);var o=e.east,a=e.west,i=t.east,c=t.west;o<a&&i>0?o+=s.TWO_PI:i<c&&o>0&&(i+=s.TWO_PI),o<a&&c<0?c+=s.TWO_PI:i<c&&a<0&&(a+=s.TWO_PI);var l=s.convertLongitudeRange(Math.min(a,c)),f=s.convertLongitudeRange(Math.max(o,i));return r.west=l,r.south=Math.min(e.south,t.south),r.east=f,r.north=Math.max(e.north,t.north),r},u.expand=function(e,t,r){return n(r)||(r=new u),r.west=Math.min(e.west,t.longitude),r.south=Math.min(e.south,t.latitude),r.east=Math.max(e.east,t.longitude),r.north=Math.max(e.north,t.latitude),r},u.contains=function(e,t){var r=t.longitude,n=t.latitude,o=e.west,a=e.east;return a<o&&(a+=s.TWO_PI,r<0&&(r+=s.TWO_PI)),(r>o||s.equalsEpsilon(r,o,s.EPSILON14))&&(r<a||s.equalsEpsilon(r,a,s.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return u.subsample=function(e,t,o,i){t=r(t,a.WGS84),o=r(o,0),n(i)||(i=[]);var l=0,f=e.north,d=e.south,h=e.east,E=e.west,m=c;m.height=o,m.longitude=E,m.latitude=f,i[l]=t.cartographicToCartesian(m,i[l]),l++,m.longitude=h,i[l]=t.cartographicToCartesian(m,i[l]),l++,m.latitude=d,i[l]=t.cartographicToCartesian(m,i[l]),l++,m.longitude=E,i[l]=t.cartographicToCartesian(m,i[l]),l++,m.latitude=f<0?f:d>0?d:0;for(var p=1;p<8;++p)m.longitude=-Math.PI+p*s.PI_OVER_TWO,u.contains(e,m)&&(i[l]=t.cartographicToCartesian(m,i[l]),l++);return 0===m.latitude&&(m.longitude=E,i[l]=t.cartographicToCartesian(m,i[l]),l++,m.longitude=h,i[l]=t.cartographicToCartesian(m,i[l]),l++),i.length=l,i},u.MAX_VALUE=i(new u(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,o,a,i,s,u,c,l,f,d){"use strict";function h(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var E=new e,m=new e,p=new e,y=new e,_=new e,T=new e,R=new e,A=new e,S=new e,C=new e,I=new e,g=new e,O=4/3*c.PI;h.fromPoints=function(t,r){if(o(r)||(r=new h),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,a=e.clone(t[0],R),i=e.clone(a,E),s=e.clone(a,m),u=e.clone(a,p),c=e.clone(a,y),l=e.clone(a,_),f=e.clone(a,T),d=t.length;for(n=1;n<d;n++){e.clone(t[n],a);var O=a.x,N=a.y,v=a.z;O<i.x&&e.clone(a,i),O>c.x&&e.clone(a,c),N<s.y&&e.clone(a,s),N>l.y&&e.clone(a,l),v<u.z&&e.clone(a,u),v>f.z&&e.clone(a,f)}var w=e.magnitudeSquared(e.subtract(c,i,A)),M=e.magnitudeSquared(e.subtract(l,s,A)),F=e.magnitudeSquared(e.subtract(f,u,A)),x=i,D=c,U=w;M>U&&(U=M,x=s,D=l),F>U&&(U=F,x=u,D=f);var P=S;P.x=.5*(x.x+D.x),P.y=.5*(x.y+D.y),P.z=.5*(x.z+D.z);var L=e.magnitudeSquared(e.subtract(D,P,A)),b=Math.sqrt(L),B=C;B.x=i.x,B.y=s.y,B.z=u.z;var z=I;z.x=c.x,z.y=l.y,z.z=f.z;var G=e.multiplyByScalar(e.add(B,z,A),.5,g),q=0;for(n=0;n<d;n++){e.clone(t[n],a);var V=e.magnitude(e.subtract(a,G,A));V>q&&(q=V);var W=e.magnitudeSquared(e.subtract(a,P,A));if(W>L){var k=Math.sqrt(W);b=.5*(b+k),L=b*b;var H=k-b;P.x=(b*P.x+H*a.x)/k,P.y=(b*P.y+H*a.y)/k,P.z=(b*P.z+H*a.z)/k}}return b<q?(e.clone(P,r.center),r.radius=b):(e.clone(G,r.center),r.radius=q),r};var N=new i,v=new e,w=new e,M=new t,F=new t;h.fromRectangle2D=function(e,t,r){return h.fromRectangleWithHeights2D(e,t,0,0,r)},h.fromRectangleWithHeights2D=function(t,r,a,i,s){if(o(s)||(s=new h),!o(t))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;r=n(r,N),d.southwest(t,M),M.height=a,d.northeast(t,F),F.height=i;var u=r.project(M,v),c=r.project(F,w),l=c.x-u.x,f=c.y-u.y,E=c.z-u.z;s.radius=.5*Math.sqrt(l*l+f*f+E*E);var m=s.center;return m.x=u.x+.5*l,m.y=u.y+.5*f,m.z=u.z+.5*E,s};var x=[];h.fromRectangle3D=function(t,r,i,s){if(r=n(r,a.WGS84),i=n(i,0),o(s)||(s=new h),!o(t))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;var u=d.subsample(t,r,i,x);return h.fromPoints(u,s)},h.fromVertices=function(t,r,a,i){if(o(i)||(i=new h),!o(t)||0===t.length)return i.center=e.clone(e.ZERO,i.center),i.radius=0,i;r=n(r,e.ZERO),a=n(a,3);var s=R;s.x=t[0]+r.x,s.y=t[1]+r.y,s.z=t[2]+r.z;var u,c=e.clone(s,E),l=e.clone(s,m),f=e.clone(s,p),d=e.clone(s,y),O=e.clone(s,_),N=e.clone(s,T),v=t.length;for(u=0;u<v;u+=a){var w=t[u]+r.x,M=t[u+1]+r.y,F=t[u+2]+r.z;s.x=w,s.y=M,s.z=F,w<c.x&&e.clone(s,c),w>d.x&&e.clone(s,d),M<l.y&&e.clone(s,l),M>O.y&&e.clone(s,O),F<f.z&&e.clone(s,f),F>N.z&&e.clone(s,N)}var x=e.magnitudeSquared(e.subtract(d,c,A)),D=e.magnitudeSquared(e.subtract(O,l,A)),U=e.magnitudeSquared(e.subtract(N,f,A)),P=c,L=d,b=x;D>b&&(b=D,P=l,L=O),U>b&&(b=U,P=f,L=N);var B=S;B.x=.5*(P.x+L.x),B.y=.5*(P.y+L.y),B.z=.5*(P.z+L.z);var z=e.magnitudeSquared(e.subtract(L,B,A)),G=Math.sqrt(z),q=C;q.x=c.x,q.y=l.y,q.z=f.z;var V=I;V.x=d.x,V.y=O.y,V.z=N.z;var W=e.multiplyByScalar(e.add(q,V,A),.5,g),k=0;for(u=0;u<v;u+=a){s.x=t[u]+r.x,s.y=t[u+1]+r.y,s.z=t[u+2]+r.z;var H=e.magnitude(e.subtract(s,W,A));H>k&&(k=H);var X=e.magnitudeSquared(e.subtract(s,B,A));if(X>z){var Y=Math.sqrt(X);G=.5*(G+Y),z=G*G;var j=Y-G;B.x=(G*B.x+j*s.x)/Y,B.y=(G*B.y+j*s.y)/Y,B.z=(G*B.z+j*s.z)/Y}}return G<k?(e.clone(B,i.center),i.radius=G):(e.clone(W,i.center),i.radius=k),i},h.fromEncodedCartesianVertices=function(t,r,n){if(o(n)||(n=new h),!o(t)||!o(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=R;a.x=t[0]+r[0],a.y=t[1]+r[1],a.z=t[2]+r[2];var i,s=e.clone(a,E),u=e.clone(a,m),c=e.clone(a,p),l=e.clone(a,y),f=e.clone(a,_),d=e.clone(a,T),O=t.length;for(i=0;i<O;i+=3){var N=t[i]+r[i],v=t[i+1]+r[i+1],w=t[i+2]+r[i+2];a.x=N,a.y=v,a.z=w,N<s.x&&e.clone(a,s),N>l.x&&e.clone(a,l),v<u.y&&e.clone(a,u),v>f.y&&e.clone(a,f),w<c.z&&e.clone(a,c),w>d.z&&e.clone(a,d)}var M=e.magnitudeSquared(e.subtract(l,s,A)),F=e.magnitudeSquared(e.subtract(f,u,A)),x=e.magnitudeSquared(e.subtract(d,c,A)),D=s,U=l,P=M;F>P&&(P=F,D=u,U=f),x>P&&(P=x,D=c,U=d);var L=S;L.x=.5*(D.x+U.x),L.y=.5*(D.y+U.y),L.z=.5*(D.z+U.z);var b=e.magnitudeSquared(e.subtract(U,L,A)),B=Math.sqrt(b),z=C;z.x=s.x,z.y=u.y,z.z=c.z;var G=I;G.x=l.x,G.y=f.y,G.z=d.z;var q=e.multiplyByScalar(e.add(z,G,A),.5,g),V=0;for(i=0;i<O;i+=3){a.x=t[i]+r[i],a.y=t[i+1]+r[i+1],a.z=t[i+2]+r[i+2];var W=e.magnitude(e.subtract(a,q,A));W>V&&(V=W);var k=e.magnitudeSquared(e.subtract(a,L,A));if(k>b){var H=Math.sqrt(k);B=.5*(B+H),b=B*B;var X=H-B;L.x=(B*L.x+X*a.x)/H,L.y=(B*L.y+X*a.y)/H,L.z=(B*L.z+X*a.z)/H}}return B<V?(e.clone(L,n.center),n.radius=B):(e.clone(q,n.center),n.radius=V),n},h.fromCornerPoints=function(t,r,n){o(n)||(n=new h);var a=n.center;return e.add(t,r,a),e.multiplyByScalar(a,.5,a),n.radius=e.distance(a,r),n},h.fromEllipsoid=function(t,r){return o(r)||(r=new h),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var D=new e;h.fromBoundingSpheres=function(t,r){if(o(r)||(r=new h),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return h.clone(t[0],r);if(2===n)return h.union(t[0],t[1],r);var a,i=[];for(a=0;a<n;a++)i.push(t[a].center);r=h.fromPoints(i,r);var s=r.center,u=r.radius;for(a=0;a<n;a++){var c=t[a];u=Math.max(u,e.distance(s,c.center,D)+c.radius)}return r.radius=u,r};var U=new e,P=new e,L=new e;h.fromOrientedBoundingBox=function(t,r){o(r)||(r=new h);var n=t.halfAxes,a=l.getColumn(n,0,U),i=l.getColumn(n,1,P),s=l.getColumn(n,2,L);return e.add(a,i,a),e.add(a,s,a),r.center=e.clone(t.center,r.center),r.radius=e.magnitude(a),r},h.clone=function(t,r){if(o(t))return o(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new h(t.center,t.radius)},h.packedLength=4,h.pack=function(e,t,r){r=n(r,0);var o=e.center;return t[r++]=o.x,t[r++]=o.y,t[r++]=o.z,t[r]=e.radius,t},h.unpack=function(e,t,r){t=n(t,0),o(r)||(r=new h);var a=r.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],r.radius=e[t],r};var b=new e,B=new e;h.union=function(t,r,n){o(n)||(n=new h);var a=t.center,i=t.radius,s=r.center,u=r.radius,c=e.subtract(s,a,b),l=e.magnitude(c);if(i>=l+u)return t.clone(n),n;if(u>=l+i)return r.clone(n),n;var f=.5*(i+l+u),d=e.multiplyByScalar(c,(-i+f)/l,B);return e.add(d,a,d),e.clone(d,n.center),n.radius=f,n};var z=new e;h.expand=function(t,r,n){n=h.clone(t,n);var o=e.magnitude(e.subtract(r,n.center,z));return o>n.radius&&(n.radius=o),n},h.intersectPlane=function(t,r){var n=t.center,o=t.radius,a=r.normal,i=e.dot(a,n)+r.distance;return i<-o?s.OUTSIDE:i<o?s.INTERSECTING:s.INSIDE},h.transform=function(e,t,r){return o(r)||(r=new h),r.center=f.multiplyByPoint(t,e.center,r.center),r.radius=f.getMaximumScale(t)*e.radius,r};var G=new e;h.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,G);return e.magnitudeSquared(n)-t.radius*t.radius},h.transformWithoutScale=function(e,t,r){return o(r)||(r=new h),r.center=f.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var q=new e;h.computePlaneDistances=function(t,r,n,a){o(a)||(a=new u);var i=e.subtract(t.center,r,q),s=e.dot(n,i);return a.start=s-t.radius,a.stop=s+t.radius,a};for(var V=new e,W=new e,k=new e,H=new e,X=new e,Y=new t,j=new Array(8),K=0;K<8;++K)j[K]=new e;var Z=new i;return h.projectTo2D=function(t,r,o){r=n(r,Z);var a=r.ellipsoid,i=t.center,s=t.radius,u=a.geodeticSurfaceNormal(i,V),c=e.cross(e.UNIT_Z,u,W);e.normalize(c,c);var l=e.cross(u,c,k);e.normalize(l,l),e.multiplyByScalar(u,s,u),e.multiplyByScalar(l,s,l),e.multiplyByScalar(c,s,c);var f=e.negate(l,X),d=e.negate(c,H),E=j,m=E[0];e.add(u,l,m),e.add(m,c,m),m=E[1],e.add(u,l,m),e.add(m,d,m),m=E[2],e.add(u,f,m),e.add(m,d,m),m=E[3],e.add(u,f,m),e.add(m,c,m),e.negate(u,u),m=E[4],e.add(u,l,m),e.add(m,c,m),m=E[5],e.add(u,l,m),e.add(m,d,m),m=E[6],e.add(u,f,m),e.add(m,d,m),m=E[7],e.add(u,f,m),e.add(m,c,m);for(var p=E.length,y=0;y<p;++y){var _=E[y];e.add(i,_,_);var T=a.cartesianToCartographic(_,Y);r.project(T,_)}o=h.fromPoints(E,o),i=o.center;var R=i.x,A=i.y,S=i.z;return i.x=S,i.y=R,i.z=A,o},h.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},h.equals=function(t,r){return t===r||o(t)&&o(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,r){return h.computePlaneDistances(this,e,t,r)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.volume=function(){var e=this.radius;return O*e*e*e},h}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return t(o,{element:{get:function(){if(o.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(o.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(o.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(o.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(o.supportsFullscreen())return null!==o.element}}}),o.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var o,a=["webkit","moz","o","ms","khtml"],i=0,s=a.length;i<s;++i){var u=a[i];o=u+"RequestFullscreen","function"==typeof t[o]?(n.requestFullscreen=o,r=!0):(o=u+"RequestFullScreen","function"==typeof t[o]&&(n.requestFullscreen=o,r=!0)),o=u+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=u+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=u+"FullscreenEnabled",void 0!==document[o]?n.fullscreenEnabled=o:(o=u+"FullScreenEnabled",void 0!==document[o]&&(n.fullscreenEnabled=o)),o=u+"FullscreenElement",
void 0!==document[o]?n.fullscreenElement=o:(o=u+"FullScreenElement",void 0!==document[o]&&(n.fullscreenElement=o)),o=u+"fullscreenchange",void 0!==document["on"+o]&&("ms"===u&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=u+"fullscreenerror",void 0!==document["on"+o]&&("ms"===u&&(o="MSFullscreenError"),n.fullscreenerror=o)}return r},o.requestFullscreen=function(e,t){o.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function o(){if(!t(S)&&(S=!1,!d())){var e=/ Chrome\/([\.0-9]+)/.exec(A.userAgent);null!==e&&(S=!0,C=n(e[1]))}return S}function a(){return o()&&C}function i(){if(!t(I)&&(I=!1,!o()&&!d()&&/ Safari\/[\.0-9]+/.test(A.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(A.userAgent);null!==e&&(I=!0,g=n(e[1]))}return I}function s(){return i()&&g}function u(){if(!t(O)){O=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(A.userAgent);null!==e&&(O=!0,N=n(e[1]),N.isNightly=!!e[2])}return O}function c(){return u()&&N}function l(){if(!t(v)){v=!1;var e;"Microsoft Internet Explorer"===A.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(A.userAgent))&&(v=!0,w=n(e[1])):"Netscape"===A.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(A.userAgent))&&(v=!0,w=n(e[1]))}return v}function f(){return l()&&w}function d(){if(!t(M)){M=!1;var e=/ Edge\/([\.0-9]+)/.exec(A.userAgent);null!==e&&(M=!0,F=n(e[1]))}return M}function h(){return d()&&F}function E(){if(!t(x)){x=!1;var e=/Firefox\/([\.0-9]+)/.exec(A.userAgent);null!==e&&(x=!0,D=n(e[1]))}return x}function m(){return t(U)||(U=/Windows/i.test(A.appVersion)),U}function p(){return E()&&D}function y(){return t(P)||(P="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),P}function _(){return t(L)||(L="undefined"!=typeof PointerEvent&&(!t(A.pointerEnabled)||A.pointerEnabled)),L}function T(){if(!t(B)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;B=t(r)&&""!==r,B&&(b=r)}return B}function R(){return T()?b:void 0}var A;A="undefined"!=typeof navigator?navigator:{};var S,C,I,g,O,N,v,w,M,F,x,D,U,P,L,b,B,z=[];"undefined"!=typeof ArrayBuffer&&(z.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&z.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&z.push(CanvasPixelArray));var G={isChrome:o,chromeVersion:a,isSafari:i,safariVersion:s,isWebkit:u,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isEdge:d,edgeVersion:h,isFirefox:E,firefoxVersion:p,isWindows:m,isNodeJs:y,hardwareConcurrency:e(A.hardwareConcurrency,3),supportsPointerEvents:_,supportsImageRenderingPixelated:T,imageRenderingValue:R,typedArrayTypes:z};return G.supportsFullscreen=function(){return r.supportsFullscreen()},G.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},G.supportsWebWorkers=function(){return"undefined"!=typeof Worker},G.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!G.isEdge()},G}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,o,a){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE};return i.getSizeInBytes=function(e){switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.INT:return Int32Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Int32Array?i.INT:e instanceof Uint32Array?i.UNSIGNED_INT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return t(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.INT||e===i.UNSIGNED_INT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,t){switch(e){case i.BYTE:return new Int8Array(t);case i.UNSIGNED_BYTE:return new Uint8Array(t);case i.SHORT:return new Int16Array(t);case i.UNSIGNED_SHORT:return new Uint16Array(t);case i.INT:return new Int32Array(t);case i.UNSIGNED_INT:return new Uint32Array(t);case i.FLOAT:return new Float32Array(t);case i.DOUBLE:return new Float64Array(t)}},i.createArrayBufferView=function(t,r,n,o){switch(n=e(n,0),o=e(o,(r.byteLength-n)/i.getSizeInBytes(t)),t){case i.BYTE:return new Int8Array(r,n,o);case i.UNSIGNED_BYTE:return new Uint8Array(r,n,o);case i.SHORT:return new Int16Array(r,n,o);case i.UNSIGNED_SHORT:return new Uint16Array(r,n,o);case i.INT:return new Int32Array(r,n,o);case i.UNSIGNED_INT:return new Uint32Array(r,n,o);case i.FLOAT:return new Float32Array(r,n,o);case i.DOUBLE:return new Float64Array(r,n,o)}},i.fromName=function(e){switch(e){case"BYTE":return i.BYTE;case"UNSIGNED_BYTE":return i.UNSIGNED_BYTE;case"SHORT":return i.SHORT;case"UNSIGNED_SHORT":return i.UNSIGNED_SHORT;case"INT":return i.INT;case"UNSIGNED_INT":return i.UNSIGNED_INT;case"FLOAT":return i.FLOAT;case"DOUBLE":return i.DOUBLE}},o(i)}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,a){"use strict";function i(e,r){this.x=t(e,0),this.y=t(r,0)}i.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new i(e,t)},i.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new i(e.x,e.y)},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n]=e.y,r},i.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new i),o.x=e[n++],o.y=e[n],o},i.packArray=function(e,t){var n=e.length;r(t)?t.length=2*n:t=new Array(2*n);for(var o=0;o<n;++o)i.pack(e[o],t,2*o);return t},i.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/2:t=new Array(n/2);for(var o=0;o<n;o+=2){var a=o/2;t[a]=i.unpack(e,o,t[a])}return t},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var s=new i;i.distance=function(e,t){return i.subtract(e,t,s),i.magnitude(s)},i.distanceSquared=function(e,t){return i.subtract(e,t,s),i.magnitudeSquared(s)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},i.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var c=new i,l=new i;i.angleBetween=function(e,t){return i.normalize(e,c),i.normalize(t,l),a.acosClamped(i.dot(c,l))};var f=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,f);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},i.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,o)&&a.equalsEpsilon(e.y,t.y,n,o)},i.ZERO=o(new i(0,0)),i.UNIT_X=o(new i(1,0)),i.UNIT_Y=o(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";return e({NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3})}),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],function(e,t,r,n,o,a){"use strict";function i(e,t,n,o){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(o,0)}i.packedLength=4,i.pack=function(e,t,n){return n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t},i.unpack=function(e,t,o){return t=r(t,0),n(o)||(o=new i),o[0]=e[t++],o[1]=e[t++],o[2]=e[t++],o[3]=e[t++],o},i.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new i(e[0],e[2],e[1],e[3])},i.fromArray=function(e,t,o){return t=r(t,0),n(o)||(o=new i),o[0]=e[t],o[1]=e[t+1],o[2]=e[t+2],o[3]=e[t+3],o},i.fromColumnMajorArray=function(e,t){return i.clone(e,t)},i.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new i(e[0],e[1],e[2],e[3])},i.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new i(e.x,0,0,e.y)},i.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new i(e,0,0,e)},i.fromRotation=function(e,t){var r=Math.cos(e),o=Math.sin(e);return n(t)?(t[0]=r,t[1]=o,t[2]=-o,t[3]=r,t):new i(r,-o,o,r)},i.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},i.getElementIndex=function(e,t){return 2*e+t},i.getColumn=function(e,t,r){var n=2*t,o=e[n],a=e[n+1];return r.x=o,r.y=a,r},i.setColumn=function(e,t,r,n){n=i.clone(e,n);var o=2*t;return n[o]=r.x,n[o+1]=r.y,n},i.getRow=function(e,t,r){var n=e[t],o=e[t+2];return r.x=n,r.y=o,r},i.setRow=function(e,t,r,n){return n=i.clone(e,n),n[t]=r.x,n[t+2]=r.y,n};var s=new e;i.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],s)),r.y=e.magnitude(e.fromElements(t[2],t[3],s)),r};var u=new e;return i.getMaximumScale=function(t){return i.getScale(t,u),e.maximumComponent(u)},i.multiply=function(e,t,r){var n=e[0]*t[0]+e[2]*t[1],o=e[0]*t[2]+e[2]*t[3],a=e[1]*t[0]+e[3]*t[1],i=e[1]*t[2]+e[3]*t[3];return r[0]=n,r[1]=a,r[2]=o,r[3]=i,r},i.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r},i.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r},i.multiplyByVector=function(e,t,r){var n=e[0]*t.x+e[2]*t.y,o=e[1]*t.x+e[3]*t.y;return r.x=n,r.y=o,r},i.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r},i.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.y,r[3]=e[3]*t.y,r},i.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},i.transpose=function(e,t){var r=e[0],n=e[2],o=e[1],a=e[3];return t[0]=r,t[1]=n,t[2]=o,t[3]=a,t},i.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},i.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},i.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},i.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r},i.IDENTITY=a(new i(1,0,0,1)),i.ZERO=a(new i(0,0,0,0)),i.COLUMN0ROW0=0,i.COLUMN0ROW1=1,i.COLUMN1ROW0=2,i.COLUMN1ROW1=3,o(i.prototype,{length:{get:function(){return i.packedLength}}}),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},i}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,o,a,i,s){"use strict";function u(e,t,n,o){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(o,0)}var c=new e;u.fromAxisAngle=function(t,r,o){var a=r/2,i=Math.sin(a);c=e.normalize(t,c);var s=c.x*i,l=c.y*i,f=c.z*i,d=Math.cos(a);return n(o)?(o.x=s,o.y=l,o.z=f,o.w=d,o):new u(s,l,f,d)};var l=[1,2,0],f=new Array(3);u.fromRotationMatrix=function(e,t){var r,o,a,i,c,d=e[s.COLUMN0ROW0],h=e[s.COLUMN1ROW1],E=e[s.COLUMN2ROW2],m=d+h+E;if(m>0)r=Math.sqrt(m+1),c=.5*r,r=.5/r,o=(e[s.COLUMN1ROW2]-e[s.COLUMN2ROW1])*r,a=(e[s.COLUMN2ROW0]-e[s.COLUMN0ROW2])*r,i=(e[s.COLUMN0ROW1]-e[s.COLUMN1ROW0])*r;else{var p=l,y=0;h>d&&(y=1),E>d&&E>h&&(y=2);var _=p[y],T=p[_];r=Math.sqrt(e[s.getElementIndex(y,y)]-e[s.getElementIndex(_,_)]-e[s.getElementIndex(T,T)]+1);var R=f;R[y]=.5*r,r=.5/r,c=(e[s.getElementIndex(T,_)]-e[s.getElementIndex(_,T)])*r,R[_]=(e[s.getElementIndex(_,y)]+e[s.getElementIndex(y,_)])*r,R[T]=(e[s.getElementIndex(T,y)]+e[s.getElementIndex(y,T)])*r,o=-R[0],a=-R[1],i=-R[2]}return n(t)?(t.x=o,t.y=a,t.z=i,t.w=c,t):new u(o,a,i,c)};var d=new u,h=new u,E=new u,m=new u;u.fromHeadingPitchRoll=function(t,r){return m=u.fromAxisAngle(e.UNIT_X,t.roll,d),E=u.fromAxisAngle(e.UNIT_Y,-t.pitch,r),r=u.multiply(E,m,E),h=u.fromAxisAngle(e.UNIT_Z,-t.heading,d),u.multiply(h,r,r)};var p=new e,y=new e,_=new u,T=new u,R=new u;u.packedLength=4,u.pack=function(e,t,n){return n=r(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.z,t[n]=e.w,t},u.unpack=function(e,t,o){return t=r(t,0),n(o)||(o=new u),o.x=e[t],o.y=e[t+1],o.z=e[t+2],o.w=e[t+3],o},u.packedInterpolationLength=3,u.convertPackedArrayForInterpolation=function(e,t,r,n){u.unpack(e,4*r,R),u.conjugate(R,R);for(var o=0,a=r-t+1;o<a;o++){var i=3*o;u.unpack(e,4*(t+o),_),u.multiply(_,R,_),_.w<0&&u.negate(_,_),u.computeAxis(_,p);var s=u.computeAngle(_);n[i]=p.x*s,n[i+1]=p.y*s,n[i+2]=p.z*s}},u.unpackInterpolationResult=function(t,r,o,a,i){n(i)||(i=new u),e.fromArray(t,0,y);var s=e.magnitude(y);return u.unpack(r,4*a,T),0===s?u.clone(u.IDENTITY,_):u.fromAxisAngle(y,s,_),u.multiply(_,T,i)},u.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new u(e.x,e.y,e.z,e.w)},u.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},u.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},u.magnitude=function(e){return Math.sqrt(u.magnitudeSquared(e))},u.normalize=function(e,t){var r=1/u.magnitude(e),n=e.x*r,o=e.y*r,a=e.z*r,i=e.w*r;return t.x=n,t.y=o,t.z=a,t.w=i,t},u.inverse=function(e,t){var r=u.magnitudeSquared(e);return t=u.conjugate(e,t),u.multiplyByScalar(t,1/r,t)},u.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},u.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},u.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},u.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},u.multiply=function(e,t,r){var n=e.x,o=e.y,a=e.z,i=e.w,s=t.x,u=t.y,c=t.z,l=t.w,f=i*s+n*l+o*c-a*u,d=i*u-n*c+o*l+a*s,h=i*c+n*u-o*s+a*l,E=i*l-n*s-o*u-a*c;return r.x=f,r.y=d,r.z=h,r.w=E,r},u.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},u.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},u.computeAxis=function(e,t){var r=e.w;if(Math.abs(r-1)<i.EPSILON6)return t.x=t.y=t.z=0,t;var n=1/Math.sqrt(1-r*r);return t.x=e.x*n,t.y=e.y*n,t.z=e.z*n,t},u.computeAngle=function(e){return Math.abs(e.w-1)<i.EPSILON6?0:2*Math.acos(e.w)};var A=new u;u.lerp=function(e,t,r,n){return A=u.multiplyByScalar(t,r,A),n=u.multiplyByScalar(e,1-r,n),u.add(A,n,n)};var S=new u,C=new u,I=new u;u.slerp=function(e,t,r,n){var o=u.dot(e,t),a=t;if(o<0&&(o=-o,a=S=u.negate(t,S)),1-o<i.EPSILON6)return u.lerp(e,a,r,n);var s=Math.acos(o);return C=u.multiplyByScalar(e,Math.sin((1-r)*s),C),I=u.multiplyByScalar(a,Math.sin(r*s),I),n=u.add(C,I,n),u.multiplyByScalar(n,1/Math.sin(s),n)},u.log=function(t,r){var n=i.acosClamped(t.w),o=0;return 0!==n&&(o=n/Math.sin(n)),e.multiplyByScalar(t,o,r)},u.exp=function(t,r){var n=e.magnitude(t),o=0;return 0!==n&&(o=Math.sin(n)/n),r.x=t.x*o,r.y=t.y*o,r.z=t.z*o,r.w=Math.cos(n),r};var g=new e,O=new e,N=new u,v=new u;u.computeInnerQuadrangle=function(t,r,n,o){var a=u.conjugate(r,N);u.multiply(a,n,v);var i=u.log(v,g);u.multiply(a,t,v);var s=u.log(v,O);return e.add(i,s,i),e.multiplyByScalar(i,.25,i),e.negate(i,i),u.exp(i,N),u.multiply(r,N,o)},u.squad=function(e,t,r,n,o,a){var i=u.slerp(e,t,o,N),s=u.slerp(r,n,o,v);return u.slerp(i,s,2*o*(1-o),a)};for(var w=new u,M=1.9011074535173003,F=o.supportsTypedArrays()?new Float32Array(8):[],x=o.supportsTypedArrays()?new Float32Array(8):[],D=o.supportsTypedArrays()?new Float32Array(8):[],U=o.supportsTypedArrays()?new Float32Array(8):[],P=0;P<7;++P){var L=P+1,b=2*L+1;F[P]=1/(L*b),x[P]=L/b}return F[7]=M/136,x[7]=8*M/17,u.fastSlerp=function(e,t,r,n){var o,a=u.dot(e,t);a>=0?o=1:(o=-1,a=-a);for(var i=a-1,s=1-r,c=r*r,l=s*s,f=7;f>=0;--f)D[f]=(F[f]*c-x[f])*i,U[f]=(F[f]*l-x[f])*i;var d=o*r*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),h=s*(1+U[0]*(1+U[1]*(1+U[2]*(1+U[3]*(1+U[4]*(1+U[5]*(1+U[6]*(1+U[7])))))))),E=u.multiplyByScalar(e,h,w);return u.multiplyByScalar(t,d,n),u.add(E,n,n)},u.fastSquad=function(e,t,r,n,o,a){var i=u.fastSlerp(e,t,o,N),s=u.fastSlerp(r,n,o,v);return u.fastSlerp(i,s,2*o*(1-o),a)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.x-t.x)<=r&&Math.abs(e.y-t.y)<=r&&Math.abs(e.z-t.z)<=r&&Math.abs(e.w-t.w)<=r},
u.ZERO=a(new u(0,0,0,0)),u.IDENTITY=a(new u(0,0,0,1)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},u}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,o){return t(e).then(r,n,o)}function t(e){var t,r;return e instanceof n?t=e:s(e)?(r=i(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=o(e),t}function r(t){return e(t,a)}function n(e){this.then=e}function o(e){return new n(function(r){try{return t(r?r(e):e)}catch(e){return a(e)}})}function a(e){return new n(function(r,n){try{return n?t(n(e)):a(e)}catch(e){return a(e)}})}function i(){function e(e,t,r){return d(e,t,r)}function r(e){return E(e)}function o(e){return E(a(e))}function s(e){return h(e)}var u,c,l,f,d,h,E;return c=new n(e),u={then:e,resolve:r,reject:o,progress:s,promise:c,resolver:{resolve:r,reject:o,progress:s}},l=[],f=[],d=function(e,t,r){var n,o;return n=i(),o="function"==typeof r?function(e){try{n.progress(r(e))}catch(e){n.progress(e)}}:function(e){n.progress(e)},l.push(function(r){r.then(e,t).then(n.resolve,n.reject,o)}),f.push(o),n.promise},h=function(e){return m(f,e),e},E=function(e){return e=t(e),d=e.then,E=t,h=y,m(l,e),f=l=A,e},u}function s(e){return e&&"function"==typeof e.then}function u(t,r,n,o,a){return p(2,arguments),e(t,function(t){function s(e){m(e)}function u(e){E(e)}var c,l,f,d,h,E,m,p,_,T;if(_=t.length>>>0,c=Math.max(0,Math.min(r,_)),f=[],l=_-c+1,d=[],h=i(),c)for(p=h.progress,m=function(e){d.push(e),--l||(E=m=y,h.reject(d))},E=function(e){f.push(e),--c||(E=m=y,h.resolve(f))},T=0;T<_;++T)T in t&&e(t[T],u,s,p);else h.resolve(f);return h.then(n,o,a)})}function c(e,t,r,n){function o(e){return t?t(e[0]):e[0]}return u(e,1,o,r,n)}function l(e,t,r,n){return p(1,arguments),d(e,_).then(t,r,n)}function f(){return d(arguments,_)}function d(t,r){return e(t,function(t){var n,o,a,s,u,c;if(a=o=t.length>>>0,n=[],c=i(),a)for(s=function(t,o){e(t,r).then(function(e){n[o]=e,--a||c.resolve(n)},c.reject)},u=0;u<o;u++)u in t?s(t[u],u):--a;else c.resolve(n);return c.promise})}function h(t,r){var n=R.call(arguments,1);return e(t,function(t){var o;return o=t.length,n[0]=function(t,n,a){return e(t,function(t){return e(n,function(e){return r(t,e,a,o)})})},T.apply(t,n)})}function E(t,r,n){var o=arguments.length>2;return e(t,function(e){return e=o?n:e,r.resolve(e),e},function(e){return r.reject(e),a(e)},r.progress)}function m(e,t){for(var r,n=0;r=e[n++];)r(t)}function p(e,t){for(var r,n=t.length;n>e;)if(null!=(r=t[--n])&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function y(){}function _(e){return e}var T,R,A;return e.defer=i,e.resolve=t,e.reject=r,e.join=f,e.all=l,e.map=d,e.reduce=h,e.any=c,e.some=u,e.chain=E,e.isPromise=s,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(A,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(A,t)})})}},R=[].slice,T=[].reduce||function(e){var t,r,n,o,a;if(a=0,t=Object(this),o=t.length>>>0,r=arguments,r.length<=1)for(;;){if(a in t){n=t[a++];break}if(++a>=o)throw new TypeError}else n=r[1];for(;a<o;++a)a in t&&(n=e(n,t[a],a,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./Check"],function(e){"use strict";function t(e,t,r){for(var n,o,a=0,i=e.length-1;a<=i;)if(n=~~((a+i)/2),(o=r(e[n],t))<0)a=n+1;else{if(!(o>0))return n;i=n-1}return~(i+1)}return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,n,o){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=o}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],o=function(e,t,r,n){r||(r=" ");var o=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+o:o+e},a=function(e,t,r,n,a,i){var s=n-e.length;return s>0&&(e=r||!a?o(e,n,i,r):e.slice(0,t.length)+o("",s,"0",!0)+e.slice(t.length)),e},i=function(e,t,r,n,i,s,u){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+o(c.toString(t),s||0,"0",!1),a(e,r,n,i,u)},s=function(e,t,r,n,o,i){return null!=n&&(e=e.slice(0,n)),a(e,"",t,r,o,i)},u=function(e,n,u,c,l,f,d){var h,E,m,p,y;if("%%"==e)return"%";for(var _=!1,T="",R=!1,A=!1,S=" ",C=u.length,I=0;u&&I<C;I++)switch(u.charAt(I)){case" ":T=" ";break;case"+":T="+";break;case"-":_=!0;break;case"'":S=u.charAt(I+1);break;case"0":R=!0;break;case"#":A=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,c<0&&(c=-c,_=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[r++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,y=n?t[n.slice(0,-1)]:t[r++],d){case"s":return s(String(y),_,c,f,R,S);case"c":return s(String.fromCharCode(+y),_,c,f,R);case"b":return i(y,2,A,_,c,f,R);case"o":return i(y,8,A,_,c,f,R);case"x":return i(y,16,A,_,c,f,R);case"X":return i(y,16,A,_,c,f,R).toUpperCase();case"u":return i(y,10,A,_,c,f,R);case"i":case"d":return h=+y||0,h=Math.round(h-h%1),E=h<0?"-":T,y=E+o(String(Math.abs(h)),f,"0",!1),a(y,E,_,c,R);case"e":case"E":case"f":case"F":case"g":case"G":return h=+y,E=h<0?"-":T,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],p=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],y=E+Math.abs(h)[m](f),a(y,E,_,c,R)[p]();default:return e}};return n.replace(e,u)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,n,o,a,i,s){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=o,this.second=a,this.millisecond=i,this.isLeapSecond=s}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4==0&&e%100!=0||e%400==0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";return e({SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5})}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";return e({UTC:0,TAI:1})}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,o,a,i,s,u,c){"use strict";function l(e,t){return m.compare(e.julianDate,t.julianDate)}function f(e){_.julianDate=e;var r=m.leapSeconds,n=t(r,_,l);n<0&&(n=~n),n>=r.length&&(n=r.length-1);var o=r[n].offset;if(n>0){m.secondsDifference(r[n].julianDate,e)>o&&(n--,o=r[n].offset)}m.addSeconds(e,o,e)}function d(e,r){_.julianDate=e;var n=m.leapSeconds,o=t(n,_,l);if(o<0&&(o=~o),0===o)return m.addSeconds(e,-n[0].offset,r);if(o>=n.length)return m.addSeconds(e,-n[o-1].offset,r);var a=m.secondsDifference(n[o].julianDate,e);return 0===a?m.addSeconds(e,-n[o].offset,r):a<=1?void 0:m.addSeconds(e,-n[--o].offset,r)}function h(e,t,r){var n=t/u.SECONDS_PER_DAY|0;return e+=n,t-=u.SECONDS_PER_DAY*n,t<0&&(e--,t+=u.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function E(e,t,r,n,o,a,i){var s=(t-14)/12|0,c=e+4800+s,l=(1461*c/4|0)+(367*(t-2-12*s)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;(n-=12)<0&&(n+=24);var f=a+(n*u.SECONDS_PER_HOUR+o*u.SECONDS_PER_MINUTE+i*u.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}function m(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var o=0|e;t+=(e-o)*u.SECONDS_PER_DAY,h(o,t,this),n===c.UTC&&f(this)}var p=new a,y=[31,28,31,30,31,30,31,31,30,31,30,31],_=new s,T=/^(\d{4})$/,R=/^(\d{4})-(\d{2})$/,A=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,C=/^(\d{4})-?(\d{2})-?(\d{2})$/,I=/([Z+\-])?(\d{2})?:?(\d{2})?$/,g=/^(\d{2})(\.\d+)?/.source+I.source,O=/^(\d{2}):?(\d{2})(\.\d+)?/.source+I.source,N=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+I.source;m.fromGregorianDate=function(e,t){var r=E(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(h(r[0],r[1],t),f(t),t):new m(r[0],r[1],c.UTC)},m.fromDate=function(e,t){var r=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(h(r[0],r[1],t),f(t),t):new m(r[0],r[1],c.UTC)},m.fromIso8601=function(e,t){e=e.replace(",",".");var r,o,a,s=e.split("T"),u=1,l=1,d=0,p=0,_=0,I=0,v=s[0],w=s[1];if(null!==(s=v.match(C)))r=+s[1],u=+s[2],l=+s[3];else if(null!==(s=v.match(R)))r=+s[1],u=+s[2];else if(null!==(s=v.match(T)))r=+s[1];else{var M;if(null!==(s=v.match(A)))r=+s[1],M=+s[2],a=i(r);else if(null!==(s=v.match(S))){r=+s[1];var F=+s[2],x=+s[3]||0,D=new Date(Date.UTC(r,0,4));M=7*F+x-D.getUTCDay()-3}o=new Date(Date.UTC(r,0,1)),o.setUTCDate(M),u=o.getUTCMonth()+1,l=o.getUTCDate()}a=i(r);var U;if(n(w)){s=w.match(N),null!==s?(d=+s[1],p=+s[2],_=+s[3],I=1e3*+(s[4]||0),U=5):(s=w.match(O),null!==s?(d=+s[1],p=+s[2],_=60*+(s[3]||0),U=4):null!==(s=w.match(g))&&(d=+s[1],p=60*+(s[2]||0),U=3));var P=s[U],L=+s[U+1],b=+(s[U+2]||0);switch(P){case"+":d-=L,p-=b;break;case"-":d+=L,p+=b;break;case"Z":break;default:p+=new Date(Date.UTC(r,u-1,l,d,p)).getTimezoneOffset()}}var B=60===_;for(B&&_--;p>=60;)p-=60,d++;for(;d>=24;)d-=24,l++;for(o=a&&2===u?29:y[u-1];l>o;)l-=o,u++,u>12&&(u-=12,r++),o=a&&2===u?29:y[u-1];for(;p<0;)p+=60,d--;for(;d<0;)d+=24,l--;for(;l<1;)u--,u<1&&(u+=12,r--),o=a&&2===u?29:y[u-1],l+=o;var z=E(r,u,l,d,p,_,I);return n(t)?(h(z[0],z[1],t),f(t)):t=new m(z[0],z[1],c.UTC),B&&m.addSeconds(t,1,t),t},m.now=function(e){return m.fromDate(new Date,e)};var v=new m(0,0,c.TAI);return m.toGregorianDate=function(e,t){var r=!1,o=d(e,v);n(o)||(m.addSeconds(e,-1,v),o=d(v,v),r=!0);var i=o.dayNumber,s=o.secondsOfDay;s>=43200&&(i+=1);var c=i+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var f=4e3*(c+1)/1461001|0;c=c-(1461*f/4|0)+31|0;var h=80*c/2447|0,E=c-(2447*h/80|0)|0;c=h/11|0;var p=h+2-12*c|0,y=100*(l-49)+f+c|0,_=s/u.SECONDS_PER_HOUR|0,T=s-_*u.SECONDS_PER_HOUR,R=T/u.SECONDS_PER_MINUTE|0;T-=R*u.SECONDS_PER_MINUTE;var A=0|T,S=(T-A)/u.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),r&&(A+=1),n(t)?(t.year=y,t.month=p,t.day=E,t.hour=_,t.minute=R,t.second=A,t.millisecond=S,t.isLeapSecond=r,t):new a(y,p,E,_,R,A,S,r)},m.toDate=function(e){var t=m.toGregorianDate(e,p),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},m.toIso8601=function(t,r){var o,a=m.toGregorianDate(t,p);return n(r)||0===a.millisecond?n(r)&&0!==r?(o=(.01*a.millisecond).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a.year,a.month,a.day,a.hour,a.minute,a.second,o)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",a.year,a.month,a.day,a.hour,a.minute,a.second):(o=(.01*a.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a.year,a.month,a.day,a.hour,a.minute,a.second,o))},m.clone=function(e,t){if(n(e))return n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new m(e.dayNumber,e.secondsOfDay,c.TAI)},m.compare=function(e,t){var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},m.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},m.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(m.secondsDifference(e,t))<=r},m.totalDays=function(e){return e.dayNumber+e.secondsOfDay/u.SECONDS_PER_DAY},m.secondsDifference=function(e,t){return(e.dayNumber-t.dayNumber)*u.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},m.daysDifference=function(e,t){return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/u.SECONDS_PER_DAY},m.computeTaiMinusUtc=function(e){_.julianDate=e;var r=m.leapSeconds,n=t(r,_,l);return n<0&&(n=~n,--n<0&&(n=0)),r[n].offset},m.addSeconds=function(e,t,r){return h(e.dayNumber,e.secondsOfDay+t,r)},m.addMinutes=function(e,t,r){var n=e.secondsOfDay+t*u.SECONDS_PER_MINUTE;return h(e.dayNumber,n,r)},m.addHours=function(e,t,r){var n=e.secondsOfDay+t*u.SECONDS_PER_HOUR;return h(e.dayNumber,n,r)},m.addDays=function(e,t,r){return h(e.dayNumber+t,e.secondsOfDay,r)},m.lessThan=function(e,t){return m.compare(e,t)<0},m.lessThanOrEquals=function(e,t){return m.compare(e,t)<=0},m.greaterThan=function(e,t){return m.compare(e,t)>0},m.greaterThanOrEquals=function(e,t){return m.compare(e,t)>=0},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m.prototype.equalsEpsilon=function(e,t){return m.equalsEpsilon(this,e,t)},m.prototype.toString=function(){return m.toIso8601(this)},m.leapSeconds=[new s(new m(2441317,43210,c.TAI),10),new s(new m(2441499,43211,c.TAI),11),new s(new m(2441683,43212,c.TAI),12),new s(new m(2442048,43213,c.TAI),13),new s(new m(2442413,43214,c.TAI),14),new s(new m(2442778,43215,c.TAI),15),new s(new m(2443144,43216,c.TAI),16),new s(new m(2443509,43217,c.TAI),17),new s(new m(2443874,43218,c.TAI),18),new s(new m(2444239,43219,c.TAI),19),new s(new m(2444786,43220,c.TAI),20),new s(new m(2445151,43221,c.TAI),21),new s(new m(2445516,43222,c.TAI),22),new s(new m(2446247,43223,c.TAI),23),new s(new m(2447161,43224,c.TAI),24),new s(new m(2447892,43225,c.TAI),25),new s(new m(2448257,43226,c.TAI),26),new s(new m(2448804,43227,c.TAI),27),new s(new m(2449169,43228,c.TAI),28),new s(new m(2449534,43229,c.TAI),29),new s(new m(2450083,43230,c.TAI),30),new s(new m(2450630,43231,c.TAI),31),new s(new m(2451179,43232,c.TAI),32),new s(new m(2453736,43233,c.TAI),33),new s(new m(2454832,43234,c.TAI),34),new s(new m(2456109,43235,c.TAI),35),new s(new m(2457204,43236,c.TAI),36),new s(new m(2457754,43237,c.TAI),37)],m}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return a.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(i,r).replace(o,t)),this.path&&(this.path=this.path.replace(o,t)),this.query&&(this.query=this.query.replace(o,t)),this.fragment&&(this.fragment=this.fragment.replace(o,t))};var o=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,i=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]&&t.shift();t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);"."!=e&&".."!=e||r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/appendForwardSlash",[],function(){"use strict";function e(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}return e}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var o=new r.constructor;for(var a in r)if(r.hasOwnProperty(a)){var i=r[a];n&&(i=t(i,n)),o[a]=i}return o}return t}),define("Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";function r(n,o,a){a=e(a,!1);var i,s,u,c={},l=t(n),f=t(o);if(l)for(i in n)n.hasOwnProperty(i)&&(s=n[i],f&&a&&"object"==typeof s&&o.hasOwnProperty(i)?(u=o[i],c[i]="object"==typeof u?r(s,u,a):s):c[i]=s);if(f)for(i in o)o.hasOwnProperty(i)&&!c.hasOwnProperty(i)&&(u=o[i],c[i]=u);return c}return r}),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r,n){t(o[r])||(o[r]=!0,console.warn(e(n,r)))}var o={};return n.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",n.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",n}),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],function(e,t,r){"use strict";function n(e,t){r(e,t)}return n}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function o(e,t){var r;return"undefined"!=typeof document&&(r=document),o._implementation(e,t,r)}return o._implementation=function(n,o,a){if(!r(o)){if(void 0===a)return n;o=t(a.baseURI,a.location.href)}var i=new e(o);return new e(n).resolve(i).toString()},o}),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r,n){var o="",a=r.lastIndexOf("/");return-1!==a&&(o=r.substring(0,a+1)),n?(r=new e(r),t(r.query)&&(o+="?"+r.query),t(r.fragment)&&(o+="#"+r.fragment),o):o}return n}),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(t){var r=new e(t);r.normalize();var n=r.path,o=n.lastIndexOf("/");return-1!==o&&(n=n.substr(o+1)),o=n.lastIndexOf("."),n=-1===o?"":n.substr(o+1)}return n}),define("Core/isBlobUri",["./Check"],function(e){"use strict";function t(e){return r.test(e)}var r=/^blob:/i;return t}),define("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";function t(t){e(r)||(r=document.createElement("a")),r.href=window.location.href;var n=r.host,o=r.protocol;return r.href=t,r.href=r.href,o!==r.protocol||n!==r.host}var r;return t}),define("Core/isDataUri",["./Check"],function(e){"use strict";function t(e){return r.test(e)}var r=/^data:/i;return t}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(e){var t="";for(var n in e)if(e.hasOwnProperty(n)){var o=e[n],a=encodeURIComponent(n)+"=";if(r(o))for(var i=0,s=o.length;i<s;++i)t+=a+encodeURIComponent(o[i])+"&";else t+=a+encodeURIComponent(o)+"&"}return t=t.slice(0,-1)}return n}),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(t){var n={};if(""===t)return n;for(var o=t.replace(/\+/g,"%20").split(/[&;]/),a=0,i=o.length;a<i;++a){var s=o[a].split("="),u=decodeURIComponent(s[0]),c=s[1];c=e(c)?decodeURIComponent(c):"";var l=n[u];"string"==typeof l?n[u]=[l,c]:r(l)?l.push(c):n[u]=c}return n}return n}),define("Core/RequestState",["../Core/freezeObject"],function(e){"use strict";return e({UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5})}),define("Core/RequestType",["../Core/freezeObject"],function(e){"use strict";return e({TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3})}),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],function(e,t,r,n){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT);var o=e(t.throttleByServer,!1),a=o||e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=a,this.throttleByServer=o,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return o.prototype.cancel=function(){this.cancelled=!0},o.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new o(this)},o}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var o=r[n],a=o.indexOf(": ");if(a>0){var i=o.substring(0,a),s=o.substring(a+2);t[i]=s}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/Event",["./Check","./defined","./defineProperties"],function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function o(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);var r=this;return function(){r.removeEventListener(e,t)}},n.prototype.removeEventListener=function(e,t){for(var r=this._listeners,n=this._scopes,o=-1,a=0;a<r.length;a++)if(r[a]===e&&n[a]===t){o=a;break}return-1!==o&&(this._insideRaiseEvent?(this._toRemove.push(o),r[o]=void 0,n[o]=void 0):(r.splice(o,1),n.splice(o,1)),!0)},n.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var e,r=this._listeners,n=this._scopes,a=r.length;for(e=0;e<a;e++){var i=r[e];t(i)&&r[e].apply(n[e],arguments)}var s=this._toRemove;if((a=s.length)>0){for(s.sort(o),e=0;e<a;e++){var u=s[e];r.splice(u,1),n.splice(u,1)}s.length=0}this._insideRaiseEvent=!1},n}),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],function(e,t,r,n){"use strict";function o(e){this._comparator=e.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function a(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(o.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),o.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},o.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,o=this._array,i=-1,s=!0;s;){var u=2*(e+1),c=u-1;i=c<r&&n(o[c],o[e])<0?c:e,u<r&&n(o[u],o[i])<0&&(i=u),i!==e?(a(o,i,e),e=i):s=!1}},o.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},o.prototype.insert=function(e){var t=this._array,n=this._comparator,o=this._maximumLength,i=this._length++;for(i<t.length?t[i]=e:t.push(e);0!==i;){var s=Math.floor((i-1)/2);if(!(n(t[i],t[s])<0))break;a(t,i,s),i=s}var u;return r(o)&&this._length>o&&(u=t[o],this._length=o),u},o.prototype.pop=function(e){if(e=t(e,0),0!==this._length){var r=this._array,n=r[e];return a(r,e,--this._length),this.heapify(e),n}},o}),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState"],function(e,t,r,n,o,a,i,s,u,c,l){"use strict";function f(e,t){return e.priority-t.priority}function d(){}function h(e){o(e.priorityFunction)&&(e.priority=e.priorityFunction())}function E(e){var t=n(d.requestsByServer[e],d.maximumRequestsPerServer);return O[e]<t}function m(e){return e.state===l.UNISSUED&&(e.state=l.ISSUED,e.deferred=t.defer()),e.deferred.promise}function p(e){return function(t){e.state!==l.CANCELLED&&(--S.numberOfActiveRequests,--O[e.serverKey],v.raiseEvent(),e.state=l.RECEIVED,e.deferred.resolve(t))}}function y(e){return function(t){e.state!==l.CANCELLED&&(++S.numberOfFailedRequests,--S.numberOfActiveRequests,--O[e.serverKey],v.raiseEvent(t),e.state=l.FAILED,e.deferred.reject(t))}}function _(e){var t=m(e);return e.state=l.ACTIVE,g.push(e),++S.numberOfActiveRequests,++S.numberOfActiveRequestsEver,++O[e.serverKey],e.requestFunction().then(p(e)).otherwise(y(e)),t}function T(e){var t=e.state===l.ACTIVE;e.state=l.CANCELLED,++S.numberOfCancelledRequests,e.deferred.reject(),t&&(--S.numberOfActiveRequests,--O[e.serverKey],++S.numberOfCancelledActiveRequests),o(e.cancelFunction)&&e.cancelFunction()}function R(){S.numberOfAttemptedRequests=0,S.numberOfCancelledRequests=0,S.numberOfCancelledActiveRequests=0}function A(){d.debugShowStatistics&&(S.numberOfAttemptedRequests>0&&console.log("Number of attempted requests: "+S.numberOfAttemptedRequests),S.numberOfActiveRequests>0&&console.log("Number of active requests: "+S.numberOfActiveRequests),S.numberOfCancelledRequests>0&&console.log("Number of cancelled requests: "+S.numberOfCancelledRequests),S.numberOfCancelledActiveRequests>0&&console.log("Number of cancelled active requests: "+S.numberOfCancelledActiveRequests),S.numberOfFailedRequests>0&&console.log("Number of failed requests: "+S.numberOfFailedRequests),R())}var S={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0},C=20,I=new s({comparator:f});I.maximumLength=C,I.reserve(C);var g=[],O={},N="undefined"!=typeof document?new e(document.location.href):new e,v=new i;return d.maximumRequests=50,d.maximumRequestsPerServer=6,d.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},d.throttleRequests=!0,d.debugShowStatistics=!1,d.requestCompletedEvent=v,a(d,{statistics:{get:function(){return S}},priorityHeapLength:{get:function(){return C},set:function(e){if(e<C)for(;I.length>e;){var t=I.pop();T(t)}C=e,I.maximumLength=e,I.reserve(e)}}}),d.update=function(){var e,t,r=0,n=g.length;for(e=0;e<n;++e)t=g[e],t.cancelled&&T(t),t.state===l.ACTIVE?r>0&&(g[e-r]=t):++r;g.length-=r;var o=I.internalArray,a=I.length;for(e=0;e<a;++e)h(o[e]);I.resort();for(var i=Math.max(d.maximumRequests-g.length,0),s=0;s<i&&I.length>0;)t=I.pop(),t.cancelled?T(t):!t.throttleByServer||E(t.serverKey)?(_(t),++s):T(t);A()},d.getServerKey=function(t){var r=new e(t).resolve(N);r.normalize();var n=r.authority;/:/.test(n)||(n=n+":"+("https"===r.scheme?"443":"80"));var a=O[n];return o(a)||(O[n]=0),n},d.request=function(e){if(c(e.url)||u(e.url))return v.raiseEvent(),e.state=l.RECEIVED,e.requestFunction();if(++S.numberOfAttemptedRequests,o(e.serverKey)||(e.serverKey=d.getServerKey(e.url)),!d.throttleRequests||!e.throttle)return _(e);if(!(g.length>=d.maximumRequests)&&(!e.throttleByServer||E(e.serverKey))){h(e);var t=I.insert(e);if(o(t)){if(t===e)return;T(t)}return m(e)}},d.clearForSpecs=function(){for(;I.length>0;){T(I.pop())}for(var e=g.length,t=0;t<e;++t)T(g[t]);g.length=0,O={},S.numberOfAttemptedRequests=0,S.numberOfActiveRequests=0,S.numberOfCancelledRequests=0,S.numberOfCancelledActiveRequests=0,S.numberOfFailedRequests=0,S.numberOfActiveRequestsEver=0},d.numberOfActiveRequestsByServer=function(e){return O[e]},d.requestHeap=I,d}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r){var n=new e(r);n.normalize();var o=n.getAuthority();if(t(o)){if(-1!==o.indexOf("@")){o=o.split("@")[1]}if(-1===o.indexOf(":")){var a=n.getScheme();if(t(a)||(a=window.location.protocol,a=a.substring(0,a.length-1)),"http"===a)o+=":80";else{if("https"!==a)return;o+=":443"}}return o}}var o={},a={};return o.add=function(e,r){var n=e.toLowerCase()+":"+r;t(a[n])||(a[n]=!0)},o.remove=function(e,r){var n=e.toLowerCase()+":"+r;t(a[n])&&delete a[n]},o.contains=function(e){var r=n(e);return!(!t(r)||!t(a[r]))},o.clear=function(){a={}},o}),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./deprecationWarning","./DeveloperError","./FeatureDetection","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],function(e,t,r,n,o,a,i,s,u,c,l,f,d,h,E,m,p,y,_,T,R,A,S,C,I,g,O){"use strict";function N(e,t,r,n){var o=e.query;if(!s(o)||0===o.length)return{};var a;if(-1===o.indexOf("=")){var i={};i[o]=void 0,a=i}else a=R(o);t._queryParameters=r?F(a,t._queryParameters,n):a,e.query=void 0}function v(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||s(r[n[0]])?e.query=T(r):e.query=n[0]}function w(e,t){return s(e)?s(e.clone)?e.clone():o(e):t}function M(e){if(e.state===I.ISSUED||e.state===I.ACTIVE)throw new g("The Resource is already being fetched.");e.state=I.UNISSUED,e.deferred=void 0}function F(e,t,r){if(!r)return a(e,t);var n=o(e,!0);for(var i in t)if(t.hasOwnProperty(i)){var u=n[i],c=t[i];s(u)?(Array.isArray(u)||(u=n[i]=[u]),n[i]=u.concat(c)):n[i]=Array.isArray(c)?c.slice():c}return n}function x(t){t=i(t,i.EMPTY_OBJECT),"string"==typeof t&&(t={url:t}),this._url=void 0,this._templateValues=w(t.templateValues,{}),this._queryParameters=w(t.queryParameters,{}),this.headers=w(t.headers,{}),this.request=i(t.request,new A),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=i(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);N(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function D(e){var r=e.request;r.url=e.url,r.requestFunction=function(){var r=e.url,n=!1;e.isDataUri||e.isBlobUri||(n=e.isCrossOriginUrl);var o=t.defer();return x._Implementations.createImage(r,n,o),o.promise};var n=C.request(r);if(s(n))return n.otherwise(function(n){return r.state!==I.FAILED?t.reject(n):e.retryOnError(n).then(function(o){return o?(r.state=I.UNISSUED,r.deferred=void 0,D(e)):t.reject(n)})})}function U(e,r,n){var o={};o[r]=n,e.setQueryParameters(o);var a=e.request;a.url=e.url,a.requestFunction=function(){var r=t.defer();return window[n]=function(e){r.resolve(e);try{delete window[n]}catch(e){window[n]=void 0}},x._Implementations.loadAndExecuteScript(e.url,n,r),r.promise};var i=C.request(a);if(s(i))return i.otherwise(function(o){
return a.state!==I.FAILED?t.reject(o):e.retryOnError(o).then(function(i){return i?(a.state=I.UNISSUED,a.deferred=void 0,U(e,r,n)):t.reject(o)})})}function P(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function L(e,t){for(var r=P(e,t),n=new ArrayBuffer(r.length),o=new Uint8Array(n),a=0;a<r.length;a++)o[a]=r.charCodeAt(a);return n}function b(e,t){t=i(t,"");var r=e[1],n=!!e[2],o=e[3];switch(t){case"":case"text":return P(n,o);case"arraybuffer":return L(n,o);case"blob":var a=L(n,o);return new Blob([a],{type:r});case"document":return(new DOMParser).parseFromString(P(n,o),r);case"json":return JSON.parse(P(n,o))}}function B(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function z(e,t,r,n,o,a,i){var s=require("url").parse(e),u="https:"===s.protocol?require("https"):require("http"),c=require("zlib"),l={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:r,headers:o};u.request(l).on("response",function(e){if(e.statusCode<200||e.statusCode>=300)return void a.reject(new S(e.statusCode,e,e.headers));var r=[];e.on("data",function(e){r.push(e)}),e.on("end",function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?c.gunzip(n,function(e,r){e?a.reject(new g("Error decompressing response.")):a.resolve(B(r,t))}):a.resolve(B(n,t))})}).on("error",function(e){a.reject(new S)}).end()}var G=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(e){return!1}}();x.createIfNeeded=function(e){return e instanceof x?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new x({url:e})},u(x,{isBlobSupported:{get:function(){return G}}}),u(x.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);N(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return m(this._url)}},isDataUri:{get:function(){return _(this._url)}},isBlobUri:{get:function(){return p(this._url)}},isCrossOriginUrl:{get:function(){return y(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),x.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&v(n,this);var o=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),a=this._templateValues,i=Object.keys(a);if(i.length>0)for(var u=0;u<i.length;u++){var c=i[u],l=a[c];o=o.replace(new RegExp("{"+c+"}","g"),encodeURIComponent(l))}return r&&s(this.proxy)&&(o=this.proxy.getURL(o)),o},x.prototype.setQueryParameters=function(e,t){this._queryParameters=t?F(this._queryParameters,e,!1):F(e,this._queryParameters,!1)},x.prototype.addQueryParameters=function(e,t){return c("Resource.addQueryParameters","addQueryParameters has been deprecated and will be removed 1.45. Use setQueryParameters or appendQueryParameters instead."),this.setQueryParameters(e,t)},x.prototype.appendQueryParameters=function(e){this._queryParameters=F(e,this._queryParameters,!0)},x.prototype.setTemplateValues=function(e,t){this._templateValues=t?a(this._templateValues,e):a(e,this._templateValues)},x.prototype.addTemplateValues=function(e,t){return c("Resource.addTemplateValues","addTemplateValues has been deprecated and will be removed 1.45. Use setTemplateValues."),this.setTemplateValues(e,t)},x.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,s(t.url)){var n=new e(t.url);N(n,r,!0,i(t.preserveQueryParameters,!1)),n.fragment=void 0,r._url=n.resolve(new e(h(this._url))).toString()}return s(t.queryParameters)&&(r._queryParameters=a(t.queryParameters,r._queryParameters)),s(t.templateValues)&&(r._templateValues=a(t.templateValues,r.templateValues)),s(t.headers)&&(r.headers=a(t.headers,r.headers)),s(t.proxy)&&(r.proxy=t.proxy),s(t.request)&&(r.request=t.request),s(t.retryCallback)&&(r.retryCallback=t.retryCallback),s(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},x.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then(function(e){return++n._retryCount,e})},x.prototype.clone=function(e){return s(e)||(e=new x({url:this._url})),e._url=this._url,e._queryParameters=o(this._queryParameters),e._templateValues=o(this._templateValues),e.headers=o(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},x.prototype.getBaseUri=function(e){return E(this.getUrlComponent(e),e)},x.prototype.appendForwardSlash=function(){this._url=r(this._url)},x.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},x.fetchArrayBuffer=function(e){return new x(e).fetchArrayBuffer()},x.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},x.fetchBlob=function(e){return new x(e).fetchBlob()},x.prototype.fetchImage=function(e){if(e=i(e,!1),M(this.request),!G||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!e)return D(this,!0);var r=this.fetchBlob();if(s(r)){var n,o;return r.then(function(e){if(s(e)){o=e;var t=window.URL.createObjectURL(e);return n=new x({url:t}),D(n)}}).then(function(e){if(s(e))return window.URL.revokeObjectURL(n.url),e.blob=o,e}).otherwise(function(e){return s(n)&&window.URL.revokeObjectURL(n.url),t.reject(e)})}},x.fetchImage=function(e){return new x(e).fetchImage(e.preferBlob)},x.prototype.fetchText=function(){return this.fetch({responseType:"text"})},x.fetchText=function(e){return new x(e).fetchText()},x.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(s(e))return e.then(function(e){if(s(e))return JSON.parse(e)})},x.fetchJson=function(e){return new x(e).fetchJson()},x.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},x.fetchXML=function(e){return new x(e).fetchXML()},x.prototype.fetchJsonp=function(e){e=i(e,"callback"),M(this.request);var t;do{t="loadJsonp"+Math.random().toString().substring(2,8)}while(s(window[t]));return U(this,e,t)},x.fetchJsonp=function(e){return new x(e).fetchJsonp(e.callbackParameterName)},x.prototype._makeRequest=function(e){var r=this;M(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(){var o=e.responseType,i=a(e.headers,r.headers),u=e.overrideMimeType,c=e.method,l=e.data,f=t.defer(),d=x._Implementations.loadWithXhr(r.url,o,c,l,i,f,u);return s(d)&&s(d.abort)&&(n.cancelFunction=function(){d.abort()}),f.promise};var o=C.request(n);if(s(o))return o.then(function(e){return e}).otherwise(function(o){return n.state!==I.FAILED?t.reject(o):r.retryOnError(o).then(function(a){return a?(n.state=I.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(o)})})};var q=/^data:(.*?)(;base64)?,(.*)$/;return x.prototype.fetch=function(e){return e=w(e,{}),e.method="GET",this._makeRequest(e)},x.fetch=function(e){return new x(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.delete=function(e){return e=w(e,{}),e.method="DELETE",this._makeRequest(e)},x.delete=function(e){return new x(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},x.prototype.head=function(e){return e=w(e,{}),e.method="HEAD",this._makeRequest(e)},x.head=function(e){return new x(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.options=function(e){return e=w(e,{}),e.method="OPTIONS",this._makeRequest(e)},x.options=function(e){return new x(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.post=function(e,t){return n.defined("data",e),t=w(t,{}),t.method="POST",t.data=e,this._makeRequest(t)},x.post=function(e){return new x(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.put=function(e,t){return n.defined("data",e),t=w(t,{}),t.method="PUT",t.data=e,this._makeRequest(t)},x.put=function(e){return new x(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.patch=function(e,t){return n.defined("data",e),t=w(t,{}),t.method="PATCH",t.data=e,this._makeRequest(t)},x.patch=function(e){return new x(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x._Implementations={},x._Implementations.createImage=function(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(O.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e},x._Implementations.loadWithXhr=function(e,t,r,n,o,a,i){var u=q.exec(e);if(null!==u)return void a.resolve(b(u,t));if(f.isNodeJs())return void z(e,t,r,n,o,a,i);var c=new XMLHttpRequest;if(O.contains(e)&&(c.withCredentials=!0),s(i)&&s(c.overrideMimeType)&&c.overrideMimeType(i),c.open(r,e,!0),s(o))for(var l in o)o.hasOwnProperty(l)&&c.setRequestHeader(l,o[l]);s(t)&&(c.responseType=t);var d=!1;return"string"==typeof e&&(d=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),c.onload=function(){if((c.status<200||c.status>=300)&&(!d||0!==c.status))return void a.reject(new S(c.status,c.response,c.getAllResponseHeaders()));var e=c.response,n=c.responseType;if("HEAD"===r||"OPTIONS"===r){var o=c.getAllResponseHeaders(),i=o.trim().split(/[\r\n]+/),u={};return i.forEach(function(e){var t=e.split(": "),r=t.shift();u[r]=t.join(": ")}),void a.resolve(u)}if(204===c.status)a.resolve();else if(!s(e)||s(t)&&n!==t)if("json"===t&&"string"==typeof e)try{a.resolve(JSON.parse(e))}catch(e){a.reject(e)}else(""===n||"document"===n)&&s(c.responseXML)&&c.responseXML.hasChildNodes()?a.resolve(c.responseXML):""!==n&&"text"!==n||!s(c.responseText)?a.reject(new g("Invalid XMLHttpRequest response type.")):a.resolve(c.responseText);else a.resolve(e)},c.onerror=function(e){a.reject(new S)},c.send(n),c},x._Implementations.loadAndExecuteScript=function(e,t,r){var n=document.createElement("script");n.async=!0,n.src=e;var o=document.getElementsByTagName("head")[0];n.onload=function(){n.onload=void 0,o.removeChild(n)},n.onerror=function(e){r.reject(e)},o.appendChild(n)},x._DefaultImplementations={},x._DefaultImplementations.createImage=x._Implementations.createImage,x._DefaultImplementations.loadWithXhr=x._Implementations.loadWithXhr,x._DefaultImplementations.loadAndExecuteScript=x._Implementations.loadAndExecuteScript,x.DEFAULT=d(new x({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),x}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,o,a,i,s,u,c,l,f){"use strict";function d(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))E(this,t.data);else if(n(t.url)){var o=u.createIfNeeded(t.url),a=this;this._downloadPromise=e(o.fetchJson(),function(e){E(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+o.url+"."})}else E(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function h(e,t){return i.compare(e.julianDate,t)}function E(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var o=r.columnNames.indexOf("modifiedJulianDateUtc"),a=r.columnNames.indexOf("xPoleWanderRadians"),u=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),d=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),E=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=r.columnNames.indexOf("taiMinusUtcSeconds");if(o<0||a<0||u<0||c<0||d<0||E<0||m<0)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var p=e._samples=r.samples,y=e._dates=[];e._dateColumn=o,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=u,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=E,e._taiMinusUtcSecondsColumn=m,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _,T=e._addNewLeapSeconds,R=0,A=p.length;R<A;R+=e._columnCount){var S=p[R+o],C=p[R+m],I=S+l.MODIFIED_JULIAN_DATE_DIFFERENCE,g=new i(I,C,f.TAI);if(y.push(g),T){if(C!==_&&n(_)){var O=i.leapSeconds,N=t(O,g,h);if(N<0){var v=new s(g,C);O.splice(~N,0,v)}}_=C}}}function m(e,t,r,n,o){var a=r*n;o.xPoleWander=t[a+e._xPoleWanderRadiansColumn],o.yPoleWander=t[a+e._yPoleWanderRadiansColumn],o.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],o.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],o.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function p(e,t,r){return t+e*(r-t)}function y(e,t,r,n,o,a,s){var u=e._columnCount;if(a>t.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;var c=t[o],l=t[a];if(c.equals(l)||n.equals(c))return m(e,r,o,u,s),s;if(n.equals(l))return m(e,r,a,u,s),s;var f=i.secondsDifference(n,c)/i.secondsDifference(l,c),d=o*u,h=a*u,E=r[d+e._ut1MinusUtcSecondsColumn],y=r[h+e._ut1MinusUtcSecondsColumn],_=y-E;if(_>.5||_<-.5){var T=r[d+e._taiMinusUtcSecondsColumn],R=r[h+e._taiMinusUtcSecondsColumn];T!==R&&(l.equals(n)?E=y:y-=R-T)}return s.xPoleWander=p(f,r[d+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),s.yPoleWander=p(f,r[d+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),s.xPoleOffset=p(f,r[d+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),s.yPoleOffset=p(f,r[d+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=p(f,E,y),s}return d.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new o(0,0,0,0,0),t}}),d.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},d.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new o(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var a=this._dates,s=this._lastIndex,u=0,l=0;if(n(s)){var f=a[s],d=a[s+1],h=i.lessThanOrEquals(f,e),E=!n(d),m=E||i.greaterThanOrEquals(d,e);if(h&&m)return u=s,!E&&d.equals(e)&&++u,l=u+1,y(this,a,this._samples,e,u,l,r),r}var p=t(a,e,i.compare,this._dateColumn);return p>=0?(p<a.length-1&&a[p+1].equals(e)&&++p,u=p,l=p):(l=~p,(u=l-1)<0&&(u=0)),this._lastIndex=u,y(this,a,this._samples,e,u,l,r),r}if(n(this._dataError))throw new c(this._dataError)},d}),define("Core/buildModuleUrl",["./defined","./DeveloperError","./Resource","require"],function(e,t,r,n){"use strict";function o(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;t<r;++t){var n=e[t].getAttribute("src"),o=d.exec(n);if(null!==o)return o[1]}}function a(){if(e(c))return c;var t;return t="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:o(),c=new r({url:t}),c.appendForwardSlash(),c}function i(e){return n.toUrl("../"+e)}function s(e){return a().getDerivedResource({url:e}).url}function u(t){if("undefined"==typeof document)return t;e(l)||(l=e(define.amd)&&!define.amd.toUrlUndefined&&e(n.toUrl)?i:s),e(f)||(f=document.createElement("a"));var r=l(t);return f.href=r,f.href=f.href,f.href}var c,l,f,d=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return u._cesiumScriptRegex=d,u._buildModuleUrlFromBaseUrl=s,u._clearBaseResource=function(){c=void 0},u.setBaseUrl=function(e){c=r.DEFAULT.getDerivedResource({url:e})},u}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],function(e,t,r,n,o,a,i,s){"use strict";function u(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=i.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,s.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),o=this._xTable=new Array(t+1),u=Math.pow(this._stepSizeDays,t),c=0;c<=t;++c){n[c]=u,o[c]=c*this._stepSizeDays;for(var l=0;l<=t;++l)l!==c&&(n[c]*=c-l);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,r){var n=f;return n.dayNumber=t,n.secondsOfDay=r,a.daysDifference(n,e._sampleZeroDateTT)}function l(r,o){if(r._chunkDownloadsInProgress[o])return r._chunkDownloadsInProgress[o];var a=e.defer();r._chunkDownloadsInProgress[o]=a;var s,u=r._xysFileUrlTemplate;return s=n(u)?u.getDerivedResource({templateValues:{0:o}}):new i({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+o+".json")}),e(s.fetchJson(),function(e){r._chunkDownloadsInProgress[o]=!1;for(var t=r._samples,n=e.samples,i=o*r._samplesPerXysFile*3,s=0,u=n.length;s<u;++s)t[i+s]=n[s];a.resolve()}),a.promise}var f=new a(0,0,s.TAI);return u.prototype.preload=function(t,r,n,o){var a=c(this,t,r),i=c(this,n,o),s=a/this._stepSizeDays-this._interpolationOrder/2|0;s<0&&(s=0);var u=i/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;u>=this._totalSamples&&(u=this._totalSamples-1);for(var f=s/this._samplesPerXysFile|0,d=u/this._samplesPerXysFile|0,h=[],E=f;E<=d;++E)h.push(l(this,E));return e.all(h)},u.prototype.computeXysRadians=function(e,t,r){var a=c(this,e,t);if(!(a<0)){var i=a/this._stepSizeDays|0;if(!(i>=this._totalSamples)){var s=this._interpolationOrder,u=i-(s/2|0);u<0&&(u=0);var f=u+s;f>=this._totalSamples&&(f=this._totalSamples-1,(u=f-s)<0&&(u=0));var d=!1,h=this._samples;if(n(h[3*u])||(l(this,u/this._samplesPerXysFile|0),d=!0),n(h[3*f])||(l(this,f/this._samplesPerXysFile|0),d=!0),!d){n(r)?(r.x=0,r.y=0,r.s=0):r=new o(0,0,0);var E,m,p=a-u*this._stepSizeDays,y=this._work,_=this._denominators,T=this._coef,R=this._xTable;for(E=0;E<=s;++E)y[E]=p-R[E];for(E=0;E<=s;++E){for(T[E]=1,m=0;m<=s;++m)m!==E&&(T[E]*=y[m]);T[E]*=_[E];var A=3*(u+E);r.x+=T[E]*h[A++],r.y+=T[E]*h[A++],r.s+=T[E]*h[A]}return r}}}},u}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,o,a,i,s,u,c,l,f,d,h,E,m,p,y,_,T){"use strict";var R={},A={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},S={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},C={},I={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},g=new r,O=new r,N=new r;R.localFrameToFixedFrameGenerator=function(e,t){if(!A.hasOwnProperty(e)||!A[e].hasOwnProperty(t))throw new u("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,o=A[e][t],a=e+t;return s(C[a])?n=C[a]:(n=function(n,a,u){if(s(u)||(u=new y),m.equalsEpsilon(n.x,0,m.EPSILON14)&&m.equalsEpsilon(n.y,0,m.EPSILON14)){var c=m.sign(n.z);r.unpack(S[e],0,g),"east"!==e&&"west"!==e&&r.multiplyByScalar(g,c,g),r.unpack(S[t],0,O),"east"!==t&&"west"!==t&&r.multiplyByScalar(O,c,O),r.unpack(S[o],0,N),"east"!==o&&"west"!==o&&r.multiplyByScalar(N,c,N)}else{a=i(a,f.WGS84),a.geodeticSurfaceNormal(n,I.up);var l=I.up,d=I.east;d.x=-n.y,d.y=n.x,d.z=0,r.normalize(d,I.east),r.cross(l,d,I.north),r.multiplyByScalar(I.up,-1,I.down),r.multiplyByScalar(I.east,-1,I.west),r.multiplyByScalar(I.north,-1,I.south),g=I[e],O=I[t],N=I[o]}return u[0]=g.x,u[1]=g.y,u[2]=g.z,u[3]=0,u[4]=O.x,u[5]=O.y,u[6]=O.z,u[7]=0,u[8]=N.x,u[9]=N.y,u[10]=N.z,u[11]=0,u[12]=n.x,u[13]=n.y,u[14]=n.z,u[15]=1,u},C[a]=n),n},R.eastNorthUpToFixedFrame=R.localFrameToFixedFrameGenerator("east","north"),R.northEastDownToFixedFrame=R.localFrameToFixedFrameGenerator("north","east"),R.northUpEastToFixedFrame=R.localFrameToFixedFrameGenerator("north","up"),R.northWestUpToFixedFrame=R.localFrameToFixedFrameGenerator("north","west");var v=new _,w=new r(1,1,1),M=new y;R.headingPitchRollToFixedFrame=function(e,t,n,o,a){o=i(o,R.eastNorthUpToFixedFrame);var s=_.fromHeadingPitchRoll(t,v),u=y.fromTranslationQuaternionRotationScale(r.ZERO,s,w,M);return a=o(e,n,a),y.multiply(a,u,a)};var F=new y,x=new p;R.headingPitchRollQuaternion=function(e,t,r,n,o){var a=R.headingPitchRollToFixedFrame(e,t,r,n,F),i=y.getRotation(a,x);return _.fromRotationMatrix(i,o)};var D=m.TWO_PI/86400,U=new E;R.computeTemeToPseudoFixedMatrix=function(e,t){U=E.addSeconds(e,-E.computeTaiMinusUtc(e),U);var r,n=U.dayNumber,o=U.secondsOfDay,a=n-2451545;r=o>=43200?(a+.5)/T.DAYS_PER_JULIAN_CENTURY:(a-.5)/T.DAYS_PER_JULIAN_CENTURY;var i=24110.54841+r*(8640184.812866+r*(.093104+-62e-7*r)),u=i*D%m.TWO_PI,c=72921158553e-15+1.1772758384668e-19*(n-2451545.5),l=(o+.5*T.SECONDS_PER_DAY)%T.SECONDS_PER_DAY,f=u+c*l,d=Math.cos(f),h=Math.sin(f);return s(t)?(t[0]=d,t[1]=-h,t[2]=0,t[3]=h,t[4]=d,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new p(d,h,0,-h,d,0,0,0,1)},R.iau2006XysData=new d,R.earthOrientationParameters=c.NONE;R.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+32.184,o=t.stop.dayNumber,a=t.stop.secondsOfDay+32.184,i=R.iau2006XysData.preload(r,n,o,a),s=R.earthOrientationParameters.getPromiseToLoad();return e.all([i,s])},R.computeIcrfToFixedMatrix=function(e,t){s(t)||(t=new p);var r=R.computeFixedToIcrfMatrix(e,t);if(s(r))return p.transpose(r,t)};var P=new h(0,0,0),L=new l(0,0,0,0,0,0),b=new p,B=new p;R.computeFixedToIcrfMatrix=function(e,t){s(t)||(t=new p);var r=R.earthOrientationParameters.compute(e,L);if(s(r)){var n=e.dayNumber,o=e.secondsOfDay+32.184,a=R.iau2006XysData.computeXysRadians(n,o,P);if(s(a)){var i=a.x+r.xPoleOffset,u=a.y+r.yPoleOffset,c=1/(1+Math.sqrt(1-i*i-u*u)),l=b;l[0]=1-c*i*i,l[3]=-c*i*u,l[6]=i,l[1]=-c*i*u,l[4]=1-c*u*u,l[7]=u,l[2]=-i,l[5]=-u,l[8]=1-c*(i*i+u*u);var f=p.fromRotationZ(-a.s,B),d=p.multiply(l,f,b),h=e.dayNumber,y=e.secondsOfDay-E.computeTaiMinusUtc(e)+r.ut1MinusUtc,_=h-2451545,A=y/T.SECONDS_PER_DAY,S=.779057273264+A+.00273781191135448*(_+A);S=S%1*m.TWO_PI;var C=p.fromRotationZ(S,B),I=p.multiply(d,C,b),g=Math.cos(r.xPoleWander),O=Math.cos(r.yPoleWander),N=Math.sin(r.xPoleWander),v=Math.sin(r.yPoleWander),w=n-2451545+o/T.SECONDS_PER_DAY;w/=36525;var M=-47e-6*w*m.RADIANS_PER_DEGREE/3600,F=Math.cos(M),x=Math.sin(M),D=B;return D[0]=g*F,D[1]=g*x,D[2]=N,D[3]=-O*x+v*N*F,D[4]=O*F+v*N*x,D[5]=-v*g,D[6]=-v*x-O*N*F,D[7]=v*F-O*N*x,D[8]=O*g,p.multiply(I,D,t)}}};var z=new n;R.pointToWindowCoordinates=function(e,t,r,n){return n=R.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},R.pointToGLWindowCoordinates=function(e,r,o,a){s(a)||(a=new t);var i=z;return y.multiplyByVector(e,n.fromElements(o.x,o.y,o.z,1,i),i),n.multiplyByScalar(i,1/i.w,i),y.multiplyByVector(r,i,i),t.fromCartesian4(i,a)};var G=new r,q=new r,V=new r;R.rotationMatrixFromPositionVelocity=function(e,t,n,o){var a=i(n,f.WGS84).geodeticSurfaceNormal(e,G),u=r.cross(t,a,q);r.equalsEpsilon(u,r.ZERO,m.EPSILON6)&&(u=r.clone(r.UNIT_X,u));var c=r.cross(u,t,V);return r.cross(t,c,u),r.negate(u,u),s(o)||(o=new p),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=u.x,o[4]=u.y,o[5]=u.z,o[6]=c.x,o[7]=c.y,o[8]=c.z,o};var W=new y(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),k=new o,H=new r,X=new r,Y=new p,j=new y,K=new y;return R.basisTo2D=function(e,t,n){var o=y.getTranslation(t,X),a=e.ellipsoid,i=a.cartesianToCartographic(o,k),s=e.project(i,H);r.fromElements(s.z,s.x,s.y,s);var u=R.eastNorthUpToFixedFrame(o,a,j),c=y.inverseTransformation(u,K),l=y.getRotation(t,Y),f=y.multiplyByMatrix3(c,l,n);return y.multiply(W,f,n),y.setTranslation(n,s,n),n},R.wgs84To2DModelMatrix=function(e,t,n){var o=e.ellipsoid,a=R.eastNorthUpToFixedFrame(t,o,j),i=y.inverseTransformation(a,K),s=o.cartesianToCartographic(t,k),u=e.project(s,H);r.fromElements(u.z,u.x,u.y,u);var c=y.fromTranslation(u,j);return y.multiply(W,i,n),y.multiply(c,n,n),n},R}),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],function(e,t,r,n,o,a,i,s,u,c,l,f,d,h,E){"use strict";function m(e){e=o(e,o.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=o(e.primitiveType,f.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=o(e.geometryType,s.NONE),this.boundingSphereCV=e.boundingSphereCV}m.computeNumberOfVertices=function(e){var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&a(e.attributes[r])&&a(e.attributes[r].values)){var n=e.attributes[r],o=n.values.length/n.componentsPerAttribute;t=o}return t};var p=new r,y=new t,_=new l,T=[new r,new r,new r],R=[new e,new e,new e],A=[new e,new e,new e],S=new t,C=new d,I=new l,g=new u;return m._textureCoordinateRotationPoints=function(n,o,a,i){var s,f=h.center(i,p),m=r.toCartesian(f,a,y),O=E.eastNorthUpToFixedFrame(m,a,_),N=l.inverse(O,_),v=R,w=T;w[0].longitude=i.west,w[0].latitude=i.south,w[1].longitude=i.west,w[1].latitude=i.north,w[2].longitude=i.east,w[2].latitude=i.south;var M=S;for(s=0;s<3;s++)r.toCartesian(w[s],a,M),M=l.multiplyByPointAsVector(N,M,M),v[s].x=M.x,v[s].y=M.y;var F=d.fromAxisAngle(t.UNIT_Z,-o,C),x=c.fromQuaternion(F,I),D=n.length,U=Number.POSITIVE_INFINITY,P=Number.POSITIVE_INFINITY,L=Number.NEGATIVE_INFINITY,b=Number.NEGATIVE_INFINITY;for(s=0;s<D;s++)M=l.multiplyByPointAsVector(N,n[s],M),M=c.multiplyByVector(x,M,M),U=Math.min(U,M.x),P=Math.min(P,M.y),L=Math.max(L,M.x),b=Math.max(b,M.y);var B=u.fromRotation(o,g),z=A;z[0].x=U,z[0].y=P,z[1].x=U,z[1].y=b,z[2].x=L,z[2].y=P;var G=v[0],q=v[2].x-G.x,V=v[1].y-G.y;for(s=0;s<3;s++){var W=z[s];u.multiplyByVector(B,W,W),W.x=(W.x-G.x)/q,W.y=(W.y-G.y)/V}var k=z[0],H=z[1],X=z[2],Y=new Array(6);return e.pack(k,Y),e.pack(H,Y,2),e.pack(X,Y,4),Y},m}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return o.POSITION_ONLY=n(new o({position:!0})),o.POSITION_AND_NORMAL=n(new o({position:!0,normal:!0})),o.POSITION_NORMAL_AND_ST=n(new o({position:!0,normal:!0,st:!0})),o.POSITION_AND_ST=n(new o({position:!0,st:!0})),o.POSITION_AND_COLOR=n(new o({position:!0,color:!0})),o.ALL=n(new o({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),o.DEFAULT=o.POSITION_NORMAL_AND_ST,o.packedLength=6,o.pack=function(t,r,n){return n=e(n,0),r[n++]=t.position?1:0,r[n++]=t.normal?1:0,r[n++]=t.st?1:0,r[n++]=t.tangent?1:0,r[n++]=t.bitangent?1:0,r[n]=t.color?1:0,r},o.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new o),a.position=1===r[n++],a.normal=1===r[n++],a.st=1===r[n++],a.tangent=1===r[n++],a.bitangent=1===r[n++],a.color=1===r[n],a},o.clone=function(e,r){if(t(e))return t(r)||(r=new o),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r},o}),define("Core/BoxGeometry",["./BoundingSphere","./Cartesian3","./Check","./ComponentDatatype","./defaultValue","./defined","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType","./VertexFormat"],function(e,t,r,n,o,a,i,s,u,c,l){"use strict";function f(e){e=o(e,o.EMPTY_OBJECT);var r=e.minimum,n=e.maximum,a=o(e.vertexFormat,l.DEFAULT);this._minimum=t.clone(r),this._maximum=t.clone(n),this._vertexFormat=a,this._workerName="createBoxGeometry"}var d=new t;f.fromDimensions=function(e){e=o(e,o.EMPTY_OBJECT);var r=e.dimensions,n=t.multiplyByScalar(r,.5,new t);return new f({minimum:t.negate(n,new t),maximum:n,vertexFormat:e.vertexFormat})},f.fromAxisAlignedBoundingBox=function(e){return new f({minimum:e.minimum,maximum:e.maximum})},f.packedLength=2*t.packedLength+l.packedLength,f.pack=function(e,r,n){return n=o(n,0),t.pack(e._minimum,r,n),t.pack(e._maximum,r,n+t.packedLength),l.pack(e._vertexFormat,r,n+2*t.packedLength),r};var h=new t,E=new t,m=new l,p={minimum:h,maximum:E,vertexFormat:m};f.unpack=function(e,r,n){r=o(r,0);var i=t.unpack(e,r,h),s=t.unpack(e,r+t.packedLength,E),u=l.unpack(e,r+2*t.packedLength,m);return a(n)?(n._minimum=t.clone(i,n._minimum),n._maximum=t.clone(s,n._maximum),n._vertexFormat=l.clone(u,n._vertexFormat),n):new f(p)},f.createGeometry=function(r){var o=r._minimum,a=r._maximum,l=r._vertexFormat;if(!t.equals(o,a)){var f,h,E=new u;if(l.position&&(l.st||l.normal||l.tangent||l.bitangent)){if(l.position&&(h=new Float64Array(72),h[0]=o.x,h[1]=o.y,h[2]=a.z,h[3]=a.x,h[4]=o.y,h[5]=a.z,h[6]=a.x,h[7]=a.y,h[8]=a.z,h[9]=o.x,h[10]=a.y,h[11]=a.z,h[12]=o.x,h[13]=o.y,h[14]=o.z,h[15]=a.x,h[16]=o.y,h[17]=o.z,h[18]=a.x,h[19]=a.y,h[20]=o.z,h[21]=o.x,h[22]=a.y,h[23]=o.z,h[24]=a.x,h[25]=o.y,h[26]=o.z,h[27]=a.x,h[28]=a.y,h[29]=o.z,h[30]=a.x,h[31]=a.y,h[32]=a.z,h[33]=a.x,h[34]=o.y,h[35]=a.z,h[36]=o.x,h[37]=o.y,h[38]=o.z,h[39]=o.x,h[40]=a.y,h[41]=o.z,h[42]=o.x,h[43]=a.y,h[44]=a.z,h[45]=o.x,h[46]=o.y,h[47]=a.z,h[48]=o.x,h[49]=a.y,h[50]=o.z,h[51]=a.x,h[52]=a.y,h[53]=o.z,h[54]=a.x,h[55]=a.y,h[56]=a.z,h[57]=o.x,h[58]=a.y,h[59]=a.z,h[60]=o.x,h[61]=o.y,h[62]=o.z,h[63]=a.x,h[64]=o.y,h[65]=o.z,h[66]=a.x,h[67]=o.y,h[68]=a.z,h[69]=o.x,h[70]=o.y,h[71]=a.z,E.position=new s({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:h})),l.normal){var m=new Float32Array(72);m[0]=0,m[1]=0,m[2]=1,m[3]=0,m[4]=0,m[5]=1,m[6]=0,m[7]=0,m[8]=1,m[9]=0,m[10]=0,m[11]=1,m[12]=0,m[13]=0,m[14]=-1,m[15]=0,m[16]=0,m[17]=-1,m[18]=0,m[19]=0,m[20]=-1,m[21]=0,m[22]=0,m[23]=-1,m[24]=1,m[25]=0,m[26]=0,m[27]=1,m[28]=0,m[29]=0,m[30]=1,m[31]=0,m[32]=0,m[33]=1,m[34]=0,m[35]=0,m[36]=-1,m[37]=0,m[38]=0,m[39]=-1,m[40]=0,m[41]=0,m[42]=-1,m[43]=0,m[44]=0,m[45]=-1,m[46]=0,m[47]=0,m[48]=0,m[49]=1,m[50]=0,m[51]=0,m[52]=1,m[53]=0,m[54]=0,m[55]=1,m[56]=0,m[57]=0,m[58]=1,
m[59]=0,m[60]=0,m[61]=-1,m[62]=0,m[63]=0,m[64]=-1,m[65]=0,m[66]=0,m[67]=-1,m[68]=0,m[69]=0,m[70]=-1,m[71]=0,E.normal=new s({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:m})}if(l.st){var p=new Float32Array(48);p[0]=0,p[1]=0,p[2]=1,p[3]=0,p[4]=1,p[5]=1,p[6]=0,p[7]=1,p[8]=1,p[9]=0,p[10]=0,p[11]=0,p[12]=0,p[13]=1,p[14]=1,p[15]=1,p[16]=0,p[17]=0,p[18]=1,p[19]=0,p[20]=1,p[21]=1,p[22]=0,p[23]=1,p[24]=1,p[25]=0,p[26]=0,p[27]=0,p[28]=0,p[29]=1,p[30]=1,p[31]=1,p[32]=1,p[33]=0,p[34]=0,p[35]=0,p[36]=0,p[37]=1,p[38]=1,p[39]=1,p[40]=0,p[41]=0,p[42]=1,p[43]=0,p[44]=1,p[45]=1,p[46]=0,p[47]=1,E.st=new s({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:p})}if(l.tangent){var y=new Float32Array(72);y[0]=1,y[1]=0,y[2]=0,y[3]=1,y[4]=0,y[5]=0,y[6]=1,y[7]=0,y[8]=0,y[9]=1,y[10]=0,y[11]=0,y[12]=-1,y[13]=0,y[14]=0,y[15]=-1,y[16]=0,y[17]=0,y[18]=-1,y[19]=0,y[20]=0,y[21]=-1,y[22]=0,y[23]=0,y[24]=0,y[25]=1,y[26]=0,y[27]=0,y[28]=1,y[29]=0,y[30]=0,y[31]=1,y[32]=0,y[33]=0,y[34]=1,y[35]=0,y[36]=0,y[37]=-1,y[38]=0,y[39]=0,y[40]=-1,y[41]=0,y[42]=0,y[43]=-1,y[44]=0,y[45]=0,y[46]=-1,y[47]=0,y[48]=-1,y[49]=0,y[50]=0,y[51]=-1,y[52]=0,y[53]=0,y[54]=-1,y[55]=0,y[56]=0,y[57]=-1,y[58]=0,y[59]=0,y[60]=1,y[61]=0,y[62]=0,y[63]=1,y[64]=0,y[65]=0,y[66]=1,y[67]=0,y[68]=0,y[69]=1,y[70]=0,y[71]=0,E.tangent=new s({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:y})}if(l.bitangent){var _=new Float32Array(72);_[0]=0,_[1]=1,_[2]=0,_[3]=0,_[4]=1,_[5]=0,_[6]=0,_[7]=1,_[8]=0,_[9]=0,_[10]=1,_[11]=0,_[12]=0,_[13]=1,_[14]=0,_[15]=0,_[16]=1,_[17]=0,_[18]=0,_[19]=1,_[20]=0,_[21]=0,_[22]=1,_[23]=0,_[24]=0,_[25]=0,_[26]=1,_[27]=0,_[28]=0,_[29]=1,_[30]=0,_[31]=0,_[32]=1,_[33]=0,_[34]=0,_[35]=1,_[36]=0,_[37]=0,_[38]=1,_[39]=0,_[40]=0,_[41]=1,_[42]=0,_[43]=0,_[44]=1,_[45]=0,_[46]=0,_[47]=1,_[48]=0,_[49]=0,_[50]=1,_[51]=0,_[52]=0,_[53]=1,_[54]=0,_[55]=0,_[56]=1,_[57]=0,_[58]=0,_[59]=1,_[60]=0,_[61]=0,_[62]=1,_[63]=0,_[64]=0,_[65]=1,_[66]=0,_[67]=0,_[68]=1,_[69]=0,_[70]=0,_[71]=1,E.bitangent=new s({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:_})}f=new Uint16Array(36),f[0]=0,f[1]=1,f[2]=2,f[3]=0,f[4]=2,f[5]=3,f[6]=6,f[7]=5,f[8]=4,f[9]=7,f[10]=6,f[11]=4,f[12]=8,f[13]=9,f[14]=10,f[15]=8,f[16]=10,f[17]=11,f[18]=14,f[19]=13,f[20]=12,f[21]=15,f[22]=14,f[23]=12,f[24]=18,f[25]=17,f[26]=16,f[27]=19,f[28]=18,f[29]=16,f[30]=20,f[31]=21,f[32]=22,f[33]=20,f[34]=22,f[35]=23}else h=new Float64Array(24),h[0]=o.x,h[1]=o.y,h[2]=o.z,h[3]=a.x,h[4]=o.y,h[5]=o.z,h[6]=a.x,h[7]=a.y,h[8]=o.z,h[9]=o.x,h[10]=a.y,h[11]=o.z,h[12]=o.x,h[13]=o.y,h[14]=a.z,h[15]=a.x,h[16]=o.y,h[17]=a.z,h[18]=a.x,h[19]=a.y,h[20]=a.z,h[21]=o.x,h[22]=a.y,h[23]=a.z,E.position=new s({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:h}),f=new Uint16Array(36),f[0]=4,f[1]=5,f[2]=6,f[3]=4,f[4]=6,f[5]=7,f[6]=1,f[7]=0,f[8]=3,f[9]=1,f[10]=3,f[11]=2,f[12]=1,f[13]=6,f[14]=5,f[15]=1,f[16]=2,f[17]=6,f[18]=2,f[19]=3,f[20]=7,f[21]=2,f[22]=7,f[23]=6,f[24]=3,f[25]=0,f[26]=4,f[27]=3,f[28]=4,f[29]=7,f[30]=0,f[31]=1,f[32]=5,f[33]=0,f[34]=5,f[35]=4;var T=t.subtract(a,o,d),R=.5*t.magnitude(T);return new i({attributes:E,indices:f,primitiveType:c.TRIANGLES,boundingSphere:new e(t.ZERO,R)})}};var y;return f.getUnitBox=function(){return a(y)||(y=f.createGeometry(f.fromDimensions({dimensions:new t(1,1,1),vertexFormat:l.POSITION_ONLY}))),y},f}),define("Core/Color",["./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math"],function(e,t,r,n,o,a){"use strict";function i(e,t,r){return r<0&&(r+=1),r>1&&(r-=1),6*r<1?e+6*(t-e)*r:2*r<1?t:3*r<2?e+(t-e)*(2/3-r)*6:e}function s(e,r,n,o){this.red=t(e,1),this.green=t(r,1),this.blue=t(n,1),this.alpha=t(o,1)}s.fromCartesian4=function(e,t){return r(t)?(t.red=e.x,t.green=e.y,t.blue=e.z,t.alpha=e.w,t):new s(e.x,e.y,e.z,e.w)},s.fromBytes=function(e,n,o,a,i){return e=s.byteToFloat(t(e,255)),n=s.byteToFloat(t(n,255)),o=s.byteToFloat(t(o,255)),a=s.byteToFloat(t(a,255)),r(i)?(i.red=e,i.green=n,i.blue=o,i.alpha=a,i):new s(e,n,o,a)},s.fromAlpha=function(e,t,n){return r(n)?(n.red=e.red,n.green=e.green,n.blue=e.blue,n.alpha=t,n):new s(e.red,e.green,e.blue,t)};var u,c,l;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),c=new Uint32Array(u),l=new Uint8Array(u)),s.fromRgba=function(e,t){return c[0]=e,s.fromBytes(l[0],l[1],l[2],l[3],t)},s.fromHsl=function(e,n,o,a,u){e=t(e,0)%1,n=t(n,0),o=t(o,0),a=t(a,1);var c=o,l=o,f=o;if(0!==n){var d;d=o<.5?o*(1+n):o+n-o*n;var h=2*o-d;c=i(h,d,e+1/3),l=i(h,d,e),f=i(h,d,e-1/3)}return r(u)?(u.red=c,u.green=l,u.blue=f,u.alpha=a,u):new s(c,l,f,a)},s.fromRandom=function(e,n){e=t(e,t.EMPTY_OBJECT);var o=e.red;if(!r(o)){var i=t(e.minimumRed,0),u=t(e.maximumRed,1);o=i+a.nextRandomNumber()*(u-i)}var c=e.green;if(!r(c)){var l=t(e.minimumGreen,0),f=t(e.maximumGreen,1);c=l+a.nextRandomNumber()*(f-l)}var d=e.blue;if(!r(d)){var h=t(e.minimumBlue,0),E=t(e.maximumBlue,1);d=h+a.nextRandomNumber()*(E-h)}var m=e.alpha;if(!r(m)){var p=t(e.minimumAlpha,0),y=t(e.maximumAlpha,1);m=p+a.nextRandomNumber()*(y-p)}return r(n)?(n.red=o,n.green=c,n.blue=d,n.alpha=m,n):new s(o,c,d,m)};var f=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,d=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,h=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,E=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(e,n){r(n)||(n=new s);var o=s[e.toUpperCase()];if(r(o))return s.clone(o,n),n;var a=f.exec(e);return null!==a?(n.red=parseInt(a[1],16)/15,n.green=parseInt(a[2],16)/15,n.blue=parseInt(a[3],16)/15,n.alpha=1,n):null!==(a=d.exec(e))?(n.red=parseInt(a[1],16)/255,n.green=parseInt(a[2],16)/255,n.blue=parseInt(a[3],16)/255,n.alpha=1,n):null!==(a=h.exec(e))?(n.red=parseFloat(a[1])/("%"===a[1].substr(-1)?100:255),n.green=parseFloat(a[2])/("%"===a[2].substr(-1)?100:255),n.blue=parseFloat(a[3])/("%"===a[3].substr(-1)?100:255),n.alpha=parseFloat(t(a[4],"1.0")),n):null!==(a=E.exec(e))?s.fromHsl(parseFloat(a[1])/360,parseFloat(a[2])/100,parseFloat(a[3])/100,parseFloat(t(a[4],"1.0")),n):n=void 0},s.packedLength=4,s.pack=function(e,r,n){return n=t(n,0),r[n++]=e.red,r[n++]=e.green,r[n++]=e.blue,r[n]=e.alpha,r},s.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new s),o.red=e[n++],o.green=e[n++],o.blue=e[n++],o.alpha=e[n],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:256*e|0},s.clone=function(e,t){if(r(e))return r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new s(e.red,e.green,e.blue,e.alpha)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},s.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},s.prototype.toBytes=function(e){var t=s.floatToByte(this.red),n=s.floatToByte(this.green),o=s.floatToByte(this.blue),a=s.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=o,e[3]=a,e):[t,n,o,a]},s.prototype.toRgba=function(){return l[0]=s.floatToByte(this.red),l[1]=s.floatToByte(this.green),l[2]=s.floatToByte(this.blue),l[3]=s.floatToByte(this.alpha),c[0]},s.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},s.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},s.prototype.withAlpha=function(e,t){return s.fromAlpha(this,e,t)},s.add=function(e,t,r){return r.red=e.red+t.red,r.green=e.green+t.green,r.blue=e.blue+t.blue,r.alpha=e.alpha+t.alpha,r},s.subtract=function(e,t,r){return r.red=e.red-t.red,r.green=e.green-t.green,r.blue=e.blue-t.blue,r.alpha=e.alpha-t.alpha,r},s.multiply=function(e,t,r){return r.red=e.red*t.red,r.green=e.green*t.green,r.blue=e.blue*t.blue,r.alpha=e.alpha*t.alpha,r},s.divide=function(e,t,r){return r.red=e.red/t.red,r.green=e.green/t.green,r.blue=e.blue/t.blue,r.alpha=e.alpha/t.alpha,r},s.mod=function(e,t,r){return r.red=e.red%t.red,r.green=e.green%t.green,r.blue=e.blue%t.blue,r.alpha=e.alpha%t.alpha,r},s.multiplyByScalar=function(e,t,r){return r.red=e.red*t,r.green=e.green*t,r.blue=e.blue*t,r.alpha=e.alpha*t,r},s.divideByScalar=function(e,t,r){return r.red=e.red/t,r.green=e.green/t,r.blue=e.blue/t,r.alpha=e.alpha/t,r},s.ALICEBLUE=o(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=o(s.fromCssColorString("#FAEBD7")),s.AQUA=o(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=o(s.fromCssColorString("#7FFFD4")),s.AZURE=o(s.fromCssColorString("#F0FFFF")),s.BEIGE=o(s.fromCssColorString("#F5F5DC")),s.BISQUE=o(s.fromCssColorString("#FFE4C4")),s.BLACK=o(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=o(s.fromCssColorString("#FFEBCD")),s.BLUE=o(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=o(s.fromCssColorString("#8A2BE2")),s.BROWN=o(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=o(s.fromCssColorString("#DEB887")),s.CADETBLUE=o(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=o(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=o(s.fromCssColorString("#D2691E")),s.CORAL=o(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=o(s.fromCssColorString("#6495ED")),s.CORNSILK=o(s.fromCssColorString("#FFF8DC")),s.CRIMSON=o(s.fromCssColorString("#DC143C")),s.CYAN=o(s.fromCssColorString("#00FFFF")),s.DARKBLUE=o(s.fromCssColorString("#00008B")),s.DARKCYAN=o(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=o(s.fromCssColorString("#B8860B")),s.DARKGRAY=o(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=o(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=o(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=o(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=o(s.fromCssColorString("#556B2F")),s.DARKORANGE=o(s.fromCssColorString("#FF8C00")),s.DARKORCHID=o(s.fromCssColorString("#9932CC")),s.DARKRED=o(s.fromCssColorString("#8B0000")),s.DARKSALMON=o(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=o(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=o(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=o(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=o(s.fromCssColorString("#00CED1")),s.DARKVIOLET=o(s.fromCssColorString("#9400D3")),s.DEEPPINK=o(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=o(s.fromCssColorString("#00BFFF")),s.DIMGRAY=o(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=o(s.fromCssColorString("#1E90FF")),s.FIREBRICK=o(s.fromCssColorString("#B22222")),s.FLORALWHITE=o(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=o(s.fromCssColorString("#228B22")),s.FUCHSIA=o(s.fromCssColorString("#FF00FF")),s.GAINSBORO=o(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=o(s.fromCssColorString("#F8F8FF")),s.GOLD=o(s.fromCssColorString("#FFD700")),s.GOLDENROD=o(s.fromCssColorString("#DAA520")),s.GRAY=o(s.fromCssColorString("#808080")),s.GREEN=o(s.fromCssColorString("#008000")),s.GREENYELLOW=o(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=o(s.fromCssColorString("#F0FFF0")),s.HOTPINK=o(s.fromCssColorString("#FF69B4")),s.INDIANRED=o(s.fromCssColorString("#CD5C5C")),s.INDIGO=o(s.fromCssColorString("#4B0082")),s.IVORY=o(s.fromCssColorString("#FFFFF0")),s.KHAKI=o(s.fromCssColorString("#F0E68C")),s.LAVENDER=o(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=o(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=o(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=o(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=o(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=o(s.fromCssColorString("#F08080")),s.LIGHTCYAN=o(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=o(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=o(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=o(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=o(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=o(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=o(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=o(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=o(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=o(s.fromCssColorString("#FFFFE0")),s.LIME=o(s.fromCssColorString("#00FF00")),s.LIMEGREEN=o(s.fromCssColorString("#32CD32")),s.LINEN=o(s.fromCssColorString("#FAF0E6")),s.MAGENTA=o(s.fromCssColorString("#FF00FF")),s.MAROON=o(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=o(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=o(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=o(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=o(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=o(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=o(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=o(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=o(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=o(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=o(s.fromCssColorString("#191970")),s.MINTCREAM=o(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=o(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=o(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=o(s.fromCssColorString("#FFDEAD")),s.NAVY=o(s.fromCssColorString("#000080")),s.OLDLACE=o(s.fromCssColorString("#FDF5E6")),s.OLIVE=o(s.fromCssColorString("#808000")),s.OLIVEDRAB=o(s.fromCssColorString("#6B8E23")),s.ORANGE=o(s.fromCssColorString("#FFA500")),s.ORANGERED=o(s.fromCssColorString("#FF4500")),s.ORCHID=o(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=o(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=o(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=o(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=o(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=o(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=o(s.fromCssColorString("#FFDAB9")),s.PERU=o(s.fromCssColorString("#CD853F")),s.PINK=o(s.fromCssColorString("#FFC0CB")),s.PLUM=o(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=o(s.fromCssColorString("#B0E0E6")),s.PURPLE=o(s.fromCssColorString("#800080")),s.RED=o(s.fromCssColorString("#FF0000")),s.ROSYBROWN=o(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=o(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=o(s.fromCssColorString("#8B4513")),s.SALMON=o(s.fromCssColorString("#FA8072")),s.SANDYBROWN=o(s.fromCssColorString("#F4A460")),s.SEAGREEN=o(s.fromCssColorString("#2E8B57")),s.SEASHELL=o(s.fromCssColorString("#FFF5EE")),s.SIENNA=o(s.fromCssColorString("#A0522D")),s.SILVER=o(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=o(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=o(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=o(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=o(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=o(s.fromCssColorString("#00FF7F")),s.STEELBLUE=o(s.fromCssColorString("#4682B4")),s.TAN=o(s.fromCssColorString("#D2B48C")),s.TEAL=o(s.fromCssColorString("#008080")),s.THISTLE=o(s.fromCssColorString("#D8BFD8")),s.TOMATO=o(s.fromCssColorString("#FF6347")),s.TURQUOISE=o(s.fromCssColorString("#40E0D0")),s.VIOLET=o(s.fromCssColorString("#EE82EE")),s.WHEAT=o(s.fromCssColorString("#F5DEB3")),s.WHITE=o(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=o(s.fromCssColorString("#F5F5F5")),s.YELLOW=o(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=o(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=o(new s(0,0,0,0)),s}),define("Core/CylinderGeometryLibrary",["./Math"],function(e){"use strict";var t={};return t.computePositions=function(t,r,n,o,a){var i,s=.5*t,u=-s,c=o+o,l=a?2*c:c,f=new Float64Array(3*l),d=0,h=0,E=a?3*c:0,m=a?3*(c+o):3*o;for(i=0;i<o;i++){var p=i/o*e.TWO_PI,y=Math.cos(p),_=Math.sin(p),T=y*n,R=_*n,A=y*r,S=_*r;f[h+E]=T,f[h+E+1]=R,f[h+E+2]=u,f[h+m]=A,f[h+m+1]=S,f[h+m+2]=s,h+=3,a&&(f[d++]=T,f[d++]=R,f[d++]=u,f[d++]=A,f[d++]=S,f[d++]=s)}return f},t}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,o){"use strict";var a={UNSIGNED_BYTE:o.UNSIGNED_BYTE,UNSIGNED_SHORT:o.UNSIGNED_SHORT,UNSIGNED_INT:o.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(e,t){return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},a.createTypedArrayFromArrayBuffer=function(e,t,r,o){return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,o):new Uint16Array(t,r,o)},r(a)}),define("Core/CylinderGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CylinderGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,n,o,a,i,s,u,c,l,f,d,h,E){"use strict";function m(e){e=a(e,a.EMPTY_OBJECT);var t=e.length,r=e.topRadius,n=e.bottomRadius,o=a(e.vertexFormat,E.DEFAULT),i=a(e.slices,128);this._length=t,this._topRadius=r,this._bottomRadius=n,this._vertexFormat=E.clone(o),this._slices=i,this._workerName="createCylinderGeometry"}var p=new t,y=new r,_=new r,T=new r,R=new r;m.packedLength=E.packedLength+4,m.pack=function(e,t,r){return r=a(r,0),E.pack(e._vertexFormat,t,r),r+=E.packedLength,t[r++]=e._length,t[r++]=e._topRadius,t[r++]=e._bottomRadius,t[r]=e._slices,t};var A=new E,S={vertexFormat:A,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0};m.unpack=function(e,t,r){t=a(t,0);var n=E.unpack(e,t,A);t+=E.packedLength;var o=e[t++],s=e[t++],u=e[t++],c=e[t];return i(r)?(r._vertexFormat=E.clone(n,r._vertexFormat),r._length=o,r._topRadius=s,r._bottomRadius=u,r._slices=c,r):(S.length=o,S.topRadius=s,S.bottomRadius=u,S.slices=c,new m(S))},m.createGeometry=function(a){var i=a._length,s=a._topRadius,E=a._bottomRadius,m=a._vertexFormat,A=a._slices;if(!(i<=0||s<0||E<0||0===s&&0===E)){var S,C=A+A,I=A+C,g=C+C,O=o.computePositions(i,s,E,A,!0),N=m.st?new Float32Array(2*g):void 0,v=m.normal?new Float32Array(3*g):void 0,w=m.tangent?new Float32Array(3*g):void 0,M=m.bitangent?new Float32Array(3*g):void 0,F=m.normal||m.tangent||m.bitangent;if(F){var x=m.tangent||m.bitangent,D=0,U=0,P=0,L=y;L.z=0;var b=T,B=_;for(S=0;S<A;S++){var z=S/A*d.TWO_PI,G=Math.cos(z),q=Math.sin(z);F&&(L.x=G,L.y=q,x&&(b=r.normalize(r.cross(r.UNIT_Z,L,b),b)),m.normal&&(v[D++]=G,v[D++]=q,v[D++]=0,v[D++]=G,v[D++]=q,v[D++]=0),m.tangent&&(w[U++]=b.x,w[U++]=b.y,w[U++]=b.z,w[U++]=b.x,w[U++]=b.y,w[U++]=b.z),m.bitangent&&(B=r.normalize(r.cross(L,b,B),B),M[P++]=B.x,M[P++]=B.y,M[P++]=B.z,M[P++]=B.x,M[P++]=B.y,M[P++]=B.z))}for(S=0;S<A;S++)m.normal&&(v[D++]=0,v[D++]=0,v[D++]=-1),m.tangent&&(w[U++]=1,w[U++]=0,w[U++]=0),m.bitangent&&(M[P++]=0,M[P++]=-1,M[P++]=0);for(S=0;S<A;S++)m.normal&&(v[D++]=0,v[D++]=0,v[D++]=1),m.tangent&&(w[U++]=1,w[U++]=0,w[U++]=0),m.bitangent&&(M[P++]=0,M[P++]=1,M[P++]=0)}var V=12*A-12,W=f.createTypedArray(g,V),k=0,H=0;for(S=0;S<A-1;S++)W[k++]=H,W[k++]=H+2,W[k++]=H+3,W[k++]=H,W[k++]=H+3,W[k++]=H+1,H+=2;for(W[k++]=C-2,W[k++]=0,W[k++]=1,W[k++]=C-2,W[k++]=1,W[k++]=C-1,S=1;S<A-1;S++)W[k++]=C+S+1,W[k++]=C+S,W[k++]=C;for(S=1;S<A-1;S++)W[k++]=I,W[k++]=I+S,W[k++]=I+S+1;var X=0;if(m.st){var Y=Math.max(s,E);for(S=0;S<g;S++){var j=r.fromArray(O,3*S,R);N[X++]=(j.x+Y)/(2*Y),N[X++]=(j.y+Y)/(2*Y)}}var K=new l;m.position&&(K.position=new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:O})),m.normal&&(K.normal=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:v})),m.tangent&&(K.tangent=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:w})),m.bitangent&&(K.bitangent=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:M})),m.st&&(K.st=new c({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:N})),p.x=.5*i,p.y=Math.max(E,s);var Z=new e(r.ZERO,t.magnitude(p));return new u({attributes:K,indices:W,primitiveType:h.TRIANGLES,boundingSphere:Z})}};var C;return m.getUnitCylinder=function(){return i(C)||(C=m.createGeometry(new m({topRadius:1,bottomRadius:1,length:1,vertexFormat:E.POSITION_ONLY}))),C},m}),define("Core/EllipsoidGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,n,o,a,i,s,u,c,l,f,d,h,E){"use strict";function m(e){e=o(e,o.EMPTY_OBJECT);var t=o(e.radii,A),n=Math.round(o(e.stackPartitions,64)),a=Math.round(o(e.slicePartitions,64)),i=o(e.vertexFormat,E.DEFAULT);this._radii=r.clone(t),this._stackPartitions=n,this._slicePartitions=a,this._vertexFormat=E.clone(i),this._workerName="createEllipsoidGeometry"}var p=new r,y=new r,_=new r,T=new r,R=new r,A=new r(1,1,1),S=Math.cos,C=Math.sin;m.packedLength=r.packedLength+E.packedLength+2,m.pack=function(e,t,n){return n=o(n,0),r.pack(e._radii,t,n),n+=r.packedLength,E.pack(e._vertexFormat,t,n),n+=E.packedLength,t[n++]=e._stackPartitions,t[n]=e._slicePartitions,t};var I=new r,g=new E,O={radii:I,vertexFormat:g,stackPartitions:void 0,slicePartitions:void 0};m.unpack=function(e,t,n){t=o(t,0);var i=r.unpack(e,t,I);t+=r.packedLength;var s=E.unpack(e,t,g);t+=E.packedLength;var u=e[t++],c=e[t];return a(n)?(n._radii=r.clone(i,n._radii),n._vertexFormat=E.clone(s,n._vertexFormat),n._stackPartitions=u,n._slicePartitions=c,n):(O.stackPartitions=u,O.slicePartitions=c,new m(O))},m.createGeometry=function(o){var a=o._radii;if(!(a.x<=0||a.y<=0||a.z<=0)){var i,E,m=s.fromCartesian3(a),A=o._vertexFormat,I=o._slicePartitions+1,g=o._stackPartitions+1,O=g*I,N=new Float64Array(3*O),v=6*(I-1)*(g-2),w=f.createTypedArray(O,v),M=A.normal?new Float32Array(3*O):void 0,F=A.tangent?new Float32Array(3*O):void 0,x=A.bitangent?new Float32Array(3*O):void 0,D=A.st?new Float32Array(2*O):void 0,U=new Array(I),P=new Array(I),L=0;for(i=0;i<I;i++){var b=d.TWO_PI*i/(I-1);U[i]=S(b),P[i]=C(b),N[L++]=0,N[L++]=0,N[L++]=a.z}for(i=1;i<g-1;i++){var B=Math.PI*i/(g-1),z=C(B),G=a.x*z,q=a.y*z,V=a.z*S(B);for(E=0;E<I;E++)N[L++]=U[E]*G,N[L++]=P[E]*q,N[L++]=V}for(i=0;i<I;i++)N[L++]=0,N[L++]=0,N[L++]=-a.z;var W=new l;A.position&&(W.position=new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:N}));var k=0,H=0,X=0,Y=0;if(A.st||A.normal||A.tangent||A.bitangent){for(i=0;i<O;i++){var j=r.fromArray(N,3*i,p),K=m.geodeticSurfaceNormal(j,y);if(A.st){var Z=t.negate(K,R);t.magnitude(Z)<d.EPSILON6&&(L=3*(i+I*Math.floor(.5*g)),L>N.length&&(L=3*(i-I*Math.floor(.5*g))),r.fromArray(N,L,Z),m.geodeticSurfaceNormal(Z,Z),t.negate(Z,Z)),D[k++]=Math.atan2(Z.y,Z.x)/d.TWO_PI+.5,D[k++]=Math.asin(K.z)/Math.PI+.5}if(A.normal&&(M[H++]=K.x,M[H++]=K.y,M[H++]=K.z),A.tangent||A.bitangent){var J=_;if(i<I||i>O-I-1?(r.cross(r.UNIT_X,K,J),r.normalize(J,J)):(r.cross(r.UNIT_Z,K,J),r.normalize(J,J)),A.tangent&&(F[X++]=J.x,F[X++]=J.y,F[X++]=J.z),A.bitangent){var Q=r.cross(K,J,T);r.normalize(Q,Q),x[Y++]=Q.x,x[Y++]=Q.y,x[Y++]=Q.z}}}A.st&&(W.st=new c({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:D})),A.normal&&(W.normal=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:M})),A.tangent&&(W.tangent=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:F})),A.bitangent&&(W.bitangent=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:x}))}for(L=0,E=0;E<I-1;E++)w[L++]=I+E,w[L++]=I+E+1,w[L++]=E+1;var $,ee;for(i=1;i<g-2;i++)for($=i*I,ee=(i+1)*I,E=0;E<I-1;E++)w[L++]=ee+E,w[L++]=ee+E+1,w[L++]=$+E+1,w[L++]=ee+E,w[L++]=$+E+1,w[L++]=$+E;for(i=g-2,$=i*I,ee=(i+1)*I,E=0;E<I-1;E++)w[L++]=ee+E,w[L++]=$+E+1,w[L++]=$+E;return new u({attributes:W,indices:w,primitiveType:h.TRIANGLES,boundingSphere:e.fromEllipsoid(m)})}};var N;return m.getUnitEllipsoid=function(){return a(N)||(N=m.createGeometry(new m({radii:new r(1,1,1),vertexFormat:E.POSITION_ONLY}))),N},m}),define("Scene/Vector3DTileBatch",[],function(){"use strict";function e(e){this.offset=e.offset,this.count=e.count,this.color=e.color,this.batchIds=e.batchIds}return e}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var r,n=t.name,o=t.message;r=e(n)&&e(o)?n+": "+o:t.toString();var a=t.stack;return e(a)&&(r+="\n"+a),r}return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,r){"use strict";function n(n){var o,a=[],i={id:void 0,result:void 0,error:void 0};return function(s){var u=s.data;a.length=0,i.id=u.id,i.error=void 0,i.result=void 0;try{i.result=n(u.parameters,a)}catch(e){e instanceof Error?i.error={name:e.name,message:e.message,stack:e.stack}:i.error=e}t(o)||(o=e(self.webkitPostMessage,self.postMessage)),u.canTransferArrayBuffer||(a.length=0);try{o(i,a)}catch(e){i.result=void 0,i.error="postMessage failed with error: "+r(e)+"\n  with responseMessage: "+JSON.stringify(i),o(i)}}}return n}),define("Workers/createVectorTileGeometries",["../Core/BoundingSphere","../Core/BoxGeometry","../Core/Cartesian3","../Core/Color","../Core/CylinderGeometry","../Core/defined","../Core/EllipsoidGeometry","../Core/IndexDatatype","../Core/Matrix4","../Scene/Vector3DTileBatch","./createTaskProcessorWorker"],function(e,t,r,n,o,a,i,s,u,c,l){"use strict";function f(e,t){var n=t*A,o=r.unpack(e,n,R);n+=r.packedLength;var a=u.unpack(e,n,g.modelMatrix);u.multiplyByScale(a,o,a);var i=g.boundingVolume;return r.clone(r.ZERO,i.center),i.radius=Math.sqrt(3),g}function d(e,t){var n=t*S,o=e[n++],a=e[n++],i=r.fromElements(o,o,a,R),s=u.unpack(e,n,g.modelMatrix);u.multiplyByScale(s,i,s);var c=g.boundingVolume;return r.clone(r.ZERO,c.center),c.radius=Math.sqrt(2),g}function h(e,t){var n=t*C,o=r.unpack(e,n,R);n+=r.packedLength;var a=u.unpack(e,n,g.modelMatrix);u.multiplyByScale(a,o,a);var i=g.boundingVolume;return r.clone(r.ZERO,i.center),i.radius=1,g}function E(e,t){var n=t*I,o=e[n++],a=r.unpack(e,n,R),i=u.fromTranslation(a,g.modelMatrix);u.multiplyByUniformScale(i,o,i);var s=g.boundingVolume;return r.clone(r.ZERO,s.center),s.radius=1,g}function m(t,o,i,s,l){if(a(o)){for(var f=i.length,d=s.attributes.position.values,h=s.indices,E=t.positions,m=t.vertexBatchIds,p=t.indices,y=t.batchIds,_=t.batchTableColors,T=t.batchedIndices,R=t.indexOffsets,A=t.indexCounts,S=t.boundingVolumes,C=t.modelMatrix,I=t.center,g=t.positionOffset,N=t.batchIdIndex,v=t.indexOffset,w=t.batchedIndicesOffset,M=0;M<f;++M){var F=l(o,M),x=F.modelMatrix;u.multiply(C,x,x);for(var D=i[M],U=d.length,P=0;P<U;P+=3){var L=r.unpack(d,P,O);u.multiplyByPoint(x,L,L),r.subtract(L,I,L),r.pack(L,E,3*g+P),m[N++]=D}for(var b=h.length,B=0;B<b;++B)p[v+B]=h[B]+g;var z=M+w;T[z]=new c({offset:v,count:b,color:n.fromRgba(_[D]),batchIds:[D]}),y[z]=D,R[z]=v,A[z]=b,S[z]=e.transform(F.boundingVolume,x),g+=U/3,v+=b}t.positionOffset=g,t.batchIdIndex=N,t.indexOffset=v,t.batchedIndicesOffset+=f}}function p(e){var t=new Float64Array(e),n=0;r.unpack(t,n,N),n+=r.packedLength,u.unpack(t,n,v)}function y(e){for(var t=e.length,r=0,o=0;o<t;++o)r+=n.packedLength+3+e[o].batchIds.length;return r}function _(t,r,o){var a=o.length,i=2+a*e.packedLength+1+y(r),s=new Float64Array(i),u=0;s[u++]=t,s[u++]=a;for(var c=0;c<a;++c)e.pack(o[c],s,u),u+=e.packedLength;var l=r.length;s[u++]=l;for(var f=0;f<l;++f){var d=r[f];n.pack(d.color,s,u),u+=n.packedLength,s[u++]=d.offset,s[u++]=d.count;var h=d.batchIds,E=h.length;s[u++]=E;for(var m=0;m<E;++m)s[u++]=h[m]}return s}function T(e,r){var n=a(e.boxes)?new Float32Array(e.boxes):void 0,u=a(e.boxBatchIds)?new Uint16Array(e.boxBatchIds):void 0,c=a(e.cylinders)?new Float32Array(e.cylinders):void 0,l=a(e.cylinderBatchIds)?new Uint16Array(e.cylinderBatchIds):void 0,y=a(e.ellipsoids)?new Float32Array(e.ellipsoids):void 0,T=a(e.ellipsoidBatchIds)?new Uint16Array(e.ellipsoidBatchIds):void 0,R=a(e.spheres)?new Float32Array(e.spheres):void 0,A=a(e.sphereBatchIds)?new Uint16Array(e.sphereBatchIds):void 0,S=a(n)?u.length:0,C=a(c)?l.length:0,I=a(y)?T.length:0,g=a(R)?A.length:0,O=t.getUnitBox(),w=o.getUnitCylinder(),M=i.getUnitEllipsoid(),F=O.attributes.position.values,x=w.attributes.position.values,D=M.attributes.position.values,U=F.length*S;U+=x.length*C,U+=D.length*(I+g);var P=O.indices,L=w.indices,b=M.indices,B=P.length*S;B+=L.length*C,B+=b.length*(I+g);var z=new Float32Array(U),G=new Uint16Array(U/3),q=s.createTypedArray(U/3,B),V=S+C+I+g,W=new Uint16Array(V),k=new Array(V),H=new Uint32Array(V),X=new Uint32Array(V),Y=new Array(V);p(e.packedBuffer);var j={batchTableColors:new Uint32Array(e.batchTableColors),positions:z,vertexBatchIds:G,indices:q,batchIds:W,batchedIndices:k,indexOffsets:H,indexCounts:X,boundingVolumes:Y,positionOffset:0,batchIdIndex:0,indexOffset:0,batchedIndicesOffset:0,modelMatrix:v,center:N};m(j,n,u,O,f),m(j,c,l,w,d),m(j,y,T,M,h),m(j,R,A,M,E);var K=_(q.BYTES_PER_ELEMENT,k,Y);return r.push(z.buffer,G.buffer,q.buffer),r.push(W.buffer,H.buffer,X.buffer),r.push(K.buffer),{positions:z.buffer,vertexBatchIds:G.buffer,indices:q.buffer,indexOffsets:H.buffer,indexCounts:X.buffer,batchIds:W.buffer,packedBuffer:K.buffer}}var R=new r,A=u.packedLength+r.packedLength,S=u.packedLength+2,C=u.packedLength+r.packedLength,I=r.packedLength+1,g={modelMatrix:new u,boundingVolume:new e},O=new r,N=new r,v=new u;return l(T)})}();