# PowerTip

PowerTip is a jQuery tooltip plugin with some advanced features like **hover intent testing**, **tooltip queueing**, and **support for complex data**.

This software is licensed under the [MIT license][license].

[![Release Version](https://img.shields.io/github/release/stevenbenner/jquery-powertip.svg?style=flat-square)][projectpage] [![NPM Version](https://img.shields.io/npm/v/jquery-powertip.svg?style=flat-square)][npmpage]

[license]: LICENSE.txt

## Getting Started

* Download the latest stable release from the [PowerTip web site][projectpage] or install [jquery-powertip][npmpage] from npm.
* Add the JavaScript and CSS file references to your web site.
* Add a title or data-powertip attribute to the elements you want to show tooltips for.
* Run the `powerTip()` method on those elements.

[npmpage]: https://www.npmjs.com/package/jquery-powertip

## Documentation

You can find the documentation for the **latest release version** on the [PowerTip web site][projectpage]. You will find the documentation for the **latest in-development version** in the [doc folder][docs] in the GitHub repository.

[projectpage]: https://stevenbenner.github.io/jquery-powertip/
[docs]: https://github.com/stevenbenner/jquery-powertip/tree/master/doc

## Reporting Bugs

For bug reports, questions, feature requests, or other suggestions the best way to contact me is to [create an issue][newissue] on GitHub.

[newissue]: https://github.com/stevenbenner/jquery-powertip/issues/new

## Contributor Guide

Make PowerTip better! Join the [league of awesome][contributors] today by submitting a patch! The best way to submit patches is to [fork this project][fork] on GitHub and submit a pull request. But if you are unwilling or unable to use GitHub I will accept patches in any way you can get them to me (JSFiddle, pastebin, text file, whatever).

[contributors]: https://github.com/stevenbenner/jquery-powertip/graphs/contributors
[fork]: https://github.com/stevenbenner/jquery-powertip/fork

### Style Guide

These are general guidelines, not rules. I won't refuse a pull request just because it isn't the style that I use.

* Style guide: In general, follow the [Google JavaScript Style Guide][styleguide].
* Line wrap: Soft-wrap at 80 characters (go further if wrapping makes code less readable).
* Indentation: Use tabs for indentation.
* JSDoc comments: Use [closure compiler annotations][jsdoc].
* Method chaining: Avoid long chained method statements, two or three max.

[styleguide]: https://google.github.io/styleguide/javascriptguide.xml
[jsdoc]: https://github.com/google/closure-compiler/wiki/Annotating-JavaScript-for-the-Closure-Compiler
